/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.registry;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPDataSourceOriginProvider;
import org.jkiss.dbeaver.model.DBPDataSourcePermission;
import org.jkiss.dbeaver.model.app.DBPDataSourceRegistry;
import org.jkiss.dbeaver.model.app.DBPRegistryListener;
import org.jkiss.dbeaver.model.connection.DBPAuthModelDescriptor;
import org.jkiss.dbeaver.model.connection.DBPConnectionType;
import org.jkiss.dbeaver.model.connection.DBPDataSourceProviderDescriptor;
import org.jkiss.dbeaver.model.connection.DBPDataSourceProviderRegistry;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.model.connection.DBPEditorContribution;
import org.jkiss.dbeaver.model.impl.AbstractDescriptor;
import org.jkiss.dbeaver.model.impl.preferences.SimplePreferenceStore;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceListener;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.registry.DataSourceAuthModelDescriptor;
import org.jkiss.dbeaver.registry.DataSourceConfigurationStorageDescriptor;
import org.jkiss.dbeaver.registry.DataSourceHandlerDescriptor;
import org.jkiss.dbeaver.registry.DataSourceOriginProviderDescriptor;
import org.jkiss.dbeaver.registry.DataSourceProviderDescriptor;
import org.jkiss.dbeaver.registry.DataSourceRegistry;
import org.jkiss.dbeaver.registry.EditorContributionDescriptor;
import org.jkiss.dbeaver.registry.ExternalResourceDescriptor;
import org.jkiss.dbeaver.registry.driver.DriverDescriptor;
import org.jkiss.dbeaver.registry.driver.DriverDescriptorSerializerLegacy;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.xml.SAXListener;
import org.jkiss.utils.xml.SAXReader;
import org.jkiss.utils.xml.XMLBuilder;
import org.jkiss.utils.xml.XMLException;
import org.xml.sax.Attributes;

public class DataSourceProviderRegistry
implements DBPDataSourceProviderRegistry {
    private static final Log log = Log.getLog(DataSourceProviderRegistry.class);
    private static DataSourceProviderRegistry instance = null;
    private final List<DataSourceProviderDescriptor> dataSourceProviders = new ArrayList<DataSourceProviderDescriptor>();
    private final List<DBPRegistryListener> registryListeners = new ArrayList<DBPRegistryListener>();
    private final List<DataSourceHandlerDescriptor> dataSourceHandlers = new ArrayList<DataSourceHandlerDescriptor>();
    private final Map<String, DBPConnectionType> connectionTypes = new LinkedHashMap<String, DBPConnectionType>();
    private final Map<String, ExternalResourceDescriptor> resourceContributions = new LinkedHashMap<String, ExternalResourceDescriptor>();
    private final List<EditorContributionDescriptor> editorContributors = new ArrayList<EditorContributionDescriptor>();
    private final Map<String, List<EditorContributionDescriptor>> contributionCategoryMap = new HashMap<String, List<EditorContributionDescriptor>>();
    private final Map<String, DataSourceAuthModelDescriptor> authModels = new LinkedHashMap<String, DataSourceAuthModelDescriptor>();
    private final List<DataSourceConfigurationStorageDescriptor> dataSourceConfigurationStorageDescriptors = new ArrayList<DataSourceConfigurationStorageDescriptor>();
    private final DBPPreferenceStore globalDataSourcePreferenceStore;
    private final Map<String, DataSourceOriginProviderDescriptor> dataSourceOrigins = new LinkedHashMap<String, DataSourceOriginProviderDescriptor>();

    public static synchronized DataSourceProviderRegistry getInstance() {
        if (instance == null) {
            instance = new DataSourceProviderRegistry();
            instance.loadExtensions(Platform.getExtensionRegistry());
        }
        return instance;
    }

    private DataSourceProviderRegistry() {
        this.globalDataSourcePreferenceStore = new SimplePreferenceStore(){

            public void addPropertyChangeListener(DBPPreferenceListener listener) {
                super.addPropertyChangeListener(listener);
            }

            public void removePropertyChangeListener(DBPPreferenceListener listener) {
                super.removePropertyChangeListener(listener);
            }

            public void save() throws IOException {
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    private void loadExtensions(IExtensionRegistry registry) {
        void var6_18;
        void var6_16;
        Object descriptor;
        void var6_14;
        void var6_12;
        IConfigurationElement[] extElements;
        File driversConfig;
        IConfigurationElement ext;
        IConfigurationElement[] extElements2 = registry.getConfigurationElementsFor("org.jkiss.dbeaver.dataSourceProvider");
        Arrays.sort(extElements2, (o1, o2) -> {
            String p2;
            String p1 = o1.getAttribute("parent");
            if (CommonUtils.equalObjects((Object)p1, (Object)(p2 = o2.getAttribute("parent")))) {
                return 0;
            }
            if (p1 == null) {
                return -1;
            }
            if (p2 == null) {
                return 1;
            }
            return 0;
        });
        IConfigurationElement[] object = extElements2;
        int n = extElements2.length;
        int n2 = 0;
        while (n2 < n) {
            ext = object[n2];
            switch (ext.getName()) {
                case "datasource": {
                    AbstractDescriptor provider = new DataSourceProviderDescriptor(this, ext);
                    this.dataSourceProviders.add((DataSourceProviderDescriptor)provider);
                    break;
                }
                case "datasourceOrigin": {
                    AbstractDescriptor provider = new DataSourceOriginProviderDescriptor(ext);
                    this.dataSourceOrigins.put(provider.getId(), (DataSourceOriginProviderDescriptor)provider);
                }
            }
            ++n2;
        }
        IConfigurationElement[] n3 = extElements2;
        n = extElements2.length;
        n2 = 0;
        while (n2 < n) {
            ext = n3[n2];
            switch (ext.getName()) {
                case "datasourcePatch": {
                    String dsId = ext.getAttribute("id");
                    DataSourceProviderDescriptor dataSourceProvider = this.getDataSourceProvider(dsId);
                    if (dataSourceProvider != null) {
                        dataSourceProvider.patchConfigurationFrom(ext);
                        break;
                    }
                    log.warn((Object)("Datasource '" + dsId + "' not found for patch"));
                    break;
                }
                case "editorContribution": {
                    EditorContributionDescriptor descriptor2 = new EditorContributionDescriptor(ext);
                    this.editorContributors.add(descriptor2);
                    List list = this.contributionCategoryMap.computeIfAbsent(descriptor2.getCategory(), k -> new ArrayList());
                    list.add(descriptor2);
                }
            }
            ++n2;
        }
        this.dataSourceProviders.sort((o1, o2) -> {
            if (o1.isDriversManagable() && !o2.isDriversManagable()) {
                return 1;
            }
            if (o2.isDriversManagable() && !o1.isDriversManagable()) {
                return -1;
            }
            return o1.getName().compareToIgnoreCase(o2.getName());
        });
        String providedDriversConfig = System.getProperty("dbeaver.drivers.configuration-file");
        if (!CommonUtils.isEmpty((String)providedDriversConfig)) {
            File configFile = new File(providedDriversConfig);
            if (configFile.exists()) {
                log.debug((Object)("Loading provided drivers configuration from '" + configFile.getAbsolutePath() + "'"));
                this.loadDrivers(configFile, true);
            } else {
                log.debug((Object)("Provided drivers configuration file '" + configFile.getAbsolutePath() + "' doesn't exist"));
            }
        }
        if ((driversConfig = DBWorkbench.getPlatform().getConfigurationFile("drivers.xml")).exists()) {
            log.debug((Object)("Loading user drivers configuration from '" + driversConfig.getAbsolutePath() + "'"));
            this.loadDrivers(driversConfig, false);
        }
        ArrayList<DriverDescriptor> allDrivers = new ArrayList<DriverDescriptor>();
        for (DataSourceProviderDescriptor provider : this.dataSourceProviders) {
            allDrivers.addAll(provider.getDrivers());
        }
        for (DriverDescriptor driver1 : allDrivers) {
            for (DriverDescriptor driver2 : allDrivers) {
                if (driver1 == driver2 || !driver1.replaces(driver2)) continue;
                driver2.setReplacedBy(driver1);
            }
        }
        int driverCount = 0;
        int customDriverCount = 0;
        for (DataSourceProviderDescriptor pd : this.dataSourceProviders) {
            for (DBPDriver dBPDriver : pd.getDrivers()) {
                if (dBPDriver.isDisabled() || dBPDriver.getReplacedBy() != null) continue;
                ++driverCount;
                if (!dBPDriver.isCustom()) continue;
                ++customDriverCount;
            }
        }
        log.debug((Object)("Total database drivers: " + driverCount + " (" + (driverCount - customDriverCount) + ")"));
        DBPConnectionType[] dBPConnectionTypeArray = DBPConnectionType.SYSTEM_TYPES;
        int n4 = DBPConnectionType.SYSTEM_TYPES.length;
        int driver2 = 0;
        while (driver2 < n4) {
            DBPConnectionType ct = dBPConnectionTypeArray[driver2];
            this.connectionTypes.put(ct.getId(), ct);
            ++driver2;
        }
        File ctConfig = DBWorkbench.getPlatform().getConfigurationFile("connection-types.xml");
        if (ctConfig.exists()) {
            this.loadConnectionTypes(ctConfig);
        }
        IConfigurationElement[] iConfigurationElementArray = extElements = registry.getConfigurationElementsFor("org.jkiss.dbeaver.dataSourceHandler");
        int n5 = extElements.length;
        boolean bl = false;
        while (var6_12 < n5) {
            IConfigurationElement ext2 = iConfigurationElementArray[var6_12];
            ExternalResourceDescriptor resource = new ExternalResourceDescriptor(ext2);
            this.resourceContributions.put(resource.getName(), resource);
            if (!CommonUtils.isEmpty((String)resource.getAlias())) {
                String[] stringArray = resource.getAlias().split(",");
                int n6 = stringArray.length;
                int n7 = 0;
                while (n7 < n6) {
                    String alias = stringArray[n7];
                    this.resourceContributions.put(alias, resource);
                    ++n7;
                }
            }
            ++var6_12;
        }
        iConfigurationElementArray = extElements = registry.getConfigurationElementsFor("org.jkiss.dbeaver.dataSourceHandler");
        n5 = extElements.length;
        boolean bl2 = false;
        while (var6_14 < n5) {
            IConfigurationElement ext3 = iConfigurationElementArray[var6_14];
            descriptor = new DataSourceHandlerDescriptor(ext3);
            this.dataSourceHandlers.add((DataSourceHandlerDescriptor)((Object)descriptor));
            ++var6_14;
        }
        iConfigurationElementArray = extElements = registry.getConfigurationElementsFor("org.jkiss.dbeaver.dataSourceAuth");
        n5 = extElements.length;
        boolean bl3 = false;
        while (var6_16 < n5) {
            IConfigurationElement ext4 = iConfigurationElementArray[var6_16];
            descriptor = new DataSourceAuthModelDescriptor(ext4);
            this.authModels.put(descriptor.getId(), (DataSourceAuthModelDescriptor)((Object)descriptor));
            ++var6_16;
        }
        iConfigurationElementArray = extElements = registry.getConfigurationElementsFor("org.jkiss.dbeaver.dataSourceStorage");
        n5 = extElements.length;
        boolean bl4 = false;
        while (var6_18 < n5) {
            IConfigurationElement ext5 = iConfigurationElementArray[var6_18];
            descriptor = new DataSourceConfigurationStorageDescriptor(ext5);
            this.dataSourceConfigurationStorageDescriptors.add((DataSourceConfigurationStorageDescriptor)((Object)descriptor));
            ++var6_18;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        List<DBPRegistryListener> list = this.registryListeners;
        synchronized (list) {
            if (!this.registryListeners.isEmpty()) {
                log.warn((Object)("Some datasource registry listeners are still registered: " + this.registryListeners));
            }
            this.registryListeners.clear();
        }
        for (DataSourceProviderDescriptor providerDescriptor : this.dataSourceProviders) {
            providerDescriptor.dispose();
        }
        this.dataSourceProviders.clear();
        this.resourceContributions.clear();
        this.dataSourceConfigurationStorageDescriptors.clear();
    }

    @Nullable
    public DataSourceProviderDescriptor getDataSourceProvider(String id) {
        for (DataSourceProviderDescriptor provider : this.dataSourceProviders) {
            if (!provider.getId().equals(id)) continue;
            return provider;
        }
        return null;
    }

    public DBPDataSourceProviderDescriptor makeFakeProvider(String providerID) {
        DataSourceProviderDescriptor provider = new DataSourceProviderDescriptor(this, providerID);
        this.dataSourceProviders.add(provider);
        return provider;
    }

    public List<DataSourceProviderDescriptor> getDataSourceProviders() {
        return this.dataSourceProviders;
    }

    public List<DBPDataSourceProviderDescriptor> getEnabledDataSourceProviders() {
        ArrayList<DBPDataSourceProviderDescriptor> enabled = new ArrayList<DBPDataSourceProviderDescriptor>(this.dataSourceProviders);
        return enabled;
    }

    @Nullable
    public DBPDriver findDriver(@NotNull String driverIdOrName) {
        DataSourceProviderDescriptor dsProvider;
        String[] driverPath;
        DBPDriver driver = null;
        if (driverIdOrName.contains(":") && (driverPath = driverIdOrName.split(":")).length == 2 && (dsProvider = this.getDataSourceProvider(driverPath[0])) != null) {
            driver = dsProvider.getDriver(driverPath[1]);
        }
        if (driver == null) {
            for (DataSourceProviderDescriptor pd : this.dataSourceProviders) {
                driver = pd.getDriver(driverIdOrName);
                if (driver != null) break;
            }
        }
        if (driver == null) {
            for (DataSourceProviderDescriptor pd : this.dataSourceProviders) {
                for (DBPDriver dBPDriver : pd.getDrivers()) {
                    if (!dBPDriver.getName().equalsIgnoreCase(driverIdOrName)) continue;
                    driver = dBPDriver;
                }
            }
        }
        if (driver != null) {
            while (driver.getReplacedBy() != null) {
                driver = driver.getReplacedBy();
            }
        }
        return driver;
    }

    public DBPEditorContribution[] getContributedEditors(String category, DBPDataSourceContainer dataSource) {
        List<EditorContributionDescriptor> ec = this.contributionCategoryMap.get(category);
        if (ec == null) {
            return new DBPEditorContribution[0];
        }
        ArrayList<EditorContributionDescriptor> ecCopy = new ArrayList<EditorContributionDescriptor>();
        for (EditorContributionDescriptor editor : ec) {
            if (!editor.supportsDataSource(dataSource)) continue;
            ecCopy.add(editor);
        }
        return ecCopy.toArray(new DBPEditorContribution[0]);
    }

    public DBPPreferenceStore getGlobalDataSourcePreferenceStore() {
        return this.globalDataSourcePreferenceStore;
    }

    private void loadDrivers(File driversConfig, boolean provided) {
        if (driversConfig.exists()) {
            try {
                try {
                    Throwable throwable = null;
                    Object var4_7 = null;
                    try (FileInputStream is = new FileInputStream(driversConfig);){
                        new SAXReader((InputStream)is).parse((SAXListener)new DriverDescriptorSerializerLegacy.DriversParser(provided));
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (XMLException ex) {
                    log.warn((Object)"Drivers config parse error", (Throwable)ex);
                }
            }
            catch (Exception ex) {
                log.warn((Object)("Error loading drivers from " + driversConfig.getPath()), (Throwable)ex);
            }
        }
    }

    public void saveDrivers() {
        File driversConfig = DBWorkbench.getPlatform().getConfigurationFile("drivers.xml");
        try {
            FileOutputStream os = new FileOutputStream(driversConfig);
            XMLBuilder xml = new XMLBuilder((OutputStream)os, GeneralUtils.UTF8_ENCODING);
            xml.setButify(true);
            xml.startElement("drivers");
            for (DataSourceProviderDescriptor provider : this.dataSourceProviders) {
                if (provider.isTemporary()) continue;
                xml.startElement("provider");
                xml.addAttribute("id", provider.getId());
                for (DBPDriver dBPDriver : provider.getDrivers()) {
                    if (!(dBPDriver instanceof DriverDescriptor) || !((DriverDescriptor)dBPDriver).isModified()) continue;
                    ((DriverDescriptor)dBPDriver).serialize(xml, false);
                }
                xml.endElement();
            }
            xml.endElement();
            xml.flush();
            ((OutputStream)os).close();
        }
        catch (Exception ex) {
            log.warn((Object)"Error saving drivers", (Throwable)ex);
        }
    }

    private void loadConnectionTypes(File configFile) {
        try {
            try {
                Throwable throwable = null;
                Object var3_6 = null;
                try (FileInputStream is = new FileInputStream(configFile);){
                    new SAXReader((InputStream)is).parse((SAXListener)new ConnectionTypeParser());
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (XMLException ex) {
                log.warn((Object)("Can't load connection types config from " + configFile.getPath()), (Throwable)ex);
            }
        }
        catch (Exception ex) {
            log.warn((Object)"Error parsing connection types", (Throwable)ex);
        }
    }

    public Collection<DBPConnectionType> getConnectionTypes() {
        return this.connectionTypes.values();
    }

    public DBPConnectionType getConnectionType(String id, DBPConnectionType defaultType) {
        DBPConnectionType connectionType = this.connectionTypes.get(id);
        return connectionType == null ? defaultType : connectionType;
    }

    public void addConnectionType(DBPConnectionType connectionType) {
        if (this.connectionTypes.containsKey(connectionType.getId())) {
            log.warn((Object)("Duplicate connection type id: " + connectionType.getId()));
            return;
        }
        this.connectionTypes.put(connectionType.getId(), connectionType);
    }

    public void removeConnectionType(DBPConnectionType connectionType) {
        if (!this.connectionTypes.containsKey(connectionType.getId())) {
            log.warn((Object)("Connection type doesn't exist: " + connectionType.getId()));
            return;
        }
        this.connectionTypes.remove(connectionType.getId());
    }

    public void saveConnectionTypes() {
        File ctConfig = DBWorkbench.getPlatform().getConfigurationFile("connection-types.xml");
        try {
            FileOutputStream os = new FileOutputStream(ctConfig);
            XMLBuilder xml = new XMLBuilder((OutputStream)os, GeneralUtils.UTF8_ENCODING);
            xml.setButify(true);
            xml.startElement("types");
            for (DBPConnectionType connectionType : this.connectionTypes.values()) {
                xml.startElement("type");
                xml.addAttribute("id", connectionType.getId());
                xml.addAttribute("name", CommonUtils.toString((Object)connectionType.getName()));
                xml.addAttribute("color", connectionType.getColor());
                xml.addAttribute("description", CommonUtils.toString((Object)connectionType.getDescription()));
                xml.addAttribute("autocommit", connectionType.isAutocommit());
                xml.addAttribute("confirmExecute", connectionType.isConfirmExecute());
                xml.addAttribute("confirmDataChange", connectionType.isConfirmDataChange());
                xml.addAttribute("autoCloseTransactions", connectionType.isAutoCloseTransactions());
                List modifyPermission = connectionType.getModifyPermission();
                if (modifyPermission != null) {
                    xml.addAttribute("modifyPermission", modifyPermission.stream().map(Enum::name).collect(Collectors.joining(",")));
                }
                xml.endElement();
            }
            xml.endElement();
            xml.flush();
            ((OutputStream)os).close();
        }
        catch (Exception ex) {
            log.warn((Object)"Error saving drivers", (Throwable)ex);
        }
    }

    public List<DataSourceConfigurationStorageDescriptor> getDataSourceConfigurationStorages() {
        return this.dataSourceConfigurationStorageDescriptors;
    }

    public DBPDataSourceOriginProvider getDataSourceOriginProvider(String id) {
        DataSourceOriginProviderDescriptor descriptor = this.dataSourceOrigins.get(id);
        if (descriptor == null) {
            return null;
        }
        try {
            return descriptor.getProvider();
        }
        catch (Exception e) {
            log.error((Object)e);
            return null;
        }
    }

    public List<DataSourceHandlerDescriptor> getDataSourceHandlers() {
        return this.dataSourceHandlers;
    }

    public DataSourceAuthModelDescriptor getAuthModel(String id) {
        return this.authModels.get(id);
    }

    public List<DataSourceAuthModelDescriptor> getAllAuthModels() {
        return new ArrayList<DataSourceAuthModelDescriptor>(this.authModels.values());
    }

    public List<? extends DBPAuthModelDescriptor> getApplicableAuthModels(DBPDriver driver) {
        ArrayList<DataSourceAuthModelDescriptor> models = new ArrayList<DataSourceAuthModelDescriptor>();
        ArrayList<String> replaced = new ArrayList<String>();
        for (DataSourceAuthModelDescriptor amd : this.authModels.values()) {
            if (!amd.appliesTo(driver)) continue;
            models.add(amd);
            replaced.addAll(amd.getReplaces(driver));
        }
        if (!replaced.isEmpty()) {
            models.removeIf(dataSourceAuthModelDescriptor -> replaced.contains(dataSourceAuthModelDescriptor.getId()));
        }
        return models;
    }

    @Nullable
    public URL findResourceURL(String resourcePath) {
        ExternalResourceDescriptor descriptor = this.resourceContributions.get(resourcePath);
        return descriptor == null ? null : descriptor.getURL();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDataSourceRegistryListener(DBPRegistryListener listener) {
        List<DBPRegistryListener> list = this.registryListeners;
        synchronized (list) {
            this.registryListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDataSourceRegistryListener(DBPRegistryListener listener) {
        List<DBPRegistryListener> list = this.registryListeners;
        synchronized (list) {
            this.registryListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireRegistryChange(DataSourceRegistry registry, boolean load) {
        List<DBPRegistryListener> list = this.registryListeners;
        synchronized (list) {
            for (DBPRegistryListener listener : this.registryListeners) {
                if (load) {
                    listener.handleRegistryLoad((DBPDataSourceRegistry)registry);
                    continue;
                }
                listener.handleRegistryUnload((DBPDataSourceRegistry)registry);
            }
        }
    }

    class ConnectionTypeParser
    implements SAXListener {
        ConnectionTypeParser() {
        }

        public void saxStartElement(SAXReader reader, String namespaceURI, String localName, Attributes atts) throws XMLException {
            if (localName.equals("type")) {
                String typeId = atts.getValue("id");
                DBPConnectionType origType = null;
                DBPConnectionType[] dBPConnectionTypeArray = DBPConnectionType.SYSTEM_TYPES;
                int n = DBPConnectionType.SYSTEM_TYPES.length;
                int n2 = 0;
                while (n2 < n) {
                    DBPConnectionType ct = dBPConnectionTypeArray[n2];
                    if (ct.getId().equals(typeId)) {
                        origType = ct;
                        break;
                    }
                    ++n2;
                }
                DBPConnectionType connectionType = new DBPConnectionType(typeId, atts.getValue("name"), atts.getValue("color"), atts.getValue("description"), CommonUtils.getBoolean((String)atts.getValue("autocommit"), (origType != null && origType.isAutocommit() ? 1 : 0) != 0), CommonUtils.getBoolean((String)atts.getValue("confirmExecute"), (origType != null && origType.isConfirmExecute() ? 1 : 0) != 0), CommonUtils.getBoolean((String)atts.getValue("confirmDataChange"), (origType != null && origType.isConfirmDataChange() ? 1 : 0) != 0), CommonUtils.getBoolean((String)atts.getValue("autoCloseTransactions"), (origType != null && origType.isAutoCloseTransactions() ? 1 : 0) != 0));
                String modifyPermissionList = atts.getValue("modifyPermission");
                if (!CommonUtils.isEmpty((String)modifyPermissionList)) {
                    ArrayList<DBPDataSourcePermission> permList = new ArrayList<DBPDataSourcePermission>();
                    String[] stringArray = modifyPermissionList.split(",");
                    int n3 = stringArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String permItem = stringArray[n4];
                        permList.add((DBPDataSourcePermission)CommonUtils.valueOf(DBPDataSourcePermission.class, (String)permItem, (Enum)DBPDataSourcePermission.PERMISSION_EDIT_DATA));
                        ++n4;
                    }
                    connectionType.setModifyPermissions(permList);
                }
                DataSourceProviderRegistry.this.connectionTypes.put(connectionType.getId(), connectionType);
            }
        }

        public void saxText(SAXReader reader, String data) {
        }

        public void saxEndElement(SAXReader reader, String namespaceURI, String localName) {
        }
    }
}

