/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.net.ssh;

import java.io.File;
import java.io.IOException;
import java.security.Key;
import java.security.PublicKey;
import net.schmizz.sshj.common.KeyType;
import net.schmizz.sshj.common.SecurityUtils;
import net.schmizz.sshj.transport.verification.OpenSSHKnownHosts;
import org.eclipse.osgi.util.NLS;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.net.ssh.SSHJUIMessages;
import org.jkiss.dbeaver.model.net.ssh.SSHUtils;
import org.jkiss.dbeaver.runtime.ui.DBPPlatformUI;

public class KnownHostsVerifier
extends OpenSSHKnownHosts {
    private DBPPlatformUI platformUI;

    public KnownHostsVerifier(@NotNull File khFile, @NotNull DBPPlatformUI platformUI) throws IOException {
        super(khFile);
        this.platformUI = platformUI;
    }

    protected boolean hostKeyUnverifiableAction(String hostname, PublicKey key) {
        KeyType type = KeyType.fromKey((Key)key);
        boolean isConfirmed = this.platformUI.confirmAction(SSHJUIMessages.verify_connection_confirmation_title, NLS.bind((String)SSHJUIMessages.verify_connection_confirmation_message, (Object[])new String[]{hostname, type.toString(), SecurityUtils.getFingerprint((PublicKey)key)}));
        if (!isConfirmed) {
            return false;
        }
        try {
            this.entries().add(new OpenSSHKnownHosts.HostEntry(null, hostname, KeyType.fromKey((Key)key), key));
            this.write();
            this.platformUI.showWarningMessageBox(SSHJUIMessages.warning_title, NLS.bind((String)SSHJUIMessages.known_host_added_warning_message, (Object)hostname, (Object)type));
            return true;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected boolean hostKeyChangedAction(String hostname, PublicKey key) {
        KeyType type = KeyType.fromKey((Key)key);
        String fp = SecurityUtils.getFingerprint((PublicKey)key);
        String path = this.getFile().getAbsolutePath();
        this.platformUI.showWarningMessageBox(SSHJUIMessages.warning_title, NLS.bind((String)SSHJUIMessages.host_key_changed_warning_message, (Object[])new String[]{type.toString(), fp, path}));
        return false;
    }

    public void write(OpenSSHKnownHosts.KnownHostEntry entry) throws IOException {
        this.khFile.getParentFile().mkdirs();
        super.write(entry);
        SSHUtils.forcePlatformReloadKnownHostsPreferences();
    }

    public void write() throws IOException {
        this.khFile.getParentFile().mkdirs();
        super.write();
        SSHUtils.forcePlatformReloadKnownHostsPreferences();
    }
}

