/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.utils;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.utils.CommonUtils;

public class ArrayUtils {
    public static boolean isEmpty(@Nullable Object[] arr) {
        return arr == null || arr.length == 0;
    }

    public static boolean isEmpty(@Nullable short[] array) {
        return array == null || array.length == 0;
    }

    public static boolean isArray(@Nullable Object value) {
        return value != null && value.getClass().isArray();
    }

    public static boolean contains(@Nullable short[] array, short value) {
        if (array == null) {
            return false;
        }
        int i = 0;
        int arrayLength = array.length;
        while (i < arrayLength) {
            if (array[i] == value) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean contains(@Nullable char[] array, char value) {
        if (array == null || array.length == 0) {
            return false;
        }
        int i = 0;
        int arrayLength = array.length;
        while (i < arrayLength) {
            if (array[i] == value) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isEmpty(@Nullable int[] array) {
        return array == null || array.length == 0;
    }

    public static boolean contains(@Nullable int[] array, int value) {
        if (array == null) {
            return false;
        }
        int[] nArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            int v = nArray[n2];
            if (v == value) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean isEmpty(@Nullable long[] array) {
        return array == null || array.length == 0;
    }

    public static boolean contains(@Nullable long[] array, long value) {
        if (array == null) {
            return false;
        }
        long[] lArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            long v = lArray[n2];
            if (v == value) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static <OBJECT_TYPE> boolean contains(OBJECT_TYPE[] array, OBJECT_TYPE value) {
        if (ArrayUtils.isEmpty(array)) {
            return false;
        }
        int i = 0;
        while (i < array.length) {
            if (CommonUtils.equalObjects(value, array[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean containsIgnoreCase(String[] array, String value) {
        if (ArrayUtils.isEmpty(array) || value == null) {
            return false;
        }
        int i = 0;
        while (i < array.length) {
            if (value.equalsIgnoreCase(array[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static <OBJECT_TYPE> boolean containsRef(@NotNull OBJECT_TYPE[] array, @Nullable OBJECT_TYPE value) {
        int length = array.length;
        int i = 0;
        while (i < length) {
            if (value == array[i]) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @SafeVarargs
    public static <OBJECT_TYPE> boolean containsAny(OBJECT_TYPE[] array, OBJECT_TYPE ... values) {
        OBJECT_TYPE[] OBJECT_TYPEArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            OBJECT_TYPE item = OBJECT_TYPEArray[n2];
            OBJECT_TYPE[] OBJECT_TYPEArray2 = values;
            int n3 = values.length;
            int n4 = 0;
            while (n4 < n3) {
                OBJECT_TYPE value = OBJECT_TYPEArray2[n4];
                if (CommonUtils.equalObjects(item, value)) {
                    return true;
                }
                ++n4;
            }
            ++n2;
        }
        return false;
    }

    @SafeVarargs
    public static <OBJECT_TYPE> boolean containsAll(OBJECT_TYPE[] array, OBJECT_TYPE ... values) {
        if (ArrayUtils.isEmpty(array)) {
            return false;
        }
        OBJECT_TYPE[] OBJECT_TYPEArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            OBJECT_TYPE value = OBJECT_TYPEArray[n2];
            if (!ArrayUtils.contains(array, value)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    @NotNull
    public static <T> T[] concatArrays(@NotNull T[] first, @NotNull T[] second) {
        T[] result = Arrays.copyOf(first, first.length + second.length);
        System.arraycopy(second, 0, result, first.length, second.length);
        return result;
    }

    @NotNull
    public static <T> List<T> safeArray(@Nullable T[] array) {
        if (array == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(array);
    }

    public static <T> int indexOf(T[] array, T element) {
        int i = 0;
        while (i < array.length) {
            if (CommonUtils.equalObjects(array[i], element)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static int indexOf(int[] array, int offset, int element) {
        int i = offset;
        while (i < array.length) {
            if (array[i] == element) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static int indexOf(byte[] array, int offset, byte element) {
        int i = offset;
        while (i < array.length) {
            if (array[i] == element) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static <T> T[] deleteArea(Class<T> type, T[] elements, int from, int to) {
        int delCount = to - from + 1;
        Object[] newArray = (Object[])Array.newInstance(type, elements.length - delCount);
        System.arraycopy(elements, 0, newArray, 0, from);
        if (to < elements.length - 1) {
            System.arraycopy(elements, to + 1, newArray, from, elements.length - from - delCount);
        }
        return newArray;
    }

    public static <T> T[] insertArea(Class<T> type, Object[] elements, int pos, Object[] add) {
        Object[] newArray = (Object[])Array.newInstance(type, elements.length + add.length);
        System.arraycopy(elements, 0, newArray, 0, pos);
        System.arraycopy(add, 0, newArray, pos, add.length);
        System.arraycopy(elements, pos, newArray, pos + add.length, elements.length - pos);
        return newArray;
    }

    public static <T> T[] add(Class<T> type, T[] elements, T add) {
        Object[] newArray = (Object[])Array.newInstance(type, elements.length + 1);
        System.arraycopy(elements, 0, newArray, 0, elements.length);
        newArray[elements.length] = add;
        return newArray;
    }

    public static <T> T[] remove(Class<T> type, T[] elements, int index) {
        Object[] newArray = (Object[])Array.newInstance(type, elements.length - 1);
        System.arraycopy(elements, 0, newArray, 0, index);
        if (index < elements.length - 1) {
            System.arraycopy(elements, index + 1, newArray, index, elements.length - index - 1);
        }
        return newArray;
    }

    public static <T> T[] remove(Class<T> type, T[] elements, T element) {
        int i = 0;
        while (i < elements.length) {
            if (elements[i] == element) {
                return ArrayUtils.remove(type, elements, i);
            }
            ++i;
        }
        return elements;
    }

    public static int[] add(int[] elements, int add) {
        int[] newArray = new int[elements.length + 1];
        System.arraycopy(elements, 0, newArray, 0, elements.length);
        newArray[elements.length] = add;
        return newArray;
    }

    public static void main(String[] args) {
        Object[] arr = new String[]{};
        int i = 0;
        while (i < 100) {
            arr = ArrayUtils.add(String.class, arr, String.valueOf(i));
            ++i;
        }
        System.out.println(Arrays.toString(arr));
        i = 0;
        while (i < 100) {
            arr = (String[])ArrayUtils.remove(String.class, arr, false);
            ++i;
        }
        System.out.println(Arrays.toString(arr));
    }

    public static <T> T[] toArray(Class<T> type, Collection<? extends T> list) {
        return list.toArray((Object[])Array.newInstance(type, list.size()));
    }

    public static void reverse(@Nullable Object[] array) {
        if (array == null || array.length <= 1) {
            return;
        }
        int i = 0;
        int j = array.length - 1;
        while (j > i) {
            Object tmp = array[j];
            array[j] = array[i];
            array[i] = tmp;
            ++i;
            --j;
        }
    }
}

