/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.h2.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.generic.model.GenericDataSource;
import org.jkiss.dbeaver.ext.generic.model.GenericFunctionResultType;
import org.jkiss.dbeaver.ext.generic.model.GenericObjectContainer;
import org.jkiss.dbeaver.ext.generic.model.GenericProcedure;
import org.jkiss.dbeaver.ext.generic.model.GenericSequence;
import org.jkiss.dbeaver.ext.generic.model.GenericStructContainer;
import org.jkiss.dbeaver.ext.generic.model.GenericTableBase;
import org.jkiss.dbeaver.ext.generic.model.GenericTableColumn;
import org.jkiss.dbeaver.ext.generic.model.GenericTableConstraintColumn;
import org.jkiss.dbeaver.ext.generic.model.GenericUniqueKey;
import org.jkiss.dbeaver.ext.generic.model.GenericView;
import org.jkiss.dbeaver.ext.generic.model.meta.GenericMetaModel;
import org.jkiss.dbeaver.ext.generic.model.meta.GenericMetaObject;
import org.jkiss.dbeaver.ext.h2.model.H2Constraint;
import org.jkiss.dbeaver.ext.h2.model.H2DataSource;
import org.jkiss.dbeaver.ext.h2.model.H2RoutineAlias;
import org.jkiss.dbeaver.ext.h2.model.H2Sequence;
import org.jkiss.dbeaver.ext.h2.model.H2Table;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.jdbc.struct.JDBCTableConstraint;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraintType;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.rdb.DBSProcedureType;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;

public class H2MetaModel
extends GenericMetaModel {
    public GenericDataSource createDataSourceImpl(DBRProgressMonitor monitor, DBPDataSourceContainer container) throws DBException {
        return new H2DataSource(monitor, container, new H2MetaModel());
    }

    public GenericTableBase createTableImpl(GenericStructContainer container, @Nullable String tableName, @Nullable String tableType, @Nullable JDBCResultSet dbResult) {
        if (tableType != null && this.isView(tableType)) {
            return new GenericView(container, tableName, tableType, dbResult);
        }
        return new H2Table(container, tableName, tableType, dbResult);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getTableDDL(DBRProgressMonitor monitor, GenericTableBase sourceObject, Map<String, Object> options) throws DBException {
        GenericDataSource dataSource = (GenericDataSource)sourceObject.getDataSource();
        if (dataSource.isServerVersionAtLeast(2, 0)) return super.getTableDDL(monitor, sourceObject, options);
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)sourceObject, (String)"Read H2 table source");){
                JDBCResultSet dbResult;
                block24: {
                    Throwable throwable2 = null;
                    Object var9_13 = null;
                    try {
                        String string;
                        JDBCPreparedStatement dbStat = session.prepareStatement("SELECT SQL FROM INFORMATION_SCHEMA.TABLES WHERE TABLE_SCHEMA=? AND TABLE_NAME=?");
                        dbStat.setString(1, ((GenericStructContainer)sourceObject.getContainer()).getName());
                        dbStat.setString(2, sourceObject.getName());
                        Throwable throwable3 = null;
                        Object var12_18 = null;
                        try {
                            block25: {
                                dbResult = dbStat.executeQuery();
                                try {
                                    if (!dbResult.nextRow()) break block24;
                                    string = dbResult.getString(1);
                                    if (dbResult == null) break block25;
                                }
                                catch (Throwable throwable4) {
                                    if (dbResult == null) throw throwable4;
                                    dbResult.close();
                                    throw throwable4;
                                }
                                dbResult.close();
                            }
                            if (dbStat == null) return string;
                        }
                        catch (Throwable throwable5) {
                            if (throwable3 == null) {
                                throwable3 = throwable5;
                                throw throwable3;
                            }
                            if (throwable3 == throwable5) throw throwable3;
                            throwable3.addSuppressed(throwable5);
                            throw throwable3;
                        }
                        dbStat.close();
                        return string;
                    }
                    catch (Throwable throwable6) {
                        if (throwable2 == null) {
                            throwable2 = throwable6;
                            throw throwable2;
                        }
                        if (throwable2 == throwable6) throw throwable2;
                        throwable2.addSuppressed(throwable6);
                        throw throwable2;
                    }
                }
                if (dbResult == null) return super.getTableDDL(monitor, sourceObject, options);
                dbResult.close();
                return super.getTableDDL(monitor, sourceObject, options);
            }
            catch (Throwable throwable7) {
                if (throwable == null) {
                    throwable = throwable7;
                    throw throwable;
                }
                if (throwable == throwable7) throw throwable;
                throwable.addSuppressed(throwable7);
                throw throwable;
            }
        }
        catch (SQLException e) {
            throw new DBException((Throwable)e, (DBPDataSource)dataSource);
        }
    }

    /*
     * Exception decompiling
     */
    public String getViewDDL(DBRProgressMonitor monitor, GenericView sourceObject, Map<String, Object> options) throws DBException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public JDBCStatement prepareUniqueConstraintsLoadStatement(@NotNull JDBCSession session, @NotNull GenericStructContainer owner, @Nullable GenericTableBase forParent) throws SQLException, DBException {
        if (!owner.getDataSource().isServerVersionAtLeast(2, 0)) {
            JDBCPreparedStatement dbStat = session.prepareStatement("SELECT c.*, c.CONSTRAINT_NAME AS PK_NAME FROM INFORMATION_SCHEMA.\"CONSTRAINTS\" c \nWHERE c.CONSTRAINT_SCHEMA = ? " + (forParent != null ? "AND c.TABLE_NAME = ?" : ""));
            dbStat.setString(1, owner.getName());
            if (forParent != null) {
                dbStat.setString(2, forParent.getName());
            }
            return dbStat;
        }
        JDBCPreparedStatement dbStat = session.prepareStatement("SELECT tc.*, tc.CONSTRAINT_NAME AS PK_NAME, ccu.COLUMN_NAME, cc.CHECK_CLAUSE AS CHECK_EXPRESSION FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS tc LEFT JOIN\nINFORMATION_SCHEMA.CONSTRAINT_COLUMN_USAGE ccu ON tc.CONSTRAINT_SCHEMA = ccu.CONSTRAINT_SCHEMA AND tc.CONSTRAINT_NAME = ccu.CONSTRAINT_NAME\nLEFT JOIN INFORMATION_SCHEMA.CHECK_CONSTRAINTS cc ON tc.CONSTRAINT_SCHEMA = cc.CONSTRAINT_SCHEMA AND tc.CONSTRAINT_NAME = cc.CONSTRAINT_NAME\nWHERE tc.CONSTRAINT_SCHEMA = ?" + (forParent != null ? "AND tc.TABLE_NAME = ?" : ""));
        dbStat.setString(1, owner.getName());
        if (forParent != null) {
            dbStat.setString(2, forParent.getName());
        }
        return dbStat;
    }

    public DBSEntityConstraintType getUniqueConstraintType(JDBCResultSet dbResult) throws DBException, SQLException {
        String type = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"CONSTRAINT_TYPE");
        if (CommonUtils.isNotEmpty((String)type)) {
            if ("UNIQUE".equals(type)) {
                return DBSEntityConstraintType.UNIQUE_KEY;
            }
            if ("CHECK".equals(type)) {
                return DBSEntityConstraintType.CHECK;
            }
            return DBSEntityConstraintType.PRIMARY_KEY;
        }
        return super.getUniqueConstraintType(dbResult);
    }

    public GenericUniqueKey createConstraintImpl(GenericTableBase table, String constraintName, DBSEntityConstraintType constraintType, JDBCResultSet dbResult, boolean persisted) {
        if (dbResult != null) {
            String description = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"REMARKS");
            String checkExpression = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"CHECK_EXPRESSION");
            return new H2Constraint(table, constraintName, description, constraintType, persisted, checkExpression);
        }
        return new H2Constraint(table, constraintName, null, constraintType, persisted, null);
    }

    public GenericTableConstraintColumn[] createConstraintColumnsImpl(JDBCSession session, GenericTableBase parent, GenericUniqueKey object, GenericMetaObject pkObject, JDBCResultSet dbResult) throws DBException {
        GenericDataSource dataSource = (GenericDataSource)parent.getDataSource();
        if (!dataSource.isServerVersionAtLeast(2, 0) && dbResult != null) {
            ArrayList<GenericTableConstraintColumn> constraintColumns = new ArrayList<GenericTableConstraintColumn>();
            String columnList = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"COLUMN_LIST");
            List attributes = parent.getAttributes(dbResult.getSession().getProgressMonitor());
            if (CommonUtils.isNotEmpty((String)columnList) && !CommonUtils.isEmpty((Collection)attributes)) {
                if (columnList.contains(",")) {
                    String[] strings;
                    String[] stringArray = strings = columnList.split(",");
                    int n = strings.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String columnName = stringArray[n2];
                        this.findConstraintColumns(object, dataSource, constraintColumns, columnName, attributes);
                        ++n2;
                    }
                } else {
                    this.findConstraintColumns(object, dataSource, constraintColumns, columnList, attributes);
                }
            }
            return (GenericTableConstraintColumn[])ArrayUtils.toArray(GenericTableConstraintColumn.class, constraintColumns);
        }
        return super.createConstraintColumnsImpl(session, parent, object, pkObject, dbResult);
    }

    private void findConstraintColumns(GenericUniqueKey object, GenericDataSource dataSource, List<GenericTableConstraintColumn> constraintColumns, String columnList, List<? extends GenericTableColumn> attributes) {
        Optional<GenericTableColumn> match = attributes.stream().filter(item -> DBUtils.getUnQuotedIdentifier((DBPDataSource)dataSource, (String)item.getName()).equals(columnList)).findFirst();
        if (match.isPresent()) {
            GenericTableColumn tableColumn = match.get();
            constraintColumns.add(new GenericTableConstraintColumn((JDBCTableConstraint)object, tableColumn, tableColumn.getOrdinalPosition()));
        }
    }

    public boolean supportsCheckConstraints() {
        return true;
    }

    public boolean supportsSequences(@NotNull GenericDataSource dataSource) {
        return true;
    }

    public JDBCStatement prepareSequencesLoadStatement(@NotNull JDBCSession session, @NotNull GenericStructContainer container) throws SQLException {
        return session.prepareStatement("SELECT * FROM INFORMATION_SCHEMA.SEQUENCES");
    }

    public GenericSequence createSequenceImpl(@NotNull JDBCSession session, @NotNull GenericStructContainer container, @NotNull JDBCResultSet dbResult) {
        String name = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"SEQUENCE_NAME");
        if (CommonUtils.isEmpty((String)name)) {
            return null;
        }
        String description = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"REMARKS");
        boolean isVersion2 = container.getDataSource().isServerVersionAtLeast(2, 0);
        return new H2Sequence(container, name, description, isVersion2 ? JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"BASE_VALUE") : JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"CURRENT_VALUE"), isVersion2 ? JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"MINIMUM_VALUE") : JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"MIN_VALUE"), isVersion2 ? JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"MAXIMUM_VALUE") : JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"MAX_VALUE"), JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"INCREMENT"), dbResult);
    }

    public String getAutoIncrementClause(GenericTableColumn column) {
        return "AUTO_INCREMENT";
    }

    public boolean isTableCommentEditable() {
        return true;
    }

    public boolean isTableColumnCommentEditable() {
        return true;
    }

    public void loadProcedures(DBRProgressMonitor monitor, @NotNull GenericObjectContainer container) throws DBException {
        boolean new2H2 = container.getDataSource().isServerVersionAtLeast(2, 0);
        String sql = new2H2 ? "SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_SCHEMA = ?" : "SELECT * FROM INFORMATION_SCHEMA.FUNCTION_ALIASES WHERE ALIAS_SCHEMA = ?";
        Throwable throwable = null;
        Object var6_7 = null;
        try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)container, (String)"Load functions aliases");){
            try {
                Throwable throwable2 = null;
                Object var9_13 = null;
                try (JDBCPreparedStatement dbStat = session.prepareStatement(sql);){
                    dbStat.setString(1, container.getName());
                    Throwable throwable3 = null;
                    Object var12_18 = null;
                    try (JDBCResultSet dbResult = dbStat.executeQuery();){
                        while (dbResult.nextRow()) {
                            String aliasName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)(new2H2 ? "ROUTINE_NAME" : "ALIAS_NAME"));
                            if (CommonUtils.isEmpty((String)aliasName)) continue;
                            String description = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"REMARKS");
                            DBSProcedureType type = DBSProcedureType.PROCEDURE;
                            GenericFunctionResultType resultType = null;
                            if (new2H2) {
                                String routineType = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"ROUTINE_TYPE");
                                if ("FUNCTION".equals(routineType)) {
                                    type = DBSProcedureType.FUNCTION;
                                    resultType = GenericFunctionResultType.UNKNOWN;
                                }
                            } else {
                                int procType = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"RETURNS_RESULT");
                                if (procType == 2) {
                                    type = DBSProcedureType.FUNCTION;
                                    resultType = GenericFunctionResultType.UNKNOWN;
                                }
                            }
                            H2RoutineAlias routineAlias = new H2RoutineAlias((GenericStructContainer)container, aliasName, description, type, resultType, dbResult);
                            container.addProcedure((GenericProcedure)routineAlias);
                        }
                    }
                    catch (Throwable throwable4) {
                        if (throwable3 == null) {
                            throwable3 = throwable4;
                        } else if (throwable3 != throwable4) {
                            throwable3.addSuppressed(throwable4);
                        }
                        throw throwable3;
                    }
                }
                catch (Throwable throwable5) {
                    if (throwable2 == null) {
                        throwable2 = throwable5;
                    } else if (throwable2 != throwable5) {
                        throwable2.addSuppressed(throwable5);
                    }
                    throw throwable2;
                }
            }
            catch (SQLException e) {
                throw new DBException((Throwable)e, (DBPDataSource)container.getDataSource());
            }
        }
        catch (Throwable throwable6) {
            if (throwable == null) {
                throwable = throwable6;
            } else if (throwable != throwable6) {
                throwable.addSuppressed(throwable6);
            }
            throw throwable;
        }
    }
}

