/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.erd.ui.action;

import java.io.File;
import java.io.FileWriter;
import org.eclipse.jface.action.Action;
import org.eclipse.swt.widgets.Shell;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.erd.ui.editor.ERDEditorPart;
import org.jkiss.dbeaver.erd.ui.internal.ERDUIMessages;
import org.jkiss.dbeaver.erd.ui.model.DiagramLoader;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.dialogs.DialogUtils;
import org.jkiss.dbeaver.utils.GeneralUtils;

public class DiagramExportAction
extends Action {
    private static final Log log = Log.getLog(DiagramExportAction.class);
    private final ERDEditorPart editor;
    private final Shell shell;

    public DiagramExportAction(ERDEditorPart editor, Shell shell) {
        super(ERDUIMessages.erd_action_diagram_export_text, DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.EXPORT));
        this.setDescription(ERDUIMessages.erd_action_diagram_export_description);
        this.setToolTipText(this.getDescription());
        this.editor = editor;
        this.shell = shell;
    }

    public void run() {
        block12: {
            try {
                File path = DialogUtils.selectFileForSave((Shell)this.shell, (String)ERDUIMessages.erd_action_diagram_export_dialog_save_as_title, (String[])new String[]{"*.erd"}, null);
                if (path != null) {
                    Throwable throwable = null;
                    Object var3_5 = null;
                    try (FileWriter writer = new FileWriter(path, GeneralUtils.UTF8_CHARSET);){
                        writer.write(DiagramLoader.serializeDiagram((DBRProgressMonitor)new VoidProgressMonitor(), this.editor.getDiagramPart(), this.editor.getDiagram(), false, true));
                        break block12;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                log.error((Object)"Invalid path to save the image");
            }
            catch (Exception e) {
                log.error((Object)"Error saving diagram", (Throwable)e);
            }
        }
    }
}

