/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.sqlite.model.data;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.sql.SQLException;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.gis.DBGeometry;
import org.jkiss.dbeaver.model.impl.jdbc.data.handlers.JDBCAbstractValueHandler;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.utils.CommonUtils;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.jts.io.ByteArrayInStream;
import org.locationtech.jts.io.InStream;
import org.locationtech.jts.io.WKBReader;

public class SQLiteGeometryValueHandler
extends JDBCAbstractValueHandler {
    public static final SQLiteGeometryValueHandler INSTANCE = new SQLiteGeometryValueHandler();
    public static final String[] GEOMETRY_TYPES = new String[]{"GEOMETRY", "POINT", "LINESTRING", "POLYGON", "MULTIPOINT", "MULTILINESTRING", "MULTIPOLYGON", "GEOMETRYCOLLECTION"};
    private static final Log log = Log.getLog(SQLiteGeometryValueHandler.class);

    @NotNull
    public Class<?> getValueObjectType(@NotNull DBSTypedObject attribute) {
        return DBGeometry.class;
    }

    @Nullable
    public Object getValueFromObject(@NotNull DBCSession session, @NotNull DBSTypedObject type, @Nullable Object object, boolean copy, boolean validateValue) {
        if (object == null) {
            return new DBGeometry();
        }
        if (object instanceof byte[]) {
            byte[] bytes = (byte[])object;
            ByteBuffer buffer = ByteBuffer.wrap(bytes);
            if (buffer.get() != 71 || buffer.get() != 80) {
                log.debug((Object)"Invalid GeoPackage data");
                return object;
            }
            byte version = buffer.get();
            if (version != 0) {
                log.debug((Object)("Invalid GeoPackage version: " + version));
                return object;
            }
            byte flags = buffer.get();
            if (CommonUtils.isBitSet((int)flags, (int)1)) {
                buffer.order(ByteOrder.LITTLE_ENDIAN);
            }
            int srsId = buffer.getInt();
            switch ((byte)(flags >> 1 & 7)) {
                case 1: {
                    buffer.position(buffer.position() + 32);
                    break;
                }
                case 2: 
                case 3: {
                    buffer.position(buffer.position() + 48);
                    break;
                }
                case 4: {
                    buffer.position(buffer.position() + 64);
                    break;
                }
            }
            byte[] wkb = new byte[bytes.length - buffer.position()];
            System.arraycopy(bytes, buffer.position(), wkb, 0, wkb.length);
            try {
                GeometryFactory geometryFactory = new GeometryFactory(new PrecisionModel(), srsId);
                WKBReader wkbReader = new WKBReader(geometryFactory);
                Geometry geometry = wkbReader.read((InStream)new ByteArrayInStream(wkb));
                return new DBGeometry((Object)geometry, srsId);
            }
            catch (Exception e) {
                log.debug((Object)"Error reading GeoPackage WKB", (Throwable)e);
                return object;
            }
        }
        return object;
    }

    @Nullable
    protected Object fetchColumnValue(DBCSession session, JDBCResultSet resultSet, DBSTypedObject type, int index) throws SQLException {
        Object object = resultSet.getObject(index);
        return this.getValueFromObject(session, type, object, false, false);
    }

    protected void bindParameter(JDBCSession session, JDBCPreparedStatement statement, DBSTypedObject paramType, int paramIndex, Object value) throws SQLException {
        statement.setObject(paramIndex, value);
    }
}

