/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tools.transfer.ui.pages.database;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPDataSourcePermission;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.impl.DBObjectNameCaseTransformer;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.DBSDataContainer;
import org.jkiss.dbeaver.model.struct.DBSDataManipulator;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.dbeaver.model.struct.DBSWrapper;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.runtime.ui.UIServiceSQL;
import org.jkiss.dbeaver.tools.transfer.DataTransferPipe;
import org.jkiss.dbeaver.tools.transfer.DataTransferSettings;
import org.jkiss.dbeaver.tools.transfer.database.DatabaseConsumerSettings;
import org.jkiss.dbeaver.tools.transfer.database.DatabaseMappingAttribute;
import org.jkiss.dbeaver.tools.transfer.database.DatabaseMappingContainer;
import org.jkiss.dbeaver.tools.transfer.database.DatabaseMappingObject;
import org.jkiss.dbeaver.tools.transfer.database.DatabaseMappingType;
import org.jkiss.dbeaver.tools.transfer.database.DatabaseTransferConsumer;
import org.jkiss.dbeaver.tools.transfer.database.DatabaseTransferUtils;
import org.jkiss.dbeaver.tools.transfer.internal.DTMessages;
import org.jkiss.dbeaver.tools.transfer.registry.DataTransferAttributeTransformerDescriptor;
import org.jkiss.dbeaver.tools.transfer.registry.DataTransferRegistry;
import org.jkiss.dbeaver.tools.transfer.ui.internal.DTUIMessages;
import org.jkiss.dbeaver.tools.transfer.ui.pages.database.AttributeTransformerSettingsDialog;
import org.jkiss.dbeaver.tools.transfer.ui.pages.database.ColumnsMappingDialog;
import org.jkiss.dbeaver.tools.transfer.ui.pages.database.PreviewMappingDialog;
import org.jkiss.dbeaver.tools.transfer.ui.wizard.DataTransferWizard;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.DefaultViewerToolTipSupport;
import org.jkiss.dbeaver.ui.SharedTextColors;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.CustomComboBoxCellEditor;
import org.jkiss.dbeaver.ui.controls.ObjectContainerSelectorPanel;
import org.jkiss.dbeaver.ui.controls.TreeContentProvider;
import org.jkiss.dbeaver.ui.dialogs.ActiveWizardPage;
import org.jkiss.dbeaver.ui.dialogs.EnterNameDialog;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;

public class DatabaseConsumerPageMapping
extends ActiveWizardPage<DataTransferWizard> {
    private static final Log log = Log.getLog(DatabaseConsumerPageMapping.class);
    private static final String TARGET_NAME_BROWSE = "[browse]";
    private final List<DatabaseMappingContainer> model = new ArrayList<DatabaseMappingContainer>();
    private TreeViewer mappingViewer;
    private Button autoAssignButton;
    private Button upButton;
    private Button downButton;
    private ObjectContainerSelectorPanel containerPanel;
    private boolean firstInit = true;

    public DatabaseConsumerPageMapping() {
        super(DTUIMessages.database_consumer_page_mapping_name_and_title);
        this.setTitle(DTUIMessages.database_consumer_page_mapping_name_and_title);
        this.setDescription(DTUIMessages.database_consumer_page_mapping_description);
    }

    private DatabaseConsumerSettings getDatabaseConsumerSettings() {
        return ((DataTransferWizard)this.getWizard()).getPageSettings((IWizardPage)this, DatabaseConsumerSettings.class);
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        final DatabaseConsumerSettings settings = this.getDatabaseConsumerSettings();
        Composite composite = UIUtils.createComposite((Composite)parent, (int)1);
        this.containerPanel = new ObjectContainerSelectorPanel(composite, ((DataTransferWizard)this.getWizard()).getProject(), "container.data-transfer.database-consumer", DTMessages.data_transfer_db_consumer_target_container, DTMessages.data_transfer_db_consumer_choose_container){

            @Nullable
            protected DBNNode getSelectedNode() {
                DBNDatabaseNode selectedNode = settings.getContainerNode();
                if (selectedNode == null && !settings.getDataMappings().isEmpty()) {
                    DBSDataContainer firstSource = (DBSDataContainer)settings.getDataMappings().keySet().iterator().next();
                    selectedNode = DBWorkbench.getPlatform().getNavigatorModel().getNodeByObject((DBSObject)firstSource);
                    while (selectedNode != null) {
                        if (selectedNode instanceof DBSWrapper && ((DBSWrapper)selectedNode).getObject() instanceof DBSObjectContainer) break;
                        selectedNode = selectedNode.getParentNode();
                    }
                }
                return selectedNode;
            }

            protected void setSelectedNode(DBNDatabaseNode node) {
                settings.setContainerNode(node);
                this.setContainerInfo(node);
                for (DatabaseMappingContainer mappingContainer : settings.getDataMappings().values()) {
                    try {
                        DatabaseConsumerPageMapping.this.setMappingTarget((DatabaseMappingObject)mappingContainer, mappingContainer.getTargetName(), true);
                    }
                    catch (DBException e1) {
                        log.error((Object)e1);
                    }
                }
                DatabaseConsumerPageMapping.this.mappingViewer.refresh();
                DatabaseConsumerPageMapping.this.updatePageCompletion();
                DatabaseConsumerPageMapping.this.setMessage(null);
            }
        };
        Composite mappingsGroup = UIUtils.createComposite((Composite)composite, (int)2);
        mappingsGroup.setLayoutData((Object)new GridData(1808));
        this.createMappingsTree(mappingsGroup);
        Composite buttonsPanel = UIUtils.createComposite((Composite)mappingsGroup, (int)1);
        buttonsPanel.setLayoutData((Object)new GridData(1040));
        this.autoAssignButton = UIUtils.createDialogButton((Composite)buttonsPanel, (String)DTMessages.data_transfer_db_consumer_auto_assign, (DBPImage)UIIcon.ASTERISK, (String)DTMessages.data_transfer_db_consumer_auto_assign_description, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DatabaseConsumerPageMapping.this.autoAssignMappings();
            }
        });
        UIUtils.createLabelSeparator((Composite)buttonsPanel, (int)256);
        Button mapTableButton = UIUtils.createDialogButton((Composite)buttonsPanel, (String)DTMessages.data_transfer_db_consumer_existing_table, (DBPImage)DBIcon.TREE_TABLE, (String)DTMessages.data_transfer_db_consumer_existing_table_description, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DatabaseConsumerPageMapping.this.mapExistingTable((DatabaseMappingContainer)DatabaseConsumerPageMapping.this.getSelectedMapping());
            }
        });
        mapTableButton.setEnabled(false);
        Button createNewButton = UIUtils.createDialogButton((Composite)buttonsPanel, (String)DTMessages.data_transfer_db_consumer_new_table, (DBPImage)DBIcon.TREE_VIEW, (String)DTMessages.data_transfer_db_consumer_new_table_description, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DatabaseConsumerPageMapping.this.mapNewTable((DatabaseMappingContainer)DatabaseConsumerPageMapping.this.getSelectedMapping());
            }
        });
        createNewButton.setEnabled(false);
        Button columnsButton = UIUtils.createDialogButton((Composite)buttonsPanel, (String)DTMessages.data_transfer_db_consumer_column_mappings, (DBPImage)DBIcon.TREE_COLUMNS, (String)DTMessages.data_transfer_db_consumer_column_mappings_description, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DatabaseMappingObject selectedMapping = DatabaseConsumerPageMapping.this.getSelectedMapping();
                DatabaseConsumerPageMapping.this.mapColumns(selectedMapping instanceof DatabaseMappingContainer ? (DatabaseMappingContainer)selectedMapping : ((DatabaseMappingAttribute)selectedMapping).getParent());
            }
        });
        columnsButton.setEnabled(false);
        UIUtils.createLabelSeparator((Composite)buttonsPanel, (int)256);
        Button ddlButton = UIUtils.createDialogButton((Composite)buttonsPanel, (String)DTMessages.data_transfer_wizard_page_ddl_name, (DBPImage)UIIcon.SQL_TEXT, (String)DTMessages.data_transfer_wizard_page_ddl_description, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DatabaseMappingObject selectedMapping = DatabaseConsumerPageMapping.this.getSelectedMapping();
                DatabaseConsumerPageMapping.this.showDDL(selectedMapping instanceof DatabaseMappingContainer ? (DatabaseMappingContainer)selectedMapping : ((DatabaseMappingAttribute)selectedMapping).getParent());
            }
        });
        ddlButton.setEnabled(false);
        Button previewButton = UIUtils.createDialogButton((Composite)buttonsPanel, (String)DTMessages.data_transfer_wizard_page_preview_name, (DBPImage)UIIcon.SQL_PREVIEW, (String)DTMessages.data_transfer_wizard_page_preview_description, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DBPDataSourceContainer dataSourceContainer = DatabaseConsumerPageMapping.this.getDatabaseConsumerSettings().getContainerNode().getDataSourceContainer();
                if (!dataSourceContainer.hasModifyPermission(DBPDataSourcePermission.PERMISSION_EDIT_METADATA)) {
                    UIUtils.showMessageBox((Shell)DatabaseConsumerPageMapping.this.getShell(), (String)DTMessages.data_transfer_wizard_restricted_title, (String)NLS.bind((String)DTMessages.data_transfer_wizard_restricted_description, (Object)dataSourceContainer.getName()), (int)8);
                    return;
                }
                DatabaseMappingObject selectedMapping = DatabaseConsumerPageMapping.this.getSelectedMapping();
                DatabaseConsumerPageMapping.this.showPreview(selectedMapping instanceof DatabaseMappingContainer ? (DatabaseMappingContainer)selectedMapping : ((DatabaseMappingAttribute)selectedMapping).getParent());
            }
        });
        previewButton.setEnabled(false);
        UIUtils.createLabelSeparator((Composite)buttonsPanel, (int)256);
        this.upButton = UIUtils.createDialogButton((Composite)buttonsPanel, (String)DTMessages.data_transfer_db_consumer_up_label, (DBPImage)UIIcon.ARROW_UP, (String)DTMessages.data_transfer_db_consumer_up_tooltip, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DataTransferPipe pipe = DatabaseConsumerPageMapping.this.getPipeFromCurrentSelection();
                DatabaseMappingContainer mappingContainer = DatabaseConsumerPageMapping.this.getMappingContainerFromCurrentSelection();
                if (pipe == null || mappingContainer == null) {
                    return;
                }
                ((DataTransferWizard)DatabaseConsumerPageMapping.this.getWizard()).getSettings().processPipeEarlier(pipe);
                DatabaseConsumerPageMapping.this.mappingViewer.getTree().setVisible(false);
                CommonUtils.shiftLeft(DatabaseConsumerPageMapping.this.model, (Object)mappingContainer);
                DatabaseConsumerPageMapping.this.mappingViewer.refresh();
                DatabaseConsumerPageMapping.this.mappingViewer.getTree().setVisible(true);
                DatabaseConsumerPageMapping.this.updateUpAndDownButtons(pipe);
            }
        });
        this.upButton.setEnabled(false);
        this.downButton = UIUtils.createDialogButton((Composite)buttonsPanel, (String)DTMessages.data_transfer_db_consumer_down_label, (DBPImage)UIIcon.ARROW_DOWN, (String)DTMessages.data_transfer_db_consumer_down_tooltip, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DataTransferPipe pipe = DatabaseConsumerPageMapping.this.getPipeFromCurrentSelection();
                DatabaseMappingContainer mappingContainer = DatabaseConsumerPageMapping.this.getMappingContainerFromCurrentSelection();
                if (pipe == null || mappingContainer == null) {
                    return;
                }
                ((DataTransferWizard)DatabaseConsumerPageMapping.this.getWizard()).getSettings().processPipeLater(pipe);
                DatabaseConsumerPageMapping.this.mappingViewer.getTree().setVisible(false);
                CommonUtils.shiftRight(DatabaseConsumerPageMapping.this.model, (Object)mappingContainer);
                DatabaseConsumerPageMapping.this.mappingViewer.refresh();
                DatabaseConsumerPageMapping.this.mappingViewer.getTree().setVisible(true);
                DatabaseConsumerPageMapping.this.updateUpAndDownButtons(pipe);
            }
        });
        this.downButton.setEnabled(false);
        this.mappingViewer.getTree().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                try {
                    boolean updated = false;
                    Object element = null;
                    if (e.character != '\r') {
                        TreeItem item;
                        int n;
                        if (e.character == '\u007f') {
                            TreeItem[] treeItemArray = DatabaseConsumerPageMapping.this.mappingViewer.getTree().getSelection();
                            int n2 = treeItemArray.length;
                            n = 0;
                            while (n < n2) {
                                item = treeItemArray[n];
                                element = item.getData();
                                if (element instanceof DatabaseMappingAttribute) {
                                    DatabaseMappingAttribute attribute = (DatabaseMappingAttribute)element;
                                    attribute.setMappingType(DatabaseMappingType.skip);
                                } else if (element instanceof DatabaseMappingContainer) {
                                    DatabaseMappingContainer container = (DatabaseMappingContainer)element;
                                    container.refreshMappingType(((DataTransferWizard)DatabaseConsumerPageMapping.this.getWizard()).getRunnableContext(), DatabaseMappingType.skip, false);
                                }
                                DatabaseConsumerPageMapping.this.selectNextColumn(item);
                                ++n;
                            }
                            updated = true;
                        } else if (e.character == ' ') {
                            TreeItem[] treeItemArray = DatabaseConsumerPageMapping.this.mappingViewer.getTree().getSelection();
                            int n3 = treeItemArray.length;
                            n = 0;
                            while (n < n3) {
                                item = treeItemArray[n];
                                element = item.getData();
                                if (element instanceof DatabaseMappingAttribute) {
                                    DatabaseMappingAttribute attribute = (DatabaseMappingAttribute)item.getData();
                                    attribute.setMappingType(DatabaseMappingType.existing);
                                    attribute.updateMappingType((DBRProgressMonitor)new VoidProgressMonitor(), false);
                                } else if (element instanceof DatabaseMappingContainer) {
                                    DatabaseMappingContainer container = (DatabaseMappingContainer)element;
                                    DatabaseConsumerPageMapping.this.setMappingTarget((DatabaseMappingObject)container, container.getTargetName(), false);
                                }
                                DatabaseConsumerPageMapping.this.selectNextColumn(item);
                                ++n;
                            }
                            updated = true;
                        }
                    }
                    if (updated) {
                        List model;
                        int curIndex;
                        DatabaseConsumerPageMapping.this.updateMappingsAndButtons();
                        DatabaseConsumerPageMapping.this.updatePageCompletion();
                        if (element instanceof DatabaseMappingContainer && (curIndex = (model = (List)DatabaseConsumerPageMapping.this.mappingViewer.getInput()).indexOf(element)) < model.size() - 1) {
                            DatabaseConsumerPageMapping.this.mappingViewer.setSelection((ISelection)new StructuredSelection(model.get(curIndex + 1)), true);
                        }
                    }
                }
                catch (DBException e1) {
                    DBWorkbench.getPlatformUI().showError(DTUIMessages.database_consumer_page_mapping_title_error_mapping_table, DTUIMessages.database_consumer_page_mapping_message_error_mapping_target_table, (Throwable)e1);
                }
            }
        });
        this.mappingViewer.addSelectionChangedListener(event -> {
            DatabaseMappingObject mapping = this.getSelectedMapping();
            mapTableButton.setEnabled(mapping instanceof DatabaseMappingContainer);
            createNewButton.setEnabled(mapping instanceof DatabaseMappingContainer && settings.getContainerNode() != null);
            boolean hasMappings = settings.getContainerNode() != null && (mapping instanceof DatabaseMappingContainer && mapping.getMappingType() != DatabaseMappingType.unspecified || mapping instanceof DatabaseMappingAttribute && ((DatabaseMappingAttribute)mapping).getParent().getMappingType() != DatabaseMappingType.unspecified);
            columnsButton.setEnabled(hasMappings);
            ddlButton.setEnabled(hasMappings);
            previewButton.setEnabled(hasMappings);
            this.updateUpAndDownButtons();
        });
        this.mappingViewer.addDoubleClickListener(event -> {
            DatabaseMappingObject selectedMapping = this.getSelectedMapping();
            if (selectedMapping != null) {
                boolean cfr_ignored_0 = selectedMapping instanceof DatabaseMappingContainer;
            }
        });
        Composite hintPanel = new Composite(composite, 0);
        hintPanel.setLayout((Layout)new GridLayout(3, false));
        hintPanel.setLayoutData((Object)new GridData(32));
        new Label(hintPanel, 0).setText(DTUIMessages.database_consumer_page_mapping_label_hint);
        this.setControl((Control)composite);
    }

    private void updateUpAndDownButtons() {
        DataTransferPipe pipe = this.getPipeFromCurrentSelection();
        if (pipe != null) {
            this.updateUpAndDownButtons(pipe);
            return;
        }
        this.upButton.setEnabled(false);
        this.downButton.setEnabled(false);
    }

    private void updateUpAndDownButtons(@NotNull DataTransferPipe pipeFromCurrentSelection) {
        List pipes = ((DataTransferWizard)this.getWizard()).getSettings().getDataPipes();
        int idx = pipes.indexOf(pipeFromCurrentSelection);
        this.upButton.setEnabled(idx > 0);
        this.downButton.setEnabled(idx > -1 && idx < pipes.size() - 1);
    }

    private void selectNextColumn(TreeItem item) {
        Object[] childItems;
        int index;
        TreeItem parentItem = item.getParentItem();
        if (parentItem != null && (index = ArrayUtils.indexOf((Object[])(childItems = parentItem.getItems()), (Object)item)) >= 0 && index < childItems.length - 1) {
            this.mappingViewer.setSelection((ISelection)new StructuredSelection(childItems[index + 1].getData()));
        }
    }

    private void createMappingsTree(Composite composite) {
        this.mappingViewer = new TreeViewer(composite, 67586);
        this.mappingViewer.getTree().setLayoutData((Object)new GridData(1808));
        this.mappingViewer.getTree().setLinesVisible(true);
        this.mappingViewer.getTree().setHeaderVisible(true);
        UIUtils.setControlContextMenu((Control)this.mappingViewer.getTree(), manager -> {
            DatabaseMappingAttribute mapping;
            Object element;
            IStructuredSelection selection = (IStructuredSelection)this.mappingViewer.getSelection();
            if (!selection.isEmpty() && (element = selection.getFirstElement()) instanceof DatabaseMappingAttribute && (mapping = (DatabaseMappingAttribute)element).getTransformer() != null && !mapping.getTransformer().getProperties().isEmpty()) {
                manager.add((IAction)new Action("Transformer settings ..."){

                    public void run() {
                        AttributeTransformerSettingsDialog settingsDialog = new AttributeTransformerSettingsDialog(DatabaseConsumerPageMapping.this.getShell(), (DatabaseMappingAttribute)element, mapping.getTransformer());
                        if (settingsDialog.open() != 0) {
                            return;
                        }
                    }
                });
            }
            UIUtils.fillDefaultTreeContextMenu((IContributionManager)manager, (Tree)this.mappingViewer.getTree());
        });
        TreeViewerColumn columnSource = new TreeViewerColumn(this.mappingViewer, 16384);
        columnSource.setLabelProvider((CellLabelProvider)new MappingLabelProvider(){

            @Override
            public void update(ViewerCell cell) {
                DatabaseMappingObject mapping = (DatabaseMappingObject)cell.getElement();
                cell.setText(DBUtils.getObjectFullName((DBPNamedObject)mapping.getSource(), (DBPEvaluationContext)DBPEvaluationContext.UI));
                if (mapping.getIcon() != null) {
                    cell.setImage(DBeaverIcons.getImage((DBPImage)mapping.getIcon()));
                }
                super.update(cell);
            }
        });
        columnSource.getColumn().setText(DTUIMessages.database_consumer_page_mapping_column_source_text);
        TreeViewerColumn columnTarget = new TreeViewerColumn(this.mappingViewer, 16384);
        columnTarget.setLabelProvider((CellLabelProvider)new MappingLabelProvider(){

            @Override
            public void update(ViewerCell cell) {
                DatabaseMappingObject mapping = (DatabaseMappingObject)cell.getElement();
                cell.setText(mapping.getTargetName());
                if (mapping.getMappingType() == DatabaseMappingType.unspecified) {
                    cell.setBackground(UIUtils.getSharedTextColors().getColor(SharedTextColors.COLOR_WARNING));
                } else {
                    cell.setBackground(null);
                }
                super.update(cell);
            }
        });
        columnTarget.getColumn().setText(DTUIMessages.database_consumer_page_mapping_column_target_text);
        columnTarget.setEditingSupport(new EditingSupport((ColumnViewer)this.mappingViewer){

            protected CellEditor getCellEditor(Object element) {
                try {
                    return DatabaseConsumerPageMapping.this.createTargetEditor(element);
                }
                catch (DBException e) {
                    DatabaseConsumerPageMapping.this.setErrorMessage(e.getMessage());
                    return null;
                }
            }

            protected boolean canEdit(Object element) {
                return true;
            }

            protected Object getValue(Object element) {
                DatabaseMappingObject mapping = (DatabaseMappingObject)element;
                if (mapping.getMappingType() == DatabaseMappingType.unspecified) {
                    String targetName = mapping.getTargetName();
                    if (!CommonUtils.isEmpty((String)targetName)) {
                        return targetName;
                    }
                    String newName = DatabaseConsumerPageMapping.this.transformTargetName(DBUtils.getQuotedIdentifier((DBPNamedObject)mapping.getSource()));
                    return newName;
                }
                if (mapping instanceof DatabaseMappingContainer) {
                    if (mapping.getMappingType() == DatabaseMappingType.existing) {
                        return ((DatabaseMappingContainer)mapping).getTarget();
                    }
                    return mapping.getTargetName();
                }
                if (mapping.getMappingType() == DatabaseMappingType.existing) {
                    return ((DatabaseMappingAttribute)mapping).getTarget();
                }
                return mapping.getTargetName();
            }

            protected void setValue(Object element, Object value) {
                try {
                    DatabaseConsumerSettings settings = DatabaseConsumerPageMapping.this.getDatabaseConsumerSettings();
                    String name = CommonUtils.toString((Object)value);
                    DBPDataSource dataSource = settings.getTargetDataSource((DatabaseMappingObject)element);
                    if (!name.equals("[skip]") && !name.equals(DatabaseConsumerPageMapping.TARGET_NAME_BROWSE) && dataSource != null) {
                        name = DBUtils.getQuotedIdentifier((DBPDataSource)dataSource, (String)name);
                        name = DBObjectNameCaseTransformer.transformName((DBPDataSource)dataSource, (String)name);
                    }
                    DatabaseConsumerPageMapping.this.setMappingTarget((DatabaseMappingObject)element, name, false);
                    DatabaseConsumerPageMapping.this.mappingViewer.update(element, null);
                    DatabaseConsumerPageMapping.this.mappingViewer.setSelection(DatabaseConsumerPageMapping.this.mappingViewer.getSelection());
                    DatabaseConsumerPageMapping.this.updatePageCompletion();
                }
                catch (DBException e) {
                    DBWorkbench.getPlatformUI().showError(DTUIMessages.database_consumer_page_mapping_title_mapping_error, DTUIMessages.database_consumer_page_mapping_message_error_setting_target_table, (Throwable)e);
                }
            }
        });
        TreeViewerColumn columnMapping = new TreeViewerColumn(this.mappingViewer, 16384);
        columnMapping.setLabelProvider((CellLabelProvider)new MappingLabelProvider(){

            @Override
            public void update(ViewerCell cell) {
                DatabaseMappingObject mapping = (DatabaseMappingObject)cell.getElement();
                cell.setText(mapping.getMappingType().name());
                super.update(cell);
            }
        });
        columnMapping.getColumn().setText(DTUIMessages.database_consumer_page_mapping_column_mapping_text);
        columnMapping.setEditingSupport(new EditingSupport((ColumnViewer)this.mappingViewer){

            protected CellEditor getCellEditor(Object element) {
                DatabaseMappingType parentMapping;
                ArrayList<String> mappingTypes = new ArrayList<String>();
                DatabaseMappingObject mapping = (DatabaseMappingObject)element;
                DatabaseMappingType mappingType = mapping.getMappingType();
                if (mappingType != DatabaseMappingType.skip) {
                    mappingTypes.add(mappingType.name());
                }
                if (mapping instanceof DatabaseMappingAttribute && mappingType != (parentMapping = ((DatabaseMappingAttribute)mapping).getParent().getMappingType()) && parentMapping == DatabaseMappingType.create) {
                    mappingTypes.add(DatabaseMappingType.create.name());
                }
                mappingTypes.add(DatabaseMappingType.skip.name());
                return new CustomComboBoxCellEditor((ColumnViewer)DatabaseConsumerPageMapping.this.mappingViewer, (Composite)DatabaseConsumerPageMapping.this.mappingViewer.getTree(), mappingTypes.toArray(new String[0]), 12);
            }

            protected boolean canEdit(Object element) {
                return true;
            }

            protected Object getValue(Object element) {
                DatabaseMappingObject mapping = (DatabaseMappingObject)element;
                return mapping.getMappingType().name();
            }

            protected void setValue(Object element, Object value) {
                try {
                    DatabaseMappingObject mapping = (DatabaseMappingObject)element;
                    DatabaseMappingType mappingType = DatabaseMappingType.valueOf((String)value.toString());
                    if (mapping instanceof DatabaseMappingAttribute) {
                        ((DatabaseMappingAttribute)mapping).setMappingType(mappingType);
                    } else {
                        ((DatabaseMappingContainer)mapping).refreshMappingType(((DataTransferWizard)DatabaseConsumerPageMapping.this.getWizard()).getRunnableContext(), mappingType, false);
                    }
                    DatabaseConsumerPageMapping.this.mappingViewer.refresh();
                    DatabaseConsumerPageMapping.this.setErrorMessage(null);
                }
                catch (DBException e) {
                    DatabaseConsumerPageMapping.this.setErrorMessage(e.getMessage());
                }
            }
        });
        TreeViewerColumn columnTransformer = new TreeViewerColumn(this.mappingViewer, 16384);
        columnTransformer.setLabelProvider((CellLabelProvider)new MappingLabelProvider(){

            @Override
            public void update(ViewerCell cell) {
                DataTransferAttributeTransformerDescriptor transformer = DatabaseConsumerPageMapping.this.getTransformer(cell.getElement());
                if (transformer != null) {
                    cell.setText(transformer.getName());
                } else {
                    cell.setText("");
                }
                super.update(cell);
            }

            public String getToolTipText(Object element) {
                Map props;
                DataTransferAttributeTransformerDescriptor transformer = DatabaseConsumerPageMapping.this.getTransformer(element);
                if (transformer != null && !CommonUtils.isEmpty((Map)(props = ((DatabaseMappingAttribute)element).getTransformerProperties()))) {
                    return props.entrySet().stream().map(e -> String.valueOf((String)e.getKey()) + "=" + e.getValue()).collect(Collectors.joining(GeneralUtils.getDefaultLineSeparator()));
                }
                return null;
            }
        });
        columnTransformer.getColumn().setText(DTUIMessages.database_consumer_page_mapping_column_transformer_text);
        columnTransformer.getColumn().setToolTipText(DTUIMessages.database_consumer_page_mapping_column_transformer_tip);
        columnTransformer.setEditingSupport(new EditingSupport((ColumnViewer)this.mappingViewer){

            protected CellEditor getCellEditor(Object element) {
                if (element instanceof DatabaseMappingAttribute) {
                    List transformers = DataTransferRegistry.getInstance().getAttributeTransformers();
                    transformers.add(0, null);
                    List<String> tsfNames = transformers.stream().map(t -> t == null ? "" : t.getName()).collect(Collectors.toList());
                    return new CustomComboBoxCellEditor((ColumnViewer)DatabaseConsumerPageMapping.this.mappingViewer, (Composite)DatabaseConsumerPageMapping.this.mappingViewer.getTree(), tsfNames.toArray(new String[0]), 12);
                }
                return null;
            }

            protected boolean canEdit(Object element) {
                return element instanceof DatabaseMappingAttribute && ((DatabaseMappingAttribute)element).getMappingType().isValid();
            }

            protected Object getValue(Object element) {
                DataTransferAttributeTransformerDescriptor transformer = DatabaseConsumerPageMapping.this.getTransformer(element);
                return transformer == null ? "" : transformer.getName();
            }

            protected void setValue(Object element, Object value) {
                String tName = (String)value;
                DataTransferAttributeTransformerDescriptor newTransformer = CommonUtils.isEmpty((String)tName) ? null : DataTransferRegistry.getInstance().getAttributeTransformerByName(tName);
                if (element instanceof DatabaseMappingAttribute) {
                    AttributeTransformerSettingsDialog settingsDialog;
                    if (newTransformer == ((DatabaseMappingAttribute)element).getTransformer()) {
                        return;
                    }
                    if (newTransformer != null && !newTransformer.getProperties().isEmpty() && (settingsDialog = new AttributeTransformerSettingsDialog(DatabaseConsumerPageMapping.this.getShell(), (DatabaseMappingAttribute)element, newTransformer)).open() != 0) {
                        return;
                    }
                    ((DatabaseMappingAttribute)element).setTransformer(newTransformer);
                    DatabaseConsumerPageMapping.this.mappingViewer.refresh();
                }
                DatabaseConsumerPageMapping.this.setErrorMessage(null);
            }
        });
        new DefaultViewerToolTipSupport((ColumnViewer)this.mappingViewer);
        this.mappingViewer.setContentProvider((IContentProvider)new TreeContentProvider(){

            public boolean hasChildren(Object element) {
                return element instanceof DatabaseMappingContainer;
            }

            public Object[] getChildren(Object parentElement) {
                if (parentElement instanceof DatabaseMappingContainer) {
                    return ((DatabaseMappingContainer)parentElement).getAttributeMappings(((DataTransferWizard)DatabaseConsumerPageMapping.this.getWizard()).getRunnableContext()).toArray();
                }
                return null;
            }
        });
        this.mappingViewer.addDoubleClickListener(event -> {
            DatabaseMappingObject selectedMapping = this.getSelectedMapping();
            if (selectedMapping instanceof DatabaseMappingContainer) {
                this.mapColumns((DatabaseMappingContainer)selectedMapping);
            } else if (selectedMapping instanceof DatabaseMappingAttribute) {
                this.mapColumns(((DatabaseMappingAttribute)selectedMapping).getParent());
            }
        });
    }

    private CellEditor createTargetEditor(Object element) throws DBException {
        DatabaseConsumerSettings settings = this.getDatabaseConsumerSettings();
        boolean allowsCreate = true;
        ArrayList<String> items = new ArrayList<String>();
        if (element instanceof DatabaseMappingContainer) {
            if (settings.getContainerNode() == null) {
                allowsCreate = false;
            }
            if (settings.getContainer() != null) {
                DBSObjectContainer container = settings.getContainer();
                for (DBSObject child : container.getChildren((DBRProgressMonitor)new VoidProgressMonitor())) {
                    if (!(child instanceof DBSDataManipulator)) continue;
                    items.add(this.transformTargetName(DBUtils.getQuotedIdentifier((DBSObject)child)));
                }
            }
            items.add(TARGET_NAME_BROWSE);
        } else {
            DatabaseMappingAttribute mapping = (DatabaseMappingAttribute)element;
            switch (mapping.getParent().getMappingType()) {
                case unspecified: 
                case skip: {
                    allowsCreate = false;
                }
            }
            if (mapping.getParent().getTarget() instanceof DBSEntity) {
                DBSEntity parentEntity = (DBSEntity)mapping.getParent().getTarget();
                for (DBSEntityAttribute attr : parentEntity.getAttributes((DBRProgressMonitor)new VoidProgressMonitor())) {
                    items.add(this.transformTargetName(DBUtils.getQuotedIdentifier((DBSObject)attr)));
                }
            }
        }
        items.add("[skip]");
        CustomComboBoxCellEditor editor = new CustomComboBoxCellEditor((ColumnViewer)this.mappingViewer, (Composite)this.mappingViewer.getTree(), items.toArray(new String[0]), 4 | (allowsCreate ? 0 : 8));
        return editor;
    }

    private void setMappingTarget(DatabaseMappingObject mapping, String name, boolean forceRefresh) throws DBException {
        if (name.equals("[skip]")) {
            if (mapping instanceof DatabaseMappingAttribute) {
                ((DatabaseMappingAttribute)mapping).setMappingType(DatabaseMappingType.skip);
            } else {
                ((DatabaseMappingContainer)mapping).refreshMappingType(((DataTransferWizard)this.getWizard()).getRunnableContext(), DatabaseMappingType.skip, false);
            }
        } else if (name.equals(TARGET_NAME_BROWSE)) {
            this.mapExistingTable((DatabaseMappingContainer)mapping);
        } else {
            name = this.transformTargetName(name);
            DatabaseConsumerSettings settings = this.getDatabaseConsumerSettings();
            if (mapping instanceof DatabaseMappingContainer) {
                DatabaseMappingContainer containerMapping = (DatabaseMappingContainer)mapping;
                if (settings.getContainer() != null) {
                    DBSObjectContainer container = settings.getContainer();
                    String unQuotedNameForSearch = DBUtils.getUnQuotedIdentifier((DBPDataSource)container.getDataSource(), (String)name);
                    for (DBSObject child : container.getChildren((DBRProgressMonitor)new VoidProgressMonitor())) {
                        if (!(child instanceof DBSDataManipulator) || !unQuotedNameForSearch.equalsIgnoreCase(child.getName())) continue;
                        containerMapping.setTarget((DBSDataManipulator)child);
                        containerMapping.refreshMappingType(((DataTransferWizard)this.getWizard()).getRunnableContext(), DatabaseMappingType.existing, false);
                        this.mappingViewer.refresh();
                        return;
                    }
                }
                containerMapping.refreshMappingType(((DataTransferWizard)this.getWizard()).getRunnableContext(), DatabaseMappingType.create, forceRefresh);
                ((DatabaseMappingContainer)mapping).setTarget(null);
                ((DatabaseMappingContainer)mapping).setTargetName(name);
            } else {
                DBSEntityAttribute matchingAttribute;
                DBSEntity parentEntity;
                List attributes;
                DatabaseMappingAttribute attrMapping = (DatabaseMappingAttribute)mapping;
                DBPDataSource targetDataSource = settings.getTargetDataSource(mapping);
                if (targetDataSource != null) {
                    name = DBUtils.getUnQuotedIdentifier((DBPDataSource)targetDataSource, (String)name);
                }
                if (attrMapping.getParent().getTarget() instanceof DBSEntity && (attributes = (parentEntity = (DBSEntity)attrMapping.getParent().getTarget()).getAttributes((DBRProgressMonitor)new VoidProgressMonitor())) != null && (matchingAttribute = (DBSEntityAttribute)CommonUtils.findBestCaseAwareMatch((Iterable)attributes, (String)name, DBPNamedObject::getName)) != null) {
                    attrMapping.setMappingType(DatabaseMappingType.existing);
                    attrMapping.setTarget(matchingAttribute);
                    attrMapping.setTargetName(name);
                    return;
                }
                attrMapping.setMappingType(DatabaseMappingType.create);
                attrMapping.setTargetName(name);
            }
            this.updateMappingsAndButtons();
        }
    }

    private void autoAssignMappings() {
        try {
            ((DataTransferWizard)this.getWizard()).getRunnableContext().run(true, true, monitor -> ((DataTransferWizard)this.getWizard()).getSettings().sortDataPipes(monitor));
        }
        catch (InterruptedException | InvocationTargetException exception) {}
        this.loadAndUpdateColumnsModel();
        TreeItem[] treeItemArray = this.mappingViewer.getTree().getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem item = treeItemArray[n2];
            Object element = item.getData();
            if (element instanceof DatabaseMappingContainer) {
                DatabaseMappingContainer container = (DatabaseMappingContainer)element;
                try {
                    this.setMappingTarget((DatabaseMappingObject)container, container.getTargetName(), true);
                }
                catch (DBException e) {
                    DBWorkbench.getPlatformUI().showError(DTUIMessages.database_consumer_page_mapping_title_mapping_error, NLS.bind((String)DTUIMessages.database_consumer_page_mapping_message_error_auto_mapping_source_table, (Object)container.getSource().getName()), (Throwable)e);
                }
            }
            ++n2;
        }
        this.updateMappingsAndButtons();
        this.updatePageCompletion();
    }

    private void updateAutoAssign() {
        boolean hasUnassigned = false;
        DatabaseConsumerSettings settings = this.getDatabaseConsumerSettings();
        for (DatabaseMappingContainer mapping : settings.getDataMappings().values()) {
            if (mapping.getMappingType() == DatabaseMappingType.create || mapping.getMappingType() == DatabaseMappingType.existing) continue;
            hasUnassigned = true;
            break;
        }
        this.autoAssignButton.setEnabled(hasUnassigned);
    }

    private void mapExistingTable(DatabaseMappingContainer mapping) {
        DatabaseConsumerSettings settings = this.getDatabaseConsumerSettings();
        DBPProject activeProject = DBWorkbench.getPlatform().getWorkspace().getActiveProject();
        if (activeProject != null) {
            DBNNode node;
            DBNDatabaseNode rootNode = settings.getContainerNode();
            if (rootNode == null) {
                rootNode = DBWorkbench.getPlatform().getNavigatorModel().getRoot().getProjectNode(activeProject).getDatabases();
            }
            DBNDatabaseNode selectedNode = rootNode;
            if (mapping.getTarget() != null) {
                selectedNode = DBWorkbench.getPlatform().getNavigatorModel().getNodeByObject((DBSObject)mapping.getTarget());
            }
            if ((node = DBWorkbench.getPlatformUI().selectObject((Object)this.getShell(), DTUIMessages.database_consumer_page_mapping_node_title, (DBNNode)rootNode, (DBNNode)selectedNode, new Class[]{DBSObjectContainer.class, DBSDataManipulator.class}, new Class[]{DBSDataManipulator.class}, null)) != null && node instanceof DBSWrapper) {
                DBSObject object = ((DBSWrapper)node).getObject();
                try {
                    if (object instanceof DBSDataManipulator) {
                        mapping.setTarget((DBSDataManipulator)object);
                        mapping.refreshMappingType(((DataTransferWizard)this.getWizard()).getRunnableContext(), DatabaseMappingType.existing, false);
                        this.mapColumns(mapping);
                    } else {
                        mapping.setTarget(null);
                        mapping.refreshMappingType(((DataTransferWizard)this.getWizard()).getRunnableContext(), DatabaseMappingType.unspecified, false);
                    }
                }
                catch (DBException e) {
                    DBWorkbench.getPlatformUI().showError(DTUIMessages.database_consumer_page_mapping_title_error_mapping_table, DTUIMessages.database_consumer_page_mapping_message_error_mapping_existing_table, (Throwable)e);
                }
                this.updateMappingsAndButtons();
                this.updatePageCompletion();
            }
        }
    }

    private void updateMappingsAndButtons() {
        this.mappingViewer.refresh();
        this.mappingViewer.setSelection(this.mappingViewer.getSelection());
    }

    private void mapNewTable(DatabaseMappingContainer mapping) {
        String tableName = EnterNameDialog.chooseName((Shell)this.getShell(), (String)DTUIMessages.database_consumer_page_mapping_table_name, (String)this.transformTargetName(mapping.getMappingType() == DatabaseMappingType.create ? mapping.getTargetName() : ""));
        if (!CommonUtils.isEmpty((String)tableName)) {
            try {
                mapping.setTargetName(tableName);
                mapping.refreshMappingType(((DataTransferWizard)this.getWizard()).getRunnableContext(), DatabaseMappingType.create, false);
                this.updateMappingsAndButtons();
                this.updatePageCompletion();
            }
            catch (DBException e) {
                DBWorkbench.getPlatformUI().showError(DTUIMessages.database_consumer_page_mapping_title_mapping_error, DTUIMessages.database_consumer_page_mapping_message_error_mapping_new_table, (Throwable)e);
            }
        }
    }

    private String transformTargetName(String name) {
        DBSObjectContainer container = this.getDatabaseConsumerSettings().getContainer();
        if (container == null) {
            return name;
        }
        return DBObjectNameCaseTransformer.transformName((DBPDataSource)container.getDataSource(), (String)name);
    }

    private void mapColumns(DatabaseMappingContainer mapping) {
        ColumnsMappingDialog dialog = new ColumnsMappingDialog((DataTransferWizard)this.getWizard(), this.getDatabaseConsumerSettings(), mapping);
        if (dialog.open() == 0) {
            this.mappingViewer.refresh();
            this.updatePageCompletion();
        }
    }

    private void showDDL(DatabaseMappingContainer mapping) {
        DatabaseConsumerSettings settings = this.getDatabaseConsumerSettings();
        DBSObjectContainer container = settings.getContainer();
        if (container == null) {
            return;
        }
        DBPDataSource dataSource = container.getDataSource();
        DBEPersistAction[][] ddl = new DBEPersistAction[1][];
        try {
            ((DataTransferWizard)this.getWizard()).getRunnableContext().run(true, true, monitor -> {
                monitor.beginTask(DTUIMessages.database_consumer_page_mapping_monitor_task, 1);
                try {
                    DBCExecutionContext executionContext = DBUtils.getDefaultContext((DBSObject)dataSource, (boolean)true);
                    dBEPersistActionArray[0] = DatabaseTransferUtils.generateTargetTableDDL((DBRProgressMonitor)monitor, (DBCExecutionContext)executionContext, (DBSObjectContainer)container, (DatabaseMappingContainer)mapping);
                }
                catch (DBException e) {
                    throw new InvocationTargetException(e);
                }
                monitor.done();
            });
        }
        catch (InvocationTargetException e) {
            DBWorkbench.getPlatformUI().showError(DTUIMessages.database_consumer_page_mapping_title_target_DDL, DTUIMessages.database_consumer_page_mapping_message_error_generating_target_DDL, (Throwable)e);
            return;
        }
        catch (InterruptedException interruptedException) {
            return;
        }
        Object[] persistActions = ddl[0];
        if (ArrayUtils.isEmpty((Object[])persistActions)) {
            UIUtils.showMessageBox((Shell)this.getShell(), (String)"No schema changes", (String)"No changes are needed for this mapping", (int)2);
            return;
        }
        UIServiceSQL serviceSQL = (UIServiceSQL)DBWorkbench.getService(UIServiceSQL.class);
        if (serviceSQL != null) {
            String sql = SQLUtils.generateScript((DBPDataSource)dataSource, (DBEPersistAction[])persistActions, (boolean)false);
            int result = serviceSQL.openSQLViewer(DBUtils.getDefaultContext((DBSObject)container, (boolean)true), DTUIMessages.database_consumer_page_mapping_sqlviewer_title, null, sql, dataSource.getContainer().hasModifyPermission(DBPDataSourcePermission.PERMISSION_EDIT_METADATA), false);
            if (result == 10 && UIUtils.confirmAction((Shell)this.getShell(), (String)"Create target objects", (String)"Database metadata will be modified by creating new table(s) and column(s).\nAre you sure you want to proceed?") && this.applySchemaChanges(container, mapping, (DBEPersistAction[])persistActions)) {
                this.autoAssignMappings();
                this.updateMappingsAndButtons();
            }
        }
    }

    private boolean applySchemaChanges(DBSObjectContainer targetContainer, DatabaseMappingContainer mapping, DBEPersistAction[] persistActions) {
        try {
            ((DataTransferWizard)this.getWizard()).getRunnableContext().run(true, true, monitor -> {
                monitor.beginTask("Save schema changes in the database", 1);
                try {
                    try {
                        Throwable throwable = null;
                        Object var6_8 = null;
                        try (DBCSession session = DBUtils.openUtilSession((DBRProgressMonitor)monitor, (DBSObject)targetContainer, (String)"Apply schema changes");){
                            DatabaseTransferUtils.executeDDL((DBCSession)session, (DBEPersistAction[])persistActions);
                            DatabaseConsumerSettings consumerSettings = this.getDatabaseConsumerSettings();
                            if (consumerSettings != null) {
                                DatabaseTransferUtils.refreshDatabaseModel((DBRProgressMonitor)monitor, (DatabaseConsumerSettings)consumerSettings, (DatabaseMappingContainer)mapping);
                            }
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                    }
                    catch (Exception e) {
                        throw new InvocationTargetException(e);
                    }
                }
                finally {
                    monitor.done();
                }
            });
            return true;
        }
        catch (InvocationTargetException e) {
            DBWorkbench.getPlatformUI().showError("Schema changes save", "Error applying schema changes", e.getTargetException());
        }
        catch (InterruptedException interruptedException) {}
        return false;
    }

    private void showPreview(DatabaseMappingContainer mappingContainer) {
        DataTransferPipe pipe = this.getPipe(mappingContainer);
        DataTransferSettings dtSettings = ((DataTransferWizard)this.getWizard()).getSettings();
        PreviewMappingDialog previewDialog = new PreviewMappingDialog(this.getShell(), pipe, mappingContainer, dtSettings);
        previewDialog.open();
    }

    @Nullable
    private DatabaseMappingContainer getMappingContainerFromCurrentSelection() {
        for (Object o : this.mappingViewer.getStructuredSelection()) {
            if (!(o instanceof DatabaseMappingContainer)) continue;
            return (DatabaseMappingContainer)o;
        }
        return null;
    }

    @Nullable
    private DataTransferPipe getPipeFromCurrentSelection() {
        DatabaseMappingContainer mappingContainer = this.getMappingContainerFromCurrentSelection();
        if (mappingContainer == null) {
            return null;
        }
        return this.getPipe(mappingContainer);
    }

    @Nullable
    private DataTransferPipe getPipe(DatabaseMappingContainer mappingContainer) {
        DatabaseConsumerSettings settings = this.getDatabaseConsumerSettings();
        for (DataTransferPipe pipe : ((DataTransferWizard)this.getWizard()).getSettings().getDataPipes()) {
            DBSDataContainer sourceObject;
            DatabaseMappingContainer mapping;
            if (pipe.getProducer() == null || (mapping = settings.getDataMapping(sourceObject = (DBSDataContainer)pipe.getProducer().getDatabaseObject())) != mappingContainer) continue;
            return pipe;
        }
        return null;
    }

    private DatabaseMappingObject getSelectedMapping() {
        IStructuredSelection selection = (IStructuredSelection)this.mappingViewer.getSelection();
        return selection.isEmpty() ? null : (DatabaseMappingObject)selection.getFirstElement();
    }

    public void activatePage() {
        DatabaseConsumerSettings settings = this.getDatabaseConsumerSettings();
        DBSObjectContainer producerContainer = null;
        for (DataTransferPipe pipe : ((DataTransferWizard)this.getWizard()).getSettings().getDataPipes()) {
            DBSObject container;
            DBSObject producerObject;
            if (pipe.getProducer() == null || !((producerObject = pipe.getProducer().getDatabaseObject()) instanceof DBSDataContainer) || !((container = producerObject.getParentObject()) instanceof DBSObjectContainer)) continue;
            producerContainer = (DBSObjectContainer)container;
        }
        settings.loadNode(((DataTransferWizard)this.getWizard()).getRunnableContext(), ((DataTransferWizard)this.getWizard()).getSettings(), producerContainer);
        DBNDatabaseNode containerNode = settings.getContainerNode();
        if (containerNode != null) {
            try {
                this.containerPanel.checkValidContainerNode((DBNNode)containerNode);
                this.containerPanel.setContainerInfo(containerNode);
            }
            catch (DBException e) {
                this.setErrorMessage(e.getMessage());
            }
        }
        this.loadAndUpdateColumnsModel();
        this.updatePageCompletion();
        if (this.firstInit) {
            this.firstInit = false;
            Tree table = this.mappingViewer.getTree();
            int totalWidth = table.getClientArea().width;
            TreeColumn[] columns = table.getColumns();
            columns[0].setWidth(totalWidth * 35 / 100);
            columns[1].setWidth(totalWidth * 35 / 100);
            columns[2].setWidth(totalWidth * 15 / 100);
            columns[3].setWidth(totalWidth * 15 / 100);
            UIUtils.asyncExec(this::autoAssignMappings);
        }
    }

    private void loadAndUpdateColumnsModel() {
        DatabaseConsumerSettings settings = this.getDatabaseConsumerSettings();
        this.model.clear();
        for (DataTransferPipe pipe : ((DataTransferWizard)this.getWizard()).getSettings().getDataPipes()) {
            DatabaseMappingContainer newMapping;
            if (pipe.getProducer() == null || !(pipe.getProducer().getDatabaseObject() instanceof DBSDataContainer)) continue;
            DBSDataContainer sourceDataContainer = (DBSDataContainer)pipe.getProducer().getDatabaseObject();
            DatabaseMappingContainer mapping = settings.getDataMapping(sourceDataContainer);
            if (pipe.getConsumer() instanceof DatabaseTransferConsumer && ((DatabaseTransferConsumer)pipe.getConsumer()).getTargetObject() != null) {
                try {
                    newMapping = new DatabaseMappingContainer(((DataTransferWizard)this.getWizard()).getRunnableContext(), this.getDatabaseConsumerSettings(), sourceDataContainer, ((DatabaseTransferConsumer)pipe.getConsumer()).getTargetObject());
                }
                catch (DBException e) {
                    this.setMessage(e.getMessage(), 3);
                    newMapping = new DatabaseMappingContainer(this.getDatabaseConsumerSettings(), sourceDataContainer);
                }
            } else {
                newMapping = new DatabaseMappingContainer(this.getDatabaseConsumerSettings(), sourceDataContainer);
            }
            newMapping.getAttributeMappings(((DataTransferWizard)this.getWizard()).getRunnableContext());
            if (mapping == null || !mapping.isSameMapping(newMapping)) {
                mapping = newMapping;
                settings.addDataMappings(((DataTransferWizard)this.getWizard()).getRunnableContext(), sourceDataContainer, mapping);
            }
            this.model.add(mapping);
        }
        this.mappingViewer.getTree().setVisible(false);
        Object[] expandedElements = this.mappingViewer.getExpandedElements();
        this.mappingViewer.setInput(this.model);
        this.mappingViewer.setExpandedElements(expandedElements);
        this.mappingViewer.getTree().setVisible(true);
        if (!this.model.isEmpty()) {
            this.mappingViewer.setSelection((ISelection)new StructuredSelection((Object)this.model.get(0)));
        }
    }

    protected boolean determinePageCompletion() {
        DatabaseConsumerSettings settings = this.getDatabaseConsumerSettings();
        if (settings.getContainerNode() == null) {
            this.setErrorMessage(DTUIMessages.database_consumer_page_mapping_error_message_set_target_container);
            return false;
        }
        if (!settings.isCompleted((Collection)((DataTransferWizard)this.getWizard()).getSettings().getDataPipes())) {
            this.setErrorMessage(DTUIMessages.database_consumer_page_mapping_error_message_set_all_tables_mappings);
            return false;
        }
        this.setErrorMessage(null);
        return true;
    }

    protected void updatePageCompletion() {
        super.updatePageCompletion();
        this.updateAutoAssign();
    }

    private DataTransferAttributeTransformerDescriptor getTransformer(Object element) {
        if (element instanceof DatabaseMappingAttribute) {
            return ((DatabaseMappingAttribute)element).getTransformer();
        }
        return null;
    }

    private static abstract class MappingLabelProvider
    extends CellLabelProvider {
        private MappingLabelProvider() {
        }

        public void update(ViewerCell cell) {
        }
    }
}

