# This is the main file used for generating docs for the standard library.
# It, for example, doesn't include API for the compiler, but does include
# the fictitious API for the Crystal::Macros module.

require "./annotations"
require "./big"
require "./compiler/crystal/macros"
require "./compress/**"
require "./crypto/**"
require "./crystal/syntax_highlighter/*"
require "./csv"
require "./digest/**"
require "./ecr"
require "./fiber"
require "./gc/**"
require "./html"
require "./http/**"
require "./io/**"
require "./json"
require "./llvm"
require "./macros"
require "./math/**"
require "./oauth"
require "./oauth2"
require "./openssl"
require "./process"
require "./regex"
require "./socket"
require "./spec/**"
require "./string/**"
require "./weak_ref"
require "./xml"
require "./yaml"
require "./benchmark"
require "./array"
require "./bit_array"
require "./box"
require "./colorize"
require "./complex"
require "./deque"
require "./file_utils"
require "./ini"
require "./levenshtein"
require "./log"
require "./log/spec"
require "./option_parser"
require "./path"
require "./random/**"
require "./semantic_version"
require "./signal"
require "./string_pool"
require "./string_scanner"
require "./unicode/unicode"
require "./uri"
require "./uuid"
require "./uuid/json"
require "./syscall"
{% unless flag?(:win32) %}
  require "./system/*"
{% end %}
require "./docs_pseudo_methods"
