# t30011 - Package diagram with packages from directory structure for plain C
## Config
```yaml
diagrams:
  t30011_package:
    type: package
    package_type: directory
    glob:
      - t30011.c
    include:
      paths:
        - .
```
## Source code
File `tests/t30011/t30011.c`
```cpp
#include "app/app.h"

struct t30011_App app;

```
File `tests/t30011/libraries/lib1/lib1.h`
```cpp
#pragma once

struct t30011_A {
    int a;
};

```
File `tests/t30011/libraries/lib2/lib2.h`
```cpp
#pragma once

struct t30011_B {
    int b;
};

```
File `tests/t30011/libraries/lib3/lib3.h`
```cpp
#pragma once

enum t30011_E { e1, e2, e3 };

```
File `tests/t30011/libraries/lib4/lib4.h`
```cpp
#pragma once

struct t30011_C {
    int c;
};

```
File `tests/t30011/app/app.h`
```cpp
#pragma once

#include "../libraries/lib1/lib1.h"
#include "../libraries/lib2/lib2.h"
#include "../libraries/lib3/lib3.h"
#include "../libraries/lib4/lib4.h"

struct t30011_App {
    struct t30011_A a;
    struct t30011_B *b;
    enum t30011_E e;
};

void c(struct t30011_App *app, struct t30011_C *c) { }

```
## Generated PlantUML diagrams
![t30011_package](./t30011_package.svg "Package diagram with packages from directory structure for plain C")
## Generated Mermaid diagrams
![t30011_package](./t30011_package_mermaid.svg "Package diagram with packages from directory structure for plain C")
## Generated JSON models
```json
{
  "diagram_type": "package",
  "elements": [
    {
      "display_name": "libraries",
      "elements": [
        {
          "display_name": "lib1",
          "id": "7033698116283031691",
          "is_deprecated": false,
          "name": "lib1",
          "path": "libraries",
          "source_location": {
            "column": 8,
            "file": "libraries/lib1/lib1.h",
            "line": 3,
            "translation_unit": "t30011.c"
          },
          "type": "directory"
        },
        {
          "display_name": "lib2",
          "id": "12180849757009627397",
          "is_deprecated": false,
          "name": "lib2",
          "path": "libraries",
          "source_location": {
            "column": 8,
            "file": "libraries/lib2/lib2.h",
            "line": 3,
            "translation_unit": "t30011.c"
          },
          "type": "directory"
        },
        {
          "display_name": "lib3",
          "id": "18109676637220650603",
          "is_deprecated": false,
          "name": "lib3",
          "path": "libraries",
          "source_location": {
            "column": 6,
            "file": "libraries/lib3/lib3.h",
            "line": 3,
            "translation_unit": "t30011.c"
          },
          "type": "directory"
        },
        {
          "display_name": "lib4",
          "id": "8827624240187281752",
          "is_deprecated": false,
          "name": "lib4",
          "path": "libraries",
          "source_location": {
            "column": 8,
            "file": "libraries/lib4/lib4.h",
            "line": 3,
            "translation_unit": "t30011.c"
          },
          "type": "directory"
        }
      ],
      "id": "7035209531004006049",
      "is_deprecated": false,
      "name": "libraries",
      "path": "",
      "type": "directory"
    },
    {
      "display_name": "app",
      "id": "16010562093136641194",
      "is_deprecated": false,
      "name": "app",
      "path": "",
      "source_location": {
        "column": 8,
        "file": "app/app.h",
        "line": 8,
        "translation_unit": "t30011.c"
      },
      "type": "directory"
    }
  ],
  "name": "t30011_package",
  "package_type": "directory",
  "relationships": [
    {
      "destination": "7033698116283031691",
      "source": "16010562093136641194",
      "type": "dependency"
    },
    {
      "destination": "12180849757009627397",
      "source": "16010562093136641194",
      "type": "dependency"
    },
    {
      "destination": "18109676637220650603",
      "source": "16010562093136641194",
      "type": "dependency"
    },
    {
      "destination": "8827624240187281752",
      "source": "16010562093136641194",
      "type": "dependency"
    }
  ]
}
```
## Generated GraphML models
```xml
<?xml version="1.0"?>
<graphml xmlns="http://graphml.graphdrawing.org/xmlns" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="http://graphml.graphdrawing.org/xmlns http://graphml.graphdrawing.org/xmlns/1.0/graphml.xsd">
 <key attr.name="id" attr.type="string" for="graph" id="gd0" />
 <key attr.name="diagram_type" attr.type="string" for="graph" id="gd1" />
 <key attr.name="name" attr.type="string" for="graph" id="gd2" />
 <key attr.name="using_namespace" attr.type="string" for="graph" id="gd3" />
 <key attr.name="id" attr.type="string" for="node" id="nd0" />
 <key attr.name="type" attr.type="string" for="node" id="nd1" />
 <key attr.name="name" attr.type="string" for="node" id="nd2" />
 <key attr.name="stereotype" attr.type="string" for="node" id="nd3" />
 <key attr.name="url" attr.type="string" for="node" id="nd4" />
 <key attr.name="tooltip" attr.type="string" for="node" id="nd5" />
 <key attr.name="type" attr.type="string" for="edge" id="ed0" />
 <key attr.name="access" attr.type="string" for="edge" id="ed1" />
 <key attr.name="label" attr.type="string" for="edge" id="ed2" />
 <key attr.name="url" attr.type="string" for="edge" id="ed3" />
 <graph id="g0" edgedefault="directed" parse.nodeids="canonical" parse.edgeids="canonical" parse.order="nodesfirst">
  <node id="n0">
   <data key="nd2">libraries</data>
   <data key="nd1">directory</data>
   <graph id="g1" edgedefault="directed" parse.nodeids="canonical" parse.edgeids="canonical" parse.order="nodesfirst">
    <node id="n1">
     <data key="nd2">lib1</data>
     <data key="nd1">directory</data>
     <graph id="g2" edgedefault="directed" parse.nodeids="canonical" parse.edgeids="canonical" parse.order="nodesfirst" />
    </node>
    <node id="n2">
     <data key="nd2">lib2</data>
     <data key="nd1">directory</data>
     <graph id="g3" edgedefault="directed" parse.nodeids="canonical" parse.edgeids="canonical" parse.order="nodesfirst" />
    </node>
    <node id="n3">
     <data key="nd2">lib3</data>
     <data key="nd1">directory</data>
     <graph id="g4" edgedefault="directed" parse.nodeids="canonical" parse.edgeids="canonical" parse.order="nodesfirst" />
    </node>
    <node id="n4">
     <data key="nd2">lib4</data>
     <data key="nd1">directory</data>
     <graph id="g5" edgedefault="directed" parse.nodeids="canonical" parse.edgeids="canonical" parse.order="nodesfirst" />
    </node>
   </graph>
  </node>
  <node id="n5">
   <data key="nd2">app</data>
   <data key="nd1">directory</data>
   <graph id="g6" edgedefault="directed" parse.nodeids="canonical" parse.edgeids="canonical" parse.order="nodesfirst" />
  </node>
  <edge id="e0" source="n5" target="n1">
   <data key="ed0">dependency</data>
  </edge>
  <edge id="e1" source="n5" target="n2">
   <data key="ed0">dependency</data>
  </edge>
  <edge id="e2" source="n5" target="n3">
   <data key="ed0">dependency</data>
  </edge>
  <edge id="e3" source="n5" target="n4">
   <data key="ed0">dependency</data>
  </edge>
 </graph>
</graphml>

```
