# t20016 - Template method specialization sequence diagram test case
## Config
```yaml
diagrams:
  t20016_sequence:
    type: sequence
    glob:
      - t20016.cc
    include:
      namespaces:
        - clanguml::t20016
    using_namespace: clanguml::t20016
    from:
      - function: "clanguml::t20016::tmain()"
```
## Source code
File `tests/t20016/t20016.cc`
```cpp
namespace clanguml {
namespace t20016 {
struct A {
    void a1(int a) { }
    template <typename T> T a2(const T &a) { return a; }
};

template <typename T> struct B {
    void b1(T b) { a_.a1(1); }

    template <typename F> F b2(T t) { return a_.a2(t); }

    A a_;
};

void tmain()
{
    B<long> b;

    b.b1(1);

    b.b2<int>(2);
}
}
}
```
## Generated PlantUML diagrams
![t20016_sequence](./t20016_sequence.svg "Template method specialization sequence diagram test case")
## Generated Mermaid diagrams
![t20016_sequence](./t20016_sequence_mermaid.svg "Template method specialization sequence diagram test case")
## Generated JSON models
```json
{
  "diagram_type": "sequence",
  "name": "t20016_sequence",
  "participants": [
    {
      "display_name": "tmain()",
      "full_name": "clanguml::t20016::tmain()",
      "id": "15301298869215413700",
      "name": "tmain",
      "namespace": "clanguml::t20016",
      "source_location": {
        "column": 6,
        "file": "t20016.cc",
        "line": 16,
        "translation_unit": "t20016.cc"
      },
      "type": "function"
    },
    {
      "activities": [
        {
          "display_name": "b1(long)",
          "full_name": "clanguml::t20016::B<long>::b1(long)",
          "id": "16514117681429778095",
          "name": "b1",
          "namespace": "clanguml::t20016",
          "source_location": {
            "column": 10,
            "file": "t20016.cc",
            "line": 9,
            "translation_unit": "t20016.cc"
          },
          "type": "method"
        },
        {
          "display_name": "b2(long)",
          "full_name": "clanguml::t20016::B<long>::b2(long)",
          "id": "1627049121504654829",
          "name": "b2",
          "namespace": "clanguml::t20016",
          "source_location": {
            "column": 29,
            "file": "t20016.cc",
            "line": 11,
            "translation_unit": "t20016.cc"
          },
          "type": "method"
        }
      ],
      "display_name": "B<long>",
      "full_name": "clanguml::t20016::B<long>",
      "id": "13506727301146613328",
      "name": "B",
      "namespace": "clanguml::t20016",
      "source_location": {
        "column": 30,
        "file": "t20016.cc",
        "line": 8,
        "translation_unit": "t20016.cc"
      },
      "type": "class"
    },
    {
      "activities": [
        {
          "display_name": "a1(int)",
          "full_name": "clanguml::t20016::A::a1(int)",
          "id": "9586968971391540342",
          "name": "a1",
          "namespace": "clanguml::t20016",
          "source_location": {
            "column": 10,
            "file": "t20016.cc",
            "line": 4,
            "translation_unit": "t20016.cc"
          },
          "type": "method"
        },
        {
          "display_name": "a2(const long &)",
          "full_name": "clanguml::t20016::A::a2(const long &)",
          "id": "9670277356243041331",
          "name": "a2",
          "namespace": "clanguml::t20016",
          "source_location": {
            "column": 29,
            "file": "t20016.cc",
            "line": 5,
            "translation_unit": "t20016.cc"
          },
          "type": "method"
        }
      ],
      "display_name": "A",
      "full_name": "clanguml::t20016::A",
      "id": "10809940754200425565",
      "name": "A",
      "namespace": "clanguml::t20016",
      "source_location": {
        "column": 8,
        "file": "t20016.cc",
        "line": 3,
        "translation_unit": "t20016.cc"
      },
      "type": "class"
    }
  ],
  "sequences": [
    {
      "from": {
        "id": "15301298869215413700",
        "location": "clanguml::t20016::tmain()"
      },
      "messages": [
        {
          "from": {
            "activity_id": "15301298869215413700",
            "participant_id": "15301298869215413700"
          },
          "name": "b1(long)",
          "return_type": "void",
          "scope": "normal",
          "source_location": {
            "column": 5,
            "file": "t20016.cc",
            "line": 20,
            "translation_unit": "t20016.cc"
          },
          "to": {
            "activity_id": "16514117681429778095",
            "participant_id": "13506727301146613328"
          },
          "type": "message"
        },
        {
          "from": {
            "activity_id": "16514117681429778095",
            "participant_id": "13506727301146613328"
          },
          "name": "a1(int)",
          "return_type": "void",
          "scope": "normal",
          "source_location": {
            "column": 20,
            "file": "t20016.cc",
            "line": 9,
            "translation_unit": "t20016.cc"
          },
          "to": {
            "activity_id": "9586968971391540342",
            "participant_id": "10809940754200425565"
          },
          "type": "message"
        },
        {
          "from": {
            "activity_id": "15301298869215413700",
            "participant_id": "15301298869215413700"
          },
          "name": "b2(long)",
          "return_type": "F",
          "scope": "normal",
          "source_location": {
            "column": 5,
            "file": "t20016.cc",
            "line": 22,
            "translation_unit": "t20016.cc"
          },
          "to": {
            "activity_id": "1627049121504654829",
            "participant_id": "13506727301146613328"
          },
          "type": "message"
        },
        {
          "from": {
            "activity_id": "1627049121504654829",
            "participant_id": "13506727301146613328"
          },
          "name": "a2(const long &)",
          "return_type": "long",
          "scope": "normal",
          "source_location": {
            "column": 46,
            "file": "t20016.cc",
            "line": 11,
            "translation_unit": "t20016.cc"
          },
          "to": {
            "activity_id": "9670277356243041331",
            "participant_id": "10809940754200425565"
          },
          "type": "message"
        },
        {
          "from": {
            "activity_id": "9670277356243041331",
            "participant_id": "10809940754200425565"
          },
          "name": "",
          "return_type": "T",
          "scope": "normal",
          "source_location": {
            "column": 46,
            "file": "t20016.cc",
            "line": 5,
            "translation_unit": "t20016.cc"
          },
          "to": {
            "activity_id": "1627049121504654829",
            "participant_id": "13506727301146613328"
          },
          "type": "return"
        },
        {
          "from": {
            "activity_id": "1627049121504654829",
            "participant_id": "13506727301146613328"
          },
          "name": "",
          "return_type": "F",
          "scope": "normal",
          "source_location": {
            "column": 39,
            "file": "t20016.cc",
            "line": 11,
            "translation_unit": "t20016.cc"
          },
          "to": {
            "activity_id": "15301298869215413700",
            "participant_id": "15301298869215413700"
          },
          "type": "return"
        }
      ]
    }
  ],
  "using_namespace": "clanguml::t20016"
}
```
## Generated GraphML models
