# Configuration file for the Sphinx documentation builder.
#
# This file only contains a selection of the most common options. For a full
# list see the documentation:
# https://www.sphinx-doc.org/en/master/usage/configuration.html
# -- Path setup --------------------------------------------------------------
# If extensions (or modules to document with autodoc) are in another directory,
# add these directories to sys.path here. If the directory is relative to the
# documentation root, use os.path.abspath to make it absolute, like shown here.
#
import os
import sys

from sphinx.locale import _

import chemex

sys.path.insert(0, os.path.abspath("."))

# -- Project information -----------------------------------------------------

project = "ChemEx"
copyright = "2021, Guillaume Bouvignies"
author = "Guillaume Bouvignies"

# The full version, including alpha/beta/rc tags


version = chemex.__version__
release = version

# -- General configuration ---------------------------------------------------

# Add any Sphinx extension module names here, as strings. They can be
# extensions coming with Sphinx (named 'sphinx.ext.*') or your custom
# ones.
extensions = [
    "sphinx.ext.intersphinx",
    "sphinx.ext.autodoc",
    "sphinx.ext.doctest",
    "sphinx.ext.mathjax",
    "sphinx.ext.extlinks",
    "sphinx.ext.viewcode",
    "sphinx.ext.todo",
    "sphinx.ext.coverage",
    "sphinx.ext.ifconfig",
    "sphinx.ext.githubpages",
    "sphinx.ext.inheritance_diagram",
    "sphinx.ext.napoleon",
    "sphinxcontrib.httpdomain",
    "sphinx_rtd_theme",
    "recommonmark",
]

# Add any paths that contain templates here, relative to this directory.
templates_path = ["_templates"]

# List of patterns, relative to source directory, that match files and
# directories to ignore when looking for source files.
# This pattern also affects html_static_path and html_extra_path.
exclude_patterns = ["build"]

# The language for content autogenerated by Sphinx. Refer to documentation
# for a list of supported languages.
# language = None

# There are two options for replacing |today|: either, you set today to some
# non-false value, then it is used:
# today = ''
# Else, today_fmt is used as the format for a strftime call.
today_fmt = "%B %d, %Y"

# The reST default role (used for this markup: `text`) to use for all documents.
# default_role = None

# If true, '()' will be appended to :func: etc. cross-reference text.
# add_function_parentheses = True

# If true, the current module name will be prepended to all description
# unit titles (such as .. function::).
# add_module_names = True

# If true, sectionauthor and moduleauthor directives will be shown in the
# output. They are ignored by default.
# show_authors = False

# The name of the Pygments (syntax highlighting) style to use.
pygments_style = "sphinx"

# A list of ignored prefixes for module index sorting.
modindex_common_prefix = ["chemex."]

# The default syntax to be highlighted
highlight_language = "python"

# Napoleon attributes
napoleon_google_docstring = False
napoleon_numpy_docstring = True

# Sphinx documentation build configuration file
autodoc_member_order = "groupwise"

# Whether to include todos or not
todo_include_todos = True

# Sphinx document translation with sphinx gettext feature uses these settings:
gettext_compact = False

# Whether to number all figures or not
numfig = True

# Example configuration for intersphinx: refer to the Python standard library.
# intersphinx_mapping = {'python': ('https://docs.python.org/3/', None)}

# -- Extensions to theme docs ------------------------------------------------


def setup(app):
    from sphinx.domains.python import PyField
    from sphinx.util.docfields import Field

    app.add_object_type(
        "confval",
        "confval",
        objname="configuration value",
        indextemplate="pair: %s; configuration value",
        doc_field_types=[
            PyField(
                "type",
                label=_("Type"),
                has_arg=False,
                names=("type",),
                bodyrolename="class",
            ),
            Field(
                "default",
                label=_("Default"),
                has_arg=False,
                names=("default",),
            ),
        ],
    )


# -- Options for HTML output -------------------------------------------------

# The theme to use for HTML and HTML Help pages.  See the documentation for
# a list of builtin themes.
#
html_theme = "sphinx_rtd_theme"

html_theme_options = {
    "canonical_url": "",
    #   'analytics_id': 'UA-XXXXXXX-1',  #  Provided by Google in your dashboard
    "logo_only": False,
    "display_version": True,
    "prev_next_buttons_location": "bottom",
    "style_external_links": False,
    #   'vcs_pageview_mode': '',
    #   'style_nav_header_background': 'white',
    # Toc options
    "collapse_navigation": True,
    "sticky_navigation": True,
    "navigation_depth": 3,
    "includehidden": True,
    "titles_only": False,
}

# Add any paths that contain custom static files (such as style sheets) here,
# relative to this directory. They are copied after the builtin static files,
# so a file named "default.css" will overwrite the builtin "default.css".
html_static_path = ["_static"]

# The suffix of source filenames.
source_suffix = ".rst"

# The master toctree document.
master_doc = "index"

# Theme options are theme-specific and customize the look and feel of a theme
# further.  For a list of options available for each theme, see the
# documentation.
# html_theme_options = {}

# Add any paths that contain custom themes here, relative to this directory.
# html_theme_path = []

# The name for this set of Sphinx documents.  If None, it defaults to
# "<project> v<release> documentation".
# html_title = None

# A shorter title for the navigation bar.  Default is the same as html_title.
# html_short_title = None

# The name of an image file (relative to this directory) to place at the top
# of the sidebar.
# html_logo = None
html_logo = "_static/chemex_logo.svg"

# The name of an image file (within the static path) to use as favicon of the
# docs.  This file should be a Windows icon file (.ico) being 16x16 or 32x32
# pixels large.
# html_favicon = None

# If not '', a 'Last updated on:' timestamp is inserted at every page bottom,
# using the given strftime format.
# html_last_updated_fmt = '%b %d, %Y'

# If true, SmartyPants will be used to convert quotes and dashes to
# typographically correct entities.
# html_use_smartypants = True

# Custom sidebar templates, maps document names to template names.
# html_sidebars = {}

# Additional templates that should be rendered to pages, maps page names to
# template names.
# html_additional_pages = {}

# If false, no module index is generated.
html_domain_indices = True

# If false, no index is generated.
# html_use_index = True

# If true, the index is split into individual pages for each letter.
# html_split_index = False

# If true, links to the reST sources are added to the pages.
html_show_sourcelink = True

# If true, "Created using Sphinx" is shown in the HTML footer. Default is True.
# html_show_sphinx = True

# If true, "(C) Copyright ..." is shown in the HTML footer. Default is True.
# html_show_copyright = True

# If true, an OpenSearch description file will be output, and all pages will
# contain a <link> tag referring to it.  The value of this option must be the
# base URL from which the finished HTML is served.
# html_use_opensearch = ''

# This is the file name suffix for HTML files (e.g. ".xhtml").
# html_file_suffix = None

# Output file base name for HTML help builder.
htmlhelp_basename = "chemexdoc"

# -- Options for LaTeX output ---------------------------------------------

latex_engine = "xelatex"

# latex_elements = {
#     # The paper size ('letterpaper' or 'a4paper').
#     "papersize": "letterpaper",
#     # 'papersize': 'a4',
#     # The font size ('10pt', '11pt' or '12pt').
#     "pointsize": "10pt",
#     "releasename": " ",
#     # Sonny, Lenny, Glenn, Conny, Rejne, Bjarne and Bjornstrup
#     # 'fncychap': '\\usepackage[Lenny]{fncychap}',
#     "fncychap": "\\usepackage{fncychap}",
#     # Latex figure (float) alignment
#     "figure_align": "htbp",
#     # Start first page of each chapter on any page
#     "extraclassoptions": "openany, oneside",
#     # Additional stuff for the LaTeX preamble.
#     #
#     "preamble": r"""
#         \setcounter{tocdepth}{2}
#         \usepackage[depth=2]{bookmark}
#         \usepackage[notbib,notindex]{tocbibind}

#         \usepackage{charter}
#         %\usepackage{crimson}
#         \usepackage[defaultsans]{lato}
#         %\usepackage{DejaVuSans}
#         \usepackage{inconsolata}
#         %\usepackage{sourcecodepro}
#         %\usepackage{DejaVuSansMono}

#         \usepackage[utf8]{inputenc}
#         \DeclareUnicodeCharacter{03D6}{\ensuremath{\varpi}}
#     """,
# }

# Grouping the document tree into LaTeX files. List of tuples
# (source start file, target name, title,
#  author, documentclass [howto, manual, or own class]).
latex_documents = [("index", "chemex.tex", "ChemEx Documentation", author, "manual")]

# The name of an image file (relative to this directory) to place at the top of
# the title page.
# latex_logo = None
latex_logo = "_static/chemex_logo.pdf"

# For "manual" documents, if this is true, then toplevel headings are parts,
# not chapters.
# latex_use_parts = False

# If true, show page references after internal links.
# latex_show_pagerefs = False

# If true, show URL addresses after external links.
# latex_show_urls = False

# Additional stuff for the LaTeX preamble.
# latex_preamble = ''

# Documents to append as an appendix to all manuals.
# latex_appendices = []

# If false, no module index is generated.
# latex_domain_indices = True

# -- Options for manual page output ---------------------------------------

# One entry per manual page. List of tuples
# (source start file, name, description, authors, manual section).
man_pages = [
    (
        "index",
        "chemex",
        "an open source Python package for analysis of NMR chemical exchange data",
        author,
        1,
    )
]

# -- Options for Texinfo output -------------------------------------------

# Grouping the document tree into Texinfo files. List of tuples
# (source start file, target name, title, author,
#  dir menu entry, description, category)
texinfo_documents = [
    (
        "index",
        "chemex",
        "ChemEx Documentation",
        author,
        "ChemEx",
        "ChemEx Documentation.",
        "Miscellaneous",
    ),
]

# -- Options for Epub output ----------------------------------------------

# Bibliographic Dublin Core info.
epub_theme = "epub"
epub_basename = "chemex"
epub_title = project
epub_author = author
epub_publisher = author
epub_copyright = copyright
epub_scheme = "url"

# The unique identifier of the text. This can be a ISBN number
# or the project homepage.
epub_identifier = epub_publisher

# A unique identification for the text.
epub_uid = "web-site"

# A list of files that should not be packed into the epub file.
epub_fix_images = False
epub_max_image_width = 0
epub_show_urls = "inline"
epub_use_index = True
epub_description = "ChemEx Documentation"
