import { z } from 'zod';
export declare const ConfigSchema: z.ZodObject<{
    backgroundAnalysisMaxFiles: z.ZodDefault<z.ZodNumber>;
    enableSourceErrorDiagnostics: z.ZodDefault<z.ZodBoolean>;
    globPattern: z.ZodDefault<z.ZodString>;
    explainshellEndpoint: z.ZodDefault<z.ZodString>;
    logLevel: z.ZodDefault<z.ZodEnum<["debug", "info", "warning", "error"]>>;
    includeAllWorkspaceSymbols: z.ZodDefault<z.ZodBoolean>;
    shellcheckArguments: z.ZodDefault<z.ZodEffects<z.ZodArray<z.ZodString, "many">, string[], unknown>>;
    shellcheckPath: z.ZodDefault<z.ZodString>;
    shfmt: z.ZodDefault<z.ZodObject<{
        path: z.ZodDefault<z.ZodString>;
        binaryNextLine: z.ZodDefault<z.ZodBoolean>;
        caseIndent: z.ZodDefault<z.ZodBoolean>;
        funcNextLine: z.ZodDefault<z.ZodBoolean>;
        spaceRedirects: z.ZodDefault<z.ZodBoolean>;
    }, "strip", z.ZodTypeAny, {
        path: string;
        binaryNextLine: boolean;
        caseIndent: boolean;
        funcNextLine: boolean;
        spaceRedirects: boolean;
    }, {
        path?: string | undefined;
        binaryNextLine?: boolean | undefined;
        caseIndent?: boolean | undefined;
        funcNextLine?: boolean | undefined;
        spaceRedirects?: boolean | undefined;
    }>>;
}, "strip", z.ZodTypeAny, {
    globPattern: string;
    enableSourceErrorDiagnostics: boolean;
    includeAllWorkspaceSymbols: boolean;
    backgroundAnalysisMaxFiles: number;
    explainshellEndpoint: string;
    logLevel: "debug" | "info" | "warning" | "error";
    shellcheckArguments: string[];
    shellcheckPath: string;
    shfmt: {
        path: string;
        binaryNextLine: boolean;
        caseIndent: boolean;
        funcNextLine: boolean;
        spaceRedirects: boolean;
    };
}, {
    backgroundAnalysisMaxFiles?: number | undefined;
    enableSourceErrorDiagnostics?: boolean | undefined;
    globPattern?: string | undefined;
    explainshellEndpoint?: string | undefined;
    logLevel?: "debug" | "info" | "warning" | "error" | undefined;
    includeAllWorkspaceSymbols?: boolean | undefined;
    shellcheckArguments?: unknown;
    shellcheckPath?: string | undefined;
    shfmt?: {
        path?: string | undefined;
        binaryNextLine?: boolean | undefined;
        caseIndent?: boolean | undefined;
        funcNextLine?: boolean | undefined;
        spaceRedirects?: boolean | undefined;
    } | undefined;
}>;
export type Config = z.infer<typeof ConfigSchema>;
export declare function getConfigFromEnvironmentVariables(): {
    config: Config;
    environmentVariablesUsed: string[];
};
export declare function getDefaultConfiguration(): Config;
