/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.fn;

import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.func.Function;
import org.basex.query.func.fn.ContextFn;
import org.basex.query.value.Value;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.QNm;
import org.basex.query.value.item.Str;
import org.basex.query.value.map.XQMap;
import org.basex.query.value.node.ANode;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.type.NodeType;
import org.basex.query.value.type.Types;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.list.TokenList;
import org.basex.util.options.BooleanOption;
import org.basex.util.options.Options;
import org.basex.util.options.ValueOption;

public final class FnPath
extends ContextFn {
    @Override
    public Item item(QueryContext qc, InputInfo ii) throws QueryException {
        boolean relative;
        Value origin;
        TokenList steps;
        TokenBuilder tb;
        block16: {
            ANode nd;
            ANode node = this.toNodeOrNull(this.context(qc), qc);
            PathOptions options = this.toOptions(this.arg(1), new PathOptions(), qc);
            if (node == null) {
                return Empty.VALUE;
            }
            tb = new TokenBuilder();
            steps = new TokenList();
            boolean indexes = options.get(PathOptions.INDEXES);
            Value ns = options.get(PathOptions.NAMESPACES);
            XQMap namespaces = ns.isEmpty() ? XQMap.empty() : this.toMap(ns, qc);
            boolean lexical = options.get(PathOptions.LEXICAL);
            origin = options.get(PathOptions.ORIGIN);
            relative = false;
            do {
                ANode parent = node.parent();
                NodeType type = (NodeType)node.type;
                if (parent == null) {
                    if (type != NodeType.DOCUMENT_NODE) {
                        tb.add(this.name(Function.ROOT.definition().name, false, lexical, namespaces, qc)).add("()");
                    }
                    break block16;
                }
                QNm qname = node.qname();
                if (type == NodeType.ATTRIBUTE) {
                    tb.add(64).add(this.name(qname, true, lexical, namespaces, qc));
                } else if (type == NodeType.ELEMENT) {
                    tb.add(this.name(qname, false, lexical, namespaces, qc));
                } else if (type == NodeType.PROCESSING_INSTRUCTION) {
                    tb.add(type.toString(Token.string(qname.local())));
                } else if (type.oneOf(NodeType.COMMENT, NodeType.TEXT)) {
                    tb.add(type.toString());
                }
                if (indexes && type != NodeType.ATTRIBUTE) {
                    int p = 1;
                    for (ANode nd2 : node.precedingSiblingIter(false)) {
                        qc.checkStop();
                        if (nd2.type != type || !type.oneOf(NodeType.COMMENT, NodeType.TEXT) && !nd2.qname().eq(qname)) continue;
                        ++p;
                    }
                    tb.add(91).addInt(p).add(93);
                }
                steps.add(tb.next());
                node = parent;
            } while (!(origin instanceof ANode) || !node.is(nd = (ANode)origin));
            relative = true;
        }
        if (origin instanceof ANode && !relative) {
            throw QueryError.PATH_X.get(this.info, origin);
        }
        for (int s = steps.size() - 1; s >= 0; --s) {
            if (!tb.isEmpty() || !(origin instanceof ANode)) {
                tb.add(47);
            }
            tb.add((byte[])steps.get(s));
        }
        return Str.get(tb.isEmpty() ? Token.cpToken(47) : tb.finish());
    }

    private byte[] name(QNm qnm, boolean attr, boolean lexical, XQMap namespaces, QueryContext qc) throws QueryException {
        if (lexical) {
            return qnm.string();
        }
        for (Item prefix : namespaces.keys()) {
            if (!Token.eq(qnm.uri(), this.toToken(namespaces.get(prefix), qc))) continue;
            return new QNm(this.toToken(prefix), qnm.local(), qnm.uri()).string();
        }
        return attr ? qnm.unique() : qnm.eqName();
    }

    @Override
    protected Expr opt(CompileContext cc) {
        return this.optFirst(true, false, cc.qc.focus.value);
    }

    public static class PathOptions
    extends Options {
        public static final ValueOption ORIGIN = new ValueOption("origin", Types.NODE_ZO);
        public static final BooleanOption LEXICAL = new BooleanOption("lexical", false);
        public static final ValueOption NAMESPACES = new ValueOption("namespaces", Types.MAP_O);
        public static final BooleanOption INDEXES = new BooleanOption("indexes", true);
    }
}

