/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.fn;

import java.util.function.Predicate;
import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.func.Function;
import org.basex.query.func.HofArgs;
import org.basex.query.func.StandardFunc;
import org.basex.query.func.fn.FnReplicate;
import org.basex.query.func.fn.FnSortBy;
import org.basex.query.iter.Iter;
import org.basex.query.util.collation.Collation;
import org.basex.query.util.list.ItemList;
import org.basex.query.value.Value;
import org.basex.query.value.ValueBuilder;
import org.basex.query.value.item.Dbl;
import org.basex.query.value.item.FItem;
import org.basex.query.value.item.Item;
import org.basex.query.value.seq.RangeSeq;
import org.basex.query.value.seq.SingletonSeq;
import org.basex.query.value.type.Occ;
import org.basex.query.value.type.SeqType;
import org.basex.query.value.type.Type;

public class FnLowest
extends StandardFunc {
    @Override
    public Value value(QueryContext qc) throws QueryException {
        return this.value(true, qc);
    }

    final Value value(boolean min, QueryContext qc) throws QueryException {
        Item item;
        Iter input = this.arg(0).iter(qc);
        Collation collation = this.toCollation(this.arg(1), qc);
        FItem key = this.toFunctionOrNull(this.arg(2), 1, qc);
        HofArgs args = key != null ? new HofArgs(1) : null;
        ItemList result = new ItemList();
        Value lowest = null;
        while ((item = input.next()) != null) {
            ValueBuilder vb = new ValueBuilder(qc);
            Item value = key != null ? this.invoke(key, args.set(0, item), qc) : item;
            for (Item it : ((Expr)value).atomValue(qc, this.info)) {
                vb.add(it.type.isUntyped() ? Dbl.get(this.toDouble(it)) : it);
            }
            Value low = vb.value();
            int diff = FnSortBy.compare(lowest != null ? lowest : low, low, collation, this.info);
            if (min) {
                diff = -diff;
            }
            if (diff > 0) continue;
            if (diff < 0) {
                result.reset();
            }
            result.add(item);
            lowest = low;
        }
        return result.value(this);
    }

    @Override
    protected Expr opt(CompileContext cc) throws QueryException {
        return this.opt(true, cc);
    }

    final Expr opt(boolean min, CompileContext cc) throws QueryException {
        Expr input = this.arg(0);
        SeqType st = input.seqType();
        if (st.zero()) {
            return input;
        }
        if (this.defined(2)) {
            this.arg(2, arg -> FnLowest.refineFunc(arg, cc, st.with(Occ.EXACTLY_ONE)));
        } else if (!this.defined(1)) {
            SingletonSeq ss;
            Predicate<Type> noCheck = type -> type.isSortable() && !type.isUntyped();
            if (st.zeroOrOne() && noCheck.test(st.type)) {
                return input;
            }
            if (input instanceof RangeSeq) {
                RangeSeq rs = (RangeSeq)input;
                return (rs.ascending() ? rs : rs.reverse(null)).itemAt(min ? 0L : rs.size() - 1L);
            }
            if (noCheck.test(st.type) && (st.one() || input instanceof SingletonSeq && (ss = (SingletonSeq)input).singleItem())) {
                return input;
            }
            if (Function.REPLICATE.is(input) && ((FnReplicate)input).singleEval(false)) {
                SeqType ast = input.arg(0).seqType();
                if (ast.zeroOrOne() && noCheck.test(ast.type)) {
                    return input;
                }
            } else if (Function.REVERSE.is(input) || Function.SORT.is(input)) {
                Expr[] args = (Expr[])this.exprs.clone();
                args[0] = args[0].arg(0);
                return cc.function(min ? Function.LOWEST : Function.HIGHEST, this.info, args);
            }
        }
        return this.adoptType(input);
    }
}

