/*
 * Decompiled with CFR 0.152.
 */
package org.basex.io.serial;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import org.basex.io.out.EncoderOutput;
import org.basex.io.out.NewlineOutput;
import org.basex.io.out.PrintOutput;
import org.basex.io.serial.Serializer;
import org.basex.io.serial.SerializerOptions;
import org.basex.query.QueryError;
import org.basex.util.Strings;
import org.basex.util.Token;

public abstract class OutputSerializer
extends Serializer {
    protected final PrintOutput out;
    protected final SerializerOptions sopts;
    protected final String encoding;
    protected byte[] itemsep;
    private final int indents;
    private final char tab;

    protected OutputSerializer(OutputStream os, SerializerOptions sopts) throws IOException {
        SerializerOptions.Newline nl;
        PrintOutput po;
        this.sopts = sopts;
        this.indent = sopts.yes(SerializerOptions.INDENT);
        this.indents = sopts.get(SerializerOptions.INDENTS);
        this.tab = (char)(sopts.yes(SerializerOptions.TABULATOR) ? 9 : 32);
        this.encoding = Strings.normEncoding(sopts.get(SerializerOptions.ENCODING), true);
        if (this.encoding == "UTF-8") {
            po = PrintOutput.get(os);
        } else {
            String error = Strings.checkEncoding(this.encoding);
            if (error != null) {
                throw QueryError.SERENCODING_X.getIO(error);
            }
            po = new EncoderOutput(os, Charset.forName(this.encoding));
        }
        int limit = sopts.get(SerializerOptions.LIMIT);
        if (limit != -1) {
            po.setLimit(limit);
        }
        if ((nl = sopts.get(SerializerOptions.NEWLINE)) != SerializerOptions.Newline.NL) {
            po = new NewlineOutput(po, Token.token(nl.newline()));
        }
        this.out = po;
        String is = sopts.get(SerializerOptions.ITEM_SEPARATOR);
        if (is != null) {
            this.itemsep = Token.token(is);
        }
        if (sopts.yes(SerializerOptions.BYTE_ORDER_MARK)) {
            switch (this.encoding) {
                case "UTF-8": {
                    this.out.write(239);
                    this.out.write(187);
                    this.out.write(191);
                    break;
                }
                case "UTF-16LE": {
                    this.out.write(255);
                    this.out.write(254);
                    break;
                }
                case "UTF-16BE": {
                    this.out.write(254);
                    this.out.write(255);
                }
            }
        }
    }

    @Override
    public void reset() {
        this.more = false;
    }

    @Override
    public final boolean finished() {
        return this.out.finished();
    }

    @Override
    public void close() throws IOException {
        this.out.flush();
    }

    protected void indent() throws IOException {
        if (this.indent) {
            this.out.print(10);
            int ls = this.level * this.indents;
            for (int l = 0; l < ls; ++l) {
                this.out.print(this.tab);
            }
        }
    }

    protected boolean separate() throws IOException {
        if (!this.more || this.itemsep == null) {
            return false;
        }
        this.out.print(this.itemsep);
        return true;
    }

    protected final void printChars(byte[] text) throws IOException {
        int tl = text.length;
        for (int t = 0; t < tl; t += Token.cl(text, t)) {
            this.printChar(Token.cp(text, t));
        }
    }

    protected abstract void printChar(int var1) throws IOException;

    protected final void printHex(int cp) throws IOException {
        this.out.print(38);
        this.out.print(35);
        this.out.print(120);
        boolean o = false;
        for (int i = 3; i >= 0; --i) {
            int b = cp >> (i << 3) & 0xFF;
            if (o || b > 15) {
                this.out.print(Token.HEX_TABLE[b >> 4]);
            }
            if (!o && b == 0) continue;
            this.out.print(Token.HEX_TABLE[b & 0xF]);
            o = true;
        }
        this.out.print(59);
    }
}

