/*
 * Decompiled with CFR 0.152.
 */
package net.xqj.core.toolkit;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.ref.SoftReference;
import java.util.Enumeration;
import java.util.Properties;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.xquery.XQException;
import net.xqj.core.exception.XQExceptionImpl;

public final class ReoToolkit {
    private static final ThreadLocal<SoftReference<ReoToolkit>> threadLocal = new ThreadLocal();
    private static TransformerFactory xmlTransformerFactory = null;
    private static final Properties DEFAULT_TRANSFORMER_PROPERTIES = new Properties();
    private final Transformer transformer;
    private boolean transformerIsDirty = true;
    private boolean isDodgyXalan27 = false;
    private final byte[] smallByteBuffer = new byte[10240];
    private final char[] smallCharBuffer = new char[10240];

    private ReoToolkit() {
        this.transformer = ReoToolkit.createTransformer();
        this.isDodgyXalan27 = this.transformer.getClass().getName().equals("org.apache.xalan.transformer.TransformerIdentityImpl");
    }

    private boolean isTransformerDodgyXalan27() {
        return this.isDodgyXalan27;
    }

    public static ReoToolkit getInstance() {
        SoftReference<ReoToolkit> softReference = threadLocal.get();
        ReoToolkit toolkit = null;
        if (softReference == null) {
            toolkit = new ReoToolkit();
            threadLocal.set(new SoftReference<ReoToolkit>(toolkit));
        } else {
            toolkit = softReference.get();
            if (toolkit == null) {
                toolkit = new ReoToolkit();
                threadLocal.set(new SoftReference<ReoToolkit>(toolkit));
            }
        }
        return toolkit;
    }

    public byte[] forceRead(InputStream in) throws XQException {
        return this.forceRead(this.smallByteBuffer, in);
    }

    public char[] forceRead(Reader reader) throws XQException {
        return this.forceRead(this.smallCharBuffer, reader);
    }

    public byte[] forceRead(byte[] smallBuffer, InputStream in) throws XQException {
        byte[] newTargetBuffer;
        int read;
        byte[] targetBuffer = null;
        int smallBufferPosition = 0;
        int targetBufferPosition = 0;
        while ((read = this.read(in, smallBuffer, smallBufferPosition, smallBuffer.length - smallBufferPosition)) != -1) {
            if ((smallBufferPosition += read) != smallBuffer.length) continue;
            if (targetBuffer == null) {
                targetBuffer = new byte[smallBufferPosition];
                System.arraycopy(smallBuffer, 0, targetBuffer, 0, smallBufferPosition);
                targetBufferPosition += smallBufferPosition;
            } else {
                newTargetBuffer = new byte[targetBufferPosition + smallBufferPosition];
                System.arraycopy(targetBuffer, 0, newTargetBuffer, 0, targetBufferPosition);
                System.arraycopy(smallBuffer, 0, newTargetBuffer, targetBufferPosition, smallBufferPosition);
                targetBuffer = newTargetBuffer;
                newTargetBuffer = null;
                targetBufferPosition += smallBufferPosition;
            }
            smallBufferPosition = 0;
        }
        if (targetBuffer == null) {
            targetBuffer = new byte[smallBufferPosition];
            System.arraycopy(smallBuffer, 0, targetBuffer, 0, smallBufferPosition);
        } else {
            newTargetBuffer = new byte[targetBufferPosition + smallBufferPosition];
            System.arraycopy(targetBuffer, 0, newTargetBuffer, 0, targetBufferPosition);
            System.arraycopy(smallBuffer, 0, newTargetBuffer, targetBufferPosition, smallBufferPosition);
            targetBuffer = newTargetBuffer;
            newTargetBuffer = null;
        }
        return targetBuffer;
    }

    public char[] forceRead(char[] smallBuffer, Reader reader) throws XQException {
        char[] newTargetBuffer;
        int read;
        char[] targetBuffer = null;
        int smallBufferPosition = 0;
        int targetBufferPosition = 0;
        while ((read = this.read(reader, smallBuffer, smallBufferPosition, smallBuffer.length - smallBufferPosition)) != -1) {
            if ((smallBufferPosition += read) != smallBuffer.length) continue;
            if (targetBuffer == null) {
                targetBuffer = new char[smallBufferPosition];
                System.arraycopy(smallBuffer, 0, targetBuffer, 0, smallBufferPosition);
                targetBufferPosition += smallBufferPosition;
            } else {
                newTargetBuffer = new char[targetBufferPosition + smallBufferPosition];
                System.arraycopy(targetBuffer, 0, newTargetBuffer, 0, targetBufferPosition);
                System.arraycopy(smallBuffer, 0, newTargetBuffer, targetBufferPosition, smallBufferPosition);
                targetBuffer = newTargetBuffer;
                newTargetBuffer = null;
                targetBufferPosition += smallBufferPosition;
            }
            smallBufferPosition = 0;
        }
        if (targetBuffer == null) {
            targetBuffer = new char[smallBufferPosition];
            System.arraycopy(smallBuffer, 0, targetBuffer, 0, smallBufferPosition);
        } else {
            newTargetBuffer = new char[targetBufferPosition + smallBufferPosition];
            System.arraycopy(targetBuffer, 0, newTargetBuffer, 0, targetBufferPosition);
            System.arraycopy(smallBuffer, 0, newTargetBuffer, targetBufferPosition, smallBufferPosition);
            targetBuffer = newTargetBuffer;
            newTargetBuffer = null;
        }
        return targetBuffer;
    }

    public final int read(InputStream in, byte[] buffer, int offset, int length) throws XQException {
        try {
            return in.read(buffer, offset, length);
        }
        catch (IOException e) {
            throw new XQExceptionImpl("IOException occurred whilst reading from InputStream.", "XQJTO001", e);
        }
    }

    public final int read(Reader reader, char[] buffer, int offset, int length) throws XQException {
        try {
            return reader.read(buffer, offset, length);
        }
        catch (IOException e) {
            throw new XQExceptionImpl("IOException occurred whilst reading from Reader.", "XQJTO002", e);
        }
    }

    public final void transform(Source source, Result result) throws XQException {
        this.transform(source, result, null);
    }

    public final void transform(Source source, Result result, Properties properties) throws XQException {
        Transformer transformer = this.getTransformer(properties);
        try {
            transformer.transform(source, result);
        }
        catch (TransformerException e) {
            throw new XQExceptionImpl(e.getMessage(), "XQJTO013", e);
        }
        catch (IllegalStateException e) {
            throw new XQExceptionImpl(e.getMessage(), "XQJTO014", e);
        }
    }

    private static final void buildNewTransformerFactory() throws TransformerFactoryConfigurationError {
        if (xmlTransformerFactory != null) {
            return;
        }
        xmlTransformerFactory = TransformerFactory.newInstance();
    }

    private final Properties createTransformerProperties() {
        return (Properties)DEFAULT_TRANSFORMER_PROPERTIES.clone();
    }

    private static final Transformer createTransformer() {
        try {
            return xmlTransformerFactory.newTransformer();
        }
        catch (TransformerConfigurationException e) {
            throw new RuntimeException("Failed to create JAXP identity transformer.", e);
        }
    }

    public final Transformer getTransformer() throws XQException {
        return this.getTransformer(null);
    }

    public final Transformer getTransformer(Properties properties) throws XQException {
        if (!this.isTransformerDodgyXalan27()) {
            this.transformer.reset();
        }
        this.transformer.setOutputProperties(this.createTransformerProperties());
        this.transformerIsDirty = false;
        if (properties != null) {
            Enumeration<?> e = properties.propertyNames();
            while (e.hasMoreElements()) {
                String propertyName = (String)e.nextElement();
                String propertyValue = properties.getProperty(propertyName);
                if (propertyName.equals("method")) {
                    if (!propertyValue.equals("{http://www.xqj.net/}xquery")) {
                        this.transformer.setOutputProperty("method", propertyValue);
                    }
                } else if (propertyName.equals("encoding")) {
                    this.transformer.setOutputProperty("encoding", ReoToolkit.parseEncodingForTransformer(propertyValue));
                } else {
                    if (propertyName.equals("byte-order-mark")) continue;
                    this.transformer.setOutputProperty(propertyName, propertyValue);
                }
                this.transformerIsDirty = true;
            }
        }
        return this.transformer;
    }

    private static final String parseEncodingForTransformer(String encoding) {
        if (encoding == null) {
            return "UTF-8";
        }
        if (encoding.equalsIgnoreCase("utf-8") || encoding.equalsIgnoreCase("utf-16")) {
            return encoding;
        }
        if (encoding.startsWith("utf") || encoding.startsWith("UTF")) {
            return encoding.endsWith("16") ? "UTF-16" : "UTF-8";
        }
        return "UTF-8";
    }

    static {
        ReoToolkit.buildNewTransformerFactory();
        DEFAULT_TRANSFORMER_PROPERTIES.setProperty("method", "xml");
        DEFAULT_TRANSFORMER_PROPERTIES.setProperty("encoding", "UTF-8");
        DEFAULT_TRANSFORMER_PROPERTIES.setProperty("omit-xml-declaration", "yes");
        DEFAULT_TRANSFORMER_PROPERTIES.setProperty("indent", "no");
        DEFAULT_TRANSFORMER_PROPERTIES.setProperty("version", "1.0");
        DEFAULT_TRANSFORMER_PROPERTIES.setProperty("standalone", "omit");
    }
}

