/*
 * Decompiled with CFR 0.152.
 */
package net.xqj.core.xqitem;

import java.io.InputStream;
import java.io.Reader;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import javax.xml.xquery.XQException;
import net.xqj.basic.BasicItem;
import net.xqj.core.Factory;
import net.xqj.core.XQToolkit;
import net.xqj.core.xqitem.AtomicXQItem;
import net.xqj.core.xqitem.DeferredXMLXQItem;
import net.xqj.core.xqitem.DocumentXQItem;
import net.xqj.core.xqitem.EmptyXQItem;
import net.xqj.core.xqitem.MemoryXMLXQItem;
import net.xqj.core.xqitem.NodeXQItem;
import net.xqj.core.xqitem.StreamingAtomicXQItem;
import net.xqj.core.xqitem.StreamingCustomXQItem;
import net.xqj.core.xqitem.XQItemBase;
import net.xqj.core.xqitem.XQItemProxy;
import net.xqj.core.xqitem.XQResultItemProxy;
import net.xqj.core.xqitemtype.XQItemTypeFactory;

public final class XQItemFactory {
    private XQItemFactory() {
    }

    public static final MemoryXMLXQItem newMemoryXMLXQItem(InputStream in, String baseURI, boolean wellFormedCheck) throws XQException {
        MemoryXMLXQItem item = MemoryXMLXQItem.newInstance(XQToolkit.parseXML(Factory.newReader(in), baseURI, wellFormedCheck));
        item.setItemType(XQItemTypeFactory.createElementType(null, 2));
        return item;
    }

    public static final MemoryXMLXQItem newMemoryXMLXQItem(Reader reader, String baseURI, boolean wellFormedCheck) throws XQException {
        MemoryXMLXQItem item = MemoryXMLXQItem.newInstance(XQToolkit.parseXML(reader, baseURI, wellFormedCheck));
        item.setItemType(XQItemTypeFactory.createElementType(null, 2));
        return item;
    }

    public static final MemoryXMLXQItem newMemoryXMLXQItem(String string, String baseURI, boolean wellFormedCheck) throws XQException {
        MemoryXMLXQItem item = MemoryXMLXQItem.newInstance(XQToolkit.parseXML(string, baseURI, wellFormedCheck));
        item.setItemType(XQItemTypeFactory.createElementType(null, 2));
        return item;
    }

    public static final MemoryXMLXQItem newMemoryXMLXQItem(char[] value, String baseURI, boolean wellFormedCheck) throws XQException {
        return XQItemFactory.newMemoryXMLXQItem(value, 0, value.length, baseURI, wellFormedCheck);
    }

    public static final MemoryXMLXQItem newMemoryXMLXQItem(char[] value, int offset, int length, String baseURI, boolean wellFormedCheck) throws XQException {
        if (wellFormedCheck) {
            XQToolkit.parseXML(value, offset, length, baseURI, wellFormedCheck);
        }
        MemoryXMLXQItem item = MemoryXMLXQItem.newInstance(value, offset, length);
        item.setItemType(XQItemTypeFactory.createElementType(null, 2));
        return item;
    }

    public static final MemoryXMLXQItem newMemoryXMLXQItem(XMLStreamReader reader) throws XQException {
        MemoryXMLXQItem item = MemoryXMLXQItem.newInstance(XQToolkit.parseXML(reader));
        item.setItemType(XQItemTypeFactory.createElementType(null, 2));
        return item;
    }

    public static final MemoryXMLXQItem newMemoryXMLXQItem(Source source) throws XQException {
        MemoryXMLXQItem item = MemoryXMLXQItem.newInstance(XQToolkit.parseXML(source));
        item.setItemType(XQItemTypeFactory.createElementType(null, 2));
        return item;
    }

    public static final DeferredXMLXQItem newDeferredXMLXQItem(InputStream in, String baseURI) throws XQException {
        DeferredXMLXQItem item = DeferredXMLXQItem.newInstance(in, baseURI);
        item.setItemType(XQItemTypeFactory.createElementType(null, 2));
        return item;
    }

    public static final DeferredXMLXQItem newDeferredXMLXQItem(Reader reader, String baseURI) throws XQException {
        DeferredXMLXQItem item = DeferredXMLXQItem.newInstance(reader, baseURI);
        item.setItemType(XQItemTypeFactory.createElementType(null, 2));
        return item;
    }

    public static final DeferredXMLXQItem newDeferredXMLXQItem(XMLStreamReader reader) throws XQException {
        DeferredXMLXQItem item = DeferredXMLXQItem.newInstance(Factory.newSource(reader));
        item.setItemType(XQItemTypeFactory.createElementType(null, 2));
        return item;
    }

    public static final DeferredXMLXQItem newDeferredXMLXQItem(Source source) throws XQException {
        DeferredXMLXQItem item = DeferredXMLXQItem.newInstance(source);
        item.setItemType(XQItemTypeFactory.createElementType(null, 2));
        return item;
    }

    public static final StreamingCustomXQItem newStreamingCustomXQItem(BasicItem basicItem) throws XQException {
        StreamingCustomXQItem item = StreamingCustomXQItem.newInstance(basicItem);
        if (basicItem.hasURL()) {
            item.setNodeUri(basicItem.getURL());
        }
        item.setItemType(XQItemTypeFactory.createNodeType());
        return item;
    }

    public static final DocumentXQItem newDocumentXQItem(XQItemBase item, boolean isElement) throws XQException {
        DocumentXQItem documentItem = DocumentXQItem.newInstance(item, isElement);
        documentItem.setItemType(isElement ? XQItemTypeFactory.createDocumentElementType(item.getItemType()) : XQItemTypeFactory.createDocumentType());
        return documentItem;
    }

    public static final AtomicXQItem newAtomicXQItem(InputStream in) throws XQException {
        return XQItemFactory.newAtomicXQItem(XQToolkit.getUTF8CharArray(XQToolkit.forceRead(in)));
    }

    public static final AtomicXQItem newAtomicXQItem(char[] value) throws XQException {
        return XQItemFactory.newAtomicXQItem(value, 0, value.length);
    }

    public static final AtomicXQItem newAtomicXQItem(char[] value, int offset, int length) throws XQException {
        AtomicXQItem item = AtomicXQItem.newInstance(value, offset, length);
        return item;
    }

    public static final AtomicXQItem newAtomicXQItem(Reader reader) throws XQException {
        return AtomicXQItem.newInstance(XQToolkit.forceRead(reader));
    }

    public static final AtomicXQItem newAtomicXQItem(String string) throws XQException {
        return XQItemFactory.newAtomicXQItem(string.toCharArray());
    }

    public static final StreamingAtomicXQItem newStreamingAtomicXQItem(InputStream in) throws XQException {
        StreamingAtomicXQItem item = StreamingAtomicXQItem.newInstance(in);
        return item;
    }

    public static final XQItemProxy newXQItemProxy(XQItemBase itemBase) {
        return XQItemProxy.newInstance(itemBase);
    }

    public static final XQResultItemProxy newXQResultItemProxy(XQItemBase itemBase) {
        return XQResultItemProxy.newInstance(itemBase);
    }

    public static final EmptyXQItem newEmptyXQItem() {
        return EmptyXQItem.newInstance();
    }

    public static final NodeXQItem newNodeXQItem(String lexicalValue) throws XQException {
        return XQItemFactory.newNodeXQItem(lexicalValue.toCharArray());
    }

    public static final NodeXQItem newNodeXQItem(char[] lexicalValue) throws XQException {
        return XQItemFactory.newNodeXQItem(lexicalValue, 0, lexicalValue.length);
    }

    public static final NodeXQItem newNodeXQItem(char[] lexicalValue, int offset, int length) throws XQException {
        return NodeXQItem.newInstance(lexicalValue, offset, length);
    }

    public static final NodeXQItem newPIXQItem(String lexicalValue) throws XQException {
        String[] parts = lexicalValue.split("\\s+", 2);
        NodeXQItem item = XQItemFactory.newNodeXQItem(parts.length > 1 ? parts[1] : "");
        item.setItemType(XQItemTypeFactory.createProcessingInstructionType(parts[0]));
        return item;
    }

    public static final NodeXQItem newPIXQItemFromXML(String xmlLexicalValue) throws XQException {
        return XQItemFactory.newPIXQItemFromXML(xmlLexicalValue.toCharArray());
    }

    public static final NodeXQItem newPIXQItemFromXML(char[] xmlLexicalValue) throws XQException {
        return XQItemFactory.newPIXQItemFromXML(xmlLexicalValue, 0, xmlLexicalValue.length);
    }

    public static final NodeXQItem newPIXQItemFromXML(char[] xmlLexicalValue, int offset, int length) throws XQException {
        char[] value = new char[length];
        int valueIndex = 0;
        block3: for (int i = offset; i < offset + length; ++i) {
            switch (xmlLexicalValue[i]) {
                case '<': 
                case '>': 
                case '?': {
                    continue block3;
                }
                default: {
                    value[valueIndex++] = xmlLexicalValue[i];
                }
            }
        }
        return XQItemFactory.newPIXQItem(new String(value, 0, valueIndex));
    }

    public static final NodeXQItem newCommentXQItem(String lexicalValue) throws XQException {
        return XQItemFactory.newCommentXQItem(lexicalValue.toCharArray());
    }

    public static final NodeXQItem newCommentXQItem(char[] lexicalValue) throws XQException {
        return XQItemFactory.newCommentXQItem(lexicalValue, 0, lexicalValue.length);
    }

    public static final NodeXQItem newCommentXQItem(char[] lexicalValue, int offset, int length) throws XQException {
        NodeXQItem item;
        if (lexicalValue[offset] == '<' && lexicalValue[offset + 1] == '!' && lexicalValue[offset + 2] == '-' && lexicalValue[offset + 3] == '-') {
            item = XQItemFactory.newNodeXQItem(lexicalValue);
        } else {
            char[] v = new char[length + 7];
            v[0] = 60;
            v[1] = 33;
            v[3] = 45;
            v[2] = 45;
            System.arraycopy(lexicalValue, offset, v, 4, length);
            v[v.length - 1] = 62;
            v[v.length - 3] = 45;
            v[v.length - 2] = 45;
            item = XQItemFactory.newNodeXQItem(v);
        }
        item.setItemType(XQItemTypeFactory.createCommentType());
        return item;
    }

    public static final NodeXQItem newTextXQItem(String lexicalValue) throws XQException {
        return XQItemFactory.newTextXQItem(lexicalValue.toCharArray());
    }

    public static final NodeXQItem newTextXQItem(char[] lexicalValue) throws XQException {
        return XQItemFactory.newTextXQItem(lexicalValue, 0, lexicalValue.length);
    }

    public static final NodeXQItem newTextXQItem(char[] lexicalValue, int offset, int length) throws XQException {
        NodeXQItem item = XQItemFactory.newNodeXQItem(lexicalValue, offset, length);
        item.setItemType(XQItemTypeFactory.createTextType());
        return item;
    }

    public static final NodeXQItem newAttributeXQItem(String lexicalValue, String namespaceURI) throws XQException {
        return XQItemFactory.newAttributeXQItem(lexicalValue.toCharArray(), namespaceURI);
    }

    public static final NodeXQItem newAttributeXQItem(char[] lexicalValue, String namespaceURI) throws XQException {
        return XQItemFactory.newAttributeXQItem(lexicalValue, 0, lexicalValue.length, namespaceURI);
    }

    public static final NodeXQItem newAttributeXQItem(char[] lexicalValue, int offset, int length, String namespaceURI) throws XQException {
        String stringValue = new String(lexicalValue, offset, length);
        int equalsIndex = stringValue.indexOf(61);
        int firstQuote = stringValue.indexOf(34);
        int secondQuote = stringValue.indexOf(34, firstQuote + 1);
        String qualifiedName = stringValue.substring(0, equalsIndex).trim();
        String value = stringValue.substring(firstQuote + 1, secondQuote);
        NodeXQItem item = NodeXQItem.newInstance(value.toCharArray(), 0, value.length());
        item.setNodeUri(namespaceURI);
        item.setItemType(XQItemTypeFactory.createAttributeType(XQToolkit.getQName(qualifiedName, namespaceURI), 3));
        return item;
    }
}

