/*
 * Decompiled with CFR 0.152.
 */
package net.xqj.core;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TimeZone;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.xquery.XQConstants;
import javax.xml.xquery.XQDynamicContext;
import javax.xml.xquery.XQException;
import javax.xml.xquery.XQItem;
import javax.xml.xquery.XQItemType;
import javax.xml.xquery.XQSequence;
import javax.xml.xquery.XQStaticContext;
import net.xqj.basic.BasicConnection;
import net.xqj.basic.BasicQuery;
import net.xqj.basic.BasicResultSequence;
import net.xqj.core.BasicResultSequenceIterator;
import net.xqj.core.Constants;
import net.xqj.core.GenericXQConnection;
import net.xqj.core.GenericXQDataSource;
import net.xqj.core.XQStaticContextImpl;
import net.xqj.core.XQToolkit;
import net.xqj.core.exception.XQExceptionImpl;
import net.xqj.core.util.CharArrayWriter;
import net.xqj.core.xqitem.LexicalValidator;
import net.xqj.core.xqitem.ObjectToXQItemConverter;
import net.xqj.core.xqitem.XQItemFactory;
import net.xqj.core.xqitem.XQItemProxy;
import net.xqj.core.xqitemtype.XQItemTypeFactory;
import net.xqj.core.xqparser.Context;
import net.xqj.core.xqparser.ExternalContextItem;
import net.xqj.core.xqparser.ExternalVariable;
import net.xqj.core.xqparser.XQueryStatement;
import net.xqj.core.xqparser.XQueryToken;
import net.xqj.core.xqsequence.ForwardOnlyXQSequence;
import net.xqj.core.xqsequence.ScrollableXQSequence;
import net.xqj.core.xqsequence.XQResultSequenceProxy;
import net.xqj.core.xqsequence.XQSequenceBase;
import net.xqj.core.xqsequence.XQSequenceFactory;
import net.xqj.core.xqsequence.XQSequenceProxy;
import org.w3c.dom.Node;

public abstract class XQDynamicContextImpl
implements XQDynamicContext {
    protected Map boundVariables = new HashMap();
    protected TimeZone timezone = null;
    protected final GenericXQConnection conn;
    protected final XQStaticContext staticContext;
    protected boolean isClosed = false;

    public XQDynamicContextImpl(GenericXQConnection connection, XQStaticContext staticContext) {
        this.conn = connection;
        this.staticContext = staticContext;
    }

    public void bindAtomicValue(QName varName, String value, XQItemType type) throws XQException {
        XQToolkit.nullValueTest(varName, "QName", "XQJDC007");
        XQToolkit.nullValueTest(value, "String", "XQJDC008");
        this.checkIfClosed();
        this.getDataSource().getLogger().debug(22, this, varName, value, type);
        if (type == null) {
            type = XQItemTypeFactory.createAtomicType(4);
        }
        if (type.getItemKind() != 1) {
            throw new XQExceptionImpl("XQItemType's item kind is not XQITEMKIND_ATOMIC.", "XQJDC001");
        }
        LexicalValidator.validate(value, type);
        this.bind(varName, XQItemFactory.newXQItemProxy(ObjectToXQItemConverter.createXQItem(value, type)));
    }

    public void bindBoolean(QName varName, boolean value, XQItemType type) throws XQException {
        XQToolkit.nullValueTest(varName, "QName", "XQJDC009");
        this.checkIfClosed();
        this.getDataSource().getLogger().debug(23, this, varName, value, type);
        this.bind(varName, XQItemFactory.newXQItemProxy(ObjectToXQItemConverter.createXQItem(value, type)));
    }

    public void bindByte(QName varName, byte value, XQItemType type) throws XQException {
        XQToolkit.nullValueTest(varName, "QName", "XQJDC010");
        this.checkIfClosed();
        this.getDataSource().getLogger().debug(24, this, varName, value, type);
        this.bind(varName, XQItemFactory.newXQItemProxy(ObjectToXQItemConverter.createXQItem(value, type)));
    }

    public void bindDouble(QName varName, double value, XQItemType type) throws XQException {
        XQToolkit.nullValueTest(varName, "QName", "XQJDC011");
        this.checkIfClosed();
        this.getDataSource().getLogger().debug(25, this, varName, value, type);
        this.bind(varName, XQItemFactory.newXQItemProxy(ObjectToXQItemConverter.createXQItem(value, type)));
    }

    public void bindFloat(QName varName, float value, XQItemType type) throws XQException {
        XQToolkit.nullValueTest(varName, "QName", "XQJDC012");
        this.checkIfClosed();
        this.getDataSource().getLogger().debug(26, this, varName, Float.valueOf(value), type);
        this.bind(varName, XQItemFactory.newXQItemProxy(ObjectToXQItemConverter.createXQItem(Float.valueOf(value), type)));
    }

    public void bindInt(QName varName, int value, XQItemType type) throws XQException {
        XQToolkit.nullValueTest(varName, "QName", "XQJDC013");
        this.checkIfClosed();
        this.getDataSource().getLogger().debug(27, this, varName, value, type);
        this.bind(varName, XQItemFactory.newXQItemProxy(ObjectToXQItemConverter.createXQItem(value, type)));
    }

    public void bindLong(QName varName, long value, XQItemType type) throws XQException {
        XQToolkit.nullValueTest(varName, "QName", "XQJDC014");
        this.checkIfClosed();
        this.getDataSource().getLogger().debug(28, this, varName, value, type);
        this.bind(varName, XQItemFactory.newXQItemProxy(ObjectToXQItemConverter.createXQItem(value, type)));
    }

    public void bindNode(QName varName, Node value, XQItemType type) throws XQException {
        XQToolkit.nullValueTest(varName, "QName", "XQJDC015");
        XQToolkit.nullValueTest(value, "Node", "XQJDC016");
        this.checkIfClosed();
        this.getDataSource().getLogger().debug(29, this, varName, value, type);
        this.bind(varName, XQItemFactory.newXQItemProxy(ObjectToXQItemConverter.createXQItem(value, type)));
    }

    public void bindShort(QName varName, short value, XQItemType type) throws XQException {
        XQToolkit.nullValueTest(varName, "QName", "XQJDC017");
        this.checkIfClosed();
        this.getDataSource().getLogger().debug(30, this, varName, value, type);
        this.bind(varName, XQItemFactory.newXQItemProxy(ObjectToXQItemConverter.createXQItem(value, type)));
    }

    public void bindString(QName varName, String value, XQItemType type) throws XQException {
        XQToolkit.nullValueTest(varName, "QName", "XQJDC018");
        XQToolkit.nullValueTest(value, "String", "XQJDC019");
        this.checkIfClosed();
        this.getDataSource().getLogger().debug(38, this, varName, value, type);
        if (type == null) {
            type = XQItemTypeFactory.createAtomicType(29);
        }
        if (!XQToolkit.isDerivedFromRestriction(XQItemTypeFactory.createAtomicType(29), type)) {
            throw new XQExceptionImpl("XQItemType (" + String.valueOf(type) + ") is not derived from xs:string.", "XQJDC002");
        }
        LexicalValidator.validate(value, type);
        this.bind(varName, XQItemFactory.newXQItemProxy(ObjectToXQItemConverter.createXQItem(value, type)));
    }

    public void bindObject(QName varName, Object value, XQItemType type) throws XQException {
        XQToolkit.nullValueTest(varName, "QName", "XQJDC020");
        XQToolkit.nullValueTest(value, "Object (2nd parameter)", "XQJDC021");
        this.checkIfClosed();
        this.getDataSource().getLogger().debug(37, this, varName, value.getClass().getName(), value, type);
        this.bind(varName, XQItemFactory.newXQItemProxy(ObjectToXQItemConverter.createXQItem(value, type)));
    }

    public void bindDocument(QName varName, String value, String baseURI, XQItemType type) throws XQException {
        XQItemProxy proxy;
        XQToolkit.nullValueTest(varName, "QName", "XQJDC022");
        XQToolkit.nullValueTest(value, "String", "XQJDC023");
        this.checkIfClosed();
        this.getDataSource().getLogger().debug(31, this, varName, value, baseURI, type);
        XQItemProxy xQItemProxy = proxy = this.getStaticContext().getBindingMode() == 0 ? XQItemFactory.newXQItemProxy(XQItemFactory.newDocumentXQItem(XQItemFactory.newMemoryXMLXQItem(value, baseURI, true), true)) : XQItemFactory.newXQItemProxy(XQItemFactory.newDocumentXQItem(XQItemFactory.newDeferredXMLXQItem(new StringReader(value), baseURI), true));
        if (type == null) {
            type = XQItemTypeFactory.createDocumentElementType(XQItemTypeFactory.createElementType(null, 1));
        }
        if (!XQToolkit.isDocumentNode(type.getItemKind())) {
            this.throwNonDocumentException();
        }
        proxy.setItemType(type);
        this.bind(varName, proxy);
    }

    public void bindDocument(QName varName, Reader value, String baseURI, XQItemType type) throws XQException {
        XQItemProxy proxy;
        XQToolkit.nullValueTest(varName, "QName", "XQJDC024");
        XQToolkit.nullValueTest(value, "Reader", "XQJDC025");
        this.checkIfClosed();
        this.getDataSource().getLogger().debug(32, this, varName, value, baseURI, type);
        XQItemProxy xQItemProxy = proxy = this.getStaticContext().getBindingMode() == 0 ? XQItemFactory.newXQItemProxy(XQItemFactory.newDocumentXQItem(XQItemFactory.newMemoryXMLXQItem(value, baseURI, true), true)) : XQItemFactory.newXQItemProxy(XQItemFactory.newDocumentXQItem(XQItemFactory.newDeferredXMLXQItem(value, baseURI), true));
        if (type == null) {
            type = XQItemTypeFactory.createDocumentElementType(XQItemTypeFactory.createElementType(null, 1));
        }
        if (!XQToolkit.isDocumentNode(type.getItemKind())) {
            this.throwNonDocumentException();
        }
        proxy.setItemType(type);
        this.bind(varName, proxy);
    }

    public void bindDocument(QName varName, InputStream value, String baseURI, XQItemType type) throws XQException {
        XQItemProxy proxy;
        XQToolkit.nullValueTest(varName, "QName", "XQJDC026");
        XQToolkit.nullValueTest(value, "InputStream", "XQJDC027");
        this.checkIfClosed();
        this.getDataSource().getLogger().debug(33, this, varName, value, baseURI, type);
        XQItemProxy xQItemProxy = proxy = this.getStaticContext().getBindingMode() == 0 ? XQItemFactory.newXQItemProxy(XQItemFactory.newDocumentXQItem(XQItemFactory.newMemoryXMLXQItem(value, baseURI, true), true)) : XQItemFactory.newXQItemProxy(XQItemFactory.newDocumentXQItem(XQItemFactory.newDeferredXMLXQItem(value, baseURI), true));
        if (type == null) {
            type = XQItemTypeFactory.createDocumentElementType(XQItemTypeFactory.createElementType(null, 1));
        }
        if (!XQToolkit.isDocumentNode(type.getItemKind())) {
            this.throwNonDocumentException();
        }
        proxy.setItemType(type);
        this.bind(varName, proxy);
    }

    public void bindDocument(QName varName, XMLStreamReader value, XQItemType type) throws XQException {
        XQItemProxy proxy;
        XQToolkit.nullValueTest(varName, "QName", "XQJDC028");
        XQToolkit.nullValueTest(value, "ZMLStreamReader", "XQJDC029");
        this.checkIfClosed();
        this.getDataSource().getLogger().debug(34, this, varName, value, type);
        XQItemProxy xQItemProxy = proxy = this.getStaticContext().getBindingMode() == 0 ? XQItemFactory.newXQItemProxy(XQItemFactory.newDocumentXQItem(XQItemFactory.newMemoryXMLXQItem(value), true)) : XQItemFactory.newXQItemProxy(XQItemFactory.newDocumentXQItem(XQItemFactory.newDeferredXMLXQItem(value), true));
        if (type == null) {
            type = XQItemTypeFactory.createDocumentElementType(XQItemTypeFactory.createElementType(null, 1));
        }
        if (!XQToolkit.isDocumentNode(type.getItemKind())) {
            this.throwNonDocumentException();
        }
        proxy.setItemType(type);
        this.bind(varName, proxy);
    }

    public void bindDocument(QName varName, Source value, XQItemType type) throws XQException {
        XQToolkit.nullValueTest(varName, "QName", "XQJDC030");
        XQToolkit.nullValueTest(value, "Source", "XQJDC031");
        this.checkIfClosed();
        this.getDataSource().getLogger().debug(35, this, varName, value, type);
        if (value instanceof DOMSource && this.getDataSource().getLogger().isWarnLoggable()) {
            this.getDataSource().getLogger().log(2, XQToolkit.formatMessage(84, this, varName, value, type));
        }
        XQItemProxy proxy = XQItemFactory.newXQItemProxy(this.getStaticContext().getBindingMode() == 0 ? XQItemFactory.newDocumentXQItem(XQItemFactory.newMemoryXMLXQItem(value), true) : XQItemFactory.newDocumentXQItem(XQItemFactory.newDeferredXMLXQItem(value), true));
        if (type == null) {
            type = XQItemTypeFactory.createDocumentElementType(XQItemTypeFactory.createElementType(null, 1));
        }
        if (!XQToolkit.isDocumentNode(type.getItemKind())) {
            this.throwNonDocumentException();
        }
        proxy.setItemType(type);
        this.bind(varName, proxy);
    }

    public void bindItem(QName varName, XQItem value) throws XQException {
        XQToolkit.nullValueTest(varName, "QName", "XQJDC032");
        XQToolkit.nullValueTest(value, "XQItem", "XQJDC033");
        this.checkIfClosed();
        this.getDataSource().getLogger().debug(36, this, varName, value);
        this.bind(varName, XQItemFactory.newXQItemProxy(ObjectToXQItemConverter.createXQItem(value, value.getItemType())));
    }

    public void bindSequence(QName varName, XQSequence value) throws XQException {
        XQToolkit.nullValueTest(varName, "QName", "XQJDC034");
        XQToolkit.nullValueTest(value, "XQSequence", "XQJDC035");
        this.checkIfClosed();
        this.getDataSource().getLogger().debug(122, this, varName, value);
        XQSequenceBase xqSequenceBase = null;
        xqSequenceBase = this.getStaticContext().getBindingMode() == 0 ? (value instanceof XQSequenceProxy && value.isScrollable() ? ((XQSequenceProxy)value).getSequenceBase() : XQSequenceFactory.newScrollableXQSequence(value)) : (value instanceof XQSequenceProxy ? ((XQSequenceProxy)value).getSequenceBase() : XQSequenceFactory.newScrollableXQSequence(value));
        if (!xqSequenceBase.isOnItem()) {
            xqSequenceBase.next();
        }
        this.bind(varName, XQSequenceFactory.newXQSequenceProxy(xqSequenceBase));
    }

    public TimeZone getImplicitTimeZone() throws XQException {
        this.checkIfClosed();
        this.getDataSource().getLogger().debug(124, this);
        return this.timezone;
    }

    public void setImplicitTimeZone(TimeZone implicitTimeZone) throws XQException {
        XQToolkit.nullValueTest(implicitTimeZone, "TimeZone", "XQJDC036");
        this.checkIfClosed();
        this.getDataSource().getLogger().debug(123, this, implicitTimeZone);
        this.timezone = implicitTimeZone;
    }

    protected void validateBinding(QName varName, XQItemProxy proxy) throws XQException {
        if (XQConstants.CONTEXT_ITEM.equals(varName)) {
            if (this.getStaticContext().getContextItemStaticType() == null) {
                return;
            }
            if (XQToolkit.isInstanceOf(this.getStaticContext().getContextItemStaticType(), proxy.getItemType())) {
                throw new XQExceptionImpl("Bound context item with type '" + String.valueOf(proxy.getItemType()) + "' is incompatible with the XQStaticContext's context item type '" + String.valueOf(this.getStaticContext().getContextItemStaticType()) + "', see XQJ 1.0 Spec - Section 4.3.4.", "XQJDC005");
            }
        }
    }

    protected void validateBinding(QName varName, XQSequenceProxy proxy) throws XQException {
    }

    protected void bind(QName varName, XQItemProxy proxy) throws XQException {
        this.validateBinding(varName, proxy);
        this.boundVariables.put(varName, proxy);
    }

    protected void bind(QName varName, XQSequenceProxy proxy) throws XQException {
        this.validateBinding(varName, proxy);
        this.boundVariables.put(varName, proxy);
    }

    protected void throwNonDocumentException() throws XQException {
        throw new XQExceptionImpl("XQItemKind is not of type of type XQITEMKIND_DOCUMENT_ELEMENT or XQITEMKIND_DOCUMENT_SCHEMA_ELEMENT", "XQJDC006");
    }

    public GenericXQDataSource getDataSource() throws XQException {
        return this.conn.getDataSource();
    }

    static final void writeObjectToXQuery(BasicQuery writer, Object object) throws XQException {
        if (object instanceof XQItemProxy) {
            ((XQItemProxy)object).writeItem(writer, Constants.WRITE_XQUERY_PROPERTIES);
        } else if (object instanceof XQSequenceProxy) {
            ((XQSequenceProxy)object).writeSequence(writer, Constants.WRITE_XQUERY_PROPERTIES);
        }
    }

    protected void resolveQuery(XQueryStatement queryStatement, BasicQuery outputQuery) throws XQException, IOException {
        Object contextItem;
        char[] originalQuery = queryStatement.getQuery();
        boolean isContextItemBound = this.boundVariables.containsKey(XQConstants.CONTEXT_ITEM);
        if (queryStatement.isStraightExpression() && ((XQStaticContextImpl)this.staticContext).isDefaultBehaviour() && !isContextItemBound) {
            outputQuery.write(originalQuery, 0, originalQuery.length);
            outputQuery.flush();
            return;
        }
        outputQuery.write(originalQuery, 0, queryStatement.getPrologStartIndex());
        int originalQueryPosition = queryStatement.getPrologStartIndex();
        outputQuery.write(this.getStaticContextProlog(queryStatement));
        if (isContextItemBound && queryStatement.isXQuery30() && !queryStatement.foundContextItemExternalDeclaration()) {
            contextItem = this.boundVariables.get(XQConstants.CONTEXT_ITEM);
            if (contextItem != null) {
                if (queryStatement.foundHardCodedContextItemDeclaration()) {
                    throw new XQExceptionImpl("expression defines context item with no external keyword, can not bind Java value.", "XQJDC038");
                }
                outputQuery.append("declare context item := ");
                XQDynamicContextImpl.writeObjectToXQuery(outputQuery, contextItem);
                outputQuery.write(59);
            }
        } else if (queryStatement.foundContextItem() && isContextItemBound && (contextItem = this.boundVariables.get(XQConstants.CONTEXT_ITEM)) != null) {
            outputQuery.append("declare variable $xqj:context-item := ");
            XQDynamicContextImpl.writeObjectToXQuery(outputQuery, contextItem);
            outputQuery.write(59);
        }
        Iterator tokenIter = queryStatement.getTokensInOrder();
        while (tokenIter.hasNext()) {
            Object object;
            XQueryToken token = (XQueryToken)tokenIter.next();
            if (token.getTokenType() == 1) {
                ExternalVariable ev = (ExternalVariable)token;
                object = this.boundVariables.get(ev.getQName());
                if (object != null) {
                    outputQuery.write(originalQuery, originalQueryPosition, ev.getBeginIndex() - originalQueryPosition);
                    outputQuery.write(":=");
                    XQDynamicContextImpl.writeObjectToXQuery(outputQuery, object);
                    originalQueryPosition = ev.getEndIndex();
                    continue;
                }
                if (!ev.hasDefaultValue()) {
                    throw new XQExceptionImpl("expression declared external variable " + String.valueOf(ev.getQName()) + " but no value was bound.", "err:XPDY0002");
                }
                outputQuery.write(originalQuery, originalQueryPosition, ev.getEndIndex() - originalQueryPosition);
                originalQueryPosition = ev.getEndIndex();
                continue;
            }
            if (token.getTokenType() == 2 && isContextItemBound) {
                Context ci = (Context)token;
                outputQuery.write(originalQuery, originalQueryPosition, ci.getBeginIndex() - originalQueryPosition);
                outputQuery.write("$xqj:context-item");
                originalQueryPosition = ci.getEndIndex();
                continue;
            }
            if (token.getTokenType() != 3 || !isContextItemBound) continue;
            ExternalContextItem eci = (ExternalContextItem)token;
            object = this.boundVariables.get(XQConstants.CONTEXT_ITEM);
            if (object != null) {
                outputQuery.write(originalQuery, originalQueryPosition, eci.getBeginIndex() - originalQueryPosition);
                outputQuery.write(":=");
                XQDynamicContextImpl.writeObjectToXQuery(outputQuery, object);
                originalQueryPosition = eci.getEndIndex();
                continue;
            }
            if (!eci.hasDefaultValue()) {
                throw new XQExceptionImpl("expression declares an external context item, but no value was bound.", "err:XPDY0002");
            }
            outputQuery.write(originalQuery, originalQueryPosition, eci.getEndIndex() - originalQueryPosition);
            originalQueryPosition = eci.getEndIndex();
        }
        outputQuery.write(originalQuery, originalQueryPosition, originalQuery.length - originalQueryPosition);
        outputQuery.flush();
    }

    protected char[] getStaticContextProlog(XQueryStatement queryStatement) throws XQException {
        if (this.getStaticContext() instanceof XQStaticContextImpl && ((XQStaticContextImpl)this.getStaticContext()).isDefaultBehaviour() && !queryStatement.foundContextItem()) {
            return new char[0];
        }
        try {
            CharArrayWriter prologWriter = new CharArrayWriter();
            String[] staticPrefixes = this.getStaticContext().getNamespacePrefixes();
            String[] dynamicPrefixes = queryStatement.getNamespacePrefixes();
            int i = 0;
            while (i < staticPrefixes.length) {
                block16: {
                    int n = 0;
                    while (n < dynamicPrefixes.length) {
                        if (!staticPrefixes[i].equals(dynamicPrefixes[n])) {
                            ++n;
                            continue;
                        }
                        break block16;
                    }
                    prologWriter.append("declare namespace ");
                    prologWriter.append(staticPrefixes[i]);
                    prologWriter.append('=');
                    prologWriter.append(XQToolkit.getInQuotes(this.getStaticContext().getNamespaceURI(staticPrefixes[i])));
                    prologWriter.append(';');
                }
                ++i;
            }
            if (queryStatement.foundContextItem() && this.boundVariables.containsKey(XQConstants.CONTEXT_ITEM) && !queryStatement.isXQuery30()) {
                prologWriter.append("declare namespace xqj = \"http://xqj.jcp.org\";");
            }
            if (!queryStatement.foundBaseUri() && !"".equals(this.getStaticContext().getBaseURI())) {
                prologWriter.append("declare base-uri ");
                prologWriter.append(XQToolkit.getInQuotes(this.getStaticContext().getBaseURI()));
                prologWriter.append(';');
            }
            if (!queryStatement.foundDefaultCollation() && !"http://www.w3.org/2005/xpath-functions/collation/codepoint".equals(this.getStaticContext().getDefaultCollation())) {
                prologWriter.append("declare default collation ");
                prologWriter.append(XQToolkit.getInQuotes(this.getStaticContext().getDefaultCollation()));
                prologWriter.append(';');
            }
            if (!queryStatement.foundDefaultElementTypeNamespace() && !"".equals(this.getStaticContext().getDefaultElementTypeNamespace())) {
                prologWriter.append("declare default element namespace ");
                prologWriter.append(XQToolkit.getInQuotes(this.getStaticContext().getDefaultElementTypeNamespace()));
                prologWriter.append(';');
            }
            if (!queryStatement.foundDefaultFunctionNamespace() && !"http://www.w3.org/2005/xpath-functions".equals(this.getStaticContext().getDefaultFunctionNamespace())) {
                prologWriter.append("declare default function namespace ");
                prologWriter.append(XQToolkit.getInQuotes(this.getStaticContext().getDefaultFunctionNamespace()));
                prologWriter.append(';');
            }
            if (!queryStatement.foundBoundarySpacePolicy() && 1 != this.getStaticContext().getBoundarySpacePolicy()) {
                prologWriter.append("declare boundary-space ");
                prologWriter.append(this.getStaticContext().getBoundarySpacePolicy() == 1 ? "preserve" : "strip");
                prologWriter.append(';');
            }
            if (!queryStatement.foundConstructionMode() && 1 != this.getStaticContext().getConstructionMode()) {
                prologWriter.append("declare boundary-space ");
                prologWriter.append(this.getStaticContext().getConstructionMode() == 1 ? "preserve" : "strip");
                prologWriter.append(';');
            }
            if (!(queryStatement.foundCopyNamespaces() || 2 == this.getStaticContext().getCopyNamespacesModePreserve() && 2 == this.getStaticContext().getCopyNamespacesModeInherit())) {
                prologWriter.append("declare copy-namespaces ");
                prologWriter.append(this.getStaticContext().getCopyNamespacesModePreserve() == 1 ? "preserve" : "no-preserve");
                prologWriter.append(", ");
                prologWriter.append(this.getStaticContext().getCopyNamespacesModeInherit() == 1 ? "inherit" : "no-inherit");
                prologWriter.append(';');
            }
            if (!queryStatement.foundDefaultOrderForEmptySequences() && 1 != this.getStaticContext().getDefaultOrderForEmptySequences()) {
                prologWriter.append("declare default order empty ");
                prologWriter.append(this.getStaticContext().getDefaultOrderForEmptySequences() == 1 ? "greatest" : "least");
                prologWriter.append(';');
            }
            if (!queryStatement.foundOrderingMode() && 1 != this.getStaticContext().getOrderingMode()) {
                prologWriter.append("declare ordering ");
                prologWriter.append(this.getStaticContext().getOrderingMode() == 1 ? "ordered" : "unordered");
                prologWriter.append(';');
            }
            return prologWriter.toCharArray();
        }
        catch (IOException e) {
            throw new XQExceptionImpl("IOException occurred whilst trying to resolve XQStaticContext into XQuery prolog.", "XQJDC004", e);
        }
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public GenericXQConnection getConnection() throws XQException {
        return this.conn;
    }

    public void close() throws XQException {
        if (this.conn.getDataSource().getLogger().isDebugLoggable()) {
            this.conn.getDataSource().getLogger().log(4, XQToolkit.formatMessage(13, this.toString()));
        }
        this.isClosed = true;
        XQResultSequenceProxy resultSequence = this.getResultSequenceProxy();
        if (resultSequence != null) {
            resultSequence.close();
        }
    }

    public XQStaticContext getStaticContext() throws XQException {
        this.checkIfClosed();
        return this.staticContext;
    }

    public void cancel() throws XQException {
        if (this.conn.getDataSource().getLogger().isInfoLoggable()) {
            this.conn.getDataSource().getLogger().log(3, XQToolkit.formatMessage(12, this.toString()));
        }
        this.checkIfClosed();
    }

    protected XQResultSequenceProxy executeQuery(BasicConnection bc, BasicQuery query) throws XQException {
        try {
            BasicResultSequence rs = bc.executeQuery(query);
            XQResultSequenceProxy oldProxy = this.getResultSequenceProxy();
            if (oldProxy != null) {
                oldProxy.makeObsolete();
            }
            XQResultSequenceProxy newProxy = null;
            newProxy = oldProxy != null ? (XQResultSequenceProxy)oldProxy.clone() : XQSequenceFactory.newXQResultSequenceProxy();
            BasicResultSequenceIterator iter = this.getXQItemBaseIterator();
            if (iter == null) {
                iter = new BasicResultSequenceIterator(this.conn);
                this.setXQItemBaseIterator(iter);
            }
            iter.reset(rs);
            XQSequenceBase base = this.staticContext.getScrollability() == 2 ? this.getScrollableSequence() : this.getForwardOnlySequence();
            base.reset(iter);
            newProxy.reset(base, false, this.getConnection());
            oldProxy = null;
            this.setResultSequenceProxy(newProxy);
            XQResultSequenceProxy xQResultSequenceProxy = newProxy;
            return xQResultSequenceProxy;
        }
        catch (XQException e) {
            throw e;
        }
        finally {
            this.queryFinishedTrigger();
        }
    }

    protected void queryFinishedTrigger() throws XQException {
        if (this.staticContext.getBindingMode() == 1) {
            this.boundVariables.clear();
        }
        this.conn.setNeedsToCommit();
    }

    public XQResultSequenceProxy getResultSequenceProxy() {
        return this.conn.getResultSequenceProxy();
    }

    public void setResultSequenceProxy(XQResultSequenceProxy resultSequenceProxy) {
        this.conn.setResultSequenceProxy(resultSequenceProxy);
    }

    public ForwardOnlyXQSequence getForwardOnlySequence() throws XQException {
        ForwardOnlyXQSequence sequence = this.conn.getForwardOnlySequence();
        if (sequence == null) {
            sequence = XQSequenceFactory.newForwardOnlyXQSequence();
            this.conn.setForwardOnlySequence(sequence);
        }
        return sequence;
    }

    public void setForwardOnlySequence(ForwardOnlyXQSequence forwardOnlySequence) {
        this.conn.setForwardOnlySequence(forwardOnlySequence);
    }

    public ScrollableXQSequence getScrollableSequence() throws XQException {
        ScrollableXQSequence sequence = this.conn.getScrollableSequence();
        if (sequence == null) {
            sequence = XQSequenceFactory.newScrollableXQSequence();
            this.conn.setScrollableSequence(sequence);
        }
        return sequence;
    }

    public void setScrollableSequence(ScrollableXQSequence scrollableSequence) {
        this.conn.setScrollableSequence(scrollableSequence);
    }

    public BasicResultSequenceIterator getXQItemBaseIterator() {
        return this.conn.getXQItemBaseIterator();
    }

    public void setXQItemBaseIterator(BasicResultSequenceIterator xqItemIterator) {
        this.conn.setXQItemBaseIterator(xqItemIterator);
    }

    public void checkIfClosed() throws XQException {
        if (this.isClosed()) {
            throw new XQExceptionImpl(this.toString() + " is closed.", "XQJDC037");
        }
    }
}

