/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.util.parse;

import org.basex.query.QueryContext;
import org.basex.query.expr.Expr;
import org.basex.query.util.hash.QNmMap;
import org.basex.query.util.list.AnnList;
import org.basex.query.util.list.ExprList;
import org.basex.query.value.item.QNm;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.type.SeqType;
import org.basex.query.var.Var;
import org.basex.query.var.VarRef;
import org.basex.query.var.VarScope;
import org.basex.util.InputInfo;

public final class FuncBuilder {
    public final InputInfo info;
    public QNmMap<Expr> keywords;
    public int placeholders;
    public int arity;
    public AnnList anns = AnnList.EMPTY;
    public Var[] params;
    public VarScope vs;
    public boolean runtime;
    private final ExprList args;

    public FuncBuilder(InputInfo info) {
        this(info, new ExprList(4L));
    }

    public FuncBuilder(InputInfo info, ExprList args) {
        this.info = info;
        this.args = args;
    }

    public FuncBuilder(InputInfo info, Expr[] args, QNmMap<Expr> kw) {
        this(info, new ExprList(args));
        this.keywords = kw;
    }

    public FuncBuilder(InputInfo info, int a, boolean rt) {
        this(info, new ExprList(a));
        this.params = new Var[a];
        this.vs = new VarScope();
        this.runtime = rt;
    }

    public boolean add(Expr arg, QNm name) {
        boolean duplicate = false;
        if (name != null) {
            if (this.keywords == null) {
                this.keywords = new QNmMap();
            } else {
                duplicate = this.keywords.contains(name);
            }
            this.keywords.put(name, arg);
        } else {
            this.args.add(arg);
        }
        if (arg == Empty.UNDEFINED) {
            ++this.placeholders;
        }
        ++this.arity;
        return duplicate;
    }

    public void add(QNm name, SeqType st, QueryContext qc) {
        Var var;
        this.params[this.arity] = var = this.vs.addNew(name, st, qc, this.info);
        this.add(new VarRef(this.info, var), null);
    }

    public Expr[] args() {
        return this.params != null ? (Expr[])this.args.list : (Expr[])this.args.toArray();
    }
}

