/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.map;

import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.func.Function;
import org.basex.query.func.StandardFunc;
import org.basex.query.func.map.MapCompilation;
import org.basex.query.value.Value;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.Itr;
import org.basex.query.value.map.XQMap;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.MapType;
import org.basex.util.InputInfo;

public final class MapPut
extends StandardFunc {
    @Override
    public XQMap item(QueryContext qc, InputInfo ii) throws QueryException {
        XQMap map = this.toMap(this.arg(0), qc);
        Item key = this.toAtomItem(this.arg(1), qc);
        Value value = this.arg(2).value(qc);
        return map.put(key, value);
    }

    @Override
    protected Expr opt(CompileContext cc) throws QueryException {
        AtomType akt;
        Expr map = this.arg(0);
        Expr key = this.arg(1);
        Expr value = this.arg(2);
        if (map == XQMap.empty()) {
            return cc.function(Function._MAP_ENTRY, this.info, key, value);
        }
        MapType type = null;
        MapCompilation mc = MapCompilation.get(map).key(key);
        if (mc.key != null) {
            if (mc.field != null) {
                if (!mc.record.hasOptional()) {
                    return cc.function(Function._UTIL_MAP_PUT_AT, this.info, map, Itr.get(mc.index.intValue()), value);
                }
                if (value.seqType().instanceOf(mc.field.seqType())) {
                    type = mc.record;
                }
            } else if (mc.record.isExtensible()) {
                type = mc.record;
            }
        }
        if (type == null && mc.mapType != null && (akt = key.seqType().type.atomic()) != null) {
            type = mc.mapType.union(akt, value.seqType());
        }
        if (type != null) {
            this.exprType.assign(type);
        }
        return this;
    }
}

