/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.file;

import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.function.BiConsumer;
import java.util.regex.Pattern;
import org.basex.io.IOFile;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.func.file.FileFn;
import org.basex.query.value.Value;
import org.basex.query.value.seq.StrSeq;
import org.basex.util.Prop;
import org.basex.util.Util;
import org.basex.util.list.TokenList;

public class FileList
extends FileFn {
    @Override
    public Value eval(QueryContext qc) throws QueryException, IOException {
        Path dir = this.toPath(this.arg(0), qc).toRealPath(new LinkOption[0]);
        boolean recursive = this.toBooleanOrFalse(this.arg(1), qc);
        String pattern = this.toStringOrNull(this.arg(2), qc);
        Pattern pttrn = pattern == null ? null : Pattern.compile(IOFile.regex(pattern, false), Prop.CASE ? 0 : 2);
        TokenList tl = new TokenList();
        FileList.list(dir, recursive, pttrn, tl, dir.getNameCount(), qc);
        return StrSeq.get(tl);
    }

    Value paths(boolean recursive, QueryContext qc) throws QueryException, IOException {
        TokenList tl = new TokenList();
        FileList.list(this.toPath(this.arg(0), qc), recursive, null, tl, -1, qc);
        return StrSeq.get(tl);
    }

    private static void list(Path root, boolean recursive, Pattern pattern, TokenList list, int index, QueryContext qc) throws IOException {
        ArrayList files;
        ArrayList<Path> dirs;
        BiConsumer<Path, Boolean> add;
        block11: {
            add = (child, dir) -> {
                if (pattern == null || pattern.matcher(child.getFileName().toString()).matches()) {
                    Path path = index < 0 ? child : child.subpath(index, child.getNameCount());
                    list.add(FileList.get(path, dir).string());
                }
            };
            dirs = new ArrayList<Path>();
            files = new ArrayList();
            try (DirectoryStream<Path> paths = Files.newDirectoryStream(root);){
                for (Path path : paths) {
                    qc.checkStop();
                    (Files.isDirectory(path, new LinkOption[0]) ? dirs : files).add(path);
                }
            }
            catch (IOException ex) {
                if (index != -1 && index != root.getNameCount()) break block11;
                Util.debug(ex);
                throw ex;
            }
        }
        for (Path dir2 : dirs) {
            add.accept(dir2, true);
            if (!recursive || Files.isSymbolicLink(dir2)) continue;
            FileList.list(dir2, true, pattern, list, index == -1 ? -2 : index, qc);
        }
        for (Path file : files) {
            add.accept(file, false);
        }
    }
}

