/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.bin;

import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.func.bin.BinFn;
import org.basex.query.value.item.B64;
import org.basex.query.value.item.Item;
import org.basex.query.value.seq.Empty;
import org.basex.util.InputInfo;
import org.basex.util.TokenBuilder;
import org.basex.util.hash.IntObjectMap;

public final class BinOctal
extends BinFn {
    private static final IntObjectMap<String> MAP = new IntObjectMap(8L);

    @Override
    public Item item(QueryContext qc, InputInfo ii) throws QueryException {
        byte[] string = this.toDigits(qc);
        if (string == null) {
            return Empty.VALUE;
        }
        int tl = string.length;
        if (tl == 0) {
            return B64.EMPTY;
        }
        TokenBuilder tb = new TokenBuilder((long)tl * 3L);
        for (byte b : string) {
            String bits = MAP.get(b);
            if (bits != null) {
                tb.add(bits);
                continue;
            }
            tb.addByte(b);
        }
        if (tb.get(0) == 48 && tb.get(1) == 48) {
            tb.delete(0, 2);
        }
        return B64.get(this.binary2bytes(tb.finish()));
    }

    static {
        MAP.put(48, "000");
        MAP.put(49, "001");
        MAP.put(50, "010");
        MAP.put(51, "011");
        MAP.put(52, "100");
        MAP.put(53, "101");
        MAP.put(54, "110");
        MAP.put(55, "111");
    }
}

