/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr;

import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryFunction;
import org.basex.query.QueryPlan;
import org.basex.query.QueryString;
import org.basex.query.QuerySupplier;
import org.basex.query.expr.Arr;
import org.basex.query.expr.CmpG;
import org.basex.query.expr.CmpPos;
import org.basex.query.expr.CmpV;
import org.basex.query.expr.Expr;
import org.basex.query.expr.ExprInfo;
import org.basex.query.expr.IntPos;
import org.basex.query.func.Function;
import org.basex.query.util.Flag;
import org.basex.query.value.Value;
import org.basex.query.value.item.ANum;
import org.basex.query.value.item.Bln;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.Itr;
import org.basex.query.value.node.FBuilder;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.seq.RangeSeq;
import org.basex.query.value.type.Types;
import org.basex.query.var.Var;
import org.basex.util.InputInfo;
import org.basex.util.hash.IntObjectMap;

final class SimplePos
extends Arr
implements CmpPos {
    SimplePos(InputInfo info, Expr ... exprs) {
        super(info, Types.BOOLEAN_O, exprs);
    }

    public static Expr get(Expr min, Expr max, InputInfo info) {
        return max == null || min.equals(max) ? new SimplePos(info, min) : new SimplePos(info, min, max);
    }

    @Override
    public Expr optimize(CompileContext cc) throws QueryException {
        Expr expr2;
        this.exprs = this.simplifyAll(CompileContext.Simplify.NUMBER, cc);
        QueryFunction<Expr, Expr> simplify = expr -> {
            long p;
            ANum num;
            if (expr instanceof ANum && !((num = (ANum)expr) instanceof Itr) && (double)(p = num.itr()) == num.dbl()) {
                return Itr.get(p);
            }
            return expr;
        };
        this.exprs[0] = simplify.apply(this.exprs[0]);
        Expr ex = null;
        if (this.exact()) {
            ex = this.exprs[0].optimizePos(CmpV.OpV.EQ, cc);
            if (!(ex instanceof Bln)) {
                ex = null;
            }
        } else {
            this.exprs[1] = simplify.apply(this.exprs[1]);
        }
        if (ex == null && (expr2 = this.exprs[0]) instanceof Itr) {
            Itr itr1 = (Itr)expr2;
            long mn = itr1.itr();
            if (this.exact()) {
                ex = IntPos.get(mn, mn, this.info);
            } else {
                Expr expr3 = this.exprs[1];
                if (expr3 instanceof Itr) {
                    Itr itr2 = (Itr)expr3;
                    ex = IntPos.get(mn, itr2.itr(), this.info);
                }
            }
        }
        return ex != null ? cc.replaceWith(this, ex) : this;
    }

    @Override
    public Bln item(QueryContext qc, InputInfo ii) throws QueryException {
        return Bln.get(this.test(qc, ii, 0L));
    }

    @Override
    public boolean test(QueryContext qc, InputInfo ii, long pos) throws QueryException {
        this.ctxValue(qc);
        Item min = this.exprs[0].atomItem(qc, this.info);
        if (min.isEmpty()) {
            return false;
        }
        long p = qc.focus.pos;
        if (this.exact()) {
            return (double)p == this.toDouble(min);
        }
        Item max = this.exprs[1].atomItem(qc, this.info);
        if (max.isEmpty()) {
            return false;
        }
        return (double)p >= this.toDouble(min) && (double)p <= this.toDouble(max);
    }

    @Override
    public Value positions(QueryContext qc) throws QueryException {
        Item max;
        Item min = this.exprs[0].atomItem(qc, this.info);
        if (min.isEmpty()) {
            return Empty.VALUE;
        }
        Item item = max = this.exact() ? min : this.exprs[1].atomItem(qc, this.info);
        if (max.isEmpty()) {
            return Empty.VALUE;
        }
        long mn = (long)Math.ceil(this.toDouble(min));
        long mx = (long)Math.floor(this.toDouble(max));
        return RangeSeq.get(mn, mx - mn + 1L, true);
    }

    @Override
    public SimplePos copy(CompileContext cc, IntObjectMap<Var> vm) {
        return this.copyType(new SimplePos(this.info, SimplePos.copyAll((CompileContext)cc, vm, (Expr[])this.exprs)));
    }

    @Override
    public Expr mergeEbv(Expr ex, boolean or, CompileContext cc) throws QueryException {
        if (!or && ex instanceof SimplePos) {
            Expr max;
            Expr min;
            Expr pexpr2;
            SimplePos pos = (SimplePos)ex;
            Expr expr1 = this.exprs[0];
            Expr expr2 = this.exact() ? expr1 : this.exprs[1];
            Expr pexpr1 = pos.exprs[0];
            Expr expr = pexpr2 = pos.exact() ? pexpr1 : pos.exprs[1];
            Expr expr3 = expr1 == Itr.ONE ? pexpr1 : (min = pexpr1 == Itr.ONE ? expr1 : null);
            Expr expr4 = expr2 == Itr.MAX ? pexpr2 : (max = pexpr2 == Itr.MAX ? expr2 : null);
            if (min != null && max != null) {
                return SimplePos.get(min, max, this.info).optimize(cc);
            }
            if (this.exact() && (expr1.equals(pexpr1) || expr1.equals(pexpr2))) {
                return this;
            }
            if (pos.exact() && (pexpr1.equals(expr1) || pexpr2.equals(expr2))) {
                return pos;
            }
        }
        return null;
    }

    @Override
    public Expr invert(CompileContext cc) throws QueryException {
        if (this.exprs[0].seqType().one()) {
            QuerySupplier<Expr> pos = () -> cc.function(Function.POSITION, this.info, new Expr[0]);
            if (this.exact()) {
                return new CmpG(this.info, pos.get(), this.exprs[0], CmpG.OpG.NE).optimize(cc);
            }
            if (this.exprs[0] == Itr.ONE) {
                return new CmpG(this.info, pos.get(), this.exprs[1], CmpG.OpG.GT).optimize(cc);
            }
            if (this.exprs[1] == Itr.MAX) {
                return new CmpG(this.info, pos.get(), this.exprs[0], CmpG.OpG.LT).optimize(cc);
            }
        }
        return null;
    }

    @Override
    public boolean exact() {
        return this.exprs.length == 1;
    }

    @Override
    public boolean has(Flag ... flags) {
        return Flag.POS.oneOf(flags) || Flag.CTX.oneOf(flags) || super.has(flags);
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj || obj instanceof SimplePos && super.equals(obj);
    }

    @Override
    public String description() {
        return "positional access";
    }

    @Override
    public void toXml(QueryPlan plan) {
        ExprInfo[] exprInfoArray;
        FBuilder fBuilder = plan.create(this, new Object[0]);
        if (this.exact()) {
            Expr[] exprArray = new Expr[1];
            exprInfoArray = exprArray;
            exprArray[0] = this.exprs[0];
        } else {
            exprInfoArray = this.exprs;
        }
        plan.add(fBuilder, exprInfoArray);
    }

    @Override
    public void toString(QueryString qs) {
        qs.function(Function.POSITION, new Object[0]).token("=").token(this.exprs[0]);
        if (!this.exact()) {
            qs.token("to").token(this.exprs[1]);
        }
    }
}

