/*
 * Decompiled with CFR 0.152.
 */
package org.basex.core.cmd;

import java.io.IOException;
import org.basex.core.Text;
import org.basex.core.cmd.ACreate;
import org.basex.core.parse.CmdBuilder;
import org.basex.core.parse.Commands;
import org.basex.core.users.Perm;
import org.basex.data.Data;
import org.basex.index.IndexType;

public final class DropIndex
extends ACreate {
    public DropIndex(Object type) {
        super(Perm.WRITE, true, type.toString());
    }

    @Override
    protected boolean run() {
        IndexType type;
        Data data = this.context.data();
        Commands.CmdIndex ci = this.getOption(Commands.CmdIndex.class);
        if (ci == Commands.CmdIndex.TEXT) {
            type = IndexType.TEXT;
            data.meta.createtext = false;
        } else if (ci == Commands.CmdIndex.ATTRIBUTE) {
            type = IndexType.ATTRIBUTE;
            data.meta.createattr = false;
        } else if (ci == Commands.CmdIndex.TOKEN) {
            type = IndexType.TOKEN;
            data.meta.createtoken = false;
        } else if (ci == Commands.CmdIndex.FULLTEXT) {
            type = IndexType.FULLTEXT;
            data.meta.createft = false;
        } else {
            return this.error(Text.UNKNOWN_CMD_X, this);
        }
        data.meta.names(type, this.options);
        return this.update(data, () -> {
            DropIndex.drop(type, data);
            return this.info(Text.INDEX_DROPPED_X_X, new Object[]{type, this.jc().performance});
        });
    }

    @Override
    public void build(CmdBuilder cb) {
        cb.init(String.valueOf((Object)Commands.Cmd.DROP) + " " + String.valueOf((Object)Commands.CmdDrop.INDEX)).args();
    }

    static void drop(IndexType type, Data data) throws IOException {
        data.meta.dirty = true;
        data.meta.index(type, false);
        data.dropIndex(type);
    }
}

