/*
 * Decompiled with CFR 0.152.
 */
package de.bottlecaps.markup;

import de.bottlecaps.markup.BlitzException;
import de.bottlecaps.markup.blitz.Parser;
import de.bottlecaps.markup.blitz.grammar.Grammar;
import de.bottlecaps.markup.blitz.grammar.Ixml;
import de.bottlecaps.markup.blitz.transform.BNF;
import de.bottlecaps.markup.blitz.transform.Generator;
import de.bottlecaps.markup.blitz.xml.XmlGrammarInput;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.Set;

public class Blitz {
    public static final String IXML_GRAMMAR_RESOURCE = "de/bottlecaps/markup/blitz/ixml.ixml";

    public static Parser generate(String grammar, Option ... blitzOptions) throws BlitzException {
        long t0 = 0L;
        long t1 = 0L;
        long t2 = 0L;
        long t3 = 0L;
        Set<Option> options = Set.of(blitzOptions);
        boolean timing = options.contains((Object)Option.TIMING);
        if (timing) {
            t0 = System.currentTimeMillis();
        }
        Grammar tree = Ixml.parse(grammar);
        if (timing) {
            t1 = System.currentTimeMillis();
        }
        Grammar bnf = BNF.process(tree, options);
        if (timing) {
            t2 = System.currentTimeMillis();
        }
        Parser parser = Generator.generate(bnf, options);
        if (timing) {
            t3 = System.currentTimeMillis();
            System.err.println("             parsing time: " + (t1 - t0) + " msec");
            System.err.println("  BNF transformation time: " + (t2 - t1) + " msec");
            System.err.println("LALR(1) construction time: " + (t3 - t2) + " msec");
        }
        return parser;
    }

    public static Parser generateFromXml(InputStream xml, Option ... blitzOptions) throws BlitzException {
        return Blitz.generate(new XmlGrammarInput(xml).toIxml(), blitzOptions);
    }

    public static Parser generateFromXml(String xml, Option ... blitzOptions) throws BlitzException {
        return Blitz.generate(new XmlGrammarInput(xml).toIxml(), blitzOptions);
    }

    public static void main(String[] args) throws IOException {
        int i;
        System.setOut(new PrintStream((OutputStream)System.out, true, StandardCharsets.UTF_8));
        System.setErr(new PrintStream((OutputStream)System.err, true, StandardCharsets.UTF_8));
        HashSet<Option> options = new HashSet<Option>();
        for (i = 0; i < args.length; ++i) {
            if (args[i].equals("--indent")) {
                options.add(Option.INDENT);
                continue;
            }
            if (args[i].equals("--trace")) {
                options.add(Option.TRACE);
                continue;
            }
            if (args[i].equals("--fail-on-error")) {
                options.add(Option.FAIL_ON_ERROR);
                continue;
            }
            if (args[i].equals("--timing")) {
                options.add(Option.TIMING);
                continue;
            }
            if (args[i].equals("--verbose")) {
                options.add(Option.VERBOSE);
                continue;
            }
            if (!args[i].startsWith("-")) break;
            Blitz.usage(1);
        }
        if (i != args.length - 2 && i != args.length - 1) {
            Blitz.usage(1);
        }
        Object grammar = i == args.length - 1 ? "!" + Blitz.ixmlGrammar() : args[i];
        String input = args[args.length - 1];
        String grammarString = ((String)grammar).startsWith("!") ? ((String)grammar).substring(1) : Blitz.urlContent(Blitz.url((String)grammar));
        Parser parser = Blitz.generate(grammarString, (Option[])options.toArray(Option[]::new));
        String inputString = input.startsWith("!") ? input.substring(1) : Blitz.urlContent(Blitz.url(input));
        String result = parser.parse(inputString, new Option[0]);
        System.out.print("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
        if (options.contains((Object)Option.INDENT)) {
            System.out.println();
        }
        System.out.print(result);
    }

    private static void usage(int exitCode) {
        String resource = Blitz.class.getResource("/" + Blitz.class.getName().replace('.', '/') + ".class").toString();
        String origin = resource.startsWith("jar:") ? "-jar " + resource.replaceFirst("^.*/([^/]+.jar)!.*$", "$1") : Blitz.class.getName();
        System.err.println("Markup Blitz - Invisible XML processor");
        System.err.println();
        System.err.println("  version 1.10");
        System.err.println("  built Nov 07, 2025");
        System.err.println();
        System.err.println("Usage: java " + origin + " [<OPTION>...] [<GRAMMAR>] <INPUT>");
        System.err.println();
        System.err.println("  Compile an Invisible XML grammar, and parse input with the resulting parser.");
        System.err.println();
        System.err.println("  <GRAMMAR>          the grammar (literal, file name or URL), in ixml notation.");
        System.err.println("                     When omitted, the ixml grammar will be used.");
        System.err.println("  <INPUT>            the input (literal, file name or URL).");
        System.err.println();
        System.err.println("  <OPTION>:");
        System.err.println("    --indent         generate resulting xml with indentation.");
        System.err.println("    --trace          print parser trace.");
        System.err.println("    --fail-on-error  throw an exception instead of returning an error document.");
        System.err.println("    --timing         print timing information.");
        System.err.println("    --verbose        print intermediate results.");
        System.err.println();
        System.err.println("  A literal grammar or input must be preceded by an exclamation point (!).");
        System.err.println("  All inputs must be presented in UTF-8 encoding, and output is written in");
        System.err.println("  UTF-8 as well. Resulting XML goes to standard output, all diagnostics go");
        System.err.println("  to standard error.");
        System.err.println();
        System.exit(exitCode);
    }

    public static String urlContent(URL url) throws IOException {
        String input;
        try (InputStream in = url.openStream();){
            input = new String(in.readAllBytes(), StandardCharsets.UTF_8);
        }
        return input.replaceFirst("^\ufeff", "");
    }

    public static String normalizeEol(String input) {
        return input.replace("\r\n", "\n").replace("\r", "\n");
    }

    public static URL url(String input) {
        URI uri = null;
        try {
            File file = new File(input);
            if (file.exists()) {
                uri = file.toURI();
            }
        }
        catch (Exception file) {
            // empty catch block
        }
        try {
            if (uri == null) {
                uri = new URI(input);
            }
            return uri.toURL();
        }
        catch (Exception e) {
            throw new BlitzException("Failed to process URL: " + input, e);
        }
    }

    public static String ixmlGrammar() {
        try {
            String grammar = Blitz.urlContent(Blitz.class.getClassLoader().getResource(IXML_GRAMMAR_RESOURCE));
            return Blitz.normalizeEol(grammar);
        }
        catch (IOException e) {
            throw new BlitzException("Failed to access ixml grammar resource de/bottlecaps/markup/blitz/ixml.ixml", e);
        }
    }

    public static enum Option {
        INDENT,
        TRACE,
        FAIL_ON_ERROR,
        TIMING,
        VERBOSE;

    }
}

