/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.htmlparser.extra;

import com.ibm.icu.text.CharsetDetector;
import com.ibm.icu.text.CharsetMatch;
import java.io.IOException;
import java.io.InputStream;
import nu.validator.htmlparser.common.ByteReadable;
import nu.validator.htmlparser.io.Encoding;

public class IcuDetectorSniffer
extends InputStream {
    private final ByteReadable source;

    public IcuDetectorSniffer(ByteReadable source) {
        this.source = source;
    }

    @Override
    public int read() throws IOException {
        return this.source.readByte();
    }

    public Encoding sniff() throws IOException {
        try {
            CharsetDetector detector = new CharsetDetector();
            detector.setText((InputStream)this);
            CharsetMatch match = detector.detect();
            Encoding enc = Encoding.forName(match.getName());
            Encoding actual = enc.getActualHtmlEncoding();
            if (actual != null) {
                enc = actual;
            }
            if (enc != Encoding.WINDOWS1252 && enc.isAsciiSuperset()) {
                return enc;
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static void main(String[] args) {
        String[] detectable = CharsetDetector.getAllDetectableCharsets();
        for (int i = 0; i < detectable.length; ++i) {
            String charset = detectable[i];
            System.out.println(charset);
        }
    }
}

