/*
 * Decompiled with CFR 0.152.
 */
package org.basex.core.locks;

import java.util.Iterator;
import org.basex.util.Strings;
import org.basex.util.list.StringList;

public final class LockList
implements Iterable<String> {
    private final StringList list = new StringList(0L);
    private boolean global;

    public LockList add(String lock) {
        if (!this.global) {
            this.list.addUnique(lock);
        }
        return this;
    }

    public boolean local() {
        return !this.list.isEmpty();
    }

    public void addGlobal() {
        this.global = true;
        this.list.reset();
    }

    public void reset() {
        this.global = false;
        this.list.reset();
    }

    public boolean global() {
        return this.global;
    }

    public boolean locking() {
        return this.global() || this.local();
    }

    public void add(LockList locks) {
        if (!this.global) {
            if (locks.global) {
                this.addGlobal();
            } else {
                for (String lock : locks.list) {
                    this.list.addUnique(lock);
                }
            }
        }
    }

    public void remove(LockList locks) {
        this.list.removeAll(locks.list);
    }

    public String get(int index) {
        return (String)this.list.get(index);
    }

    public boolean contains(String lock) {
        return this.list.contains(lock);
    }

    public int size() {
        return this.list.size();
    }

    public void finish(String name) {
        for (int l = 0; l < this.list.size(); ++l) {
            String lock = (String)this.list.get(l);
            if (!Strings.eq(lock, "internal:collection", "internal:context")) continue;
            if (name != null) {
                this.list.set(l, name);
                continue;
            }
            this.list.remove(l--);
        }
        this.list.sort();
    }

    @Override
    public Iterator<String> iterator() {
        return this.list.iterator();
    }

    public String toString() {
        return this.global ? "(global)" : (this.list.isEmpty() ? "(none)" : String.join((CharSequence)",", (CharSequence[])this.list.toArray()));
    }
}

