/*
 * Decompiled with CFR 0.152.
 */
package org.asciidoctor.cli;

import com.beust.jcommander.Parameter;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import org.asciidoctor.Attributes;
import org.asciidoctor.AttributesBuilder;
import org.asciidoctor.SafeMode;
import org.asciidoctor.cli.SafeModeConverter;
import org.asciidoctor.cli.SeverityConverter;
import org.asciidoctor.log.Severity;
import org.jruby.Ruby;
import org.jruby.RubyHash;

public class AsciidoctorCliOptions {
    public static final String LOAD_PATHS = "-I";
    public static final String REQUIRE = "-r";
    public static final String QUIET = "-q";
    public static final String WARNINGS = "-w";
    public static final String ATTRIBUTE = "-a";
    public static final String HELP = "-h";
    public static final String DESTINATION_DIR = "-D";
    public static final String SOURCE_DIR = "-R";
    public static final String BASE_DIR = "-B";
    public static final String TEMPLATE_DIR = "-T";
    public static final String TEMPLATE_ENGINE = "-E";
    public static final String COMPACT = "-C";
    public static final String EMBEDDED = "-e";
    public static final String NO_HEADER_FOOTER = "-s";
    public static final String SECTION_NUMBERS = "-n";
    public static final String SAFE = "-S";
    public static final String OUTFILE = "-o";
    public static final String DOCTYPE = "-d";
    public static final String BACKEND = "-b";
    public static final String VERSION = "-V";
    public static final String VERBOSE = "-v";
    public static final String TIMINGS = "-t";
    public static final char ATTRIBUTE_SEPARATOR = '=';
    @Parameter(names={"-v", "--verbose"}, description="enable verbose mode")
    private boolean verbose = false;
    @Parameter(names={"-t", "--timings"}, description="enable timings mode")
    private boolean timings = false;
    @Parameter(names={"-V", "--version"}, description="display the version and runtime environment")
    private boolean version = false;
    @Parameter(names={"-b", "--backend"}, description="set output format backend")
    private String backend;
    @Parameter(names={"-d", "--doctype"}, description="document type to use when rendering output: [article, book, inline] (default: article)")
    private String doctype;
    @Parameter(names={"-o", "--out-file"}, description="output file (default: based on input file path); use - to output to STDOUT")
    private String outFile;
    @Parameter(names={"--safe"}, description="set safe mode level to safe (default: unsafe)")
    private boolean safe = false;
    @Parameter(names={"-S", "--safe-mode"}, converter=SafeModeConverter.class, description="set safe mode level explicitly: [unsafe, safe, server, secure] (default: unsafe)")
    private SafeMode safeMode = SafeMode.UNSAFE;
    @Parameter(names={"-s", "--no-header-footer"}, description="suppress output of header and footer")
    private boolean noHeaderFooter = false;
    @Parameter(names={"-e", "--embedded"}, description="suppress enclosing document structure and output an embedded document")
    private boolean embedded = false;
    @Parameter(names={"-n", "--section-numbers"}, description="auto-number section titles; disabled by default")
    private boolean sectionNumbers = false;
    @Parameter(names={"--eruby"}, description="specify eRuby implementation to render built-in templates: [erb, erubis]; default erb")
    private String eruby;
    @Parameter(names={"-C", "--compact"}, description="compact the output by removing blank lines")
    private boolean compact = false;
    @Parameter(names={"-E", "--template-engine"}, description="template engine to use for the custom render templates (loads gem on demand)")
    private String templateEngine;
    @Parameter(names={"-T", "--template-dir"}, description="directory containing custom render templates the override the built-in set")
    private List<String> templateDir;
    @Parameter(names={"-B", "--base-dir"}, description="base directory containing the document and resources (default: directory of source file)")
    private String baseDir;
    @Parameter(names={"-D", "--destination-dir"}, description="destination output directory (default: directory of source file)")
    private String destinationDir;
    @Parameter(names={"-R", "--source-dir"}, description="source directory (requires destination directory)")
    private String sourceDir;
    @Parameter(names={"--trace"}, description="include backtrace information on errors")
    private boolean trace = false;
    @Parameter(names={"-h", "--help"}, help=true, description="show this message")
    private boolean help = false;
    @Parameter(names={"-a", "--attribute"}, description="a list of attributes, in the form key or key=value pair, to set on the document")
    private List<String> attributes = new ArrayList<String>();
    @Parameter(names={"-q", "--quiet"}, description="suppress warnings")
    private boolean quiet = false;
    @Parameter(names={"-w", "--warnings"}, description="suppress warnings")
    private boolean warnings = false;
    @Parameter(names={"--failure-level"}, converter=SeverityConverter.class, description="set minimum log level that yields a non-zero exit code.")
    private Severity failureLevel = Severity.FATAL;
    @Parameter(names={"-r", "--require"}, description="require the specified library before executing the processor (using require)")
    private List<String> require;
    @Parameter(names={"-cp", "-classpath", "--classpath"}, description="add a directory to the classpath may be specified more than once")
    private String classPath;
    @Parameter(names={"-I", "--load-path"}, description="add a directory to the $LOAD_PATH may be specified more than once")
    private String loadPath;
    @Parameter(description="input files; use - to read from STDIN")
    private List<String> parameters = new ArrayList<String>();

    public boolean isQuiet() {
        return this.quiet;
    }

    public Severity getFailureLevel() {
        return this.failureLevel;
    }

    public boolean isRequire() {
        return this.require != null && this.require.size() > 0;
    }

    public List<String> getRequire() {
        return this.require;
    }

    public boolean isClassPaths() {
        return this.classPath != null && this.classPath.length() > 0;
    }

    public List<String> getClassPaths() {
        return this.splitByPathSeparator(this.classPath);
    }

    public boolean isLoadPaths() {
        return this.loadPath != null && this.loadPath.length() > 0;
    }

    public List<String> getLoadPaths() {
        return this.splitByPathSeparator(this.loadPath);
    }

    public List<String> getParameters() {
        return this.parameters;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public boolean isTimings() {
        return this.timings;
    }

    public String getBackend() {
        return this.backend;
    }

    public String getDoctype() {
        return this.doctype;
    }

    public boolean isDoctypeOption() {
        return this.doctype != null;
    }

    public String getOutFile() {
        return this.outFile;
    }

    public boolean isOutFileOption() {
        return this.outFile != null;
    }

    public boolean isSafe() {
        return this.safe;
    }

    public SafeMode getSafeMode() {
        return this.safeMode;
    }

    public boolean isNoHeaderFooter() {
        return this.noHeaderFooter;
    }

    public boolean isSectionNumbers() {
        return this.sectionNumbers;
    }

    public String getEruby() {
        return this.eruby;
    }

    public boolean isCompact() {
        return this.compact;
    }

    public List<String> getTemplateDir() {
        return this.templateDir;
    }

    public boolean isTemplateDirOption() {
        return this.templateDir != null;
    }

    public String getBaseDir() {
        return this.baseDir;
    }

    public boolean isBaseDirOption() {
        return this.baseDir != null;
    }

    public String getDestinationDir() {
        return this.destinationDir;
    }

    public String getSourceDir() {
        return this.sourceDir;
    }

    public boolean isDestinationDirOption() {
        return this.destinationDir != null;
    }

    public boolean isSourceDirOption() {
        return this.sourceDir != null;
    }

    public boolean isTemplateEngineOption() {
        return this.templateEngine != null;
    }

    public boolean isTrace() {
        return this.trace;
    }

    public boolean isHelp() {
        return this.help;
    }

    public boolean isVersion() {
        return this.version;
    }

    private boolean isInputStdin() {
        return this.getParameters().size() == 1 && "-".equals(this.getParameters().get(0));
    }

    private boolean isOutputStdout() {
        return "-".equals(this.getOutFile());
    }

    private boolean isInPlaceRequired() {
        return !this.isOutFileOption() && !this.isDestinationDirOption() && !this.isOutputStdout();
    }

    public RubyHash parse(Ruby ruby) {
        RubyHash opts = new RubyHash(ruby);
        Attributes attributes = this.buildAttributes();
        opts.put((Object)ruby.newSymbol("standalone"), (Object)true);
        opts.put((Object)ruby.newSymbol("warnings"), (Object)false);
        if (this.backend != null) {
            attributes.setAttribute("backend", (Object)this.backend);
        }
        if (this.doctype != null) {
            attributes.setAttribute("doctype", (Object)this.doctype);
        }
        if (this.embedded) {
            opts.put((Object)ruby.newSymbol("standalone"), (Object)false);
        }
        if (this.outFile != null) {
            opts.put((Object)ruby.newSymbol("output_file"), (Object)this.outFile);
        }
        if (this.safe) {
            opts.put((Object)ruby.newSymbol("safe"), (Object)SafeMode.SAFE.getLevel());
        }
        if (this.safeMode != null) {
            opts.put((Object)ruby.newSymbol("safe"), (Object)this.safeMode.getLevel());
        }
        if (this.noHeaderFooter) {
            opts.put((Object)ruby.newSymbol("standalone"), (Object)false);
        }
        if (this.sectionNumbers) {
            attributes.setAttribute("sectnums", (Object)"");
        }
        if (this.eruby != null) {
            opts.put((Object)ruby.newSymbol("eruby"), (Object)this.eruby);
        }
        if (this.isTemplateDirOption()) {
            opts.put((Object)ruby.newSymbol("template_dirs"), (Object)this.templateDir.toArray(new String[0]));
        }
        if (this.isTemplateEngineOption()) {
            opts.put((Object)ruby.newSymbol("template_engine"), (Object)this.templateEngine);
        }
        if (this.baseDir != null) {
            opts.put((Object)ruby.newSymbol("base_dir"), (Object)this.baseDir);
        }
        if (this.destinationDir != null) {
            opts.put((Object)ruby.newSymbol("destination_dir"), (Object)this.destinationDir);
        }
        if (this.trace) {
            opts.put((Object)ruby.newSymbol("trace"), (Object)true);
        }
        if (this.timings) {
            opts.put((Object)ruby.newSymbol("timings"), (Object)true);
        }
        if (this.warnings) {
            opts.put((Object)ruby.newSymbol("warnings"), (Object)true);
        }
        if (!attributes.isEmpty()) {
            opts.put((Object)ruby.newSymbol("attributes"), (Object)attributes.map());
        }
        if (this.isSourceDirOption()) {
            opts.put((Object)ruby.newSymbol("source_dir"), (Object)this.sourceDir);
        }
        return opts;
    }

    Attributes buildAttributes() {
        AttributesBuilder attributesBuilder = Attributes.builder();
        for (String attribute : this.attributes) {
            int separatorIndex = attribute.indexOf(61);
            if (separatorIndex > -1) {
                String name = attribute.substring(0, separatorIndex);
                String value = attribute.substring(separatorIndex + 1);
                attributesBuilder.attribute(name, (Object)value);
                continue;
            }
            attributesBuilder.attribute(attribute);
        }
        return attributesBuilder.build();
    }

    private List<String> splitByPathSeparator(String path) {
        if (AsciidoctorCliOptions.isEmpty(path)) {
            return Collections.emptyList();
        }
        StringTokenizer tokenizer = new StringTokenizer(path, File.pathSeparator);
        ArrayList<String> ret = new ArrayList<String>();
        while (tokenizer.hasMoreTokens()) {
            ret.add(tokenizer.nextToken());
        }
        return ret;
    }

    private static boolean isEmpty(String path) {
        return path == null || path.trim().isEmpty();
    }
}

