/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.console;

import java.awt.Container;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import org.jmol.api.JmolCallbackListener;
import org.jmol.api.JmolFrame;
import org.jmol.api.JmolScriptEditorInterface;
import org.jmol.api.JmolViewer;
import org.jmol.console.KeyJMenuItem;
import org.jmol.console.ScriptEditor;
import org.jmol.i18n.GT;
import org.jmol.script.ScriptCompiler;
import org.jmol.script.Token;
import org.jmol.util.ArrayUtil;
import org.jmol.util.TextFormat;
import org.jmol.viewer.FileManager;
import org.jmol.viewer.Viewer;

public abstract class JmolConsole
implements JmolCallbackListener,
ActionListener,
WindowListener {
    public JmolViewer viewer;
    protected JFrame viewerFrame;
    protected Container externalContainer;
    protected JButton editButton;
    protected JButton runButton;
    protected JButton historyButton;
    protected JButton stateButton;
    protected Map<String, String> labels;
    protected Map<String, AbstractButton> menuMap = new Hashtable<String, AbstractButton>();
    protected ScriptEditor scriptEditor;
    public int nTab = 0;
    private String incompleteCmd;
    protected String defaultMessage;
    protected JLabel label1;

    protected abstract void setupLabels();

    public void dispose() {
        if (this.externalContainer instanceof Window) {
            ((Window)this.externalContainer).dispose();
        } else {
            this.externalContainer.setVisible(false);
        }
    }

    protected Container getPane() {
        return this.externalContainer instanceof JFrame ? ((JFrame)this.externalContainer).getContentPane() : this.externalContainer;
    }

    protected String getLabel(String string) {
        if (this.labels == null) {
            this.labels = new Hashtable<String, String>();
            this.labels.put("title", GT._((String)"Jmol Script Console") + " " + Viewer.getJmolVersion());
            this.setupLabels();
        }
        return this.labels.get(string);
    }

    protected void setTitle() {
        if (this.externalContainer instanceof JFrame) {
            ((JFrame)this.externalContainer).setTitle(this.getLabel("title"));
        } else if (this.externalContainer instanceof JDialog) {
            ((JDialog)this.externalContainer).setTitle(this.getLabel("title"));
        }
    }

    public void setVisible(boolean bl) {
        this.externalContainer.setVisible(bl);
    }

    void setScriptEditor(ScriptEditor scriptEditor) {
        this.scriptEditor = scriptEditor;
    }

    public JmolScriptEditorInterface getScriptEditor() {
        return this.scriptEditor == null ? (this.scriptEditor = new ScriptEditor(this.viewer, this.viewerFrame, this)) : this.scriptEditor;
    }

    protected abstract void clearContent(String var1);

    protected abstract void execute(String var1);

    protected String completeCommand(String string) {
        String string2;
        if (string.length() == 0) {
            return null;
        }
        this.incompleteCmd = string2 = this.nTab <= 0 || this.incompleteCmd == null ? string : this.incompleteCmd;
        String[] stringArray = ScriptCompiler.splitCommandLine((String)string);
        if (stringArray == null) {
            return null;
        }
        boolean bl = stringArray[2] == null;
        String string3 = stringArray[bl ? 1 : 2];
        if (string3.length() == 0) {
            return null;
        }
        stringArray = ScriptCompiler.splitCommandLine((String)string2);
        String string4 = null;
        if (!(bl || string3.charAt(0) != '\"' && string3.charAt(0) != '\'')) {
            char c = string3.charAt(0);
            string3 = TextFormat.trim((String)string3, (String)"\"'");
            String string5 = TextFormat.trim((String)stringArray[2], (String)"\"'");
            string4 = this.nextFileName(string5, this.nTab);
            if (string4 != null) {
                string4 = stringArray[0] + stringArray[1] + c + (string4 == null ? string3 : string4) + c;
            }
        } else {
            if (!bl) {
                string3 = stringArray[1];
            }
            string4 = Token.completeCommand(null, (boolean)stringArray[1].equalsIgnoreCase("set "), (boolean)bl, (String)(bl ? stringArray[1] : stringArray[2]), (int)this.nTab);
            string4 = stringArray[0] + (string4 == null ? string3 : (bl ? string4 : stringArray[1] + string4));
        }
        return string4 == null || string4.equals(string2) ? null : string4;
    }

    private String nextFileName(String string, int n) {
        Object object;
        String string2 = FileManager.getLocalPathForWritingFile((JmolViewer)this.viewer, (String)string);
        String string3 = string2.substring(0, string2.lastIndexOf("/") + 1);
        if (string2.startsWith("file:/")) {
            string2 = string2.substring(6);
        }
        if (string2.indexOf("/") >= 0) {
            if (string3.equals(string2)) {
                string = "";
            } else {
                object = new File(string2);
                string2 = ((File)object).getParent();
                string = ((File)object).getName();
            }
        }
        object = new FileChecker(string);
        try {
            new File(string2).list((FilenameFilter)object);
            return string3 + ((FileChecker)object).getFile(n);
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected void setEnabled(JButton jButton, boolean bl) {
        if (jButton != null) {
            jButton.setEnabled(bl);
        }
    }

    protected JButton setButton(String string) {
        JButton jButton = new JButton(this.getLabel(string));
        jButton.addActionListener(this);
        this.menuMap.put(string, jButton);
        return jButton;
    }

    protected void updateLabels() {
        boolean bl = GT.getDoTranslate();
        this.labels = null;
        GT.setDoTranslate((boolean)true);
        this.defaultMessage = this.getLabel("default");
        KeyJMenuItem.setAbstractButtonLabels(this.menuMap, this.labels);
        this.setTitle();
        if (this.label1 != null) {
            this.label1.setText(this.getLabel("label1"));
        }
        GT.setDoTranslate((boolean)bl);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.runButton) {
            this.execute(null);
        } else if (object == this.editButton) {
            this.viewer.getProperty("DATA_API", "scriptEditor", null);
        } else if (object == this.historyButton) {
            this.clearContent(this.viewer.getSetHistory(Integer.MAX_VALUE));
        } else if (object == this.stateButton) {
            this.clearContent(this.viewer.getStateInfo());
        }
    }

    protected void addWindowListener() {
        Window window = JmolConsole.getWindow(this.externalContainer);
        if (window != null) {
            window.addWindowListener(this);
        }
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
        this.destroyConsole();
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.destroyConsole();
    }

    private void destroyConsole() {
        if (this.viewer.isApplet()) {
            this.viewer.getProperty("DATA_API", "getAppConsole", (Object)Boolean.FALSE);
        }
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public boolean notifyEnabled(int n) {
        switch (n) {
            case 1: 
            case 6: 
            case 7: 
            case 9: {
                return true;
            }
        }
        return false;
    }

    public abstract void sendConsoleMessage(String var1);

    public abstract void sendConsoleEcho(String var1);

    public void notifyCallback(int n, Object[] objectArray) {
        String string = objectArray == null || objectArray[1] == null ? null : objectArray[1].toString();
        switch (n) {
            case 1: {
                this.sendConsoleEcho(string);
                break;
            }
            case 6: {
                String string2 = (String)objectArray[3];
                if (string2.indexOf("Picked") >= 0) {
                    this.sendConsoleMessage(string);
                    break;
                }
                if (string2.indexOf("Completed") < 0) break;
                this.sendConsoleEcho(string.substring(string.lastIndexOf(",") + 2, string.length() - 1));
                break;
            }
            case 7: {
                this.sendConsoleMessage(objectArray == null ? null : string);
                break;
            }
            case 9: {
                this.sendConsoleMessage(string);
            }
        }
    }

    public void setCallbackFunction(String string, String string2) {
    }

    public static Window getWindow(Container container) {
        while (container != null) {
            if (container instanceof Frame) {
                return (Frame)container;
            }
            if (container instanceof JDialog) {
                return (JDialog)container;
            }
            if (container instanceof JmolFrame) {
                return ((JmolFrame)container).getFrame();
            }
            container = container.getParent();
        }
        return null;
    }

    protected class FileChecker
    implements FilenameFilter {
        private String stub;
        private List<String> v = new ArrayList<String>();

        protected FileChecker(String string) {
            this.stub = string.toLowerCase();
        }

        public boolean accept(File file, String string) {
            if (!(string = string.toLowerCase()).toLowerCase().startsWith(this.stub)) {
                return false;
            }
            this.v.add(string);
            return true;
        }

        protected String getFile(int n) {
            return ArrayUtil.sortedItem(this.v, (int)n);
        }
    }
}

