/*===- TableGen'erated file -------------------------------------*- C++ -*-===*\
|*                                                                            *|
|* Global Instruction Selector for the AArch64 target                         *|
|*                                                                            *|
|* Automatically generated file, do not edit!                                 *|
|*                                                                            *|
\*===----------------------------------------------------------------------===*/

#ifdef GET_GLOBALISEL_PREDICATE_BITSET
const unsigned MAX_SUBTARGET_PREDICATES = 57;
using PredicateBitset = llvm::PredicateBitsetImpl<MAX_SUBTARGET_PREDICATES>;
#endif // ifdef GET_GLOBALISEL_PREDICATE_BITSET

#ifdef GET_GLOBALISEL_TEMPORARIES_DECL
  mutable MatcherState State;
  typedef ComplexRendererFns(AArch64InstructionSelector::*ComplexMatcherMemFn)(MachineOperand &) const;
  typedef void(AArch64InstructionSelector::*CustomRendererFn)(MachineInstrBuilder &, const MachineInstr &, int) const;
  const ISelInfoTy<PredicateBitset, ComplexMatcherMemFn, CustomRendererFn> ISelInfo;
  static AArch64InstructionSelector::ComplexMatcherMemFn ComplexPredicateFns[];
  static AArch64InstructionSelector::CustomRendererFn CustomRenderers[];
  bool testImmPredicate_I64(unsigned PredicateID, int64_t Imm) const override;
  bool testImmPredicate_APInt(unsigned PredicateID, const APInt &Imm) const override;
  bool testImmPredicate_APFloat(unsigned PredicateID, const APFloat &Imm) const override;
  const int64_t *getMatchTable() const override;
  bool testMIPredicate_MI(unsigned PredicateID, const MachineInstr &MI, const std::array<const MachineOperand *, 3> &Operands) const override;
#endif // ifdef GET_GLOBALISEL_TEMPORARIES_DECL

#ifdef GET_GLOBALISEL_TEMPORARIES_INIT
, State(1),
ISelInfo(TypeObjects, NumTypeObjects, FeatureBitsets, ComplexPredicateFns, CustomRenderers)
#endif // ifdef GET_GLOBALISEL_TEMPORARIES_INIT

#ifdef GET_GLOBALISEL_IMPL
// Bits for subtarget features that participate in instruction matching.
enum SubtargetFeatureBits : uint8_t {
  Feature_HasPAuthBit = 7,
  Feature_HasJSBit = 9,
  Feature_HasComplxNumBit = 44,
  Feature_HasFPARMv8Bit = 8,
  Feature_HasNEONBit = 3,
  Feature_HasSM4Bit = 43,
  Feature_HasSHA3Bit = 42,
  Feature_HasSHA2Bit = 18,
  Feature_HasAESBit = 17,
  Feature_HasDotProdBit = 1,
  Feature_HasCRCBit = 11,
  Feature_HasCSSCBit = 19,
  Feature_HasNoCSSCBit = 39,
  Feature_HasLSEBit = 40,
  Feature_HasNoLSEBit = 38,
  Feature_HasRDMBit = 16,
  Feature_HasFullFP16Bit = 14,
  Feature_HasFP16FMLBit = 6,
  Feature_HasFuseAESBit = 51,
  Feature_HasSVEBit = 20,
  Feature_HasSVE2Bit = 21,
  Feature_HasSVE2AESBit = 28,
  Feature_HasSVE2SM4Bit = 29,
  Feature_HasSVE2SHA3Bit = 30,
  Feature_HasSVE2BitPermBit = 31,
  Feature_HasSMEBit = 34,
  Feature_HasSMEF64F64Bit = 36,
  Feature_HasSMEI16I64Bit = 35,
  Feature_HasSME2Bit = 37,
  Feature_HasSVEorSMEBit = 0,
  Feature_HasSVE2orSMEBit = 27,
  Feature_HasSVE2p1_or_HasSMEBit = 32,
  Feature_HasSVE2p1_or_HasSME2Bit = 33,
  Feature_HasNEONorSMEBit = 4,
  Feature_HasRCPCBit = 56,
  Feature_HasFRInt3264Bit = 15,
  Feature_HasMTEBit = 12,
  Feature_HasTMEBit = 10,
  Feature_HasBF16Bit = 2,
  Feature_HasMatMulInt8Bit = 5,
  Feature_HasMatMulFP32Bit = 41,
  Feature_HasMatMulFP64Bit = 26,
  Feature_HasLS64Bit = 55,
  Feature_HasHBCBit = 13,
  Feature_IsLEBit = 24,
  Feature_IsBEBit = 52,
  Feature_UseExperimentalZeroingPseudosBit = 22,
  Feature_UseAlternateSExtLoadCVTF32Bit = 50,
  Feature_UseScalarIncVLBit = 23,
  Feature_NotInStreamingSVEModeBit = 25,
  Feature_NotForCodeSizeBit = 49,
  Feature_UseSTRQroBit = 48,
  Feature_UseBTIBit = 54,
  Feature_NotUseBTIBit = 53,
  Feature_SLSBLRMitigationBit = 47,
  Feature_NoSLSBLRMitigationBit = 46,
  Feature_OptimizedGISelOrOtherSelectorBit = 45,
};

PredicateBitset AArch64InstructionSelector::
computeAvailableModuleFeatures(const AArch64Subtarget *Subtarget) const {
  PredicateBitset Features;
  if (Subtarget->hasPAuth())
    Features.set(Feature_HasPAuthBit);
  if (Subtarget->hasJS())
    Features.set(Feature_HasJSBit);
  if (Subtarget->hasComplxNum())
    Features.set(Feature_HasComplxNumBit);
  if (Subtarget->hasFPARMv8())
    Features.set(Feature_HasFPARMv8Bit);
  if (Subtarget->hasNEON())
    Features.set(Feature_HasNEONBit);
  if (Subtarget->hasSM4())
    Features.set(Feature_HasSM4Bit);
  if (Subtarget->hasSHA3())
    Features.set(Feature_HasSHA3Bit);
  if (Subtarget->hasSHA2())
    Features.set(Feature_HasSHA2Bit);
  if (Subtarget->hasAES())
    Features.set(Feature_HasAESBit);
  if (Subtarget->hasDotProd())
    Features.set(Feature_HasDotProdBit);
  if (Subtarget->hasCRC())
    Features.set(Feature_HasCRCBit);
  if (Subtarget->hasCSSC())
    Features.set(Feature_HasCSSCBit);
  if (!Subtarget->hasCSSC())
    Features.set(Feature_HasNoCSSCBit);
  if (Subtarget->hasLSE())
    Features.set(Feature_HasLSEBit);
  if (!Subtarget->hasLSE())
    Features.set(Feature_HasNoLSEBit);
  if (Subtarget->hasRDM())
    Features.set(Feature_HasRDMBit);
  if (Subtarget->hasFullFP16())
    Features.set(Feature_HasFullFP16Bit);
  if (Subtarget->hasFP16FML())
    Features.set(Feature_HasFP16FMLBit);
  if (Subtarget->hasFuseAES())
    Features.set(Feature_HasFuseAESBit);
  if (Subtarget->hasSVE())
    Features.set(Feature_HasSVEBit);
  if (Subtarget->hasSVE2())
    Features.set(Feature_HasSVE2Bit);
  if (Subtarget->hasSVE2AES())
    Features.set(Feature_HasSVE2AESBit);
  if (Subtarget->hasSVE2SM4())
    Features.set(Feature_HasSVE2SM4Bit);
  if (Subtarget->hasSVE2SHA3())
    Features.set(Feature_HasSVE2SHA3Bit);
  if (Subtarget->hasSVE2BitPerm())
    Features.set(Feature_HasSVE2BitPermBit);
  if (Subtarget->hasSME())
    Features.set(Feature_HasSMEBit);
  if (Subtarget->hasSMEF64F64())
    Features.set(Feature_HasSMEF64F64Bit);
  if (Subtarget->hasSMEI16I64())
    Features.set(Feature_HasSMEI16I64Bit);
  if (Subtarget->hasSME2())
    Features.set(Feature_HasSME2Bit);
  if (Subtarget->hasSVEorSME())
    Features.set(Feature_HasSVEorSMEBit);
  if (Subtarget->hasSVE2() || Subtarget->hasSME())
    Features.set(Feature_HasSVE2orSMEBit);
  if (Subtarget->hasSVE2p1() || Subtarget->hasSME())
    Features.set(Feature_HasSVE2p1_or_HasSMEBit);
  if (Subtarget->hasSVE2p1() || Subtarget->hasSME2())
    Features.set(Feature_HasSVE2p1_or_HasSME2Bit);
  if (Subtarget->hasNEON() || Subtarget->hasSME())
    Features.set(Feature_HasNEONorSMEBit);
  if (Subtarget->hasRCPC())
    Features.set(Feature_HasRCPCBit);
  if (Subtarget->hasFRInt3264())
    Features.set(Feature_HasFRInt3264Bit);
  if (Subtarget->hasMTE())
    Features.set(Feature_HasMTEBit);
  if (Subtarget->hasTME())
    Features.set(Feature_HasTMEBit);
  if (Subtarget->hasBF16())
    Features.set(Feature_HasBF16Bit);
  if (Subtarget->hasMatMulInt8())
    Features.set(Feature_HasMatMulInt8Bit);
  if (Subtarget->hasMatMulFP32())
    Features.set(Feature_HasMatMulFP32Bit);
  if (Subtarget->hasMatMulFP64())
    Features.set(Feature_HasMatMulFP64Bit);
  if (Subtarget->hasLS64())
    Features.set(Feature_HasLS64Bit);
  if (Subtarget->hasHBC())
    Features.set(Feature_HasHBCBit);
  if (Subtarget->isLittleEndian())
    Features.set(Feature_IsLEBit);
  if (!Subtarget->isLittleEndian())
    Features.set(Feature_IsBEBit);
  if (Subtarget->useExperimentalZeroingPseudos())
    Features.set(Feature_UseExperimentalZeroingPseudosBit);
  if (Subtarget->useAlternateSExtLoadCVTF32Pattern())
    Features.set(Feature_UseAlternateSExtLoadCVTF32Bit);
  if (Subtarget->useScalarIncVL())
    Features.set(Feature_UseScalarIncVLBit);
  if (!Subtarget->forceStreamingCompatibleSVE())
    Features.set(Feature_NotInStreamingSVEModeBit);
  return Features;
}

void AArch64InstructionSelector::setupGeneratedPerFunctionState(MachineFunction &MF) {
  AvailableFunctionFeatures = computeAvailableFunctionFeatures((const AArch64Subtarget *)&MF.getSubtarget(), &MF);
}
PredicateBitset AArch64InstructionSelector::
computeAvailableFunctionFeatures(const AArch64Subtarget *Subtarget, const MachineFunction *MF) const {
  PredicateBitset Features;
  if (!shouldOptForSize(MF))
    Features.set(Feature_NotForCodeSizeBit);
  if (!Subtarget->isSTRQroSlow() || shouldOptForSize(MF))
    Features.set(Feature_UseSTRQroBit);
  if ( MF->getInfo<AArch64FunctionInfo>()->branchTargetEnforcement() )
    Features.set(Feature_UseBTIBit);
  if ( !MF->getInfo<AArch64FunctionInfo>()->branchTargetEnforcement() )
    Features.set(Feature_NotUseBTIBit);
  if ( MF->getSubtarget<AArch64Subtarget>().hardenSlsBlr() )
    Features.set(Feature_SLSBLRMitigationBit);
  if ( !MF->getSubtarget<AArch64Subtarget>().hardenSlsBlr() )
    Features.set(Feature_NoSLSBLRMitigationBit);
  if (!MF->getFunction().hasOptNone() || MF->getProperties().hasProperty(MachineFunctionProperties::Property::FailedISel) || !MF->getProperties().hasProperty(MachineFunctionProperties::Property::Legalized))
    Features.set(Feature_OptimizedGISelOrOtherSelectorBit);
  return Features;
}

// LLT Objects.
enum {
  GILLT_s16,
  GILLT_s32,
  GILLT_s64,
  GILLT_s128,
  GILLT_v2s32,
  GILLT_v2s64,
  GILLT_v4s16,
  GILLT_v4s32,
  GILLT_v8s8,
  GILLT_v8s16,
  GILLT_v16s8,
  GILLT_nxv1s1,
  GILLT_nxv2s1,
  GILLT_nxv2s16,
  GILLT_nxv2s32,
  GILLT_nxv2s64,
  GILLT_nxv4s1,
  GILLT_nxv4s16,
  GILLT_nxv4s32,
  GILLT_nxv8s1,
  GILLT_nxv8s16,
  GILLT_nxv16s1,
  GILLT_nxv16s8,
};
const static size_t NumTypeObjects = 23;
const static LLT TypeObjects[] = {
  LLT::scalar(16),
  LLT::scalar(32),
  LLT::scalar(64),
  LLT::scalar(128),
  LLT::vector(ElementCount::getFixed(2), 32),
  LLT::vector(ElementCount::getFixed(2), 64),
  LLT::vector(ElementCount::getFixed(4), 16),
  LLT::vector(ElementCount::getFixed(4), 32),
  LLT::vector(ElementCount::getFixed(8), 8),
  LLT::vector(ElementCount::getFixed(8), 16),
  LLT::vector(ElementCount::getFixed(16), 8),
  LLT::vector(ElementCount::getScalable(1), 1),
  LLT::vector(ElementCount::getScalable(2), 1),
  LLT::vector(ElementCount::getScalable(2), 16),
  LLT::vector(ElementCount::getScalable(2), 32),
  LLT::vector(ElementCount::getScalable(2), 64),
  LLT::vector(ElementCount::getScalable(4), 1),
  LLT::vector(ElementCount::getScalable(4), 16),
  LLT::vector(ElementCount::getScalable(4), 32),
  LLT::vector(ElementCount::getScalable(8), 1),
  LLT::vector(ElementCount::getScalable(8), 16),
  LLT::vector(ElementCount::getScalable(16), 1),
  LLT::vector(ElementCount::getScalable(16), 8),
};

// Feature bitsets.
enum {
  GIFBS_Invalid,
  GIFBS_HasAES,
  GIFBS_HasCRC,
  GIFBS_HasCSSC,
  GIFBS_HasFPARMv8,
  GIFBS_HasFRInt3264,
  GIFBS_HasFullFP16,
  GIFBS_HasFuseAES,
  GIFBS_HasLSE,
  GIFBS_HasMTE,
  GIFBS_HasMatMulInt8,
  GIFBS_HasNEON,
  GIFBS_HasNEONorSME,
  GIFBS_HasNoCSSC,
  GIFBS_HasNoLSE,
  GIFBS_HasPAuth,
  GIFBS_HasRCPC,
  GIFBS_HasRDM,
  GIFBS_HasSHA2,
  GIFBS_HasSHA3,
  GIFBS_HasSM4,
  GIFBS_HasSME,
  GIFBS_HasSVE,
  GIFBS_HasSVE2,
  GIFBS_HasSVEorSME,
  GIFBS_HasTME,
  GIFBS_IsBE,
  GIFBS_IsLE,
  GIFBS_NotInStreamingSVEMode,
  GIFBS_OptimizedGISelOrOtherSelector,
  GIFBS_UseSTRQro,
  GIFBS_HasBF16_HasNEON,
  GIFBS_HasBF16_HasNEONorSME,
  GIFBS_HasComplxNum_HasNEON,
  GIFBS_HasFP16FML_HasNEON,
  GIFBS_HasFPARMv8_HasJS,
  GIFBS_HasFullFP16_HasNEON,
  GIFBS_HasFullFP16_HasNEONorSME,
  GIFBS_HasNEON_HasRDM,
  GIFBS_HasSVEorSME_UseScalarIncVL,
  GIFBS_IsLE_UseSTRQro,
  GIFBS_HasComplxNum_HasFullFP16_HasNEON,
  GIFBS_HasNEON_NotForCodeSize_UseAlternateSExtLoadCVTF32,
};
const static PredicateBitset FeatureBitsets[] {
  {}, // GIFBS_Invalid
  {Feature_HasAESBit, },
  {Feature_HasCRCBit, },
  {Feature_HasCSSCBit, },
  {Feature_HasFPARMv8Bit, },
  {Feature_HasFRInt3264Bit, },
  {Feature_HasFullFP16Bit, },
  {Feature_HasFuseAESBit, },
  {Feature_HasLSEBit, },
  {Feature_HasMTEBit, },
  {Feature_HasMatMulInt8Bit, },
  {Feature_HasNEONBit, },
  {Feature_HasNEONorSMEBit, },
  {Feature_HasNoCSSCBit, },
  {Feature_HasNoLSEBit, },
  {Feature_HasPAuthBit, },
  {Feature_HasRCPCBit, },
  {Feature_HasRDMBit, },
  {Feature_HasSHA2Bit, },
  {Feature_HasSHA3Bit, },
  {Feature_HasSM4Bit, },
  {Feature_HasSMEBit, },
  {Feature_HasSVEBit, },
  {Feature_HasSVE2Bit, },
  {Feature_HasSVEorSMEBit, },
  {Feature_HasTMEBit, },
  {Feature_IsBEBit, },
  {Feature_IsLEBit, },
  {Feature_NotInStreamingSVEModeBit, },
  {Feature_OptimizedGISelOrOtherSelectorBit, },
  {Feature_UseSTRQroBit, },
  {Feature_HasBF16Bit, Feature_HasNEONBit, },
  {Feature_HasBF16Bit, Feature_HasNEONorSMEBit, },
  {Feature_HasComplxNumBit, Feature_HasNEONBit, },
  {Feature_HasFP16FMLBit, Feature_HasNEONBit, },
  {Feature_HasFPARMv8Bit, Feature_HasJSBit, },
  {Feature_HasFullFP16Bit, Feature_HasNEONBit, },
  {Feature_HasFullFP16Bit, Feature_HasNEONorSMEBit, },
  {Feature_HasNEONBit, Feature_HasRDMBit, },
  {Feature_HasSVEorSMEBit, Feature_UseScalarIncVLBit, },
  {Feature_IsLEBit, Feature_UseSTRQroBit, },
  {Feature_HasComplxNumBit, Feature_HasFullFP16Bit, Feature_HasNEONBit, },
  {Feature_HasNEONBit, Feature_NotForCodeSizeBit, Feature_UseAlternateSExtLoadCVTF32Bit, },
};

// ComplexPattern predicates.
enum {
  GICP_Invalid,
  GICP_gi_addsub_shifted_imm32,
  GICP_gi_addsub_shifted_imm64,
  GICP_gi_am_indexed128,
  GICP_gi_am_indexed16,
  GICP_gi_am_indexed32,
  GICP_gi_am_indexed64,
  GICP_gi_am_indexed8,
  GICP_gi_am_unscaled128,
  GICP_gi_am_unscaled16,
  GICP_gi_am_unscaled32,
  GICP_gi_am_unscaled64,
  GICP_gi_am_unscaled8,
  GICP_gi_arith_extended_reg32_i32,
  GICP_gi_arith_extended_reg32_i64,
  GICP_gi_arith_extended_reg32to64_i64,
  GICP_gi_arith_shifted_reg32,
  GICP_gi_arith_shifted_reg64,
  GICP_gi_logical_shifted_reg32,
  GICP_gi_logical_shifted_reg64,
  GICP_gi_neg_addsub_shifted_imm32,
  GICP_gi_neg_addsub_shifted_imm64,
  GICP_gi_ro_Windexed128,
  GICP_gi_ro_Windexed16,
  GICP_gi_ro_Windexed32,
  GICP_gi_ro_Windexed64,
  GICP_gi_ro_Windexed8,
  GICP_gi_ro_Xindexed128,
  GICP_gi_ro_Xindexed16,
  GICP_gi_ro_Xindexed32,
  GICP_gi_ro_Xindexed64,
  GICP_gi_ro_Xindexed8,
};
// See constructor for table contents

// PatFrag predicates.
enum {
  GIPFP_I64_Predicate_VectorIndex0 = GIPFP_I64_Invalid + 1,
  GIPFP_I64_Predicate_VectorIndex0_timm,
  GIPFP_I64_Predicate_VectorIndex1,
  GIPFP_I64_Predicate_VectorIndex132b,
  GIPFP_I64_Predicate_VectorIndex132b_timm,
  GIPFP_I64_Predicate_VectorIndex1_timm,
  GIPFP_I64_Predicate_VectorIndexB,
  GIPFP_I64_Predicate_VectorIndexB32b,
  GIPFP_I64_Predicate_VectorIndexB32b_timm,
  GIPFP_I64_Predicate_VectorIndexB_timm,
  GIPFP_I64_Predicate_VectorIndexD,
  GIPFP_I64_Predicate_VectorIndexD32b,
  GIPFP_I64_Predicate_VectorIndexD32b_timm,
  GIPFP_I64_Predicate_VectorIndexD_timm,
  GIPFP_I64_Predicate_VectorIndexH,
  GIPFP_I64_Predicate_VectorIndexH32b,
  GIPFP_I64_Predicate_VectorIndexH32b_timm,
  GIPFP_I64_Predicate_VectorIndexH_timm,
  GIPFP_I64_Predicate_VectorIndexS,
  GIPFP_I64_Predicate_VectorIndexS32b,
  GIPFP_I64_Predicate_VectorIndexS32b_timm,
  GIPFP_I64_Predicate_VectorIndexS_timm,
  GIPFP_I64_Predicate_complexrotateop,
  GIPFP_I64_Predicate_complexrotateopodd,
  GIPFP_I64_Predicate_i64imm_32bit,
  GIPFP_I64_Predicate_i64imm_32bit_tgt,
  GIPFP_I64_Predicate_imm0_1,
  GIPFP_I64_Predicate_imm0_127,
  GIPFP_I64_Predicate_imm0_127_64b,
  GIPFP_I64_Predicate_imm0_15,
  GIPFP_I64_Predicate_imm0_255,
  GIPFP_I64_Predicate_imm0_3,
  GIPFP_I64_Predicate_imm0_31,
  GIPFP_I64_Predicate_imm0_63,
  GIPFP_I64_Predicate_imm0_7,
  GIPFP_I64_Predicate_imm32_0_15,
  GIPFP_I64_Predicate_imm32_0_31,
  GIPFP_I64_Predicate_maski16_or_more,
  GIPFP_I64_Predicate_maski8_or_more,
  GIPFP_I64_Predicate_rprfop,
  GIPFP_I64_Predicate_s64imm_32bit,
  GIPFP_I64_Predicate_simm4s1,
  GIPFP_I64_Predicate_simm4s16,
  GIPFP_I64_Predicate_simm4s2,
  GIPFP_I64_Predicate_simm4s3,
  GIPFP_I64_Predicate_simm4s32,
  GIPFP_I64_Predicate_simm4s4,
  GIPFP_I64_Predicate_simm5_16b,
  GIPFP_I64_Predicate_simm5_16b_tgt,
  GIPFP_I64_Predicate_simm5_32b,
  GIPFP_I64_Predicate_simm5_32b_tgt,
  GIPFP_I64_Predicate_simm5_64b,
  GIPFP_I64_Predicate_simm5_64b_tgt,
  GIPFP_I64_Predicate_simm5_8b,
  GIPFP_I64_Predicate_simm5_8b_tgt,
  GIPFP_I64_Predicate_simm6_32b,
  GIPFP_I64_Predicate_simm6s1,
  GIPFP_I64_Predicate_simm8_32b,
  GIPFP_I64_Predicate_simm8_64b,
  GIPFP_I64_Predicate_simm9,
  GIPFP_I64_Predicate_sme_elm_idx0_0,
  GIPFP_I64_Predicate_sme_elm_idx0_1,
  GIPFP_I64_Predicate_sme_elm_idx0_15,
  GIPFP_I64_Predicate_sme_elm_idx0_3,
  GIPFP_I64_Predicate_sme_elm_idx0_7,
  GIPFP_I64_Predicate_svcr_op,
  GIPFP_I64_Predicate_sve_elm_idx_extdup_b,
  GIPFP_I64_Predicate_sve_elm_idx_extdup_b_timm,
  GIPFP_I64_Predicate_sve_elm_idx_extdup_d,
  GIPFP_I64_Predicate_sve_elm_idx_extdup_d_timm,
  GIPFP_I64_Predicate_sve_elm_idx_extdup_h,
  GIPFP_I64_Predicate_sve_elm_idx_extdup_h_timm,
  GIPFP_I64_Predicate_sve_elm_idx_extdup_q,
  GIPFP_I64_Predicate_sve_elm_idx_extdup_q_timm,
  GIPFP_I64_Predicate_sve_elm_idx_extdup_s,
  GIPFP_I64_Predicate_sve_elm_idx_extdup_s_timm,
  GIPFP_I64_Predicate_sve_incdec_imm,
  GIPFP_I64_Predicate_sve_pred_enum,
  GIPFP_I64_Predicate_sve_prfop,
  GIPFP_I64_Predicate_sve_vec_len_specifier_enum,
  GIPFP_I64_Predicate_tbz_imm0_31_diag,
  GIPFP_I64_Predicate_tbz_imm0_31_nodiag,
  GIPFP_I64_Predicate_tbz_imm32_63,
  GIPFP_I64_Predicate_timm0_1,
  GIPFP_I64_Predicate_timm0_31,
  GIPFP_I64_Predicate_timm0_63,
  GIPFP_I64_Predicate_timm32_0_1,
  GIPFP_I64_Predicate_timm32_0_15,
  GIPFP_I64_Predicate_timm32_0_255,
  GIPFP_I64_Predicate_timm32_0_3,
  GIPFP_I64_Predicate_timm32_0_31,
  GIPFP_I64_Predicate_timm32_0_65535,
  GIPFP_I64_Predicate_timm32_0_7,
  GIPFP_I64_Predicate_timm64_0_65535,
  GIPFP_I64_Predicate_tuimm5s2,
  GIPFP_I64_Predicate_tuimm5s4,
  GIPFP_I64_Predicate_tuimm5s8,
  GIPFP_I64_Predicate_tvecshiftL16,
  GIPFP_I64_Predicate_tvecshiftL32,
  GIPFP_I64_Predicate_tvecshiftL64,
  GIPFP_I64_Predicate_tvecshiftL8,
  GIPFP_I64_Predicate_tvecshiftR16,
  GIPFP_I64_Predicate_tvecshiftR32,
  GIPFP_I64_Predicate_tvecshiftR64,
  GIPFP_I64_Predicate_tvecshiftR8,
  GIPFP_I64_Predicate_ubsan_trap_imm,
  GIPFP_I64_Predicate_uimm0s2range,
  GIPFP_I64_Predicate_uimm0s4range,
  GIPFP_I64_Predicate_uimm16,
  GIPFP_I64_Predicate_uimm1s2range,
  GIPFP_I64_Predicate_uimm1s4range,
  GIPFP_I64_Predicate_uimm2s2range,
  GIPFP_I64_Predicate_uimm2s4range,
  GIPFP_I64_Predicate_uimm3s2range,
  GIPFP_I64_Predicate_uimm3s8,
  GIPFP_I64_Predicate_uimm5s2,
  GIPFP_I64_Predicate_uimm5s4,
  GIPFP_I64_Predicate_uimm5s8,
  GIPFP_I64_Predicate_uimm6,
  GIPFP_I64_Predicate_uimm6s1,
  GIPFP_I64_Predicate_uimm6s16,
  GIPFP_I64_Predicate_uimm6s2,
  GIPFP_I64_Predicate_uimm6s4,
  GIPFP_I64_Predicate_uimm6s8,
  GIPFP_I64_Predicate_uimm8_32b,
  GIPFP_I64_Predicate_uimm8_64b,
  GIPFP_I64_Predicate_vecshiftL16,
  GIPFP_I64_Predicate_vecshiftL32,
  GIPFP_I64_Predicate_vecshiftL64,
  GIPFP_I64_Predicate_vecshiftL8,
  GIPFP_I64_Predicate_vecshiftR16,
  GIPFP_I64_Predicate_vecshiftR16Narrow,
  GIPFP_I64_Predicate_vecshiftR32,
  GIPFP_I64_Predicate_vecshiftR32Narrow,
  GIPFP_I64_Predicate_vecshiftR64,
  GIPFP_I64_Predicate_vecshiftR64Narrow,
  GIPFP_I64_Predicate_vecshiftR8,
};
bool AArch64InstructionSelector::testImmPredicate_I64(unsigned PredicateID, int64_t Imm) const {
  switch (PredicateID) {
  case GIPFP_I64_Predicate_VectorIndex0: {
     return ((uint64_t)Imm) == 0; 
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_VectorIndex0_timm: {
     return ((uint64_t)Imm) == 0; 
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_VectorIndex1: {
     return ((uint64_t)Imm) == 1; 
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_VectorIndex132b: {
     return ((uint64_t)Imm) == 1; 
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_VectorIndex132b_timm: {
     return ((uint64_t)Imm) == 1; 
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_VectorIndex1_timm: {
     return ((uint64_t)Imm) == 1; 
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_VectorIndexB: {
     return ((uint64_t)Imm) < 16; 
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_VectorIndexB32b: {
     return ((uint64_t)Imm) < 16; 
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_VectorIndexB32b_timm: {
     return ((uint64_t)Imm) < 16; 
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_VectorIndexB_timm: {
     return ((uint64_t)Imm) < 16; 
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_VectorIndexD: {
     return ((uint64_t)Imm) < 2; 
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_VectorIndexD32b: {
     return ((uint64_t)Imm) < 2; 
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_VectorIndexD32b_timm: {
     return ((uint64_t)Imm) < 2; 
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_VectorIndexD_timm: {
     return ((uint64_t)Imm) < 2; 
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_VectorIndexH: {
     return ((uint64_t)Imm) < 8; 
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_VectorIndexH32b: {
     return ((uint64_t)Imm) < 8; 
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_VectorIndexH32b_timm: {
     return ((uint64_t)Imm) < 8; 
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_VectorIndexH_timm: {
     return ((uint64_t)Imm) < 8; 
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_VectorIndexS: {
     return ((uint64_t)Imm) < 4; 
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_VectorIndexS32b: {
     return ((uint64_t)Imm) < 4; 
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_VectorIndexS32b_timm: {
     return ((uint64_t)Imm) < 4; 
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_VectorIndexS_timm: {
     return ((uint64_t)Imm) < 4; 
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_complexrotateop: {
     return Imm >= 0 && Imm <= 270;  
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_complexrotateopodd: {
     return Imm >= 0 && Imm <= 270;  
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_i64imm_32bit: {
    
  return (Imm & 0xffffffffULL) == static_cast<uint64_t>(Imm);

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_i64imm_32bit_tgt: {
    
  return (Imm & 0xffffffffULL) == static_cast<uint64_t>(Imm);

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_imm0_1: {
    
  return ((uint64_t)Imm) < 2;

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_imm0_127: {
    
  return ((uint32_t)Imm) < 128;

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_imm0_127_64b: {
    
  return ((uint64_t)Imm) < 128;

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_imm0_15: {
    
  return ((uint64_t)Imm) < 16;

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_imm0_255: {
    
  return ((uint32_t)Imm) < 256;

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_imm0_3: {
    
  return ((uint64_t)Imm) < 4;

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_imm0_31: {
    
  return ((uint64_t)Imm) < 32;

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_imm0_63: {
    
  return ((uint64_t)Imm) < 64;

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_imm0_7: {
    
  return ((uint64_t)Imm) < 8;

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_imm32_0_15: {
    
  return ((uint32_t)Imm) < 16;

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_imm32_0_31: {
    
  return ((uint64_t)Imm) < 32;

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_maski16_or_more: {
     return (Imm & 0xffff) == 0xffff; 
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_maski8_or_more: {
     return (Imm & 0xff) == 0xff; 
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_rprfop: {
    
    return (((uint32_t)Imm) <= 63);
  
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_s64imm_32bit: {
    
  int64_t Imm64 = static_cast<int64_t>(Imm);
  return Imm64 >= std::numeric_limits<int32_t>::min() &&
         Imm64 <= std::numeric_limits<int32_t>::max();

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_simm4s1: {
     return Imm >=-8  && Imm <= 7; 
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_simm4s16: {
     return Imm >=-128  && Imm <= 112 && (Imm % 16) == 0x0; 
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_simm4s2: {
     return Imm >=-16  && Imm <= 14 && (Imm % 2) == 0x0; 
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_simm4s3: {
     return Imm >=-24  && Imm <= 21 && (Imm % 3) == 0x0; 
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_simm4s32: {
     return Imm >=-256  && Imm <= 224 && (Imm % 32) == 0x0; 
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_simm4s4: {
     return Imm >=-32  && Imm <= 28 && (Imm % 4) == 0x0; 
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_simm5_16b: {
     return (int16_t)Imm >= -16 && (int16_t)Imm < 16; 
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_simm5_16b_tgt: {
     return (int16_t)Imm >= -16 && (int16_t)Imm < 16; 
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_simm5_32b: {
     return Imm >= -16 && Imm < 16; 
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_simm5_32b_tgt: {
     return (int32_t)Imm >= -16 && (int32_t)Imm < 16; 
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_simm5_64b: {
     return Imm >= -16 && Imm < 16; 
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_simm5_64b_tgt: {
     return (int64_t)Imm >= -16 && (int64_t)Imm < 16; 
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_simm5_8b: {
     return (int8_t)Imm >= -16 && (int8_t)Imm < 16; 
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_simm5_8b_tgt: {
     return (int8_t)Imm >= -16 && (int8_t)Imm < 16; 
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_simm6_32b: {
     return Imm >= -32 && Imm < 32; 
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_simm6s1: {
     return Imm >= -32 && Imm < 32; 
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_simm8_32b: {
     return Imm >= -128 && Imm < 128; 
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_simm8_64b: {
     return Imm >= -128 && Imm < 128; 
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_simm9: {
     return Imm >= -256 && Imm < 256; 
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_sme_elm_idx0_0: {
    
  return ((uint32_t)Imm) == 0;

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_sme_elm_idx0_1: {
    
  return ((uint32_t)Imm) <= 1;

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_sme_elm_idx0_15: {
    
  return ((uint32_t)Imm) <= 15;

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_sme_elm_idx0_3: {
    
  return ((uint32_t)Imm) <= 3;

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_sme_elm_idx0_7: {
    
  return ((uint32_t)Imm) <= 7;

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_svcr_op: {
    
    return AArch64SVCR::lookupSVCRByEncoding(Imm) != nullptr;
  
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_sve_elm_idx_extdup_b: {
     return ((uint64_t)Imm) < 64; 
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_sve_elm_idx_extdup_b_timm: {
     return ((uint64_t)Imm) < 64; 
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_sve_elm_idx_extdup_d: {
     return ((uint64_t)Imm) < 8; 
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_sve_elm_idx_extdup_d_timm: {
     return ((uint64_t)Imm) < 8; 
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_sve_elm_idx_extdup_h: {
     return ((uint64_t)Imm) < 32; 
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_sve_elm_idx_extdup_h_timm: {
     return ((uint64_t)Imm) < 32; 
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_sve_elm_idx_extdup_q: {
     return ((uint64_t)Imm) < 4; 
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_sve_elm_idx_extdup_q_timm: {
     return ((uint64_t)Imm) < 4; 
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_sve_elm_idx_extdup_s: {
     return ((uint64_t)Imm) < 16; 
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_sve_elm_idx_extdup_s_timm: {
     return ((uint64_t)Imm) < 16; 
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_sve_incdec_imm: {
    
  return (((uint32_t)Imm) > 0) && (((uint32_t)Imm) < 17);

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_sve_pred_enum: {
    
  return (((uint32_t)Imm) < 32);
  
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_sve_prfop: {
    
    return (((uint32_t)Imm) <= 15);
  
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_sve_vec_len_specifier_enum: {
    
  return (((uint32_t)Imm) < 2);
  
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_tbz_imm0_31_diag: {
    
  return (((uint32_t)Imm) < 32);

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_tbz_imm0_31_nodiag: {
    
  return (((uint32_t)Imm) < 32);

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_tbz_imm32_63: {
    
  return (((uint32_t)Imm) > 31) && (((uint32_t)Imm) < 64);

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_timm0_1: {
    
  return ((uint64_t)Imm) < 2;

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_timm0_31: {
    
  return ((uint64_t)Imm) < 32;

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_timm0_63: {
    
  return ((uint64_t)Imm) < 64;

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_timm32_0_1: {
    
  return ((uint32_t)Imm) < 2;

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_timm32_0_15: {
    
  return ((uint32_t)Imm) < 16;

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_timm32_0_255: {
    
  return ((uint32_t)Imm) < 256;

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_timm32_0_3: {
    
  return ((uint32_t)Imm) < 4;

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_timm32_0_31: {
    
  return ((uint32_t)Imm) < 32;

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_timm32_0_65535: {
    
  return ((uint32_t)Imm) < 65536;

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_timm32_0_7: {
    
  return ((uint32_t)Imm) < 8;

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_timm64_0_65535: {
    
  return ((uint64_t)Imm) < 65536;

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_tuimm5s2: {
     return Imm >= 0 && Imm < (32*2) && ((Imm % 2) == 0); 
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_tuimm5s4: {
     return Imm >= 0 && Imm < (32*4) && ((Imm % 4) == 0); 
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_tuimm5s8: {
     return Imm >= 0 && Imm < (32*8) && ((Imm % 8) == 0); 
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_tvecshiftL16: {
    
  return (((uint32_t)Imm) < 16);

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_tvecshiftL32: {
    
  return (((uint32_t)Imm) < 32);

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_tvecshiftL64: {
    
  return (((uint32_t)Imm) < 64);

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_tvecshiftL8: {
    
  return (((uint32_t)Imm) < 8);

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_tvecshiftR16: {
    
  return (((uint32_t)Imm) > 0) && (((uint32_t)Imm) < 17);

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_tvecshiftR32: {
    
  return (((uint32_t)Imm) > 0) && (((uint32_t)Imm) < 33);

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_tvecshiftR64: {
    
  return (((uint32_t)Imm) > 0) && (((uint32_t)Imm) < 65);

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_tvecshiftR8: {
    
  return (((uint32_t)Imm) > 0) && (((uint32_t)Imm) < 9);

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_ubsan_trap_imm: {
    
  return isUInt<8>(Imm);

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_uimm0s2range: {
     return Imm == 0; 
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_uimm0s4range: {
     return Imm == 0; 
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_uimm16: {
    return Imm >= 0 && Imm < 65536;
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_uimm1s2range: {
     return Imm >= 0 && Imm <= 2 && ((Imm % 2) == 0); 
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_uimm1s4range: {
     return Imm >= 0 && Imm <= 4 && ((Imm % 4) == 0); 
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_uimm2s2range: {
     return Imm >= 0 && Imm <= 6 && ((Imm % 2) == 0); 
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_uimm2s4range: {
     return Imm >= 0 && Imm <= 12 && ((Imm % 4) == 0); 
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_uimm3s2range: {
     return Imm >= 0 && Imm <= 14 && ((Imm % 2) == 0); 
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_uimm3s8: {
     return Imm >= 0 && Imm <= 56 && ((Imm % 8) == 0); 
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_uimm5s2: {
     return Imm >= 0 && Imm < (32*2) && ((Imm % 2) == 0); 
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_uimm5s4: {
     return Imm >= 0 && Imm < (32*4) && ((Imm % 4) == 0); 
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_uimm5s8: {
     return Imm >= 0 && Imm < (32*8) && ((Imm % 8) == 0); 
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_uimm6: {
     return Imm >= 0 && Imm < 64; 
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_uimm6s1: {
     return Imm >= 0 && Imm < 64; 
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_uimm6s16: {
     return Imm >= 0 && Imm < (64*16) && ((Imm % 16) == 0); 
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_uimm6s2: {
     return Imm >= 0 && Imm < (64*2) && ((Imm % 2) == 0); 
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_uimm6s4: {
     return Imm >= 0 && Imm < (64*4) && ((Imm % 4) == 0); 
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_uimm6s8: {
     return Imm >= 0 && Imm < (64*8) && ((Imm % 8) == 0); 
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_uimm8_32b: {
     return Imm >= 0 && Imm < 256; 
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_uimm8_64b: {
     return Imm >= 0 && Imm < 256; 
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_vecshiftL16: {
    
  return (((uint32_t)Imm) < 16);

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_vecshiftL32: {
    
  return (((uint32_t)Imm) < 32);

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_vecshiftL64: {
    
  return (((uint32_t)Imm) < 64);

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_vecshiftL8: {
    
  return (((uint32_t)Imm) < 8);

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_vecshiftR16: {
    
  return (((uint32_t)Imm) > 0) && (((uint32_t)Imm) < 17);

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_vecshiftR16Narrow: {
    
  return (((uint32_t)Imm) > 0) && (((uint32_t)Imm) < 9);

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_vecshiftR32: {
    
  return (((uint32_t)Imm) > 0) && (((uint32_t)Imm) < 33);

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_vecshiftR32Narrow: {
    
  return (((uint32_t)Imm) > 0) && (((uint32_t)Imm) < 17);

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_vecshiftR64: {
    
  return (((uint32_t)Imm) > 0) && (((uint32_t)Imm) < 65);

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_vecshiftR64Narrow: {
    
  return (((uint32_t)Imm) > 0) && (((uint32_t)Imm) < 33);

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_I64_Predicate_vecshiftR8: {
    
  return (((uint32_t)Imm) > 0) && (((uint32_t)Imm) < 9);

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  }
  llvm_unreachable("Unknown predicate");
  return false;
}
// PatFrag predicates.
enum {
  GIPFP_APFloat_Predicate_fpimm0 = GIPFP_APFloat_Invalid + 1,
  GIPFP_APFloat_Predicate_fpimm16,
  GIPFP_APFloat_Predicate_fpimm32,
  GIPFP_APFloat_Predicate_fpimm32SIMDModImmType4,
  GIPFP_APFloat_Predicate_fpimm64,
  GIPFP_APFloat_Predicate_fpimm_half,
  GIPFP_APFloat_Predicate_fpimm_minus0,
  GIPFP_APFloat_Predicate_fpimm_one,
  GIPFP_APFloat_Predicate_fpimm_two,
  GIPFP_APFloat_Predicate_simdimmtype10,
};
bool AArch64InstructionSelector::testImmPredicate_APFloat(unsigned PredicateID, const APFloat & Imm) const {
  switch (PredicateID) {
  case GIPFP_APFloat_Predicate_fpimm0: {
    
  return Imm.isExactlyValue(+0.0);

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_APFloat_Predicate_fpimm16: {
    
      return AArch64_AM::getFP16Imm(Imm) != -1;
    
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_APFloat_Predicate_fpimm32: {
    
      return AArch64_AM::getFP32Imm(Imm) != -1;
    
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_APFloat_Predicate_fpimm32SIMDModImmType4: {
    
      uint64_t Enc = Imm.bitcastToAPInt().getZExtValue();
      return Enc != 0 && AArch64_AM::isAdvSIMDModImmType4(Enc << 32 | Enc);
    
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_APFloat_Predicate_fpimm64: {
    
      return AArch64_AM::getFP64Imm(Imm) != -1;
    
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_APFloat_Predicate_fpimm_half: {
    
  return Imm.isExactlyValue(+0.5);

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_APFloat_Predicate_fpimm_minus0: {
    
  return Imm.isExactlyValue(-0.0);

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_APFloat_Predicate_fpimm_one: {
    
  return Imm.isExactlyValue(+1.0);

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_APFloat_Predicate_fpimm_two: {
    
  return Imm.isExactlyValue(+2.0);

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_APFloat_Predicate_simdimmtype10: {
    
      return AArch64_AM::isAdvSIMDModImmType10(
                 Imm.bitcastToAPInt().getZExtValue());
    
    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  }
  llvm_unreachable("Unknown predicate");
  return false;
}
// PatFrag predicates.
enum {
  GIPFP_APInt_Predicate_logical_imm32 = GIPFP_APInt_Invalid + 1,
  GIPFP_APInt_Predicate_logical_imm64,
};
bool AArch64InstructionSelector::testImmPredicate_APInt(unsigned PredicateID, const APInt & Imm) const {
  switch (PredicateID) {
  case GIPFP_APInt_Predicate_logical_imm32: {
    
  return AArch64_AM::isLogicalImmediate(Imm.getZExtValue(), 32);

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  case GIPFP_APInt_Predicate_logical_imm64: {
    
  return AArch64_AM::isLogicalImmediate(Imm.getZExtValue(), 64);

    llvm_unreachable("ImmediateCode should have returned");
    return false;
  }
  }
  llvm_unreachable("Unknown predicate");
  return false;
}
// PatFrag predicates.
enum {
  GIPFP_MI_Predicate_add_and_or_is_add = GIPFP_MI_Invalid + 1,
  GIPFP_MI_Predicate_ldaxr_1,
  GIPFP_MI_Predicate_ldaxr_2,
  GIPFP_MI_Predicate_ldaxr_4,
  GIPFP_MI_Predicate_ldaxr_8,
  GIPFP_MI_Predicate_ldxr_1,
  GIPFP_MI_Predicate_ldxr_2,
  GIPFP_MI_Predicate_ldxr_4,
  GIPFP_MI_Predicate_ldxr_8,
  GIPFP_MI_Predicate_stlxr_1,
  GIPFP_MI_Predicate_stlxr_2,
  GIPFP_MI_Predicate_stlxr_4,
  GIPFP_MI_Predicate_stlxr_8,
  GIPFP_MI_Predicate_stxr_1,
  GIPFP_MI_Predicate_stxr_2,
  GIPFP_MI_Predicate_stxr_4,
  GIPFP_MI_Predicate_stxr_8,
};
bool AArch64InstructionSelector::testMIPredicate_MI(unsigned PredicateID, const MachineInstr & MI, const std::array<const MachineOperand *, 3> &Operands) const {
  const MachineFunction &MF = *MI.getParent()->getParent();
  const MachineRegisterInfo &MRI = MF.getRegInfo();
  (void)MRI;
  switch (PredicateID) {
  case GIPFP_MI_Predicate_add_and_or_is_add: {
    
     // Only handle G_ADD for now. FIXME. build capability to compute whether
     // operands of G_OR have common bits set or not.
     return MI.getOpcode() == TargetOpcode::G_ADD;
  
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_ldaxr_1: {
     return isLoadStoreOfNumBytes(MI, 1); 
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_ldaxr_2: {
     return isLoadStoreOfNumBytes(MI, 2); 
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_ldaxr_4: {
     return isLoadStoreOfNumBytes(MI, 4); 
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_ldaxr_8: {
     return isLoadStoreOfNumBytes(MI, 8); 
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_ldxr_1: {
     return isLoadStoreOfNumBytes(MI, 1); 
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_ldxr_2: {
     return isLoadStoreOfNumBytes(MI, 2); 
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_ldxr_4: {
     return isLoadStoreOfNumBytes(MI, 4); 
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_ldxr_8: {
     return isLoadStoreOfNumBytes(MI, 8); 
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_stlxr_1: {
     return isLoadStoreOfNumBytes(MI, 1); 
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_stlxr_2: {
     return isLoadStoreOfNumBytes(MI, 2); 
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_stlxr_4: {
     return isLoadStoreOfNumBytes(MI, 4); 
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_stlxr_8: {
     return isLoadStoreOfNumBytes(MI, 8); 
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_stxr_1: {
     return isLoadStoreOfNumBytes(MI, 1); 
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_stxr_2: {
     return isLoadStoreOfNumBytes(MI, 2); 
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_stxr_4: {
     return isLoadStoreOfNumBytes(MI, 4); 
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  case GIPFP_MI_Predicate_stxr_8: {
     return isLoadStoreOfNumBytes(MI, 8); 
    llvm_unreachable("GISelPredicateCode should have returned");
    return false;
  }
  }
  llvm_unreachable("Unknown predicate");
  return false;
}

AArch64InstructionSelector::ComplexMatcherMemFn
AArch64InstructionSelector::ComplexPredicateFns[] = {
  nullptr, // GICP_Invalid
  &AArch64InstructionSelector::selectArithImmed, // gi_addsub_shifted_imm32
  &AArch64InstructionSelector::selectArithImmed, // gi_addsub_shifted_imm64
  &AArch64InstructionSelector::selectAddrModeIndexed<128>, // gi_am_indexed128
  &AArch64InstructionSelector::selectAddrModeIndexed<16>, // gi_am_indexed16
  &AArch64InstructionSelector::selectAddrModeIndexed<32>, // gi_am_indexed32
  &AArch64InstructionSelector::selectAddrModeIndexed<64>, // gi_am_indexed64
  &AArch64InstructionSelector::selectAddrModeIndexed<8>, // gi_am_indexed8
  &AArch64InstructionSelector::selectAddrModeUnscaled128, // gi_am_unscaled128
  &AArch64InstructionSelector::selectAddrModeUnscaled16, // gi_am_unscaled16
  &AArch64InstructionSelector::selectAddrModeUnscaled32, // gi_am_unscaled32
  &AArch64InstructionSelector::selectAddrModeUnscaled64, // gi_am_unscaled64
  &AArch64InstructionSelector::selectAddrModeUnscaled8, // gi_am_unscaled8
  &AArch64InstructionSelector::selectArithExtendedRegister, // gi_arith_extended_reg32_i32
  &AArch64InstructionSelector::selectArithExtendedRegister, // gi_arith_extended_reg32_i64
  &AArch64InstructionSelector::selectArithExtendedRegister, // gi_arith_extended_reg32to64_i64
  &AArch64InstructionSelector::selectArithShiftedRegister, // gi_arith_shifted_reg32
  &AArch64InstructionSelector::selectArithShiftedRegister, // gi_arith_shifted_reg64
  &AArch64InstructionSelector::selectLogicalShiftedRegister, // gi_logical_shifted_reg32
  &AArch64InstructionSelector::selectLogicalShiftedRegister, // gi_logical_shifted_reg64
  &AArch64InstructionSelector::selectNegArithImmed, // gi_neg_addsub_shifted_imm32
  &AArch64InstructionSelector::selectNegArithImmed, // gi_neg_addsub_shifted_imm64
  &AArch64InstructionSelector::selectAddrModeWRO<128>, // gi_ro_Windexed128
  &AArch64InstructionSelector::selectAddrModeWRO<16>, // gi_ro_Windexed16
  &AArch64InstructionSelector::selectAddrModeWRO<32>, // gi_ro_Windexed32
  &AArch64InstructionSelector::selectAddrModeWRO<64>, // gi_ro_Windexed64
  &AArch64InstructionSelector::selectAddrModeWRO<8>, // gi_ro_Windexed8
  &AArch64InstructionSelector::selectAddrModeXRO<128>, // gi_ro_Xindexed128
  &AArch64InstructionSelector::selectAddrModeXRO<16>, // gi_ro_Xindexed16
  &AArch64InstructionSelector::selectAddrModeXRO<32>, // gi_ro_Xindexed32
  &AArch64InstructionSelector::selectAddrModeXRO<64>, // gi_ro_Xindexed64
  &AArch64InstructionSelector::selectAddrModeXRO<8>, // gi_ro_Xindexed8
};

// Custom renderers.
enum {
  GICR_Invalid,
  GICR_renderFPImm16,
  GICR_renderFPImm32,
  GICR_renderFPImm32SIMDModImmType4,
  GICR_renderFPImm64,
  GICR_renderLogicalImm32,
  GICR_renderLogicalImm64,
  GICR_renderTruncImm,
};
AArch64InstructionSelector::CustomRendererFn
AArch64InstructionSelector::CustomRenderers[] = {
  nullptr, // GICR_Invalid
  &AArch64InstructionSelector::renderFPImm16,
  &AArch64InstructionSelector::renderFPImm32,
  &AArch64InstructionSelector::renderFPImm32SIMDModImmType4,
  &AArch64InstructionSelector::renderFPImm64,
  &AArch64InstructionSelector::renderLogicalImm32,
  &AArch64InstructionSelector::renderLogicalImm64,
  &AArch64InstructionSelector::renderTruncImm,
};

bool AArch64InstructionSelector::selectImpl(MachineInstr &I, CodeGenCoverage &CoverageInfo) const {
  MachineFunction &MF = *I.getParent()->getParent();
  MachineRegisterInfo &MRI = MF.getRegInfo();
  const PredicateBitset AvailableFeatures = getAvailableFeatures();
  NewMIVector OutMIs;
  State.MIs.clear();
  State.MIs.push_back(&I);

  if (executeMatchTable(*this, OutMIs, State, ISelInfo, getMatchTable(), TII, MRI, TRI, RBI, AvailableFeatures, CoverageInfo)) {
    return true;
  }

  return false;
}

const int64_t *AArch64InstructionSelector::getMatchTable() const {
  constexpr static int64_t MatchTable0[] = {
    GIM_SwitchOpcode, /*MI*/0, /*[*/46, 773, /*)*//*default:*//*Label 119*/ 199135,
    /*TargetOpcode::G_ADD*//*Label 0*/ 732,
    /*TargetOpcode::G_SUB*//*Label 1*/ 12245,
    /*TargetOpcode::G_MUL*//*Label 2*/ 16113,
    /*TargetOpcode::G_SDIV*//*Label 3*/ 17428,
    /*TargetOpcode::G_UDIV*//*Label 4*/ 17497, 0, 0, 0, 0,
    /*TargetOpcode::G_AND*//*Label 5*/ 17566,
    /*TargetOpcode::G_OR*//*Label 6*/ 20738,
    /*TargetOpcode::G_XOR*//*Label 7*/ 32335, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    /*TargetOpcode::G_CONCAT_VECTORS*//*Label 8*/ 36564, 0, 0,
    /*TargetOpcode::G_BITCAST*//*Label 9*/ 44956, 0, 0,
    /*TargetOpcode::G_INTRINSIC_TRUNC*//*Label 10*/ 56739,
    /*TargetOpcode::G_INTRINSIC_ROUND*//*Label 11*/ 56972,
    /*TargetOpcode::G_INTRINSIC_LRINT*//*Label 12*/ 57205, 0,
    /*TargetOpcode::G_READCYCLECOUNTER*//*Label 13*/ 57472,
    /*TargetOpcode::G_LOAD*//*Label 14*/ 57498,
    /*TargetOpcode::G_SEXTLOAD*//*Label 15*/ 65308,
    /*TargetOpcode::G_ZEXTLOAD*//*Label 16*/ 66279, 0, 0, 0,
    /*TargetOpcode::G_STORE*//*Label 17*/ 68854, 0, 0,
    /*TargetOpcode::G_ATOMIC_CMPXCHG*//*Label 18*/ 77897,
    /*TargetOpcode::G_ATOMICRMW_XCHG*//*Label 19*/ 79342,
    /*TargetOpcode::G_ATOMICRMW_ADD*//*Label 20*/ 80371,
    /*TargetOpcode::G_ATOMICRMW_SUB*//*Label 21*/ 81400,
    /*TargetOpcode::G_ATOMICRMW_AND*//*Label 22*/ 82829, 0,
    /*TargetOpcode::G_ATOMICRMW_OR*//*Label 23*/ 84258,
    /*TargetOpcode::G_ATOMICRMW_XOR*//*Label 24*/ 85287,
    /*TargetOpcode::G_ATOMICRMW_MAX*//*Label 25*/ 86316,
    /*TargetOpcode::G_ATOMICRMW_MIN*//*Label 26*/ 87345,
    /*TargetOpcode::G_ATOMICRMW_UMAX*//*Label 27*/ 88374,
    /*TargetOpcode::G_ATOMICRMW_UMIN*//*Label 28*/ 89403, 0, 0, 0, 0, 0, 0,
    /*TargetOpcode::G_FENCE*//*Label 29*/ 90432, 0, 0, 0,
    /*TargetOpcode::G_INTRINSIC*//*Label 30*/ 90484,
    /*TargetOpcode::G_INTRINSIC_W_SIDE_EFFECTS*//*Label 31*/ 135866,
    /*TargetOpcode::G_ANYEXT*//*Label 32*/ 140836,
    /*TargetOpcode::G_TRUNC*//*Label 33*/ 141013,
    /*TargetOpcode::G_CONSTANT*//*Label 34*/ 142021,
    /*TargetOpcode::G_FCONSTANT*//*Label 35*/ 142129, 0, 0,
    /*TargetOpcode::G_SEXT*//*Label 36*/ 142341, 0,
    /*TargetOpcode::G_ZEXT*//*Label 37*/ 142676,
    /*TargetOpcode::G_SHL*//*Label 38*/ 143135,
    /*TargetOpcode::G_LSHR*//*Label 39*/ 143448,
    /*TargetOpcode::G_ASHR*//*Label 40*/ 143833, 0, 0,
    /*TargetOpcode::G_ROTR*//*Label 41*/ 144328, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    /*TargetOpcode::G_UMULH*//*Label 42*/ 144817,
    /*TargetOpcode::G_SMULH*//*Label 43*/ 145250,
    /*TargetOpcode::G_UADDSAT*//*Label 44*/ 145683,
    /*TargetOpcode::G_SADDSAT*//*Label 45*/ 145921,
    /*TargetOpcode::G_USUBSAT*//*Label 46*/ 146159,
    /*TargetOpcode::G_SSUBSAT*//*Label 47*/ 146397, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    /*TargetOpcode::G_FADD*//*Label 48*/ 146635,
    /*TargetOpcode::G_FSUB*//*Label 49*/ 147553,
    /*TargetOpcode::G_FMUL*//*Label 50*/ 147850,
    /*TargetOpcode::G_FMA*//*Label 51*/ 150003, 0,
    /*TargetOpcode::G_FDIV*//*Label 52*/ 160215, 0, 0, 0, 0, 0, 0, 0, 0,
    /*TargetOpcode::G_FNEG*//*Label 53*/ 160512,
    /*TargetOpcode::G_FPEXT*//*Label 54*/ 161390,
    /*TargetOpcode::G_FPTRUNC*//*Label 55*/ 161534,
    /*TargetOpcode::G_FPTOSI*//*Label 56*/ 161678,
    /*TargetOpcode::G_FPTOUI*//*Label 57*/ 162699,
    /*TargetOpcode::G_SITOFP*//*Label 58*/ 163720,
    /*TargetOpcode::G_UITOFP*//*Label 59*/ 166465,
    /*TargetOpcode::G_FABS*//*Label 60*/ 168538, 0, 0, 0,
    /*TargetOpcode::G_FMINNUM*//*Label 61*/ 169099,
    /*TargetOpcode::G_FMAXNUM*//*Label 62*/ 169411, 0, 0,
    /*TargetOpcode::G_FMINIMUM*//*Label 63*/ 169723,
    /*TargetOpcode::G_FMAXIMUM*//*Label 64*/ 170035, 0, 0,
    /*TargetOpcode::G_SMIN*//*Label 65*/ 170347,
    /*TargetOpcode::G_SMAX*//*Label 66*/ 170696,
    /*TargetOpcode::G_UMIN*//*Label 67*/ 171045,
    /*TargetOpcode::G_UMAX*//*Label 68*/ 171394,
    /*TargetOpcode::G_ABS*//*Label 69*/ 171743,
    /*TargetOpcode::G_LROUND*//*Label 70*/ 172245,
    /*TargetOpcode::G_LLROUND*//*Label 71*/ 172380,
    /*TargetOpcode::G_BR*//*Label 72*/ 172450, 0, 0,
    /*TargetOpcode::G_EXTRACT_VECTOR_ELT*//*Label 73*/ 172463, 0,
    /*TargetOpcode::G_CTTZ*//*Label 74*/ 174721, 0,
    /*TargetOpcode::G_CTLZ*//*Label 75*/ 174852, 0,
    /*TargetOpcode::G_CTPOP*//*Label 76*/ 175475,
    /*TargetOpcode::G_BSWAP*//*Label 77*/ 175588,
    /*TargetOpcode::G_BITREVERSE*//*Label 78*/ 175733,
    /*TargetOpcode::G_FCEIL*//*Label 79*/ 175842, 0, 0,
    /*TargetOpcode::G_FSQRT*//*Label 80*/ 176075,
    /*TargetOpcode::G_FFLOOR*//*Label 81*/ 176308,
    /*TargetOpcode::G_FRINT*//*Label 82*/ 176541,
    /*TargetOpcode::G_FNEARBYINT*//*Label 83*/ 176774, 0, 0, 0, 0,
    /*TargetOpcode::G_STRICT_FADD*//*Label 84*/ 177007,
    /*TargetOpcode::G_STRICT_FSUB*//*Label 85*/ 177795,
    /*TargetOpcode::G_STRICT_FMUL*//*Label 86*/ 178092,
    /*TargetOpcode::G_STRICT_FDIV*//*Label 87*/ 179983, 0,
    /*TargetOpcode::G_STRICT_FMA*//*Label 88*/ 180280,
    /*TargetOpcode::G_STRICT_FSQRT*//*Label 89*/ 189794, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    /*AArch64::G_BIT*//*Label 90*/ 190027,
    /*AArch64::G_DUP*//*Label 91*/ 190363,
    /*AArch64::G_DUPLANE16*//*Label 92*/ 191942,
    /*AArch64::G_DUPLANE32*//*Label 93*/ 192195,
    /*AArch64::G_DUPLANE64*//*Label 94*/ 192382,
    /*AArch64::G_DUPLANE8*//*Label 95*/ 192474,
    /*AArch64::G_EXT*//*Label 96*/ 192588,
    /*AArch64::G_FCMEQ*//*Label 97*/ 193412,
    /*AArch64::G_FCMEQZ*//*Label 98*/ 193690,
    /*AArch64::G_FCMGE*//*Label 99*/ 193867,
    /*AArch64::G_FCMGEZ*//*Label 100*/ 194145,
    /*AArch64::G_FCMGT*//*Label 101*/ 194322,
    /*AArch64::G_FCMGTZ*//*Label 102*/ 194600,
    /*AArch64::G_FCMLEZ*//*Label 103*/ 194777,
    /*AArch64::G_FCMLTZ*//*Label 104*/ 194954,
    /*AArch64::G_PREFETCH*//*Label 105*/ 195131,
    /*AArch64::G_REV16*//*Label 106*/ 195258,
    /*AArch64::G_REV32*//*Label 107*/ 195316,
    /*AArch64::G_REV64*//*Label 108*/ 195466,
    /*AArch64::G_SITOF*//*Label 109*/ 195690,
    /*AArch64::G_TRN1*//*Label 110*/ 195781,
    /*AArch64::G_TRN2*//*Label 111*/ 196146,
    /*AArch64::G_UITOF*//*Label 112*/ 196511,
    /*AArch64::G_UZP1*//*Label 113*/ 196602,
    /*AArch64::G_UZP2*//*Label 114*/ 196967,
    /*AArch64::G_VASHR*//*Label 115*/ 197332,
    /*AArch64::G_VLSHR*//*Label 116*/ 197967,
    /*AArch64::G_ZIP1*//*Label 117*/ 198405,
    /*AArch64::G_ZIP2*//*Label 118*/ 198770,
    // Label 0: @732
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/1, 11, /*)*//*default:*//*Label 129*/ 12244,
    /*GILLT_s32*//*Label 120*/ 748,
    /*GILLT_s64*//*Label 121*/ 2165, 0,
    /*GILLT_v2s32*//*Label 122*/ 4587,
    /*GILLT_v2s64*//*Label 123*/ 5386,
    /*GILLT_v4s16*//*Label 124*/ 6841,
    /*GILLT_v4s32*//*Label 125*/ 7640,
    /*GILLT_v8s8*//*Label 126*/ 9367,
    /*GILLT_v8s16*//*Label 127*/ 9942,
    /*GILLT_v16s8*//*Label 128*/ 11669,
    // Label 120: @748
    GIM_Try, /*On fail goto*//*Label 130*/ 2164,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 131*/ 792, // Rule ID 10620 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32spRegClassID,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_addsub_shifted_imm32,
        // (add:{ *:[i32] } addsub_shifted_imm32:{ *:[i32] }:$imm, GPR32sp:{ *:[i32] }:$Rn)  =>  (ADDWri:{ *:[i32] } GPR32sp:{ *:[i32] }:$Rn, addsub_shifted_imm32:{ *:[i32] }:$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::ADDWri,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/0, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 10620,
        GIR_Done,
      // Label 131: @792
      GIM_Try, /*On fail goto*//*Label 132*/ 931, // Rule ID 11401 //
        GIM_CheckFeatures, GIFBS_HasSVEorSME_UseScalarIncVL,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_TRUNC,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/2, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, Intrinsic::aarch64_sve_cnth,
        // MIs[2] pattern
        GIM_CheckIsImm, /*MI*/2, /*Op*/2,
        GIM_CheckImmOperandPredicate, /*MI*/2, /*MO*/2, /*Predicate*/GIPFP_I64_Predicate_sve_pred_enum,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[i32] } (trunc:{ *:[i32] } (intrinsic_wo_chain:{ *:[i64] } 889:{ *:[iPTR] }, (timm:{ *:[i32] })<<P:Predicate_sve_pred_enum>>:$pattern)), GPR32:{ *:[i32] }:$Rdn)  =>  (EXTRACT_SUBREG:{ *:[i32] } (INCH_XPiI:{ *:[i64] } (INSERT_SUBREG:{ *:[i64] } (IMPLICIT_DEF:{ *:[i64] }), GPR32:{ *:[i32] }:$Rdn, sub_32:{ *:[i32] }), (timm:{ *:[i32] })<<P:Predicate_sve_pred_enum>>:$pattern, 1:{ *:[i32] }), sub_32:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s64,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::INSERT_SUBREG,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/2, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/2, // Rdn
        GIR_AddImm, /*InsnID*/2, /*Imm*/15,
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, AArch64::GPR64allRegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, AArch64::GPR64allRegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/2, AArch64::GPR32RegClassID,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AArch64::INCH_XPiI,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/2, /*OpIdx*/2, // pattern
        GIR_AddImm, /*InsnID*/1, /*Imm*/1,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0, AArch64::sub_32,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AArch64::GPR32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, AArch64::GPR64RegClassID,
        // GIR_Coverage, 11401,
        GIR_Done,
      // Label 132: @931
      GIM_Try, /*On fail goto*//*Label 133*/ 1070, // Rule ID 11413 //
        GIM_CheckFeatures, GIFBS_HasSVEorSME_UseScalarIncVL,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_TRUNC,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/2, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, Intrinsic::aarch64_sve_cntw,
        // MIs[2] pattern
        GIM_CheckIsImm, /*MI*/2, /*Op*/2,
        GIM_CheckImmOperandPredicate, /*MI*/2, /*MO*/2, /*Predicate*/GIPFP_I64_Predicate_sve_pred_enum,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[i32] } (trunc:{ *:[i32] } (intrinsic_wo_chain:{ *:[i64] } 891:{ *:[iPTR] }, (timm:{ *:[i32] })<<P:Predicate_sve_pred_enum>>:$pattern)), GPR32:{ *:[i32] }:$Rdn)  =>  (EXTRACT_SUBREG:{ *:[i32] } (INCW_XPiI:{ *:[i64] } (INSERT_SUBREG:{ *:[i64] } (IMPLICIT_DEF:{ *:[i64] }), GPR32:{ *:[i32] }:$Rdn, sub_32:{ *:[i32] }), (timm:{ *:[i32] })<<P:Predicate_sve_pred_enum>>:$pattern, 1:{ *:[i32] }), sub_32:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s64,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::INSERT_SUBREG,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/2, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/2, // Rdn
        GIR_AddImm, /*InsnID*/2, /*Imm*/15,
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, AArch64::GPR64allRegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, AArch64::GPR64allRegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/2, AArch64::GPR32RegClassID,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AArch64::INCW_XPiI,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/2, /*OpIdx*/2, // pattern
        GIR_AddImm, /*InsnID*/1, /*Imm*/1,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0, AArch64::sub_32,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AArch64::GPR32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, AArch64::GPR64RegClassID,
        // GIR_Coverage, 11413,
        GIR_Done,
      // Label 133: @1070
      GIM_Try, /*On fail goto*//*Label 134*/ 1209, // Rule ID 11425 //
        GIM_CheckFeatures, GIFBS_HasSVEorSME_UseScalarIncVL,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_TRUNC,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/2, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, Intrinsic::aarch64_sve_cntd,
        // MIs[2] pattern
        GIM_CheckIsImm, /*MI*/2, /*Op*/2,
        GIM_CheckImmOperandPredicate, /*MI*/2, /*MO*/2, /*Predicate*/GIPFP_I64_Predicate_sve_pred_enum,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[i32] } (trunc:{ *:[i32] } (intrinsic_wo_chain:{ *:[i64] } 888:{ *:[iPTR] }, (timm:{ *:[i32] })<<P:Predicate_sve_pred_enum>>:$pattern)), GPR32:{ *:[i32] }:$Rdn)  =>  (EXTRACT_SUBREG:{ *:[i32] } (INCD_XPiI:{ *:[i64] } (INSERT_SUBREG:{ *:[i64] } (IMPLICIT_DEF:{ *:[i64] }), GPR32:{ *:[i32] }:$Rdn, sub_32:{ *:[i32] }), (timm:{ *:[i32] })<<P:Predicate_sve_pred_enum>>:$pattern, 1:{ *:[i32] }), sub_32:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s64,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::INSERT_SUBREG,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/2, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/2, // Rdn
        GIR_AddImm, /*InsnID*/2, /*Imm*/15,
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, AArch64::GPR64allRegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, AArch64::GPR64allRegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/2, AArch64::GPR32RegClassID,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AArch64::INCD_XPiI,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/2, /*OpIdx*/2, // pattern
        GIR_AddImm, /*InsnID*/1, /*Imm*/1,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0, AArch64::sub_32,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AArch64::GPR32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, AArch64::GPR64RegClassID,
        // GIR_Coverage, 11425,
        GIR_Done,
      // Label 134: @1209
      GIM_Try, /*On fail goto*//*Label 135*/ 1348, // Rule ID 11535 //
        GIM_CheckFeatures, GIFBS_HasSVEorSME_UseScalarIncVL,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_TRUNC,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/2, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, Intrinsic::aarch64_sve_cntb,
        // MIs[2] pattern
        GIM_CheckIsImm, /*MI*/2, /*Op*/2,
        GIM_CheckImmOperandPredicate, /*MI*/2, /*MO*/2, /*Predicate*/GIPFP_I64_Predicate_sve_pred_enum,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[i32] } (trunc:{ *:[i32] } (intrinsic_wo_chain:{ *:[i64] } 887:{ *:[iPTR] }, (timm:{ *:[i32] })<<P:Predicate_sve_pred_enum>>:$pattern)), GPR32:{ *:[i32] }:$Rdn)  =>  (EXTRACT_SUBREG:{ *:[i32] } (INCB_XPiI:{ *:[i64] } (INSERT_SUBREG:{ *:[i64] } (IMPLICIT_DEF:{ *:[i64] }), GPR32:{ *:[i32] }:$Rdn, sub_32:{ *:[i32] }), (timm:{ *:[i32] })<<P:Predicate_sve_pred_enum>>:$pattern, 1:{ *:[i32] }), sub_32:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s64,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::INSERT_SUBREG,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/2, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/2, // Rdn
        GIR_AddImm, /*InsnID*/2, /*Imm*/15,
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, AArch64::GPR64allRegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, AArch64::GPR64allRegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/2, AArch64::GPR32RegClassID,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AArch64::INCB_XPiI,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/2, /*OpIdx*/2, // pattern
        GIR_AddImm, /*InsnID*/1, /*Imm*/1,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0, AArch64::sub_32,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AArch64::GPR32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, AArch64::GPR64RegClassID,
        // GIR_Coverage, 11535,
        GIR_Done,
      // Label 135: @1348
      GIM_Try, /*On fail goto*//*Label 136*/ 1382, // Rule ID 93 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR32spRegClassID,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/0, GICP_gi_addsub_shifted_imm32,
        // (add:{ *:[i32] } GPR32sp:{ *:[i32] }:$Rn, addsub_shifted_imm32:{ *:[i32] }:$imm)  =>  (ADDWri:{ *:[i32] } GPR32sp:{ *:[i32] }:$Rn, addsub_shifted_imm32:{ *:[i32] }:$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::ADDWri,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/0, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 93,
        GIR_Done,
      // Label 136: @1382
      GIM_Try, /*On fail goto*//*Label 137*/ 1521, // Rule ID 4540 //
        GIM_CheckFeatures, GIFBS_HasSVEorSME_UseScalarIncVL,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_TRUNC,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/2, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, Intrinsic::aarch64_sve_cnth,
        // MIs[2] pattern
        GIM_CheckIsImm, /*MI*/2, /*Op*/2,
        GIM_CheckImmOperandPredicate, /*MI*/2, /*MO*/2, /*Predicate*/GIPFP_I64_Predicate_sve_pred_enum,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[i32] } GPR32:{ *:[i32] }:$Rdn, (trunc:{ *:[i32] } (intrinsic_wo_chain:{ *:[i64] } 889:{ *:[iPTR] }, (timm:{ *:[i32] })<<P:Predicate_sve_pred_enum>>:$pattern)))  =>  (EXTRACT_SUBREG:{ *:[i32] } (INCH_XPiI:{ *:[i64] } (INSERT_SUBREG:{ *:[i64] } (IMPLICIT_DEF:{ *:[i64] }), GPR32:{ *:[i32] }:$Rdn, sub_32:{ *:[i32] }), (timm:{ *:[i32] })<<P:Predicate_sve_pred_enum>>:$pattern, 1:{ *:[i32] }), sub_32:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s64,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::INSERT_SUBREG,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/2, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // Rdn
        GIR_AddImm, /*InsnID*/2, /*Imm*/15,
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, AArch64::GPR64allRegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, AArch64::GPR64allRegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/2, AArch64::GPR32RegClassID,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AArch64::INCH_XPiI,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/2, /*OpIdx*/2, // pattern
        GIR_AddImm, /*InsnID*/1, /*Imm*/1,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0, AArch64::sub_32,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AArch64::GPR32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, AArch64::GPR64RegClassID,
        // GIR_Coverage, 4540,
        GIR_Done,
      // Label 137: @1521
      GIM_Try, /*On fail goto*//*Label 138*/ 1660, // Rule ID 4552 //
        GIM_CheckFeatures, GIFBS_HasSVEorSME_UseScalarIncVL,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_TRUNC,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/2, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, Intrinsic::aarch64_sve_cntw,
        // MIs[2] pattern
        GIM_CheckIsImm, /*MI*/2, /*Op*/2,
        GIM_CheckImmOperandPredicate, /*MI*/2, /*MO*/2, /*Predicate*/GIPFP_I64_Predicate_sve_pred_enum,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[i32] } GPR32:{ *:[i32] }:$Rdn, (trunc:{ *:[i32] } (intrinsic_wo_chain:{ *:[i64] } 891:{ *:[iPTR] }, (timm:{ *:[i32] })<<P:Predicate_sve_pred_enum>>:$pattern)))  =>  (EXTRACT_SUBREG:{ *:[i32] } (INCW_XPiI:{ *:[i64] } (INSERT_SUBREG:{ *:[i64] } (IMPLICIT_DEF:{ *:[i64] }), GPR32:{ *:[i32] }:$Rdn, sub_32:{ *:[i32] }), (timm:{ *:[i32] })<<P:Predicate_sve_pred_enum>>:$pattern, 1:{ *:[i32] }), sub_32:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s64,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::INSERT_SUBREG,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/2, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // Rdn
        GIR_AddImm, /*InsnID*/2, /*Imm*/15,
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, AArch64::GPR64allRegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, AArch64::GPR64allRegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/2, AArch64::GPR32RegClassID,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AArch64::INCW_XPiI,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/2, /*OpIdx*/2, // pattern
        GIR_AddImm, /*InsnID*/1, /*Imm*/1,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0, AArch64::sub_32,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AArch64::GPR32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, AArch64::GPR64RegClassID,
        // GIR_Coverage, 4552,
        GIR_Done,
      // Label 138: @1660
      GIM_Try, /*On fail goto*//*Label 139*/ 1799, // Rule ID 4564 //
        GIM_CheckFeatures, GIFBS_HasSVEorSME_UseScalarIncVL,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_TRUNC,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/2, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, Intrinsic::aarch64_sve_cntd,
        // MIs[2] pattern
        GIM_CheckIsImm, /*MI*/2, /*Op*/2,
        GIM_CheckImmOperandPredicate, /*MI*/2, /*MO*/2, /*Predicate*/GIPFP_I64_Predicate_sve_pred_enum,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[i32] } GPR32:{ *:[i32] }:$Rdn, (trunc:{ *:[i32] } (intrinsic_wo_chain:{ *:[i64] } 888:{ *:[iPTR] }, (timm:{ *:[i32] })<<P:Predicate_sve_pred_enum>>:$pattern)))  =>  (EXTRACT_SUBREG:{ *:[i32] } (INCD_XPiI:{ *:[i64] } (INSERT_SUBREG:{ *:[i64] } (IMPLICIT_DEF:{ *:[i64] }), GPR32:{ *:[i32] }:$Rdn, sub_32:{ *:[i32] }), (timm:{ *:[i32] })<<P:Predicate_sve_pred_enum>>:$pattern, 1:{ *:[i32] }), sub_32:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s64,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::INSERT_SUBREG,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/2, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // Rdn
        GIR_AddImm, /*InsnID*/2, /*Imm*/15,
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, AArch64::GPR64allRegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, AArch64::GPR64allRegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/2, AArch64::GPR32RegClassID,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AArch64::INCD_XPiI,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/2, /*OpIdx*/2, // pattern
        GIR_AddImm, /*InsnID*/1, /*Imm*/1,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0, AArch64::sub_32,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AArch64::GPR32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, AArch64::GPR64RegClassID,
        // GIR_Coverage, 4564,
        GIR_Done,
      // Label 139: @1799
      GIM_Try, /*On fail goto*//*Label 140*/ 1938, // Rule ID 6935 //
        GIM_CheckFeatures, GIFBS_HasSVEorSME_UseScalarIncVL,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_TRUNC,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/2, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, Intrinsic::aarch64_sve_cntb,
        // MIs[2] pattern
        GIM_CheckIsImm, /*MI*/2, /*Op*/2,
        GIM_CheckImmOperandPredicate, /*MI*/2, /*MO*/2, /*Predicate*/GIPFP_I64_Predicate_sve_pred_enum,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[i32] } GPR32:{ *:[i32] }:$Rdn, (trunc:{ *:[i32] } (intrinsic_wo_chain:{ *:[i64] } 887:{ *:[iPTR] }, (timm:{ *:[i32] })<<P:Predicate_sve_pred_enum>>:$pattern)))  =>  (EXTRACT_SUBREG:{ *:[i32] } (INCB_XPiI:{ *:[i64] } (INSERT_SUBREG:{ *:[i64] } (IMPLICIT_DEF:{ *:[i64] }), GPR32:{ *:[i32] }:$Rdn, sub_32:{ *:[i32] }), (timm:{ *:[i32] })<<P:Predicate_sve_pred_enum>>:$pattern, 1:{ *:[i32] }), sub_32:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s64,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::INSERT_SUBREG,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/2, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // Rdn
        GIR_AddImm, /*InsnID*/2, /*Imm*/15,
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, AArch64::GPR64allRegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, AArch64::GPR64allRegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/2, AArch64::GPR32RegClassID,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AArch64::INCB_XPiI,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/2, /*OpIdx*/2, // pattern
        GIR_AddImm, /*InsnID*/1, /*Imm*/1,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0, AArch64::sub_32,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AArch64::GPR32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, AArch64::GPR64RegClassID,
        // GIR_Coverage, 6935,
        GIR_Done,
      // Label 140: @1938
      GIM_Try, /*On fail goto*//*Label 141*/ 1972, // Rule ID 10624 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32spRegClassID,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_arith_extended_reg32_i32,
        // (add:{ *:[i32] } arith_extended_reg32_i32:{ *:[i32] }:$Rm_and_extend, GPR32sp:{ *:[i32] }:$Rn)  =>  (ADDWrx:{ *:[i32] } GPR32sp:{ *:[i32] }:$Rn, arith_extended_reg32_i32:{ *:[i32] }:$Rm_and_extend)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::ADDWrx,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/0, // Rm_and_extend
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 10624,
        GIR_Done,
      // Label 141: @1972
      GIM_Try, /*On fail goto*//*Label 142*/ 2006, // Rule ID 11656 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_neg_addsub_shifted_imm32,
        // (add:{ *:[i32] } neg_addsub_shifted_imm32:{ *:[i32] }:$imm, GPR32:{ *:[i32] }:$Rn)  =>  (SUBSWri:{ *:[i32] }:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, neg_addsub_shifted_imm32:{ *:[i32] }:$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SUBSWri,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/0, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11656,
        GIR_Done,
      // Label 142: @2006
      GIM_Try, /*On fail goto*//*Label 143*/ 2040, // Rule ID 99 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR32spRegClassID,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/0, GICP_gi_arith_extended_reg32_i32,
        // (add:{ *:[i32] } GPR32sp:{ *:[i32] }:$Rn, arith_extended_reg32_i32:{ *:[i32] }:$Rm_and_extend)  =>  (ADDWrx:{ *:[i32] } GPR32sp:{ *:[i32] }:$Rn, arith_extended_reg32_i32:{ *:[i32] }:$Rm_and_extend)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::ADDWrx,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/0, // Rm_and_extend
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 99,
        GIR_Done,
      // Label 143: @2040
      GIM_Try, /*On fail goto*//*Label 144*/ 2074, // Rule ID 7883 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/0, GICP_gi_neg_addsub_shifted_imm32,
        // (add:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, neg_addsub_shifted_imm32:{ *:[i32] }:$imm)  =>  (SUBSWri:{ *:[i32] }:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, neg_addsub_shifted_imm32:{ *:[i32] }:$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SUBSWri,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/0, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 7883,
        GIR_Done,
      // Label 144: @2074
      GIM_Try, /*On fail goto*//*Label 145*/ 2108, // Rule ID 10622 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_arith_shifted_reg32,
        // (add:{ *:[i32] } arith_shifted_reg32:{ *:[i32] }:$Rm_and_shift, GPR32:{ *:[i32] }:$Rn)  =>  (ADDWrs:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, arith_shifted_reg32:{ *:[i32] }:$Rm_and_shift)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::ADDWrs,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/0, // Rm_and_shift
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 10622,
        GIR_Done,
      // Label 145: @2108
      GIM_Try, /*On fail goto*//*Label 146*/ 2142, // Rule ID 97 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/0, GICP_gi_arith_shifted_reg32,
        // (add:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, arith_shifted_reg32:{ *:[i32] }:$Rm_and_shift)  =>  (ADDWrs:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, arith_shifted_reg32:{ *:[i32] }:$Rm_and_shift)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::ADDWrs,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/0, // Rm_and_shift
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 97,
        GIR_Done,
      // Label 146: @2142
      GIM_Try, /*On fail goto*//*Label 147*/ 2163, // Rule ID 95 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        // (add:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, GPR32:{ *:[i32] }:$Rm)  =>  (ADDWrr:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, GPR32:{ *:[i32] }:$Rm)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::ADDWrr,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 95,
        GIR_Done,
      // Label 147: @2163
      GIM_Reject,
    // Label 130: @2164
    GIM_Reject,
    // Label 121: @2165
    GIM_Try, /*On fail goto*//*Label 148*/ 4586,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_Try, /*On fail goto*//*Label 149*/ 2244, // Rule ID 10117 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_EXTRACT_VECTOR_ELT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, 0,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_EXTRACT_VECTOR_ELT,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        // MIs[2] Rn
        GIM_CheckIsSameOperand, /*MI*/2, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_CheckConstantInt, /*MI*/2, /*Op*/2, 1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[i64] } (vector_extract:{ *:[i64] } FPR128:{ *:[v2i64] }:$Rn, 0:{ *:[i64] }), (vector_extract:{ *:[i64] } FPR128:{ *:[v2i64] }:$Rn, 1:{ *:[i64] }))  =>  (ADDPv2i64p:{ *:[i64] } FPR128:{ *:[v2i64] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::ADDPv2i64p,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 10117,
        GIR_Done,
      // Label 149: @2244
      GIM_Try, /*On fail goto*//*Label 150*/ 2313, // Rule ID 11793 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_EXTRACT_VECTOR_ELT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, 1,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_EXTRACT_VECTOR_ELT,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        // MIs[2] Rn
        GIM_CheckIsSameOperand, /*MI*/2, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_CheckConstantInt, /*MI*/2, /*Op*/2, 0,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[i64] } (vector_extract:{ *:[i64] } FPR128:{ *:[v2i64] }:$Rn, 1:{ *:[i64] }), (vector_extract:{ *:[i64] } FPR128:{ *:[v2i64] }:$Rn, 0:{ *:[i64] }))  =>  (ADDPv2i64p:{ *:[i64] } FPR128:{ *:[v2i64] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::ADDPv2i64p,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11793,
        GIR_Done,
      // Label 150: @2313
      GIM_Try, /*On fail goto*//*Label 151*/ 2347, // Rule ID 10621 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_addsub_shifted_imm64,
        // (add:{ *:[i64] } addsub_shifted_imm64:{ *:[i64] }:$imm, GPR64sp:{ *:[i64] }:$Rn)  =>  (ADDXri:{ *:[i64] } GPR64sp:{ *:[i64] }:$Rn, addsub_shifted_imm64:{ *:[i64] }:$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::ADDXri,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/0, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 10621,
        GIR_Done,
      // Label 151: @2347
      GIM_Try, /*On fail goto*//*Label 152*/ 2443, // Rule ID 7933 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_MUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_SEXT,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIPFP_I64_Predicate_s64imm_32bit,
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (add:{ *:[i64] } (mul:{ *:[i64] } (sext:{ *:[i64] } GPR32:{ *:[i32] }:$Rn), (imm:{ *:[i64] })<<P:Predicate_s64imm_32bit>>:$C), GPR64:{ *:[i64] }:$Ra)  =>  (SMADDLrrr:{ *:[i64] } GPR32:{ *:[i32] }:$Rn, (MOVi32imm:{ *:[i32] } (trunc_imm:{ *:[i32] } (imm:{ *:[i64] }):$C)), GPR64:{ *:[i64] }:$Ra)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AArch64::MOVi32imm,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_CustomRenderer, /*InsnID*/1, /*OldInsnID*/3, /*Renderer*/GICR_renderTruncImm, // C
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SMADDLrrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rn
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Ra
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 7933,
        GIR_Done,
      // Label 152: @2443
      GIM_Try, /*On fail goto*//*Label 153*/ 2539, // Rule ID 7934 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_MUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIPFP_I64_Predicate_i64imm_32bit,
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (add:{ *:[i64] } (mul:{ *:[i64] } (zext:{ *:[i64] } GPR32:{ *:[i32] }:$Rn), (imm:{ *:[i64] })<<P:Predicate_i64imm_32bit>>:$C), GPR64:{ *:[i64] }:$Ra)  =>  (UMADDLrrr:{ *:[i64] } GPR32:{ *:[i32] }:$Rn, (MOVi32imm:{ *:[i32] } (trunc_imm:{ *:[i32] } (imm:{ *:[i64] }):$C)), GPR64:{ *:[i64] }:$Ra)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AArch64::MOVi32imm,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_CustomRenderer, /*InsnID*/1, /*OldInsnID*/3, /*Renderer*/GICR_renderTruncImm, // C
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UMADDLrrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rn
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Ra
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 7934,
        GIR_Done,
      // Label 153: @2539
      GIM_Try, /*On fail goto*//*Label 154*/ 2573, // Rule ID 94 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/0, GICP_gi_addsub_shifted_imm64,
        // (add:{ *:[i64] } GPR64sp:{ *:[i64] }:$Rn, addsub_shifted_imm64:{ *:[i64] }:$imm)  =>  (ADDXri:{ *:[i64] } GPR64sp:{ *:[i64] }:$Rn, addsub_shifted_imm64:{ *:[i64] }:$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::ADDXri,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/0, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 94,
        GIR_Done,
      // Label 154: @2573
      GIM_Try, /*On fail goto*//*Label 155*/ 2669, // Rule ID 11664 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_MUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_SEXT,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIPFP_I64_Predicate_s64imm_32bit,
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (add:{ *:[i64] } GPR64:{ *:[i64] }:$Ra, (mul:{ *:[i64] } (sext:{ *:[i64] } GPR32:{ *:[i32] }:$Rn), (imm:{ *:[i64] })<<P:Predicate_s64imm_32bit>>:$C))  =>  (SMADDLrrr:{ *:[i64] } GPR32:{ *:[i32] }:$Rn, (MOVi32imm:{ *:[i32] } (trunc_imm:{ *:[i32] } (imm:{ *:[i64] }):$C)), GPR64:{ *:[i64] }:$Ra)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AArch64::MOVi32imm,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_CustomRenderer, /*InsnID*/1, /*OldInsnID*/3, /*Renderer*/GICR_renderTruncImm, // C
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SMADDLrrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rn
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Ra
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11664,
        GIR_Done,
      // Label 155: @2669
      GIM_Try, /*On fail goto*//*Label 156*/ 2765, // Rule ID 11665 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_MUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIPFP_I64_Predicate_i64imm_32bit,
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (add:{ *:[i64] } GPR64:{ *:[i64] }:$Ra, (mul:{ *:[i64] } (zext:{ *:[i64] } GPR32:{ *:[i32] }:$Rn), (imm:{ *:[i64] })<<P:Predicate_i64imm_32bit>>:$C))  =>  (UMADDLrrr:{ *:[i64] } GPR32:{ *:[i32] }:$Rn, (MOVi32imm:{ *:[i32] } (trunc_imm:{ *:[i32] } (imm:{ *:[i64] }):$C)), GPR64:{ *:[i64] }:$Ra)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AArch64::MOVi32imm,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_CustomRenderer, /*InsnID*/1, /*OldInsnID*/3, /*Renderer*/GICR_renderTruncImm, // C
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UMADDLrrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rn
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Ra
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11665,
        GIR_Done,
      // Label 156: @2765
      GIM_Try, /*On fail goto*//*Label 157*/ 2850, // Rule ID 10632 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_MUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_SEXT,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_SEXT,
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (add:{ *:[i64] } (mul:{ *:[i64] } (sext:{ *:[i64] } GPR32:{ *:[i32] }:$Rn), (sext:{ *:[i64] } GPR32:{ *:[i32] }:$Rm)), GPR64:{ *:[i64] }:$Ra)  =>  (SMADDLrrr:{ *:[i64] } GPR32:{ *:[i32] }:$Rn, GPR32:{ *:[i32] }:$Rm, GPR64:{ *:[i64] }:$Ra)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SMADDLrrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Ra
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 10632,
        GIR_Done,
      // Label 157: @2850
      GIM_Try, /*On fail goto*//*Label 158*/ 2935, // Rule ID 10633 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_MUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (add:{ *:[i64] } (mul:{ *:[i64] } (zext:{ *:[i64] } GPR32:{ *:[i32] }:$Rn), (zext:{ *:[i64] } GPR32:{ *:[i32] }:$Rm)), GPR64:{ *:[i64] }:$Ra)  =>  (UMADDLrrr:{ *:[i64] } GPR32:{ *:[i32] }:$Rn, GPR32:{ *:[i32] }:$Rm, GPR64:{ *:[i64] }:$Ra)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UMADDLrrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Ra
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 10633,
        GIR_Done,
      // Label 158: @2935
      GIM_Try, /*On fail goto*//*Label 159*/ 3020, // Rule ID 125 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_MUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_SEXT,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_SEXT,
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (add:{ *:[i64] } GPR64:{ *:[i64] }:$Ra, (mul:{ *:[i64] } (sext:{ *:[i64] } GPR32:{ *:[i32] }:$Rn), (sext:{ *:[i64] } GPR32:{ *:[i32] }:$Rm)))  =>  (SMADDLrrr:{ *:[i64] } GPR32:{ *:[i32] }:$Rn, GPR32:{ *:[i32] }:$Rm, GPR64:{ *:[i64] }:$Ra)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SMADDLrrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Ra
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 125,
        GIR_Done,
      // Label 159: @3020
      GIM_Try, /*On fail goto*//*Label 160*/ 3105, // Rule ID 127 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_MUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (add:{ *:[i64] } GPR64:{ *:[i64] }:$Ra, (mul:{ *:[i64] } (zext:{ *:[i64] } GPR32:{ *:[i32] }:$Rn), (zext:{ *:[i64] } GPR32:{ *:[i32] }:$Rm)))  =>  (UMADDLrrr:{ *:[i64] } GPR32:{ *:[i32] }:$Rn, GPR32:{ *:[i32] }:$Rm, GPR64:{ *:[i64] }:$Ra)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UMADDLrrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Ra
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 127,
        GIR_Done,
      // Label 160: @3105
      GIM_Try, /*On fail goto*//*Label 161*/ 3164, // Rule ID 11396 //
        GIM_CheckFeatures, GIFBS_HasSVEorSME_UseScalarIncVL,
        GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/0, /*OtherMI*/0, /*OtherOpIdx*/2,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_sve_cnth,
        // MIs[1] pattern
        GIM_CheckIsImm, /*MI*/1, /*Op*/2,
        GIM_CheckImmOperandPredicate, /*MI*/1, /*MO*/2, /*Predicate*/GIPFP_I64_Predicate_sve_pred_enum,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i64] } (intrinsic_wo_chain:{ *:[i64] } 889:{ *:[iPTR] }, (timm:{ *:[i32] })<<P:Predicate_sve_pred_enum>>:$pattern), GPR64:{ *:[i64] }:$Rdn)  =>  (INCH_XPiI:{ *:[i64] } GPR64:{ *:[i64] }:$Rdn, (timm:{ *:[i32] })<<P:Predicate_sve_pred_enum>>:$pattern, 1:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::INCH_XPiI,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rdn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rdn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // pattern
        GIR_AddImm, /*InsnID*/0, /*Imm*/1,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11396,
        GIR_Done,
      // Label 161: @3164
      GIM_Try, /*On fail goto*//*Label 162*/ 3223, // Rule ID 11408 //
        GIM_CheckFeatures, GIFBS_HasSVEorSME_UseScalarIncVL,
        GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/0, /*OtherMI*/0, /*OtherOpIdx*/2,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_sve_cntw,
        // MIs[1] pattern
        GIM_CheckIsImm, /*MI*/1, /*Op*/2,
        GIM_CheckImmOperandPredicate, /*MI*/1, /*MO*/2, /*Predicate*/GIPFP_I64_Predicate_sve_pred_enum,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i64] } (intrinsic_wo_chain:{ *:[i64] } 891:{ *:[iPTR] }, (timm:{ *:[i32] })<<P:Predicate_sve_pred_enum>>:$pattern), GPR64:{ *:[i64] }:$Rdn)  =>  (INCW_XPiI:{ *:[i64] } GPR64:{ *:[i64] }:$Rdn, (timm:{ *:[i32] })<<P:Predicate_sve_pred_enum>>:$pattern, 1:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::INCW_XPiI,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rdn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rdn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // pattern
        GIR_AddImm, /*InsnID*/0, /*Imm*/1,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11408,
        GIR_Done,
      // Label 162: @3223
      GIM_Try, /*On fail goto*//*Label 163*/ 3282, // Rule ID 11420 //
        GIM_CheckFeatures, GIFBS_HasSVEorSME_UseScalarIncVL,
        GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/0, /*OtherMI*/0, /*OtherOpIdx*/2,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_sve_cntd,
        // MIs[1] pattern
        GIM_CheckIsImm, /*MI*/1, /*Op*/2,
        GIM_CheckImmOperandPredicate, /*MI*/1, /*MO*/2, /*Predicate*/GIPFP_I64_Predicate_sve_pred_enum,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i64] } (intrinsic_wo_chain:{ *:[i64] } 888:{ *:[iPTR] }, (timm:{ *:[i32] })<<P:Predicate_sve_pred_enum>>:$pattern), GPR64:{ *:[i64] }:$Rdn)  =>  (INCD_XPiI:{ *:[i64] } GPR64:{ *:[i64] }:$Rdn, (timm:{ *:[i32] })<<P:Predicate_sve_pred_enum>>:$pattern, 1:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::INCD_XPiI,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rdn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rdn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // pattern
        GIR_AddImm, /*InsnID*/0, /*Imm*/1,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11420,
        GIR_Done,
      // Label 163: @3282
      GIM_Try, /*On fail goto*//*Label 164*/ 3341, // Rule ID 11530 //
        GIM_CheckFeatures, GIFBS_HasSVEorSME_UseScalarIncVL,
        GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/0, /*OtherMI*/0, /*OtherOpIdx*/2,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_sve_cntb,
        // MIs[1] pattern
        GIM_CheckIsImm, /*MI*/1, /*Op*/2,
        GIM_CheckImmOperandPredicate, /*MI*/1, /*MO*/2, /*Predicate*/GIPFP_I64_Predicate_sve_pred_enum,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i64] } (intrinsic_wo_chain:{ *:[i64] } 887:{ *:[iPTR] }, (timm:{ *:[i32] })<<P:Predicate_sve_pred_enum>>:$pattern), GPR64:{ *:[i64] }:$Rdn)  =>  (INCB_XPiI:{ *:[i64] } GPR64:{ *:[i64] }:$Rdn, (timm:{ *:[i32] })<<P:Predicate_sve_pred_enum>>:$pattern, 1:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::INCB_XPiI,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rdn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rdn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // pattern
        GIR_AddImm, /*InsnID*/0, /*Imm*/1,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11530,
        GIR_Done,
      // Label 164: @3341
      GIM_Try, /*On fail goto*//*Label 165*/ 3400, // Rule ID 4537 //
        GIM_CheckFeatures, GIFBS_HasSVEorSME_UseScalarIncVL,
        GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/0, /*OtherMI*/0, /*OtherOpIdx*/1,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_sve_cnth,
        // MIs[1] pattern
        GIM_CheckIsImm, /*MI*/1, /*Op*/2,
        GIM_CheckImmOperandPredicate, /*MI*/1, /*MO*/2, /*Predicate*/GIPFP_I64_Predicate_sve_pred_enum,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i64] } GPR64:{ *:[i64] }:$Rdn, (intrinsic_wo_chain:{ *:[i64] } 889:{ *:[iPTR] }, (timm:{ *:[i32] })<<P:Predicate_sve_pred_enum>>:$pattern))  =>  (INCH_XPiI:{ *:[i64] } GPR64:{ *:[i64] }:$Rdn, (timm:{ *:[i32] })<<P:Predicate_sve_pred_enum>>:$pattern, 1:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::INCH_XPiI,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rdn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rdn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // pattern
        GIR_AddImm, /*InsnID*/0, /*Imm*/1,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4537,
        GIR_Done,
      // Label 165: @3400
      GIM_Try, /*On fail goto*//*Label 166*/ 3459, // Rule ID 4549 //
        GIM_CheckFeatures, GIFBS_HasSVEorSME_UseScalarIncVL,
        GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/0, /*OtherMI*/0, /*OtherOpIdx*/1,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_sve_cntw,
        // MIs[1] pattern
        GIM_CheckIsImm, /*MI*/1, /*Op*/2,
        GIM_CheckImmOperandPredicate, /*MI*/1, /*MO*/2, /*Predicate*/GIPFP_I64_Predicate_sve_pred_enum,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i64] } GPR64:{ *:[i64] }:$Rdn, (intrinsic_wo_chain:{ *:[i64] } 891:{ *:[iPTR] }, (timm:{ *:[i32] })<<P:Predicate_sve_pred_enum>>:$pattern))  =>  (INCW_XPiI:{ *:[i64] } GPR64:{ *:[i64] }:$Rdn, (timm:{ *:[i32] })<<P:Predicate_sve_pred_enum>>:$pattern, 1:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::INCW_XPiI,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rdn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rdn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // pattern
        GIR_AddImm, /*InsnID*/0, /*Imm*/1,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4549,
        GIR_Done,
      // Label 166: @3459
      GIM_Try, /*On fail goto*//*Label 167*/ 3518, // Rule ID 4561 //
        GIM_CheckFeatures, GIFBS_HasSVEorSME_UseScalarIncVL,
        GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/0, /*OtherMI*/0, /*OtherOpIdx*/1,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_sve_cntd,
        // MIs[1] pattern
        GIM_CheckIsImm, /*MI*/1, /*Op*/2,
        GIM_CheckImmOperandPredicate, /*MI*/1, /*MO*/2, /*Predicate*/GIPFP_I64_Predicate_sve_pred_enum,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i64] } GPR64:{ *:[i64] }:$Rdn, (intrinsic_wo_chain:{ *:[i64] } 888:{ *:[iPTR] }, (timm:{ *:[i32] })<<P:Predicate_sve_pred_enum>>:$pattern))  =>  (INCD_XPiI:{ *:[i64] } GPR64:{ *:[i64] }:$Rdn, (timm:{ *:[i32] })<<P:Predicate_sve_pred_enum>>:$pattern, 1:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::INCD_XPiI,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rdn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rdn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // pattern
        GIR_AddImm, /*InsnID*/0, /*Imm*/1,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4561,
        GIR_Done,
      // Label 167: @3518
      GIM_Try, /*On fail goto*//*Label 168*/ 3577, // Rule ID 6932 //
        GIM_CheckFeatures, GIFBS_HasSVEorSME_UseScalarIncVL,
        GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/0, /*OtherMI*/0, /*OtherOpIdx*/1,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_sve_cntb,
        // MIs[1] pattern
        GIM_CheckIsImm, /*MI*/1, /*Op*/2,
        GIM_CheckImmOperandPredicate, /*MI*/1, /*MO*/2, /*Predicate*/GIPFP_I64_Predicate_sve_pred_enum,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i64] } GPR64:{ *:[i64] }:$Rdn, (intrinsic_wo_chain:{ *:[i64] } 887:{ *:[iPTR] }, (timm:{ *:[i32] })<<P:Predicate_sve_pred_enum>>:$pattern))  =>  (INCB_XPiI:{ *:[i64] } GPR64:{ *:[i64] }:$Rdn, (timm:{ *:[i32] })<<P:Predicate_sve_pred_enum>>:$pattern, 1:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::INCB_XPiI,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rdn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rdn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // pattern
        GIR_AddImm, /*InsnID*/0, /*Imm*/1,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 6932,
        GIR_Done,
      // Label 168: @3577
      GIM_Try, /*On fail goto*//*Label 169*/ 3611, // Rule ID 10625 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_arith_extended_reg32to64_i64,
        // (add:{ *:[i64] } arith_extended_reg32to64_i64:{ *:[i64] }:$Rm_and_extend, GPR64sp:{ *:[i64] }:$Rn)  =>  (ADDXrx:{ *:[i64] } GPR64sp:{ *:[i64] }:$Rn, arith_extended_reg32to64_i64:{ *:[i64] }:$Rm_and_extend)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::ADDXrx,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/0, // Rm_and_extend
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 10625,
        GIR_Done,
      // Label 169: @3611
      GIM_Try, /*On fail goto*//*Label 170*/ 3645, // Rule ID 11657 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_neg_addsub_shifted_imm64,
        // (add:{ *:[i64] } neg_addsub_shifted_imm64:{ *:[i64] }:$imm, GPR64:{ *:[i64] }:$Rn)  =>  (SUBSXri:{ *:[i64] }:{ *:[i32] } GPR64:{ *:[i64] }:$Rn, neg_addsub_shifted_imm64:{ *:[i64] }:$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SUBSXri,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/0, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11657,
        GIR_Done,
      // Label 170: @3645
      GIM_Try, /*On fail goto*//*Label 171*/ 3679, // Rule ID 100 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/0, GICP_gi_arith_extended_reg32to64_i64,
        // (add:{ *:[i64] } GPR64sp:{ *:[i64] }:$Rn, arith_extended_reg32to64_i64:{ *:[i64] }:$Rm_and_extend)  =>  (ADDXrx:{ *:[i64] } GPR64sp:{ *:[i64] }:$Rn, arith_extended_reg32to64_i64:{ *:[i64] }:$Rm_and_extend)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::ADDXrx,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/0, // Rm_and_extend
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 100,
        GIR_Done,
      // Label 171: @3679
      GIM_Try, /*On fail goto*//*Label 172*/ 3713, // Rule ID 7884 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/0, GICP_gi_neg_addsub_shifted_imm64,
        // (add:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, neg_addsub_shifted_imm64:{ *:[i64] }:$imm)  =>  (SUBSXri:{ *:[i64] }:{ *:[i32] } GPR64:{ *:[i64] }:$Rn, neg_addsub_shifted_imm64:{ *:[i64] }:$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SUBSXri,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/0, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 7884,
        GIR_Done,
      // Label 172: @3713
      GIM_Try, /*On fail goto*//*Label 173*/ 3747, // Rule ID 10623 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_arith_shifted_reg64,
        // (add:{ *:[i64] } arith_shifted_reg64:{ *:[i64] }:$Rm_and_shift, GPR64:{ *:[i64] }:$Rn)  =>  (ADDXrs:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, arith_shifted_reg64:{ *:[i64] }:$Rm_and_shift)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::ADDXrs,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/0, // Rm_and_shift
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 10623,
        GIR_Done,
      // Label 173: @3747
      GIM_Try, /*On fail goto*//*Label 174*/ 3781, // Rule ID 98 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/0, GICP_gi_arith_shifted_reg64,
        // (add:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, arith_shifted_reg64:{ *:[i64] }:$Rm_and_shift)  =>  (ADDXrs:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, arith_shifted_reg64:{ *:[i64] }:$Rm_and_shift)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::ADDXrs,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/0, // Rm_and_shift
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 98,
        GIR_Done,
      // Label 174: @3781
      GIM_Try, /*On fail goto*//*Label 175*/ 3837, // Rule ID 10707 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_saddlp,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v1i64] } (intrinsic_wo_chain:{ *:[v1i64] } 550:{ *:[iPTR] }, V64:{ *:[v2i32] }:$Rn), V64:{ *:[v1i64] }:$Rd)  =>  (SADALPv2i32_v1i64:{ *:[v1i64] } V64:{ *:[v1i64] }:$Rd, V64:{ *:[v2i32] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SADALPv2i32_v1i64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 10707,
        GIR_Done,
      // Label 175: @3837
      GIM_Try, /*On fail goto*//*Label 176*/ 3893, // Rule ID 10719 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_uaddlp,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v1i64] } (intrinsic_wo_chain:{ *:[v1i64] } 615:{ *:[iPTR] }, V64:{ *:[v2i32] }:$Rn), V64:{ *:[v1i64] }:$Rd)  =>  (UADALPv2i32_v1i64:{ *:[v1i64] } V64:{ *:[v1i64] }:$Rd, V64:{ *:[v2i32] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UADALPv2i32_v1i64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 10719,
        GIR_Done,
      // Label 176: @3893
      GIM_Try, /*On fail goto*//*Label 177*/ 3960, // Rule ID 10897 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, AArch64::G_VASHR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        // MIs[1] imm
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIPFP_I64_Predicate_vecshiftR64,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_add_and_or_is_add,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[i64] } (AArch64vashr:{ *:[i64] } FPR64:{ *:[i64] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR64>>:$imm), FPR64:{ *:[i64] }:$Rd)<<P:Predicate_add_and_or_is_add>>  =>  (SSRAd:{ *:[i64] } FPR64:{ *:[i64] }:$Rd, FPR64:{ *:[i64] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SSRAd,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 10897,
        GIR_Done,
      // Label 177: @3960
      GIM_Try, /*On fail goto*//*Label 178*/ 4027, // Rule ID 11782 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, AArch64::G_VASHR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        // MIs[1] imm
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIPFP_I64_Predicate_vecshiftR64,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_add_and_or_is_add,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v1i64] } (AArch64vashr:{ *:[v1i64] } FPR64:{ *:[v1i64] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR64>>:$imm), FPR64:{ *:[v1i64] }:$Rd)<<P:Predicate_add_and_or_is_add>>  =>  (SSRAd:{ *:[v1i64] } FPR64:{ *:[v1i64] }:$Rd, FPR64:{ *:[v1i64] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR64>>:$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SSRAd,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11782,
        GIR_Done,
      // Label 178: @4027
      GIM_Try, /*On fail goto*//*Label 179*/ 4094, // Rule ID 10900 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, AArch64::G_VLSHR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        // MIs[1] imm
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIPFP_I64_Predicate_vecshiftR64,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_add_and_or_is_add,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[i64] } (AArch64vlshr:{ *:[i64] } FPR64:{ *:[i64] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR64>>:$imm), FPR64:{ *:[i64] }:$Rd)<<P:Predicate_add_and_or_is_add>>  =>  (USRAd:{ *:[i64] } FPR64:{ *:[i64] }:$Rd, FPR64:{ *:[i64] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::USRAd,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 10900,
        GIR_Done,
      // Label 179: @4094
      GIM_Try, /*On fail goto*//*Label 180*/ 4161, // Rule ID 11785 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, AArch64::G_VLSHR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        // MIs[1] imm
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIPFP_I64_Predicate_vecshiftR64,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_add_and_or_is_add,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v1i64] } (AArch64vlshr:{ *:[v1i64] } FPR64:{ *:[v1i64] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR64>>:$imm), FPR64:{ *:[v1i64] }:$Rd)<<P:Predicate_add_and_or_is_add>>  =>  (USRAd:{ *:[v1i64] } FPR64:{ *:[v1i64] }:$Rd, FPR64:{ *:[v1i64] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR64>>:$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::USRAd,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11785,
        GIR_Done,
      // Label 180: @4161
      GIM_Try, /*On fail goto*//*Label 181*/ 4217, // Rule ID 970 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_saddlp,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v1i64] } V64:{ *:[v1i64] }:$Rd, (intrinsic_wo_chain:{ *:[v1i64] } 550:{ *:[iPTR] }, V64:{ *:[v2i32] }:$Rn))  =>  (SADALPv2i32_v1i64:{ *:[v1i64] } V64:{ *:[v1i64] }:$Rd, V64:{ *:[v2i32] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SADALPv2i32_v1i64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 970,
        GIR_Done,
      // Label 181: @4217
      GIM_Try, /*On fail goto*//*Label 182*/ 4273, // Rule ID 1031 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_uaddlp,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v1i64] } V64:{ *:[v1i64] }:$Rd, (intrinsic_wo_chain:{ *:[v1i64] } 615:{ *:[iPTR] }, V64:{ *:[v2i32] }:$Rn))  =>  (UADALPv2i32_v1i64:{ *:[v1i64] } V64:{ *:[v1i64] }:$Rd, V64:{ *:[v2i32] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UADALPv2i32_v1i64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1031,
        GIR_Done,
      // Label 182: @4273
      GIM_Try, /*On fail goto*//*Label 183*/ 4340, // Rule ID 2037 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, AArch64::G_VASHR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        // MIs[1] imm
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIPFP_I64_Predicate_vecshiftR64,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_add_and_or_is_add,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[i64] } FPR64:{ *:[i64] }:$Rd, (AArch64vashr:{ *:[i64] } FPR64:{ *:[i64] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR64>>:$imm))<<P:Predicate_add_and_or_is_add>>  =>  (SSRAd:{ *:[i64] } FPR64:{ *:[i64] }:$Rd, FPR64:{ *:[i64] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SSRAd,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2037,
        GIR_Done,
      // Label 183: @4340
      GIM_Try, /*On fail goto*//*Label 184*/ 4407, // Rule ID 9438 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, AArch64::G_VASHR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        // MIs[1] imm
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIPFP_I64_Predicate_vecshiftR64,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_add_and_or_is_add,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v1i64] } FPR64:{ *:[v1i64] }:$Rd, (AArch64vashr:{ *:[v1i64] } FPR64:{ *:[v1i64] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR64>>:$imm))<<P:Predicate_add_and_or_is_add>>  =>  (SSRAd:{ *:[v1i64] } FPR64:{ *:[v1i64] }:$Rd, FPR64:{ *:[v1i64] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR64>>:$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SSRAd,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 9438,
        GIR_Done,
      // Label 184: @4407
      GIM_Try, /*On fail goto*//*Label 185*/ 4474, // Rule ID 2046 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, AArch64::G_VLSHR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        // MIs[1] imm
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIPFP_I64_Predicate_vecshiftR64,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_add_and_or_is_add,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[i64] } FPR64:{ *:[i64] }:$Rd, (AArch64vlshr:{ *:[i64] } FPR64:{ *:[i64] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR64>>:$imm))<<P:Predicate_add_and_or_is_add>>  =>  (USRAd:{ *:[i64] } FPR64:{ *:[i64] }:$Rd, FPR64:{ *:[i64] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::USRAd,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2046,
        GIR_Done,
      // Label 185: @4474
      GIM_Try, /*On fail goto*//*Label 186*/ 4541, // Rule ID 9444 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, AArch64::G_VLSHR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        // MIs[1] imm
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIPFP_I64_Predicate_vecshiftR64,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_add_and_or_is_add,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v1i64] } FPR64:{ *:[v1i64] }:$Rd, (AArch64vlshr:{ *:[v1i64] } FPR64:{ *:[v1i64] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR64>>:$imm))<<P:Predicate_add_and_or_is_add>>  =>  (USRAd:{ *:[v1i64] } FPR64:{ *:[v1i64] }:$Rd, FPR64:{ *:[v1i64] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR64>>:$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::USRAd,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 9444,
        GIR_Done,
      // Label 186: @4541
      GIM_Try, /*On fail goto*//*Label 187*/ 4562, // Rule ID 96 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR64RegClassID,
        // (add:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm)  =>  (ADDXrr:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::ADDXrr,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 96,
        GIR_Done,
      // Label 187: @4562
      GIM_Try, /*On fail goto*//*Label 188*/ 4585, // Rule ID 1572 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        // (add:{ *:[v1i64] } FPR64:{ *:[v1i64] }:$Rn, FPR64:{ *:[v1i64] }:$Rm)  =>  (ADDv1i64:{ *:[v1i64] } FPR64:{ *:[v1i64] }:$Rn, FPR64:{ *:[v1i64] }:$Rm)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::ADDv1i64,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1572,
        GIR_Done,
      // Label 188: @4585
      GIM_Reject,
    // Label 148: @4586
    GIM_Reject,
    // Label 122: @4587
    GIM_Try, /*On fail goto*//*Label 189*/ 5385,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s32,
      GIM_Try, /*On fail goto*//*Label 190*/ 4665, // Rule ID 10741 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_sabd,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v2i32] } (intrinsic_wo_chain:{ *:[v2i32] } 549:{ *:[iPTR] }, V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm), V64:{ *:[v2i32] }:$Rd)  =>  (SABAv2i32:{ *:[v2i32] } V64:{ *:[v2i32] }:$Rd, V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SABAv2i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 10741,
        GIR_Done,
      // Label 190: @4665
      GIM_Try, /*On fail goto*//*Label 191*/ 4733, // Rule ID 10753 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_uabd,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v2i32] } (intrinsic_wo_chain:{ *:[v2i32] } 614:{ *:[iPTR] }, V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm), V64:{ *:[v2i32] }:$Rd)  =>  (UABAv2i32:{ *:[v2i32] } V64:{ *:[v2i32] }:$Rd, V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UABAv2i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 10753,
        GIR_Done,
      // Label 191: @4733
      GIM_Try, /*On fail goto*//*Label 192*/ 4789, // Rule ID 10703 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_saddlp,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v2i32] } (intrinsic_wo_chain:{ *:[v2i32] } 550:{ *:[iPTR] }, V64:{ *:[v4i16] }:$Rn), V64:{ *:[v2i32] }:$Rd)  =>  (SADALPv4i16_v2i32:{ *:[v2i32] } V64:{ *:[v2i32] }:$Rd, V64:{ *:[v4i16] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SADALPv4i16_v2i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 10703,
        GIR_Done,
      // Label 192: @4789
      GIM_Try, /*On fail goto*//*Label 193*/ 4845, // Rule ID 10715 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_uaddlp,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v2i32] } (intrinsic_wo_chain:{ *:[v2i32] } 615:{ *:[iPTR] }, V64:{ *:[v4i16] }:$Rn), V64:{ *:[v2i32] }:$Rd)  =>  (UADALPv4i16_v2i32:{ *:[v2i32] } V64:{ *:[v2i32] }:$Rd, V64:{ *:[v4i16] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UADALPv4i16_v2i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 10715,
        GIR_Done,
      // Label 193: @4845
      GIM_Try, /*On fail goto*//*Label 194*/ 4912, // Rule ID 10917 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, AArch64::G_VASHR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        // MIs[1] imm
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIPFP_I64_Predicate_vecshiftR32,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_add_and_or_is_add,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v2i32] } (AArch64vashr:{ *:[v2i32] } V64:{ *:[v2i32] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR32>>:$imm), V64:{ *:[v2i32] }:$Rd)<<P:Predicate_add_and_or_is_add>>  =>  (SSRAv2i32_shift:{ *:[v2i32] } V64:{ *:[v2i32] }:$Rd, V64:{ *:[v2i32] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SSRAv2i32_shift,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 10917,
        GIR_Done,
      // Label 194: @4912
      GIM_Try, /*On fail goto*//*Label 195*/ 4979, // Rule ID 10938 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, AArch64::G_VLSHR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        // MIs[1] imm
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIPFP_I64_Predicate_vecshiftR32,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_add_and_or_is_add,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v2i32] } (AArch64vlshr:{ *:[v2i32] } V64:{ *:[v2i32] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR32>>:$imm), V64:{ *:[v2i32] }:$Rd)<<P:Predicate_add_and_or_is_add>>  =>  (USRAv2i32_shift:{ *:[v2i32] } V64:{ *:[v2i32] }:$Rd, V64:{ *:[v2i32] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::USRAv2i32_shift,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 10938,
        GIR_Done,
      // Label 195: @4979
      GIM_Try, /*On fail goto*//*Label 196*/ 5047, // Rule ID 1328 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_sabd,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v2i32] } V64:{ *:[v2i32] }:$Rd, (intrinsic_wo_chain:{ *:[v2i32] } 549:{ *:[iPTR] }, V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm))  =>  (SABAv2i32:{ *:[v2i32] } V64:{ *:[v2i32] }:$Rd, V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SABAv2i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1328,
        GIR_Done,
      // Label 196: @5047
      GIM_Try, /*On fail goto*//*Label 197*/ 5115, // Rule ID 1451 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_uabd,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v2i32] } V64:{ *:[v2i32] }:$Rd, (intrinsic_wo_chain:{ *:[v2i32] } 614:{ *:[iPTR] }, V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm))  =>  (UABAv2i32:{ *:[v2i32] } V64:{ *:[v2i32] }:$Rd, V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UABAv2i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1451,
        GIR_Done,
      // Label 197: @5115
      GIM_Try, /*On fail goto*//*Label 198*/ 5171, // Rule ID 966 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_saddlp,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v2i32] } V64:{ *:[v2i32] }:$Rd, (intrinsic_wo_chain:{ *:[v2i32] } 550:{ *:[iPTR] }, V64:{ *:[v4i16] }:$Rn))  =>  (SADALPv4i16_v2i32:{ *:[v2i32] } V64:{ *:[v2i32] }:$Rd, V64:{ *:[v4i16] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SADALPv4i16_v2i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 966,
        GIR_Done,
      // Label 198: @5171
      GIM_Try, /*On fail goto*//*Label 199*/ 5227, // Rule ID 1027 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_uaddlp,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v2i32] } V64:{ *:[v2i32] }:$Rd, (intrinsic_wo_chain:{ *:[v2i32] } 615:{ *:[iPTR] }, V64:{ *:[v4i16] }:$Rn))  =>  (UADALPv4i16_v2i32:{ *:[v2i32] } V64:{ *:[v2i32] }:$Rd, V64:{ *:[v4i16] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UADALPv4i16_v2i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1027,
        GIR_Done,
      // Label 199: @5227
      GIM_Try, /*On fail goto*//*Label 200*/ 5294, // Rule ID 2151 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, AArch64::G_VASHR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        // MIs[1] imm
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIPFP_I64_Predicate_vecshiftR32,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_add_and_or_is_add,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v2i32] } V64:{ *:[v2i32] }:$Rd, (AArch64vashr:{ *:[v2i32] } V64:{ *:[v2i32] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR32>>:$imm))<<P:Predicate_add_and_or_is_add>>  =>  (SSRAv2i32_shift:{ *:[v2i32] } V64:{ *:[v2i32] }:$Rd, V64:{ *:[v2i32] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SSRAv2i32_shift,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2151,
        GIR_Done,
      // Label 200: @5294
      GIM_Try, /*On fail goto*//*Label 201*/ 5361, // Rule ID 2210 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, AArch64::G_VLSHR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        // MIs[1] imm
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIPFP_I64_Predicate_vecshiftR32,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_add_and_or_is_add,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v2i32] } V64:{ *:[v2i32] }:$Rd, (AArch64vlshr:{ *:[v2i32] } V64:{ *:[v2i32] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR32>>:$imm))<<P:Predicate_add_and_or_is_add>>  =>  (USRAv2i32_shift:{ *:[v2i32] } V64:{ *:[v2i32] }:$Rd, V64:{ *:[v2i32] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::USRAv2i32_shift,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2210,
        GIR_Done,
      // Label 201: @5361
      GIM_Try, /*On fail goto*//*Label 202*/ 5384, // Rule ID 1077 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        // (add:{ *:[v2i32] } V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm)  =>  (ADDv2i32:{ *:[v2i32] } V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::ADDv2i32,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1077,
        GIR_Done,
      // Label 202: @5384
      GIM_Reject,
    // Label 189: @5385
    GIM_Reject,
    // Label 123: @5386
    GIM_Try, /*On fail goto*//*Label 203*/ 6840,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
      GIM_Try, /*On fail goto*//*Label 204*/ 5477, // Rule ID 10783 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/2, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, Intrinsic::aarch64_neon_sabd,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/3, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v2i64] } (zext:{ *:[v2i64] } (intrinsic_wo_chain:{ *:[v2i32] } 549:{ *:[iPTR] }, V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm)), V128:{ *:[v2i64] }:$Rd)  =>  (SABALv2i32_v2i64:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SABALv2i32_v2i64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/3, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 10783,
        GIR_Done,
      // Label 204: @5477
      GIM_Try, /*On fail goto*//*Label 205*/ 5558, // Rule ID 10807 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/2, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, Intrinsic::aarch64_neon_uabd,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/3, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v2i64] } (zext:{ *:[v2i64] } (intrinsic_wo_chain:{ *:[v2i32] } 614:{ *:[iPTR] }, V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm)), V128:{ *:[v2i64] }:$Rd)  =>  (UABALv2i32_v2i64:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UABALv2i32_v2i64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/3, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 10807,
        GIR_Done,
      // Label 205: @5558
      GIM_Try, /*On fail goto*//*Label 206*/ 5639, // Rule ID 1661 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/2, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, Intrinsic::aarch64_neon_sabd,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/3, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, (zext:{ *:[v2i64] } (intrinsic_wo_chain:{ *:[v2i32] } 549:{ *:[iPTR] }, V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm)))  =>  (SABALv2i32_v2i64:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SABALv2i32_v2i64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/3, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1661,
        GIR_Done,
      // Label 206: @5639
      GIM_Try, /*On fail goto*//*Label 207*/ 5720, // Rule ID 1739 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/2, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, Intrinsic::aarch64_neon_uabd,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/3, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, (zext:{ *:[v2i64] } (intrinsic_wo_chain:{ *:[v2i32] } 614:{ *:[iPTR] }, V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm)))  =>  (UABALv2i32_v2i64:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UABALv2i32_v2i64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/3, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1739,
        GIR_Done,
      // Label 207: @5720
      GIM_Try, /*On fail goto*//*Label 208*/ 5776, // Rule ID 10709 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_saddlp,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v2i64] } (intrinsic_wo_chain:{ *:[v2i64] } 550:{ *:[iPTR] }, V128:{ *:[v4i32] }:$Rn), V128:{ *:[v2i64] }:$Rd)  =>  (SADALPv4i32_v2i64:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, V128:{ *:[v4i32] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SADALPv4i32_v2i64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 10709,
        GIR_Done,
      // Label 208: @5776
      GIM_Try, /*On fail goto*//*Label 209*/ 5832, // Rule ID 10721 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_uaddlp,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v2i64] } (intrinsic_wo_chain:{ *:[v2i64] } 615:{ *:[iPTR] }, V128:{ *:[v4i32] }:$Rn), V128:{ *:[v2i64] }:$Rd)  =>  (UADALPv4i32_v2i64:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, V128:{ *:[v4i32] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UADALPv4i32_v2i64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 10721,
        GIR_Done,
      // Label 209: @5832
      GIM_Try, /*On fail goto*//*Label 210*/ 5899, // Rule ID 10921 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, AArch64::G_VASHR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        // MIs[1] imm
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIPFP_I64_Predicate_vecshiftR64,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_add_and_or_is_add,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v2i64] } (AArch64vashr:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR64>>:$imm), V128:{ *:[v2i64] }:$Rd)<<P:Predicate_add_and_or_is_add>>  =>  (SSRAv2i64_shift:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, V128:{ *:[v2i64] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SSRAv2i64_shift,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 10921,
        GIR_Done,
      // Label 210: @5899
      GIM_Try, /*On fail goto*//*Label 211*/ 5966, // Rule ID 10942 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, AArch64::G_VLSHR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        // MIs[1] imm
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIPFP_I64_Predicate_vecshiftR64,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_add_and_or_is_add,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v2i64] } (AArch64vlshr:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR64>>:$imm), V128:{ *:[v2i64] }:$Rd)<<P:Predicate_add_and_or_is_add>>  =>  (USRAv2i64_shift:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, V128:{ *:[v2i64] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::USRAv2i64_shift,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 10942,
        GIR_Done,
      // Label 211: @5966
      GIM_Try, /*On fail goto*//*Label 212*/ 6022, // Rule ID 972 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_saddlp,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, (intrinsic_wo_chain:{ *:[v2i64] } 550:{ *:[iPTR] }, V128:{ *:[v4i32] }:$Rn))  =>  (SADALPv4i32_v2i64:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, V128:{ *:[v4i32] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SADALPv4i32_v2i64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 972,
        GIR_Done,
      // Label 212: @6022
      GIM_Try, /*On fail goto*//*Label 213*/ 6078, // Rule ID 1033 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_uaddlp,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, (intrinsic_wo_chain:{ *:[v2i64] } 615:{ *:[iPTR] }, V128:{ *:[v4i32] }:$Rn))  =>  (UADALPv4i32_v2i64:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, V128:{ *:[v4i32] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UADALPv4i32_v2i64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1033,
        GIR_Done,
      // Label 213: @6078
      GIM_Try, /*On fail goto*//*Label 214*/ 6145, // Rule ID 2155 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, AArch64::G_VASHR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        // MIs[1] imm
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIPFP_I64_Predicate_vecshiftR64,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_add_and_or_is_add,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, (AArch64vashr:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR64>>:$imm))<<P:Predicate_add_and_or_is_add>>  =>  (SSRAv2i64_shift:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, V128:{ *:[v2i64] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SSRAv2i64_shift,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2155,
        GIR_Done,
      // Label 214: @6145
      GIM_Try, /*On fail goto*//*Label 215*/ 6212, // Rule ID 2214 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, AArch64::G_VLSHR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        // MIs[1] imm
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIPFP_I64_Predicate_vecshiftR64,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_add_and_or_is_add,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, (AArch64vlshr:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR64>>:$imm))<<P:Predicate_add_and_or_is_add>>  =>  (USRAv2i64_shift:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, V128:{ *:[v2i64] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::USRAv2i64_shift,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2214,
        GIR_Done,
      // Label 215: @6212
      GIM_Try, /*On fail goto*//*Label 216*/ 6274, // Rule ID 1761 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ANYEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_ANYEXT,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v2i64] } (anyext:{ *:[v2i64] } V64:{ *:[v2i32] }:$Rn), (anyext:{ *:[v2i64] } V64:{ *:[v2i32] }:$Rm))  =>  (UADDLv2i32_v2i64:{ *:[v2i64] } V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UADDLv2i32_v2i64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1761,
        GIR_Done,
      // Label 216: @6274
      GIM_Try, /*On fail goto*//*Label 217*/ 6336, // Rule ID 1760 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ANYEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v2i64] } (anyext:{ *:[v2i64] } V64:{ *:[v2i32] }:$Rn), (zext:{ *:[v2i64] } V64:{ *:[v2i32] }:$Rm))  =>  (UADDLv2i32_v2i64:{ *:[v2i64] } V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UADDLv2i32_v2i64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1760,
        GIR_Done,
      // Label 217: @6336
      GIM_Try, /*On fail goto*//*Label 218*/ 6398, // Rule ID 1680 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_SEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_SEXT,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v2i64] } (sext:{ *:[v2i64] } V64:{ *:[v2i32] }:$Rn), (sext:{ *:[v2i64] } V64:{ *:[v2i32] }:$Rm))  =>  (SADDLv2i32_v2i64:{ *:[v2i64] } V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SADDLv2i32_v2i64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1680,
        GIR_Done,
      // Label 218: @6398
      GIM_Try, /*On fail goto*//*Label 219*/ 6460, // Rule ID 1759 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_ANYEXT,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v2i64] } (zext:{ *:[v2i64] } V64:{ *:[v2i32] }:$Rn), (anyext:{ *:[v2i64] } V64:{ *:[v2i32] }:$Rm))  =>  (UADDLv2i32_v2i64:{ *:[v2i64] } V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UADDLv2i32_v2i64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1759,
        GIR_Done,
      // Label 219: @6460
      GIM_Try, /*On fail goto*//*Label 220*/ 6522, // Rule ID 1758 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v2i64] } (zext:{ *:[v2i64] } V64:{ *:[v2i32] }:$Rn), (zext:{ *:[v2i64] } V64:{ *:[v2i32] }:$Rm))  =>  (UADDLv2i32_v2i64:{ *:[v2i64] } V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UADDLv2i32_v2i64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1758,
        GIR_Done,
      // Label 220: @6522
      GIM_Try, /*On fail goto*//*Label 221*/ 6571, // Rule ID 10819 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ANYEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v2i64] } (anyext:{ *:[v2i64] } V64:{ *:[v2i32] }:$Rm), V128:{ *:[v2i64] }:$Rn)  =>  (UADDWv2i32_v2i64:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rn, V64:{ *:[v2i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UADDWv2i32_v2i64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 10819,
        GIR_Done,
      // Label 221: @6571
      GIM_Try, /*On fail goto*//*Label 222*/ 6620, // Rule ID 10790 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_SEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v2i64] } (sext:{ *:[v2i64] } V64:{ *:[v2i32] }:$Rm), V128:{ *:[v2i64] }:$Rn)  =>  (SADDWv2i32_v2i64:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rn, V64:{ *:[v2i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SADDWv2i32_v2i64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 10790,
        GIR_Done,
      // Label 222: @6620
      GIM_Try, /*On fail goto*//*Label 223*/ 6669, // Rule ID 10818 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v2i64] } (zext:{ *:[v2i64] } V64:{ *:[v2i32] }:$Rm), V128:{ *:[v2i64] }:$Rn)  =>  (UADDWv2i32_v2i64:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rn, V64:{ *:[v2i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UADDWv2i32_v2i64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 10818,
        GIR_Done,
      // Label 223: @6669
      GIM_Try, /*On fail goto*//*Label 224*/ 6718, // Rule ID 1775 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ANYEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rn, (anyext:{ *:[v2i64] } V64:{ *:[v2i32] }:$Rm))  =>  (UADDWv2i32_v2i64:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rn, V64:{ *:[v2i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UADDWv2i32_v2i64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1775,
        GIR_Done,
      // Label 224: @6718
      GIM_Try, /*On fail goto*//*Label 225*/ 6767, // Rule ID 1686 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_SEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rn, (sext:{ *:[v2i64] } V64:{ *:[v2i32] }:$Rm))  =>  (SADDWv2i32_v2i64:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rn, V64:{ *:[v2i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SADDWv2i32_v2i64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1686,
        GIR_Done,
      // Label 225: @6767
      GIM_Try, /*On fail goto*//*Label 226*/ 6816, // Rule ID 1774 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rn, (zext:{ *:[v2i64] } V64:{ *:[v2i32] }:$Rm))  =>  (UADDWv2i32_v2i64:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rn, V64:{ *:[v2i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UADDWv2i32_v2i64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1774,
        GIR_Done,
      // Label 226: @6816
      GIM_Try, /*On fail goto*//*Label 227*/ 6839, // Rule ID 1079 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        // (add:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rn, V128:{ *:[v2i64] }:$Rm)  =>  (ADDv2i64:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rn, V128:{ *:[v2i64] }:$Rm)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::ADDv2i64,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1079,
        GIR_Done,
      // Label 227: @6839
      GIM_Reject,
    // Label 203: @6840
    GIM_Reject,
    // Label 124: @6841
    GIM_Try, /*On fail goto*//*Label 228*/ 7639,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s16,
      GIM_Try, /*On fail goto*//*Label 229*/ 6919, // Rule ID 10737 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_sabd,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v4i16] } (intrinsic_wo_chain:{ *:[v4i16] } 549:{ *:[iPTR] }, V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm), V64:{ *:[v4i16] }:$Rd)  =>  (SABAv4i16:{ *:[v4i16] } V64:{ *:[v4i16] }:$Rd, V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SABAv4i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 10737,
        GIR_Done,
      // Label 229: @6919
      GIM_Try, /*On fail goto*//*Label 230*/ 6987, // Rule ID 10749 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_uabd,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v4i16] } (intrinsic_wo_chain:{ *:[v4i16] } 614:{ *:[iPTR] }, V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm), V64:{ *:[v4i16] }:$Rd)  =>  (UABAv4i16:{ *:[v4i16] } V64:{ *:[v4i16] }:$Rd, V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UABAv4i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 10749,
        GIR_Done,
      // Label 230: @6987
      GIM_Try, /*On fail goto*//*Label 231*/ 7043, // Rule ID 10699 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_saddlp,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v4i16] } (intrinsic_wo_chain:{ *:[v4i16] } 550:{ *:[iPTR] }, V64:{ *:[v8i8] }:$Rn), V64:{ *:[v4i16] }:$Rd)  =>  (SADALPv8i8_v4i16:{ *:[v4i16] } V64:{ *:[v4i16] }:$Rd, V64:{ *:[v8i8] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SADALPv8i8_v4i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 10699,
        GIR_Done,
      // Label 231: @7043
      GIM_Try, /*On fail goto*//*Label 232*/ 7099, // Rule ID 10711 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_uaddlp,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v4i16] } (intrinsic_wo_chain:{ *:[v4i16] } 615:{ *:[iPTR] }, V64:{ *:[v8i8] }:$Rn), V64:{ *:[v4i16] }:$Rd)  =>  (UADALPv8i8_v4i16:{ *:[v4i16] } V64:{ *:[v4i16] }:$Rd, V64:{ *:[v8i8] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UADALPv8i8_v4i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 10711,
        GIR_Done,
      // Label 232: @7099
      GIM_Try, /*On fail goto*//*Label 233*/ 7166, // Rule ID 10913 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, AArch64::G_VASHR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        // MIs[1] imm
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIPFP_I64_Predicate_vecshiftR16,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_add_and_or_is_add,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v4i16] } (AArch64vashr:{ *:[v4i16] } V64:{ *:[v4i16] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR16>>:$imm), V64:{ *:[v4i16] }:$Rd)<<P:Predicate_add_and_or_is_add>>  =>  (SSRAv4i16_shift:{ *:[v4i16] } V64:{ *:[v4i16] }:$Rd, V64:{ *:[v4i16] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SSRAv4i16_shift,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 10913,
        GIR_Done,
      // Label 233: @7166
      GIM_Try, /*On fail goto*//*Label 234*/ 7233, // Rule ID 10934 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, AArch64::G_VLSHR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        // MIs[1] imm
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIPFP_I64_Predicate_vecshiftR16,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_add_and_or_is_add,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v4i16] } (AArch64vlshr:{ *:[v4i16] } V64:{ *:[v4i16] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR16>>:$imm), V64:{ *:[v4i16] }:$Rd)<<P:Predicate_add_and_or_is_add>>  =>  (USRAv4i16_shift:{ *:[v4i16] } V64:{ *:[v4i16] }:$Rd, V64:{ *:[v4i16] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::USRAv4i16_shift,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 10934,
        GIR_Done,
      // Label 234: @7233
      GIM_Try, /*On fail goto*//*Label 235*/ 7301, // Rule ID 1324 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_sabd,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v4i16] } V64:{ *:[v4i16] }:$Rd, (intrinsic_wo_chain:{ *:[v4i16] } 549:{ *:[iPTR] }, V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm))  =>  (SABAv4i16:{ *:[v4i16] } V64:{ *:[v4i16] }:$Rd, V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SABAv4i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1324,
        GIR_Done,
      // Label 235: @7301
      GIM_Try, /*On fail goto*//*Label 236*/ 7369, // Rule ID 1447 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_uabd,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v4i16] } V64:{ *:[v4i16] }:$Rd, (intrinsic_wo_chain:{ *:[v4i16] } 614:{ *:[iPTR] }, V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm))  =>  (UABAv4i16:{ *:[v4i16] } V64:{ *:[v4i16] }:$Rd, V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UABAv4i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1447,
        GIR_Done,
      // Label 236: @7369
      GIM_Try, /*On fail goto*//*Label 237*/ 7425, // Rule ID 962 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_saddlp,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v4i16] } V64:{ *:[v4i16] }:$Rd, (intrinsic_wo_chain:{ *:[v4i16] } 550:{ *:[iPTR] }, V64:{ *:[v8i8] }:$Rn))  =>  (SADALPv8i8_v4i16:{ *:[v4i16] } V64:{ *:[v4i16] }:$Rd, V64:{ *:[v8i8] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SADALPv8i8_v4i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 962,
        GIR_Done,
      // Label 237: @7425
      GIM_Try, /*On fail goto*//*Label 238*/ 7481, // Rule ID 1023 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_uaddlp,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v4i16] } V64:{ *:[v4i16] }:$Rd, (intrinsic_wo_chain:{ *:[v4i16] } 615:{ *:[iPTR] }, V64:{ *:[v8i8] }:$Rn))  =>  (UADALPv8i8_v4i16:{ *:[v4i16] } V64:{ *:[v4i16] }:$Rd, V64:{ *:[v8i8] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UADALPv8i8_v4i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1023,
        GIR_Done,
      // Label 238: @7481
      GIM_Try, /*On fail goto*//*Label 239*/ 7548, // Rule ID 2147 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, AArch64::G_VASHR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        // MIs[1] imm
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIPFP_I64_Predicate_vecshiftR16,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_add_and_or_is_add,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v4i16] } V64:{ *:[v4i16] }:$Rd, (AArch64vashr:{ *:[v4i16] } V64:{ *:[v4i16] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR16>>:$imm))<<P:Predicate_add_and_or_is_add>>  =>  (SSRAv4i16_shift:{ *:[v4i16] } V64:{ *:[v4i16] }:$Rd, V64:{ *:[v4i16] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SSRAv4i16_shift,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2147,
        GIR_Done,
      // Label 239: @7548
      GIM_Try, /*On fail goto*//*Label 240*/ 7615, // Rule ID 2206 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, AArch64::G_VLSHR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        // MIs[1] imm
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIPFP_I64_Predicate_vecshiftR16,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_add_and_or_is_add,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v4i16] } V64:{ *:[v4i16] }:$Rd, (AArch64vlshr:{ *:[v4i16] } V64:{ *:[v4i16] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR16>>:$imm))<<P:Predicate_add_and_or_is_add>>  =>  (USRAv4i16_shift:{ *:[v4i16] } V64:{ *:[v4i16] }:$Rd, V64:{ *:[v4i16] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::USRAv4i16_shift,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2206,
        GIR_Done,
      // Label 240: @7615
      GIM_Try, /*On fail goto*//*Label 241*/ 7638, // Rule ID 1075 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        // (add:{ *:[v4i16] } V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm)  =>  (ADDv4i16:{ *:[v4i16] } V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::ADDv4i16,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1075,
        GIR_Done,
      // Label 241: @7638
      GIM_Reject,
    // Label 228: @7639
    GIM_Reject,
    // Label 125: @7640
    GIM_Try, /*On fail goto*//*Label 242*/ 9366,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
      GIM_Try, /*On fail goto*//*Label 243*/ 7731, // Rule ID 10779 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/2, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, Intrinsic::aarch64_neon_sabd,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/3, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v4i32] } (zext:{ *:[v4i32] } (intrinsic_wo_chain:{ *:[v4i16] } 549:{ *:[iPTR] }, V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm)), V128:{ *:[v4i32] }:$Rd)  =>  (SABALv4i16_v4i32:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SABALv4i16_v4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/3, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 10779,
        GIR_Done,
      // Label 243: @7731
      GIM_Try, /*On fail goto*//*Label 244*/ 7812, // Rule ID 10803 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/2, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, Intrinsic::aarch64_neon_uabd,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/3, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v4i32] } (zext:{ *:[v4i32] } (intrinsic_wo_chain:{ *:[v4i16] } 614:{ *:[iPTR] }, V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm)), V128:{ *:[v4i32] }:$Rd)  =>  (UABALv4i16_v4i32:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UABALv4i16_v4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/3, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 10803,
        GIR_Done,
      // Label 244: @7812
      GIM_Try, /*On fail goto*//*Label 245*/ 7893, // Rule ID 1657 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/2, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, Intrinsic::aarch64_neon_sabd,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/3, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, (zext:{ *:[v4i32] } (intrinsic_wo_chain:{ *:[v4i16] } 549:{ *:[iPTR] }, V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm)))  =>  (SABALv4i16_v4i32:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SABALv4i16_v4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/3, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1657,
        GIR_Done,
      // Label 245: @7893
      GIM_Try, /*On fail goto*//*Label 246*/ 7974, // Rule ID 1735 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/2, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, Intrinsic::aarch64_neon_uabd,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/3, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, (zext:{ *:[v4i32] } (intrinsic_wo_chain:{ *:[v4i16] } 614:{ *:[iPTR] }, V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm)))  =>  (UABALv4i16_v4i32:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UABALv4i16_v4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/3, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1735,
        GIR_Done,
      // Label 246: @7974
      GIM_Try, /*On fail goto*//*Label 247*/ 8042, // Rule ID 10743 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_sabd,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v4i32] } (intrinsic_wo_chain:{ *:[v4i32] } 549:{ *:[iPTR] }, V128:{ *:[v4i32] }:$Rn, V128:{ *:[v4i32] }:$Rm), V128:{ *:[v4i32] }:$Rd)  =>  (SABAv4i32:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, V128:{ *:[v4i32] }:$Rn, V128:{ *:[v4i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SABAv4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 10743,
        GIR_Done,
      // Label 247: @8042
      GIM_Try, /*On fail goto*//*Label 248*/ 8110, // Rule ID 10755 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_uabd,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v4i32] } (intrinsic_wo_chain:{ *:[v4i32] } 614:{ *:[iPTR] }, V128:{ *:[v4i32] }:$Rn, V128:{ *:[v4i32] }:$Rm), V128:{ *:[v4i32] }:$Rd)  =>  (UABAv4i32:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, V128:{ *:[v4i32] }:$Rn, V128:{ *:[v4i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UABAv4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 10755,
        GIR_Done,
      // Label 248: @8110
      GIM_Try, /*On fail goto*//*Label 249*/ 8166, // Rule ID 10705 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_saddlp,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v4i32] } (intrinsic_wo_chain:{ *:[v4i32] } 550:{ *:[iPTR] }, V128:{ *:[v8i16] }:$Rn), V128:{ *:[v4i32] }:$Rd)  =>  (SADALPv8i16_v4i32:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, V128:{ *:[v8i16] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SADALPv8i16_v4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 10705,
        GIR_Done,
      // Label 249: @8166
      GIM_Try, /*On fail goto*//*Label 250*/ 8222, // Rule ID 10717 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_uaddlp,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v4i32] } (intrinsic_wo_chain:{ *:[v4i32] } 615:{ *:[iPTR] }, V128:{ *:[v8i16] }:$Rn), V128:{ *:[v4i32] }:$Rd)  =>  (UADALPv8i16_v4i32:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, V128:{ *:[v8i16] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UADALPv8i16_v4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 10717,
        GIR_Done,
      // Label 250: @8222
      GIM_Try, /*On fail goto*//*Label 251*/ 8289, // Rule ID 10919 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, AArch64::G_VASHR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        // MIs[1] imm
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIPFP_I64_Predicate_vecshiftR32,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_add_and_or_is_add,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v4i32] } (AArch64vashr:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR32>>:$imm), V128:{ *:[v4i32] }:$Rd)<<P:Predicate_add_and_or_is_add>>  =>  (SSRAv4i32_shift:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, V128:{ *:[v4i32] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SSRAv4i32_shift,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 10919,
        GIR_Done,
      // Label 251: @8289
      GIM_Try, /*On fail goto*//*Label 252*/ 8356, // Rule ID 10940 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, AArch64::G_VLSHR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        // MIs[1] imm
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIPFP_I64_Predicate_vecshiftR32,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_add_and_or_is_add,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v4i32] } (AArch64vlshr:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR32>>:$imm), V128:{ *:[v4i32] }:$Rd)<<P:Predicate_add_and_or_is_add>>  =>  (USRAv4i32_shift:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, V128:{ *:[v4i32] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::USRAv4i32_shift,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 10940,
        GIR_Done,
      // Label 252: @8356
      GIM_Try, /*On fail goto*//*Label 253*/ 8424, // Rule ID 1330 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_sabd,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, (intrinsic_wo_chain:{ *:[v4i32] } 549:{ *:[iPTR] }, V128:{ *:[v4i32] }:$Rn, V128:{ *:[v4i32] }:$Rm))  =>  (SABAv4i32:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, V128:{ *:[v4i32] }:$Rn, V128:{ *:[v4i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SABAv4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1330,
        GIR_Done,
      // Label 253: @8424
      GIM_Try, /*On fail goto*//*Label 254*/ 8492, // Rule ID 1453 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_uabd,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, (intrinsic_wo_chain:{ *:[v4i32] } 614:{ *:[iPTR] }, V128:{ *:[v4i32] }:$Rn, V128:{ *:[v4i32] }:$Rm))  =>  (UABAv4i32:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, V128:{ *:[v4i32] }:$Rn, V128:{ *:[v4i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UABAv4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1453,
        GIR_Done,
      // Label 254: @8492
      GIM_Try, /*On fail goto*//*Label 255*/ 8548, // Rule ID 968 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_saddlp,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, (intrinsic_wo_chain:{ *:[v4i32] } 550:{ *:[iPTR] }, V128:{ *:[v8i16] }:$Rn))  =>  (SADALPv8i16_v4i32:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, V128:{ *:[v8i16] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SADALPv8i16_v4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 968,
        GIR_Done,
      // Label 255: @8548
      GIM_Try, /*On fail goto*//*Label 256*/ 8604, // Rule ID 1029 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_uaddlp,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, (intrinsic_wo_chain:{ *:[v4i32] } 615:{ *:[iPTR] }, V128:{ *:[v8i16] }:$Rn))  =>  (UADALPv8i16_v4i32:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, V128:{ *:[v8i16] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UADALPv8i16_v4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1029,
        GIR_Done,
      // Label 256: @8604
      GIM_Try, /*On fail goto*//*Label 257*/ 8671, // Rule ID 2153 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, AArch64::G_VASHR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        // MIs[1] imm
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIPFP_I64_Predicate_vecshiftR32,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_add_and_or_is_add,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, (AArch64vashr:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR32>>:$imm))<<P:Predicate_add_and_or_is_add>>  =>  (SSRAv4i32_shift:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, V128:{ *:[v4i32] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SSRAv4i32_shift,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2153,
        GIR_Done,
      // Label 257: @8671
      GIM_Try, /*On fail goto*//*Label 258*/ 8738, // Rule ID 2212 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, AArch64::G_VLSHR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        // MIs[1] imm
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIPFP_I64_Predicate_vecshiftR32,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_add_and_or_is_add,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, (AArch64vlshr:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR32>>:$imm))<<P:Predicate_add_and_or_is_add>>  =>  (USRAv4i32_shift:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, V128:{ *:[v4i32] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::USRAv4i32_shift,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2212,
        GIR_Done,
      // Label 258: @8738
      GIM_Try, /*On fail goto*//*Label 259*/ 8800, // Rule ID 1753 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ANYEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_ANYEXT,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v4i32] } (anyext:{ *:[v4i32] } V64:{ *:[v4i16] }:$Rn), (anyext:{ *:[v4i32] } V64:{ *:[v4i16] }:$Rm))  =>  (UADDLv4i16_v4i32:{ *:[v4i32] } V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UADDLv4i16_v4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1753,
        GIR_Done,
      // Label 259: @8800
      GIM_Try, /*On fail goto*//*Label 260*/ 8862, // Rule ID 1752 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ANYEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v4i32] } (anyext:{ *:[v4i32] } V64:{ *:[v4i16] }:$Rn), (zext:{ *:[v4i32] } V64:{ *:[v4i16] }:$Rm))  =>  (UADDLv4i16_v4i32:{ *:[v4i32] } V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UADDLv4i16_v4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1752,
        GIR_Done,
      // Label 260: @8862
      GIM_Try, /*On fail goto*//*Label 261*/ 8924, // Rule ID 1678 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_SEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_SEXT,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v4i32] } (sext:{ *:[v4i32] } V64:{ *:[v4i16] }:$Rn), (sext:{ *:[v4i32] } V64:{ *:[v4i16] }:$Rm))  =>  (SADDLv4i16_v4i32:{ *:[v4i32] } V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SADDLv4i16_v4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1678,
        GIR_Done,
      // Label 261: @8924
      GIM_Try, /*On fail goto*//*Label 262*/ 8986, // Rule ID 1751 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_ANYEXT,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v4i32] } (zext:{ *:[v4i32] } V64:{ *:[v4i16] }:$Rn), (anyext:{ *:[v4i32] } V64:{ *:[v4i16] }:$Rm))  =>  (UADDLv4i16_v4i32:{ *:[v4i32] } V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UADDLv4i16_v4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1751,
        GIR_Done,
      // Label 262: @8986
      GIM_Try, /*On fail goto*//*Label 263*/ 9048, // Rule ID 1750 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v4i32] } (zext:{ *:[v4i32] } V64:{ *:[v4i16] }:$Rn), (zext:{ *:[v4i32] } V64:{ *:[v4i16] }:$Rm))  =>  (UADDLv4i16_v4i32:{ *:[v4i32] } V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UADDLv4i16_v4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1750,
        GIR_Done,
      // Label 263: @9048
      GIM_Try, /*On fail goto*//*Label 264*/ 9097, // Rule ID 10815 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ANYEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v4i32] } (anyext:{ *:[v4i32] } V64:{ *:[v4i16] }:$Rm), V128:{ *:[v4i32] }:$Rn)  =>  (UADDWv4i16_v4i32:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rn, V64:{ *:[v4i16] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UADDWv4i16_v4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 10815,
        GIR_Done,
      // Label 264: @9097
      GIM_Try, /*On fail goto*//*Label 265*/ 9146, // Rule ID 10788 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_SEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v4i32] } (sext:{ *:[v4i32] } V64:{ *:[v4i16] }:$Rm), V128:{ *:[v4i32] }:$Rn)  =>  (SADDWv4i16_v4i32:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rn, V64:{ *:[v4i16] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SADDWv4i16_v4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 10788,
        GIR_Done,
      // Label 265: @9146
      GIM_Try, /*On fail goto*//*Label 266*/ 9195, // Rule ID 10814 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v4i32] } (zext:{ *:[v4i32] } V64:{ *:[v4i16] }:$Rm), V128:{ *:[v4i32] }:$Rn)  =>  (UADDWv4i16_v4i32:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rn, V64:{ *:[v4i16] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UADDWv4i16_v4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 10814,
        GIR_Done,
      // Label 266: @9195
      GIM_Try, /*On fail goto*//*Label 267*/ 9244, // Rule ID 1771 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ANYEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rn, (anyext:{ *:[v4i32] } V64:{ *:[v4i16] }:$Rm))  =>  (UADDWv4i16_v4i32:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rn, V64:{ *:[v4i16] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UADDWv4i16_v4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1771,
        GIR_Done,
      // Label 267: @9244
      GIM_Try, /*On fail goto*//*Label 268*/ 9293, // Rule ID 1684 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_SEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rn, (sext:{ *:[v4i32] } V64:{ *:[v4i16] }:$Rm))  =>  (SADDWv4i16_v4i32:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rn, V64:{ *:[v4i16] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SADDWv4i16_v4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1684,
        GIR_Done,
      // Label 268: @9293
      GIM_Try, /*On fail goto*//*Label 269*/ 9342, // Rule ID 1770 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rn, (zext:{ *:[v4i32] } V64:{ *:[v4i16] }:$Rm))  =>  (UADDWv4i16_v4i32:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rn, V64:{ *:[v4i16] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UADDWv4i16_v4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1770,
        GIR_Done,
      // Label 269: @9342
      GIM_Try, /*On fail goto*//*Label 270*/ 9365, // Rule ID 1078 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        // (add:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rn, V128:{ *:[v4i32] }:$Rm)  =>  (ADDv4i32:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rn, V128:{ *:[v4i32] }:$Rm)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::ADDv4i32,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1078,
        GIR_Done,
      // Label 270: @9365
      GIM_Reject,
    // Label 242: @9366
    GIM_Reject,
    // Label 126: @9367
    GIM_Try, /*On fail goto*//*Label 271*/ 9941,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s8,
      GIM_Try, /*On fail goto*//*Label 272*/ 9445, // Rule ID 10733 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_sabd,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v8i8] } (intrinsic_wo_chain:{ *:[v8i8] } 549:{ *:[iPTR] }, V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm), V64:{ *:[v8i8] }:$Rd)  =>  (SABAv8i8:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rd, V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SABAv8i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 10733,
        GIR_Done,
      // Label 272: @9445
      GIM_Try, /*On fail goto*//*Label 273*/ 9513, // Rule ID 10745 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_uabd,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v8i8] } (intrinsic_wo_chain:{ *:[v8i8] } 614:{ *:[iPTR] }, V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm), V64:{ *:[v8i8] }:$Rd)  =>  (UABAv8i8:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rd, V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UABAv8i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 10745,
        GIR_Done,
      // Label 273: @9513
      GIM_Try, /*On fail goto*//*Label 274*/ 9580, // Rule ID 10909 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, AArch64::G_VASHR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        // MIs[1] imm
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIPFP_I64_Predicate_vecshiftR8,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_add_and_or_is_add,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v8i8] } (AArch64vashr:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR8>>:$imm), V64:{ *:[v8i8] }:$Rd)<<P:Predicate_add_and_or_is_add>>  =>  (SSRAv8i8_shift:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rd, V64:{ *:[v8i8] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SSRAv8i8_shift,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 10909,
        GIR_Done,
      // Label 274: @9580
      GIM_Try, /*On fail goto*//*Label 275*/ 9647, // Rule ID 10930 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, AArch64::G_VLSHR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        // MIs[1] imm
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIPFP_I64_Predicate_vecshiftR8,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_add_and_or_is_add,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v8i8] } (AArch64vlshr:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR8>>:$imm), V64:{ *:[v8i8] }:$Rd)<<P:Predicate_add_and_or_is_add>>  =>  (USRAv8i8_shift:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rd, V64:{ *:[v8i8] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::USRAv8i8_shift,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 10930,
        GIR_Done,
      // Label 275: @9647
      GIM_Try, /*On fail goto*//*Label 276*/ 9715, // Rule ID 1320 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_sabd,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rd, (intrinsic_wo_chain:{ *:[v8i8] } 549:{ *:[iPTR] }, V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm))  =>  (SABAv8i8:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rd, V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SABAv8i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1320,
        GIR_Done,
      // Label 276: @9715
      GIM_Try, /*On fail goto*//*Label 277*/ 9783, // Rule ID 1443 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_uabd,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rd, (intrinsic_wo_chain:{ *:[v8i8] } 614:{ *:[iPTR] }, V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm))  =>  (UABAv8i8:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rd, V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UABAv8i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1443,
        GIR_Done,
      // Label 277: @9783
      GIM_Try, /*On fail goto*//*Label 278*/ 9850, // Rule ID 2143 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, AArch64::G_VASHR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        // MIs[1] imm
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIPFP_I64_Predicate_vecshiftR8,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_add_and_or_is_add,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rd, (AArch64vashr:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR8>>:$imm))<<P:Predicate_add_and_or_is_add>>  =>  (SSRAv8i8_shift:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rd, V64:{ *:[v8i8] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SSRAv8i8_shift,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2143,
        GIR_Done,
      // Label 278: @9850
      GIM_Try, /*On fail goto*//*Label 279*/ 9917, // Rule ID 2202 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, AArch64::G_VLSHR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        // MIs[1] imm
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIPFP_I64_Predicate_vecshiftR8,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_add_and_or_is_add,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rd, (AArch64vlshr:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR8>>:$imm))<<P:Predicate_add_and_or_is_add>>  =>  (USRAv8i8_shift:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rd, V64:{ *:[v8i8] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::USRAv8i8_shift,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2202,
        GIR_Done,
      // Label 279: @9917
      GIM_Try, /*On fail goto*//*Label 280*/ 9940, // Rule ID 1073 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        // (add:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm)  =>  (ADDv8i8:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::ADDv8i8,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1073,
        GIR_Done,
      // Label 280: @9940
      GIM_Reject,
    // Label 271: @9941
    GIM_Reject,
    // Label 127: @9942
    GIM_Try, /*On fail goto*//*Label 281*/ 11668,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
      GIM_Try, /*On fail goto*//*Label 282*/ 10033, // Rule ID 10775 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/2, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, Intrinsic::aarch64_neon_sabd,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/3, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v8i16] } (zext:{ *:[v8i16] } (intrinsic_wo_chain:{ *:[v8i8] } 549:{ *:[iPTR] }, V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm)), V128:{ *:[v8i16] }:$Rd)  =>  (SABALv8i8_v8i16:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rd, V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SABALv8i8_v8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/3, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 10775,
        GIR_Done,
      // Label 282: @10033
      GIM_Try, /*On fail goto*//*Label 283*/ 10114, // Rule ID 10799 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/2, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, Intrinsic::aarch64_neon_uabd,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/3, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v8i16] } (zext:{ *:[v8i16] } (intrinsic_wo_chain:{ *:[v8i8] } 614:{ *:[iPTR] }, V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm)), V128:{ *:[v8i16] }:$Rd)  =>  (UABALv8i8_v8i16:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rd, V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UABALv8i8_v8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/3, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 10799,
        GIR_Done,
      // Label 283: @10114
      GIM_Try, /*On fail goto*//*Label 284*/ 10195, // Rule ID 1653 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/2, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, Intrinsic::aarch64_neon_sabd,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/3, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rd, (zext:{ *:[v8i16] } (intrinsic_wo_chain:{ *:[v8i8] } 549:{ *:[iPTR] }, V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm)))  =>  (SABALv8i8_v8i16:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rd, V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SABALv8i8_v8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/3, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1653,
        GIR_Done,
      // Label 284: @10195
      GIM_Try, /*On fail goto*//*Label 285*/ 10276, // Rule ID 1731 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/2, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, Intrinsic::aarch64_neon_uabd,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/3, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rd, (zext:{ *:[v8i16] } (intrinsic_wo_chain:{ *:[v8i8] } 614:{ *:[iPTR] }, V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm)))  =>  (UABALv8i8_v8i16:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rd, V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UABALv8i8_v8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/3, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1731,
        GIR_Done,
      // Label 285: @10276
      GIM_Try, /*On fail goto*//*Label 286*/ 10344, // Rule ID 10739 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_sabd,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v8i16] } (intrinsic_wo_chain:{ *:[v8i16] } 549:{ *:[iPTR] }, V128:{ *:[v8i16] }:$Rn, V128:{ *:[v8i16] }:$Rm), V128:{ *:[v8i16] }:$Rd)  =>  (SABAv8i16:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rd, V128:{ *:[v8i16] }:$Rn, V128:{ *:[v8i16] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SABAv8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 10739,
        GIR_Done,
      // Label 286: @10344
      GIM_Try, /*On fail goto*//*Label 287*/ 10412, // Rule ID 10751 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_uabd,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v8i16] } (intrinsic_wo_chain:{ *:[v8i16] } 614:{ *:[iPTR] }, V128:{ *:[v8i16] }:$Rn, V128:{ *:[v8i16] }:$Rm), V128:{ *:[v8i16] }:$Rd)  =>  (UABAv8i16:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rd, V128:{ *:[v8i16] }:$Rn, V128:{ *:[v8i16] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UABAv8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 10751,
        GIR_Done,
      // Label 287: @10412
      GIM_Try, /*On fail goto*//*Label 288*/ 10468, // Rule ID 10701 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_saddlp,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v8i16] } (intrinsic_wo_chain:{ *:[v8i16] } 550:{ *:[iPTR] }, V128:{ *:[v16i8] }:$Rn), V128:{ *:[v8i16] }:$Rd)  =>  (SADALPv16i8_v8i16:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rd, V128:{ *:[v16i8] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SADALPv16i8_v8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 10701,
        GIR_Done,
      // Label 288: @10468
      GIM_Try, /*On fail goto*//*Label 289*/ 10524, // Rule ID 10713 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_uaddlp,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v8i16] } (intrinsic_wo_chain:{ *:[v8i16] } 615:{ *:[iPTR] }, V128:{ *:[v16i8] }:$Rn), V128:{ *:[v8i16] }:$Rd)  =>  (UADALPv16i8_v8i16:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rd, V128:{ *:[v16i8] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UADALPv16i8_v8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 10713,
        GIR_Done,
      // Label 289: @10524
      GIM_Try, /*On fail goto*//*Label 290*/ 10591, // Rule ID 10915 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, AArch64::G_VASHR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        // MIs[1] imm
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIPFP_I64_Predicate_vecshiftR16,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_add_and_or_is_add,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v8i16] } (AArch64vashr:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR16>>:$imm), V128:{ *:[v8i16] }:$Rd)<<P:Predicate_add_and_or_is_add>>  =>  (SSRAv8i16_shift:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rd, V128:{ *:[v8i16] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SSRAv8i16_shift,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 10915,
        GIR_Done,
      // Label 290: @10591
      GIM_Try, /*On fail goto*//*Label 291*/ 10658, // Rule ID 10936 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, AArch64::G_VLSHR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        // MIs[1] imm
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIPFP_I64_Predicate_vecshiftR16,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_add_and_or_is_add,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v8i16] } (AArch64vlshr:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR16>>:$imm), V128:{ *:[v8i16] }:$Rd)<<P:Predicate_add_and_or_is_add>>  =>  (USRAv8i16_shift:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rd, V128:{ *:[v8i16] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::USRAv8i16_shift,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 10936,
        GIR_Done,
      // Label 291: @10658
      GIM_Try, /*On fail goto*//*Label 292*/ 10726, // Rule ID 1326 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_sabd,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rd, (intrinsic_wo_chain:{ *:[v8i16] } 549:{ *:[iPTR] }, V128:{ *:[v8i16] }:$Rn, V128:{ *:[v8i16] }:$Rm))  =>  (SABAv8i16:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rd, V128:{ *:[v8i16] }:$Rn, V128:{ *:[v8i16] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SABAv8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1326,
        GIR_Done,
      // Label 292: @10726
      GIM_Try, /*On fail goto*//*Label 293*/ 10794, // Rule ID 1449 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_uabd,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rd, (intrinsic_wo_chain:{ *:[v8i16] } 614:{ *:[iPTR] }, V128:{ *:[v8i16] }:$Rn, V128:{ *:[v8i16] }:$Rm))  =>  (UABAv8i16:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rd, V128:{ *:[v8i16] }:$Rn, V128:{ *:[v8i16] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UABAv8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1449,
        GIR_Done,
      // Label 293: @10794
      GIM_Try, /*On fail goto*//*Label 294*/ 10850, // Rule ID 964 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_saddlp,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rd, (intrinsic_wo_chain:{ *:[v8i16] } 550:{ *:[iPTR] }, V128:{ *:[v16i8] }:$Rn))  =>  (SADALPv16i8_v8i16:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rd, V128:{ *:[v16i8] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SADALPv16i8_v8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 964,
        GIR_Done,
      // Label 294: @10850
      GIM_Try, /*On fail goto*//*Label 295*/ 10906, // Rule ID 1025 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_uaddlp,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rd, (intrinsic_wo_chain:{ *:[v8i16] } 615:{ *:[iPTR] }, V128:{ *:[v16i8] }:$Rn))  =>  (UADALPv16i8_v8i16:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rd, V128:{ *:[v16i8] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UADALPv16i8_v8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1025,
        GIR_Done,
      // Label 295: @10906
      GIM_Try, /*On fail goto*//*Label 296*/ 10973, // Rule ID 2149 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, AArch64::G_VASHR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        // MIs[1] imm
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIPFP_I64_Predicate_vecshiftR16,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_add_and_or_is_add,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rd, (AArch64vashr:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR16>>:$imm))<<P:Predicate_add_and_or_is_add>>  =>  (SSRAv8i16_shift:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rd, V128:{ *:[v8i16] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SSRAv8i16_shift,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2149,
        GIR_Done,
      // Label 296: @10973
      GIM_Try, /*On fail goto*//*Label 297*/ 11040, // Rule ID 2208 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, AArch64::G_VLSHR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        // MIs[1] imm
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIPFP_I64_Predicate_vecshiftR16,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_add_and_or_is_add,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rd, (AArch64vlshr:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR16>>:$imm))<<P:Predicate_add_and_or_is_add>>  =>  (USRAv8i16_shift:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rd, V128:{ *:[v8i16] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::USRAv8i16_shift,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2208,
        GIR_Done,
      // Label 297: @11040
      GIM_Try, /*On fail goto*//*Label 298*/ 11102, // Rule ID 1745 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ANYEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_ANYEXT,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v8i16] } (anyext:{ *:[v8i16] } V64:{ *:[v8i8] }:$Rn), (anyext:{ *:[v8i16] } V64:{ *:[v8i8] }:$Rm))  =>  (UADDLv8i8_v8i16:{ *:[v8i16] } V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UADDLv8i8_v8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1745,
        GIR_Done,
      // Label 298: @11102
      GIM_Try, /*On fail goto*//*Label 299*/ 11164, // Rule ID 1744 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ANYEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v8i16] } (anyext:{ *:[v8i16] } V64:{ *:[v8i8] }:$Rn), (zext:{ *:[v8i16] } V64:{ *:[v8i8] }:$Rm))  =>  (UADDLv8i8_v8i16:{ *:[v8i16] } V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UADDLv8i8_v8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1744,
        GIR_Done,
      // Label 299: @11164
      GIM_Try, /*On fail goto*//*Label 300*/ 11226, // Rule ID 1676 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_SEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_SEXT,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v8i16] } (sext:{ *:[v8i16] } V64:{ *:[v8i8] }:$Rn), (sext:{ *:[v8i16] } V64:{ *:[v8i8] }:$Rm))  =>  (SADDLv8i8_v8i16:{ *:[v8i16] } V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SADDLv8i8_v8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1676,
        GIR_Done,
      // Label 300: @11226
      GIM_Try, /*On fail goto*//*Label 301*/ 11288, // Rule ID 1743 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_ANYEXT,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v8i16] } (zext:{ *:[v8i16] } V64:{ *:[v8i8] }:$Rn), (anyext:{ *:[v8i16] } V64:{ *:[v8i8] }:$Rm))  =>  (UADDLv8i8_v8i16:{ *:[v8i16] } V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UADDLv8i8_v8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1743,
        GIR_Done,
      // Label 301: @11288
      GIM_Try, /*On fail goto*//*Label 302*/ 11350, // Rule ID 1742 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v8i16] } (zext:{ *:[v8i16] } V64:{ *:[v8i8] }:$Rn), (zext:{ *:[v8i16] } V64:{ *:[v8i8] }:$Rm))  =>  (UADDLv8i8_v8i16:{ *:[v8i16] } V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UADDLv8i8_v8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1742,
        GIR_Done,
      // Label 302: @11350
      GIM_Try, /*On fail goto*//*Label 303*/ 11399, // Rule ID 10811 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ANYEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v8i16] } (anyext:{ *:[v8i16] } V64:{ *:[v8i8] }:$Rm), V128:{ *:[v8i16] }:$Rn)  =>  (UADDWv8i8_v8i16:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rn, V64:{ *:[v8i8] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UADDWv8i8_v8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 10811,
        GIR_Done,
      // Label 303: @11399
      GIM_Try, /*On fail goto*//*Label 304*/ 11448, // Rule ID 10786 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_SEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v8i16] } (sext:{ *:[v8i16] } V64:{ *:[v8i8] }:$Rm), V128:{ *:[v8i16] }:$Rn)  =>  (SADDWv8i8_v8i16:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rn, V64:{ *:[v8i8] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SADDWv8i8_v8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 10786,
        GIR_Done,
      // Label 304: @11448
      GIM_Try, /*On fail goto*//*Label 305*/ 11497, // Rule ID 10810 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v8i16] } (zext:{ *:[v8i16] } V64:{ *:[v8i8] }:$Rm), V128:{ *:[v8i16] }:$Rn)  =>  (UADDWv8i8_v8i16:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rn, V64:{ *:[v8i8] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UADDWv8i8_v8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 10810,
        GIR_Done,
      // Label 305: @11497
      GIM_Try, /*On fail goto*//*Label 306*/ 11546, // Rule ID 1767 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ANYEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rn, (anyext:{ *:[v8i16] } V64:{ *:[v8i8] }:$Rm))  =>  (UADDWv8i8_v8i16:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rn, V64:{ *:[v8i8] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UADDWv8i8_v8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1767,
        GIR_Done,
      // Label 306: @11546
      GIM_Try, /*On fail goto*//*Label 307*/ 11595, // Rule ID 1682 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_SEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rn, (sext:{ *:[v8i16] } V64:{ *:[v8i8] }:$Rm))  =>  (SADDWv8i8_v8i16:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rn, V64:{ *:[v8i8] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SADDWv8i8_v8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1682,
        GIR_Done,
      // Label 307: @11595
      GIM_Try, /*On fail goto*//*Label 308*/ 11644, // Rule ID 1766 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rn, (zext:{ *:[v8i16] } V64:{ *:[v8i8] }:$Rm))  =>  (UADDWv8i8_v8i16:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rn, V64:{ *:[v8i8] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UADDWv8i8_v8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1766,
        GIR_Done,
      // Label 308: @11644
      GIM_Try, /*On fail goto*//*Label 309*/ 11667, // Rule ID 1076 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        // (add:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rn, V128:{ *:[v8i16] }:$Rm)  =>  (ADDv8i16:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rn, V128:{ *:[v8i16] }:$Rm)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::ADDv8i16,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1076,
        GIR_Done,
      // Label 309: @11667
      GIM_Reject,
    // Label 281: @11668
    GIM_Reject,
    // Label 128: @11669
    GIM_Try, /*On fail goto*//*Label 310*/ 12243,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
      GIM_Try, /*On fail goto*//*Label 311*/ 11747, // Rule ID 10735 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_sabd,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v16i8] } (intrinsic_wo_chain:{ *:[v16i8] } 549:{ *:[iPTR] }, V128:{ *:[v16i8] }:$Rn, V128:{ *:[v16i8] }:$Rm), V128:{ *:[v16i8] }:$Rd)  =>  (SABAv16i8:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rd, V128:{ *:[v16i8] }:$Rn, V128:{ *:[v16i8] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SABAv16i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 10735,
        GIR_Done,
      // Label 311: @11747
      GIM_Try, /*On fail goto*//*Label 312*/ 11815, // Rule ID 10747 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_uabd,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v16i8] } (intrinsic_wo_chain:{ *:[v16i8] } 614:{ *:[iPTR] }, V128:{ *:[v16i8] }:$Rn, V128:{ *:[v16i8] }:$Rm), V128:{ *:[v16i8] }:$Rd)  =>  (UABAv16i8:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rd, V128:{ *:[v16i8] }:$Rn, V128:{ *:[v16i8] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UABAv16i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 10747,
        GIR_Done,
      // Label 312: @11815
      GIM_Try, /*On fail goto*//*Label 313*/ 11882, // Rule ID 10911 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, AArch64::G_VASHR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        // MIs[1] imm
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIPFP_I64_Predicate_vecshiftR8,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_add_and_or_is_add,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v16i8] } (AArch64vashr:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR8>>:$imm), V128:{ *:[v16i8] }:$Rd)<<P:Predicate_add_and_or_is_add>>  =>  (SSRAv16i8_shift:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rd, V128:{ *:[v16i8] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SSRAv16i8_shift,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 10911,
        GIR_Done,
      // Label 313: @11882
      GIM_Try, /*On fail goto*//*Label 314*/ 11949, // Rule ID 10932 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, AArch64::G_VLSHR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        // MIs[1] imm
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIPFP_I64_Predicate_vecshiftR8,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_add_and_or_is_add,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v16i8] } (AArch64vlshr:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR8>>:$imm), V128:{ *:[v16i8] }:$Rd)<<P:Predicate_add_and_or_is_add>>  =>  (USRAv16i8_shift:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rd, V128:{ *:[v16i8] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::USRAv16i8_shift,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 10932,
        GIR_Done,
      // Label 314: @11949
      GIM_Try, /*On fail goto*//*Label 315*/ 12017, // Rule ID 1322 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_sabd,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rd, (intrinsic_wo_chain:{ *:[v16i8] } 549:{ *:[iPTR] }, V128:{ *:[v16i8] }:$Rn, V128:{ *:[v16i8] }:$Rm))  =>  (SABAv16i8:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rd, V128:{ *:[v16i8] }:$Rn, V128:{ *:[v16i8] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SABAv16i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1322,
        GIR_Done,
      // Label 315: @12017
      GIM_Try, /*On fail goto*//*Label 316*/ 12085, // Rule ID 1445 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_uabd,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rd, (intrinsic_wo_chain:{ *:[v16i8] } 614:{ *:[iPTR] }, V128:{ *:[v16i8] }:$Rn, V128:{ *:[v16i8] }:$Rm))  =>  (UABAv16i8:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rd, V128:{ *:[v16i8] }:$Rn, V128:{ *:[v16i8] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UABAv16i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1445,
        GIR_Done,
      // Label 316: @12085
      GIM_Try, /*On fail goto*//*Label 317*/ 12152, // Rule ID 2145 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, AArch64::G_VASHR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        // MIs[1] imm
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIPFP_I64_Predicate_vecshiftR8,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_add_and_or_is_add,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rd, (AArch64vashr:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR8>>:$imm))<<P:Predicate_add_and_or_is_add>>  =>  (SSRAv16i8_shift:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rd, V128:{ *:[v16i8] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SSRAv16i8_shift,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2145,
        GIR_Done,
      // Label 317: @12152
      GIM_Try, /*On fail goto*//*Label 318*/ 12219, // Rule ID 2204 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, AArch64::G_VLSHR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        // MIs[1] imm
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIPFP_I64_Predicate_vecshiftR8,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_add_and_or_is_add,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rd, (AArch64vlshr:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR8>>:$imm))<<P:Predicate_add_and_or_is_add>>  =>  (USRAv16i8_shift:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rd, V128:{ *:[v16i8] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::USRAv16i8_shift,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2204,
        GIR_Done,
      // Label 318: @12219
      GIM_Try, /*On fail goto*//*Label 319*/ 12242, // Rule ID 1074 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        // (add:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rn, V128:{ *:[v16i8] }:$Rm)  =>  (ADDv16i8:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rn, V128:{ *:[v16i8] }:$Rm)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::ADDv16i8,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1074,
        GIR_Done,
      // Label 319: @12242
      GIM_Reject,
    // Label 310: @12243
    GIM_Reject,
    // Label 129: @12244
    GIM_Reject,
    // Label 1: @12245
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/1, 11, /*)*//*default:*//*Label 329*/ 16112,
    /*GILLT_s32*//*Label 320*/ 12261,
    /*GILLT_s64*//*Label 321*/ 13048, 0,
    /*GILLT_v2s32*//*Label 322*/ 14340,
    /*GILLT_v2s64*//*Label 323*/ 14411,
    /*GILLT_v4s16*//*Label 324*/ 14907,
    /*GILLT_v4s32*//*Label 325*/ 14978,
    /*GILLT_v8s8*//*Label 326*/ 15474,
    /*GILLT_v8s16*//*Label 327*/ 15545,
    /*GILLT_v16s8*//*Label 328*/ 16041,
    // Label 320: @12261
    GIM_Try, /*On fail goto*//*Label 330*/ 13047,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 331*/ 12410, // Rule ID 4534 //
        GIM_CheckFeatures, GIFBS_HasSVEorSME_UseScalarIncVL,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_TRUNC,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/2, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, Intrinsic::aarch64_sve_cntb,
        // MIs[2] pattern
        GIM_CheckIsImm, /*MI*/2, /*Op*/2,
        GIM_CheckImmOperandPredicate, /*MI*/2, /*MO*/2, /*Predicate*/GIPFP_I64_Predicate_sve_pred_enum,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (sub:{ *:[i32] } GPR32:{ *:[i32] }:$Rdn, (trunc:{ *:[i32] } (intrinsic_wo_chain:{ *:[i64] } 887:{ *:[iPTR] }, (timm:{ *:[i32] })<<P:Predicate_sve_pred_enum>>:$pattern)))  =>  (EXTRACT_SUBREG:{ *:[i32] } (DECB_XPiI:{ *:[i64] } (INSERT_SUBREG:{ *:[i64] } (IMPLICIT_DEF:{ *:[i64] }), GPR32:{ *:[i32] }:$Rdn, sub_32:{ *:[i32] }), (timm:{ *:[i32] })<<P:Predicate_sve_pred_enum>>:$pattern, 1:{ *:[i32] }), sub_32:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s64,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::INSERT_SUBREG,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/2, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // Rdn
        GIR_AddImm, /*InsnID*/2, /*Imm*/15,
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, AArch64::GPR64allRegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, AArch64::GPR64allRegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/2, AArch64::GPR32RegClassID,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AArch64::DECB_XPiI,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/2, /*OpIdx*/2, // pattern
        GIR_AddImm, /*InsnID*/1, /*Imm*/1,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0, AArch64::sub_32,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AArch64::GPR32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, AArch64::GPR64RegClassID,
        // GIR_Coverage, 4534,
        GIR_Done,
      // Label 331: @12410
      GIM_Try, /*On fail goto*//*Label 332*/ 12549, // Rule ID 4546 //
        GIM_CheckFeatures, GIFBS_HasSVEorSME_UseScalarIncVL,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_TRUNC,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/2, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, Intrinsic::aarch64_sve_cnth,
        // MIs[2] pattern
        GIM_CheckIsImm, /*MI*/2, /*Op*/2,
        GIM_CheckImmOperandPredicate, /*MI*/2, /*MO*/2, /*Predicate*/GIPFP_I64_Predicate_sve_pred_enum,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (sub:{ *:[i32] } GPR32:{ *:[i32] }:$Rdn, (trunc:{ *:[i32] } (intrinsic_wo_chain:{ *:[i64] } 889:{ *:[iPTR] }, (timm:{ *:[i32] })<<P:Predicate_sve_pred_enum>>:$pattern)))  =>  (EXTRACT_SUBREG:{ *:[i32] } (DECH_XPiI:{ *:[i64] } (INSERT_SUBREG:{ *:[i64] } (IMPLICIT_DEF:{ *:[i64] }), GPR32:{ *:[i32] }:$Rdn, sub_32:{ *:[i32] }), (timm:{ *:[i32] })<<P:Predicate_sve_pred_enum>>:$pattern, 1:{ *:[i32] }), sub_32:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s64,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::INSERT_SUBREG,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/2, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // Rdn
        GIR_AddImm, /*InsnID*/2, /*Imm*/15,
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, AArch64::GPR64allRegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, AArch64::GPR64allRegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/2, AArch64::GPR32RegClassID,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AArch64::DECH_XPiI,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/2, /*OpIdx*/2, // pattern
        GIR_AddImm, /*InsnID*/1, /*Imm*/1,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0, AArch64::sub_32,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AArch64::GPR32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, AArch64::GPR64RegClassID,
        // GIR_Coverage, 4546,
        GIR_Done,
      // Label 332: @12549
      GIM_Try, /*On fail goto*//*Label 333*/ 12688, // Rule ID 4558 //
        GIM_CheckFeatures, GIFBS_HasSVEorSME_UseScalarIncVL,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_TRUNC,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/2, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, Intrinsic::aarch64_sve_cntw,
        // MIs[2] pattern
        GIM_CheckIsImm, /*MI*/2, /*Op*/2,
        GIM_CheckImmOperandPredicate, /*MI*/2, /*MO*/2, /*Predicate*/GIPFP_I64_Predicate_sve_pred_enum,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (sub:{ *:[i32] } GPR32:{ *:[i32] }:$Rdn, (trunc:{ *:[i32] } (intrinsic_wo_chain:{ *:[i64] } 891:{ *:[iPTR] }, (timm:{ *:[i32] })<<P:Predicate_sve_pred_enum>>:$pattern)))  =>  (EXTRACT_SUBREG:{ *:[i32] } (DECW_XPiI:{ *:[i64] } (INSERT_SUBREG:{ *:[i64] } (IMPLICIT_DEF:{ *:[i64] }), GPR32:{ *:[i32] }:$Rdn, sub_32:{ *:[i32] }), (timm:{ *:[i32] })<<P:Predicate_sve_pred_enum>>:$pattern, 1:{ *:[i32] }), sub_32:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s64,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::INSERT_SUBREG,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/2, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // Rdn
        GIR_AddImm, /*InsnID*/2, /*Imm*/15,
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, AArch64::GPR64allRegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, AArch64::GPR64allRegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/2, AArch64::GPR32RegClassID,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AArch64::DECW_XPiI,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/2, /*OpIdx*/2, // pattern
        GIR_AddImm, /*InsnID*/1, /*Imm*/1,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0, AArch64::sub_32,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AArch64::GPR32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, AArch64::GPR64RegClassID,
        // GIR_Coverage, 4558,
        GIR_Done,
      // Label 333: @12688
      GIM_Try, /*On fail goto*//*Label 334*/ 12827, // Rule ID 4570 //
        GIM_CheckFeatures, GIFBS_HasSVEorSME_UseScalarIncVL,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_TRUNC,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/2, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, Intrinsic::aarch64_sve_cntd,
        // MIs[2] pattern
        GIM_CheckIsImm, /*MI*/2, /*Op*/2,
        GIM_CheckImmOperandPredicate, /*MI*/2, /*MO*/2, /*Predicate*/GIPFP_I64_Predicate_sve_pred_enum,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (sub:{ *:[i32] } GPR32:{ *:[i32] }:$Rdn, (trunc:{ *:[i32] } (intrinsic_wo_chain:{ *:[i64] } 888:{ *:[iPTR] }, (timm:{ *:[i32] })<<P:Predicate_sve_pred_enum>>:$pattern)))  =>  (EXTRACT_SUBREG:{ *:[i32] } (DECD_XPiI:{ *:[i64] } (INSERT_SUBREG:{ *:[i64] } (IMPLICIT_DEF:{ *:[i64] }), GPR32:{ *:[i32] }:$Rdn, sub_32:{ *:[i32] }), (timm:{ *:[i32] })<<P:Predicate_sve_pred_enum>>:$pattern, 1:{ *:[i32] }), sub_32:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s64,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/RegState::Define,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::INSERT_SUBREG,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/2, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // Rdn
        GIR_AddImm, /*InsnID*/2, /*Imm*/15,
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, AArch64::GPR64allRegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, AArch64::GPR64allRegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/2, AArch64::GPR32RegClassID,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AArch64::DECD_XPiI,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/2, /*OpIdx*/2, // pattern
        GIR_AddImm, /*InsnID*/1, /*Imm*/1,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::COPY,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0, AArch64::sub_32,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AArch64::GPR32RegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, AArch64::GPR64RegClassID,
        // GIR_Coverage, 4570,
        GIR_Done,
      // Label 334: @12827
      GIM_Try, /*On fail goto*//*Label 335*/ 12886, // Rule ID 7915 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/1, 0,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_MUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sub:{ *:[i32] } 0:{ *:[i32] }, (mul:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, GPR32:{ *:[i32] }:$Rm))  =>  (MSUBWrrr:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, GPR32:{ *:[i32] }:$Rm, WZR:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::MSUBWrrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rm
        GIR_AddRegister, /*InsnID*/0, AArch64::WZR, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 7915,
        GIR_Done,
      // Label 335: @12886
      GIM_Try, /*On fail goto*//*Label 336*/ 12920, // Rule ID 7880 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR32spRegClassID,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/0, GICP_gi_arith_extended_reg32_i32,
        // (sub:{ *:[i32] } GPR32sp:{ *:[i32] }:$R2, arith_extended_reg32_i32:{ *:[i32] }:$R3)  =>  (SUBSWrx:{ *:[i32] }:{ *:[i32] } GPR32sp:{ *:[i32] }:$R2, arith_extended_reg32_i32:{ *:[i32] }:$R3)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SUBSWrx,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // R2
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/0, // R3
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 7880,
        GIR_Done,
      // Label 336: @12920
      GIM_Try, /*On fail goto*//*Label 337*/ 12954, // Rule ID 7885 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/0, GICP_gi_neg_addsub_shifted_imm32,
        // (sub:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, neg_addsub_shifted_imm32:{ *:[i32] }:$imm)  =>  (ADDWri:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, neg_addsub_shifted_imm32:{ *:[i32] }:$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::ADDWri,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/0, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 7885,
        GIR_Done,
      // Label 337: @12954
      GIM_Try, /*On fail goto*//*Label 338*/ 12988, // Rule ID 7874 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR32spRegClassID,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/0, GICP_gi_addsub_shifted_imm32,
        // (sub:{ *:[i32] } GPR32sp:{ *:[i32] }:$Rn, addsub_shifted_imm32:{ *:[i32] }:$imm)  =>  (SUBSWri:{ *:[i32] }:{ *:[i32] } GPR32sp:{ *:[i32] }:$Rn, addsub_shifted_imm32:{ *:[i32] }:$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SUBSWri,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/0, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 7874,
        GIR_Done,
      // Label 338: @12988
      GIM_Try, /*On fail goto*//*Label 339*/ 13022, // Rule ID 7878 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/0, GICP_gi_arith_shifted_reg32,
        // (sub:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, arith_shifted_reg32:{ *:[i32] }:$Rm)  =>  (SUBSWrs:{ *:[i32] }:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, arith_shifted_reg32:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SUBSWrs,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/0, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 7878,
        GIR_Done,
      // Label 339: @13022
      GIM_Try, /*On fail goto*//*Label 340*/ 13046, // Rule ID 7876 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        // (sub:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, GPR32:{ *:[i32] }:$Rm)  =>  (SUBSWrr:{ *:[i32] }:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, GPR32:{ *:[i32] }:$Rm)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::SUBSWrr,
        GIR_AddImplicitDef, /*InsnID*/0, AArch64::NZCV,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 7876,
        GIR_Done,
      // Label 340: @13046
      GIM_Reject,
    // Label 330: @13047
    GIM_Reject,
    // Label 321: @13048
    GIM_Try, /*On fail goto*//*Label 341*/ 14339,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_Try, /*On fail goto*//*Label 342*/ 13154, // Rule ID 7930 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/1, 0,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_MUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_SEXT,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIPFP_I64_Predicate_s64imm_32bit,
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (sub:{ *:[i64] } 0:{ *:[i64] }, (mul:{ *:[i64] } (sext:{ *:[i64] } GPR32:{ *:[i32] }:$Rn), (imm:{ *:[i64] })<<P:Predicate_s64imm_32bit>>:$C))  =>  (SMSUBLrrr:{ *:[i64] } GPR32:{ *:[i32] }:$Rn, (MOVi32imm:{ *:[i32] } (trunc_imm:{ *:[i32] } (imm:{ *:[i64] }):$C)), XZR:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AArch64::MOVi32imm,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_CustomRenderer, /*InsnID*/1, /*OldInsnID*/3, /*Renderer*/GICR_renderTruncImm, // C
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SMSUBLrrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rn
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddRegister, /*InsnID*/0, AArch64::XZR, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 7930,
        GIR_Done,
      // Label 342: @13154
      GIM_Try, /*On fail goto*//*Label 343*/ 13250, // Rule ID 7931 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/1, 0,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_MUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIPFP_I64_Predicate_i64imm_32bit,
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (sub:{ *:[i64] } 0:{ *:[i64] }, (mul:{ *:[i64] } (zext:{ *:[i64] } GPR32:{ *:[i32] }:$Rn), (imm:{ *:[i64] })<<P:Predicate_i64imm_32bit>>:$C))  =>  (UMSUBLrrr:{ *:[i64] } GPR32:{ *:[i32] }:$Rn, (MOVi32imm:{ *:[i32] } (trunc_imm:{ *:[i32] } (imm:{ *:[i64] }):$C)), XZR:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AArch64::MOVi32imm,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_CustomRenderer, /*InsnID*/1, /*OldInsnID*/3, /*Renderer*/GICR_renderTruncImm, // C
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UMSUBLrrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rn
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddRegister, /*InsnID*/0, AArch64::XZR, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 7931,
        GIR_Done,
      // Label 343: @13250
      GIM_Try, /*On fail goto*//*Label 344*/ 13335, // Rule ID 7925 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/1, 0,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_MUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_SEXT,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_SEXT,
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (sub:{ *:[i64] } 0:{ *:[i64] }, (mul:{ *:[i64] } (sext:{ *:[i64] } GPR32:{ *:[i32] }:$Rn), (sext:{ *:[i64] } GPR32:{ *:[i32] }:$Rm)))  =>  (SMSUBLrrr:{ *:[i64] } GPR32:{ *:[i32] }:$Rn, GPR32:{ *:[i32] }:$Rm, XZR:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SMSUBLrrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // Rm
        GIR_AddRegister, /*InsnID*/0, AArch64::XZR, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 7925,
        GIR_Done,
      // Label 344: @13335
      GIM_Try, /*On fail goto*//*Label 345*/ 13420, // Rule ID 7926 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/1, 0,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_MUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (sub:{ *:[i64] } 0:{ *:[i64] }, (mul:{ *:[i64] } (zext:{ *:[i64] } GPR32:{ *:[i32] }:$Rn), (zext:{ *:[i64] } GPR32:{ *:[i32] }:$Rm)))  =>  (UMSUBLrrr:{ *:[i64] } GPR32:{ *:[i32] }:$Rn, GPR32:{ *:[i32] }:$Rm, XZR:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UMSUBLrrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // Rm
        GIR_AddRegister, /*InsnID*/0, AArch64::XZR, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 7926,
        GIR_Done,
      // Label 345: @13420
      GIM_Try, /*On fail goto*//*Label 346*/ 13516, // Rule ID 7936 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_MUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_SEXT,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIPFP_I64_Predicate_s64imm_32bit,
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (sub:{ *:[i64] } GPR64:{ *:[i64] }:$Ra, (mul:{ *:[i64] } (sext:{ *:[i64] } GPR32:{ *:[i32] }:$Rn), (imm:{ *:[i64] })<<P:Predicate_s64imm_32bit>>:$C))  =>  (SMSUBLrrr:{ *:[i64] } GPR32:{ *:[i32] }:$Rn, (MOVi32imm:{ *:[i32] } (trunc_imm:{ *:[i32] } (imm:{ *:[i64] }):$C)), GPR64:{ *:[i64] }:$Ra)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AArch64::MOVi32imm,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_CustomRenderer, /*InsnID*/1, /*OldInsnID*/3, /*Renderer*/GICR_renderTruncImm, // C
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SMSUBLrrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rn
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Ra
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 7936,
        GIR_Done,
      // Label 346: @13516
      GIM_Try, /*On fail goto*//*Label 347*/ 13612, // Rule ID 7937 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_MUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIPFP_I64_Predicate_i64imm_32bit,
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (sub:{ *:[i64] } GPR64:{ *:[i64] }:$Ra, (mul:{ *:[i64] } (zext:{ *:[i64] } GPR32:{ *:[i32] }:$Rn), (imm:{ *:[i64] })<<P:Predicate_i64imm_32bit>>:$C))  =>  (UMSUBLrrr:{ *:[i64] } GPR32:{ *:[i32] }:$Rn, (MOVi32imm:{ *:[i32] } (trunc_imm:{ *:[i32] } (imm:{ *:[i64] }):$C)), GPR64:{ *:[i64] }:$Ra)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AArch64::MOVi32imm,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_CustomRenderer, /*InsnID*/1, /*OldInsnID*/3, /*Renderer*/GICR_renderTruncImm, // C
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UMSUBLrrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rn
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Ra
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 7937,
        GIR_Done,
      // Label 347: @13612
      GIM_Try, /*On fail goto*//*Label 348*/ 13697, // Rule ID 126 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_MUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_SEXT,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_SEXT,
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (sub:{ *:[i64] } GPR64:{ *:[i64] }:$Ra, (mul:{ *:[i64] } (sext:{ *:[i64] } GPR32:{ *:[i32] }:$Rn), (sext:{ *:[i64] } GPR32:{ *:[i32] }:$Rm)))  =>  (SMSUBLrrr:{ *:[i64] } GPR32:{ *:[i32] }:$Rn, GPR32:{ *:[i32] }:$Rm, GPR64:{ *:[i64] }:$Ra)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SMSUBLrrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Ra
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 126,
        GIR_Done,
      // Label 348: @13697
      GIM_Try, /*On fail goto*//*Label 349*/ 13782, // Rule ID 128 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_MUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (sub:{ *:[i64] } GPR64:{ *:[i64] }:$Ra, (mul:{ *:[i64] } (zext:{ *:[i64] } GPR32:{ *:[i32] }:$Rn), (zext:{ *:[i64] } GPR32:{ *:[i32] }:$Rm)))  =>  (UMSUBLrrr:{ *:[i64] } GPR32:{ *:[i32] }:$Rn, GPR32:{ *:[i32] }:$Rm, GPR64:{ *:[i64] }:$Ra)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UMSUBLrrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // Rm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Ra
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 128,
        GIR_Done,
      // Label 349: @13782
      GIM_Try, /*On fail goto*//*Label 350*/ 13841, // Rule ID 7916 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/1, 0,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_MUL,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sub:{ *:[i64] } 0:{ *:[i64] }, (mul:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm))  =>  (MSUBXrrr:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm, XZR:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::MSUBXrrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rm
        GIR_AddRegister, /*InsnID*/0, AArch64::XZR, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 7916,
        GIR_Done,
      // Label 350: @13841
      GIM_Try, /*On fail goto*//*Label 351*/ 13900, // Rule ID 4531 //
        GIM_CheckFeatures, GIFBS_HasSVEorSME_UseScalarIncVL,
        GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/0, /*OtherMI*/0, /*OtherOpIdx*/1,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_sve_cntb,
        // MIs[1] pattern
        GIM_CheckIsImm, /*MI*/1, /*Op*/2,
        GIM_CheckImmOperandPredicate, /*MI*/1, /*MO*/2, /*Predicate*/GIPFP_I64_Predicate_sve_pred_enum,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sub:{ *:[i64] } GPR64:{ *:[i64] }:$Rdn, (intrinsic_wo_chain:{ *:[i64] } 887:{ *:[iPTR] }, (timm:{ *:[i32] })<<P:Predicate_sve_pred_enum>>:$pattern))  =>  (DECB_XPiI:{ *:[i64] } GPR64:{ *:[i64] }:$Rdn, (timm:{ *:[i32] })<<P:Predicate_sve_pred_enum>>:$pattern, 1:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::DECB_XPiI,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rdn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rdn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // pattern
        GIR_AddImm, /*InsnID*/0, /*Imm*/1,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4531,
        GIR_Done,
      // Label 351: @13900
      GIM_Try, /*On fail goto*//*Label 352*/ 13959, // Rule ID 4543 //
        GIM_CheckFeatures, GIFBS_HasSVEorSME_UseScalarIncVL,
        GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/0, /*OtherMI*/0, /*OtherOpIdx*/1,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_sve_cnth,
        // MIs[1] pattern
        GIM_CheckIsImm, /*MI*/1, /*Op*/2,
        GIM_CheckImmOperandPredicate, /*MI*/1, /*MO*/2, /*Predicate*/GIPFP_I64_Predicate_sve_pred_enum,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sub:{ *:[i64] } GPR64:{ *:[i64] }:$Rdn, (intrinsic_wo_chain:{ *:[i64] } 889:{ *:[iPTR] }, (timm:{ *:[i32] })<<P:Predicate_sve_pred_enum>>:$pattern))  =>  (DECH_XPiI:{ *:[i64] } GPR64:{ *:[i64] }:$Rdn, (timm:{ *:[i32] })<<P:Predicate_sve_pred_enum>>:$pattern, 1:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::DECH_XPiI,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rdn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rdn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // pattern
        GIR_AddImm, /*InsnID*/0, /*Imm*/1,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4543,
        GIR_Done,
      // Label 352: @13959
      GIM_Try, /*On fail goto*//*Label 353*/ 14018, // Rule ID 4555 //
        GIM_CheckFeatures, GIFBS_HasSVEorSME_UseScalarIncVL,
        GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/0, /*OtherMI*/0, /*OtherOpIdx*/1,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_sve_cntw,
        // MIs[1] pattern
        GIM_CheckIsImm, /*MI*/1, /*Op*/2,
        GIM_CheckImmOperandPredicate, /*MI*/1, /*MO*/2, /*Predicate*/GIPFP_I64_Predicate_sve_pred_enum,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sub:{ *:[i64] } GPR64:{ *:[i64] }:$Rdn, (intrinsic_wo_chain:{ *:[i64] } 891:{ *:[iPTR] }, (timm:{ *:[i32] })<<P:Predicate_sve_pred_enum>>:$pattern))  =>  (DECW_XPiI:{ *:[i64] } GPR64:{ *:[i64] }:$Rdn, (timm:{ *:[i32] })<<P:Predicate_sve_pred_enum>>:$pattern, 1:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::DECW_XPiI,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rdn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rdn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // pattern
        GIR_AddImm, /*InsnID*/0, /*Imm*/1,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4555,
        GIR_Done,
      // Label 353: @14018
      GIM_Try, /*On fail goto*//*Label 354*/ 14077, // Rule ID 4567 //
        GIM_CheckFeatures, GIFBS_HasSVEorSME_UseScalarIncVL,
        GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/0, /*OtherMI*/0, /*OtherOpIdx*/1,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_sve_cntd,
        // MIs[1] pattern
        GIM_CheckIsImm, /*MI*/1, /*Op*/2,
        GIM_CheckImmOperandPredicate, /*MI*/1, /*MO*/2, /*Predicate*/GIPFP_I64_Predicate_sve_pred_enum,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sub:{ *:[i64] } GPR64:{ *:[i64] }:$Rdn, (intrinsic_wo_chain:{ *:[i64] } 888:{ *:[iPTR] }, (timm:{ *:[i32] })<<P:Predicate_sve_pred_enum>>:$pattern))  =>  (DECD_XPiI:{ *:[i64] } GPR64:{ *:[i64] }:$Rdn, (timm:{ *:[i32] })<<P:Predicate_sve_pred_enum>>:$pattern, 1:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::DECD_XPiI,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rdn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rdn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // pattern
        GIR_AddImm, /*InsnID*/0, /*Imm*/1,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 4567,
        GIR_Done,
      // Label 354: @14077
      GIM_Try, /*On fail goto*//*Label 355*/ 14111, // Rule ID 7881 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/0, GICP_gi_arith_extended_reg32to64_i64,
        // (sub:{ *:[i64] } GPR64sp:{ *:[i64] }:$R2, arith_extended_reg32to64_i64:{ *:[i64] }:$R3)  =>  (SUBSXrx:{ *:[i64] }:{ *:[i32] } GPR64sp:{ *:[i64] }:$R2, arith_extended_reg32to64_i64:{ *:[i64] }:$R3)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SUBSXrx,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // R2
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/0, // R3
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 7881,
        GIR_Done,
      // Label 355: @14111
      GIM_Try, /*On fail goto*//*Label 356*/ 14145, // Rule ID 7886 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/0, GICP_gi_neg_addsub_shifted_imm64,
        // (sub:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, neg_addsub_shifted_imm64:{ *:[i64] }:$imm)  =>  (ADDXri:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, neg_addsub_shifted_imm64:{ *:[i64] }:$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::ADDXri,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/0, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 7886,
        GIR_Done,
      // Label 356: @14145
      GIM_Try, /*On fail goto*//*Label 357*/ 14179, // Rule ID 7875 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/0, GICP_gi_addsub_shifted_imm64,
        // (sub:{ *:[i64] } GPR64sp:{ *:[i64] }:$Rn, addsub_shifted_imm64:{ *:[i64] }:$imm)  =>  (SUBSXri:{ *:[i64] }:{ *:[i32] } GPR64sp:{ *:[i64] }:$Rn, addsub_shifted_imm64:{ *:[i64] }:$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SUBSXri,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/0, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 7875,
        GIR_Done,
      // Label 357: @14179
      GIM_Try, /*On fail goto*//*Label 358*/ 14213, // Rule ID 7879 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/0, GICP_gi_arith_shifted_reg64,
        // (sub:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, arith_shifted_reg64:{ *:[i64] }:$Rm)  =>  (SUBSXrs:{ *:[i64] }:{ *:[i32] } GPR64:{ *:[i64] }:$Rn, arith_shifted_reg64:{ *:[i64] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SUBSXrs,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/0, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 7879,
        GIR_Done,
      // Label 358: @14213
      GIM_Try, /*On fail goto*//*Label 359*/ 14253, // Rule ID 1619 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcodeIsEither, /*MI*/1, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllZeros, /*MI*/1,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sub:{ *:[v1i64] } immAllZerosV:{ *:[v1i64] }, FPR64:{ *:[v1i64] }:$Rn)  =>  (NEGv1i64:{ *:[v1i64] } FPR64:{ *:[v1i64] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::NEGv1i64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1619,
        GIR_Done,
      // Label 359: @14253
      GIM_Try, /*On fail goto*//*Label 360*/ 14291, // Rule ID 8716 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcodeIsEither, /*MI*/1, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllZeros, /*MI*/1,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sub:{ *:[i64] } immAllZerosV:{ *:[i64] }, FPR64:{ *:[i64] }:$Rn)  =>  (NEGv1i64:{ *:[i64] } FPR64:{ *:[i64] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::NEGv1i64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 8716,
        GIR_Done,
      // Label 360: @14291
      GIM_Try, /*On fail goto*//*Label 361*/ 14314, // Rule ID 1609 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        // (sub:{ *:[v1i64] } FPR64:{ *:[v1i64] }:$Rn, FPR64:{ *:[v1i64] }:$Rm)  =>  (SUBv1i64:{ *:[v1i64] } FPR64:{ *:[v1i64] }:$Rn, FPR64:{ *:[v1i64] }:$Rm)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::SUBv1i64,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1609,
        GIR_Done,
      // Label 361: @14314
      GIM_Try, /*On fail goto*//*Label 362*/ 14338, // Rule ID 7877 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR64RegClassID,
        // (sub:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm)  =>  (SUBSXrr:{ *:[i64] }:{ *:[i32] } GPR64:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::SUBSXrr,
        GIR_AddImplicitDef, /*InsnID*/0, AArch64::NZCV,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 7877,
        GIR_Done,
      // Label 362: @14338
      GIM_Reject,
    // Label 341: @14339
    GIM_Reject,
    // Label 322: @14340
    GIM_Try, /*On fail goto*//*Label 363*/ 14410,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_Try, /*On fail goto*//*Label 364*/ 14390, // Rule ID 942 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcodeIsEither, /*MI*/1, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllZeros, /*MI*/1,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sub:{ *:[v2i32] } immAllZerosV:{ *:[v2i32] }, V64:{ *:[v2i32] }:$Rn)  =>  (NEGv2i32:{ *:[v2i32] } V64:{ *:[v2i32] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::NEGv2i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 942,
        GIR_Done,
      // Label 364: @14390
      GIM_Try, /*On fail goto*//*Label 365*/ 14409, // Rule ID 1439 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        // (sub:{ *:[v2i32] } V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm)  =>  (SUBv2i32:{ *:[v2i32] } V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::SUBv2i32,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1439,
        GIR_Done,
      // Label 365: @14409
      GIM_Reject,
    // Label 363: @14410
    GIM_Reject,
    // Label 323: @14411
    GIM_Try, /*On fail goto*//*Label 366*/ 14906,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_Try, /*On fail goto*//*Label 367*/ 14483, // Rule ID 1815 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ANYEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_ANYEXT,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (sub:{ *:[v2i64] } (anyext:{ *:[v2i64] } V64:{ *:[v2i32] }:$Rn), (anyext:{ *:[v2i64] } V64:{ *:[v2i32] }:$Rm))  =>  (USUBLv2i32_v2i64:{ *:[v2i64] } V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::USUBLv2i32_v2i64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1815,
        GIR_Done,
      // Label 367: @14483
      GIM_Try, /*On fail goto*//*Label 368*/ 14541, // Rule ID 1814 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ANYEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (sub:{ *:[v2i64] } (anyext:{ *:[v2i64] } V64:{ *:[v2i32] }:$Rn), (zext:{ *:[v2i64] } V64:{ *:[v2i32] }:$Rm))  =>  (USUBLv2i32_v2i64:{ *:[v2i64] } V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::USUBLv2i32_v2i64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1814,
        GIR_Done,
      // Label 368: @14541
      GIM_Try, /*On fail goto*//*Label 369*/ 14599, // Rule ID 1722 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_SEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_SEXT,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (sub:{ *:[v2i64] } (sext:{ *:[v2i64] } V64:{ *:[v2i32] }:$Rn), (sext:{ *:[v2i64] } V64:{ *:[v2i32] }:$Rm))  =>  (SSUBLv2i32_v2i64:{ *:[v2i64] } V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SSUBLv2i32_v2i64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1722,
        GIR_Done,
      // Label 369: @14599
      GIM_Try, /*On fail goto*//*Label 370*/ 14657, // Rule ID 1813 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_ANYEXT,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (sub:{ *:[v2i64] } (zext:{ *:[v2i64] } V64:{ *:[v2i32] }:$Rn), (anyext:{ *:[v2i64] } V64:{ *:[v2i32] }:$Rm))  =>  (USUBLv2i32_v2i64:{ *:[v2i64] } V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::USUBLv2i32_v2i64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1813,
        GIR_Done,
      // Label 370: @14657
      GIM_Try, /*On fail goto*//*Label 371*/ 14715, // Rule ID 1812 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (sub:{ *:[v2i64] } (zext:{ *:[v2i64] } V64:{ *:[v2i32] }:$Rn), (zext:{ *:[v2i64] } V64:{ *:[v2i32] }:$Rm))  =>  (USUBLv2i32_v2i64:{ *:[v2i64] } V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::USUBLv2i32_v2i64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1812,
        GIR_Done,
      // Label 371: @14715
      GIM_Try, /*On fail goto*//*Label 372*/ 14751, // Rule ID 944 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcodeIsEither, /*MI*/1, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllZeros, /*MI*/1,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sub:{ *:[v2i64] } immAllZerosV:{ *:[v2i64] }, V128:{ *:[v2i64] }:$Rn)  =>  (NEGv2i64:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::NEGv2i64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 944,
        GIR_Done,
      // Label 372: @14751
      GIM_Try, /*On fail goto*//*Label 373*/ 14796, // Rule ID 1829 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ANYEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sub:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rn, (anyext:{ *:[v2i64] } V64:{ *:[v2i32] }:$Rm))  =>  (USUBWv2i32_v2i64:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rn, V64:{ *:[v2i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::USUBWv2i32_v2i64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1829,
        GIR_Done,
      // Label 373: @14796
      GIM_Try, /*On fail goto*//*Label 374*/ 14841, // Rule ID 1728 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_SEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sub:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rn, (sext:{ *:[v2i64] } V64:{ *:[v2i32] }:$Rm))  =>  (SSUBWv2i32_v2i64:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rn, V64:{ *:[v2i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SSUBWv2i32_v2i64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1728,
        GIR_Done,
      // Label 374: @14841
      GIM_Try, /*On fail goto*//*Label 375*/ 14886, // Rule ID 1828 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sub:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rn, (zext:{ *:[v2i64] } V64:{ *:[v2i32] }:$Rm))  =>  (USUBWv2i32_v2i64:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rn, V64:{ *:[v2i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::USUBWv2i32_v2i64,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1828,
        GIR_Done,
      // Label 375: @14886
      GIM_Try, /*On fail goto*//*Label 376*/ 14905, // Rule ID 1441 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        // (sub:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rn, V128:{ *:[v2i64] }:$Rm)  =>  (SUBv2i64:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rn, V128:{ *:[v2i64] }:$Rm)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::SUBv2i64,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1441,
        GIR_Done,
      // Label 376: @14905
      GIM_Reject,
    // Label 366: @14906
    GIM_Reject,
    // Label 324: @14907
    GIM_Try, /*On fail goto*//*Label 377*/ 14977,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_Try, /*On fail goto*//*Label 378*/ 14957, // Rule ID 940 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcodeIsEither, /*MI*/1, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllZeros, /*MI*/1,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sub:{ *:[v4i16] } immAllZerosV:{ *:[v4i16] }, V64:{ *:[v4i16] }:$Rn)  =>  (NEGv4i16:{ *:[v4i16] } V64:{ *:[v4i16] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::NEGv4i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 940,
        GIR_Done,
      // Label 378: @14957
      GIM_Try, /*On fail goto*//*Label 379*/ 14976, // Rule ID 1437 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        // (sub:{ *:[v4i16] } V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm)  =>  (SUBv4i16:{ *:[v4i16] } V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::SUBv4i16,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1437,
        GIR_Done,
      // Label 379: @14976
      GIM_Reject,
    // Label 377: @14977
    GIM_Reject,
    // Label 325: @14978
    GIM_Try, /*On fail goto*//*Label 380*/ 15473,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_Try, /*On fail goto*//*Label 381*/ 15050, // Rule ID 1807 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ANYEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_ANYEXT,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (sub:{ *:[v4i32] } (anyext:{ *:[v4i32] } V64:{ *:[v4i16] }:$Rn), (anyext:{ *:[v4i32] } V64:{ *:[v4i16] }:$Rm))  =>  (USUBLv4i16_v4i32:{ *:[v4i32] } V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::USUBLv4i16_v4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1807,
        GIR_Done,
      // Label 381: @15050
      GIM_Try, /*On fail goto*//*Label 382*/ 15108, // Rule ID 1806 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ANYEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (sub:{ *:[v4i32] } (anyext:{ *:[v4i32] } V64:{ *:[v4i16] }:$Rn), (zext:{ *:[v4i32] } V64:{ *:[v4i16] }:$Rm))  =>  (USUBLv4i16_v4i32:{ *:[v4i32] } V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::USUBLv4i16_v4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1806,
        GIR_Done,
      // Label 382: @15108
      GIM_Try, /*On fail goto*//*Label 383*/ 15166, // Rule ID 1720 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_SEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_SEXT,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (sub:{ *:[v4i32] } (sext:{ *:[v4i32] } V64:{ *:[v4i16] }:$Rn), (sext:{ *:[v4i32] } V64:{ *:[v4i16] }:$Rm))  =>  (SSUBLv4i16_v4i32:{ *:[v4i32] } V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SSUBLv4i16_v4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1720,
        GIR_Done,
      // Label 383: @15166
      GIM_Try, /*On fail goto*//*Label 384*/ 15224, // Rule ID 1805 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_ANYEXT,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (sub:{ *:[v4i32] } (zext:{ *:[v4i32] } V64:{ *:[v4i16] }:$Rn), (anyext:{ *:[v4i32] } V64:{ *:[v4i16] }:$Rm))  =>  (USUBLv4i16_v4i32:{ *:[v4i32] } V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::USUBLv4i16_v4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1805,
        GIR_Done,
      // Label 384: @15224
      GIM_Try, /*On fail goto*//*Label 385*/ 15282, // Rule ID 1804 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (sub:{ *:[v4i32] } (zext:{ *:[v4i32] } V64:{ *:[v4i16] }:$Rn), (zext:{ *:[v4i32] } V64:{ *:[v4i16] }:$Rm))  =>  (USUBLv4i16_v4i32:{ *:[v4i32] } V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::USUBLv4i16_v4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1804,
        GIR_Done,
      // Label 385: @15282
      GIM_Try, /*On fail goto*//*Label 386*/ 15318, // Rule ID 943 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcodeIsEither, /*MI*/1, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllZeros, /*MI*/1,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sub:{ *:[v4i32] } immAllZerosV:{ *:[v4i32] }, V128:{ *:[v4i32] }:$Rn)  =>  (NEGv4i32:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::NEGv4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 943,
        GIR_Done,
      // Label 386: @15318
      GIM_Try, /*On fail goto*//*Label 387*/ 15363, // Rule ID 1825 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ANYEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sub:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rn, (anyext:{ *:[v4i32] } V64:{ *:[v4i16] }:$Rm))  =>  (USUBWv4i16_v4i32:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rn, V64:{ *:[v4i16] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::USUBWv4i16_v4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1825,
        GIR_Done,
      // Label 387: @15363
      GIM_Try, /*On fail goto*//*Label 388*/ 15408, // Rule ID 1726 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_SEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sub:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rn, (sext:{ *:[v4i32] } V64:{ *:[v4i16] }:$Rm))  =>  (SSUBWv4i16_v4i32:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rn, V64:{ *:[v4i16] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SSUBWv4i16_v4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1726,
        GIR_Done,
      // Label 388: @15408
      GIM_Try, /*On fail goto*//*Label 389*/ 15453, // Rule ID 1824 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sub:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rn, (zext:{ *:[v4i32] } V64:{ *:[v4i16] }:$Rm))  =>  (USUBWv4i16_v4i32:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rn, V64:{ *:[v4i16] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::USUBWv4i16_v4i32,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1824,
        GIR_Done,
      // Label 389: @15453
      GIM_Try, /*On fail goto*//*Label 390*/ 15472, // Rule ID 1440 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        // (sub:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rn, V128:{ *:[v4i32] }:$Rm)  =>  (SUBv4i32:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rn, V128:{ *:[v4i32] }:$Rm)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::SUBv4i32,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1440,
        GIR_Done,
      // Label 390: @15472
      GIM_Reject,
    // Label 380: @15473
    GIM_Reject,
    // Label 326: @15474
    GIM_Try, /*On fail goto*//*Label 391*/ 15544,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_Try, /*On fail goto*//*Label 392*/ 15524, // Rule ID 938 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcodeIsEither, /*MI*/1, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllZeros, /*MI*/1,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sub:{ *:[v8i8] } immAllZerosV:{ *:[v8i8] }, V64:{ *:[v8i8] }:$Rn)  =>  (NEGv8i8:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::NEGv8i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 938,
        GIR_Done,
      // Label 392: @15524
      GIM_Try, /*On fail goto*//*Label 393*/ 15543, // Rule ID 1435 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        // (sub:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm)  =>  (SUBv8i8:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::SUBv8i8,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1435,
        GIR_Done,
      // Label 393: @15543
      GIM_Reject,
    // Label 391: @15544
    GIM_Reject,
    // Label 327: @15545
    GIM_Try, /*On fail goto*//*Label 394*/ 16040,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_Try, /*On fail goto*//*Label 395*/ 15617, // Rule ID 1799 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ANYEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_ANYEXT,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (sub:{ *:[v8i16] } (anyext:{ *:[v8i16] } V64:{ *:[v8i8] }:$Rn), (anyext:{ *:[v8i16] } V64:{ *:[v8i8] }:$Rm))  =>  (USUBLv8i8_v8i16:{ *:[v8i16] } V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::USUBLv8i8_v8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1799,
        GIR_Done,
      // Label 395: @15617
      GIM_Try, /*On fail goto*//*Label 396*/ 15675, // Rule ID 1798 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ANYEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (sub:{ *:[v8i16] } (anyext:{ *:[v8i16] } V64:{ *:[v8i8] }:$Rn), (zext:{ *:[v8i16] } V64:{ *:[v8i8] }:$Rm))  =>  (USUBLv8i8_v8i16:{ *:[v8i16] } V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::USUBLv8i8_v8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1798,
        GIR_Done,
      // Label 396: @15675
      GIM_Try, /*On fail goto*//*Label 397*/ 15733, // Rule ID 1718 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_SEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_SEXT,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (sub:{ *:[v8i16] } (sext:{ *:[v8i16] } V64:{ *:[v8i8] }:$Rn), (sext:{ *:[v8i16] } V64:{ *:[v8i8] }:$Rm))  =>  (SSUBLv8i8_v8i16:{ *:[v8i16] } V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SSUBLv8i8_v8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1718,
        GIR_Done,
      // Label 397: @15733
      GIM_Try, /*On fail goto*//*Label 398*/ 15791, // Rule ID 1797 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_ANYEXT,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (sub:{ *:[v8i16] } (zext:{ *:[v8i16] } V64:{ *:[v8i8] }:$Rn), (anyext:{ *:[v8i16] } V64:{ *:[v8i8] }:$Rm))  =>  (USUBLv8i8_v8i16:{ *:[v8i16] } V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::USUBLv8i8_v8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1797,
        GIR_Done,
      // Label 398: @15791
      GIM_Try, /*On fail goto*//*Label 399*/ 15849, // Rule ID 1796 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (sub:{ *:[v8i16] } (zext:{ *:[v8i16] } V64:{ *:[v8i8] }:$Rn), (zext:{ *:[v8i16] } V64:{ *:[v8i8] }:$Rm))  =>  (USUBLv8i8_v8i16:{ *:[v8i16] } V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::USUBLv8i8_v8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1796,
        GIR_Done,
      // Label 399: @15849
      GIM_Try, /*On fail goto*//*Label 400*/ 15885, // Rule ID 941 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcodeIsEither, /*MI*/1, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllZeros, /*MI*/1,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sub:{ *:[v8i16] } immAllZerosV:{ *:[v8i16] }, V128:{ *:[v8i16] }:$Rn)  =>  (NEGv8i16:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::NEGv8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 941,
        GIR_Done,
      // Label 400: @15885
      GIM_Try, /*On fail goto*//*Label 401*/ 15930, // Rule ID 1821 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ANYEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sub:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rn, (anyext:{ *:[v8i16] } V64:{ *:[v8i8] }:$Rm))  =>  (USUBWv8i8_v8i16:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rn, V64:{ *:[v8i8] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::USUBWv8i8_v8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1821,
        GIR_Done,
      // Label 401: @15930
      GIM_Try, /*On fail goto*//*Label 402*/ 15975, // Rule ID 1724 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_SEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sub:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rn, (sext:{ *:[v8i16] } V64:{ *:[v8i8] }:$Rm))  =>  (SSUBWv8i8_v8i16:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rn, V64:{ *:[v8i8] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SSUBWv8i8_v8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1724,
        GIR_Done,
      // Label 402: @15975
      GIM_Try, /*On fail goto*//*Label 403*/ 16020, // Rule ID 1820 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sub:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rn, (zext:{ *:[v8i16] } V64:{ *:[v8i8] }:$Rm))  =>  (USUBWv8i8_v8i16:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rn, V64:{ *:[v8i8] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::USUBWv8i8_v8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1820,
        GIR_Done,
      // Label 403: @16020
      GIM_Try, /*On fail goto*//*Label 404*/ 16039, // Rule ID 1438 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        // (sub:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rn, V128:{ *:[v8i16] }:$Rm)  =>  (SUBv8i16:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rn, V128:{ *:[v8i16] }:$Rm)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::SUBv8i16,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1438,
        GIR_Done,
      // Label 404: @16039
      GIM_Reject,
    // Label 394: @16040
    GIM_Reject,
    // Label 328: @16041
    GIM_Try, /*On fail goto*//*Label 405*/ 16111,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_Try, /*On fail goto*//*Label 406*/ 16091, // Rule ID 939 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcodeIsEither, /*MI*/1, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllZeros, /*MI*/1,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sub:{ *:[v16i8] } immAllZerosV:{ *:[v16i8] }, V128:{ *:[v16i8] }:$Rn)  =>  (NEGv16i8:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::NEGv16i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 939,
        GIR_Done,
      // Label 406: @16091
      GIM_Try, /*On fail goto*//*Label 407*/ 16110, // Rule ID 1436 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        // (sub:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rn, V128:{ *:[v16i8] }:$Rm)  =>  (SUBv16i8:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rn, V128:{ *:[v16i8] }:$Rm)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::SUBv16i8,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1436,
        GIR_Done,
      // Label 407: @16110
      GIM_Reject,
    // Label 405: @16111
    GIM_Reject,
    // Label 329: @16112
    GIM_Reject,
    // Label 2: @16113
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/1, 11, /*)*//*default:*//*Label 416*/ 17427,
    /*GILLT_s32*//*Label 408*/ 16129,
    /*GILLT_s64*//*Label 409*/ 16289, 0,
    /*GILLT_v2s32*//*Label 410*/ 16711, 0,
    /*GILLT_v4s16*//*Label 411*/ 16874,
    /*GILLT_v4s32*//*Label 412*/ 17037,
    /*GILLT_v8s8*//*Label 413*/ 17200,
    /*GILLT_v8s16*//*Label 414*/ 17232,
    /*GILLT_v16s8*//*Label 415*/ 17395,
    // Label 408: @16129
    GIM_Try, /*On fail goto*//*Label 417*/ 16288,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
      GIM_Try, /*On fail goto*//*Label 418*/ 16198, // Rule ID 7917 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_SUB,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/1, 0,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (mul:{ *:[i32] } (sub:{ *:[i32] } 0:{ *:[i32] }, GPR32:{ *:[i32] }:$Rn), GPR32:{ *:[i32] }:$Rm)  =>  (MSUBWrrr:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, GPR32:{ *:[i32] }:$Rm, WZR:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::MSUBWrrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_AddRegister, /*InsnID*/0, AArch64::WZR, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 7917,
        GIR_Done,
      // Label 418: @16198
      GIM_Try, /*On fail goto*//*Label 419*/ 16253, // Rule ID 11660 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_SUB,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/1, 0,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (mul:{ *:[i32] } GPR32:{ *:[i32] }:$Rm, (sub:{ *:[i32] } 0:{ *:[i32] }, GPR32:{ *:[i32] }:$Rn))  =>  (MSUBWrrr:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, GPR32:{ *:[i32] }:$Rm, WZR:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::MSUBWrrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rm
        GIR_AddRegister, /*InsnID*/0, AArch64::WZR, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11660,
        GIR_Done,
      // Label 419: @16253
      GIM_Try, /*On fail goto*//*Label 420*/ 16287, // Rule ID 7913 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        // (mul:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, GPR32:{ *:[i32] }:$Rm)  =>  (MADDWrrr:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, GPR32:{ *:[i32] }:$Rm, WZR:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::MADDWrrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_AddRegister, /*InsnID*/0, AArch64::WZR, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 7913,
        GIR_Done,
      // Label 420: @16287
      GIM_Reject,
    // Label 417: @16288
    GIM_Reject,
    // Label 409: @16289
    GIM_Try, /*On fail goto*//*Label 421*/ 16710,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
      GIM_Try, /*On fail goto*//*Label 422*/ 16358, // Rule ID 7918 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_SUB,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/1, 0,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (mul:{ *:[i64] } (sub:{ *:[i64] } 0:{ *:[i64] }, GPR64:{ *:[i64] }:$Rn), GPR64:{ *:[i64] }:$Rm)  =>  (MSUBXrrr:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm, XZR:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::MSUBXrrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_AddRegister, /*InsnID*/0, AArch64::XZR, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 7918,
        GIR_Done,
      // Label 422: @16358
      GIM_Try, /*On fail goto*//*Label 423*/ 16413, // Rule ID 11661 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_SUB,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/1, 0,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (mul:{ *:[i64] } GPR64:{ *:[i64] }:$Rm, (sub:{ *:[i64] } 0:{ *:[i64] }, GPR64:{ *:[i64] }:$Rn))  =>  (MSUBXrrr:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm, XZR:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::MSUBXrrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rm
        GIR_AddRegister, /*InsnID*/0, AArch64::XZR, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11661,
        GIR_Done,
      // Label 423: @16413
      GIM_Try, /*On fail goto*//*Label 424*/ 16484, // Rule ID 7927 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_SEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIPFP_I64_Predicate_s64imm_32bit,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (mul:{ *:[i64] } (sext:{ *:[i64] } GPR32:{ *:[i32] }:$Rn), (imm:{ *:[i64] })<<P:Predicate_s64imm_32bit>>:$C)  =>  (SMADDLrrr:{ *:[i64] } GPR32:{ *:[i32] }:$Rn, (MOVi32imm:{ *:[i32] } (trunc_imm:{ *:[i32] } (imm:{ *:[i64] }):$C)), XZR:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AArch64::MOVi32imm,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_CustomRenderer, /*InsnID*/1, /*OldInsnID*/2, /*Renderer*/GICR_renderTruncImm, // C
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SMADDLrrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddRegister, /*InsnID*/0, AArch64::XZR, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 7927,
        GIR_Done,
      // Label 424: @16484
      GIM_Try, /*On fail goto*//*Label 425*/ 16555, // Rule ID 7928 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIPFP_I64_Predicate_i64imm_32bit,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (mul:{ *:[i64] } (zext:{ *:[i64] } GPR32:{ *:[i32] }:$Rn), (imm:{ *:[i64] })<<P:Predicate_i64imm_32bit>>:$C)  =>  (UMADDLrrr:{ *:[i64] } GPR32:{ *:[i32] }:$Rn, (MOVi32imm:{ *:[i32] } (trunc_imm:{ *:[i32] } (imm:{ *:[i64] }):$C)), XZR:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AArch64::MOVi32imm,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_CustomRenderer, /*InsnID*/1, /*OldInsnID*/2, /*Renderer*/GICR_renderTruncImm, // C
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UMADDLrrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddRegister, /*InsnID*/0, AArch64::XZR, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 7928,
        GIR_Done,
      // Label 425: @16555
      GIM_Try, /*On fail goto*//*Label 426*/ 16615, // Rule ID 7921 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_SEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_SEXT,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (mul:{ *:[i64] } (sext:{ *:[i64] } GPR32:{ *:[i32] }:$Rn), (sext:{ *:[i64] } GPR32:{ *:[i32] }:$Rm))  =>  (SMADDLrrr:{ *:[i64] } GPR32:{ *:[i32] }:$Rn, GPR32:{ *:[i32] }:$Rm, XZR:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SMADDLrrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_AddRegister, /*InsnID*/0, AArch64::XZR, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 7921,
        GIR_Done,
      // Label 426: @16615
      GIM_Try, /*On fail goto*//*Label 427*/ 16675, // Rule ID 7924 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (mul:{ *:[i64] } (zext:{ *:[i64] } GPR32:{ *:[i32] }:$Rn), (zext:{ *:[i64] } GPR32:{ *:[i32] }:$Rm))  =>  (UMADDLrrr:{ *:[i64] } GPR32:{ *:[i32] }:$Rn, GPR32:{ *:[i32] }:$Rm, XZR:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UMADDLrrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_AddRegister, /*InsnID*/0, AArch64::XZR, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 7924,
        GIR_Done,
      // Label 427: @16675
      GIM_Try, /*On fail goto*//*Label 428*/ 16709, // Rule ID 7914 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR64RegClassID,
        // (mul:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm)  =>  (MADDXrrr:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm, XZR:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::MADDXrrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_AddRegister, /*InsnID*/0, AArch64::XZR, /*AddRegisterRegFlags*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 7914,
        GIR_Done,
      // Label 428: @16709
      GIM_Reject,
    // Label 421: @16710
    GIM_Reject,
    // Label 410: @16711
    GIM_Try, /*On fail goto*//*Label 429*/ 16873,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_Try, /*On fail goto*//*Label 430*/ 16789, // Rule ID 10854 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, AArch64::G_DUPLANE32,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIPFP_I64_Predicate_VectorIndexS,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (mul:{ *:[v2i32] } (AArch64duplane32:{ *:[v2i32] } V128:{ *:[v4i32] }:$Rm, (imm:{ *:[i64] })<<P:Predicate_VectorIndexS>>:$idx), V64:{ *:[v2i32] }:$Rn)  =>  (MULv2i32_indexed:{ *:[v2i32] } V64:{ *:[v2i32] }:$Rn, V128:{ *:[v4i32] }:$Rm, (imm:{ *:[i64] }):$idx)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::MULv2i32_indexed,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // idx
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 10854,
        GIR_Done,
      // Label 430: @16789
      GIM_Try, /*On fail goto*//*Label 431*/ 16853, // Rule ID 1975 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, AArch64::G_DUPLANE32,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIPFP_I64_Predicate_VectorIndexS,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (mul:{ *:[v2i32] } V64:{ *:[v2i32] }:$Rn, (AArch64duplane32:{ *:[v2i32] } V128:{ *:[v4i32] }:$Rm, (imm:{ *:[i64] })<<P:Predicate_VectorIndexS>>:$idx))  =>  (MULv2i32_indexed:{ *:[v2i32] } V64:{ *:[v2i32] }:$Rn, V128:{ *:[v4i32] }:$Rm, (imm:{ *:[i64] }):$idx)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::MULv2i32_indexed,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // idx
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1975,
        GIR_Done,
      // Label 431: @16853
      GIM_Try, /*On fail goto*//*Label 432*/ 16872, // Rule ID 1315 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        // (mul:{ *:[v2i32] } V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm)  =>  (MULv2i32:{ *:[v2i32] } V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::MULv2i32,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1315,
        GIR_Done,
      // Label 432: @16872
      GIM_Reject,
    // Label 429: @16873
    GIM_Reject,
    // Label 411: @16874
    GIM_Try, /*On fail goto*//*Label 433*/ 17036,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_Try, /*On fail goto*//*Label 434*/ 16952, // Rule ID 10852 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, AArch64::G_DUPLANE16,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128_loRegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIPFP_I64_Predicate_VectorIndexH,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (mul:{ *:[v4i16] } (AArch64duplane16:{ *:[v4i16] } V128_lo:{ *:[v8i16] }:$Rm, (imm:{ *:[i64] })<<P:Predicate_VectorIndexH>>:$idx), V64:{ *:[v4i16] }:$Rn)  =>  (MULv4i16_indexed:{ *:[v4i16] } V64:{ *:[v4i16] }:$Rn, V128_lo:{ *:[v8i16] }:$Rm, (imm:{ *:[i64] }):$idx)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::MULv4i16_indexed,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // idx
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 10852,
        GIR_Done,
      // Label 434: @16952
      GIM_Try, /*On fail goto*//*Label 435*/ 17016, // Rule ID 1973 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, AArch64::G_DUPLANE16,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128_loRegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIPFP_I64_Predicate_VectorIndexH,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (mul:{ *:[v4i16] } V64:{ *:[v4i16] }:$Rn, (AArch64duplane16:{ *:[v4i16] } V128_lo:{ *:[v8i16] }:$Rm, (imm:{ *:[i64] })<<P:Predicate_VectorIndexH>>:$idx))  =>  (MULv4i16_indexed:{ *:[v4i16] } V64:{ *:[v4i16] }:$Rn, V128_lo:{ *:[v8i16] }:$Rm, (imm:{ *:[i64] }):$idx)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::MULv4i16_indexed,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // idx
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1973,
        GIR_Done,
      // Label 435: @17016
      GIM_Try, /*On fail goto*//*Label 436*/ 17035, // Rule ID 1313 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        // (mul:{ *:[v4i16] } V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm)  =>  (MULv4i16:{ *:[v4i16] } V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::MULv4i16,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1313,
        GIR_Done,
      // Label 436: @17035
      GIM_Reject,
    // Label 433: @17036
    GIM_Reject,
    // Label 412: @17037
    GIM_Try, /*On fail goto*//*Label 437*/ 17199,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_Try, /*On fail goto*//*Label 438*/ 17115, // Rule ID 10855 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, AArch64::G_DUPLANE32,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIPFP_I64_Predicate_VectorIndexS,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (mul:{ *:[v4i32] } (AArch64duplane32:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rm, (imm:{ *:[i64] })<<P:Predicate_VectorIndexS>>:$idx), V128:{ *:[v4i32] }:$Rn)  =>  (MULv4i32_indexed:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rn, V128:{ *:[v4i32] }:$Rm, (imm:{ *:[i64] }):$idx)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::MULv4i32_indexed,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // idx
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 10855,
        GIR_Done,
      // Label 438: @17115
      GIM_Try, /*On fail goto*//*Label 439*/ 17179, // Rule ID 1976 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, AArch64::G_DUPLANE32,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIPFP_I64_Predicate_VectorIndexS,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (mul:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rn, (AArch64duplane32:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rm, (imm:{ *:[i64] })<<P:Predicate_VectorIndexS>>:$idx))  =>  (MULv4i32_indexed:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rn, V128:{ *:[v4i32] }:$Rm, (imm:{ *:[i64] }):$idx)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::MULv4i32_indexed,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // idx
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1976,
        GIR_Done,
      // Label 439: @17179
      GIM_Try, /*On fail goto*//*Label 440*/ 17198, // Rule ID 1316 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        // (mul:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rn, V128:{ *:[v4i32] }:$Rm)  =>  (MULv4i32:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rn, V128:{ *:[v4i32] }:$Rm)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::MULv4i32,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1316,
        GIR_Done,
      // Label 440: @17198
      GIM_Reject,
    // Label 437: @17199
    GIM_Reject,
    // Label 413: @17200
    GIM_Try, /*On fail goto*//*Label 441*/ 17231, // Rule ID 1311 //
      GIM_CheckFeatures, GIFBS_HasNEON,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
      // (mul:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm)  =>  (MULv8i8:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::MULv8i8,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1311,
      GIR_Done,
    // Label 441: @17231
    GIM_Reject,
    // Label 414: @17232
    GIM_Try, /*On fail goto*//*Label 442*/ 17394,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_Try, /*On fail goto*//*Label 443*/ 17310, // Rule ID 10853 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, AArch64::G_DUPLANE16,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128_loRegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIPFP_I64_Predicate_VectorIndexH,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (mul:{ *:[v8i16] } (AArch64duplane16:{ *:[v8i16] } V128_lo:{ *:[v8i16] }:$Rm, (imm:{ *:[i64] })<<P:Predicate_VectorIndexH>>:$idx), V128:{ *:[v8i16] }:$Rn)  =>  (MULv8i16_indexed:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rn, V128_lo:{ *:[v8i16] }:$Rm, (imm:{ *:[i64] }):$idx)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::MULv8i16_indexed,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // idx
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 10853,
        GIR_Done,
      // Label 443: @17310
      GIM_Try, /*On fail goto*//*Label 444*/ 17374, // Rule ID 1974 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, AArch64::G_DUPLANE16,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128_loRegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIPFP_I64_Predicate_VectorIndexH,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (mul:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rn, (AArch64duplane16:{ *:[v8i16] } V128_lo:{ *:[v8i16] }:$Rm, (imm:{ *:[i64] })<<P:Predicate_VectorIndexH>>:$idx))  =>  (MULv8i16_indexed:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rn, V128_lo:{ *:[v8i16] }:$Rm, (imm:{ *:[i64] }):$idx)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::MULv8i16_indexed,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // idx
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1974,
        GIR_Done,
      // Label 444: @17374
      GIM_Try, /*On fail goto*//*Label 445*/ 17393, // Rule ID 1314 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        // (mul:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rn, V128:{ *:[v8i16] }:$Rm)  =>  (MULv8i16:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rn, V128:{ *:[v8i16] }:$Rm)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::MULv8i16,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1314,
        GIR_Done,
      // Label 445: @17393
      GIM_Reject,
    // Label 442: @17394
    GIM_Reject,
    // Label 415: @17395
    GIM_Try, /*On fail goto*//*Label 446*/ 17426, // Rule ID 1312 //
      GIM_CheckFeatures, GIFBS_HasNEON,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
      // (mul:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rn, V128:{ *:[v16i8] }:$Rm)  =>  (MULv16i8:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rn, V128:{ *:[v16i8] }:$Rm)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::MULv16i8,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 1312,
      GIR_Done,
    // Label 446: @17426
    GIM_Reject,
    // Label 416: @17427
    GIM_Reject,
    // Label 3: @17428
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/1, 3, /*)*//*default:*//*Label 449*/ 17496,
    /*GILLT_s32*//*Label 447*/ 17436,
    /*GILLT_s64*//*Label 448*/ 17466,
    // Label 447: @17436
    GIM_Try, /*On fail goto*//*Label 450*/ 17465, // Rule ID 119 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
      // (sdiv:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, GPR32:{ *:[i32] }:$Rm)  =>  (SDIVWr:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, GPR32:{ *:[i32] }:$Rm)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::SDIVWr,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 119,
      GIR_Done,
    // Label 450: @17465
    GIM_Reject,
    // Label 448: @17466
    GIM_Try, /*On fail goto*//*Label 451*/ 17495, // Rule ID 120 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR64RegClassID,
      // (sdiv:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm)  =>  (SDIVXr:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::SDIVXr,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 120,
      GIR_Done,
    // Label 451: @17495
    GIM_Reject,
    // Label 449: @17496
    GIM_Reject,
    // Label 4: @17497
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/1, 3, /*)*//*default:*//*Label 454*/ 17565,
    /*GILLT_s32*//*Label 452*/ 17505,
    /*GILLT_s64*//*Label 453*/ 17535,
    // Label 452: @17505
    GIM_Try, /*On fail goto*//*Label 455*/ 17534, // Rule ID 117 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
      // (udiv:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, GPR32:{ *:[i32] }:$Rm)  =>  (UDIVWr:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, GPR32:{ *:[i32] }:$Rm)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::UDIVWr,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 117,
      GIR_Done,
    // Label 455: @17534
    GIM_Reject,
    // Label 453: @17535
    GIM_Try, /*On fail goto*//*Label 456*/ 17564, // Rule ID 118 //
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR64RegClassID,
      // (udiv:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm)  =>  (UDIVXr:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::UDIVXr,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 118,
      GIR_Done,
    // Label 456: @17564
    GIM_Reject,
    // Label 454: @17565
    GIM_Reject,
    // Label 5: @17566
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/1, 22, /*)*//*default:*//*Label 471*/ 20737,
    /*GILLT_s32*//*Label 457*/ 17593,
    /*GILLT_s64*//*Label 458*/ 18080, 0,
    /*GILLT_v2s32*//*Label 459*/ 19318,
    /*GILLT_v2s64*//*Label 460*/ 19475,
    /*GILLT_v4s16*//*Label 461*/ 19632,
    /*GILLT_v4s32*//*Label 462*/ 19789,
    /*GILLT_v8s8*//*Label 463*/ 19946,
    /*GILLT_v8s16*//*Label 464*/ 20103,
    /*GILLT_v16s8*//*Label 465*/ 20260,
    /*GILLT_nxv1s1*//*Label 466*/ 20417,
    /*GILLT_nxv2s1*//*Label 467*/ 20481, 0, 0, 0,
    /*GILLT_nxv4s1*//*Label 468*/ 20545, 0, 0,
    /*GILLT_nxv8s1*//*Label 469*/ 20609, 0,
    /*GILLT_nxv16s1*//*Label 470*/ 20673,
    // Label 457: @17593
    GIM_Try, /*On fail goto*//*Label 472*/ 18079,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 473*/ 17658, // Rule ID 10644 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/0, GICP_gi_logical_shifted_reg32,
        // (and:{ *:[i32] } (xor:{ *:[i32] } logical_shifted_reg32:{ *:[i32] }:$Rm_and_shift, -1:{ *:[i32] }), GPR32:{ *:[i32] }:$Rn)  =>  (BICWrs:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, logical_shifted_reg32:{ *:[i32] }:$Rm_and_shift)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::BICWrs,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/0, // Rm_and_shift
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 10644,
        GIR_Done,
      // Label 473: @17658
      GIM_Try, /*On fail goto*//*Label 474*/ 17713, // Rule ID 164 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/0, GICP_gi_logical_shifted_reg32,
        // (and:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, (xor:{ *:[i32] } logical_shifted_reg32:{ *:[i32] }:$Rm_and_shift, -1:{ *:[i32] }))  =>  (BICWrs:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, logical_shifted_reg32:{ *:[i32] }:$Rm_and_shift)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::BICWrs,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/0, // Rm_and_shift
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 164,
        GIR_Done,
      // Label 474: @17713
      GIM_Try, /*On fail goto*//*Label 475*/ 17775, // Rule ID 8991 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_EXTRACT_VECTOR_ELT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIPFP_I64_Predicate_VectorIndexB,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, 255,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (and:{ *:[i32] } (vector_extract:{ *:[i32] } V128:{ *:[v16i8] }:$Rn, (imm:{ *:[i64] })<<P:Predicate_VectorIndexB>>:$idx), 255:{ *:[i32] })  =>  (UMOVvi8:{ *:[i32] } V128:{ *:[v16i8] }:$Rn, (imm:{ *:[i64] })<<P:Predicate_VectorIndexB>>:$idx)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UMOVvi8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // idx
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 8991,
        GIR_Done,
      // Label 475: @17775
      GIM_Try, /*On fail goto*//*Label 476*/ 17837, // Rule ID 8992 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_EXTRACT_VECTOR_ELT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIPFP_I64_Predicate_VectorIndexH,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, 65535,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (and:{ *:[i32] } (vector_extract:{ *:[i32] } V128:{ *:[v8i16] }:$Rn, (imm:{ *:[i64] })<<P:Predicate_VectorIndexH>>:$idx), 65535:{ *:[i32] })  =>  (UMOVvi16:{ *:[i32] } V128:{ *:[v8i16] }:$Rn, (imm:{ *:[i64] })<<P:Predicate_VectorIndexH>>:$idx)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UMOVvi16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // idx
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 8992,
        GIR_Done,
      // Label 476: @17837
      GIM_Try, /*On fail goto*//*Label 477*/ 17892, // Rule ID 10642 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (and:{ *:[i32] } (xor:{ *:[i32] } GPR32:{ *:[i32] }:$Rm, -1:{ *:[i32] }), GPR32:{ *:[i32] }:$Rn)  =>  (BICWrr:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, GPR32:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::BICWrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 10642,
        GIR_Done,
      // Label 477: @17892
      GIM_Try, /*On fail goto*//*Label 478*/ 17947, // Rule ID 162 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (and:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, (xor:{ *:[i32] } GPR32:{ *:[i32] }:$Rm, -1:{ *:[i32] }))  =>  (BICWrr:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, GPR32:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::BICWrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 162,
        GIR_Done,
      // Label 478: @17947
      GIM_Try, /*On fail goto*//*Label 479*/ 17989, // Rule ID 144 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckAPIntImmPredicate, /*MI*/1, /*Predicate*/GIPFP_APInt_Predicate_logical_imm32,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (and:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_logical_imm32>><<X:logical_imm32_XFORM>>:$imm)  =>  (ANDWri:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, (logical_imm32_XFORM:{ *:[i32] } (imm:{ *:[i32] }):$imm))
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::ANDWri,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_CustomRenderer, /*InsnID*/0, /*OldInsnID*/1, /*Renderer*/GICR_renderLogicalImm32, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 144,
        GIR_Done,
      // Label 479: @17989
      GIM_Try, /*On fail goto*//*Label 480*/ 18023, // Rule ID 10640 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_logical_shifted_reg32,
        // (and:{ *:[i32] } logical_shifted_reg32:{ *:[i32] }:$Rm_and_shift, GPR32:{ *:[i32] }:$Rn)  =>  (ANDWrs:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, logical_shifted_reg32:{ *:[i32] }:$Rm_and_shift)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::ANDWrs,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/0, // Rm_and_shift
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 10640,
        GIR_Done,
      // Label 480: @18023
      GIM_Try, /*On fail goto*//*Label 481*/ 18057, // Rule ID 160 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/0, GICP_gi_logical_shifted_reg32,
        // (and:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, logical_shifted_reg32:{ *:[i32] }:$Rm_and_shift)  =>  (ANDWrs:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, logical_shifted_reg32:{ *:[i32] }:$Rm_and_shift)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::ANDWrs,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/0, // Rm_and_shift
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 160,
        GIR_Done,
      // Label 481: @18057
      GIM_Try, /*On fail goto*//*Label 482*/ 18078, // Rule ID 158 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        // (and:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, GPR32:{ *:[i32] }:$Rm)  =>  (ANDWrr:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, GPR32:{ *:[i32] }:$Rm)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::ANDWrr,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 158,
        GIR_Done,
      // Label 482: @18078
      GIM_Reject,
    // Label 472: @18079
    GIM_Reject,
    // Label 458: @18080
    GIM_Try, /*On fail goto*//*Label 483*/ 19317,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_Try, /*On fail goto*//*Label 484*/ 18145, // Rule ID 10645 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/0, GICP_gi_logical_shifted_reg64,
        // (and:{ *:[i64] } (xor:{ *:[i64] } logical_shifted_reg64:{ *:[i64] }:$Rm_and_shift, -1:{ *:[i64] }), GPR64:{ *:[i64] }:$Rn)  =>  (BICXrs:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, logical_shifted_reg64:{ *:[i64] }:$Rm_and_shift)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::BICXrs,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/0, // Rm_and_shift
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 10645,
        GIR_Done,
      // Label 484: @18145
      GIM_Try, /*On fail goto*//*Label 485*/ 18200, // Rule ID 165 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/0, GICP_gi_logical_shifted_reg64,
        // (and:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, (xor:{ *:[i64] } logical_shifted_reg64:{ *:[i64] }:$Rm_and_shift, -1:{ *:[i64] }))  =>  (BICXrs:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, logical_shifted_reg64:{ *:[i64] }:$Rm_and_shift)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::BICXrs,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/0, // Rm_and_shift
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 165,
        GIR_Done,
      // Label 485: @18200
      GIM_Try, /*On fail goto*//*Label 486*/ 18303, // Rule ID 8993 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64allRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ANYEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_EXTRACT_VECTOR_ELT,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIPFP_I64_Predicate_VectorIndexB,
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, 255,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (and:{ *:[i64] } (anyext:{ *:[i64] } (vector_extract:{ *:[i32] } V128:{ *:[v16i8] }:$Rn, (imm:{ *:[i64] })<<P:Predicate_VectorIndexB>>:$idx)), 255:{ *:[i64] })  =>  (SUBREG_TO_REG:{ *:[i64] } 0:{ *:[i64] }, (UMOVvi8:{ *:[i32] } V128:{ *:[v16i8] }:$Rn, (imm:{ *:[i64] })<<P:Predicate_VectorIndexB>>:$idx), sub_32:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AArch64::UMOVvi8,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/2, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/1, /*OldInsnID*/3, // idx
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::SUBREG_TO_REG,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddImm, /*InsnID*/0, /*Imm*/15,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AArch64::GPR64allRegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/2, AArch64::GPR32RegClassID,
        // GIR_Coverage, 8993,
        GIR_Done,
      // Label 486: @18303
      GIM_Try, /*On fail goto*//*Label 487*/ 18406, // Rule ID 8994 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64allRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ANYEXT,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_EXTRACT_VECTOR_ELT,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIPFP_I64_Predicate_VectorIndexH,
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, 65535,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (and:{ *:[i64] } (anyext:{ *:[i64] } (vector_extract:{ *:[i32] } V128:{ *:[v8i16] }:$Rn, (imm:{ *:[i64] })<<P:Predicate_VectorIndexH>>:$idx)), 65535:{ *:[i64] })  =>  (SUBREG_TO_REG:{ *:[i64] } 0:{ *:[i64] }, (UMOVvi16:{ *:[i32] } V128:{ *:[v8i16] }:$Rn, (imm:{ *:[i64] })<<P:Predicate_VectorIndexH>>:$idx), sub_32:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AArch64::UMOVvi16,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/2, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/1, /*OldInsnID*/3, // idx
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::SUBREG_TO_REG,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddImm, /*InsnID*/0, /*Imm*/15,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AArch64::GPR64allRegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/2, AArch64::GPR32RegClassID,
        // GIR_Coverage, 8994,
        GIR_Done,
      // Label 487: @18406
      GIM_Try, /*On fail goto*//*Label 488*/ 18492, // Rule ID 10248 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64allRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC_W_SIDE_EFFECTS,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_ldxr,
        // MIs[1] addr
        GIM_CheckPointerToAny, /*MI*/1, /*Op*/2, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIPFP_MI_Predicate_ldxr_1,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, 255,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (and:{ *:[i64] } (intrinsic_w_chain:{ *:[i64] } 476:{ *:[iPTR] }, GPR64sp:{ *:[i64] }:$addr)<<P:Predicate_ldxr_1>>, 255:{ *:[i64] })  =>  (SUBREG_TO_REG:{ *:[i64] } 0:{ *:[i64] }, (LDXRB:{ *:[i32] } GPR64sp:{ *:[i64] }:$addr), sub_32:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AArch64::LDXRB,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // addr
        GIR_MergeMemOperands, /*InsnID*/1, /*MergeInsnID's*/0, 1, GIU_MergeMemOperands_EndOfList,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::SUBREG_TO_REG,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddImm, /*InsnID*/0, /*Imm*/15,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AArch64::GPR64allRegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/2, AArch64::GPR32RegClassID,
        // GIR_Coverage, 10248,
        GIR_Done,
      // Label 488: @18492
      GIM_Try, /*On fail goto*//*Label 489*/ 18578, // Rule ID 10249 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64allRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC_W_SIDE_EFFECTS,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_ldxr,
        // MIs[1] addr
        GIM_CheckPointerToAny, /*MI*/1, /*Op*/2, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIPFP_MI_Predicate_ldxr_2,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, 65535,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (and:{ *:[i64] } (intrinsic_w_chain:{ *:[i64] } 476:{ *:[iPTR] }, GPR64sp:{ *:[i64] }:$addr)<<P:Predicate_ldxr_2>>, 65535:{ *:[i64] })  =>  (SUBREG_TO_REG:{ *:[i64] } 0:{ *:[i64] }, (LDXRH:{ *:[i32] } GPR64sp:{ *:[i64] }:$addr), sub_32:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AArch64::LDXRH,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // addr
        GIR_MergeMemOperands, /*InsnID*/1, /*MergeInsnID's*/0, 1, GIU_MergeMemOperands_EndOfList,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::SUBREG_TO_REG,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddImm, /*InsnID*/0, /*Imm*/15,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AArch64::GPR64allRegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/2, AArch64::GPR32RegClassID,
        // GIR_Coverage, 10249,
        GIR_Done,
      // Label 489: @18578
      GIM_Try, /*On fail goto*//*Label 490*/ 18664, // Rule ID 10250 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64allRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC_W_SIDE_EFFECTS,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_ldxr,
        // MIs[1] addr
        GIM_CheckPointerToAny, /*MI*/1, /*Op*/2, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIPFP_MI_Predicate_ldxr_4,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, 4294967295,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (and:{ *:[i64] } (intrinsic_w_chain:{ *:[i64] } 476:{ *:[iPTR] }, GPR64sp:{ *:[i64] }:$addr)<<P:Predicate_ldxr_4>>, 4294967295:{ *:[i64] })  =>  (SUBREG_TO_REG:{ *:[i64] } 0:{ *:[i64] }, (LDXRW:{ *:[i32] } GPR64sp:{ *:[i64] }:$addr), sub_32:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AArch64::LDXRW,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // addr
        GIR_MergeMemOperands, /*InsnID*/1, /*MergeInsnID's*/0, 1, GIU_MergeMemOperands_EndOfList,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::SUBREG_TO_REG,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddImm, /*InsnID*/0, /*Imm*/15,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AArch64::GPR64allRegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/2, AArch64::GPR32RegClassID,
        // GIR_Coverage, 10250,
        GIR_Done,
      // Label 490: @18664
      GIM_Try, /*On fail goto*//*Label 491*/ 18750, // Rule ID 10255 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64allRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC_W_SIDE_EFFECTS,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_ldaxr,
        // MIs[1] addr
        GIM_CheckPointerToAny, /*MI*/1, /*Op*/2, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIPFP_MI_Predicate_ldaxr_1,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, 255,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (and:{ *:[i64] } (intrinsic_w_chain:{ *:[i64] } 473:{ *:[iPTR] }, GPR64sp:{ *:[i64] }:$addr)<<P:Predicate_ldaxr_1>>, 255:{ *:[i64] })  =>  (SUBREG_TO_REG:{ *:[i64] } 0:{ *:[i64] }, (LDAXRB:{ *:[i32] } GPR64sp:{ *:[i64] }:$addr), sub_32:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AArch64::LDAXRB,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // addr
        GIR_MergeMemOperands, /*InsnID*/1, /*MergeInsnID's*/0, 1, GIU_MergeMemOperands_EndOfList,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::SUBREG_TO_REG,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddImm, /*InsnID*/0, /*Imm*/15,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AArch64::GPR64allRegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/2, AArch64::GPR32RegClassID,
        // GIR_Coverage, 10255,
        GIR_Done,
      // Label 491: @18750
      GIM_Try, /*On fail goto*//*Label 492*/ 18836, // Rule ID 10256 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64allRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC_W_SIDE_EFFECTS,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_ldaxr,
        // MIs[1] addr
        GIM_CheckPointerToAny, /*MI*/1, /*Op*/2, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIPFP_MI_Predicate_ldaxr_2,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, 65535,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (and:{ *:[i64] } (intrinsic_w_chain:{ *:[i64] } 473:{ *:[iPTR] }, GPR64sp:{ *:[i64] }:$addr)<<P:Predicate_ldaxr_2>>, 65535:{ *:[i64] })  =>  (SUBREG_TO_REG:{ *:[i64] } 0:{ *:[i64] }, (LDAXRH:{ *:[i32] } GPR64sp:{ *:[i64] }:$addr), sub_32:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AArch64::LDAXRH,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // addr
        GIR_MergeMemOperands, /*InsnID*/1, /*MergeInsnID's*/0, 1, GIU_MergeMemOperands_EndOfList,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::SUBREG_TO_REG,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddImm, /*InsnID*/0, /*Imm*/15,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AArch64::GPR64allRegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/2, AArch64::GPR32RegClassID,
        // GIR_Coverage, 10256,
        GIR_Done,
      // Label 492: @18836
      GIM_Try, /*On fail goto*//*Label 493*/ 18922, // Rule ID 10257 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64allRegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC_W_SIDE_EFFECTS,
        GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
        GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_ldaxr,
        // MIs[1] addr
        GIM_CheckPointerToAny, /*MI*/1, /*Op*/2, /*SizeInBits*/64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIPFP_MI_Predicate_ldaxr_4,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, 4294967295,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (and:{ *:[i64] } (intrinsic_w_chain:{ *:[i64] } 473:{ *:[iPTR] }, GPR64sp:{ *:[i64] }:$addr)<<P:Predicate_ldaxr_4>>, 4294967295:{ *:[i64] })  =>  (SUBREG_TO_REG:{ *:[i64] } 0:{ *:[i64] }, (LDAXRW:{ *:[i32] } GPR64sp:{ *:[i64] }:$addr), sub_32:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/AArch64::LDAXRW,
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // addr
        GIR_MergeMemOperands, /*InsnID*/1, /*MergeInsnID's*/0, 1, GIU_MergeMemOperands_EndOfList,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::SUBREG_TO_REG,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_AddImm, /*InsnID*/0, /*Imm*/0,
        GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
        GIR_AddImm, /*InsnID*/0, /*Imm*/15,
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AArch64::GPR64allRegClassID,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/2, AArch64::GPR32RegClassID,
        // GIR_Coverage, 10257,
        GIR_Done,
      // Label 493: @18922
      GIM_Try, /*On fail goto*//*Label 494*/ 18977, // Rule ID 10643 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (and:{ *:[i64] } (xor:{ *:[i64] } GPR64:{ *:[i64] }:$Rm, -1:{ *:[i64] }), GPR64:{ *:[i64] }:$Rn)  =>  (BICXrr:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::BICXrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 10643,
        GIR_Done,
      // Label 494: @18977
      GIM_Try, /*On fail goto*//*Label 495*/ 19032, // Rule ID 163 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (and:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, (xor:{ *:[i64] } GPR64:{ *:[i64] }:$Rm, -1:{ *:[i64] }))  =>  (BICXrr:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::BICXrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 163,
        GIR_Done,
      // Label 495: @19032
      GIM_Try, /*On fail goto*//*Label 496*/ 19074, // Rule ID 145 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckAPIntImmPredicate, /*MI*/1, /*Predicate*/GIPFP_APInt_Predicate_logical_imm64,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (and:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, (imm:{ *:[i64] })<<P:Predicate_logical_imm64>><<X:logical_imm64_XFORM>>:$imm)  =>  (ANDXri:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, (logical_imm64_XFORM:{ *:[i64] } (imm:{ *:[i64] }):$imm))
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::ANDXri,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_CustomRenderer, /*InsnID*/0, /*OldInsnID*/1, /*Renderer*/GICR_renderLogicalImm64, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 145,
        GIR_Done,
      // Label 496: @19074
      GIM_Try, /*On fail goto*//*Label 497*/ 19108, // Rule ID 10641 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_logical_shifted_reg64,
        // (and:{ *:[i64] } logical_shifted_reg64:{ *:[i64] }:$Rm_and_shift, GPR64:{ *:[i64] }:$Rn)  =>  (ANDXrs:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, logical_shifted_reg64:{ *:[i64] }:$Rm_and_shift)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::ANDXrs,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/0, // Rm_and_shift
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 10641,
        GIR_Done,
      // Label 497: @19108
      GIM_Try, /*On fail goto*//*Label 498*/ 19142, // Rule ID 161 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/0, GICP_gi_logical_shifted_reg64,
        // (and:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, logical_shifted_reg64:{ *:[i64] }:$Rm_and_shift)  =>  (ANDXrs:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, logical_shifted_reg64:{ *:[i64] }:$Rm_and_shift)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::ANDXrs,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/0, // Rm_and_shift
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 161,
        GIR_Done,
      // Label 498: @19142
      GIM_Try, /*On fail goto*//*Label 499*/ 19207, // Rule ID 11759 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (and:{ *:[v1i64] } (xor:{ *:[v1i64] } V64:{ *:[v1i64] }:$RHS, immAllOnesV:{ *:[v1i64] }), V64:{ *:[v1i64] }:$LHS)  =>  (BICv8i8:{ *:[v1i64] } V64:{ *:[v1i64] }:$LHS, V64:{ *:[v1i64] }:$RHS)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::BICv8i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // LHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // RHS
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11759,
        GIR_Done,
      // Label 499: @19207
      GIM_Try, /*On fail goto*//*Label 500*/ 19272, // Rule ID 8643 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (and:{ *:[v1i64] } V64:{ *:[v1i64] }:$LHS, (xor:{ *:[v1i64] } V64:{ *:[v1i64] }:$RHS, immAllOnesV:{ *:[v1i64] }))  =>  (BICv8i8:{ *:[v1i64] } V64:{ *:[v1i64] }:$LHS, V64:{ *:[v1i64] }:$RHS)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::BICv8i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // LHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // RHS
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 8643,
        GIR_Done,
      // Label 500: @19272
      GIM_Try, /*On fail goto*//*Label 501*/ 19293, // Rule ID 159 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR64RegClassID,
        // (and:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm)  =>  (ANDXrr:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::ANDXrr,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 159,
        GIR_Done,
      // Label 501: @19293
      GIM_Try, /*On fail goto*//*Label 502*/ 19316, // Rule ID 6802 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        // (and:{ *:[v1i64] } V64:{ *:[v1i64] }:$LHS, V64:{ *:[v1i64] }:$RHS)  =>  (ANDv8i8:{ *:[v1i64] } V64:{ *:[v1i64] }:$LHS, V64:{ *:[v1i64] }:$RHS)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::ANDv8i8,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 6802,
        GIR_Done,
      // Label 502: @19316
      GIM_Reject,
    // Label 483: @19317
    GIM_Reject,
    // Label 459: @19318
    GIM_Try, /*On fail goto*//*Label 503*/ 19474,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_Try, /*On fail goto*//*Label 504*/ 19393, // Rule ID 11758 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (and:{ *:[v2i32] } (xor:{ *:[v2i32] } V64:{ *:[v2i32] }:$RHS, immAllOnesV:{ *:[v2i32] }), V64:{ *:[v2i32] }:$LHS)  =>  (BICv8i8:{ *:[v2i32] } V64:{ *:[v2i32] }:$LHS, V64:{ *:[v2i32] }:$RHS)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::BICv8i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // LHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // RHS
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11758,
        GIR_Done,
      // Label 504: @19393
      GIM_Try, /*On fail goto*//*Label 505*/ 19454, // Rule ID 8642 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (and:{ *:[v2i32] } V64:{ *:[v2i32] }:$LHS, (xor:{ *:[v2i32] } V64:{ *:[v2i32] }:$RHS, immAllOnesV:{ *:[v2i32] }))  =>  (BICv8i8:{ *:[v2i32] } V64:{ *:[v2i32] }:$LHS, V64:{ *:[v2i32] }:$RHS)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::BICv8i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // LHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // RHS
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 8642,
        GIR_Done,
      // Label 505: @19454
      GIM_Try, /*On fail goto*//*Label 506*/ 19473, // Rule ID 6801 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        // (and:{ *:[v2i32] } V64:{ *:[v2i32] }:$LHS, V64:{ *:[v2i32] }:$RHS)  =>  (ANDv8i8:{ *:[v2i32] } V64:{ *:[v2i32] }:$LHS, V64:{ *:[v2i32] }:$RHS)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::ANDv8i8,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 6801,
        GIR_Done,
      // Label 506: @19473
      GIM_Reject,
    // Label 503: @19474
    GIM_Reject,
    // Label 460: @19475
    GIM_Try, /*On fail goto*//*Label 507*/ 19631,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_Try, /*On fail goto*//*Label 508*/ 19550, // Rule ID 11762 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (and:{ *:[v2i64] } (xor:{ *:[v2i64] } V128:{ *:[v2i64] }:$RHS, immAllOnesV:{ *:[v2i64] }), V128:{ *:[v2i64] }:$LHS)  =>  (BICv16i8:{ *:[v2i64] } V128:{ *:[v2i64] }:$LHS, V128:{ *:[v2i64] }:$RHS)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::BICv16i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // LHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // RHS
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11762,
        GIR_Done,
      // Label 508: @19550
      GIM_Try, /*On fail goto*//*Label 509*/ 19611, // Rule ID 8646 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (and:{ *:[v2i64] } V128:{ *:[v2i64] }:$LHS, (xor:{ *:[v2i64] } V128:{ *:[v2i64] }:$RHS, immAllOnesV:{ *:[v2i64] }))  =>  (BICv16i8:{ *:[v2i64] } V128:{ *:[v2i64] }:$LHS, V128:{ *:[v2i64] }:$RHS)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::BICv16i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // LHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // RHS
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 8646,
        GIR_Done,
      // Label 509: @19611
      GIM_Try, /*On fail goto*//*Label 510*/ 19630, // Rule ID 6805 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        // (and:{ *:[v2i64] } V128:{ *:[v2i64] }:$LHS, V128:{ *:[v2i64] }:$RHS)  =>  (ANDv16i8:{ *:[v2i64] } V128:{ *:[v2i64] }:$LHS, V128:{ *:[v2i64] }:$RHS)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::ANDv16i8,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 6805,
        GIR_Done,
      // Label 510: @19630
      GIM_Reject,
    // Label 507: @19631
    GIM_Reject,
    // Label 461: @19632
    GIM_Try, /*On fail goto*//*Label 511*/ 19788,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_Try, /*On fail goto*//*Label 512*/ 19707, // Rule ID 11757 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (and:{ *:[v4i16] } (xor:{ *:[v4i16] } V64:{ *:[v4i16] }:$RHS, immAllOnesV:{ *:[v4i16] }), V64:{ *:[v4i16] }:$LHS)  =>  (BICv8i8:{ *:[v4i16] } V64:{ *:[v4i16] }:$LHS, V64:{ *:[v4i16] }:$RHS)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::BICv8i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // LHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // RHS
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11757,
        GIR_Done,
      // Label 512: @19707
      GIM_Try, /*On fail goto*//*Label 513*/ 19768, // Rule ID 8641 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (and:{ *:[v4i16] } V64:{ *:[v4i16] }:$LHS, (xor:{ *:[v4i16] } V64:{ *:[v4i16] }:$RHS, immAllOnesV:{ *:[v4i16] }))  =>  (BICv8i8:{ *:[v4i16] } V64:{ *:[v4i16] }:$LHS, V64:{ *:[v4i16] }:$RHS)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::BICv8i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // LHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // RHS
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 8641,
        GIR_Done,
      // Label 513: @19768
      GIM_Try, /*On fail goto*//*Label 514*/ 19787, // Rule ID 6800 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        // (and:{ *:[v4i16] } V64:{ *:[v4i16] }:$LHS, V64:{ *:[v4i16] }:$RHS)  =>  (ANDv8i8:{ *:[v4i16] } V64:{ *:[v4i16] }:$LHS, V64:{ *:[v4i16] }:$RHS)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::ANDv8i8,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 6800,
        GIR_Done,
      // Label 514: @19787
      GIM_Reject,
    // Label 511: @19788
    GIM_Reject,
    // Label 462: @19789
    GIM_Try, /*On fail goto*//*Label 515*/ 19945,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_Try, /*On fail goto*//*Label 516*/ 19864, // Rule ID 11761 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (and:{ *:[v4i32] } (xor:{ *:[v4i32] } V128:{ *:[v4i32] }:$RHS, immAllOnesV:{ *:[v4i32] }), V128:{ *:[v4i32] }:$LHS)  =>  (BICv16i8:{ *:[v4i32] } V128:{ *:[v4i32] }:$LHS, V128:{ *:[v4i32] }:$RHS)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::BICv16i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // LHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // RHS
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11761,
        GIR_Done,
      // Label 516: @19864
      GIM_Try, /*On fail goto*//*Label 517*/ 19925, // Rule ID 8645 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (and:{ *:[v4i32] } V128:{ *:[v4i32] }:$LHS, (xor:{ *:[v4i32] } V128:{ *:[v4i32] }:$RHS, immAllOnesV:{ *:[v4i32] }))  =>  (BICv16i8:{ *:[v4i32] } V128:{ *:[v4i32] }:$LHS, V128:{ *:[v4i32] }:$RHS)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::BICv16i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // LHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // RHS
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 8645,
        GIR_Done,
      // Label 517: @19925
      GIM_Try, /*On fail goto*//*Label 518*/ 19944, // Rule ID 6804 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        // (and:{ *:[v4i32] } V128:{ *:[v4i32] }:$LHS, V128:{ *:[v4i32] }:$RHS)  =>  (ANDv16i8:{ *:[v4i32] } V128:{ *:[v4i32] }:$LHS, V128:{ *:[v4i32] }:$RHS)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::ANDv16i8,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 6804,
        GIR_Done,
      // Label 518: @19944
      GIM_Reject,
    // Label 515: @19945
    GIM_Reject,
    // Label 463: @19946
    GIM_Try, /*On fail goto*//*Label 519*/ 20102,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_Try, /*On fail goto*//*Label 520*/ 20021, // Rule ID 10756 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (and:{ *:[v8i8] } (xor:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rm, immAllOnesV:{ *:[v8i8] }), V64:{ *:[v8i8] }:$Rn)  =>  (BICv8i8:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::BICv8i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 10756,
        GIR_Done,
      // Label 520: @20021
      GIM_Try, /*On fail goto*//*Label 521*/ 20082, // Rule ID 1560 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (and:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rn, (xor:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rm, immAllOnesV:{ *:[v8i8] }))  =>  (BICv8i8:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::BICv8i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1560,
        GIR_Done,
      // Label 521: @20082
      GIM_Try, /*On fail goto*//*Label 522*/ 20101, // Rule ID 1558 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        // (and:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm)  =>  (ANDv8i8:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::ANDv8i8,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1558,
        GIR_Done,
      // Label 522: @20101
      GIM_Reject,
    // Label 519: @20102
    GIM_Reject,
    // Label 464: @20103
    GIM_Try, /*On fail goto*//*Label 523*/ 20259,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_Try, /*On fail goto*//*Label 524*/ 20178, // Rule ID 11760 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (and:{ *:[v8i16] } (xor:{ *:[v8i16] } V128:{ *:[v8i16] }:$RHS, immAllOnesV:{ *:[v8i16] }), V128:{ *:[v8i16] }:$LHS)  =>  (BICv16i8:{ *:[v8i16] } V128:{ *:[v8i16] }:$LHS, V128:{ *:[v8i16] }:$RHS)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::BICv16i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // LHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // RHS
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11760,
        GIR_Done,
      // Label 524: @20178
      GIM_Try, /*On fail goto*//*Label 525*/ 20239, // Rule ID 8644 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (and:{ *:[v8i16] } V128:{ *:[v8i16] }:$LHS, (xor:{ *:[v8i16] } V128:{ *:[v8i16] }:$RHS, immAllOnesV:{ *:[v8i16] }))  =>  (BICv16i8:{ *:[v8i16] } V128:{ *:[v8i16] }:$LHS, V128:{ *:[v8i16] }:$RHS)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::BICv16i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // LHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // RHS
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 8644,
        GIR_Done,
      // Label 525: @20239
      GIM_Try, /*On fail goto*//*Label 526*/ 20258, // Rule ID 6803 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        // (and:{ *:[v8i16] } V128:{ *:[v8i16] }:$LHS, V128:{ *:[v8i16] }:$RHS)  =>  (ANDv16i8:{ *:[v8i16] } V128:{ *:[v8i16] }:$LHS, V128:{ *:[v8i16] }:$RHS)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::ANDv16i8,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 6803,
        GIR_Done,
      // Label 526: @20258
      GIM_Reject,
    // Label 523: @20259
    GIM_Reject,
    // Label 465: @20260
    GIM_Try, /*On fail goto*//*Label 527*/ 20416,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_Try, /*On fail goto*//*Label 528*/ 20335, // Rule ID 10757 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (and:{ *:[v16i8] } (xor:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rm, immAllOnesV:{ *:[v16i8] }), V128:{ *:[v16i8] }:$Rn)  =>  (BICv16i8:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rn, V128:{ *:[v16i8] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::BICv16i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 10757,
        GIR_Done,
      // Label 528: @20335
      GIM_Try, /*On fail goto*//*Label 529*/ 20396, // Rule ID 1561 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (and:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rn, (xor:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rm, immAllOnesV:{ *:[v16i8] }))  =>  (BICv16i8:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rn, V128:{ *:[v16i8] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::BICv16i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1561,
        GIR_Done,
      // Label 529: @20396
      GIM_Try, /*On fail goto*//*Label 530*/ 20415, // Rule ID 1559 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        // (and:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rn, V128:{ *:[v16i8] }:$Rm)  =>  (ANDv16i8:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rn, V128:{ *:[v16i8] }:$Rm)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::ANDv16i8,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1559,
        GIR_Done,
      // Label 530: @20415
      GIM_Reject,
    // Label 527: @20416
    GIM_Reject,
    // Label 466: @20417
    GIM_Try, /*On fail goto*//*Label 531*/ 20480, // Rule ID 5200 //
      GIM_CheckFeatures, GIFBS_HasSVEorSME,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv1s1,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv1s1,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::PPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::PPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::PPRRegClassID,
      // (and:{ *:[nxv1i1] } PPR:{ *:[nxv1i1] }:$Ps1, PPR:{ *:[nxv1i1] }:$Ps2)  =>  (AND_PPzPP:{ *:[nxv1i1] } (PTRUE_D:{ *:[nxv1i1] } 31:{ *:[i32] }), PPR:{ *:[nxv1i1] }:$Ps1, PPR:{ *:[nxv1i1] }:$Ps2)
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s1,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/AArch64::PTRUE_D,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
      GIR_AddImm, /*InsnID*/1, /*Imm*/31,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::AND_PPzPP,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Pd
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Ps1
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Ps2
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 5200,
      GIR_Done,
    // Label 531: @20480
    GIM_Reject,
    // Label 467: @20481
    GIM_Try, /*On fail goto*//*Label 532*/ 20544, // Rule ID 5199 //
      GIM_CheckFeatures, GIFBS_HasSVEorSME,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv2s1,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv2s1,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::PPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::PPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::PPRRegClassID,
      // (and:{ *:[nxv2i1] } PPR:{ *:[nxv2i1] }:$Ps1, PPR:{ *:[nxv2i1] }:$Ps2)  =>  (AND_PPzPP:{ *:[nxv2i1] } (PTRUE_D:{ *:[nxv1i1] } 31:{ *:[i32] }), PPR:{ *:[nxv2i1] }:$Ps1, PPR:{ *:[nxv2i1] }:$Ps2)
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s1,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/AArch64::PTRUE_D,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
      GIR_AddImm, /*InsnID*/1, /*Imm*/31,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::AND_PPzPP,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Pd
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Ps1
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Ps2
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 5199,
      GIR_Done,
    // Label 532: @20544
    GIM_Reject,
    // Label 468: @20545
    GIM_Try, /*On fail goto*//*Label 533*/ 20608, // Rule ID 5198 //
      GIM_CheckFeatures, GIFBS_HasSVEorSME,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv4s1,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv4s1,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::PPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::PPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::PPRRegClassID,
      // (and:{ *:[nxv4i1] } PPR:{ *:[nxv4i1] }:$Ps1, PPR:{ *:[nxv4i1] }:$Ps2)  =>  (AND_PPzPP:{ *:[nxv4i1] } (PTRUE_S:{ *:[nxv1i1] } 31:{ *:[i32] }), PPR:{ *:[nxv4i1] }:$Ps1, PPR:{ *:[nxv4i1] }:$Ps2)
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s1,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/AArch64::PTRUE_S,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
      GIR_AddImm, /*InsnID*/1, /*Imm*/31,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::AND_PPzPP,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Pd
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Ps1
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Ps2
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 5198,
      GIR_Done,
    // Label 533: @20608
    GIM_Reject,
    // Label 469: @20609
    GIM_Try, /*On fail goto*//*Label 534*/ 20672, // Rule ID 5197 //
      GIM_CheckFeatures, GIFBS_HasSVEorSME,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv8s1,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv8s1,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::PPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::PPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::PPRRegClassID,
      // (and:{ *:[nxv8i1] } PPR:{ *:[nxv8i1] }:$Ps1, PPR:{ *:[nxv8i1] }:$Ps2)  =>  (AND_PPzPP:{ *:[nxv8i1] } (PTRUE_H:{ *:[nxv1i1] } 31:{ *:[i32] }), PPR:{ *:[nxv8i1] }:$Ps1, PPR:{ *:[nxv8i1] }:$Ps2)
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s1,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/AArch64::PTRUE_H,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
      GIR_AddImm, /*InsnID*/1, /*Imm*/31,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::AND_PPzPP,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Pd
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Ps1
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Ps2
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 5197,
      GIR_Done,
    // Label 534: @20672
    GIM_Reject,
    // Label 470: @20673
    GIM_Try, /*On fail goto*//*Label 535*/ 20736, // Rule ID 5196 //
      GIM_CheckFeatures, GIFBS_HasSVEorSME,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv16s1,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv16s1,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::PPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::PPRRegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::PPRRegClassID,
      // (and:{ *:[nxv16i1] } PPR:{ *:[nxv16i1] }:$Ps1, PPR:{ *:[nxv16i1] }:$Ps2)  =>  (AND_PPzPP:{ *:[nxv16i1] } (PTRUE_B:{ *:[nxv1i1] } 31:{ *:[i32] }), PPR:{ *:[nxv16i1] }:$Ps1, PPR:{ *:[nxv16i1] }:$Ps2)
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s1,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/AArch64::PTRUE_B,
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
      GIR_AddImm, /*InsnID*/1, /*Imm*/31,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::AND_PPzPP,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Pd
      GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Ps1
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Ps2
      GIR_EraseFromParent, /*InsnID*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 5196,
      GIR_Done,
    // Label 535: @20736
    GIM_Reject,
    // Label 471: @20737
    GIM_Reject,
    // Label 6: @20738
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/1, 11, /*)*//*default:*//*Label 545*/ 32334,
    /*GILLT_s32*//*Label 536*/ 20754,
    /*GILLT_s64*//*Label 537*/ 21117, 0,
    /*GILLT_v2s32*//*Label 538*/ 23255,
    /*GILLT_v2s64*//*Label 539*/ 24552,
    /*GILLT_v4s16*//*Label 540*/ 25849,
    /*GILLT_v4s32*//*Label 541*/ 27146,
    /*GILLT_v8s8*//*Label 542*/ 28443,
    /*GILLT_v8s16*//*Label 543*/ 29740,
    /*GILLT_v16s8*//*Label 544*/ 31037,
    // Label 536: @20754
    GIM_Try, /*On fail goto*//*Label 546*/ 21116,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 547*/ 20819, // Rule ID 10664 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/0, GICP_gi_logical_shifted_reg32,
        // (or:{ *:[i32] } (xor:{ *:[i32] } logical_shifted_reg32:{ *:[i32] }:$Rm_and_shift, -1:{ *:[i32] }), GPR32:{ *:[i32] }:$Rn)  =>  (ORNWrs:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, logical_shifted_reg32:{ *:[i32] }:$Rm_and_shift)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::ORNWrs,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/0, // Rm_and_shift
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 10664,
        GIR_Done,
      // Label 547: @20819
      GIM_Try, /*On fail goto*//*Label 548*/ 20874, // Rule ID 176 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/0, GICP_gi_logical_shifted_reg32,
        // (or:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, (xor:{ *:[i32] } logical_shifted_reg32:{ *:[i32] }:$Rm_and_shift, -1:{ *:[i32] }))  =>  (ORNWrs:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, logical_shifted_reg32:{ *:[i32] }:$Rm_and_shift)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::ORNWrs,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/0, // Rm_and_shift
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 176,
        GIR_Done,
      // Label 548: @20874
      GIM_Try, /*On fail goto*//*Label 549*/ 20916, // Rule ID 148 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckAPIntImmPredicate, /*MI*/1, /*Predicate*/GIPFP_APInt_Predicate_logical_imm32,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (or:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_logical_imm32>><<X:logical_imm32_XFORM>>:$imm)  =>  (ORRWri:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, (logical_imm32_XFORM:{ *:[i32] } (imm:{ *:[i32] }):$imm))
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::ORRWri,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_CustomRenderer, /*InsnID*/0, /*OldInsnID*/1, /*Renderer*/GICR_renderLogicalImm32, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 148,
        GIR_Done,
      // Label 549: @20916
      GIM_Try, /*On fail goto*//*Label 550*/ 20950, // Rule ID 10666 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_logical_shifted_reg32,
        // (or:{ *:[i32] } logical_shifted_reg32:{ *:[i32] }:$Rm_and_shift, GPR32:{ *:[i32] }:$Rn)  =>  (ORRWrs:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, logical_shifted_reg32:{ *:[i32] }:$Rm_and_shift)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::ORRWrs,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/0, // Rm_and_shift
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 10666,
        GIR_Done,
      // Label 550: @20950
      GIM_Try, /*On fail goto*//*Label 551*/ 20984, // Rule ID 180 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/0, GICP_gi_logical_shifted_reg32,
        // (or:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, logical_shifted_reg32:{ *:[i32] }:$Rm_and_shift)  =>  (ORRWrs:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, logical_shifted_reg32:{ *:[i32] }:$Rm_and_shift)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::ORRWrs,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/0, // Rm_and_shift
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 180,
        GIR_Done,
      // Label 551: @20984
      GIM_Try, /*On fail goto*//*Label 552*/ 21039, // Rule ID 10662 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (or:{ *:[i32] } (xor:{ *:[i32] } GPR32:{ *:[i32] }:$Rm, -1:{ *:[i32] }), GPR32:{ *:[i32] }:$Rn)  =>  (ORNWrr:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, GPR32:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::ORNWrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 10662,
        GIR_Done,
      // Label 552: @21039
      GIM_Try, /*On fail goto*//*Label 553*/ 21094, // Rule ID 174 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (or:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, (xor:{ *:[i32] } GPR32:{ *:[i32] }:$Rm, -1:{ *:[i32] }))  =>  (ORNWrr:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, GPR32:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::ORNWrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 174,
        GIR_Done,
      // Label 553: @21094
      GIM_Try, /*On fail goto*//*Label 554*/ 21115, // Rule ID 178 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        // (or:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, GPR32:{ *:[i32] }:$Rm)  =>  (ORRWrr:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, GPR32:{ *:[i32] }:$Rm)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::ORRWrr,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 178,
        GIR_Done,
      // Label 554: @21115
      GIM_Reject,
    // Label 546: @21116
    GIM_Reject,
    // Label 537: @21117
    GIM_Try, /*On fail goto*//*Label 555*/ 23254,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_Try, /*On fail goto*//*Label 556*/ 21238, // Rule ID 7976 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_LSHR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckConstantInt, /*MI*/2, /*Op*/2, 8,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, 71777214294589695,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, TargetOpcode::G_SHL,
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s64,
        // MIs[4] Rn
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckConstantInt, /*MI*/4, /*Op*/2, 8,
        GIM_CheckConstantInt, /*MI*/3, /*Op*/2, -71777214294589696,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        // (or:{ *:[i64] } (and:{ *:[i64] } (srl:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, 8:{ *:[i64] }), 71777214294589695:{ *:[i64] }), (and:{ *:[i64] } (shl:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, 8:{ *:[i64] }), -71777214294589696:{ *:[i64] }))  =>  (REV16Xr:{ *:[i64] } GPR64:{ *:[i64] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::REV16Xr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rn
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 7976,
        GIR_Done,
      // Label 556: @21238
      GIM_Try, /*On fail goto*//*Label 557*/ 21349, // Rule ID 11683 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_SHL,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckConstantInt, /*MI*/2, /*Op*/2, 8,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -71777214294589696,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, TargetOpcode::G_LSHR,
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s64,
        // MIs[4] Rn
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckConstantInt, /*MI*/4, /*Op*/2, 8,
        GIM_CheckConstantInt, /*MI*/3, /*Op*/2, 71777214294589695,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        // (or:{ *:[i64] } (and:{ *:[i64] } (shl:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, 8:{ *:[i64] }), -71777214294589696:{ *:[i64] }), (and:{ *:[i64] } (srl:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, 8:{ *:[i64] }), 71777214294589695:{ *:[i64] }))  =>  (REV16Xr:{ *:[i64] } GPR64:{ *:[i64] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::REV16Xr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rn
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11683,
        GIR_Done,
      // Label 557: @21349
      GIM_Try, /*On fail goto*//*Label 558*/ 21404, // Rule ID 10665 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/0, GICP_gi_logical_shifted_reg64,
        // (or:{ *:[i64] } (xor:{ *:[i64] } logical_shifted_reg64:{ *:[i64] }:$Rm_and_shift, -1:{ *:[i64] }), GPR64:{ *:[i64] }:$Rn)  =>  (ORNXrs:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, logical_shifted_reg64:{ *:[i64] }:$Rm_and_shift)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::ORNXrs,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/0, // Rm_and_shift
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 10665,
        GIR_Done,
      // Label 558: @21404
      GIM_Try, /*On fail goto*//*Label 559*/ 21459, // Rule ID 177 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/0, GICP_gi_logical_shifted_reg64,
        // (or:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, (xor:{ *:[i64] } logical_shifted_reg64:{ *:[i64] }:$Rm_and_shift, -1:{ *:[i64] }))  =>  (ORNXrs:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, logical_shifted_reg64:{ *:[i64] }:$Rm_and_shift)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::ORNXrs,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/0, // Rm_and_shift
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 177,
        GIR_Done,
      // Label 559: @21459
      GIM_Try, /*On fail goto*//*Label 560*/ 21567, // Rule ID 11505 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcodeIsEither, /*MI*/3, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/3,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/4, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        // MIs[4] LHS
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        // (or:{ *:[v1i64] } (and:{ *:[v1i64] } (xor:{ *:[v1i64] } V64:{ *:[v1i64] }:$LHS, immAllOnesV:{ *:[v1i64] }), V64:{ *:[v1i64] }:$RHS), (and:{ *:[v1i64] } V64:{ *:[v1i64] }:$MHS, V64:{ *:[v1i64] }:$LHS))  =>  (BSPv8i8:{ *:[v1i64] } V64:{ *:[v1i64] }:$LHS, V64:{ *:[v1i64] }:$MHS, V64:{ *:[v1i64] }:$RHS)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::BSPv8i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // LHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/1, // MHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // RHS
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11505,
        GIR_Done,
      // Label 560: @21567
      GIM_Try, /*On fail goto*//*Label 561*/ 21675, // Rule ID 11504 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcodeIsEither, /*MI*/3, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/3,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s64,
        // MIs[4] LHS
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckRegBankForClass, /*MI*/4, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        // (or:{ *:[v1i64] } (and:{ *:[v1i64] } (xor:{ *:[v1i64] } V64:{ *:[v1i64] }:$LHS, immAllOnesV:{ *:[v1i64] }), V64:{ *:[v1i64] }:$RHS), (and:{ *:[v1i64] } V64:{ *:[v1i64] }:$LHS, V64:{ *:[v1i64] }:$MHS))  =>  (BSPv8i8:{ *:[v1i64] } V64:{ *:[v1i64] }:$LHS, V64:{ *:[v1i64] }:$MHS, V64:{ *:[v1i64] }:$RHS)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::BSPv8i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // LHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/2, // MHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // RHS
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11504,
        GIR_Done,
      // Label 561: @21675
      GIM_Try, /*On fail goto*//*Label 562*/ 21783, // Rule ID 11507 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcodeIsEither, /*MI*/3, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/3,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/4, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        // MIs[4] LHS
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        // (or:{ *:[v1i64] } (and:{ *:[v1i64] } V64:{ *:[v1i64] }:$RHS, (xor:{ *:[v1i64] } V64:{ *:[v1i64] }:$LHS, immAllOnesV:{ *:[v1i64] })), (and:{ *:[v1i64] } V64:{ *:[v1i64] }:$MHS, V64:{ *:[v1i64] }:$LHS))  =>  (BSPv8i8:{ *:[v1i64] } V64:{ *:[v1i64] }:$LHS, V64:{ *:[v1i64] }:$MHS, V64:{ *:[v1i64] }:$RHS)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::BSPv8i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // LHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/1, // MHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // RHS
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11507,
        GIR_Done,
      // Label 562: @21783
      GIM_Try, /*On fail goto*//*Label 563*/ 21891, // Rule ID 11506 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcodeIsEither, /*MI*/3, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/3,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s64,
        // MIs[4] LHS
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckRegBankForClass, /*MI*/4, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        // (or:{ *:[v1i64] } (and:{ *:[v1i64] } V64:{ *:[v1i64] }:$RHS, (xor:{ *:[v1i64] } V64:{ *:[v1i64] }:$LHS, immAllOnesV:{ *:[v1i64] })), (and:{ *:[v1i64] } V64:{ *:[v1i64] }:$LHS, V64:{ *:[v1i64] }:$MHS))  =>  (BSPv8i8:{ *:[v1i64] } V64:{ *:[v1i64] }:$LHS, V64:{ *:[v1i64] }:$MHS, V64:{ *:[v1i64] }:$RHS)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::BSPv8i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // LHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/2, // MHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // RHS
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11506,
        GIR_Done,
      // Label 563: @21891
      GIM_Try, /*On fail goto*//*Label 564*/ 21999, // Rule ID 6789 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s64,
        // MIs[3] LHS
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        // (or:{ *:[v1i64] } (and:{ *:[v1i64] } V64:{ *:[v1i64] }:$LHS, V64:{ *:[v1i64] }:$MHS), (and:{ *:[v1i64] } (xor:{ *:[v1i64] } V64:{ *:[v1i64] }:$LHS, immAllOnesV:{ *:[v1i64] }), V64:{ *:[v1i64] }:$RHS))  =>  (BSPv8i8:{ *:[v1i64] } V64:{ *:[v1i64] }:$LHS, V64:{ *:[v1i64] }:$MHS, V64:{ *:[v1i64] }:$RHS)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::BSPv8i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // LHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // MHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // RHS
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 6789,
        GIR_Done,
      // Label 564: @21999
      GIM_Try, /*On fail goto*//*Label 565*/ 22107, // Rule ID 11502 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s64,
        // MIs[3] LHS
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/2,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        // (or:{ *:[v1i64] } (and:{ *:[v1i64] } V64:{ *:[v1i64] }:$MHS, V64:{ *:[v1i64] }:$LHS), (and:{ *:[v1i64] } (xor:{ *:[v1i64] } V64:{ *:[v1i64] }:$LHS, immAllOnesV:{ *:[v1i64] }), V64:{ *:[v1i64] }:$RHS))  =>  (BSPv8i8:{ *:[v1i64] } V64:{ *:[v1i64] }:$LHS, V64:{ *:[v1i64] }:$MHS, V64:{ *:[v1i64] }:$RHS)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::BSPv8i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // LHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // MHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // RHS
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11502,
        GIR_Done,
      // Label 565: @22107
      GIM_Try, /*On fail goto*//*Label 566*/ 22215, // Rule ID 11501 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s64,
        // MIs[3] LHS
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        // (or:{ *:[v1i64] } (and:{ *:[v1i64] } V64:{ *:[v1i64] }:$LHS, V64:{ *:[v1i64] }:$MHS), (and:{ *:[v1i64] } V64:{ *:[v1i64] }:$RHS, (xor:{ *:[v1i64] } V64:{ *:[v1i64] }:$LHS, immAllOnesV:{ *:[v1i64] })))  =>  (BSPv8i8:{ *:[v1i64] } V64:{ *:[v1i64] }:$LHS, V64:{ *:[v1i64] }:$MHS, V64:{ *:[v1i64] }:$RHS)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::BSPv8i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // LHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // MHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // RHS
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11501,
        GIR_Done,
      // Label 566: @22215
      GIM_Try, /*On fail goto*//*Label 567*/ 22323, // Rule ID 11503 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s64,
        // MIs[3] LHS
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/2,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        // (or:{ *:[v1i64] } (and:{ *:[v1i64] } V64:{ *:[v1i64] }:$MHS, V64:{ *:[v1i64] }:$LHS), (and:{ *:[v1i64] } V64:{ *:[v1i64] }:$RHS, (xor:{ *:[v1i64] } V64:{ *:[v1i64] }:$LHS, immAllOnesV:{ *:[v1i64] })))  =>  (BSPv8i8:{ *:[v1i64] } V64:{ *:[v1i64] }:$LHS, V64:{ *:[v1i64] }:$MHS, V64:{ *:[v1i64] }:$RHS)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::BSPv8i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // LHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // MHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // RHS
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11503,
        GIR_Done,
      // Label 567: @22323
      GIM_Try, /*On fail goto*//*Label 568*/ 22365, // Rule ID 149 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckAPIntImmPredicate, /*MI*/1, /*Predicate*/GIPFP_APInt_Predicate_logical_imm64,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (or:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, (imm:{ *:[i64] })<<P:Predicate_logical_imm64>><<X:logical_imm64_XFORM>>:$imm)  =>  (ORRXri:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, (logical_imm64_XFORM:{ *:[i64] } (imm:{ *:[i64] }):$imm))
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::ORRXri,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_CustomRenderer, /*InsnID*/0, /*OldInsnID*/1, /*Renderer*/GICR_renderLogicalImm64, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 149,
        GIR_Done,
      // Label 568: @22365
      GIM_Try, /*On fail goto*//*Label 569*/ 22399, // Rule ID 10667 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_logical_shifted_reg64,
        // (or:{ *:[i64] } logical_shifted_reg64:{ *:[i64] }:$Rm_and_shift, GPR64:{ *:[i64] }:$Rn)  =>  (ORRXrs:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, logical_shifted_reg64:{ *:[i64] }:$Rm_and_shift)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::ORRXrs,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/0, // Rm_and_shift
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 10667,
        GIR_Done,
      // Label 569: @22399
      GIM_Try, /*On fail goto*//*Label 570*/ 22433, // Rule ID 181 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/0, GICP_gi_logical_shifted_reg64,
        // (or:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, logical_shifted_reg64:{ *:[i64] }:$Rm_and_shift)  =>  (ORRXrs:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, logical_shifted_reg64:{ *:[i64] }:$Rm_and_shift)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::ORRXrs,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/0, // Rm_and_shift
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 181,
        GIR_Done,
      // Label 570: @22433
      GIM_Try, /*On fail goto*//*Label 571*/ 22500, // Rule ID 10898 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, AArch64::G_VASHR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        // MIs[1] imm
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIPFP_I64_Predicate_vecshiftR64,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_add_and_or_is_add,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (or:{ *:[i64] } (AArch64vashr:{ *:[i64] } FPR64:{ *:[i64] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR64>>:$imm), FPR64:{ *:[i64] }:$Rd)<<P:Predicate_add_and_or_is_add>>  =>  (SSRAd:{ *:[i64] } FPR64:{ *:[i64] }:$Rd, FPR64:{ *:[i64] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SSRAd,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 10898,
        GIR_Done,
      // Label 571: @22500
      GIM_Try, /*On fail goto*//*Label 572*/ 22567, // Rule ID 11783 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, AArch64::G_VASHR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        // MIs[1] imm
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIPFP_I64_Predicate_vecshiftR64,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_add_and_or_is_add,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (or:{ *:[v1i64] } (AArch64vashr:{ *:[v1i64] } FPR64:{ *:[v1i64] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR64>>:$imm), FPR64:{ *:[v1i64] }:$Rd)<<P:Predicate_add_and_or_is_add>>  =>  (SSRAd:{ *:[v1i64] } FPR64:{ *:[v1i64] }:$Rd, FPR64:{ *:[v1i64] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR64>>:$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SSRAd,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11783,
        GIR_Done,
      // Label 572: @22567
      GIM_Try, /*On fail goto*//*Label 573*/ 22634, // Rule ID 10901 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, AArch64::G_VLSHR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        // MIs[1] imm
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIPFP_I64_Predicate_vecshiftR64,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_add_and_or_is_add,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (or:{ *:[i64] } (AArch64vlshr:{ *:[i64] } FPR64:{ *:[i64] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR64>>:$imm), FPR64:{ *:[i64] }:$Rd)<<P:Predicate_add_and_or_is_add>>  =>  (USRAd:{ *:[i64] } FPR64:{ *:[i64] }:$Rd, FPR64:{ *:[i64] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::USRAd,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 10901,
        GIR_Done,
      // Label 573: @22634
      GIM_Try, /*On fail goto*//*Label 574*/ 22701, // Rule ID 11786 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, AArch64::G_VLSHR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        // MIs[1] imm
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIPFP_I64_Predicate_vecshiftR64,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_add_and_or_is_add,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (or:{ *:[v1i64] } (AArch64vlshr:{ *:[v1i64] } FPR64:{ *:[v1i64] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR64>>:$imm), FPR64:{ *:[v1i64] }:$Rd)<<P:Predicate_add_and_or_is_add>>  =>  (USRAd:{ *:[v1i64] } FPR64:{ *:[v1i64] }:$Rd, FPR64:{ *:[v1i64] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR64>>:$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::USRAd,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11786,
        GIR_Done,
      // Label 574: @22701
      GIM_Try, /*On fail goto*//*Label 575*/ 22756, // Rule ID 10663 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (or:{ *:[i64] } (xor:{ *:[i64] } GPR64:{ *:[i64] }:$Rm, -1:{ *:[i64] }), GPR64:{ *:[i64] }:$Rn)  =>  (ORNXrr:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::ORNXrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 10663,
        GIR_Done,
      // Label 575: @22756
      GIM_Try, /*On fail goto*//*Label 576*/ 22823, // Rule ID 2038 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, AArch64::G_VASHR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        // MIs[1] imm
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIPFP_I64_Predicate_vecshiftR64,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_add_and_or_is_add,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (or:{ *:[i64] } FPR64:{ *:[i64] }:$Rd, (AArch64vashr:{ *:[i64] } FPR64:{ *:[i64] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR64>>:$imm))<<P:Predicate_add_and_or_is_add>>  =>  (SSRAd:{ *:[i64] } FPR64:{ *:[i64] }:$Rd, FPR64:{ *:[i64] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SSRAd,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2038,
        GIR_Done,
      // Label 576: @22823
      GIM_Try, /*On fail goto*//*Label 577*/ 22890, // Rule ID 9439 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, AArch64::G_VASHR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        // MIs[1] imm
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIPFP_I64_Predicate_vecshiftR64,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_add_and_or_is_add,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (or:{ *:[v1i64] } FPR64:{ *:[v1i64] }:$Rd, (AArch64vashr:{ *:[v1i64] } FPR64:{ *:[v1i64] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR64>>:$imm))<<P:Predicate_add_and_or_is_add>>  =>  (SSRAd:{ *:[v1i64] } FPR64:{ *:[v1i64] }:$Rd, FPR64:{ *:[v1i64] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR64>>:$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SSRAd,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 9439,
        GIR_Done,
      // Label 577: @22890
      GIM_Try, /*On fail goto*//*Label 578*/ 22957, // Rule ID 2047 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, AArch64::G_VLSHR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        // MIs[1] imm
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIPFP_I64_Predicate_vecshiftR64,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_add_and_or_is_add,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (or:{ *:[i64] } FPR64:{ *:[i64] }:$Rd, (AArch64vlshr:{ *:[i64] } FPR64:{ *:[i64] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR64>>:$imm))<<P:Predicate_add_and_or_is_add>>  =>  (USRAd:{ *:[i64] } FPR64:{ *:[i64] }:$Rd, FPR64:{ *:[i64] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::USRAd,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2047,
        GIR_Done,
      // Label 578: @22957
      GIM_Try, /*On fail goto*//*Label 579*/ 23024, // Rule ID 9445 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, AArch64::G_VLSHR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        // MIs[1] imm
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIPFP_I64_Predicate_vecshiftR64,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_add_and_or_is_add,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (or:{ *:[v1i64] } FPR64:{ *:[v1i64] }:$Rd, (AArch64vlshr:{ *:[v1i64] } FPR64:{ *:[v1i64] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR64>>:$imm))<<P:Predicate_add_and_or_is_add>>  =>  (USRAd:{ *:[v1i64] } FPR64:{ *:[v1i64] }:$Rd, FPR64:{ *:[v1i64] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR64>>:$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::USRAd,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 9445,
        GIR_Done,
      // Label 579: @23024
      GIM_Try, /*On fail goto*//*Label 580*/ 23079, // Rule ID 175 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (or:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, (xor:{ *:[i64] } GPR64:{ *:[i64] }:$Rm, -1:{ *:[i64] }))  =>  (ORNXrr:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::ORNXrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 175,
        GIR_Done,
      // Label 580: @23079
      GIM_Try, /*On fail goto*//*Label 581*/ 23144, // Rule ID 11765 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (or:{ *:[v1i64] } (xor:{ *:[v1i64] } V64:{ *:[v1i64] }:$RHS, immAllOnesV:{ *:[v1i64] }), V64:{ *:[v1i64] }:$LHS)  =>  (ORNv8i8:{ *:[v1i64] } V64:{ *:[v1i64] }:$LHS, V64:{ *:[v1i64] }:$RHS)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::ORNv8i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // LHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // RHS
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11765,
        GIR_Done,
      // Label 581: @23144
      GIM_Try, /*On fail goto*//*Label 582*/ 23209, // Rule ID 8655 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (or:{ *:[v1i64] } V64:{ *:[v1i64] }:$LHS, (xor:{ *:[v1i64] } V64:{ *:[v1i64] }:$RHS, immAllOnesV:{ *:[v1i64] }))  =>  (ORNv8i8:{ *:[v1i64] } V64:{ *:[v1i64] }:$LHS, V64:{ *:[v1i64] }:$RHS)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::ORNv8i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // LHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // RHS
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 8655,
        GIR_Done,
      // Label 582: @23209
      GIM_Try, /*On fail goto*//*Label 583*/ 23230, // Rule ID 179 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR64RegClassID,
        // (or:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm)  =>  (ORRXrr:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::ORRXrr,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 179,
        GIR_Done,
      // Label 583: @23230
      GIM_Try, /*On fail goto*//*Label 584*/ 23253, // Rule ID 8661 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        // (or:{ *:[v1i64] } V64:{ *:[v1i64] }:$LHS, V64:{ *:[v1i64] }:$RHS)  =>  (ORRv8i8:{ *:[v1i64] } V64:{ *:[v1i64] }:$LHS, V64:{ *:[v1i64] }:$RHS)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::ORRv8i8,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 8661,
        GIR_Done,
      // Label 584: @23253
      GIM_Reject,
    // Label 555: @23254
    GIM_Reject,
    // Label 538: @23255
    GIM_Try, /*On fail goto*//*Label 585*/ 24551,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s32,
      GIM_Try, /*On fail goto*//*Label 586*/ 23373, // Rule ID 11498 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcodeIsEither, /*MI*/3, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/3,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/4, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        // MIs[4] LHS
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        // (or:{ *:[v2i32] } (and:{ *:[v2i32] } (xor:{ *:[v2i32] } V64:{ *:[v2i32] }:$LHS, immAllOnesV:{ *:[v2i32] }), V64:{ *:[v2i32] }:$RHS), (and:{ *:[v2i32] } V64:{ *:[v2i32] }:$MHS, V64:{ *:[v2i32] }:$LHS))  =>  (BSPv8i8:{ *:[v2i32] } V64:{ *:[v2i32] }:$LHS, V64:{ *:[v2i32] }:$MHS, V64:{ *:[v2i32] }:$RHS)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::BSPv8i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // LHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/1, // MHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // RHS
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11498,
        GIR_Done,
      // Label 586: @23373
      GIM_Try, /*On fail goto*//*Label 587*/ 23481, // Rule ID 11497 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcodeIsEither, /*MI*/3, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/3,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_v2s32,
        // MIs[4] LHS
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckRegBankForClass, /*MI*/4, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        // (or:{ *:[v2i32] } (and:{ *:[v2i32] } (xor:{ *:[v2i32] } V64:{ *:[v2i32] }:$LHS, immAllOnesV:{ *:[v2i32] }), V64:{ *:[v2i32] }:$RHS), (and:{ *:[v2i32] } V64:{ *:[v2i32] }:$LHS, V64:{ *:[v2i32] }:$MHS))  =>  (BSPv8i8:{ *:[v2i32] } V64:{ *:[v2i32] }:$LHS, V64:{ *:[v2i32] }:$MHS, V64:{ *:[v2i32] }:$RHS)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::BSPv8i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // LHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/2, // MHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // RHS
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11497,
        GIR_Done,
      // Label 587: @23481
      GIM_Try, /*On fail goto*//*Label 588*/ 23589, // Rule ID 11500 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcodeIsEither, /*MI*/3, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/3,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/4, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        // MIs[4] LHS
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        // (or:{ *:[v2i32] } (and:{ *:[v2i32] } V64:{ *:[v2i32] }:$RHS, (xor:{ *:[v2i32] } V64:{ *:[v2i32] }:$LHS, immAllOnesV:{ *:[v2i32] })), (and:{ *:[v2i32] } V64:{ *:[v2i32] }:$MHS, V64:{ *:[v2i32] }:$LHS))  =>  (BSPv8i8:{ *:[v2i32] } V64:{ *:[v2i32] }:$LHS, V64:{ *:[v2i32] }:$MHS, V64:{ *:[v2i32] }:$RHS)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::BSPv8i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // LHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/1, // MHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // RHS
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11500,
        GIR_Done,
      // Label 588: @23589
      GIM_Try, /*On fail goto*//*Label 589*/ 23697, // Rule ID 11499 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcodeIsEither, /*MI*/3, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/3,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_v2s32,
        // MIs[4] LHS
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckRegBankForClass, /*MI*/4, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        // (or:{ *:[v2i32] } (and:{ *:[v2i32] } V64:{ *:[v2i32] }:$RHS, (xor:{ *:[v2i32] } V64:{ *:[v2i32] }:$LHS, immAllOnesV:{ *:[v2i32] })), (and:{ *:[v2i32] } V64:{ *:[v2i32] }:$LHS, V64:{ *:[v2i32] }:$MHS))  =>  (BSPv8i8:{ *:[v2i32] } V64:{ *:[v2i32] }:$LHS, V64:{ *:[v2i32] }:$MHS, V64:{ *:[v2i32] }:$RHS)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::BSPv8i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // LHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/2, // MHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // RHS
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11499,
        GIR_Done,
      // Label 589: @23697
      GIM_Try, /*On fail goto*//*Label 590*/ 23805, // Rule ID 6788 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v2s32,
        // MIs[3] LHS
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        // (or:{ *:[v2i32] } (and:{ *:[v2i32] } V64:{ *:[v2i32] }:$LHS, V64:{ *:[v2i32] }:$MHS), (and:{ *:[v2i32] } (xor:{ *:[v2i32] } V64:{ *:[v2i32] }:$LHS, immAllOnesV:{ *:[v2i32] }), V64:{ *:[v2i32] }:$RHS))  =>  (BSPv8i8:{ *:[v2i32] } V64:{ *:[v2i32] }:$LHS, V64:{ *:[v2i32] }:$MHS, V64:{ *:[v2i32] }:$RHS)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::BSPv8i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // LHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // MHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // RHS
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 6788,
        GIR_Done,
      // Label 590: @23805
      GIM_Try, /*On fail goto*//*Label 591*/ 23913, // Rule ID 11495 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v2s32,
        // MIs[3] LHS
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/2,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        // (or:{ *:[v2i32] } (and:{ *:[v2i32] } V64:{ *:[v2i32] }:$MHS, V64:{ *:[v2i32] }:$LHS), (and:{ *:[v2i32] } (xor:{ *:[v2i32] } V64:{ *:[v2i32] }:$LHS, immAllOnesV:{ *:[v2i32] }), V64:{ *:[v2i32] }:$RHS))  =>  (BSPv8i8:{ *:[v2i32] } V64:{ *:[v2i32] }:$LHS, V64:{ *:[v2i32] }:$MHS, V64:{ *:[v2i32] }:$RHS)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::BSPv8i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // LHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // MHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // RHS
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11495,
        GIR_Done,
      // Label 591: @23913
      GIM_Try, /*On fail goto*//*Label 592*/ 24021, // Rule ID 11494 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v2s32,
        // MIs[3] LHS
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        // (or:{ *:[v2i32] } (and:{ *:[v2i32] } V64:{ *:[v2i32] }:$LHS, V64:{ *:[v2i32] }:$MHS), (and:{ *:[v2i32] } V64:{ *:[v2i32] }:$RHS, (xor:{ *:[v2i32] } V64:{ *:[v2i32] }:$LHS, immAllOnesV:{ *:[v2i32] })))  =>  (BSPv8i8:{ *:[v2i32] } V64:{ *:[v2i32] }:$LHS, V64:{ *:[v2i32] }:$MHS, V64:{ *:[v2i32] }:$RHS)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::BSPv8i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // LHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // MHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // RHS
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11494,
        GIR_Done,
      // Label 592: @24021
      GIM_Try, /*On fail goto*//*Label 593*/ 24129, // Rule ID 11496 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v2s32,
        // MIs[3] LHS
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/2,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        // (or:{ *:[v2i32] } (and:{ *:[v2i32] } V64:{ *:[v2i32] }:$MHS, V64:{ *:[v2i32] }:$LHS), (and:{ *:[v2i32] } V64:{ *:[v2i32] }:$RHS, (xor:{ *:[v2i32] } V64:{ *:[v2i32] }:$LHS, immAllOnesV:{ *:[v2i32] })))  =>  (BSPv8i8:{ *:[v2i32] } V64:{ *:[v2i32] }:$LHS, V64:{ *:[v2i32] }:$MHS, V64:{ *:[v2i32] }:$RHS)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::BSPv8i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // LHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // MHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // RHS
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11496,
        GIR_Done,
      // Label 593: @24129
      GIM_Try, /*On fail goto*//*Label 594*/ 24196, // Rule ID 10918 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, AArch64::G_VASHR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        // MIs[1] imm
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIPFP_I64_Predicate_vecshiftR32,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_add_and_or_is_add,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (or:{ *:[v2i32] } (AArch64vashr:{ *:[v2i32] } V64:{ *:[v2i32] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR32>>:$imm), V64:{ *:[v2i32] }:$Rd)<<P:Predicate_add_and_or_is_add>>  =>  (SSRAv2i32_shift:{ *:[v2i32] } V64:{ *:[v2i32] }:$Rd, V64:{ *:[v2i32] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SSRAv2i32_shift,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 10918,
        GIR_Done,
      // Label 594: @24196
      GIM_Try, /*On fail goto*//*Label 595*/ 24263, // Rule ID 10939 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, AArch64::G_VLSHR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        // MIs[1] imm
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIPFP_I64_Predicate_vecshiftR32,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_add_and_or_is_add,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (or:{ *:[v2i32] } (AArch64vlshr:{ *:[v2i32] } V64:{ *:[v2i32] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR32>>:$imm), V64:{ *:[v2i32] }:$Rd)<<P:Predicate_add_and_or_is_add>>  =>  (USRAv2i32_shift:{ *:[v2i32] } V64:{ *:[v2i32] }:$Rd, V64:{ *:[v2i32] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::USRAv2i32_shift,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 10939,
        GIR_Done,
      // Label 595: @24263
      GIM_Try, /*On fail goto*//*Label 596*/ 24330, // Rule ID 2152 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, AArch64::G_VASHR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        // MIs[1] imm
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIPFP_I64_Predicate_vecshiftR32,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_add_and_or_is_add,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (or:{ *:[v2i32] } V64:{ *:[v2i32] }:$Rd, (AArch64vashr:{ *:[v2i32] } V64:{ *:[v2i32] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR32>>:$imm))<<P:Predicate_add_and_or_is_add>>  =>  (SSRAv2i32_shift:{ *:[v2i32] } V64:{ *:[v2i32] }:$Rd, V64:{ *:[v2i32] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SSRAv2i32_shift,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2152,
        GIR_Done,
      // Label 596: @24330
      GIM_Try, /*On fail goto*//*Label 597*/ 24397, // Rule ID 2211 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, AArch64::G_VLSHR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        // MIs[1] imm
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIPFP_I64_Predicate_vecshiftR32,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_add_and_or_is_add,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (or:{ *:[v2i32] } V64:{ *:[v2i32] }:$Rd, (AArch64vlshr:{ *:[v2i32] } V64:{ *:[v2i32] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR32>>:$imm))<<P:Predicate_add_and_or_is_add>>  =>  (USRAv2i32_shift:{ *:[v2i32] } V64:{ *:[v2i32] }:$Rd, V64:{ *:[v2i32] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::USRAv2i32_shift,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2211,
        GIR_Done,
      // Label 597: @24397
      GIM_Try, /*On fail goto*//*Label 598*/ 24462, // Rule ID 11764 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (or:{ *:[v2i32] } (xor:{ *:[v2i32] } V64:{ *:[v2i32] }:$RHS, immAllOnesV:{ *:[v2i32] }), V64:{ *:[v2i32] }:$LHS)  =>  (ORNv8i8:{ *:[v2i32] } V64:{ *:[v2i32] }:$LHS, V64:{ *:[v2i32] }:$RHS)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::ORNv8i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // LHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // RHS
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11764,
        GIR_Done,
      // Label 598: @24462
      GIM_Try, /*On fail goto*//*Label 599*/ 24527, // Rule ID 8654 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (or:{ *:[v2i32] } V64:{ *:[v2i32] }:$LHS, (xor:{ *:[v2i32] } V64:{ *:[v2i32] }:$RHS, immAllOnesV:{ *:[v2i32] }))  =>  (ORNv8i8:{ *:[v2i32] } V64:{ *:[v2i32] }:$LHS, V64:{ *:[v2i32] }:$RHS)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::ORNv8i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // LHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // RHS
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 8654,
        GIR_Done,
      // Label 599: @24527
      GIM_Try, /*On fail goto*//*Label 600*/ 24550, // Rule ID 8660 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        // (or:{ *:[v2i32] } V64:{ *:[v2i32] }:$LHS, V64:{ *:[v2i32] }:$RHS)  =>  (ORRv8i8:{ *:[v2i32] } V64:{ *:[v2i32] }:$LHS, V64:{ *:[v2i32] }:$RHS)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::ORRv8i8,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 8660,
        GIR_Done,
      // Label 600: @24550
      GIM_Reject,
    // Label 585: @24551
    GIM_Reject,
    // Label 539: @24552
    GIM_Try, /*On fail goto*//*Label 601*/ 25848,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
      GIM_Try, /*On fail goto*//*Label 602*/ 24670, // Rule ID 11526 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcodeIsEither, /*MI*/3, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/3,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/4, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        // MIs[4] LHS
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        // (or:{ *:[v2i64] } (and:{ *:[v2i64] } (xor:{ *:[v2i64] } V128:{ *:[v2i64] }:$LHS, immAllOnesV:{ *:[v2i64] }), V128:{ *:[v2i64] }:$RHS), (and:{ *:[v2i64] } V128:{ *:[v2i64] }:$MHS, V128:{ *:[v2i64] }:$LHS))  =>  (BSPv16i8:{ *:[v2i64] } V128:{ *:[v2i64] }:$LHS, V128:{ *:[v2i64] }:$MHS, V128:{ *:[v2i64] }:$RHS)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::BSPv16i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // LHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/1, // MHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // RHS
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11526,
        GIR_Done,
      // Label 602: @24670
      GIM_Try, /*On fail goto*//*Label 603*/ 24778, // Rule ID 11525 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcodeIsEither, /*MI*/3, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/3,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_v2s64,
        // MIs[4] LHS
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckRegBankForClass, /*MI*/4, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        // (or:{ *:[v2i64] } (and:{ *:[v2i64] } (xor:{ *:[v2i64] } V128:{ *:[v2i64] }:$LHS, immAllOnesV:{ *:[v2i64] }), V128:{ *:[v2i64] }:$RHS), (and:{ *:[v2i64] } V128:{ *:[v2i64] }:$LHS, V128:{ *:[v2i64] }:$MHS))  =>  (BSPv16i8:{ *:[v2i64] } V128:{ *:[v2i64] }:$LHS, V128:{ *:[v2i64] }:$MHS, V128:{ *:[v2i64] }:$RHS)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::BSPv16i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // LHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/2, // MHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // RHS
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11525,
        GIR_Done,
      // Label 603: @24778
      GIM_Try, /*On fail goto*//*Label 604*/ 24886, // Rule ID 11528 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcodeIsEither, /*MI*/3, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/3,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/4, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        // MIs[4] LHS
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        // (or:{ *:[v2i64] } (and:{ *:[v2i64] } V128:{ *:[v2i64] }:$RHS, (xor:{ *:[v2i64] } V128:{ *:[v2i64] }:$LHS, immAllOnesV:{ *:[v2i64] })), (and:{ *:[v2i64] } V128:{ *:[v2i64] }:$MHS, V128:{ *:[v2i64] }:$LHS))  =>  (BSPv16i8:{ *:[v2i64] } V128:{ *:[v2i64] }:$LHS, V128:{ *:[v2i64] }:$MHS, V128:{ *:[v2i64] }:$RHS)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::BSPv16i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // LHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/1, // MHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // RHS
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11528,
        GIR_Done,
      // Label 604: @24886
      GIM_Try, /*On fail goto*//*Label 605*/ 24994, // Rule ID 11527 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcodeIsEither, /*MI*/3, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/3,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_v2s64,
        // MIs[4] LHS
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckRegBankForClass, /*MI*/4, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        // (or:{ *:[v2i64] } (and:{ *:[v2i64] } V128:{ *:[v2i64] }:$RHS, (xor:{ *:[v2i64] } V128:{ *:[v2i64] }:$LHS, immAllOnesV:{ *:[v2i64] })), (and:{ *:[v2i64] } V128:{ *:[v2i64] }:$LHS, V128:{ *:[v2i64] }:$MHS))  =>  (BSPv16i8:{ *:[v2i64] } V128:{ *:[v2i64] }:$LHS, V128:{ *:[v2i64] }:$MHS, V128:{ *:[v2i64] }:$RHS)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::BSPv16i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // LHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/2, // MHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // RHS
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11527,
        GIR_Done,
      // Label 605: @24994
      GIM_Try, /*On fail goto*//*Label 606*/ 25102, // Rule ID 6792 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v2s64,
        // MIs[3] LHS
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        // (or:{ *:[v2i64] } (and:{ *:[v2i64] } V128:{ *:[v2i64] }:$LHS, V128:{ *:[v2i64] }:$MHS), (and:{ *:[v2i64] } (xor:{ *:[v2i64] } V128:{ *:[v2i64] }:$LHS, immAllOnesV:{ *:[v2i64] }), V128:{ *:[v2i64] }:$RHS))  =>  (BSPv16i8:{ *:[v2i64] } V128:{ *:[v2i64] }:$LHS, V128:{ *:[v2i64] }:$MHS, V128:{ *:[v2i64] }:$RHS)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::BSPv16i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // LHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // MHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // RHS
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 6792,
        GIR_Done,
      // Label 606: @25102
      GIM_Try, /*On fail goto*//*Label 607*/ 25210, // Rule ID 11523 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v2s64,
        // MIs[3] LHS
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/2,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        // (or:{ *:[v2i64] } (and:{ *:[v2i64] } V128:{ *:[v2i64] }:$MHS, V128:{ *:[v2i64] }:$LHS), (and:{ *:[v2i64] } (xor:{ *:[v2i64] } V128:{ *:[v2i64] }:$LHS, immAllOnesV:{ *:[v2i64] }), V128:{ *:[v2i64] }:$RHS))  =>  (BSPv16i8:{ *:[v2i64] } V128:{ *:[v2i64] }:$LHS, V128:{ *:[v2i64] }:$MHS, V128:{ *:[v2i64] }:$RHS)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::BSPv16i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // LHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // MHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // RHS
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11523,
        GIR_Done,
      // Label 607: @25210
      GIM_Try, /*On fail goto*//*Label 608*/ 25318, // Rule ID 11522 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v2s64,
        // MIs[3] LHS
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        // (or:{ *:[v2i64] } (and:{ *:[v2i64] } V128:{ *:[v2i64] }:$LHS, V128:{ *:[v2i64] }:$MHS), (and:{ *:[v2i64] } V128:{ *:[v2i64] }:$RHS, (xor:{ *:[v2i64] } V128:{ *:[v2i64] }:$LHS, immAllOnesV:{ *:[v2i64] })))  =>  (BSPv16i8:{ *:[v2i64] } V128:{ *:[v2i64] }:$LHS, V128:{ *:[v2i64] }:$MHS, V128:{ *:[v2i64] }:$RHS)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::BSPv16i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // LHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // MHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // RHS
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11522,
        GIR_Done,
      // Label 608: @25318
      GIM_Try, /*On fail goto*//*Label 609*/ 25426, // Rule ID 11524 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v2s64,
        // MIs[3] LHS
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/2,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        // (or:{ *:[v2i64] } (and:{ *:[v2i64] } V128:{ *:[v2i64] }:$MHS, V128:{ *:[v2i64] }:$LHS), (and:{ *:[v2i64] } V128:{ *:[v2i64] }:$RHS, (xor:{ *:[v2i64] } V128:{ *:[v2i64] }:$LHS, immAllOnesV:{ *:[v2i64] })))  =>  (BSPv16i8:{ *:[v2i64] } V128:{ *:[v2i64] }:$LHS, V128:{ *:[v2i64] }:$MHS, V128:{ *:[v2i64] }:$RHS)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::BSPv16i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // LHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // MHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // RHS
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11524,
        GIR_Done,
      // Label 609: @25426
      GIM_Try, /*On fail goto*//*Label 610*/ 25493, // Rule ID 10922 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, AArch64::G_VASHR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        // MIs[1] imm
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIPFP_I64_Predicate_vecshiftR64,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_add_and_or_is_add,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (or:{ *:[v2i64] } (AArch64vashr:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR64>>:$imm), V128:{ *:[v2i64] }:$Rd)<<P:Predicate_add_and_or_is_add>>  =>  (SSRAv2i64_shift:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, V128:{ *:[v2i64] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SSRAv2i64_shift,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 10922,
        GIR_Done,
      // Label 610: @25493
      GIM_Try, /*On fail goto*//*Label 611*/ 25560, // Rule ID 10943 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, AArch64::G_VLSHR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        // MIs[1] imm
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIPFP_I64_Predicate_vecshiftR64,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_add_and_or_is_add,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (or:{ *:[v2i64] } (AArch64vlshr:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR64>>:$imm), V128:{ *:[v2i64] }:$Rd)<<P:Predicate_add_and_or_is_add>>  =>  (USRAv2i64_shift:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, V128:{ *:[v2i64] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::USRAv2i64_shift,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 10943,
        GIR_Done,
      // Label 611: @25560
      GIM_Try, /*On fail goto*//*Label 612*/ 25627, // Rule ID 2156 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, AArch64::G_VASHR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        // MIs[1] imm
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIPFP_I64_Predicate_vecshiftR64,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_add_and_or_is_add,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (or:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, (AArch64vashr:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR64>>:$imm))<<P:Predicate_add_and_or_is_add>>  =>  (SSRAv2i64_shift:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, V128:{ *:[v2i64] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SSRAv2i64_shift,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2156,
        GIR_Done,
      // Label 612: @25627
      GIM_Try, /*On fail goto*//*Label 613*/ 25694, // Rule ID 2215 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, AArch64::G_VLSHR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        // MIs[1] imm
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIPFP_I64_Predicate_vecshiftR64,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_add_and_or_is_add,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (or:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, (AArch64vlshr:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR64>>:$imm))<<P:Predicate_add_and_or_is_add>>  =>  (USRAv2i64_shift:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, V128:{ *:[v2i64] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::USRAv2i64_shift,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2215,
        GIR_Done,
      // Label 613: @25694
      GIM_Try, /*On fail goto*//*Label 614*/ 25759, // Rule ID 11768 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (or:{ *:[v2i64] } (xor:{ *:[v2i64] } V128:{ *:[v2i64] }:$RHS, immAllOnesV:{ *:[v2i64] }), V128:{ *:[v2i64] }:$LHS)  =>  (ORNv16i8:{ *:[v2i64] } V128:{ *:[v2i64] }:$LHS, V128:{ *:[v2i64] }:$RHS)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::ORNv16i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // LHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // RHS
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11768,
        GIR_Done,
      // Label 614: @25759
      GIM_Try, /*On fail goto*//*Label 615*/ 25824, // Rule ID 8658 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (or:{ *:[v2i64] } V128:{ *:[v2i64] }:$LHS, (xor:{ *:[v2i64] } V128:{ *:[v2i64] }:$RHS, immAllOnesV:{ *:[v2i64] }))  =>  (ORNv16i8:{ *:[v2i64] } V128:{ *:[v2i64] }:$LHS, V128:{ *:[v2i64] }:$RHS)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::ORNv16i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // LHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // RHS
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 8658,
        GIR_Done,
      // Label 615: @25824
      GIM_Try, /*On fail goto*//*Label 616*/ 25847, // Rule ID 8664 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        // (or:{ *:[v2i64] } V128:{ *:[v2i64] }:$LHS, V128:{ *:[v2i64] }:$RHS)  =>  (ORRv16i8:{ *:[v2i64] } V128:{ *:[v2i64] }:$LHS, V128:{ *:[v2i64] }:$RHS)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::ORRv16i8,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 8664,
        GIR_Done,
      // Label 616: @25847
      GIM_Reject,
    // Label 601: @25848
    GIM_Reject,
    // Label 540: @25849
    GIM_Try, /*On fail goto*//*Label 617*/ 27145,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s16,
      GIM_Try, /*On fail goto*//*Label 618*/ 25967, // Rule ID 11491 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcodeIsEither, /*MI*/3, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/3,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/4, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        // MIs[4] LHS
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        // (or:{ *:[v4i16] } (and:{ *:[v4i16] } (xor:{ *:[v4i16] } V64:{ *:[v4i16] }:$LHS, immAllOnesV:{ *:[v4i16] }), V64:{ *:[v4i16] }:$RHS), (and:{ *:[v4i16] } V64:{ *:[v4i16] }:$MHS, V64:{ *:[v4i16] }:$LHS))  =>  (BSPv8i8:{ *:[v4i16] } V64:{ *:[v4i16] }:$LHS, V64:{ *:[v4i16] }:$MHS, V64:{ *:[v4i16] }:$RHS)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::BSPv8i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // LHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/1, // MHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // RHS
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11491,
        GIR_Done,
      // Label 618: @25967
      GIM_Try, /*On fail goto*//*Label 619*/ 26075, // Rule ID 11490 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcodeIsEither, /*MI*/3, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/3,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_v4s16,
        // MIs[4] LHS
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckRegBankForClass, /*MI*/4, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        // (or:{ *:[v4i16] } (and:{ *:[v4i16] } (xor:{ *:[v4i16] } V64:{ *:[v4i16] }:$LHS, immAllOnesV:{ *:[v4i16] }), V64:{ *:[v4i16] }:$RHS), (and:{ *:[v4i16] } V64:{ *:[v4i16] }:$LHS, V64:{ *:[v4i16] }:$MHS))  =>  (BSPv8i8:{ *:[v4i16] } V64:{ *:[v4i16] }:$LHS, V64:{ *:[v4i16] }:$MHS, V64:{ *:[v4i16] }:$RHS)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::BSPv8i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // LHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/2, // MHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // RHS
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11490,
        GIR_Done,
      // Label 619: @26075
      GIM_Try, /*On fail goto*//*Label 620*/ 26183, // Rule ID 11493 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcodeIsEither, /*MI*/3, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/3,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/4, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        // MIs[4] LHS
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        // (or:{ *:[v4i16] } (and:{ *:[v4i16] } V64:{ *:[v4i16] }:$RHS, (xor:{ *:[v4i16] } V64:{ *:[v4i16] }:$LHS, immAllOnesV:{ *:[v4i16] })), (and:{ *:[v4i16] } V64:{ *:[v4i16] }:$MHS, V64:{ *:[v4i16] }:$LHS))  =>  (BSPv8i8:{ *:[v4i16] } V64:{ *:[v4i16] }:$LHS, V64:{ *:[v4i16] }:$MHS, V64:{ *:[v4i16] }:$RHS)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::BSPv8i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // LHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/1, // MHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // RHS
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11493,
        GIR_Done,
      // Label 620: @26183
      GIM_Try, /*On fail goto*//*Label 621*/ 26291, // Rule ID 11492 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcodeIsEither, /*MI*/3, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/3,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_v4s16,
        // MIs[4] LHS
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckRegBankForClass, /*MI*/4, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        // (or:{ *:[v4i16] } (and:{ *:[v4i16] } V64:{ *:[v4i16] }:$RHS, (xor:{ *:[v4i16] } V64:{ *:[v4i16] }:$LHS, immAllOnesV:{ *:[v4i16] })), (and:{ *:[v4i16] } V64:{ *:[v4i16] }:$LHS, V64:{ *:[v4i16] }:$MHS))  =>  (BSPv8i8:{ *:[v4i16] } V64:{ *:[v4i16] }:$LHS, V64:{ *:[v4i16] }:$MHS, V64:{ *:[v4i16] }:$RHS)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::BSPv8i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // LHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/2, // MHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // RHS
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11492,
        GIR_Done,
      // Label 621: @26291
      GIM_Try, /*On fail goto*//*Label 622*/ 26399, // Rule ID 6787 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s16,
        // MIs[3] LHS
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        // (or:{ *:[v4i16] } (and:{ *:[v4i16] } V64:{ *:[v4i16] }:$LHS, V64:{ *:[v4i16] }:$MHS), (and:{ *:[v4i16] } (xor:{ *:[v4i16] } V64:{ *:[v4i16] }:$LHS, immAllOnesV:{ *:[v4i16] }), V64:{ *:[v4i16] }:$RHS))  =>  (BSPv8i8:{ *:[v4i16] } V64:{ *:[v4i16] }:$LHS, V64:{ *:[v4i16] }:$MHS, V64:{ *:[v4i16] }:$RHS)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::BSPv8i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // LHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // MHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // RHS
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 6787,
        GIR_Done,
      // Label 622: @26399
      GIM_Try, /*On fail goto*//*Label 623*/ 26507, // Rule ID 11488 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s16,
        // MIs[3] LHS
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/2,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        // (or:{ *:[v4i16] } (and:{ *:[v4i16] } V64:{ *:[v4i16] }:$MHS, V64:{ *:[v4i16] }:$LHS), (and:{ *:[v4i16] } (xor:{ *:[v4i16] } V64:{ *:[v4i16] }:$LHS, immAllOnesV:{ *:[v4i16] }), V64:{ *:[v4i16] }:$RHS))  =>  (BSPv8i8:{ *:[v4i16] } V64:{ *:[v4i16] }:$LHS, V64:{ *:[v4i16] }:$MHS, V64:{ *:[v4i16] }:$RHS)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::BSPv8i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // LHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // MHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // RHS
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11488,
        GIR_Done,
      // Label 623: @26507
      GIM_Try, /*On fail goto*//*Label 624*/ 26615, // Rule ID 11487 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s16,
        // MIs[3] LHS
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        // (or:{ *:[v4i16] } (and:{ *:[v4i16] } V64:{ *:[v4i16] }:$LHS, V64:{ *:[v4i16] }:$MHS), (and:{ *:[v4i16] } V64:{ *:[v4i16] }:$RHS, (xor:{ *:[v4i16] } V64:{ *:[v4i16] }:$LHS, immAllOnesV:{ *:[v4i16] })))  =>  (BSPv8i8:{ *:[v4i16] } V64:{ *:[v4i16] }:$LHS, V64:{ *:[v4i16] }:$MHS, V64:{ *:[v4i16] }:$RHS)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::BSPv8i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // LHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // MHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // RHS
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11487,
        GIR_Done,
      // Label 624: @26615
      GIM_Try, /*On fail goto*//*Label 625*/ 26723, // Rule ID 11489 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s16,
        // MIs[3] LHS
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/2,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        // (or:{ *:[v4i16] } (and:{ *:[v4i16] } V64:{ *:[v4i16] }:$MHS, V64:{ *:[v4i16] }:$LHS), (and:{ *:[v4i16] } V64:{ *:[v4i16] }:$RHS, (xor:{ *:[v4i16] } V64:{ *:[v4i16] }:$LHS, immAllOnesV:{ *:[v4i16] })))  =>  (BSPv8i8:{ *:[v4i16] } V64:{ *:[v4i16] }:$LHS, V64:{ *:[v4i16] }:$MHS, V64:{ *:[v4i16] }:$RHS)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::BSPv8i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // LHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // MHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // RHS
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11489,
        GIR_Done,
      // Label 625: @26723
      GIM_Try, /*On fail goto*//*Label 626*/ 26790, // Rule ID 10914 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, AArch64::G_VASHR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        // MIs[1] imm
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIPFP_I64_Predicate_vecshiftR16,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_add_and_or_is_add,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (or:{ *:[v4i16] } (AArch64vashr:{ *:[v4i16] } V64:{ *:[v4i16] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR16>>:$imm), V64:{ *:[v4i16] }:$Rd)<<P:Predicate_add_and_or_is_add>>  =>  (SSRAv4i16_shift:{ *:[v4i16] } V64:{ *:[v4i16] }:$Rd, V64:{ *:[v4i16] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SSRAv4i16_shift,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 10914,
        GIR_Done,
      // Label 626: @26790
      GIM_Try, /*On fail goto*//*Label 627*/ 26857, // Rule ID 10935 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, AArch64::G_VLSHR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        // MIs[1] imm
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIPFP_I64_Predicate_vecshiftR16,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_add_and_or_is_add,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (or:{ *:[v4i16] } (AArch64vlshr:{ *:[v4i16] } V64:{ *:[v4i16] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR16>>:$imm), V64:{ *:[v4i16] }:$Rd)<<P:Predicate_add_and_or_is_add>>  =>  (USRAv4i16_shift:{ *:[v4i16] } V64:{ *:[v4i16] }:$Rd, V64:{ *:[v4i16] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::USRAv4i16_shift,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 10935,
        GIR_Done,
      // Label 627: @26857
      GIM_Try, /*On fail goto*//*Label 628*/ 26924, // Rule ID 2148 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, AArch64::G_VASHR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        // MIs[1] imm
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIPFP_I64_Predicate_vecshiftR16,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_add_and_or_is_add,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (or:{ *:[v4i16] } V64:{ *:[v4i16] }:$Rd, (AArch64vashr:{ *:[v4i16] } V64:{ *:[v4i16] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR16>>:$imm))<<P:Predicate_add_and_or_is_add>>  =>  (SSRAv4i16_shift:{ *:[v4i16] } V64:{ *:[v4i16] }:$Rd, V64:{ *:[v4i16] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SSRAv4i16_shift,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2148,
        GIR_Done,
      // Label 628: @26924
      GIM_Try, /*On fail goto*//*Label 629*/ 26991, // Rule ID 2207 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, AArch64::G_VLSHR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        // MIs[1] imm
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIPFP_I64_Predicate_vecshiftR16,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_add_and_or_is_add,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (or:{ *:[v4i16] } V64:{ *:[v4i16] }:$Rd, (AArch64vlshr:{ *:[v4i16] } V64:{ *:[v4i16] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR16>>:$imm))<<P:Predicate_add_and_or_is_add>>  =>  (USRAv4i16_shift:{ *:[v4i16] } V64:{ *:[v4i16] }:$Rd, V64:{ *:[v4i16] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::USRAv4i16_shift,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2207,
        GIR_Done,
      // Label 629: @26991
      GIM_Try, /*On fail goto*//*Label 630*/ 27056, // Rule ID 11763 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (or:{ *:[v4i16] } (xor:{ *:[v4i16] } V64:{ *:[v4i16] }:$RHS, immAllOnesV:{ *:[v4i16] }), V64:{ *:[v4i16] }:$LHS)  =>  (ORNv8i8:{ *:[v4i16] } V64:{ *:[v4i16] }:$LHS, V64:{ *:[v4i16] }:$RHS)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::ORNv8i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // LHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // RHS
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11763,
        GIR_Done,
      // Label 630: @27056
      GIM_Try, /*On fail goto*//*Label 631*/ 27121, // Rule ID 8653 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (or:{ *:[v4i16] } V64:{ *:[v4i16] }:$LHS, (xor:{ *:[v4i16] } V64:{ *:[v4i16] }:$RHS, immAllOnesV:{ *:[v4i16] }))  =>  (ORNv8i8:{ *:[v4i16] } V64:{ *:[v4i16] }:$LHS, V64:{ *:[v4i16] }:$RHS)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::ORNv8i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // LHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // RHS
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 8653,
        GIR_Done,
      // Label 631: @27121
      GIM_Try, /*On fail goto*//*Label 632*/ 27144, // Rule ID 8659 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        // (or:{ *:[v4i16] } V64:{ *:[v4i16] }:$LHS, V64:{ *:[v4i16] }:$RHS)  =>  (ORRv8i8:{ *:[v4i16] } V64:{ *:[v4i16] }:$LHS, V64:{ *:[v4i16] }:$RHS)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::ORRv8i8,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 8659,
        GIR_Done,
      // Label 632: @27144
      GIM_Reject,
    // Label 617: @27145
    GIM_Reject,
    // Label 541: @27146
    GIM_Try, /*On fail goto*//*Label 633*/ 28442,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
      GIM_Try, /*On fail goto*//*Label 634*/ 27264, // Rule ID 11519 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcodeIsEither, /*MI*/3, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/3,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/4, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        // MIs[4] LHS
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        // (or:{ *:[v4i32] } (and:{ *:[v4i32] } (xor:{ *:[v4i32] } V128:{ *:[v4i32] }:$LHS, immAllOnesV:{ *:[v4i32] }), V128:{ *:[v4i32] }:$RHS), (and:{ *:[v4i32] } V128:{ *:[v4i32] }:$MHS, V128:{ *:[v4i32] }:$LHS))  =>  (BSPv16i8:{ *:[v4i32] } V128:{ *:[v4i32] }:$LHS, V128:{ *:[v4i32] }:$MHS, V128:{ *:[v4i32] }:$RHS)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::BSPv16i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // LHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/1, // MHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // RHS
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11519,
        GIR_Done,
      // Label 634: @27264
      GIM_Try, /*On fail goto*//*Label 635*/ 27372, // Rule ID 11518 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcodeIsEither, /*MI*/3, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/3,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_v4s32,
        // MIs[4] LHS
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckRegBankForClass, /*MI*/4, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        // (or:{ *:[v4i32] } (and:{ *:[v4i32] } (xor:{ *:[v4i32] } V128:{ *:[v4i32] }:$LHS, immAllOnesV:{ *:[v4i32] }), V128:{ *:[v4i32] }:$RHS), (and:{ *:[v4i32] } V128:{ *:[v4i32] }:$LHS, V128:{ *:[v4i32] }:$MHS))  =>  (BSPv16i8:{ *:[v4i32] } V128:{ *:[v4i32] }:$LHS, V128:{ *:[v4i32] }:$MHS, V128:{ *:[v4i32] }:$RHS)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::BSPv16i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // LHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/2, // MHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // RHS
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11518,
        GIR_Done,
      // Label 635: @27372
      GIM_Try, /*On fail goto*//*Label 636*/ 27480, // Rule ID 11521 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcodeIsEither, /*MI*/3, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/3,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/4, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        // MIs[4] LHS
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        // (or:{ *:[v4i32] } (and:{ *:[v4i32] } V128:{ *:[v4i32] }:$RHS, (xor:{ *:[v4i32] } V128:{ *:[v4i32] }:$LHS, immAllOnesV:{ *:[v4i32] })), (and:{ *:[v4i32] } V128:{ *:[v4i32] }:$MHS, V128:{ *:[v4i32] }:$LHS))  =>  (BSPv16i8:{ *:[v4i32] } V128:{ *:[v4i32] }:$LHS, V128:{ *:[v4i32] }:$MHS, V128:{ *:[v4i32] }:$RHS)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::BSPv16i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // LHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/1, // MHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // RHS
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11521,
        GIR_Done,
      // Label 636: @27480
      GIM_Try, /*On fail goto*//*Label 637*/ 27588, // Rule ID 11520 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcodeIsEither, /*MI*/3, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/3,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_v4s32,
        // MIs[4] LHS
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckRegBankForClass, /*MI*/4, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        // (or:{ *:[v4i32] } (and:{ *:[v4i32] } V128:{ *:[v4i32] }:$RHS, (xor:{ *:[v4i32] } V128:{ *:[v4i32] }:$LHS, immAllOnesV:{ *:[v4i32] })), (and:{ *:[v4i32] } V128:{ *:[v4i32] }:$LHS, V128:{ *:[v4i32] }:$MHS))  =>  (BSPv16i8:{ *:[v4i32] } V128:{ *:[v4i32] }:$LHS, V128:{ *:[v4i32] }:$MHS, V128:{ *:[v4i32] }:$RHS)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::BSPv16i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // LHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/2, // MHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // RHS
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11520,
        GIR_Done,
      // Label 637: @27588
      GIM_Try, /*On fail goto*//*Label 638*/ 27696, // Rule ID 6791 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        // MIs[3] LHS
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        // (or:{ *:[v4i32] } (and:{ *:[v4i32] } V128:{ *:[v4i32] }:$LHS, V128:{ *:[v4i32] }:$MHS), (and:{ *:[v4i32] } (xor:{ *:[v4i32] } V128:{ *:[v4i32] }:$LHS, immAllOnesV:{ *:[v4i32] }), V128:{ *:[v4i32] }:$RHS))  =>  (BSPv16i8:{ *:[v4i32] } V128:{ *:[v4i32] }:$LHS, V128:{ *:[v4i32] }:$MHS, V128:{ *:[v4i32] }:$RHS)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::BSPv16i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // LHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // MHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // RHS
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 6791,
        GIR_Done,
      // Label 638: @27696
      GIM_Try, /*On fail goto*//*Label 639*/ 27804, // Rule ID 11516 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        // MIs[3] LHS
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/2,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        // (or:{ *:[v4i32] } (and:{ *:[v4i32] } V128:{ *:[v4i32] }:$MHS, V128:{ *:[v4i32] }:$LHS), (and:{ *:[v4i32] } (xor:{ *:[v4i32] } V128:{ *:[v4i32] }:$LHS, immAllOnesV:{ *:[v4i32] }), V128:{ *:[v4i32] }:$RHS))  =>  (BSPv16i8:{ *:[v4i32] } V128:{ *:[v4i32] }:$LHS, V128:{ *:[v4i32] }:$MHS, V128:{ *:[v4i32] }:$RHS)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::BSPv16i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // LHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // MHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // RHS
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11516,
        GIR_Done,
      // Label 639: @27804
      GIM_Try, /*On fail goto*//*Label 640*/ 27912, // Rule ID 11515 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        // MIs[3] LHS
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        // (or:{ *:[v4i32] } (and:{ *:[v4i32] } V128:{ *:[v4i32] }:$LHS, V128:{ *:[v4i32] }:$MHS), (and:{ *:[v4i32] } V128:{ *:[v4i32] }:$RHS, (xor:{ *:[v4i32] } V128:{ *:[v4i32] }:$LHS, immAllOnesV:{ *:[v4i32] })))  =>  (BSPv16i8:{ *:[v4i32] } V128:{ *:[v4i32] }:$LHS, V128:{ *:[v4i32] }:$MHS, V128:{ *:[v4i32] }:$RHS)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::BSPv16i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // LHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // MHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // RHS
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11515,
        GIR_Done,
      // Label 640: @27912
      GIM_Try, /*On fail goto*//*Label 641*/ 28020, // Rule ID 11517 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        // MIs[3] LHS
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/2,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        // (or:{ *:[v4i32] } (and:{ *:[v4i32] } V128:{ *:[v4i32] }:$MHS, V128:{ *:[v4i32] }:$LHS), (and:{ *:[v4i32] } V128:{ *:[v4i32] }:$RHS, (xor:{ *:[v4i32] } V128:{ *:[v4i32] }:$LHS, immAllOnesV:{ *:[v4i32] })))  =>  (BSPv16i8:{ *:[v4i32] } V128:{ *:[v4i32] }:$LHS, V128:{ *:[v4i32] }:$MHS, V128:{ *:[v4i32] }:$RHS)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::BSPv16i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // LHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // MHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // RHS
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11517,
        GIR_Done,
      // Label 641: @28020
      GIM_Try, /*On fail goto*//*Label 642*/ 28087, // Rule ID 10920 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, AArch64::G_VASHR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        // MIs[1] imm
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIPFP_I64_Predicate_vecshiftR32,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_add_and_or_is_add,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (or:{ *:[v4i32] } (AArch64vashr:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR32>>:$imm), V128:{ *:[v4i32] }:$Rd)<<P:Predicate_add_and_or_is_add>>  =>  (SSRAv4i32_shift:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, V128:{ *:[v4i32] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SSRAv4i32_shift,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 10920,
        GIR_Done,
      // Label 642: @28087
      GIM_Try, /*On fail goto*//*Label 643*/ 28154, // Rule ID 10941 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, AArch64::G_VLSHR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        // MIs[1] imm
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIPFP_I64_Predicate_vecshiftR32,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_add_and_or_is_add,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (or:{ *:[v4i32] } (AArch64vlshr:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR32>>:$imm), V128:{ *:[v4i32] }:$Rd)<<P:Predicate_add_and_or_is_add>>  =>  (USRAv4i32_shift:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, V128:{ *:[v4i32] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::USRAv4i32_shift,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 10941,
        GIR_Done,
      // Label 643: @28154
      GIM_Try, /*On fail goto*//*Label 644*/ 28221, // Rule ID 2154 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, AArch64::G_VASHR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        // MIs[1] imm
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIPFP_I64_Predicate_vecshiftR32,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_add_and_or_is_add,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (or:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, (AArch64vashr:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR32>>:$imm))<<P:Predicate_add_and_or_is_add>>  =>  (SSRAv4i32_shift:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, V128:{ *:[v4i32] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SSRAv4i32_shift,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2154,
        GIR_Done,
      // Label 644: @28221
      GIM_Try, /*On fail goto*//*Label 645*/ 28288, // Rule ID 2213 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, AArch64::G_VLSHR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        // MIs[1] imm
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIPFP_I64_Predicate_vecshiftR32,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_add_and_or_is_add,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (or:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, (AArch64vlshr:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR32>>:$imm))<<P:Predicate_add_and_or_is_add>>  =>  (USRAv4i32_shift:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, V128:{ *:[v4i32] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::USRAv4i32_shift,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2213,
        GIR_Done,
      // Label 645: @28288
      GIM_Try, /*On fail goto*//*Label 646*/ 28353, // Rule ID 11767 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } V128:{ *:[v4i32] }:$RHS, immAllOnesV:{ *:[v4i32] }), V128:{ *:[v4i32] }:$LHS)  =>  (ORNv16i8:{ *:[v4i32] } V128:{ *:[v4i32] }:$LHS, V128:{ *:[v4i32] }:$RHS)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::ORNv16i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // LHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // RHS
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11767,
        GIR_Done,
      // Label 646: @28353
      GIM_Try, /*On fail goto*//*Label 647*/ 28418, // Rule ID 8657 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (or:{ *:[v4i32] } V128:{ *:[v4i32] }:$LHS, (xor:{ *:[v4i32] } V128:{ *:[v4i32] }:$RHS, immAllOnesV:{ *:[v4i32] }))  =>  (ORNv16i8:{ *:[v4i32] } V128:{ *:[v4i32] }:$LHS, V128:{ *:[v4i32] }:$RHS)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::ORNv16i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // LHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // RHS
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 8657,
        GIR_Done,
      // Label 647: @28418
      GIM_Try, /*On fail goto*//*Label 648*/ 28441, // Rule ID 8663 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        // (or:{ *:[v4i32] } V128:{ *:[v4i32] }:$LHS, V128:{ *:[v4i32] }:$RHS)  =>  (ORRv16i8:{ *:[v4i32] } V128:{ *:[v4i32] }:$LHS, V128:{ *:[v4i32] }:$RHS)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::ORRv16i8,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 8663,
        GIR_Done,
      // Label 648: @28441
      GIM_Reject,
    // Label 633: @28442
    GIM_Reject,
    // Label 542: @28443
    GIM_Try, /*On fail goto*//*Label 649*/ 29739,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s8,
      GIM_Try, /*On fail goto*//*Label 650*/ 28561, // Rule ID 10764 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcodeIsEither, /*MI*/3, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/3,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/4, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        // MIs[4] Rd
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        // (or:{ *:[v8i8] } (and:{ *:[v8i8] } (xor:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rd, immAllOnesV:{ *:[v8i8] }), V64:{ *:[v8i8] }:$Rm), (and:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rd))  =>  (BSPv8i8:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rd, V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::BSPv8i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 10764,
        GIR_Done,
      // Label 650: @28561
      GIM_Try, /*On fail goto*//*Label 651*/ 28669, // Rule ID 10763 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcodeIsEither, /*MI*/3, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/3,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_v8s8,
        // MIs[4] Rd
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckRegBankForClass, /*MI*/4, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        // (or:{ *:[v8i8] } (and:{ *:[v8i8] } (xor:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rd, immAllOnesV:{ *:[v8i8] }), V64:{ *:[v8i8] }:$Rm), (and:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rd, V64:{ *:[v8i8] }:$Rn))  =>  (BSPv8i8:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rd, V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::BSPv8i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 10763,
        GIR_Done,
      // Label 651: @28669
      GIM_Try, /*On fail goto*//*Label 652*/ 28777, // Rule ID 10766 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcodeIsEither, /*MI*/3, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/3,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/4, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        // MIs[4] Rd
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        // (or:{ *:[v8i8] } (and:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rm, (xor:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rd, immAllOnesV:{ *:[v8i8] })), (and:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rd))  =>  (BSPv8i8:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rd, V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::BSPv8i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 10766,
        GIR_Done,
      // Label 652: @28777
      GIM_Try, /*On fail goto*//*Label 653*/ 28885, // Rule ID 10765 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcodeIsEither, /*MI*/3, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/3,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_v8s8,
        // MIs[4] Rd
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckRegBankForClass, /*MI*/4, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        // (or:{ *:[v8i8] } (and:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rm, (xor:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rd, immAllOnesV:{ *:[v8i8] })), (and:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rd, V64:{ *:[v8i8] }:$Rn))  =>  (BSPv8i8:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rd, V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::BSPv8i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 10765,
        GIR_Done,
      // Label 653: @28885
      GIM_Try, /*On fail goto*//*Label 654*/ 28993, // Rule ID 1568 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v8s8,
        // MIs[3] Rd
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        // (or:{ *:[v8i8] } (and:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rd, V64:{ *:[v8i8] }:$Rn), (and:{ *:[v8i8] } (xor:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rd, immAllOnesV:{ *:[v8i8] }), V64:{ *:[v8i8] }:$Rm))  =>  (BSPv8i8:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rd, V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::BSPv8i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1568,
        GIR_Done,
      // Label 654: @28993
      GIM_Try, /*On fail goto*//*Label 655*/ 29101, // Rule ID 10761 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v8s8,
        // MIs[3] Rd
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/2,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        // (or:{ *:[v8i8] } (and:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rd), (and:{ *:[v8i8] } (xor:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rd, immAllOnesV:{ *:[v8i8] }), V64:{ *:[v8i8] }:$Rm))  =>  (BSPv8i8:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rd, V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::BSPv8i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 10761,
        GIR_Done,
      // Label 655: @29101
      GIM_Try, /*On fail goto*//*Label 656*/ 29209, // Rule ID 10760 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v8s8,
        // MIs[3] Rd
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        // (or:{ *:[v8i8] } (and:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rd, V64:{ *:[v8i8] }:$Rn), (and:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rm, (xor:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rd, immAllOnesV:{ *:[v8i8] })))  =>  (BSPv8i8:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rd, V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::BSPv8i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 10760,
        GIR_Done,
      // Label 656: @29209
      GIM_Try, /*On fail goto*//*Label 657*/ 29317, // Rule ID 10762 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v8s8,
        // MIs[3] Rd
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/2,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        // (or:{ *:[v8i8] } (and:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rd), (and:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rm, (xor:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rd, immAllOnesV:{ *:[v8i8] })))  =>  (BSPv8i8:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rd, V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::BSPv8i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 10762,
        GIR_Done,
      // Label 657: @29317
      GIM_Try, /*On fail goto*//*Label 658*/ 29384, // Rule ID 10910 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, AArch64::G_VASHR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        // MIs[1] imm
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIPFP_I64_Predicate_vecshiftR8,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_add_and_or_is_add,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (or:{ *:[v8i8] } (AArch64vashr:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR8>>:$imm), V64:{ *:[v8i8] }:$Rd)<<P:Predicate_add_and_or_is_add>>  =>  (SSRAv8i8_shift:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rd, V64:{ *:[v8i8] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SSRAv8i8_shift,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 10910,
        GIR_Done,
      // Label 658: @29384
      GIM_Try, /*On fail goto*//*Label 659*/ 29451, // Rule ID 10931 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, AArch64::G_VLSHR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        // MIs[1] imm
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIPFP_I64_Predicate_vecshiftR8,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_add_and_or_is_add,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (or:{ *:[v8i8] } (AArch64vlshr:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR8>>:$imm), V64:{ *:[v8i8] }:$Rd)<<P:Predicate_add_and_or_is_add>>  =>  (USRAv8i8_shift:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rd, V64:{ *:[v8i8] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::USRAv8i8_shift,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 10931,
        GIR_Done,
      // Label 659: @29451
      GIM_Try, /*On fail goto*//*Label 660*/ 29518, // Rule ID 2144 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, AArch64::G_VASHR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        // MIs[1] imm
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIPFP_I64_Predicate_vecshiftR8,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_add_and_or_is_add,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (or:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rd, (AArch64vashr:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR8>>:$imm))<<P:Predicate_add_and_or_is_add>>  =>  (SSRAv8i8_shift:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rd, V64:{ *:[v8i8] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SSRAv8i8_shift,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2144,
        GIR_Done,
      // Label 660: @29518
      GIM_Try, /*On fail goto*//*Label 661*/ 29585, // Rule ID 2203 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, AArch64::G_VLSHR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        // MIs[1] imm
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIPFP_I64_Predicate_vecshiftR8,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_add_and_or_is_add,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (or:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rd, (AArch64vlshr:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR8>>:$imm))<<P:Predicate_add_and_or_is_add>>  =>  (USRAv8i8_shift:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rd, V64:{ *:[v8i8] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::USRAv8i8_shift,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2203,
        GIR_Done,
      // Label 661: @29585
      GIM_Try, /*On fail goto*//*Label 662*/ 29650, // Rule ID 10758 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (or:{ *:[v8i8] } (xor:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rm, immAllOnesV:{ *:[v8i8] }), V64:{ *:[v8i8] }:$Rn)  =>  (ORNv8i8:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::ORNv8i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 10758,
        GIR_Done,
      // Label 662: @29650
      GIM_Try, /*On fail goto*//*Label 663*/ 29715, // Rule ID 1564 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (or:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rn, (xor:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rm, immAllOnesV:{ *:[v8i8] }))  =>  (ORNv8i8:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::ORNv8i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1564,
        GIR_Done,
      // Label 663: @29715
      GIM_Try, /*On fail goto*//*Label 664*/ 29738, // Rule ID 1566 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        // (or:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm)  =>  (ORRv8i8:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::ORRv8i8,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1566,
        GIR_Done,
      // Label 664: @29738
      GIM_Reject,
    // Label 649: @29739
    GIM_Reject,
    // Label 543: @29740
    GIM_Try, /*On fail goto*//*Label 665*/ 31036,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
      GIM_Try, /*On fail goto*//*Label 666*/ 29858, // Rule ID 11512 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcodeIsEither, /*MI*/3, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/3,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/4, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        // MIs[4] LHS
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        // (or:{ *:[v8i16] } (and:{ *:[v8i16] } (xor:{ *:[v8i16] } V128:{ *:[v8i16] }:$LHS, immAllOnesV:{ *:[v8i16] }), V128:{ *:[v8i16] }:$RHS), (and:{ *:[v8i16] } V128:{ *:[v8i16] }:$MHS, V128:{ *:[v8i16] }:$LHS))  =>  (BSPv16i8:{ *:[v8i16] } V128:{ *:[v8i16] }:$LHS, V128:{ *:[v8i16] }:$MHS, V128:{ *:[v8i16] }:$RHS)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::BSPv16i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // LHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/1, // MHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // RHS
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11512,
        GIR_Done,
      // Label 666: @29858
      GIM_Try, /*On fail goto*//*Label 667*/ 29966, // Rule ID 11511 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcodeIsEither, /*MI*/3, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/3,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_v8s16,
        // MIs[4] LHS
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckRegBankForClass, /*MI*/4, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        // (or:{ *:[v8i16] } (and:{ *:[v8i16] } (xor:{ *:[v8i16] } V128:{ *:[v8i16] }:$LHS, immAllOnesV:{ *:[v8i16] }), V128:{ *:[v8i16] }:$RHS), (and:{ *:[v8i16] } V128:{ *:[v8i16] }:$LHS, V128:{ *:[v8i16] }:$MHS))  =>  (BSPv16i8:{ *:[v8i16] } V128:{ *:[v8i16] }:$LHS, V128:{ *:[v8i16] }:$MHS, V128:{ *:[v8i16] }:$RHS)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::BSPv16i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // LHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/2, // MHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // RHS
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11511,
        GIR_Done,
      // Label 667: @29966
      GIM_Try, /*On fail goto*//*Label 668*/ 30074, // Rule ID 11514 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcodeIsEither, /*MI*/3, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/3,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/4, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        // MIs[4] LHS
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        // (or:{ *:[v8i16] } (and:{ *:[v8i16] } V128:{ *:[v8i16] }:$RHS, (xor:{ *:[v8i16] } V128:{ *:[v8i16] }:$LHS, immAllOnesV:{ *:[v8i16] })), (and:{ *:[v8i16] } V128:{ *:[v8i16] }:$MHS, V128:{ *:[v8i16] }:$LHS))  =>  (BSPv16i8:{ *:[v8i16] } V128:{ *:[v8i16] }:$LHS, V128:{ *:[v8i16] }:$MHS, V128:{ *:[v8i16] }:$RHS)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::BSPv16i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // LHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/1, // MHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // RHS
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11514,
        GIR_Done,
      // Label 668: @30074
      GIM_Try, /*On fail goto*//*Label 669*/ 30182, // Rule ID 11513 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcodeIsEither, /*MI*/3, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/3,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_v8s16,
        // MIs[4] LHS
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckRegBankForClass, /*MI*/4, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        // (or:{ *:[v8i16] } (and:{ *:[v8i16] } V128:{ *:[v8i16] }:$RHS, (xor:{ *:[v8i16] } V128:{ *:[v8i16] }:$LHS, immAllOnesV:{ *:[v8i16] })), (and:{ *:[v8i16] } V128:{ *:[v8i16] }:$LHS, V128:{ *:[v8i16] }:$MHS))  =>  (BSPv16i8:{ *:[v8i16] } V128:{ *:[v8i16] }:$LHS, V128:{ *:[v8i16] }:$MHS, V128:{ *:[v8i16] }:$RHS)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::BSPv16i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // LHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/2, // MHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // RHS
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11513,
        GIR_Done,
      // Label 669: @30182
      GIM_Try, /*On fail goto*//*Label 670*/ 30290, // Rule ID 6790 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v8s16,
        // MIs[3] LHS
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        // (or:{ *:[v8i16] } (and:{ *:[v8i16] } V128:{ *:[v8i16] }:$LHS, V128:{ *:[v8i16] }:$MHS), (and:{ *:[v8i16] } (xor:{ *:[v8i16] } V128:{ *:[v8i16] }:$LHS, immAllOnesV:{ *:[v8i16] }), V128:{ *:[v8i16] }:$RHS))  =>  (BSPv16i8:{ *:[v8i16] } V128:{ *:[v8i16] }:$LHS, V128:{ *:[v8i16] }:$MHS, V128:{ *:[v8i16] }:$RHS)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::BSPv16i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // LHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // MHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // RHS
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 6790,
        GIR_Done,
      // Label 670: @30290
      GIM_Try, /*On fail goto*//*Label 671*/ 30398, // Rule ID 11509 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v8s16,
        // MIs[3] LHS
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/2,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        // (or:{ *:[v8i16] } (and:{ *:[v8i16] } V128:{ *:[v8i16] }:$MHS, V128:{ *:[v8i16] }:$LHS), (and:{ *:[v8i16] } (xor:{ *:[v8i16] } V128:{ *:[v8i16] }:$LHS, immAllOnesV:{ *:[v8i16] }), V128:{ *:[v8i16] }:$RHS))  =>  (BSPv16i8:{ *:[v8i16] } V128:{ *:[v8i16] }:$LHS, V128:{ *:[v8i16] }:$MHS, V128:{ *:[v8i16] }:$RHS)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::BSPv16i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // LHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // MHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // RHS
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11509,
        GIR_Done,
      // Label 671: @30398
      GIM_Try, /*On fail goto*//*Label 672*/ 30506, // Rule ID 11508 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v8s16,
        // MIs[3] LHS
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        // (or:{ *:[v8i16] } (and:{ *:[v8i16] } V128:{ *:[v8i16] }:$LHS, V128:{ *:[v8i16] }:$MHS), (and:{ *:[v8i16] } V128:{ *:[v8i16] }:$RHS, (xor:{ *:[v8i16] } V128:{ *:[v8i16] }:$LHS, immAllOnesV:{ *:[v8i16] })))  =>  (BSPv16i8:{ *:[v8i16] } V128:{ *:[v8i16] }:$LHS, V128:{ *:[v8i16] }:$MHS, V128:{ *:[v8i16] }:$RHS)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::BSPv16i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // LHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // MHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // RHS
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11508,
        GIR_Done,
      // Label 672: @30506
      GIM_Try, /*On fail goto*//*Label 673*/ 30614, // Rule ID 11510 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v8s16,
        // MIs[3] LHS
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/2,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        // (or:{ *:[v8i16] } (and:{ *:[v8i16] } V128:{ *:[v8i16] }:$MHS, V128:{ *:[v8i16] }:$LHS), (and:{ *:[v8i16] } V128:{ *:[v8i16] }:$RHS, (xor:{ *:[v8i16] } V128:{ *:[v8i16] }:$LHS, immAllOnesV:{ *:[v8i16] })))  =>  (BSPv16i8:{ *:[v8i16] } V128:{ *:[v8i16] }:$LHS, V128:{ *:[v8i16] }:$MHS, V128:{ *:[v8i16] }:$RHS)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::BSPv16i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // LHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // MHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // RHS
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11510,
        GIR_Done,
      // Label 673: @30614
      GIM_Try, /*On fail goto*//*Label 674*/ 30681, // Rule ID 10916 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, AArch64::G_VASHR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        // MIs[1] imm
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIPFP_I64_Predicate_vecshiftR16,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_add_and_or_is_add,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (or:{ *:[v8i16] } (AArch64vashr:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR16>>:$imm), V128:{ *:[v8i16] }:$Rd)<<P:Predicate_add_and_or_is_add>>  =>  (SSRAv8i16_shift:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rd, V128:{ *:[v8i16] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SSRAv8i16_shift,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 10916,
        GIR_Done,
      // Label 674: @30681
      GIM_Try, /*On fail goto*//*Label 675*/ 30748, // Rule ID 10937 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, AArch64::G_VLSHR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        // MIs[1] imm
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIPFP_I64_Predicate_vecshiftR16,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_add_and_or_is_add,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (or:{ *:[v8i16] } (AArch64vlshr:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR16>>:$imm), V128:{ *:[v8i16] }:$Rd)<<P:Predicate_add_and_or_is_add>>  =>  (USRAv8i16_shift:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rd, V128:{ *:[v8i16] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::USRAv8i16_shift,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 10937,
        GIR_Done,
      // Label 675: @30748
      GIM_Try, /*On fail goto*//*Label 676*/ 30815, // Rule ID 2150 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, AArch64::G_VASHR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        // MIs[1] imm
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIPFP_I64_Predicate_vecshiftR16,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_add_and_or_is_add,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (or:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rd, (AArch64vashr:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR16>>:$imm))<<P:Predicate_add_and_or_is_add>>  =>  (SSRAv8i16_shift:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rd, V128:{ *:[v8i16] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SSRAv8i16_shift,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2150,
        GIR_Done,
      // Label 676: @30815
      GIM_Try, /*On fail goto*//*Label 677*/ 30882, // Rule ID 2209 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, AArch64::G_VLSHR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        // MIs[1] imm
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIPFP_I64_Predicate_vecshiftR16,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_add_and_or_is_add,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (or:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rd, (AArch64vlshr:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR16>>:$imm))<<P:Predicate_add_and_or_is_add>>  =>  (USRAv8i16_shift:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rd, V128:{ *:[v8i16] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::USRAv8i16_shift,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2209,
        GIR_Done,
      // Label 677: @30882
      GIM_Try, /*On fail goto*//*Label 678*/ 30947, // Rule ID 11766 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (or:{ *:[v8i16] } (xor:{ *:[v8i16] } V128:{ *:[v8i16] }:$RHS, immAllOnesV:{ *:[v8i16] }), V128:{ *:[v8i16] }:$LHS)  =>  (ORNv16i8:{ *:[v8i16] } V128:{ *:[v8i16] }:$LHS, V128:{ *:[v8i16] }:$RHS)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::ORNv16i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // LHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // RHS
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11766,
        GIR_Done,
      // Label 678: @30947
      GIM_Try, /*On fail goto*//*Label 679*/ 31012, // Rule ID 8656 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (or:{ *:[v8i16] } V128:{ *:[v8i16] }:$LHS, (xor:{ *:[v8i16] } V128:{ *:[v8i16] }:$RHS, immAllOnesV:{ *:[v8i16] }))  =>  (ORNv16i8:{ *:[v8i16] } V128:{ *:[v8i16] }:$LHS, V128:{ *:[v8i16] }:$RHS)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::ORNv16i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // LHS
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // RHS
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 8656,
        GIR_Done,
      // Label 679: @31012
      GIM_Try, /*On fail goto*//*Label 680*/ 31035, // Rule ID 8662 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        // (or:{ *:[v8i16] } V128:{ *:[v8i16] }:$LHS, V128:{ *:[v8i16] }:$RHS)  =>  (ORRv16i8:{ *:[v8i16] } V128:{ *:[v8i16] }:$LHS, V128:{ *:[v8i16] }:$RHS)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::ORRv16i8,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 8662,
        GIR_Done,
      // Label 680: @31035
      GIM_Reject,
    // Label 665: @31036
    GIM_Reject,
    // Label 544: @31037
    GIM_Try, /*On fail goto*//*Label 681*/ 32333,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
      GIM_Try, /*On fail goto*//*Label 682*/ 31155, // Rule ID 10771 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcodeIsEither, /*MI*/3, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/3,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/4, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        // MIs[4] Rd
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        // (or:{ *:[v16i8] } (and:{ *:[v16i8] } (xor:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rd, immAllOnesV:{ *:[v16i8] }), V128:{ *:[v16i8] }:$Rm), (and:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rn, V128:{ *:[v16i8] }:$Rd))  =>  (BSPv16i8:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rd, V128:{ *:[v16i8] }:$Rn, V128:{ *:[v16i8] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::BSPv16i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 10771,
        GIR_Done,
      // Label 682: @31155
      GIM_Try, /*On fail goto*//*Label 683*/ 31263, // Rule ID 10770 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcodeIsEither, /*MI*/3, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/3,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_v16s8,
        // MIs[4] Rd
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckRegBankForClass, /*MI*/4, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        // (or:{ *:[v16i8] } (and:{ *:[v16i8] } (xor:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rd, immAllOnesV:{ *:[v16i8] }), V128:{ *:[v16i8] }:$Rm), (and:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rd, V128:{ *:[v16i8] }:$Rn))  =>  (BSPv16i8:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rd, V128:{ *:[v16i8] }:$Rn, V128:{ *:[v16i8] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::BSPv16i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 10770,
        GIR_Done,
      // Label 683: @31263
      GIM_Try, /*On fail goto*//*Label 684*/ 31371, // Rule ID 10773 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcodeIsEither, /*MI*/3, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/3,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/4, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        // MIs[4] Rd
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        // (or:{ *:[v16i8] } (and:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rm, (xor:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rd, immAllOnesV:{ *:[v16i8] })), (and:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rn, V128:{ *:[v16i8] }:$Rd))  =>  (BSPv16i8:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rd, V128:{ *:[v16i8] }:$Rn, V128:{ *:[v16i8] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::BSPv16i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 10773,
        GIR_Done,
      // Label 684: @31371
      GIM_Try, /*On fail goto*//*Label 685*/ 31479, // Rule ID 10772 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcodeIsEither, /*MI*/3, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/3,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_v16s8,
        // MIs[4] Rd
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckRegBankForClass, /*MI*/4, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        // (or:{ *:[v16i8] } (and:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rm, (xor:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rd, immAllOnesV:{ *:[v16i8] })), (and:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rd, V128:{ *:[v16i8] }:$Rn))  =>  (BSPv16i8:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rd, V128:{ *:[v16i8] }:$Rn, V128:{ *:[v16i8] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::BSPv16i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 10772,
        GIR_Done,
      // Label 685: @31479
      GIM_Try, /*On fail goto*//*Label 686*/ 31587, // Rule ID 1569 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v16s8,
        // MIs[3] Rd
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        // (or:{ *:[v16i8] } (and:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rd, V128:{ *:[v16i8] }:$Rn), (and:{ *:[v16i8] } (xor:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rd, immAllOnesV:{ *:[v16i8] }), V128:{ *:[v16i8] }:$Rm))  =>  (BSPv16i8:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rd, V128:{ *:[v16i8] }:$Rn, V128:{ *:[v16i8] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::BSPv16i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1569,
        GIR_Done,
      // Label 686: @31587
      GIM_Try, /*On fail goto*//*Label 687*/ 31695, // Rule ID 10768 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v16s8,
        // MIs[3] Rd
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/2,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        // (or:{ *:[v16i8] } (and:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rn, V128:{ *:[v16i8] }:$Rd), (and:{ *:[v16i8] } (xor:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rd, immAllOnesV:{ *:[v16i8] }), V128:{ *:[v16i8] }:$Rm))  =>  (BSPv16i8:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rd, V128:{ *:[v16i8] }:$Rn, V128:{ *:[v16i8] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::BSPv16i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 10768,
        GIR_Done,
      // Label 687: @31695
      GIM_Try, /*On fail goto*//*Label 688*/ 31803, // Rule ID 10767 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v16s8,
        // MIs[3] Rd
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        // (or:{ *:[v16i8] } (and:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rd, V128:{ *:[v16i8] }:$Rn), (and:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rm, (xor:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rd, immAllOnesV:{ *:[v16i8] })))  =>  (BSPv16i8:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rd, V128:{ *:[v16i8] }:$Rn, V128:{ *:[v16i8] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::BSPv16i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 10767,
        GIR_Done,
      // Label 688: @31803
      GIM_Try, /*On fail goto*//*Label 689*/ 31911, // Rule ID 10769 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v16s8,
        // MIs[3] Rd
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/2,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        // (or:{ *:[v16i8] } (and:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rn, V128:{ *:[v16i8] }:$Rd), (and:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rm, (xor:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rd, immAllOnesV:{ *:[v16i8] })))  =>  (BSPv16i8:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rd, V128:{ *:[v16i8] }:$Rn, V128:{ *:[v16i8] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::BSPv16i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 10769,
        GIR_Done,
      // Label 689: @31911
      GIM_Try, /*On fail goto*//*Label 690*/ 31978, // Rule ID 10912 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, AArch64::G_VASHR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        // MIs[1] imm
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIPFP_I64_Predicate_vecshiftR8,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_add_and_or_is_add,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (or:{ *:[v16i8] } (AArch64vashr:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR8>>:$imm), V128:{ *:[v16i8] }:$Rd)<<P:Predicate_add_and_or_is_add>>  =>  (SSRAv16i8_shift:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rd, V128:{ *:[v16i8] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SSRAv16i8_shift,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 10912,
        GIR_Done,
      // Label 690: @31978
      GIM_Try, /*On fail goto*//*Label 691*/ 32045, // Rule ID 10933 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, AArch64::G_VLSHR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        // MIs[1] imm
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIPFP_I64_Predicate_vecshiftR8,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_add_and_or_is_add,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (or:{ *:[v16i8] } (AArch64vlshr:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR8>>:$imm), V128:{ *:[v16i8] }:$Rd)<<P:Predicate_add_and_or_is_add>>  =>  (USRAv16i8_shift:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rd, V128:{ *:[v16i8] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::USRAv16i8_shift,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 10933,
        GIR_Done,
      // Label 691: @32045
      GIM_Try, /*On fail goto*//*Label 692*/ 32112, // Rule ID 2146 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, AArch64::G_VASHR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        // MIs[1] imm
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIPFP_I64_Predicate_vecshiftR8,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_add_and_or_is_add,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (or:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rd, (AArch64vashr:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR8>>:$imm))<<P:Predicate_add_and_or_is_add>>  =>  (SSRAv16i8_shift:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rd, V128:{ *:[v16i8] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SSRAv16i8_shift,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2146,
        GIR_Done,
      // Label 692: @32112
      GIM_Try, /*On fail goto*//*Label 693*/ 32179, // Rule ID 2205 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, AArch64::G_VLSHR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        // MIs[1] imm
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIPFP_I64_Predicate_vecshiftR8,
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIPFP_MI_Predicate_add_and_or_is_add,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (or:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rd, (AArch64vlshr:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR8>>:$imm))<<P:Predicate_add_and_or_is_add>>  =>  (USRAv16i8_shift:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rd, V128:{ *:[v16i8] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::USRAv16i8_shift,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 2205,
        GIR_Done,
      // Label 693: @32179
      GIM_Try, /*On fail goto*//*Label 694*/ 32244, // Rule ID 10759 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (or:{ *:[v16i8] } (xor:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rm, immAllOnesV:{ *:[v16i8] }), V128:{ *:[v16i8] }:$Rn)  =>  (ORNv16i8:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rn, V128:{ *:[v16i8] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::ORNv16i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 10759,
        GIR_Done,
      // Label 694: @32244
      GIM_Try, /*On fail goto*//*Label 695*/ 32309, // Rule ID 1565 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (or:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rn, (xor:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rm, immAllOnesV:{ *:[v16i8] }))  =>  (ORNv16i8:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rn, V128:{ *:[v16i8] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::ORNv16i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1565,
        GIR_Done,
      // Label 695: @32309
      GIM_Try, /*On fail goto*//*Label 696*/ 32332, // Rule ID 1567 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        // (or:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rn, V128:{ *:[v16i8] }:$Rm)  =>  (ORRv16i8:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rn, V128:{ *:[v16i8] }:$Rm)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::ORRv16i8,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1567,
        GIR_Done,
      // Label 696: @32332
      GIM_Reject,
    // Label 681: @32333
    GIM_Reject,
    // Label 545: @32334
    GIM_Reject,
    // Label 7: @32335
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/1, 11, /*)*//*default:*//*Label 706*/ 36563,
    /*GILLT_s32*//*Label 697*/ 32351,
    /*GILLT_s64*//*Label 698*/ 33023, 0,
    /*GILLT_v2s32*//*Label 699*/ 33756,
    /*GILLT_v2s64*//*Label 700*/ 33821,
    /*GILLT_v4s16*//*Label 701*/ 34348,
    /*GILLT_v4s32*//*Label 702*/ 34413,
    /*GILLT_v8s8*//*Label 703*/ 34940,
    /*GILLT_v8s16*//*Label 704*/ 35007,
    /*GILLT_v16s8*//*Label 705*/ 36034,
    // Label 697: @32351
    GIM_Try, /*On fail goto*//*Label 707*/ 33022,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 708*/ 32416, // Rule ID 10653 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_logical_shifted_reg32,
        // (xor:{ *:[i32] } logical_shifted_reg32:{ *:[i32] }:$Rm_and_shift, (xor:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, -1:{ *:[i32] }))  =>  (EONWrs:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, logical_shifted_reg32:{ *:[i32] }:$Rm_and_shift)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::EONWrs,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/0, // Rm_and_shift
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 10653,
        GIR_Done,
      // Label 708: @32416
      GIM_Try, /*On fail goto*//*Label 709*/ 32471, // Rule ID 10652 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/0, GICP_gi_logical_shifted_reg32,
        // (xor:{ *:[i32] } (xor:{ *:[i32] } logical_shifted_reg32:{ *:[i32] }:$Rm_and_shift, -1:{ *:[i32] }), GPR32:{ *:[i32] }:$Rn)  =>  (EONWrs:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, logical_shifted_reg32:{ *:[i32] }:$Rm_and_shift)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::EONWrs,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/0, // Rm_and_shift
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 10652,
        GIR_Done,
      // Label 709: @32471
      GIM_Try, /*On fail goto*//*Label 710*/ 32526, // Rule ID 10650 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, -1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/0, GICP_gi_logical_shifted_reg32,
        // (xor:{ *:[i32] } (xor:{ *:[i32] } logical_shifted_reg32:{ *:[i32] }:$Rm_and_shift, GPR32:{ *:[i32] }:$Rn), -1:{ *:[i32] })  =>  (EONWrs:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, logical_shifted_reg32:{ *:[i32] }:$Rm_and_shift)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::EONWrs,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/0, // Rm_and_shift
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 10650,
        GIR_Done,
      // Label 710: @32526
      GIM_Try, /*On fail goto*//*Label 711*/ 32581, // Rule ID 168 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, -1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckComplexPattern, /*MI*/1, /*Op*/2, /*Renderer*/0, GICP_gi_logical_shifted_reg32,
        // (xor:{ *:[i32] } (xor:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, logical_shifted_reg32:{ *:[i32] }:$Rm_and_shift), -1:{ *:[i32] })  =>  (EONWrs:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, logical_shifted_reg32:{ *:[i32] }:$Rm_and_shift)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::EONWrs,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/0, // Rm_and_shift
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 168,
        GIR_Done,
      // Label 711: @32581
      GIM_Try, /*On fail goto*//*Label 712*/ 32636, // Rule ID 10651 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/0, GICP_gi_logical_shifted_reg32,
        // (xor:{ *:[i32] } (xor:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, -1:{ *:[i32] }), logical_shifted_reg32:{ *:[i32] }:$Rm_and_shift)  =>  (EONWrs:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, logical_shifted_reg32:{ *:[i32] }:$Rm_and_shift)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::EONWrs,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/0, // Rm_and_shift
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 10651,
        GIR_Done,
      // Label 712: @32636
      GIM_Try, /*On fail goto*//*Label 713*/ 32691, // Rule ID 10654 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/0, GICP_gi_logical_shifted_reg32,
        // (xor:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, (xor:{ *:[i32] } logical_shifted_reg32:{ *:[i32] }:$Rm_and_shift, -1:{ *:[i32] }))  =>  (EONWrs:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, logical_shifted_reg32:{ *:[i32] }:$Rm_and_shift)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::EONWrs,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/0, // Rm_and_shift
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 10654,
        GIR_Done,
      // Label 713: @32691
      GIM_Try, /*On fail goto*//*Label 714*/ 32733, // Rule ID 146 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckAPIntImmPredicate, /*MI*/1, /*Predicate*/GIPFP_APInt_Predicate_logical_imm32,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (xor:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_logical_imm32>><<X:logical_imm32_XFORM>>:$imm)  =>  (EORWri:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, (logical_imm32_XFORM:{ *:[i32] } (imm:{ *:[i32] }):$imm))
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::EORWri,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_CustomRenderer, /*InsnID*/0, /*OldInsnID*/1, /*Renderer*/GICR_renderLogicalImm32, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 146,
        GIR_Done,
      // Label 714: @32733
      GIM_Try, /*On fail goto*//*Label 715*/ 32767, // Rule ID 10660 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_logical_shifted_reg32,
        // (xor:{ *:[i32] } logical_shifted_reg32:{ *:[i32] }:$Rm_and_shift, GPR32:{ *:[i32] }:$Rn)  =>  (EORWrs:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, logical_shifted_reg32:{ *:[i32] }:$Rm_and_shift)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::EORWrs,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/0, // Rm_and_shift
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 10660,
        GIR_Done,
      // Label 715: @32767
      GIM_Try, /*On fail goto*//*Label 716*/ 32801, // Rule ID 172 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/0, GICP_gi_logical_shifted_reg32,
        // (xor:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, logical_shifted_reg32:{ *:[i32] }:$Rm_and_shift)  =>  (EORWrs:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, logical_shifted_reg32:{ *:[i32] }:$Rm_and_shift)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::EORWrs,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/0, // Rm_and_shift
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 172,
        GIR_Done,
      // Label 716: @32801
      GIM_Try, /*On fail goto*//*Label 717*/ 32856, // Rule ID 10646 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (xor:{ *:[i32] } (xor:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, -1:{ *:[i32] }), GPR32:{ *:[i32] }:$Rm)  =>  (EONWrr:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, GPR32:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::EONWrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 10646,
        GIR_Done,
      // Label 717: @32856
      GIM_Try, /*On fail goto*//*Label 718*/ 32911, // Rule ID 166 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, -1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (xor:{ *:[i32] } (xor:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, GPR32:{ *:[i32] }:$Rm), -1:{ *:[i32] })  =>  (EONWrr:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, GPR32:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::EONWrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 166,
        GIR_Done,
      // Label 718: @32911
      GIM_Try, /*On fail goto*//*Label 719*/ 32966, // Rule ID 10647 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (xor:{ *:[i32] } GPR32:{ *:[i32] }:$Rm, (xor:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, -1:{ *:[i32] }))  =>  (EONWrr:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, GPR32:{ *:[i32] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::EONWrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 10647,
        GIR_Done,
      // Label 719: @32966
      GIM_Try, /*On fail goto*//*Label 720*/ 33000, // Rule ID 7964 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, -1,
        // (xor:{ *:[i32] } GPR32:{ *:[i32] }:$Wm, -1:{ *:[i32] })  =>  (ORNWrr:{ *:[i32] } WZR:{ *:[i32] }, GPR32:{ *:[i32] }:$Wm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::ORNWrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_AddRegister, /*InsnID*/0, AArch64::WZR, /*AddRegisterRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Wm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 7964,
        GIR_Done,
      // Label 720: @33000
      GIM_Try, /*On fail goto*//*Label 721*/ 33021, // Rule ID 170 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR32RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR32RegClassID,
        // (xor:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, GPR32:{ *:[i32] }:$Rm)  =>  (EORWrr:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, GPR32:{ *:[i32] }:$Rm)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::EORWrr,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 170,
        GIR_Done,
      // Label 721: @33021
      GIM_Reject,
    // Label 707: @33022
    GIM_Reject,
    // Label 698: @33023
    GIM_Try, /*On fail goto*//*Label 722*/ 33755,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_Try, /*On fail goto*//*Label 723*/ 33088, // Rule ID 10658 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_logical_shifted_reg64,
        // (xor:{ *:[i64] } logical_shifted_reg64:{ *:[i64] }:$Rm_and_shift, (xor:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, -1:{ *:[i64] }))  =>  (EONXrs:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, logical_shifted_reg64:{ *:[i64] }:$Rm_and_shift)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::EONXrs,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/0, // Rm_and_shift
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 10658,
        GIR_Done,
      // Label 723: @33088
      GIM_Try, /*On fail goto*//*Label 724*/ 33143, // Rule ID 10657 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/0, GICP_gi_logical_shifted_reg64,
        // (xor:{ *:[i64] } (xor:{ *:[i64] } logical_shifted_reg64:{ *:[i64] }:$Rm_and_shift, -1:{ *:[i64] }), GPR64:{ *:[i64] }:$Rn)  =>  (EONXrs:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, logical_shifted_reg64:{ *:[i64] }:$Rm_and_shift)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::EONXrs,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/0, // Rm_and_shift
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 10657,
        GIR_Done,
      // Label 724: @33143
      GIM_Try, /*On fail goto*//*Label 725*/ 33198, // Rule ID 10655 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, -1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/0, GICP_gi_logical_shifted_reg64,
        // (xor:{ *:[i64] } (xor:{ *:[i64] } logical_shifted_reg64:{ *:[i64] }:$Rm_and_shift, GPR64:{ *:[i64] }:$Rn), -1:{ *:[i64] })  =>  (EONXrs:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, logical_shifted_reg64:{ *:[i64] }:$Rm_and_shift)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::EONXrs,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/0, // Rm_and_shift
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 10655,
        GIR_Done,
      // Label 725: @33198
      GIM_Try, /*On fail goto*//*Label 726*/ 33253, // Rule ID 169 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, -1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckComplexPattern, /*MI*/1, /*Op*/2, /*Renderer*/0, GICP_gi_logical_shifted_reg64,
        // (xor:{ *:[i64] } (xor:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, logical_shifted_reg64:{ *:[i64] }:$Rm_and_shift), -1:{ *:[i64] })  =>  (EONXrs:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, logical_shifted_reg64:{ *:[i64] }:$Rm_and_shift)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::EONXrs,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/0, // Rm_and_shift
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 169,
        GIR_Done,
      // Label 726: @33253
      GIM_Try, /*On fail goto*//*Label 727*/ 33308, // Rule ID 10656 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/0, GICP_gi_logical_shifted_reg64,
        // (xor:{ *:[i64] } (xor:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, -1:{ *:[i64] }), logical_shifted_reg64:{ *:[i64] }:$Rm_and_shift)  =>  (EONXrs:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, logical_shifted_reg64:{ *:[i64] }:$Rm_and_shift)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::EONXrs,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/0, // Rm_and_shift
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 10656,
        GIR_Done,
      // Label 727: @33308
      GIM_Try, /*On fail goto*//*Label 728*/ 33363, // Rule ID 10659 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/0, GICP_gi_logical_shifted_reg64,
        // (xor:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, (xor:{ *:[i64] } logical_shifted_reg64:{ *:[i64] }:$Rm_and_shift, -1:{ *:[i64] }))  =>  (EONXrs:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, logical_shifted_reg64:{ *:[i64] }:$Rm_and_shift)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::EONXrs,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/0, // Rm_and_shift
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 10659,
        GIR_Done,
      // Label 728: @33363
      GIM_Try, /*On fail goto*//*Label 729*/ 33405, // Rule ID 147 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64spRegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_CONSTANT,
        GIM_CheckAPIntImmPredicate, /*MI*/1, /*Predicate*/GIPFP_APInt_Predicate_logical_imm64,
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (xor:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, (imm:{ *:[i64] })<<P:Predicate_logical_imm64>><<X:logical_imm64_XFORM>>:$imm)  =>  (EORXri:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, (logical_imm64_XFORM:{ *:[i64] } (imm:{ *:[i64] }):$imm))
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::EORXri,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_CustomRenderer, /*InsnID*/0, /*OldInsnID*/1, /*Renderer*/GICR_renderLogicalImm64, // imm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 147,
        GIR_Done,
      // Label 729: @33405
      GIM_Try, /*On fail goto*//*Label 730*/ 33439, // Rule ID 10661 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/0, GICP_gi_logical_shifted_reg64,
        // (xor:{ *:[i64] } logical_shifted_reg64:{ *:[i64] }:$Rm_and_shift, GPR64:{ *:[i64] }:$Rn)  =>  (EORXrs:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, logical_shifted_reg64:{ *:[i64] }:$Rm_and_shift)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::EORXrs,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/0, // Rm_and_shift
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 10661,
        GIR_Done,
      // Label 730: @33439
      GIM_Try, /*On fail goto*//*Label 731*/ 33473, // Rule ID 173 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/0, GICP_gi_logical_shifted_reg64,
        // (xor:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, logical_shifted_reg64:{ *:[i64] }:$Rm_and_shift)  =>  (EORXrs:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, logical_shifted_reg64:{ *:[i64] }:$Rm_and_shift)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::EORXrs,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/0, // Rm_and_shift
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 173,
        GIR_Done,
      // Label 731: @33473
      GIM_Try, /*On fail goto*//*Label 732*/ 33528, // Rule ID 10648 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (xor:{ *:[i64] } (xor:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, -1:{ *:[i64] }), GPR64:{ *:[i64] }:$Rm)  =>  (EONXrr:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::EONXrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 10648,
        GIR_Done,
      // Label 732: @33528
      GIM_Try, /*On fail goto*//*Label 733*/ 33583, // Rule ID 167 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, -1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (xor:{ *:[i64] } (xor:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm), -1:{ *:[i64] })  =>  (EONXrr:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::EONXrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 167,
        GIR_Done,
      // Label 733: @33583
      GIM_Try, /*On fail goto*//*Label 734*/ 33638, // Rule ID 10649 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, -1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (xor:{ *:[i64] } GPR64:{ *:[i64] }:$Rm, (xor:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, -1:{ *:[i64] }))  =>  (EONXrr:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::EONXrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 10649,
        GIR_Done,
      // Label 734: @33638
      GIM_Try, /*On fail goto*//*Label 735*/ 33672, // Rule ID 7965 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, -1,
        // (xor:{ *:[i64] } GPR64:{ *:[i64] }:$Xm, -1:{ *:[i64] })  =>  (ORNXrr:{ *:[i64] } XZR:{ *:[i64] }, GPR64:{ *:[i64] }:$Xm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::ORNXrr,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_AddRegister, /*InsnID*/0, AArch64::XZR, /*AddRegisterRegFlags*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Xm
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 7965,
        GIR_Done,
      // Label 735: @33672
      GIM_Try, /*On fail goto*//*Label 736*/ 33710, // Rule ID 8559 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcodeIsEither, /*MI*/1, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (xor:{ *:[v1i64] } V64:{ *:[v1i64] }:$Rn, immAllOnesV:{ *:[v1i64] })  =>  (NOTv8i8:{ *:[v1i64] } V64:{ *:[v1i64] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::NOTv8i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 8559,
        GIR_Done,
      // Label 736: @33710
      GIM_Try, /*On fail goto*//*Label 737*/ 33731, // Rule ID 171 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::GPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::GPR64RegClassID,
        // (xor:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm)  =>  (EORXrr:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::EORXrr,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 171,
        GIR_Done,
      // Label 737: @33731
      GIM_Try, /*On fail goto*//*Label 738*/ 33754, // Rule ID 8649 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        // (xor:{ *:[v1i64] } V64:{ *:[v1i64] }:$LHS, V64:{ *:[v1i64] }:$RHS)  =>  (EORv8i8:{ *:[v1i64] } V64:{ *:[v1i64] }:$LHS, V64:{ *:[v1i64] }:$RHS)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::EORv8i8,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 8649,
        GIR_Done,
      // Label 738: @33754
      GIM_Reject,
    // Label 722: @33755
    GIM_Reject,
    // Label 699: @33756
    GIM_Try, /*On fail goto*//*Label 739*/ 33820,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      GIM_Try, /*On fail goto*//*Label 740*/ 33804, // Rule ID 8557 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcodeIsEither, /*MI*/1, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (xor:{ *:[v2i32] } V64:{ *:[v2i32] }:$Rn, immAllOnesV:{ *:[v2i32] })  =>  (NOTv8i8:{ *:[v2i32] } V64:{ *:[v2i32] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::NOTv8i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 8557,
        GIR_Done,
      // Label 740: @33804
      GIM_Try, /*On fail goto*//*Label 741*/ 33819, // Rule ID 8648 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        // (xor:{ *:[v2i32] } V64:{ *:[v2i32] }:$LHS, V64:{ *:[v2i32] }:$RHS)  =>  (EORv8i8:{ *:[v2i32] } V64:{ *:[v2i32] }:$LHS, V64:{ *:[v2i32] }:$RHS)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::EORv8i8,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 8648,
        GIR_Done,
      // Label 741: @33819
      GIM_Reject,
    // Label 739: @33820
    GIM_Reject,
    // Label 700: @33821
    GIM_Try, /*On fail goto*//*Label 742*/ 34347,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_Try, /*On fail goto*//*Label 743*/ 33921, // Rule ID 11655 //
        GIM_CheckFeatures, GIFBS_HasSHA3,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcodeIsEither, /*MI*/3, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/3,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (xor:{ *:[v2i64] } (and:{ *:[v2i64] } (xor:{ *:[v2i64] } V128:{ *:[v2i64] }:$Va, immAllOnesV:{ *:[v2i64] }), V128:{ *:[v2i64] }:$Vm), V128:{ *:[v2i64] }:$Vn)  =>  (BCAX:{ *:[v2i64] } V128:{ *:[v2i64] }:$Vn, V128:{ *:[v2i64] }:$Vm, V128:{ *:[v2i64] }:$Va)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::BCAX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Va
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11655,
        GIR_Done,
      // Label 743: @33921
      GIM_Try, /*On fail goto*//*Label 744*/ 34007, // Rule ID 11654 //
        GIM_CheckFeatures, GIFBS_HasSHA3,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcodeIsEither, /*MI*/3, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/3,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (xor:{ *:[v2i64] } (and:{ *:[v2i64] } V128:{ *:[v2i64] }:$Vm, (xor:{ *:[v2i64] } V128:{ *:[v2i64] }:$Va, immAllOnesV:{ *:[v2i64] })), V128:{ *:[v2i64] }:$Vn)  =>  (BCAX:{ *:[v2i64] } V128:{ *:[v2i64] }:$Vn, V128:{ *:[v2i64] }:$Vm, V128:{ *:[v2i64] }:$Va)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::BCAX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Va
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11654,
        GIR_Done,
      // Label 744: @34007
      GIM_Try, /*On fail goto*//*Label 745*/ 34093, // Rule ID 11653 //
        GIM_CheckFeatures, GIFBS_HasSHA3,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcodeIsEither, /*MI*/3, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/3,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (xor:{ *:[v2i64] } V128:{ *:[v2i64] }:$Vn, (and:{ *:[v2i64] } (xor:{ *:[v2i64] } V128:{ *:[v2i64] }:$Va, immAllOnesV:{ *:[v2i64] }), V128:{ *:[v2i64] }:$Vm))  =>  (BCAX:{ *:[v2i64] } V128:{ *:[v2i64] }:$Vn, V128:{ *:[v2i64] }:$Vm, V128:{ *:[v2i64] }:$Va)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::BCAX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Va
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11653,
        GIR_Done,
      // Label 745: @34093
      GIM_Try, /*On fail goto*//*Label 746*/ 34179, // Rule ID 7795 //
        GIM_CheckFeatures, GIFBS_HasSHA3,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcodeIsEither, /*MI*/3, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (xor:{ *:[v2i64] } V128:{ *:[v2i64] }:$Vn, (and:{ *:[v2i64] } V128:{ *:[v2i64] }:$Vm, (xor:{ *:[v2i64] } V128:{ *:[v2i64] }:$Va, immAllOnesV:{ *:[v2i64] })))  =>  (BCAX:{ *:[v2i64] } V128:{ *:[v2i64] }:$Vn, V128:{ *:[v2i64] }:$Vm, V128:{ *:[v2i64] }:$Va)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::BCAX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Va
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 7795,
        GIR_Done,
      // Label 746: @34179
      GIM_Try, /*On fail goto*//*Label 747*/ 34213, // Rule ID 8560 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcodeIsEither, /*MI*/1, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (xor:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rn, immAllOnesV:{ *:[v2i64] })  =>  (NOTv16i8:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::NOTv16i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 8560,
        GIR_Done,
      // Label 747: @34213
      GIM_Try, /*On fail goto*//*Label 748*/ 34270, // Rule ID 7791 //
        GIM_CheckFeatures, GIFBS_HasSHA3,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (xor:{ *:[v2i64] } (xor:{ *:[v2i64] } V128:{ *:[v2i64] }:$Vn, V128:{ *:[v2i64] }:$Vm), V128:{ *:[v2i64] }:$Va)  =>  (EOR3:{ *:[v2i64] } V128:{ *:[v2i64] }:$Vn, V128:{ *:[v2i64] }:$Vm, V128:{ *:[v2i64] }:$Va)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::EOR3,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Va
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 7791,
        GIR_Done,
      // Label 748: @34270
      GIM_Try, /*On fail goto*//*Label 749*/ 34327, // Rule ID 11643 //
        GIM_CheckFeatures, GIFBS_HasSHA3,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (xor:{ *:[v2i64] } V128:{ *:[v2i64] }:$Va, (xor:{ *:[v2i64] } V128:{ *:[v2i64] }:$Vn, V128:{ *:[v2i64] }:$Vm))  =>  (EOR3:{ *:[v2i64] } V128:{ *:[v2i64] }:$Vn, V128:{ *:[v2i64] }:$Vm, V128:{ *:[v2i64] }:$Va)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::EOR3,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Va
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11643,
        GIR_Done,
      // Label 749: @34327
      GIM_Try, /*On fail goto*//*Label 750*/ 34346, // Rule ID 8652 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        // (xor:{ *:[v2i64] } V128:{ *:[v2i64] }:$LHS, V128:{ *:[v2i64] }:$RHS)  =>  (EORv16i8:{ *:[v2i64] } V128:{ *:[v2i64] }:$LHS, V128:{ *:[v2i64] }:$RHS)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::EORv16i8,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 8652,
        GIR_Done,
      // Label 750: @34346
      GIM_Reject,
    // Label 742: @34347
    GIM_Reject,
    // Label 701: @34348
    GIM_Try, /*On fail goto*//*Label 751*/ 34412,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      GIM_Try, /*On fail goto*//*Label 752*/ 34396, // Rule ID 8555 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcodeIsEither, /*MI*/1, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (xor:{ *:[v4i16] } V64:{ *:[v4i16] }:$Rn, immAllOnesV:{ *:[v4i16] })  =>  (NOTv8i8:{ *:[v4i16] } V64:{ *:[v4i16] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::NOTv8i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 8555,
        GIR_Done,
      // Label 752: @34396
      GIM_Try, /*On fail goto*//*Label 753*/ 34411, // Rule ID 8647 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        // (xor:{ *:[v4i16] } V64:{ *:[v4i16] }:$LHS, V64:{ *:[v4i16] }:$RHS)  =>  (EORv8i8:{ *:[v4i16] } V64:{ *:[v4i16] }:$LHS, V64:{ *:[v4i16] }:$RHS)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::EORv8i8,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 8647,
        GIR_Done,
      // Label 753: @34411
      GIM_Reject,
    // Label 751: @34412
    GIM_Reject,
    // Label 702: @34413
    GIM_Try, /*On fail goto*//*Label 754*/ 34939,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_Try, /*On fail goto*//*Label 755*/ 34513, // Rule ID 11652 //
        GIM_CheckFeatures, GIFBS_HasSHA3,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcodeIsEither, /*MI*/3, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/3,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (xor:{ *:[v4i32] } (and:{ *:[v4i32] } (xor:{ *:[v4i32] } V128:{ *:[v4i32] }:$Va, immAllOnesV:{ *:[v4i32] }), V128:{ *:[v4i32] }:$Vm), V128:{ *:[v4i32] }:$Vn)  =>  (BCAX:{ *:[v4i32] } V128:{ *:[v4i32] }:$Vn, V128:{ *:[v4i32] }:$Vm, V128:{ *:[v4i32] }:$Va)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::BCAX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Va
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11652,
        GIR_Done,
      // Label 755: @34513
      GIM_Try, /*On fail goto*//*Label 756*/ 34599, // Rule ID 11651 //
        GIM_CheckFeatures, GIFBS_HasSHA3,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcodeIsEither, /*MI*/3, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/3,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (xor:{ *:[v4i32] } (and:{ *:[v4i32] } V128:{ *:[v4i32] }:$Vm, (xor:{ *:[v4i32] } V128:{ *:[v4i32] }:$Va, immAllOnesV:{ *:[v4i32] })), V128:{ *:[v4i32] }:$Vn)  =>  (BCAX:{ *:[v4i32] } V128:{ *:[v4i32] }:$Vn, V128:{ *:[v4i32] }:$Vm, V128:{ *:[v4i32] }:$Va)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::BCAX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Va
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11651,
        GIR_Done,
      // Label 756: @34599
      GIM_Try, /*On fail goto*//*Label 757*/ 34685, // Rule ID 11650 //
        GIM_CheckFeatures, GIFBS_HasSHA3,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcodeIsEither, /*MI*/3, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/3,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (xor:{ *:[v4i32] } V128:{ *:[v4i32] }:$Vn, (and:{ *:[v4i32] } (xor:{ *:[v4i32] } V128:{ *:[v4i32] }:$Va, immAllOnesV:{ *:[v4i32] }), V128:{ *:[v4i32] }:$Vm))  =>  (BCAX:{ *:[v4i32] } V128:{ *:[v4i32] }:$Vn, V128:{ *:[v4i32] }:$Vm, V128:{ *:[v4i32] }:$Va)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::BCAX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Va
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11650,
        GIR_Done,
      // Label 757: @34685
      GIM_Try, /*On fail goto*//*Label 758*/ 34771, // Rule ID 7794 //
        GIM_CheckFeatures, GIFBS_HasSHA3,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcodeIsEither, /*MI*/3, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (xor:{ *:[v4i32] } V128:{ *:[v4i32] }:$Vn, (and:{ *:[v4i32] } V128:{ *:[v4i32] }:$Vm, (xor:{ *:[v4i32] } V128:{ *:[v4i32] }:$Va, immAllOnesV:{ *:[v4i32] })))  =>  (BCAX:{ *:[v4i32] } V128:{ *:[v4i32] }:$Vn, V128:{ *:[v4i32] }:$Vm, V128:{ *:[v4i32] }:$Va)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::BCAX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Va
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 7794,
        GIR_Done,
      // Label 758: @34771
      GIM_Try, /*On fail goto*//*Label 759*/ 34805, // Rule ID 8558 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcodeIsEither, /*MI*/1, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (xor:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rn, immAllOnesV:{ *:[v4i32] })  =>  (NOTv16i8:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::NOTv16i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 8558,
        GIR_Done,
      // Label 759: @34805
      GIM_Try, /*On fail goto*//*Label 760*/ 34862, // Rule ID 7790 //
        GIM_CheckFeatures, GIFBS_HasSHA3,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (xor:{ *:[v4i32] } (xor:{ *:[v4i32] } V128:{ *:[v4i32] }:$Vn, V128:{ *:[v4i32] }:$Vm), V128:{ *:[v4i32] }:$Va)  =>  (EOR3:{ *:[v4i32] } V128:{ *:[v4i32] }:$Vn, V128:{ *:[v4i32] }:$Vm, V128:{ *:[v4i32] }:$Va)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::EOR3,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Va
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 7790,
        GIR_Done,
      // Label 760: @34862
      GIM_Try, /*On fail goto*//*Label 761*/ 34919, // Rule ID 11642 //
        GIM_CheckFeatures, GIFBS_HasSHA3,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (xor:{ *:[v4i32] } V128:{ *:[v4i32] }:$Va, (xor:{ *:[v4i32] } V128:{ *:[v4i32] }:$Vn, V128:{ *:[v4i32] }:$Vm))  =>  (EOR3:{ *:[v4i32] } V128:{ *:[v4i32] }:$Vn, V128:{ *:[v4i32] }:$Vm, V128:{ *:[v4i32] }:$Va)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::EOR3,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Va
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11642,
        GIR_Done,
      // Label 761: @34919
      GIM_Try, /*On fail goto*//*Label 762*/ 34938, // Rule ID 8651 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        // (xor:{ *:[v4i32] } V128:{ *:[v4i32] }:$LHS, V128:{ *:[v4i32] }:$RHS)  =>  (EORv16i8:{ *:[v4i32] } V128:{ *:[v4i32] }:$LHS, V128:{ *:[v4i32] }:$RHS)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::EORv16i8,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 8651,
        GIR_Done,
      // Label 762: @34938
      GIM_Reject,
    // Label 754: @34939
    GIM_Reject,
    // Label 703: @34940
    GIM_Try, /*On fail goto*//*Label 763*/ 35006,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR64RegClassID,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
      GIM_Try, /*On fail goto*//*Label 764*/ 34990, // Rule ID 945 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcodeIsEither, /*MI*/1, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (xor:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rn, immAllOnesV:{ *:[v8i8] })  =>  (NOTv8i8:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::NOTv8i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 945,
        GIR_Done,
      // Label 764: @34990
      GIM_Try, /*On fail goto*//*Label 765*/ 35005, // Rule ID 1562 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
        // (xor:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm)  =>  (EORv8i8:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::EORv8i8,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1562,
        GIR_Done,
      // Label 765: @35005
      GIM_Reject,
    // Label 763: @35006
    GIM_Reject,
    // Label 704: @35007
    GIM_Try, /*On fail goto*//*Label 766*/ 36033,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_Try, /*On fail goto*//*Label 767*/ 35146, // Rule ID 11726 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ADD,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_SUB,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/2, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/4, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/1, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, AArch64::G_VASHR,
        GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_v8s16,
        // MIs[5] Operand 2
        GIM_CheckLiteralInt, /*MI*/5, /*Op*/2, 15,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/0, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, AArch64::G_VASHR,
        // MIs[6] src
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/5, /*OtherOpIdx*/1,
        // MIs[6] Operand 2
        GIM_CheckLiteralInt, /*MI*/6, /*Op*/2, 15,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        GIM_CheckIsSafeToFold, /*InsnID*/5,
        GIM_CheckIsSafeToFold, /*InsnID*/6,
        // (xor:{ *:[v8i16] } (add:{ *:[v8i16] } (sub:{ *:[v8i16] } (zext:{ *:[v8i16] } V64:{ *:[v8i8] }:$opA), (zext:{ *:[v8i16] } V64:{ *:[v8i8] }:$opB)), (AArch64vashr:{ *:[v8i16] } v8i16:{ *:[v8i16] }:$src, 15:{ *:[i32] })), (AArch64vashr:{ *:[v8i16] } v8i16:{ *:[v8i16] }:$src, 15:{ *:[i32] }))  =>  (UABDLv8i8_v8i16:{ *:[v8i16] } V64:{ *:[v8i8] }:$opA, V64:{ *:[v8i8] }:$opB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UABDLv8i8_v8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // opA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/1, // opB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11726,
        GIR_Done,
      // Label 767: @35146
      GIM_Try, /*On fail goto*//*Label 768*/ 35271, // Rule ID 11727 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_ADD,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, AArch64::G_VASHR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s16,
        // MIs[2] Operand 2
        GIM_CheckLiteralInt, /*MI*/2, /*Op*/2, 15,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_SUB,
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/4, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/3, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/5, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/0, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, AArch64::G_VASHR,
        // MIs[6] src
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        // MIs[6] Operand 2
        GIM_CheckLiteralInt, /*MI*/6, /*Op*/2, 15,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        GIM_CheckIsSafeToFold, /*InsnID*/5,
        GIM_CheckIsSafeToFold, /*InsnID*/6,
        // (xor:{ *:[v8i16] } (add:{ *:[v8i16] } (AArch64vashr:{ *:[v8i16] } v8i16:{ *:[v8i16] }:$src, 15:{ *:[i32] }), (sub:{ *:[v8i16] } (zext:{ *:[v8i16] } V64:{ *:[v8i8] }:$opA), (zext:{ *:[v8i16] } V64:{ *:[v8i8] }:$opB))), (AArch64vashr:{ *:[v8i16] } v8i16:{ *:[v8i16] }:$src, 15:{ *:[i32] }))  =>  (UABDLv8i8_v8i16:{ *:[v8i16] } V64:{ *:[v8i8] }:$opA, V64:{ *:[v8i8] }:$opB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UABDLv8i8_v8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/1, // opA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/5, /*OpIdx*/1, // opB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11727,
        GIR_Done,
      // Label 768: @35271
      GIM_Try, /*On fail goto*//*Label 769*/ 35396, // Rule ID 8507 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, AArch64::G_VASHR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s16,
        // MIs[1] Operand 2
        GIM_CheckLiteralInt, /*MI*/1, /*Op*/2, 15,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_ADD,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_SUB,
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/4, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/3, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/5, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/2, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, AArch64::G_VASHR,
        // MIs[6] src
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
        // MIs[6] Operand 2
        GIM_CheckLiteralInt, /*MI*/6, /*Op*/2, 15,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        GIM_CheckIsSafeToFold, /*InsnID*/5,
        GIM_CheckIsSafeToFold, /*InsnID*/6,
        // (xor:{ *:[v8i16] } (AArch64vashr:{ *:[v8i16] } v8i16:{ *:[v8i16] }:$src, 15:{ *:[i32] }), (add:{ *:[v8i16] } (sub:{ *:[v8i16] } (zext:{ *:[v8i16] } V64:{ *:[v8i8] }:$opA), (zext:{ *:[v8i16] } V64:{ *:[v8i8] }:$opB)), (AArch64vashr:{ *:[v8i16] } v8i16:{ *:[v8i16] }:$src, 15:{ *:[i32] })))  =>  (UABDLv8i8_v8i16:{ *:[v8i16] } V64:{ *:[v8i8] }:$opA, V64:{ *:[v8i8] }:$opB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UABDLv8i8_v8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/1, // opA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/5, /*OpIdx*/1, // opB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 8507,
        GIR_Done,
      // Label 769: @35396
      GIM_Try, /*On fail goto*//*Label 770*/ 35521, // Rule ID 11725 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, AArch64::G_VASHR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s16,
        // MIs[1] Operand 2
        GIM_CheckLiteralInt, /*MI*/1, /*Op*/2, 15,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_ADD,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, AArch64::G_VASHR,
        // MIs[3] src
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
        // MIs[3] Operand 2
        GIM_CheckLiteralInt, /*MI*/3, /*Op*/2, 15,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/2, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, TargetOpcode::G_SUB,
        GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/5, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/4, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, TargetOpcode::G_ZEXT,
        GIM_CheckType, /*MI*/6, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/6, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/4,
        GIM_CheckIsSafeToFold, /*InsnID*/5,
        GIM_CheckIsSafeToFold, /*InsnID*/6,
        // (xor:{ *:[v8i16] } (AArch64vashr:{ *:[v8i16] } v8i16:{ *:[v8i16] }:$src, 15:{ *:[i32] }), (add:{ *:[v8i16] } (AArch64vashr:{ *:[v8i16] } v8i16:{ *:[v8i16] }:$src, 15:{ *:[i32] }), (sub:{ *:[v8i16] } (zext:{ *:[v8i16] } V64:{ *:[v8i8] }:$opA), (zext:{ *:[v8i16] } V64:{ *:[v8i8] }:$opB))))  =>  (UABDLv8i8_v8i16:{ *:[v8i16] } V64:{ *:[v8i8] }:$opA, V64:{ *:[v8i8] }:$opB)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UABDLv8i8_v8i16,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/5, /*OpIdx*/1, // opA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/6, /*OpIdx*/1, // opB
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11725,
        GIR_Done,
      // Label 770: @35521
      GIM_Try, /*On fail goto*//*Label 771*/ 35607, // Rule ID 11649 //
        GIM_CheckFeatures, GIFBS_HasSHA3,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcodeIsEither, /*MI*/3, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/3,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (xor:{ *:[v8i16] } (and:{ *:[v8i16] } (xor:{ *:[v8i16] } V128:{ *:[v8i16] }:$Va, immAllOnesV:{ *:[v8i16] }), V128:{ *:[v8i16] }:$Vm), V128:{ *:[v8i16] }:$Vn)  =>  (BCAX:{ *:[v8i16] } V128:{ *:[v8i16] }:$Vn, V128:{ *:[v8i16] }:$Vm, V128:{ *:[v8i16] }:$Va)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::BCAX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Va
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11649,
        GIR_Done,
      // Label 771: @35607
      GIM_Try, /*On fail goto*//*Label 772*/ 35693, // Rule ID 11648 //
        GIM_CheckFeatures, GIFBS_HasSHA3,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcodeIsEither, /*MI*/3, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/3,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (xor:{ *:[v8i16] } (and:{ *:[v8i16] } V128:{ *:[v8i16] }:$Vm, (xor:{ *:[v8i16] } V128:{ *:[v8i16] }:$Va, immAllOnesV:{ *:[v8i16] })), V128:{ *:[v8i16] }:$Vn)  =>  (BCAX:{ *:[v8i16] } V128:{ *:[v8i16] }:$Vn, V128:{ *:[v8i16] }:$Vm, V128:{ *:[v8i16] }:$Va)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::BCAX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Va
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11648,
        GIR_Done,
      // Label 772: @35693
      GIM_Try, /*On fail goto*//*Label 773*/ 35779, // Rule ID 11647 //
        GIM_CheckFeatures, GIFBS_HasSHA3,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcodeIsEither, /*MI*/3, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/3,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (xor:{ *:[v8i16] } V128:{ *:[v8i16] }:$Vn, (and:{ *:[v8i16] } (xor:{ *:[v8i16] } V128:{ *:[v8i16] }:$Va, immAllOnesV:{ *:[v8i16] }), V128:{ *:[v8i16] }:$Vm))  =>  (BCAX:{ *:[v8i16] } V128:{ *:[v8i16] }:$Vn, V128:{ *:[v8i16] }:$Vm, V128:{ *:[v8i16] }:$Va)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::BCAX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Va
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11647,
        GIR_Done,
      // Label 773: @35779
      GIM_Try, /*On fail goto*//*Label 774*/ 35865, // Rule ID 7793 //
        GIM_CheckFeatures, GIFBS_HasSHA3,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcodeIsEither, /*MI*/3, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (xor:{ *:[v8i16] } V128:{ *:[v8i16] }:$Vn, (and:{ *:[v8i16] } V128:{ *:[v8i16] }:$Vm, (xor:{ *:[v8i16] } V128:{ *:[v8i16] }:$Va, immAllOnesV:{ *:[v8i16] })))  =>  (BCAX:{ *:[v8i16] } V128:{ *:[v8i16] }:$Vn, V128:{ *:[v8i16] }:$Vm, V128:{ *:[v8i16] }:$Va)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::BCAX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Va
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 7793,
        GIR_Done,
      // Label 774: @35865
      GIM_Try, /*On fail goto*//*Label 775*/ 35899, // Rule ID 8556 //
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcodeIsEither, /*MI*/1, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (xor:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rn, immAllOnesV:{ *:[v8i16] })  =>  (NOTv16i8:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::NOTv16i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 8556,
        GIR_Done,
      // Label 775: @35899
      GIM_Try, /*On fail goto*//*Label 776*/ 35956, // Rule ID 7789 //
        GIM_CheckFeatures, GIFBS_HasSHA3,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (xor:{ *:[v8i16] } (xor:{ *:[v8i16] } V128:{ *:[v8i16] }:$Vn, V128:{ *:[v8i16] }:$Vm), V128:{ *:[v8i16] }:$Va)  =>  (EOR3:{ *:[v8i16] } V128:{ *:[v8i16] }:$Vn, V128:{ *:[v8i16] }:$Vm, V128:{ *:[v8i16] }:$Va)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::EOR3,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Va
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 7789,
        GIR_Done,
      // Label 776: @35956
      GIM_Try, /*On fail goto*//*Label 777*/ 36013, // Rule ID 11641 //
        GIM_CheckFeatures, GIFBS_HasSHA3,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (xor:{ *:[v8i16] } V128:{ *:[v8i16] }:$Va, (xor:{ *:[v8i16] } V128:{ *:[v8i16] }:$Vn, V128:{ *:[v8i16] }:$Vm))  =>  (EOR3:{ *:[v8i16] } V128:{ *:[v8i16] }:$Vn, V128:{ *:[v8i16] }:$Vm, V128:{ *:[v8i16] }:$Va)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::EOR3,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Va
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11641,
        GIR_Done,
      // Label 777: @36013
      GIM_Try, /*On fail goto*//*Label 778*/ 36032, // Rule ID 8650 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        // (xor:{ *:[v8i16] } V128:{ *:[v8i16] }:$LHS, V128:{ *:[v8i16] }:$RHS)  =>  (EORv16i8:{ *:[v8i16] } V128:{ *:[v8i16] }:$LHS, V128:{ *:[v8i16] }:$RHS)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::EORv16i8,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 8650,
        GIR_Done,
      // Label 778: @36032
      GIM_Reject,
    // Label 766: @36033
    GIM_Reject,
    // Label 705: @36034
    GIM_Try, /*On fail goto*//*Label 779*/ 36562,
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
      GIM_Try, /*On fail goto*//*Label 780*/ 36134, // Rule ID 11646 //
        GIM_CheckFeatures, GIFBS_HasSHA3,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcodeIsEither, /*MI*/3, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/3,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (xor:{ *:[v16i8] } (and:{ *:[v16i8] } (xor:{ *:[v16i8] } V128:{ *:[v16i8] }:$Va, immAllOnesV:{ *:[v16i8] }), V128:{ *:[v16i8] }:$Vm), V128:{ *:[v16i8] }:$Vn)  =>  (BCAX:{ *:[v16i8] } V128:{ *:[v16i8] }:$Vn, V128:{ *:[v16i8] }:$Vm, V128:{ *:[v16i8] }:$Va)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::BCAX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Va
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11646,
        GIR_Done,
      // Label 780: @36134
      GIM_Try, /*On fail goto*//*Label 781*/ 36220, // Rule ID 11645 //
        GIM_CheckFeatures, GIFBS_HasSHA3,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcodeIsEither, /*MI*/3, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/3,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (xor:{ *:[v16i8] } (and:{ *:[v16i8] } V128:{ *:[v16i8] }:$Vm, (xor:{ *:[v16i8] } V128:{ *:[v16i8] }:$Va, immAllOnesV:{ *:[v16i8] })), V128:{ *:[v16i8] }:$Vn)  =>  (BCAX:{ *:[v16i8] } V128:{ *:[v16i8] }:$Vn, V128:{ *:[v16i8] }:$Vm, V128:{ *:[v16i8] }:$Va)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::BCAX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Va
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11645,
        GIR_Done,
      // Label 781: @36220
      GIM_Try, /*On fail goto*//*Label 782*/ 36306, // Rule ID 11644 //
        GIM_CheckFeatures, GIFBS_HasSHA3,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcodeIsEither, /*MI*/3, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/3,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (xor:{ *:[v16i8] } V128:{ *:[v16i8] }:$Vn, (and:{ *:[v16i8] } (xor:{ *:[v16i8] } V128:{ *:[v16i8] }:$Va, immAllOnesV:{ *:[v16i8] }), V128:{ *:[v16i8] }:$Vm))  =>  (BCAX:{ *:[v16i8] } V128:{ *:[v16i8] }:$Vn, V128:{ *:[v16i8] }:$Vm, V128:{ *:[v16i8] }:$Va)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::BCAX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Va
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11644,
        GIR_Done,
      // Label 782: @36306
      GIM_Try, /*On fail goto*//*Label 783*/ 36392, // Rule ID 7792 //
        GIM_CheckFeatures, GIFBS_HasSHA3,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_AND,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcodeIsEither, /*MI*/3, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/3,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckIsSafeToFold, /*InsnID*/3,
        // (xor:{ *:[v16i8] } V128:{ *:[v16i8] }:$Vn, (and:{ *:[v16i8] } V128:{ *:[v16i8] }:$Vm, (xor:{ *:[v16i8] } V128:{ *:[v16i8] }:$Va, immAllOnesV:{ *:[v16i8] })))  =>  (BCAX:{ *:[v16i8] } V128:{ *:[v16i8] }:$Vn, V128:{ *:[v16i8] }:$Vm, V128:{ *:[v16i8] }:$Va)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::BCAX,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Va
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 7792,
        GIR_Done,
      // Label 783: @36392
      GIM_Try, /*On fail goto*//*Label 784*/ 36428, // Rule ID 946 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcodeIsEither, /*MI*/1, TargetOpcode::G_BUILD_VECTOR, TargetOpcode::G_BUILD_VECTOR_TRUNC,
        GIM_CheckIsBuildVectorAllOnes, /*MI*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (xor:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rn, immAllOnesV:{ *:[v16i8] })  =>  (NOTv16i8:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rn)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::NOTv16i8,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 946,
        GIR_Done,
      // Label 784: @36428
      GIM_Try, /*On fail goto*//*Label 785*/ 36485, // Rule ID 7788 //
        GIM_CheckFeatures, GIFBS_HasSHA3,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (xor:{ *:[v16i8] } (xor:{ *:[v16i8] } V128:{ *:[v16i8] }:$Vn, V128:{ *:[v16i8] }:$Vm), V128:{ *:[v16i8] }:$Va)  =>  (EOR3:{ *:[v16i8] } V128:{ *:[v16i8] }:$Vn, V128:{ *:[v16i8] }:$Vm, V128:{ *:[v16i8] }:$Va)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::EOR3,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // Va
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 7788,
        GIR_Done,
      // Label 785: @36485
      GIM_Try, /*On fail goto*//*Label 786*/ 36542, // Rule ID 11640 //
        GIM_CheckFeatures, GIFBS_HasSHA3,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_XOR,
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (xor:{ *:[v16i8] } V128:{ *:[v16i8] }:$Va, (xor:{ *:[v16i8] } V128:{ *:[v16i8] }:$Vn, V128:{ *:[v16i8] }:$Vm))  =>  (EOR3:{ *:[v16i8] } V128:{ *:[v16i8] }:$Vn, V128:{ *:[v16i8] }:$Vm, V128:{ *:[v16i8] }:$Va)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::EOR3,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Vd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vm
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Va
        GIR_EraseFromParent, /*InsnID*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 11640,
        GIR_Done,
      // Label 786: @36542
      GIM_Try, /*On fail goto*//*Label 787*/ 36561, // Rule ID 1563 //
        GIM_CheckFeatures, GIFBS_HasNEON,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
        // (xor:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rn, V128:{ *:[v16i8] }:$Rm)  =>  (EORv16i8:{ *:[v16i8] } V128:{ *:[v16i8] }:$Rn, V128:{ *:[v16i8] }:$Rm)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/AArch64::EORv16i8,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 1563,
        GIR_Done,
      // Label 787: @36561
      GIM_Reject,
    // Label 779: @36562
    GIM_Reject,
    // Label 706: @36563
    GIM_Reject,
    // Label 8: @36564
    GIM_Try, /*On fail goto*//*Label 788*/ 44955,
      GIM_CheckNumOperands, /*MI*/0, /*Expected*/3,
      GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/5, 11, /*)*//*default:*//*Label 793*/ 44954,
      /*GILLT_v2s64*//*Label 789*/ 36581, 0,
      /*GILLT_v4s32*//*Label 790*/ 36957, 0,
      /*GILLT_v8s16*//*Label 791*/ 39965,
      /*GILLT_v16s8*//*Label 792*/ 42633,
      // Label 789: @36581
      GIM_Try, /*On fail goto*//*Label 794*/ 36956,
        GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
        GIM_Try, /*On fail goto*//*Label 795*/ 36655, // Rule ID 9066 //
          GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
          GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_IMPLICIT_DEF,
          GIM_CheckIsSafeToFold, /*InsnID*/1,
          // (concat_vectors:{ *:[v2i64] } V64:{ *:[v1i64] }:$Rn, (undef:{ *:[v1i64] }))  =>  (INSERT_SUBREG:{ *:[v2i64] } (IMPLICIT_DEF:{ *:[v2i64] }), V64:{ *:[v1i64] }:$Rn, dsub:{ *:[i32] })
          GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v2s64,
          GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
          GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
          GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::INSERT_SUBREG,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
          GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
          GIR_AddImm, /*InsnID*/0, /*Imm*/2,
          GIR_EraseFromParent, /*InsnID*/0,
          GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AArch64::FPR128RegClassID,
          GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, AArch64::FPR128RegClassID,
          GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/2, AArch64::FPR64RegClassID,
          // GIR_Coverage, 9066,
          GIR_Done,
        // Label 795: @36655
        GIM_Try, /*On fail goto*//*Label 796*/ 36711, // Rule ID 9067 //
          GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
          GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_IMPLICIT_DEF,
          GIM_CheckIsSafeToFold, /*InsnID*/1,
          // (concat_vectors:{ *:[v2f64] } V64:{ *:[v1f64] }:$Rn, (undef:{ *:[v1f64] }))  =>  (INSERT_SUBREG:{ *:[v2f64] } (IMPLICIT_DEF:{ *:[v2f64] }), V64:{ *:[v1f64] }:$Rn, dsub:{ *:[i32] })
          GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v2s64,
          GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
          GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
          GIR_BuildMI, /*InsnID*/0, /*Opcode*/TargetOpcode::INSERT_SUBREG,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
          GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // Rn
          GIR_AddImm, /*InsnID*/0, /*Imm*/2,
          GIR_EraseFromParent, /*InsnID*/0,
          GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, AArch64::FPR128RegClassID,
          GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, AArch64::FPR128RegClassID,
          GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/2, AArch64::FPR64RegClassID,
          // GIR_Coverage, 9067,
          GIR_Done,
        // Label 796: @36711
        GIM_Try, /*On fail goto*//*Label 797*/ 36833, // Rule ID 9058 //
          GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
          // (concat_vectors:{ *:[v2i64] } V64:{ *:[v1i64] }:$Rd, V64:{ *:[v1i64] }:$Rn)  =>  (INSvi64lane:{ *:[v2i64] } (INSERT_SUBREG:{ *:[f128] } (IMPLICIT_DEF:{ *:[f128] }), V64:{ *:[v1i64] }:$Rd, dsub:{ *:[i32] }), 1:{ *:[i64] }, (INSERT_SUBREG:{ *:[f128] } (IMPLICIT_DEF:{ *:[f128] }), V64:{ *:[v1i64] }:$Rn, dsub:{ *:[i32] }), 0:{ *:[i64] })
          GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s128,
          GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s128,
          GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s128,
          GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s128,
          GIR_BuildMI, /*InsnID*/4, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
          GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/RegState::Define,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/4,
          GIR_BuildMI, /*InsnID*/3, /*Opcode*/TargetOpcode::INSERT_SUBREG,
          GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/RegState::Define,
          GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/3, /*TempRegFlags*/0,
          GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/0, /*OpIdx*/2, // Rn
          GIR_AddImm, /*InsnID*/3, /*Imm*/2,
          GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, AArch64::FPR128RegClassID,
          GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/1, AArch64::FPR128RegClassID,
          GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/2, AArch64::FPR64RegClassID,
          GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
          GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
          GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::INSERT_SUBREG,
          GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
          GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
          GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // Rd
          GIR_AddImm, /*InsnID*/1, /*Imm*/2,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, AArch64::FPR128RegClassID,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, AArch64::FPR128RegClassID,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/2, AArch64::FPR64RegClassID,
          GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::INSvi64lane,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
          GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
          GIR_AddImm, /*InsnID*/0, /*Imm*/1,
          GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/2, /*TempRegFlags*/0,
          GIR_AddImm, /*InsnID*/0, /*Imm*/0,
          GIR_EraseFromParent, /*InsnID*/0,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
          // GIR_Coverage, 9058,
          GIR_Done,
        // Label 797: @36833
        GIM_Try, /*On fail goto*//*Label 798*/ 36955, // Rule ID 9059 //
          GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/AArch64::FPR64RegClassID,
          // (concat_vectors:{ *:[v2f64] } V64:{ *:[v1f64] }:$Rd, V64:{ *:[v1f64] }:$Rn)  =>  (INSvi64lane:{ *:[v2f64] } (INSERT_SUBREG:{ *:[f128] } (IMPLICIT_DEF:{ *:[f128] }), V64:{ *:[v1f64] }:$Rd, dsub:{ *:[i32] }), 1:{ *:[i64] }, (INSERT_SUBREG:{ *:[f128] } (IMPLICIT_DEF:{ *:[f128] }), V64:{ *:[v1f64] }:$Rn, dsub:{ *:[i32] }), 0:{ *:[i64] })
          GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s128,
          GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s128,
          GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s128,
          GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s128,
          GIR_BuildMI, /*InsnID*/4, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
          GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/RegState::Define,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/4,
          GIR_BuildMI, /*InsnID*/3, /*Opcode*/TargetOpcode::INSERT_SUBREG,
          GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/RegState::Define,
          GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/3, /*TempRegFlags*/0,
          GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/0, /*OpIdx*/2, // Rn
          GIR_AddImm, /*InsnID*/3, /*Imm*/2,
          GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, AArch64::FPR128RegClassID,
          GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/1, AArch64::FPR128RegClassID,
          GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/2, AArch64::FPR64RegClassID,
          GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
          GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
          GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::INSERT_SUBREG,
          GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
          GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
          GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // Rd
          GIR_AddImm, /*InsnID*/1, /*Imm*/2,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, AArch64::FPR128RegClassID,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, AArch64::FPR128RegClassID,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/2, AArch64::FPR64RegClassID,
          GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::INSvi64lane,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
          GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
          GIR_AddImm, /*InsnID*/0, /*Imm*/1,
          GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/2, /*TempRegFlags*/0,
          GIR_AddImm, /*InsnID*/0, /*Imm*/0,
          GIR_EraseFromParent, /*InsnID*/0,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
          // GIR_Coverage, 9059,
          GIR_Done,
        // Label 798: @36955
        GIM_Reject,
      // Label 794: @36956
      GIM_Reject,
      // Label 790: @36957
      GIM_Try, /*On fail goto*//*Label 799*/ 39964,
        GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/AArch64::FPR128RegClassID,
        GIM_Try, /*On fail goto*//*Label 800*/ 37129, // Rule ID 11792 //
          GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
          GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
          GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_TRUNC,
          GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s64,
          GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
          GIM_CheckOpcode, /*MI*/2, AArch64::G_VLSHR,
          GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v2s64,
          GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
          GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_ADD,
          GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v2s64,
          GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v2s64,
          GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
          GIM_CheckOpcode, /*MI*/4, AArch64::G_DUP,
          GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s64,
          GIM_CheckConstantInt, /*MI*/4, /*Op*/1, 2147483648,
          GIM_CheckRegBankForClass, /*MI*/3, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
          // MIs[2] Operand 2
          GIM_CheckLiteralInt, /*MI*/2, /*Op*/2, 32,
          GIM_CheckIsSafeToFold, /*InsnID*/1,
          GIM_CheckIsSafeToFold, /*InsnID*/2,
          GIM_CheckIsSafeToFold, /*InsnID*/3,
          GIM_CheckIsSafeToFold, /*InsnID*/4,
          // (concat_vectors:{ *:[v4i32] } V64:{ *:[v2i32] }:$Vd, (trunc:{ *:[v2i32] } (AArch64vlshr:{ *:[v2i64] } (add:{ *:[v2i64] } (AArch64dup:{ *:[v2i64] } 2147483648:{ *:[i64] }), V128:{ *:[v2i64] }:$Vn), 32:{ *:[i32] })))  =>  (RADDHNv2i64_v4i32:{ *:[v4i32] } (INSERT_SUBREG:{ *:[f128] } (IMPLICIT_DEF:{ *:[f128] }), V64:{ *:[v2i32] }:$Vd, dsub:{ *:[i32] }), V128:{ *:[v2i64] }:$Vn, (MOVIv2d_ns:{ *:[v2i64] } 0:{ *:[i32] }))
          GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s128,
          GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s128,
          GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v2s64,
          GIR_BuildMI, /*InsnID*/3, /*Opcode*/AArch64::MOVIv2d_ns,
          GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/RegState::Define,
          GIR_AddImm, /*InsnID*/3, /*Imm*/0,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
          GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
          GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
          GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::INSERT_SUBREG,
          GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
          GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
          GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // Vd
          GIR_AddImm, /*InsnID*/1, /*Imm*/2,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, AArch64::FPR128RegClassID,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, AArch64::FPR128RegClassID,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/2, AArch64::FPR64RegClassID,
          GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::RADDHNv2i64_v4i32,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
          GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // Vn
          GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/2, /*TempRegFlags*/0,
          GIR_EraseFromParent, /*InsnID*/0,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
          // GIR_Coverage, 11792,
          GIR_Done,
        // Label 800: @37129
        GIM_Try, /*On fail goto*//*Label 801*/ 37287, // Rule ID 9474 //
          GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
          GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
          GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_TRUNC,
          GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s64,
          GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
          GIM_CheckOpcode, /*MI*/2, AArch64::G_VLSHR,
          GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v2s64,
          GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
          GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_ADD,
          GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v2s64,
          GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v2s64,
          GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
          GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/2, // MIs[4]
          GIM_CheckOpcode, /*MI*/4, AArch64::G_DUP,
          GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s64,
          GIM_CheckConstantInt, /*MI*/4, /*Op*/1, 2147483648,
          // MIs[2] Operand 2
          GIM_CheckLiteralInt, /*MI*/2, /*Op*/2, 32,
          GIM_CheckIsSafeToFold, /*InsnID*/1,
          GIM_CheckIsSafeToFold, /*InsnID*/2,
          GIM_CheckIsSafeToFold, /*InsnID*/3,
          GIM_CheckIsSafeToFold, /*InsnID*/4,
          // (concat_vectors:{ *:[v4i32] } V64:{ *:[v2i32] }:$Vd, (trunc:{ *:[v2i32] } (AArch64vlshr:{ *:[v2i64] } (add:{ *:[v2i64] } V128:{ *:[v2i64] }:$Vn, (AArch64dup:{ *:[v2i64] } 2147483648:{ *:[i64] })), 32:{ *:[i32] })))  =>  (RADDHNv2i64_v4i32:{ *:[v4i32] } (INSERT_SUBREG:{ *:[f128] } (IMPLICIT_DEF:{ *:[f128] }), V64:{ *:[v2i32] }:$Vd, dsub:{ *:[i32] }), V128:{ *:[v2i64] }:$Vn, (MOVIv2d_ns:{ *:[v2i64] } 0:{ *:[i32] }))
          GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s128,
          GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s128,
          GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v2s64,
          GIR_BuildMI, /*InsnID*/3, /*Opcode*/AArch64::MOVIv2d_ns,
          GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/RegState::Define,
          GIR_AddImm, /*InsnID*/3, /*Imm*/0,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
          GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
          GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
          GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::INSERT_SUBREG,
          GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
          GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
          GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // Vd
          GIR_AddImm, /*InsnID*/1, /*Imm*/2,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, AArch64::FPR128RegClassID,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, AArch64::FPR128RegClassID,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/2, AArch64::FPR64RegClassID,
          GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::RADDHNv2i64_v4i32,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
          GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // Vn
          GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/2, /*TempRegFlags*/0,
          GIR_EraseFromParent, /*InsnID*/0,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
          // GIR_Coverage, 9474,
          GIR_Done,
        // Label 801: @37287
        GIM_Try, /*On fail goto*//*Label 802*/ 37400, // Rule ID 8833 //
          GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
          GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
          GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_TRUNC,
          GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s64,
          GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
          GIM_CheckOpcode, /*MI*/2, AArch64::G_VLSHR,
          GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v2s64,
          GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
          GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_ADD,
          GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v2s64,
          GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v2s64,
          GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
          GIM_CheckRegBankForClass, /*MI*/3, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
          // MIs[2] Operand 2
          GIM_CheckLiteralInt, /*MI*/2, /*Op*/2, 32,
          GIM_CheckIsSafeToFold, /*InsnID*/1,
          GIM_CheckIsSafeToFold, /*InsnID*/2,
          GIM_CheckIsSafeToFold, /*InsnID*/3,
          // (concat_vectors:{ *:[v4i32] } V64:{ *:[v2i32] }:$Rd, (trunc:{ *:[v2i32] } (AArch64vlshr:{ *:[v2i64] } (add:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rn, V128:{ *:[v2i64] }:$Rm), 32:{ *:[i32] })))  =>  (ADDHNv2i64_v4i32:{ *:[v4i32] } (SUBREG_TO_REG:{ *:[f128] } 0:{ *:[i32] }, V64:{ *:[v2i32] }:$Rd, dsub:{ *:[i32] }), V128:{ *:[v2i64] }:$Rn, V128:{ *:[v2i64] }:$Rm)
          GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s128,
          GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::SUBREG_TO_REG,
          GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
          GIR_AddImm, /*InsnID*/1, /*Imm*/0,
          GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // Rd
          GIR_AddImm, /*InsnID*/1, /*Imm*/2,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, AArch64::FPR128RegClassID,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/2, AArch64::FPR64RegClassID,
          GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::ADDHNv2i64_v4i32,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
          GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // Rn
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // Rm
          GIR_EraseFromParent, /*InsnID*/0,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
          // GIR_Coverage, 8833,
          GIR_Done,
        // Label 802: @37400
        GIM_Try, /*On fail goto*//*Label 803*/ 37513, // Rule ID 8839 //
          GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
          GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
          GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_TRUNC,
          GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s64,
          GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
          GIM_CheckOpcode, /*MI*/2, AArch64::G_VLSHR,
          GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v2s64,
          GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
          GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_SUB,
          GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v2s64,
          GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v2s64,
          GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
          GIM_CheckRegBankForClass, /*MI*/3, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
          // MIs[2] Operand 2
          GIM_CheckLiteralInt, /*MI*/2, /*Op*/2, 32,
          GIM_CheckIsSafeToFold, /*InsnID*/1,
          GIM_CheckIsSafeToFold, /*InsnID*/2,
          GIM_CheckIsSafeToFold, /*InsnID*/3,
          // (concat_vectors:{ *:[v4i32] } V64:{ *:[v2i32] }:$Rd, (trunc:{ *:[v2i32] } (AArch64vlshr:{ *:[v2i64] } (sub:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rn, V128:{ *:[v2i64] }:$Rm), 32:{ *:[i32] })))  =>  (SUBHNv2i64_v4i32:{ *:[v4i32] } (SUBREG_TO_REG:{ *:[f128] } 0:{ *:[i32] }, V64:{ *:[v2i32] }:$Rd, dsub:{ *:[i32] }), V128:{ *:[v2i64] }:$Rn, V128:{ *:[v2i64] }:$Rm)
          GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s128,
          GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::SUBREG_TO_REG,
          GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
          GIR_AddImm, /*InsnID*/1, /*Imm*/0,
          GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // Rd
          GIR_AddImm, /*InsnID*/1, /*Imm*/2,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, AArch64::FPR128RegClassID,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/2, AArch64::FPR64RegClassID,
          GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SUBHNv2i64_v4i32,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
          GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // Rn
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // Rm
          GIR_EraseFromParent, /*InsnID*/0,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
          // GIR_Coverage, 8839,
          GIR_Done,
        // Label 803: @37513
        GIM_Try, /*On fail goto*//*Label 804*/ 37603, // Rule ID 8920 //
          GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
          GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_TRUNC,
          GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s64,
          GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
          GIM_CheckOpcode, /*MI*/2, AArch64::G_VLSHR,
          GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v2s64,
          GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
          // MIs[2] Operand 2
          GIM_CheckLiteralInt, /*MI*/2, /*Op*/2, 32,
          GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
          GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_TRUNC,
          GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v2s64,
          GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
          GIM_CheckOpcode, /*MI*/4, AArch64::G_VLSHR,
          GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_v2s64,
          GIM_CheckRegBankForClass, /*MI*/4, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
          // MIs[4] Operand 2
          GIM_CheckLiteralInt, /*MI*/4, /*Op*/2, 32,
          GIM_CheckIsSafeToFold, /*InsnID*/1,
          GIM_CheckIsSafeToFold, /*InsnID*/2,
          GIM_CheckIsSafeToFold, /*InsnID*/3,
          GIM_CheckIsSafeToFold, /*InsnID*/4,
          // (concat_vectors:{ *:[v4i32] } (trunc:{ *:[v2i32] } (AArch64vlshr:{ *:[v2i64] } V128:{ *:[v2i64] }:$Vn, 32:{ *:[i32] })), (trunc:{ *:[v2i32] } (AArch64vlshr:{ *:[v2i64] } V128:{ *:[v2i64] }:$Vm, 32:{ *:[i32] })))  =>  (UZP2v4i32:{ *:[v4i32] } V128:{ *:[v2i64] }:$Vn, V128:{ *:[v2i64] }:$Vm)
          GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UZP2v4i32,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // Rd
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Vn
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/1, // Vm
          GIR_EraseFromParent, /*InsnID*/0,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
          // GIR_Coverage, 8920,
          GIR_Done,
        // Label 804: @37603
        GIM_Try, /*On fail goto*//*Label 805*/ 37719, // Rule ID 9452 //
          GIM_CheckFeatures, GIFBS_HasNEON,
          GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
          GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
          GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
          GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
          GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_sqrshrn,
          GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s64,
          GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
          GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
          GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/3, // MIs[2]
          GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
          GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIPFP_I64_Predicate_vecshiftR64Narrow,
          // MIs[2] Operand 1
          // No operand predicates
          GIM_CheckIsSafeToFold, /*InsnID*/1,
          GIM_CheckIsSafeToFold, /*InsnID*/2,
          // (concat_vectors:{ *:[v4i32] } V64:{ *:[v2i32] }:$Rd, (intrinsic_wo_chain:{ *:[v2i32] } 582:{ *:[iPTR] }, V128:{ *:[v2i64] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR64Narrow>>:$imm))  =>  (SQRSHRNv4i32_shift:{ *:[v4i32] } (INSERT_SUBREG:{ *:[f128] } (IMPLICIT_DEF:{ *:[f128] }), V64:{ *:[v2i32] }:$Rd, dsub:{ *:[i32] }), V128:{ *:[v2i64] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR64Narrow>>:$imm)
          GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s128,
          GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s128,
          GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
          GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
          GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::INSERT_SUBREG,
          GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
          GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
          GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // Rd
          GIR_AddImm, /*InsnID*/1, /*Imm*/2,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, AArch64::FPR128RegClassID,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, AArch64::FPR128RegClassID,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/2, AArch64::FPR64RegClassID,
          GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SQRSHRNv4i32_shift,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
          GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
          GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
          GIR_EraseFromParent, /*InsnID*/0,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
          // GIR_Coverage, 9452,
          GIR_Done,
        // Label 805: @37719
        GIM_Try, /*On fail goto*//*Label 806*/ 37835, // Rule ID 9455 //
          GIM_CheckFeatures, GIFBS_HasNEON,
          GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
          GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
          GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
          GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
          GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_sqrshrun,
          GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s64,
          GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
          GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
          GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/3, // MIs[2]
          GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
          GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIPFP_I64_Predicate_vecshiftR64Narrow,
          // MIs[2] Operand 1
          // No operand predicates
          GIM_CheckIsSafeToFold, /*InsnID*/1,
          GIM_CheckIsSafeToFold, /*InsnID*/2,
          // (concat_vectors:{ *:[v4i32] } V64:{ *:[v2i32] }:$Rd, (intrinsic_wo_chain:{ *:[v2i32] } 583:{ *:[iPTR] }, V128:{ *:[v2i64] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR64Narrow>>:$imm))  =>  (SQRSHRUNv4i32_shift:{ *:[v4i32] } (INSERT_SUBREG:{ *:[f128] } (IMPLICIT_DEF:{ *:[f128] }), V64:{ *:[v2i32] }:$Rd, dsub:{ *:[i32] }), V128:{ *:[v2i64] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR64Narrow>>:$imm)
          GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s128,
          GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s128,
          GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
          GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
          GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::INSERT_SUBREG,
          GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
          GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
          GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // Rd
          GIR_AddImm, /*InsnID*/1, /*Imm*/2,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, AArch64::FPR128RegClassID,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, AArch64::FPR128RegClassID,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/2, AArch64::FPR64RegClassID,
          GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SQRSHRUNv4i32_shift,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
          GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
          GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
          GIR_EraseFromParent, /*InsnID*/0,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
          // GIR_Coverage, 9455,
          GIR_Done,
        // Label 806: @37835
        GIM_Try, /*On fail goto*//*Label 807*/ 37951, // Rule ID 9458 //
          GIM_CheckFeatures, GIFBS_HasNEON,
          GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
          GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
          GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
          GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
          GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_sqshrn,
          GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s64,
          GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
          GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
          GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/3, // MIs[2]
          GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
          GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIPFP_I64_Predicate_vecshiftR64Narrow,
          // MIs[2] Operand 1
          // No operand predicates
          GIM_CheckIsSafeToFold, /*InsnID*/1,
          GIM_CheckIsSafeToFold, /*InsnID*/2,
          // (concat_vectors:{ *:[v4i32] } V64:{ *:[v2i32] }:$Rd, (intrinsic_wo_chain:{ *:[v2i32] } 586:{ *:[iPTR] }, V128:{ *:[v2i64] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR64Narrow>>:$imm))  =>  (SQSHRNv4i32_shift:{ *:[v4i32] } (INSERT_SUBREG:{ *:[f128] } (IMPLICIT_DEF:{ *:[f128] }), V64:{ *:[v2i32] }:$Rd, dsub:{ *:[i32] }), V128:{ *:[v2i64] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR64Narrow>>:$imm)
          GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s128,
          GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s128,
          GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
          GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
          GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::INSERT_SUBREG,
          GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
          GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
          GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // Rd
          GIR_AddImm, /*InsnID*/1, /*Imm*/2,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, AArch64::FPR128RegClassID,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, AArch64::FPR128RegClassID,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/2, AArch64::FPR64RegClassID,
          GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SQSHRNv4i32_shift,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
          GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
          GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
          GIR_EraseFromParent, /*InsnID*/0,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
          // GIR_Coverage, 9458,
          GIR_Done,
        // Label 807: @37951
        GIM_Try, /*On fail goto*//*Label 808*/ 38067, // Rule ID 9461 //
          GIM_CheckFeatures, GIFBS_HasNEON,
          GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
          GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
          GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
          GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
          GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_sqshrun,
          GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s64,
          GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
          GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
          GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/3, // MIs[2]
          GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
          GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIPFP_I64_Predicate_vecshiftR64Narrow,
          // MIs[2] Operand 1
          // No operand predicates
          GIM_CheckIsSafeToFold, /*InsnID*/1,
          GIM_CheckIsSafeToFold, /*InsnID*/2,
          // (concat_vectors:{ *:[v4i32] } V64:{ *:[v2i32] }:$Rd, (intrinsic_wo_chain:{ *:[v2i32] } 587:{ *:[iPTR] }, V128:{ *:[v2i64] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR64Narrow>>:$imm))  =>  (SQSHRUNv4i32_shift:{ *:[v4i32] } (INSERT_SUBREG:{ *:[f128] } (IMPLICIT_DEF:{ *:[f128] }), V64:{ *:[v2i32] }:$Rd, dsub:{ *:[i32] }), V128:{ *:[v2i64] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR64Narrow>>:$imm)
          GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s128,
          GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s128,
          GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
          GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
          GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::INSERT_SUBREG,
          GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
          GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
          GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // Rd
          GIR_AddImm, /*InsnID*/1, /*Imm*/2,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, AArch64::FPR128RegClassID,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, AArch64::FPR128RegClassID,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/2, AArch64::FPR64RegClassID,
          GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SQSHRUNv4i32_shift,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
          GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
          GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
          GIR_EraseFromParent, /*InsnID*/0,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
          // GIR_Coverage, 9461,
          GIR_Done,
        // Label 808: @38067
        GIM_Try, /*On fail goto*//*Label 809*/ 38183, // Rule ID 9465 //
          GIM_CheckFeatures, GIFBS_HasNEON,
          GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
          GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
          GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
          GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
          GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_uqrshrn,
          GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s64,
          GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
          GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
          GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/3, // MIs[2]
          GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
          GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIPFP_I64_Predicate_vecshiftR64Narrow,
          // MIs[2] Operand 1
          // No operand predicates
          GIM_CheckIsSafeToFold, /*InsnID*/1,
          GIM_CheckIsSafeToFold, /*InsnID*/2,
          // (concat_vectors:{ *:[v4i32] } V64:{ *:[v2i32] }:$Rd, (intrinsic_wo_chain:{ *:[v2i32] } 631:{ *:[iPTR] }, V128:{ *:[v2i64] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR64Narrow>>:$imm))  =>  (UQRSHRNv4i32_shift:{ *:[v4i32] } (INSERT_SUBREG:{ *:[f128] } (IMPLICIT_DEF:{ *:[f128] }), V64:{ *:[v2i32] }:$Rd, dsub:{ *:[i32] }), V128:{ *:[v2i64] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR64Narrow>>:$imm)
          GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s128,
          GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s128,
          GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
          GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
          GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::INSERT_SUBREG,
          GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
          GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
          GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // Rd
          GIR_AddImm, /*InsnID*/1, /*Imm*/2,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, AArch64::FPR128RegClassID,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, AArch64::FPR128RegClassID,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/2, AArch64::FPR64RegClassID,
          GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UQRSHRNv4i32_shift,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
          GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
          GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
          GIR_EraseFromParent, /*InsnID*/0,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
          // GIR_Coverage, 9465,
          GIR_Done,
        // Label 809: @38183
        GIM_Try, /*On fail goto*//*Label 810*/ 38299, // Rule ID 9468 //
          GIM_CheckFeatures, GIFBS_HasNEON,
          GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
          GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
          GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_INTRINSIC,
          GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
          GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, Intrinsic::aarch64_neon_uqshrn,
          GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s64,
          GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
          GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/AArch64::FPR128RegClassID,
          GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/3, // MIs[2]
          GIM_CheckOpcode, /*MI*/2, TargetOpcode::G_CONSTANT,
          GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIPFP_I64_Predicate_vecshiftR64Narrow,
          // MIs[2] Operand 1
          // No operand predicates
          GIM_CheckIsSafeToFold, /*InsnID*/1,
          GIM_CheckIsSafeToFold, /*InsnID*/2,
          // (concat_vectors:{ *:[v4i32] } V64:{ *:[v2i32] }:$Rd, (intrinsic_wo_chain:{ *:[v2i32] } 633:{ *:[iPTR] }, V128:{ *:[v2i64] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR64Narrow>>:$imm))  =>  (UQSHRNv4i32_shift:{ *:[v4i32] } (INSERT_SUBREG:{ *:[f128] } (IMPLICIT_DEF:{ *:[f128] }), V64:{ *:[v2i32] }:$Rd, dsub:{ *:[i32] }), V128:{ *:[v2i64] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR64Narrow>>:$imm)
          GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s128,
          GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s128,
          GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
          GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
          GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::INSERT_SUBREG,
          GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
          GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
          GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // Rd
          GIR_AddImm, /*InsnID*/1, /*Imm*/2,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, AArch64::FPR128RegClassID,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, AArch64::FPR128RegClassID,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/2, AArch64::FPR64RegClassID,
          GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::UQSHRNv4i32_shift,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
          GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
          GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
          GIR_EraseFromParent, /*InsnID*/0,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
          // GIR_Coverage, 9468,
          GIR_Done,
        // Label 810: @38299
        GIM_Try, /*On fail goto*//*Label 811*/ 38417, // Rule ID 9448 //
          GIM_CheckFeatures, GIFBS_HasNEON,
          GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
          GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
          GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_TRUNC,
          GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s64,
          GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
          GIM_CheckOpcode, /*MI*/2, AArch64::G_VASHR,
          GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v2s64,
          GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
          // MIs[2] imm
          GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
          GIM_CheckOpcode, /*MI*/3, TargetOpcode::G_CONSTANT,
          GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIPFP_I64_Predicate_vecshiftR64Narrow,
          // MIs[3] Operand 1
          // No operand predicates
          GIM_CheckIsSafeToFold, /*InsnID*/1,
          GIM_CheckIsSafeToFold, /*InsnID*/2,
          GIM_CheckIsSafeToFold, /*InsnID*/3,
          // (concat_vectors:{ *:[v4i32] } V64:{ *:[v2i32] }:$Rd, (trunc:{ *:[v2i32] } (AArch64vashr:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR64Narrow>>:$imm)))  =>  (SHRNv4i32_shift:{ *:[v4i32] } (INSERT_SUBREG:{ *:[f128] } (IMPLICIT_DEF:{ *:[f128] }), V64:{ *:[v2i32] }:$Rd, dsub:{ *:[i32] }), V128:{ *:[v2i64] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR64Narrow>>:$imm)
          GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s128,
          GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s128,
          GIR_BuildMI, /*InsnID*/2, /*Opcode*/TargetOpcode::IMPLICIT_DEF,
          GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/RegState::Define,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
          GIR_BuildMI, /*InsnID*/1, /*Opcode*/TargetOpcode::INSERT_SUBREG,
          GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/RegState::Define,
          GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/0,
          GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // Rd
          GIR_AddImm, /*InsnID*/1, /*Imm*/2,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, AArch64::FPR128RegClassID,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, AArch64::FPR128RegClassID,
          GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/2, AArch64::FPR64RegClassID,
          GIR_BuildMI, /*InsnID*/0, /*Opcode*/AArch64::SHRNv4i32_shift,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // dst
          GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/0,
          GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rn
          GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // imm
          GIR_EraseFromParent, /*InsnID*/0,
          GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
          // GIR_Coverage, 9448,
          GIR_Done,
        // Label 811: @38417
        GIM_Try, /*On fail goto*//*Label 812*/ 38533, // Rule ID 9480 //
          GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/AArch64::FPR64RegClassID,
          GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
          GIM_CheckOpcode, /*MI*/1, TargetOpcode::G_TRUNC,
          GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s64,
          GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
          GIM_CheckOpcode, /*MI*/2, AArch64::G_VLSHR,
          GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v2s64,
          GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/AArch64::FPR128RegClassID,
          // MIs[2] imm
          GIM_RecordInsn, /*Defin