/**
 * SDRangel
 * This is the web REST/JSON API of SDRangel SDR software. SDRangel is an Open Source Qt5/OpenGL 3.0+ (4.3+ in Windows) GUI and server Software Defined Radio and signal analyzer in software. It supports Airspy, BladeRF, HackRF, LimeSDR, PlutoSDR, RTL-SDR, SDRplay RSP1 and FunCube    ---   Limitations and specifcities:    * In SDRangel GUI the first Rx device set cannot be deleted. Conversely the server starts with no device sets and its number of device sets can be reduced to zero by as many calls as necessary to /sdrangel/deviceset with DELETE method.   * Preset import and export from/to file is a server only feature.   * Device set focus is a GUI only feature.   * The following channels are not implemented (status 501 is returned): ATV and DATV demodulators, Channel Analyzer NG, LoRa demodulator   * The device settings and report structures contains only the sub-structure corresponding to the device type. The DeviceSettings and DeviceReport structures documented here shows all of them but only one will be or should be present at a time   * The channel settings and report structures contains only the sub-structure corresponding to the channel type. The ChannelSettings and ChannelReport structures documented here shows all of them but only one will be or should be present at a time    --- 
 *
 * OpenAPI spec version: 6.0.0
 * Contact: f4exb06@gmail.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


#include "SWGFeatureSettings.h"

#include "SWGHelpers.h"

#include <QJsonDocument>
#include <QJsonArray>
#include <QObject>
#include <QDebug>

namespace SWGSDRangel {

SWGFeatureSettings::SWGFeatureSettings(QString* json) {
    init();
    this->fromJson(*json);
}

SWGFeatureSettings::SWGFeatureSettings() {
    feature_type = nullptr;
    m_feature_type_isSet = false;
    originator_feature_set_index = 0;
    m_originator_feature_set_index_isSet = false;
    originator_feature_index = 0;
    m_originator_feature_index_isSet = false;
    afc_settings = nullptr;
    m_afc_settings_isSet = false;
    aprs_settings = nullptr;
    m_aprs_settings_isSet = false;
    demod_analyzer_settings = nullptr;
    m_demod_analyzer_settings_isSet = false;
    gs232_controller_settings = nullptr;
    m_gs232_controller_settings_isSet = false;
    map_settings = nullptr;
    m_map_settings_isSet = false;
    rig_ctl_server_settings = nullptr;
    m_rig_ctl_server_settings_isSet = false;
    satellite_tracker_settings = nullptr;
    m_satellite_tracker_settings_isSet = false;
    star_tracker_settings = nullptr;
    m_star_tracker_settings_isSet = false;
    simple_ptt_settings = nullptr;
    m_simple_ptt_settings_isSet = false;
    vor_localizer_settings = nullptr;
    m_vor_localizer_settings_isSet = false;
}

SWGFeatureSettings::~SWGFeatureSettings() {
    this->cleanup();
}

void
SWGFeatureSettings::init() {
    feature_type = new QString("");
    m_feature_type_isSet = false;
    originator_feature_set_index = 0;
    m_originator_feature_set_index_isSet = false;
    originator_feature_index = 0;
    m_originator_feature_index_isSet = false;
    afc_settings = new SWGAFCSettings();
    m_afc_settings_isSet = false;
    aprs_settings = new SWGAPRSSettings();
    m_aprs_settings_isSet = false;
    demod_analyzer_settings = new SWGDemodAnalyzerSettings();
    m_demod_analyzer_settings_isSet = false;
    gs232_controller_settings = new SWGGS232ControllerSettings();
    m_gs232_controller_settings_isSet = false;
    map_settings = new SWGMapSettings();
    m_map_settings_isSet = false;
    rig_ctl_server_settings = new SWGRigCtlServerSettings();
    m_rig_ctl_server_settings_isSet = false;
    satellite_tracker_settings = new SWGSatelliteTrackerSettings();
    m_satellite_tracker_settings_isSet = false;
    star_tracker_settings = new SWGStarTrackerSettings();
    m_star_tracker_settings_isSet = false;
    simple_ptt_settings = new SWGSimplePTTSettings();
    m_simple_ptt_settings_isSet = false;
    vor_localizer_settings = new SWGVORLocalizerSettings();
    m_vor_localizer_settings_isSet = false;
}

void
SWGFeatureSettings::cleanup() {
    if(feature_type != nullptr) { 
        delete feature_type;
    }


    if(afc_settings != nullptr) { 
        delete afc_settings;
    }
    if(aprs_settings != nullptr) { 
        delete aprs_settings;
    }
    if(demod_analyzer_settings != nullptr) { 
        delete demod_analyzer_settings;
    }
    if(gs232_controller_settings != nullptr) { 
        delete gs232_controller_settings;
    }
    if(map_settings != nullptr) { 
        delete map_settings;
    }
    if(rig_ctl_server_settings != nullptr) { 
        delete rig_ctl_server_settings;
    }
    if(satellite_tracker_settings != nullptr) { 
        delete satellite_tracker_settings;
    }
    if(star_tracker_settings != nullptr) { 
        delete star_tracker_settings;
    }
    if(simple_ptt_settings != nullptr) { 
        delete simple_ptt_settings;
    }
    if(vor_localizer_settings != nullptr) { 
        delete vor_localizer_settings;
    }
}

SWGFeatureSettings*
SWGFeatureSettings::fromJson(QString &json) {
    QByteArray array (json.toStdString().c_str());
    QJsonDocument doc = QJsonDocument::fromJson(array);
    QJsonObject jsonObject = doc.object();
    this->fromJsonObject(jsonObject);
    return this;
}

void
SWGFeatureSettings::fromJsonObject(QJsonObject &pJson) {
    ::SWGSDRangel::setValue(&feature_type, pJson["featureType"], "QString", "QString");
    
    ::SWGSDRangel::setValue(&originator_feature_set_index, pJson["originatorFeatureSetIndex"], "qint32", "");
    
    ::SWGSDRangel::setValue(&originator_feature_index, pJson["originatorFeatureIndex"], "qint32", "");
    
    ::SWGSDRangel::setValue(&afc_settings, pJson["AFCSettings"], "SWGAFCSettings", "SWGAFCSettings");
    
    ::SWGSDRangel::setValue(&aprs_settings, pJson["APRSSettings"], "SWGAPRSSettings", "SWGAPRSSettings");
    
    ::SWGSDRangel::setValue(&demod_analyzer_settings, pJson["DemodAnalyzerSettings"], "SWGDemodAnalyzerSettings", "SWGDemodAnalyzerSettings");
    
    ::SWGSDRangel::setValue(&gs232_controller_settings, pJson["GS232ControllerSettings"], "SWGGS232ControllerSettings", "SWGGS232ControllerSettings");
    
    ::SWGSDRangel::setValue(&map_settings, pJson["MapSettings"], "SWGMapSettings", "SWGMapSettings");
    
    ::SWGSDRangel::setValue(&rig_ctl_server_settings, pJson["RigCtlServerSettings"], "SWGRigCtlServerSettings", "SWGRigCtlServerSettings");
    
    ::SWGSDRangel::setValue(&satellite_tracker_settings, pJson["SatelliteTrackerSettings"], "SWGSatelliteTrackerSettings", "SWGSatelliteTrackerSettings");
    
    ::SWGSDRangel::setValue(&star_tracker_settings, pJson["StarTrackerSettings"], "SWGStarTrackerSettings", "SWGStarTrackerSettings");
    
    ::SWGSDRangel::setValue(&simple_ptt_settings, pJson["SimplePTTSettings"], "SWGSimplePTTSettings", "SWGSimplePTTSettings");
    
    ::SWGSDRangel::setValue(&vor_localizer_settings, pJson["VORLocalizerSettings"], "SWGVORLocalizerSettings", "SWGVORLocalizerSettings");
    
}

QString
SWGFeatureSettings::asJson ()
{
    QJsonObject* obj = this->asJsonObject();

    QJsonDocument doc(*obj);
    QByteArray bytes = doc.toJson();
    delete obj;
    return QString(bytes);
}

QJsonObject*
SWGFeatureSettings::asJsonObject() {
    QJsonObject* obj = new QJsonObject();
    if(feature_type != nullptr && *feature_type != QString("")){
        toJsonValue(QString("featureType"), feature_type, obj, QString("QString"));
    }
    if(m_originator_feature_set_index_isSet){
        obj->insert("originatorFeatureSetIndex", QJsonValue(originator_feature_set_index));
    }
    if(m_originator_feature_index_isSet){
        obj->insert("originatorFeatureIndex", QJsonValue(originator_feature_index));
    }
    if((afc_settings != nullptr) && (afc_settings->isSet())){
        toJsonValue(QString("AFCSettings"), afc_settings, obj, QString("SWGAFCSettings"));
    }
    if((aprs_settings != nullptr) && (aprs_settings->isSet())){
        toJsonValue(QString("APRSSettings"), aprs_settings, obj, QString("SWGAPRSSettings"));
    }
    if((demod_analyzer_settings != nullptr) && (demod_analyzer_settings->isSet())){
        toJsonValue(QString("DemodAnalyzerSettings"), demod_analyzer_settings, obj, QString("SWGDemodAnalyzerSettings"));
    }
    if((gs232_controller_settings != nullptr) && (gs232_controller_settings->isSet())){
        toJsonValue(QString("GS232ControllerSettings"), gs232_controller_settings, obj, QString("SWGGS232ControllerSettings"));
    }
    if((map_settings != nullptr) && (map_settings->isSet())){
        toJsonValue(QString("MapSettings"), map_settings, obj, QString("SWGMapSettings"));
    }
    if((rig_ctl_server_settings != nullptr) && (rig_ctl_server_settings->isSet())){
        toJsonValue(QString("RigCtlServerSettings"), rig_ctl_server_settings, obj, QString("SWGRigCtlServerSettings"));
    }
    if((satellite_tracker_settings != nullptr) && (satellite_tracker_settings->isSet())){
        toJsonValue(QString("SatelliteTrackerSettings"), satellite_tracker_settings, obj, QString("SWGSatelliteTrackerSettings"));
    }
    if((star_tracker_settings != nullptr) && (star_tracker_settings->isSet())){
        toJsonValue(QString("StarTrackerSettings"), star_tracker_settings, obj, QString("SWGStarTrackerSettings"));
    }
    if((simple_ptt_settings != nullptr) && (simple_ptt_settings->isSet())){
        toJsonValue(QString("SimplePTTSettings"), simple_ptt_settings, obj, QString("SWGSimplePTTSettings"));
    }
    if((vor_localizer_settings != nullptr) && (vor_localizer_settings->isSet())){
        toJsonValue(QString("VORLocalizerSettings"), vor_localizer_settings, obj, QString("SWGVORLocalizerSettings"));
    }

    return obj;
}

QString*
SWGFeatureSettings::getFeatureType() {
    return feature_type;
}
void
SWGFeatureSettings::setFeatureType(QString* feature_type) {
    this->feature_type = feature_type;
    this->m_feature_type_isSet = true;
}

qint32
SWGFeatureSettings::getOriginatorFeatureSetIndex() {
    return originator_feature_set_index;
}
void
SWGFeatureSettings::setOriginatorFeatureSetIndex(qint32 originator_feature_set_index) {
    this->originator_feature_set_index = originator_feature_set_index;
    this->m_originator_feature_set_index_isSet = true;
}

qint32
SWGFeatureSettings::getOriginatorFeatureIndex() {
    return originator_feature_index;
}
void
SWGFeatureSettings::setOriginatorFeatureIndex(qint32 originator_feature_index) {
    this->originator_feature_index = originator_feature_index;
    this->m_originator_feature_index_isSet = true;
}

SWGAFCSettings*
SWGFeatureSettings::getAfcSettings() {
    return afc_settings;
}
void
SWGFeatureSettings::setAfcSettings(SWGAFCSettings* afc_settings) {
    this->afc_settings = afc_settings;
    this->m_afc_settings_isSet = true;
}

SWGAPRSSettings*
SWGFeatureSettings::getAprsSettings() {
    return aprs_settings;
}
void
SWGFeatureSettings::setAprsSettings(SWGAPRSSettings* aprs_settings) {
    this->aprs_settings = aprs_settings;
    this->m_aprs_settings_isSet = true;
}

SWGDemodAnalyzerSettings*
SWGFeatureSettings::getDemodAnalyzerSettings() {
    return demod_analyzer_settings;
}
void
SWGFeatureSettings::setDemodAnalyzerSettings(SWGDemodAnalyzerSettings* demod_analyzer_settings) {
    this->demod_analyzer_settings = demod_analyzer_settings;
    this->m_demod_analyzer_settings_isSet = true;
}

SWGGS232ControllerSettings*
SWGFeatureSettings::getGs232ControllerSettings() {
    return gs232_controller_settings;
}
void
SWGFeatureSettings::setGs232ControllerSettings(SWGGS232ControllerSettings* gs232_controller_settings) {
    this->gs232_controller_settings = gs232_controller_settings;
    this->m_gs232_controller_settings_isSet = true;
}

SWGMapSettings*
SWGFeatureSettings::getMapSettings() {
    return map_settings;
}
void
SWGFeatureSettings::setMapSettings(SWGMapSettings* map_settings) {
    this->map_settings = map_settings;
    this->m_map_settings_isSet = true;
}

SWGRigCtlServerSettings*
SWGFeatureSettings::getRigCtlServerSettings() {
    return rig_ctl_server_settings;
}
void
SWGFeatureSettings::setRigCtlServerSettings(SWGRigCtlServerSettings* rig_ctl_server_settings) {
    this->rig_ctl_server_settings = rig_ctl_server_settings;
    this->m_rig_ctl_server_settings_isSet = true;
}

SWGSatelliteTrackerSettings*
SWGFeatureSettings::getSatelliteTrackerSettings() {
    return satellite_tracker_settings;
}
void
SWGFeatureSettings::setSatelliteTrackerSettings(SWGSatelliteTrackerSettings* satellite_tracker_settings) {
    this->satellite_tracker_settings = satellite_tracker_settings;
    this->m_satellite_tracker_settings_isSet = true;
}

SWGStarTrackerSettings*
SWGFeatureSettings::getStarTrackerSettings() {
    return star_tracker_settings;
}
void
SWGFeatureSettings::setStarTrackerSettings(SWGStarTrackerSettings* star_tracker_settings) {
    this->star_tracker_settings = star_tracker_settings;
    this->m_star_tracker_settings_isSet = true;
}

SWGSimplePTTSettings*
SWGFeatureSettings::getSimplePttSettings() {
    return simple_ptt_settings;
}
void
SWGFeatureSettings::setSimplePttSettings(SWGSimplePTTSettings* simple_ptt_settings) {
    this->simple_ptt_settings = simple_ptt_settings;
    this->m_simple_ptt_settings_isSet = true;
}

SWGVORLocalizerSettings*
SWGFeatureSettings::getVorLocalizerSettings() {
    return vor_localizer_settings;
}
void
SWGFeatureSettings::setVorLocalizerSettings(SWGVORLocalizerSettings* vor_localizer_settings) {
    this->vor_localizer_settings = vor_localizer_settings;
    this->m_vor_localizer_settings_isSet = true;
}


bool
SWGFeatureSettings::isSet(){
    bool isObjectUpdated = false;
    do{
        if(feature_type && *feature_type != QString("")){
            isObjectUpdated = true; break;
        }
        if(m_originator_feature_set_index_isSet){
            isObjectUpdated = true; break;
        }
        if(m_originator_feature_index_isSet){
            isObjectUpdated = true; break;
        }
        if(afc_settings && afc_settings->isSet()){
            isObjectUpdated = true; break;
        }
        if(aprs_settings && aprs_settings->isSet()){
            isObjectUpdated = true; break;
        }
        if(demod_analyzer_settings && demod_analyzer_settings->isSet()){
            isObjectUpdated = true; break;
        }
        if(gs232_controller_settings && gs232_controller_settings->isSet()){
            isObjectUpdated = true; break;
        }
        if(map_settings && map_settings->isSet()){
            isObjectUpdated = true; break;
        }
        if(rig_ctl_server_settings && rig_ctl_server_settings->isSet()){
            isObjectUpdated = true; break;
        }
        if(satellite_tracker_settings && satellite_tracker_settings->isSet()){
            isObjectUpdated = true; break;
        }
        if(star_tracker_settings && star_tracker_settings->isSet()){
            isObjectUpdated = true; break;
        }
        if(simple_ptt_settings && simple_ptt_settings->isSet()){
            isObjectUpdated = true; break;
        }
        if(vor_localizer_settings && vor_localizer_settings->isSet()){
            isObjectUpdated = true; break;
        }
    }while(false);
    return isObjectUpdated;
}
}

