/**
 * SDRangel
 * This is the web REST/JSON API of SDRangel SDR software. SDRangel is an Open Source Qt5/OpenGL 3.0+ (4.3+ in Windows) GUI and server Software Defined Radio and signal analyzer in software. It supports Airspy, BladeRF, HackRF, LimeSDR, PlutoSDR, RTL-SDR, SDRplay RSP1 and FunCube    ---   Limitations and specifcities:    * In SDRangel GUI the first Rx device set cannot be deleted. Conversely the server starts with no device sets and its number of device sets can be reduced to zero by as many calls as necessary to /sdrangel/deviceset with DELETE method.   * Preset import and export from/to file is a server only feature.   * Device set focus is a GUI only feature.   * The following channels are not implemented (status 501 is returned): ATV and DATV demodulators, Channel Analyzer NG, LoRa demodulator   * The device settings and report structures contains only the sub-structure corresponding to the device type. The DeviceSettings and DeviceReport structures documented here shows all of them but only one will be or should be present at a time   * The channel settings and report structures contains only the sub-structure corresponding to the channel type. The ChannelSettings and ChannelReport structures documented here shows all of them but only one will be or should be present at a time    --- 
 *
 * OpenAPI spec version: 6.0.0
 * Contact: f4exb06@gmail.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


#include "SWGGS232ControllerSettings.h"

#include "SWGHelpers.h"

#include <QJsonDocument>
#include <QJsonArray>
#include <QObject>
#include <QDebug>

namespace SWGSDRangel {

SWGGS232ControllerSettings::SWGGS232ControllerSettings(QString* json) {
    init();
    this->fromJson(*json);
}

SWGGS232ControllerSettings::SWGGS232ControllerSettings() {
    azimuth = 0;
    m_azimuth_isSet = false;
    elevation = 0;
    m_elevation_isSet = false;
    serial_port = nullptr;
    m_serial_port_isSet = false;
    baud_rate = 0;
    m_baud_rate_isSet = false;
    track = 0;
    m_track_isSet = false;
    title = nullptr;
    m_title_isSet = false;
    rgb_color = 0;
    m_rgb_color_isSet = false;
    device_index = 0;
    m_device_index_isSet = false;
    channel_index = 0;
    m_channel_index_isSet = false;
    use_reverse_api = 0;
    m_use_reverse_api_isSet = false;
    reverse_api_address = nullptr;
    m_reverse_api_address_isSet = false;
    reverse_api_port = 0;
    m_reverse_api_port_isSet = false;
    reverse_api_device_index = 0;
    m_reverse_api_device_index_isSet = false;
    reverse_api_channel_index = 0;
    m_reverse_api_channel_index_isSet = false;
}

SWGGS232ControllerSettings::~SWGGS232ControllerSettings() {
    this->cleanup();
}

void
SWGGS232ControllerSettings::init() {
    azimuth = 0;
    m_azimuth_isSet = false;
    elevation = 0;
    m_elevation_isSet = false;
    serial_port = new QString("");
    m_serial_port_isSet = false;
    baud_rate = 0;
    m_baud_rate_isSet = false;
    track = 0;
    m_track_isSet = false;
    title = new QString("");
    m_title_isSet = false;
    rgb_color = 0;
    m_rgb_color_isSet = false;
    device_index = 0;
    m_device_index_isSet = false;
    channel_index = 0;
    m_channel_index_isSet = false;
    use_reverse_api = 0;
    m_use_reverse_api_isSet = false;
    reverse_api_address = new QString("");
    m_reverse_api_address_isSet = false;
    reverse_api_port = 0;
    m_reverse_api_port_isSet = false;
    reverse_api_device_index = 0;
    m_reverse_api_device_index_isSet = false;
    reverse_api_channel_index = 0;
    m_reverse_api_channel_index_isSet = false;
}

void
SWGGS232ControllerSettings::cleanup() {


    if(serial_port != nullptr) { 
        delete serial_port;
    }


    if(title != nullptr) { 
        delete title;
    }




    if(reverse_api_address != nullptr) { 
        delete reverse_api_address;
    }



}

SWGGS232ControllerSettings*
SWGGS232ControllerSettings::fromJson(QString &json) {
    QByteArray array (json.toStdString().c_str());
    QJsonDocument doc = QJsonDocument::fromJson(array);
    QJsonObject jsonObject = doc.object();
    this->fromJsonObject(jsonObject);
    return this;
}

void
SWGGS232ControllerSettings::fromJsonObject(QJsonObject &pJson) {
    ::SWGSDRangel::setValue(&azimuth, pJson["azimuth"], "qint32", "");
    
    ::SWGSDRangel::setValue(&elevation, pJson["elevation"], "qint32", "");
    
    ::SWGSDRangel::setValue(&serial_port, pJson["serialPort"], "QString", "QString");
    
    ::SWGSDRangel::setValue(&baud_rate, pJson["baudRate"], "qint32", "");
    
    ::SWGSDRangel::setValue(&track, pJson["track"], "qint32", "");
    
    ::SWGSDRangel::setValue(&title, pJson["title"], "QString", "QString");
    
    ::SWGSDRangel::setValue(&rgb_color, pJson["rgbColor"], "qint32", "");
    
    ::SWGSDRangel::setValue(&device_index, pJson["deviceIndex"], "qint32", "");
    
    ::SWGSDRangel::setValue(&channel_index, pJson["channelIndex"], "qint32", "");
    
    ::SWGSDRangel::setValue(&use_reverse_api, pJson["useReverseAPI"], "qint32", "");
    
    ::SWGSDRangel::setValue(&reverse_api_address, pJson["reverseAPIAddress"], "QString", "QString");
    
    ::SWGSDRangel::setValue(&reverse_api_port, pJson["reverseAPIPort"], "qint32", "");
    
    ::SWGSDRangel::setValue(&reverse_api_device_index, pJson["reverseAPIDeviceIndex"], "qint32", "");
    
    ::SWGSDRangel::setValue(&reverse_api_channel_index, pJson["reverseAPIChannelIndex"], "qint32", "");
    
}

QString
SWGGS232ControllerSettings::asJson ()
{
    QJsonObject* obj = this->asJsonObject();

    QJsonDocument doc(*obj);
    QByteArray bytes = doc.toJson();
    delete obj;
    return QString(bytes);
}

QJsonObject*
SWGGS232ControllerSettings::asJsonObject() {
    QJsonObject* obj = new QJsonObject();
    if(m_azimuth_isSet){
        obj->insert("azimuth", QJsonValue(azimuth));
    }
    if(m_elevation_isSet){
        obj->insert("elevation", QJsonValue(elevation));
    }
    if(serial_port != nullptr && *serial_port != QString("")){
        toJsonValue(QString("serialPort"), serial_port, obj, QString("QString"));
    }
    if(m_baud_rate_isSet){
        obj->insert("baudRate", QJsonValue(baud_rate));
    }
    if(m_track_isSet){
        obj->insert("track", QJsonValue(track));
    }
    if(title != nullptr && *title != QString("")){
        toJsonValue(QString("title"), title, obj, QString("QString"));
    }
    if(m_rgb_color_isSet){
        obj->insert("rgbColor", QJsonValue(rgb_color));
    }
    if(m_device_index_isSet){
        obj->insert("deviceIndex", QJsonValue(device_index));
    }
    if(m_channel_index_isSet){
        obj->insert("channelIndex", QJsonValue(channel_index));
    }
    if(m_use_reverse_api_isSet){
        obj->insert("useReverseAPI", QJsonValue(use_reverse_api));
    }
    if(reverse_api_address != nullptr && *reverse_api_address != QString("")){
        toJsonValue(QString("reverseAPIAddress"), reverse_api_address, obj, QString("QString"));
    }
    if(m_reverse_api_port_isSet){
        obj->insert("reverseAPIPort", QJsonValue(reverse_api_port));
    }
    if(m_reverse_api_device_index_isSet){
        obj->insert("reverseAPIDeviceIndex", QJsonValue(reverse_api_device_index));
    }
    if(m_reverse_api_channel_index_isSet){
        obj->insert("reverseAPIChannelIndex", QJsonValue(reverse_api_channel_index));
    }

    return obj;
}

qint32
SWGGS232ControllerSettings::getAzimuth() {
    return azimuth;
}
void
SWGGS232ControllerSettings::setAzimuth(qint32 azimuth) {
    this->azimuth = azimuth;
    this->m_azimuth_isSet = true;
}

qint32
SWGGS232ControllerSettings::getElevation() {
    return elevation;
}
void
SWGGS232ControllerSettings::setElevation(qint32 elevation) {
    this->elevation = elevation;
    this->m_elevation_isSet = true;
}

QString*
SWGGS232ControllerSettings::getSerialPort() {
    return serial_port;
}
void
SWGGS232ControllerSettings::setSerialPort(QString* serial_port) {
    this->serial_port = serial_port;
    this->m_serial_port_isSet = true;
}

qint32
SWGGS232ControllerSettings::getBaudRate() {
    return baud_rate;
}
void
SWGGS232ControllerSettings::setBaudRate(qint32 baud_rate) {
    this->baud_rate = baud_rate;
    this->m_baud_rate_isSet = true;
}

qint32
SWGGS232ControllerSettings::getTrack() {
    return track;
}
void
SWGGS232ControllerSettings::setTrack(qint32 track) {
    this->track = track;
    this->m_track_isSet = true;
}

QString*
SWGGS232ControllerSettings::getTitle() {
    return title;
}
void
SWGGS232ControllerSettings::setTitle(QString* title) {
    this->title = title;
    this->m_title_isSet = true;
}

qint32
SWGGS232ControllerSettings::getRgbColor() {
    return rgb_color;
}
void
SWGGS232ControllerSettings::setRgbColor(qint32 rgb_color) {
    this->rgb_color = rgb_color;
    this->m_rgb_color_isSet = true;
}

qint32
SWGGS232ControllerSettings::getDeviceIndex() {
    return device_index;
}
void
SWGGS232ControllerSettings::setDeviceIndex(qint32 device_index) {
    this->device_index = device_index;
    this->m_device_index_isSet = true;
}

qint32
SWGGS232ControllerSettings::getChannelIndex() {
    return channel_index;
}
void
SWGGS232ControllerSettings::setChannelIndex(qint32 channel_index) {
    this->channel_index = channel_index;
    this->m_channel_index_isSet = true;
}

qint32
SWGGS232ControllerSettings::getUseReverseApi() {
    return use_reverse_api;
}
void
SWGGS232ControllerSettings::setUseReverseApi(qint32 use_reverse_api) {
    this->use_reverse_api = use_reverse_api;
    this->m_use_reverse_api_isSet = true;
}

QString*
SWGGS232ControllerSettings::getReverseApiAddress() {
    return reverse_api_address;
}
void
SWGGS232ControllerSettings::setReverseApiAddress(QString* reverse_api_address) {
    this->reverse_api_address = reverse_api_address;
    this->m_reverse_api_address_isSet = true;
}

qint32
SWGGS232ControllerSettings::getReverseApiPort() {
    return reverse_api_port;
}
void
SWGGS232ControllerSettings::setReverseApiPort(qint32 reverse_api_port) {
    this->reverse_api_port = reverse_api_port;
    this->m_reverse_api_port_isSet = true;
}

qint32
SWGGS232ControllerSettings::getReverseApiDeviceIndex() {
    return reverse_api_device_index;
}
void
SWGGS232ControllerSettings::setReverseApiDeviceIndex(qint32 reverse_api_device_index) {
    this->reverse_api_device_index = reverse_api_device_index;
    this->m_reverse_api_device_index_isSet = true;
}

qint32
SWGGS232ControllerSettings::getReverseApiChannelIndex() {
    return reverse_api_channel_index;
}
void
SWGGS232ControllerSettings::setReverseApiChannelIndex(qint32 reverse_api_channel_index) {
    this->reverse_api_channel_index = reverse_api_channel_index;
    this->m_reverse_api_channel_index_isSet = true;
}


bool
SWGGS232ControllerSettings::isSet(){
    bool isObjectUpdated = false;
    do{
        if(m_azimuth_isSet){
            isObjectUpdated = true; break;
        }
        if(m_elevation_isSet){
            isObjectUpdated = true; break;
        }
        if(serial_port && *serial_port != QString("")){
            isObjectUpdated = true; break;
        }
        if(m_baud_rate_isSet){
            isObjectUpdated = true; break;
        }
        if(m_track_isSet){
            isObjectUpdated = true; break;
        }
        if(title && *title != QString("")){
            isObjectUpdated = true; break;
        }
        if(m_rgb_color_isSet){
            isObjectUpdated = true; break;
        }
        if(m_device_index_isSet){
            isObjectUpdated = true; break;
        }
        if(m_channel_index_isSet){
            isObjectUpdated = true; break;
        }
        if(m_use_reverse_api_isSet){
            isObjectUpdated = true; break;
        }
        if(reverse_api_address && *reverse_api_address != QString("")){
            isObjectUpdated = true; break;
        }
        if(m_reverse_api_port_isSet){
            isObjectUpdated = true; break;
        }
        if(m_reverse_api_device_index_isSet){
            isObjectUpdated = true; break;
        }
        if(m_reverse_api_channel_index_isSet){
            isObjectUpdated = true; break;
        }
    }while(false);
    return isObjectUpdated;
}
}

