///////////////////////////////////////////////////////////////////////////////////
// Copyright (C) 2016 Edouard Griffiths, F4EXB                                   //
// Copyright (C) 2020 Jon Beniston, M7RCE                                        //
//                                                                               //
// This program is free software; you can redistribute it and/or modify          //
// it under the terms of the GNU General Public License as published by          //
// the Free Software Foundation as version 3 of the License, or                  //
// (at your option) any later version.                                           //
//                                                                               //
// This program is distributed in the hope that it will be useful,               //
// but WITHOUT ANY WARRANTY; without even the implied warranty of                //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the                  //
// GNU General Public License V3 for more details.                               //
//                                                                               //
// You should have received a copy of the GNU General Public License             //
// along with this program. If not, see <http://www.gnu.org/licenses/>.          //
///////////////////////////////////////////////////////////////////////////////////

#include <QtPlugin>
#include "plugin/pluginapi.h"

#ifndef SERVER_MODE
#include "ieee_802_15_4_modgui.h"
#endif
#include "ieee_802_15_4_mod.h"
#include "ieee_802_15_4_modwebapiadapter.h"
#include "ieee_802_15_4_modplugin.h"

const PluginDescriptor IEEE_802_15_4_ModPlugin::m_pluginDescriptor = {
    IEEE_802_15_4_Mod::m_channelId,
    QStringLiteral("802.15.4 Modulator"),
    QStringLiteral("6.3.3"),
    QStringLiteral("(c) Jon Beniston, M7RCE"),
    QStringLiteral("https://github.com/f4exb/sdrangel"),
    true,
    QStringLiteral("https://github.com/f4exb/sdrangel")
};

IEEE_802_15_4_ModPlugin::IEEE_802_15_4_ModPlugin(QObject* parent) :
    QObject(parent),
    m_pluginAPI(0)
{
}

const PluginDescriptor& IEEE_802_15_4_ModPlugin::getPluginDescriptor() const
{
    return m_pluginDescriptor;
}

void IEEE_802_15_4_ModPlugin::initPlugin(PluginAPI* pluginAPI)
{
    m_pluginAPI = pluginAPI;

    m_pluginAPI->registerTxChannel(IEEE_802_15_4_Mod::m_channelIdURI, IEEE_802_15_4_Mod::m_channelId, this);
}

void IEEE_802_15_4_ModPlugin::createTxChannel(DeviceAPI *deviceAPI, BasebandSampleSource **bs, ChannelAPI **cs) const
{
    if (bs || cs)
    {
        IEEE_802_15_4_Mod *instance = new IEEE_802_15_4_Mod(deviceAPI);

        if (bs) {
            *bs = instance;
        }

        if (cs) {
            *cs = instance;
        }
    }
}

#ifdef SERVER_MODE
ChannelGUI* IEEE_802_15_4_ModPlugin::createTxChannelGUI(
        DeviceUISet *deviceUISet,
        BasebandSampleSource *txChannel) const
{
	(void) deviceUISet;
	(void) txChannel;
    return nullptr;
}
#else
ChannelGUI* IEEE_802_15_4_ModPlugin::createTxChannelGUI(DeviceUISet *deviceUISet, BasebandSampleSource *txChannel) const
{
    return IEEE_802_15_4_ModGUI::create(m_pluginAPI, deviceUISet, txChannel);
}
#endif

ChannelWebAPIAdapter* IEEE_802_15_4_ModPlugin::createChannelWebAPIAdapter() const
{
    return new IEEE_802_15_4_ModWebAPIAdapter();
}
