/**
 * SDRangel
 * This is the web REST/JSON API of SDRangel SDR software. SDRangel is an Open Source Qt5/OpenGL 3.0+ (4.3+ in Windows) GUI and server Software Defined Radio and signal analyzer in software. It supports Airspy, BladeRF, HackRF, LimeSDR, PlutoSDR, RTL-SDR, SDRplay RSP1 and FunCube    ---   Limitations and specifcities:    * In SDRangel GUI the first Rx device set cannot be deleted. Conversely the server starts with no device sets and its number of device sets can be reduced to zero by as many calls as necessary to /sdrangel/deviceset with DELETE method.   * Preset import and export from/to file is a server only feature.   * Device set focus is a GUI only feature.   * The following channels are not implemented (status 501 is returned): ATV and DATV demodulators, Channel Analyzer NG, LoRa demodulator   * The device settings and report structures contains only the sub-structure corresponding to the device type. The DeviceSettings and DeviceReport structures documented here shows all of them but only one will be or should be present at a time   * The channel settings and report structures contains only the sub-structure corresponding to the channel type. The ChannelSettings and ChannelReport structures documented here shows all of them but only one will be or should be present at a time    --- 
 *
 * OpenAPI spec version: 6.0.0
 * Contact: f4exb06@gmail.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


#include "SWGSatellitePass.h"

#include "SWGHelpers.h"

#include <QJsonDocument>
#include <QJsonArray>
#include <QObject>
#include <QDebug>

namespace SWGSDRangel {

SWGSatellitePass::SWGSatellitePass(QString* json) {
    init();
    this->fromJson(*json);
}

SWGSatellitePass::SWGSatellitePass() {
    aos = nullptr;
    m_aos_isSet = false;
    los = nullptr;
    m_los_isSet = false;
    max_elevation = 0.0f;
    m_max_elevation_isSet = false;
}

SWGSatellitePass::~SWGSatellitePass() {
    this->cleanup();
}

void
SWGSatellitePass::init() {
    aos = new QString("");
    m_aos_isSet = false;
    los = new QString("");
    m_los_isSet = false;
    max_elevation = 0.0f;
    m_max_elevation_isSet = false;
}

void
SWGSatellitePass::cleanup() {
    if(aos != nullptr) { 
        delete aos;
    }
    if(los != nullptr) { 
        delete los;
    }

}

SWGSatellitePass*
SWGSatellitePass::fromJson(QString &json) {
    QByteArray array (json.toStdString().c_str());
    QJsonDocument doc = QJsonDocument::fromJson(array);
    QJsonObject jsonObject = doc.object();
    this->fromJsonObject(jsonObject);
    return this;
}

void
SWGSatellitePass::fromJsonObject(QJsonObject &pJson) {
    ::SWGSDRangel::setValue(&aos, pJson["aos"], "QString", "QString");
    
    ::SWGSDRangel::setValue(&los, pJson["los"], "QString", "QString");
    
    ::SWGSDRangel::setValue(&max_elevation, pJson["maxElevation"], "float", "");
    
}

QString
SWGSatellitePass::asJson ()
{
    QJsonObject* obj = this->asJsonObject();

    QJsonDocument doc(*obj);
    QByteArray bytes = doc.toJson();
    delete obj;
    return QString(bytes);
}

QJsonObject*
SWGSatellitePass::asJsonObject() {
    QJsonObject* obj = new QJsonObject();
    if(aos != nullptr && *aos != QString("")){
        toJsonValue(QString("aos"), aos, obj, QString("QString"));
    }
    if(los != nullptr && *los != QString("")){
        toJsonValue(QString("los"), los, obj, QString("QString"));
    }
    if(m_max_elevation_isSet){
        obj->insert("maxElevation", QJsonValue(max_elevation));
    }

    return obj;
}

QString*
SWGSatellitePass::getAos() {
    return aos;
}
void
SWGSatellitePass::setAos(QString* aos) {
    this->aos = aos;
    this->m_aos_isSet = true;
}

QString*
SWGSatellitePass::getLos() {
    return los;
}
void
SWGSatellitePass::setLos(QString* los) {
    this->los = los;
    this->m_los_isSet = true;
}

float
SWGSatellitePass::getMaxElevation() {
    return max_elevation;
}
void
SWGSatellitePass::setMaxElevation(float max_elevation) {
    this->max_elevation = max_elevation;
    this->m_max_elevation_isSet = true;
}


bool
SWGSatellitePass::isSet(){
    bool isObjectUpdated = false;
    do{
        if(aos && *aos != QString("")){
            isObjectUpdated = true; break;
        }
        if(los && *los != QString("")){
            isObjectUpdated = true; break;
        }
        if(m_max_elevation_isSet){
            isObjectUpdated = true; break;
        }
    }while(false);
    return isObjectUpdated;
}
}

