/**
 * SDRangel
 * This is the web REST/JSON API of SDRangel SDR software. SDRangel is an Open Source Qt5/OpenGL 3.0+ (4.3+ in Windows) GUI and server Software Defined Radio and signal analyzer in software. It supports Airspy, BladeRF, HackRF, LimeSDR, PlutoSDR, RTL-SDR, SDRplay RSP1 and FunCube    ---   Limitations and specifcities:    * In SDRangel GUI the first Rx device set cannot be deleted. Conversely the server starts with no device sets and its number of device sets can be reduced to zero by as many calls as necessary to /sdrangel/deviceset with DELETE method.   * Preset import and export from/to file is a server only feature.   * Device set focus is a GUI only feature.   * The following channels are not implemented (status 501 is returned): ATV and DATV demodulators, Channel Analyzer NG, LoRa demodulator   * The device settings and report structures contains only the sub-structure corresponding to the device type. The DeviceSettings and DeviceReport structures documented here shows all of them but only one will be or should be present at a time   * The channel settings and report structures contains only the sub-structure corresponding to the channel type. The ChannelSettings and ChannelReport structures documented here shows all of them but only one will be or should be present at a time    --- 
 *
 * OpenAPI spec version: 6.0.0
 * Contact: f4exb06@gmail.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


#include "SWGPERTesterSettings.h"

#include "SWGHelpers.h"

#include <QJsonDocument>
#include <QJsonArray>
#include <QObject>
#include <QDebug>

namespace SWGSDRangel {

SWGPERTesterSettings::SWGPERTesterSettings(QString* json) {
    init();
    this->fromJson(*json);
}

SWGPERTesterSettings::SWGPERTesterSettings() {
    packet_count = 0;
    m_packet_count_isSet = false;
    interval = 0.0f;
    m_interval_isSet = false;
    start = 0;
    m_start_isSet = false;
    satellites = nullptr;
    m_satellites_isSet = false;
    packet = nullptr;
    m_packet_isSet = false;
    ignore_leading_bytes = 0;
    m_ignore_leading_bytes_isSet = false;
    ignore_trailing_bytes = 0;
    m_ignore_trailing_bytes_isSet = false;
    tx_udp_address = nullptr;
    m_tx_udp_address_isSet = false;
    tx_udp_port = 0;
    m_tx_udp_port_isSet = false;
    rx_udp_address = nullptr;
    m_rx_udp_address_isSet = false;
    rx_udp_port = 0;
    m_rx_udp_port_isSet = false;
    title = nullptr;
    m_title_isSet = false;
    rgb_color = 0;
    m_rgb_color_isSet = false;
    use_reverse_api = 0;
    m_use_reverse_api_isSet = false;
    reverse_api_address = nullptr;
    m_reverse_api_address_isSet = false;
    reverse_api_port = 0;
    m_reverse_api_port_isSet = false;
    reverse_api_feature_set_index = 0;
    m_reverse_api_feature_set_index_isSet = false;
    reverse_api_feature_index = 0;
    m_reverse_api_feature_index_isSet = false;
    rollup_state = nullptr;
    m_rollup_state_isSet = false;
}

SWGPERTesterSettings::~SWGPERTesterSettings() {
    this->cleanup();
}

void
SWGPERTesterSettings::init() {
    packet_count = 0;
    m_packet_count_isSet = false;
    interval = 0.0f;
    m_interval_isSet = false;
    start = 0;
    m_start_isSet = false;
    satellites = new QList<QString*>();
    m_satellites_isSet = false;
    packet = new QString("");
    m_packet_isSet = false;
    ignore_leading_bytes = 0;
    m_ignore_leading_bytes_isSet = false;
    ignore_trailing_bytes = 0;
    m_ignore_trailing_bytes_isSet = false;
    tx_udp_address = new QString("");
    m_tx_udp_address_isSet = false;
    tx_udp_port = 0;
    m_tx_udp_port_isSet = false;
    rx_udp_address = new QString("");
    m_rx_udp_address_isSet = false;
    rx_udp_port = 0;
    m_rx_udp_port_isSet = false;
    title = new QString("");
    m_title_isSet = false;
    rgb_color = 0;
    m_rgb_color_isSet = false;
    use_reverse_api = 0;
    m_use_reverse_api_isSet = false;
    reverse_api_address = new QString("");
    m_reverse_api_address_isSet = false;
    reverse_api_port = 0;
    m_reverse_api_port_isSet = false;
    reverse_api_feature_set_index = 0;
    m_reverse_api_feature_set_index_isSet = false;
    reverse_api_feature_index = 0;
    m_reverse_api_feature_index_isSet = false;
    rollup_state = new SWGRollupState();
    m_rollup_state_isSet = false;
}

void
SWGPERTesterSettings::cleanup() {



    if(satellites != nullptr) { 
        auto arr = satellites;
        for(auto o: *arr) { 
            delete o;
        }
        delete satellites;
    }
    if(packet != nullptr) { 
        delete packet;
    }


    if(tx_udp_address != nullptr) { 
        delete tx_udp_address;
    }

    if(rx_udp_address != nullptr) { 
        delete rx_udp_address;
    }

    if(title != nullptr) { 
        delete title;
    }


    if(reverse_api_address != nullptr) { 
        delete reverse_api_address;
    }



    if(rollup_state != nullptr) { 
        delete rollup_state;
    }
}

SWGPERTesterSettings*
SWGPERTesterSettings::fromJson(QString &json) {
    QByteArray array (json.toStdString().c_str());
    QJsonDocument doc = QJsonDocument::fromJson(array);
    QJsonObject jsonObject = doc.object();
    this->fromJsonObject(jsonObject);
    return this;
}

void
SWGPERTesterSettings::fromJsonObject(QJsonObject &pJson) {
    ::SWGSDRangel::setValue(&packet_count, pJson["packetCount"], "qint32", "");
    
    ::SWGSDRangel::setValue(&interval, pJson["interval"], "float", "");
    
    ::SWGSDRangel::setValue(&start, pJson["start"], "qint32", "");
    
    
    ::SWGSDRangel::setValue(&satellites, pJson["satellites"], "QList", "QString");
    ::SWGSDRangel::setValue(&packet, pJson["packet"], "QString", "QString");
    
    ::SWGSDRangel::setValue(&ignore_leading_bytes, pJson["ignoreLeadingBytes"], "qint32", "");
    
    ::SWGSDRangel::setValue(&ignore_trailing_bytes, pJson["ignoreTrailingBytes"], "qint32", "");
    
    ::SWGSDRangel::setValue(&tx_udp_address, pJson["txUDPAddress"], "QString", "QString");
    
    ::SWGSDRangel::setValue(&tx_udp_port, pJson["txUDPPort"], "qint32", "");
    
    ::SWGSDRangel::setValue(&rx_udp_address, pJson["rxUDPAddress"], "QString", "QString");
    
    ::SWGSDRangel::setValue(&rx_udp_port, pJson["rxUDPPort"], "qint32", "");
    
    ::SWGSDRangel::setValue(&title, pJson["title"], "QString", "QString");
    
    ::SWGSDRangel::setValue(&rgb_color, pJson["rgbColor"], "qint32", "");
    
    ::SWGSDRangel::setValue(&use_reverse_api, pJson["useReverseAPI"], "qint32", "");
    
    ::SWGSDRangel::setValue(&reverse_api_address, pJson["reverseAPIAddress"], "QString", "QString");
    
    ::SWGSDRangel::setValue(&reverse_api_port, pJson["reverseAPIPort"], "qint32", "");
    
    ::SWGSDRangel::setValue(&reverse_api_feature_set_index, pJson["reverseAPIFeatureSetIndex"], "qint32", "");
    
    ::SWGSDRangel::setValue(&reverse_api_feature_index, pJson["reverseAPIFeatureIndex"], "qint32", "");
    
    ::SWGSDRangel::setValue(&rollup_state, pJson["rollupState"], "SWGRollupState", "SWGRollupState");
    
}

QString
SWGPERTesterSettings::asJson ()
{
    QJsonObject* obj = this->asJsonObject();

    QJsonDocument doc(*obj);
    QByteArray bytes = doc.toJson();
    delete obj;
    return QString(bytes);
}

QJsonObject*
SWGPERTesterSettings::asJsonObject() {
    QJsonObject* obj = new QJsonObject();
    if(m_packet_count_isSet){
        obj->insert("packetCount", QJsonValue(packet_count));
    }
    if(m_interval_isSet){
        obj->insert("interval", QJsonValue(interval));
    }
    if(m_start_isSet){
        obj->insert("start", QJsonValue(start));
    }
    if(satellites && satellites->size() > 0){
        toJsonArray((QList<void*>*)satellites, obj, "satellites", "QString");
    }
    if(packet != nullptr && *packet != QString("")){
        toJsonValue(QString("packet"), packet, obj, QString("QString"));
    }
    if(m_ignore_leading_bytes_isSet){
        obj->insert("ignoreLeadingBytes", QJsonValue(ignore_leading_bytes));
    }
    if(m_ignore_trailing_bytes_isSet){
        obj->insert("ignoreTrailingBytes", QJsonValue(ignore_trailing_bytes));
    }
    if(tx_udp_address != nullptr && *tx_udp_address != QString("")){
        toJsonValue(QString("txUDPAddress"), tx_udp_address, obj, QString("QString"));
    }
    if(m_tx_udp_port_isSet){
        obj->insert("txUDPPort", QJsonValue(tx_udp_port));
    }
    if(rx_udp_address != nullptr && *rx_udp_address != QString("")){
        toJsonValue(QString("rxUDPAddress"), rx_udp_address, obj, QString("QString"));
    }
    if(m_rx_udp_port_isSet){
        obj->insert("rxUDPPort", QJsonValue(rx_udp_port));
    }
    if(title != nullptr && *title != QString("")){
        toJsonValue(QString("title"), title, obj, QString("QString"));
    }
    if(m_rgb_color_isSet){
        obj->insert("rgbColor", QJsonValue(rgb_color));
    }
    if(m_use_reverse_api_isSet){
        obj->insert("useReverseAPI", QJsonValue(use_reverse_api));
    }
    if(reverse_api_address != nullptr && *reverse_api_address != QString("")){
        toJsonValue(QString("reverseAPIAddress"), reverse_api_address, obj, QString("QString"));
    }
    if(m_reverse_api_port_isSet){
        obj->insert("reverseAPIPort", QJsonValue(reverse_api_port));
    }
    if(m_reverse_api_feature_set_index_isSet){
        obj->insert("reverseAPIFeatureSetIndex", QJsonValue(reverse_api_feature_set_index));
    }
    if(m_reverse_api_feature_index_isSet){
        obj->insert("reverseAPIFeatureIndex", QJsonValue(reverse_api_feature_index));
    }
    if((rollup_state != nullptr) && (rollup_state->isSet())){
        toJsonValue(QString("rollupState"), rollup_state, obj, QString("SWGRollupState"));
    }

    return obj;
}

qint32
SWGPERTesterSettings::getPacketCount() {
    return packet_count;
}
void
SWGPERTesterSettings::setPacketCount(qint32 packet_count) {
    this->packet_count = packet_count;
    this->m_packet_count_isSet = true;
}

float
SWGPERTesterSettings::getInterval() {
    return interval;
}
void
SWGPERTesterSettings::setInterval(float interval) {
    this->interval = interval;
    this->m_interval_isSet = true;
}

qint32
SWGPERTesterSettings::getStart() {
    return start;
}
void
SWGPERTesterSettings::setStart(qint32 start) {
    this->start = start;
    this->m_start_isSet = true;
}

QList<QString*>*
SWGPERTesterSettings::getSatellites() {
    return satellites;
}
void
SWGPERTesterSettings::setSatellites(QList<QString*>* satellites) {
    this->satellites = satellites;
    this->m_satellites_isSet = true;
}

QString*
SWGPERTesterSettings::getPacket() {
    return packet;
}
void
SWGPERTesterSettings::setPacket(QString* packet) {
    this->packet = packet;
    this->m_packet_isSet = true;
}

qint32
SWGPERTesterSettings::getIgnoreLeadingBytes() {
    return ignore_leading_bytes;
}
void
SWGPERTesterSettings::setIgnoreLeadingBytes(qint32 ignore_leading_bytes) {
    this->ignore_leading_bytes = ignore_leading_bytes;
    this->m_ignore_leading_bytes_isSet = true;
}

qint32
SWGPERTesterSettings::getIgnoreTrailingBytes() {
    return ignore_trailing_bytes;
}
void
SWGPERTesterSettings::setIgnoreTrailingBytes(qint32 ignore_trailing_bytes) {
    this->ignore_trailing_bytes = ignore_trailing_bytes;
    this->m_ignore_trailing_bytes_isSet = true;
}

QString*
SWGPERTesterSettings::getTxUdpAddress() {
    return tx_udp_address;
}
void
SWGPERTesterSettings::setTxUdpAddress(QString* tx_udp_address) {
    this->tx_udp_address = tx_udp_address;
    this->m_tx_udp_address_isSet = true;
}

qint32
SWGPERTesterSettings::getTxUdpPort() {
    return tx_udp_port;
}
void
SWGPERTesterSettings::setTxUdpPort(qint32 tx_udp_port) {
    this->tx_udp_port = tx_udp_port;
    this->m_tx_udp_port_isSet = true;
}

QString*
SWGPERTesterSettings::getRxUdpAddress() {
    return rx_udp_address;
}
void
SWGPERTesterSettings::setRxUdpAddress(QString* rx_udp_address) {
    this->rx_udp_address = rx_udp_address;
    this->m_rx_udp_address_isSet = true;
}

qint32
SWGPERTesterSettings::getRxUdpPort() {
    return rx_udp_port;
}
void
SWGPERTesterSettings::setRxUdpPort(qint32 rx_udp_port) {
    this->rx_udp_port = rx_udp_port;
    this->m_rx_udp_port_isSet = true;
}

QString*
SWGPERTesterSettings::getTitle() {
    return title;
}
void
SWGPERTesterSettings::setTitle(QString* title) {
    this->title = title;
    this->m_title_isSet = true;
}

qint32
SWGPERTesterSettings::getRgbColor() {
    return rgb_color;
}
void
SWGPERTesterSettings::setRgbColor(qint32 rgb_color) {
    this->rgb_color = rgb_color;
    this->m_rgb_color_isSet = true;
}

qint32
SWGPERTesterSettings::getUseReverseApi() {
    return use_reverse_api;
}
void
SWGPERTesterSettings::setUseReverseApi(qint32 use_reverse_api) {
    this->use_reverse_api = use_reverse_api;
    this->m_use_reverse_api_isSet = true;
}

QString*
SWGPERTesterSettings::getReverseApiAddress() {
    return reverse_api_address;
}
void
SWGPERTesterSettings::setReverseApiAddress(QString* reverse_api_address) {
    this->reverse_api_address = reverse_api_address;
    this->m_reverse_api_address_isSet = true;
}

qint32
SWGPERTesterSettings::getReverseApiPort() {
    return reverse_api_port;
}
void
SWGPERTesterSettings::setReverseApiPort(qint32 reverse_api_port) {
    this->reverse_api_port = reverse_api_port;
    this->m_reverse_api_port_isSet = true;
}

qint32
SWGPERTesterSettings::getReverseApiFeatureSetIndex() {
    return reverse_api_feature_set_index;
}
void
SWGPERTesterSettings::setReverseApiFeatureSetIndex(qint32 reverse_api_feature_set_index) {
    this->reverse_api_feature_set_index = reverse_api_feature_set_index;
    this->m_reverse_api_feature_set_index_isSet = true;
}

qint32
SWGPERTesterSettings::getReverseApiFeatureIndex() {
    return reverse_api_feature_index;
}
void
SWGPERTesterSettings::setReverseApiFeatureIndex(qint32 reverse_api_feature_index) {
    this->reverse_api_feature_index = reverse_api_feature_index;
    this->m_reverse_api_feature_index_isSet = true;
}

SWGRollupState*
SWGPERTesterSettings::getRollupState() {
    return rollup_state;
}
void
SWGPERTesterSettings::setRollupState(SWGRollupState* rollup_state) {
    this->rollup_state = rollup_state;
    this->m_rollup_state_isSet = true;
}


bool
SWGPERTesterSettings::isSet(){
    bool isObjectUpdated = false;
    do{
        if(m_packet_count_isSet){
            isObjectUpdated = true; break;
        }
        if(m_interval_isSet){
            isObjectUpdated = true; break;
        }
        if(m_start_isSet){
            isObjectUpdated = true; break;
        }
        if(satellites && (satellites->size() > 0)){
            isObjectUpdated = true; break;
        }
        if(packet && *packet != QString("")){
            isObjectUpdated = true; break;
        }
        if(m_ignore_leading_bytes_isSet){
            isObjectUpdated = true; break;
        }
        if(m_ignore_trailing_bytes_isSet){
            isObjectUpdated = true; break;
        }
        if(tx_udp_address && *tx_udp_address != QString("")){
            isObjectUpdated = true; break;
        }
        if(m_tx_udp_port_isSet){
            isObjectUpdated = true; break;
        }
        if(rx_udp_address && *rx_udp_address != QString("")){
            isObjectUpdated = true; break;
        }
        if(m_rx_udp_port_isSet){
            isObjectUpdated = true; break;
        }
        if(title && *title != QString("")){
            isObjectUpdated = true; break;
        }
        if(m_rgb_color_isSet){
            isObjectUpdated = true; break;
        }
        if(m_use_reverse_api_isSet){
            isObjectUpdated = true; break;
        }
        if(reverse_api_address && *reverse_api_address != QString("")){
            isObjectUpdated = true; break;
        }
        if(m_reverse_api_port_isSet){
            isObjectUpdated = true; break;
        }
        if(m_reverse_api_feature_set_index_isSet){
            isObjectUpdated = true; break;
        }
        if(m_reverse_api_feature_index_isSet){
            isObjectUpdated = true; break;
        }
        if(rollup_state && rollup_state->isSet()){
            isObjectUpdated = true; break;
        }
    }while(false);
    return isObjectUpdated;
}
}

