/**
 * SDRangel
 * This is the web REST/JSON API of SDRangel SDR software. SDRangel is an Open Source Qt5/OpenGL 3.0+ (4.3+ in Windows) GUI and server Software Defined Radio and signal analyzer in software. It supports Airspy, BladeRF, HackRF, LimeSDR, PlutoSDR, RTL-SDR, SDRplay RSP1 and FunCube    ---   Limitations and specifcities:    * In SDRangel GUI the first Rx device set cannot be deleted. Conversely the server starts with no device sets and its number of device sets can be reduced to zero by as many calls as necessary to /sdrangel/deviceset with DELETE method.   * Preset import and export from/to file is a server only feature.   * Device set focus is a GUI only feature.   * The following channels are not implemented (status 501 is returned): ATV and DATV demodulators, Channel Analyzer NG, LoRa demodulator   * The device settings and report structures contains only the sub-structure corresponding to the device type. The DeviceSettings and DeviceReport structures documented here shows all of them but only one will be or should be present at a time   * The channel settings and report structures contains only the sub-structure corresponding to the channel type. The ChannelSettings and ChannelReport structures documented here shows all of them but only one will be or should be present at a time    --- 
 *
 * OpenAPI spec version: 6.0.0
 * Contact: f4exb06@gmail.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

#include "SWGFeatureSetApi.h"
#include "SWGHelpers.h"
#include "SWGModelFactory.h"

#include <QJsonArray>
#include <QJsonDocument>

namespace SWGSDRangel {

SWGFeatureSetApi::SWGFeatureSetApi() {}

SWGFeatureSetApi::~SWGFeatureSetApi() {}

SWGFeatureSetApi::SWGFeatureSetApi(QString host, QString basePath) {
    this->host = host;
    this->basePath = basePath;
}

void
SWGFeatureSetApi::featuresetFEatureSettingsPut(qint32 feature_set_index, qint32 feature_index, SWGFeatureSettings& body) {
    QString fullPath;
    fullPath.append(this->host).append(this->basePath).append("/sdrangel/featureset/{featureSetIndex}/feature/{featureIndex}/settings");

    QString feature_set_indexPathParam("{"); feature_set_indexPathParam.append("featureSetIndex").append("}");
    fullPath.replace(feature_set_indexPathParam, stringValue(feature_set_index));
    QString feature_indexPathParam("{"); feature_indexPathParam.append("featureIndex").append("}");
    fullPath.replace(feature_indexPathParam, stringValue(feature_index));


    SWGHttpRequestWorker *worker = new SWGHttpRequestWorker();
    SWGHttpRequestInput input(fullPath, "PUT");


    
    QString output = body.asJson();
    input.request_body.append(output.toUtf8());
    


    foreach(QString key, this->defaultHeaders.keys()) {
        input.headers.insert(key, this->defaultHeaders.value(key));
    }

    connect(worker,
            &SWGHttpRequestWorker::on_execution_finished,
            this,
            &SWGFeatureSetApi::featuresetFEatureSettingsPutCallback);

    worker->execute(&input);
}

void
SWGFeatureSetApi::featuresetFEatureSettingsPutCallback(SWGHttpRequestWorker * worker) {
    QString msg;
    QString error_str = worker->error_str;
    QNetworkReply::NetworkError error_type = worker->error_type;

    if (worker->error_type == QNetworkReply::NoError) {
        msg = QString("Success! %1 bytes").arg(worker->response.length());
    }
    else {
        msg = "Error: " + worker->error_str;
    }


    QString json(worker->response);
    SWGFeatureSettings* output = static_cast<SWGFeatureSettings*>(create(json, QString("SWGFeatureSettings")));
    worker->deleteLater();

    if (worker->error_type == QNetworkReply::NoError) {
        emit featuresetFEatureSettingsPutSignal(output);
    } else {
        emit featuresetFEatureSettingsPutSignalE(output, error_type, error_str);
        emit featuresetFEatureSettingsPutSignalEFull(worker, error_type, error_str);
    }
}

void
SWGFeatureSetApi::featuresetFeatureActionsPost(qint32 feature_set_index, qint32 feature_index, SWGFeatureActions& body) {
    QString fullPath;
    fullPath.append(this->host).append(this->basePath).append("/sdrangel/featureset/{featureSetIndex}/feature/{featureIndex}/actions");

    QString feature_set_indexPathParam("{"); feature_set_indexPathParam.append("featureSetIndex").append("}");
    fullPath.replace(feature_set_indexPathParam, stringValue(feature_set_index));
    QString feature_indexPathParam("{"); feature_indexPathParam.append("featureIndex").append("}");
    fullPath.replace(feature_indexPathParam, stringValue(feature_index));


    SWGHttpRequestWorker *worker = new SWGHttpRequestWorker();
    SWGHttpRequestInput input(fullPath, "POST");


    
    QString output = body.asJson();
    input.request_body.append(output.toUtf8());
    


    foreach(QString key, this->defaultHeaders.keys()) {
        input.headers.insert(key, this->defaultHeaders.value(key));
    }

    connect(worker,
            &SWGHttpRequestWorker::on_execution_finished,
            this,
            &SWGFeatureSetApi::featuresetFeatureActionsPostCallback);

    worker->execute(&input);
}

void
SWGFeatureSetApi::featuresetFeatureActionsPostCallback(SWGHttpRequestWorker * worker) {
    QString msg;
    QString error_str = worker->error_str;
    QNetworkReply::NetworkError error_type = worker->error_type;

    if (worker->error_type == QNetworkReply::NoError) {
        msg = QString("Success! %1 bytes").arg(worker->response.length());
    }
    else {
        msg = "Error: " + worker->error_str;
    }


    QString json(worker->response);
    SWGSuccessResponse* output = static_cast<SWGSuccessResponse*>(create(json, QString("SWGSuccessResponse")));
    worker->deleteLater();

    if (worker->error_type == QNetworkReply::NoError) {
        emit featuresetFeatureActionsPostSignal(output);
    } else {
        emit featuresetFeatureActionsPostSignalE(output, error_type, error_str);
        emit featuresetFeatureActionsPostSignalEFull(worker, error_type, error_str);
    }
}

void
SWGFeatureSetApi::featuresetFeatureDelete(qint32 feature_set_index, qint32 feature_index) {
    QString fullPath;
    fullPath.append(this->host).append(this->basePath).append("/sdrangel/featureset/{featureSetIndex}/feature/{featureIndex}");

    QString feature_set_indexPathParam("{"); feature_set_indexPathParam.append("featureSetIndex").append("}");
    fullPath.replace(feature_set_indexPathParam, stringValue(feature_set_index));
    QString feature_indexPathParam("{"); feature_indexPathParam.append("featureIndex").append("}");
    fullPath.replace(feature_indexPathParam, stringValue(feature_index));


    SWGHttpRequestWorker *worker = new SWGHttpRequestWorker();
    SWGHttpRequestInput input(fullPath, "DELETE");





    foreach(QString key, this->defaultHeaders.keys()) {
        input.headers.insert(key, this->defaultHeaders.value(key));
    }

    connect(worker,
            &SWGHttpRequestWorker::on_execution_finished,
            this,
            &SWGFeatureSetApi::featuresetFeatureDeleteCallback);

    worker->execute(&input);
}

void
SWGFeatureSetApi::featuresetFeatureDeleteCallback(SWGHttpRequestWorker * worker) {
    QString msg;
    QString error_str = worker->error_str;
    QNetworkReply::NetworkError error_type = worker->error_type;

    if (worker->error_type == QNetworkReply::NoError) {
        msg = QString("Success! %1 bytes").arg(worker->response.length());
    }
    else {
        msg = "Error: " + worker->error_str;
    }


    QString json(worker->response);
    SWGFeatureSettings* output = static_cast<SWGFeatureSettings*>(create(json, QString("SWGFeatureSettings")));
    worker->deleteLater();

    if (worker->error_type == QNetworkReply::NoError) {
        emit featuresetFeatureDeleteSignal(output);
    } else {
        emit featuresetFeatureDeleteSignalE(output, error_type, error_str);
        emit featuresetFeatureDeleteSignalEFull(worker, error_type, error_str);
    }
}

void
SWGFeatureSetApi::featuresetFeaturePost(qint32 feature_set_index, SWGFeatureSettings& body) {
    QString fullPath;
    fullPath.append(this->host).append(this->basePath).append("/sdrangel/featureset/{featureSetIndex}/feature");

    QString feature_set_indexPathParam("{"); feature_set_indexPathParam.append("featureSetIndex").append("}");
    fullPath.replace(feature_set_indexPathParam, stringValue(feature_set_index));


    SWGHttpRequestWorker *worker = new SWGHttpRequestWorker();
    SWGHttpRequestInput input(fullPath, "POST");


    
    QString output = body.asJson();
    input.request_body.append(output.toUtf8());
    


    foreach(QString key, this->defaultHeaders.keys()) {
        input.headers.insert(key, this->defaultHeaders.value(key));
    }

    connect(worker,
            &SWGHttpRequestWorker::on_execution_finished,
            this,
            &SWGFeatureSetApi::featuresetFeaturePostCallback);

    worker->execute(&input);
}

void
SWGFeatureSetApi::featuresetFeaturePostCallback(SWGHttpRequestWorker * worker) {
    QString msg;
    QString error_str = worker->error_str;
    QNetworkReply::NetworkError error_type = worker->error_type;

    if (worker->error_type == QNetworkReply::NoError) {
        msg = QString("Success! %1 bytes").arg(worker->response.length());
    }
    else {
        msg = "Error: " + worker->error_str;
    }


    QString json(worker->response);
    SWGSuccessResponse* output = static_cast<SWGSuccessResponse*>(create(json, QString("SWGSuccessResponse")));
    worker->deleteLater();

    if (worker->error_type == QNetworkReply::NoError) {
        emit featuresetFeaturePostSignal(output);
    } else {
        emit featuresetFeaturePostSignalE(output, error_type, error_str);
        emit featuresetFeaturePostSignalEFull(worker, error_type, error_str);
    }
}

void
SWGFeatureSetApi::featuresetFeatureReportGet(qint32 feature_set_index, qint32 feature_index) {
    QString fullPath;
    fullPath.append(this->host).append(this->basePath).append("/sdrangel/featureset/{featureSetIndex}/feature/{featureIndex}/report");

    QString feature_set_indexPathParam("{"); feature_set_indexPathParam.append("featureSetIndex").append("}");
    fullPath.replace(feature_set_indexPathParam, stringValue(feature_set_index));
    QString feature_indexPathParam("{"); feature_indexPathParam.append("featureIndex").append("}");
    fullPath.replace(feature_indexPathParam, stringValue(feature_index));


    SWGHttpRequestWorker *worker = new SWGHttpRequestWorker();
    SWGHttpRequestInput input(fullPath, "GET");





    foreach(QString key, this->defaultHeaders.keys()) {
        input.headers.insert(key, this->defaultHeaders.value(key));
    }

    connect(worker,
            &SWGHttpRequestWorker::on_execution_finished,
            this,
            &SWGFeatureSetApi::featuresetFeatureReportGetCallback);

    worker->execute(&input);
}

void
SWGFeatureSetApi::featuresetFeatureReportGetCallback(SWGHttpRequestWorker * worker) {
    QString msg;
    QString error_str = worker->error_str;
    QNetworkReply::NetworkError error_type = worker->error_type;

    if (worker->error_type == QNetworkReply::NoError) {
        msg = QString("Success! %1 bytes").arg(worker->response.length());
    }
    else {
        msg = "Error: " + worker->error_str;
    }


    QString json(worker->response);
    SWGFeatureReport* output = static_cast<SWGFeatureReport*>(create(json, QString("SWGFeatureReport")));
    worker->deleteLater();

    if (worker->error_type == QNetworkReply::NoError) {
        emit featuresetFeatureReportGetSignal(output);
    } else {
        emit featuresetFeatureReportGetSignalE(output, error_type, error_str);
        emit featuresetFeatureReportGetSignalEFull(worker, error_type, error_str);
    }
}

void
SWGFeatureSetApi::featuresetFeatureRunDelete(qint32 feature_set_index, qint32 feature_index) {
    QString fullPath;
    fullPath.append(this->host).append(this->basePath).append("/sdrangel/featureset/{featureSetIndex}/feature/{featureIndex}/run");

    QString feature_set_indexPathParam("{"); feature_set_indexPathParam.append("featureSetIndex").append("}");
    fullPath.replace(feature_set_indexPathParam, stringValue(feature_set_index));
    QString feature_indexPathParam("{"); feature_indexPathParam.append("featureIndex").append("}");
    fullPath.replace(feature_indexPathParam, stringValue(feature_index));


    SWGHttpRequestWorker *worker = new SWGHttpRequestWorker();
    SWGHttpRequestInput input(fullPath, "DELETE");





    foreach(QString key, this->defaultHeaders.keys()) {
        input.headers.insert(key, this->defaultHeaders.value(key));
    }

    connect(worker,
            &SWGHttpRequestWorker::on_execution_finished,
            this,
            &SWGFeatureSetApi::featuresetFeatureRunDeleteCallback);

    worker->execute(&input);
}

void
SWGFeatureSetApi::featuresetFeatureRunDeleteCallback(SWGHttpRequestWorker * worker) {
    QString msg;
    QString error_str = worker->error_str;
    QNetworkReply::NetworkError error_type = worker->error_type;

    if (worker->error_type == QNetworkReply::NoError) {
        msg = QString("Success! %1 bytes").arg(worker->response.length());
    }
    else {
        msg = "Error: " + worker->error_str;
    }


    QString json(worker->response);
    SWGDeviceState* output = static_cast<SWGDeviceState*>(create(json, QString("SWGDeviceState")));
    worker->deleteLater();

    if (worker->error_type == QNetworkReply::NoError) {
        emit featuresetFeatureRunDeleteSignal(output);
    } else {
        emit featuresetFeatureRunDeleteSignalE(output, error_type, error_str);
        emit featuresetFeatureRunDeleteSignalEFull(worker, error_type, error_str);
    }
}

void
SWGFeatureSetApi::featuresetFeatureRunGet(qint32 feature_set_index, qint32 feature_index) {
    QString fullPath;
    fullPath.append(this->host).append(this->basePath).append("/sdrangel/featureset/{featureSetIndex}/feature/{featureIndex}/run");

    QString feature_set_indexPathParam("{"); feature_set_indexPathParam.append("featureSetIndex").append("}");
    fullPath.replace(feature_set_indexPathParam, stringValue(feature_set_index));
    QString feature_indexPathParam("{"); feature_indexPathParam.append("featureIndex").append("}");
    fullPath.replace(feature_indexPathParam, stringValue(feature_index));


    SWGHttpRequestWorker *worker = new SWGHttpRequestWorker();
    SWGHttpRequestInput input(fullPath, "GET");





    foreach(QString key, this->defaultHeaders.keys()) {
        input.headers.insert(key, this->defaultHeaders.value(key));
    }

    connect(worker,
            &SWGHttpRequestWorker::on_execution_finished,
            this,
            &SWGFeatureSetApi::featuresetFeatureRunGetCallback);

    worker->execute(&input);
}

void
SWGFeatureSetApi::featuresetFeatureRunGetCallback(SWGHttpRequestWorker * worker) {
    QString msg;
    QString error_str = worker->error_str;
    QNetworkReply::NetworkError error_type = worker->error_type;

    if (worker->error_type == QNetworkReply::NoError) {
        msg = QString("Success! %1 bytes").arg(worker->response.length());
    }
    else {
        msg = "Error: " + worker->error_str;
    }


    QString json(worker->response);
    SWGDeviceState* output = static_cast<SWGDeviceState*>(create(json, QString("SWGDeviceState")));
    worker->deleteLater();

    if (worker->error_type == QNetworkReply::NoError) {
        emit featuresetFeatureRunGetSignal(output);
    } else {
        emit featuresetFeatureRunGetSignalE(output, error_type, error_str);
        emit featuresetFeatureRunGetSignalEFull(worker, error_type, error_str);
    }
}

void
SWGFeatureSetApi::featuresetFeatureRunPost(qint32 feature_set_index, qint32 feature_index) {
    QString fullPath;
    fullPath.append(this->host).append(this->basePath).append("/sdrangel/featureset/{featureSetIndex}/feature/{featureIndex}/run");

    QString feature_set_indexPathParam("{"); feature_set_indexPathParam.append("featureSetIndex").append("}");
    fullPath.replace(feature_set_indexPathParam, stringValue(feature_set_index));
    QString feature_indexPathParam("{"); feature_indexPathParam.append("featureIndex").append("}");
    fullPath.replace(feature_indexPathParam, stringValue(feature_index));


    SWGHttpRequestWorker *worker = new SWGHttpRequestWorker();
    SWGHttpRequestInput input(fullPath, "POST");





    foreach(QString key, this->defaultHeaders.keys()) {
        input.headers.insert(key, this->defaultHeaders.value(key));
    }

    connect(worker,
            &SWGHttpRequestWorker::on_execution_finished,
            this,
            &SWGFeatureSetApi::featuresetFeatureRunPostCallback);

    worker->execute(&input);
}

void
SWGFeatureSetApi::featuresetFeatureRunPostCallback(SWGHttpRequestWorker * worker) {
    QString msg;
    QString error_str = worker->error_str;
    QNetworkReply::NetworkError error_type = worker->error_type;

    if (worker->error_type == QNetworkReply::NoError) {
        msg = QString("Success! %1 bytes").arg(worker->response.length());
    }
    else {
        msg = "Error: " + worker->error_str;
    }


    QString json(worker->response);
    SWGDeviceState* output = static_cast<SWGDeviceState*>(create(json, QString("SWGDeviceState")));
    worker->deleteLater();

    if (worker->error_type == QNetworkReply::NoError) {
        emit featuresetFeatureRunPostSignal(output);
    } else {
        emit featuresetFeatureRunPostSignalE(output, error_type, error_str);
        emit featuresetFeatureRunPostSignalEFull(worker, error_type, error_str);
    }
}

void
SWGFeatureSetApi::featuresetFeatureSettingsGet(qint32 feature_set_index, qint32 feature_index) {
    QString fullPath;
    fullPath.append(this->host).append(this->basePath).append("/sdrangel/featureset/{featureSetIndex}/feature/{featureIndex}/settings");

    QString feature_set_indexPathParam("{"); feature_set_indexPathParam.append("featureSetIndex").append("}");
    fullPath.replace(feature_set_indexPathParam, stringValue(feature_set_index));
    QString feature_indexPathParam("{"); feature_indexPathParam.append("featureIndex").append("}");
    fullPath.replace(feature_indexPathParam, stringValue(feature_index));


    SWGHttpRequestWorker *worker = new SWGHttpRequestWorker();
    SWGHttpRequestInput input(fullPath, "GET");





    foreach(QString key, this->defaultHeaders.keys()) {
        input.headers.insert(key, this->defaultHeaders.value(key));
    }

    connect(worker,
            &SWGHttpRequestWorker::on_execution_finished,
            this,
            &SWGFeatureSetApi::featuresetFeatureSettingsGetCallback);

    worker->execute(&input);
}

void
SWGFeatureSetApi::featuresetFeatureSettingsGetCallback(SWGHttpRequestWorker * worker) {
    QString msg;
    QString error_str = worker->error_str;
    QNetworkReply::NetworkError error_type = worker->error_type;

    if (worker->error_type == QNetworkReply::NoError) {
        msg = QString("Success! %1 bytes").arg(worker->response.length());
    }
    else {
        msg = "Error: " + worker->error_str;
    }


    QString json(worker->response);
    SWGFeatureSettings* output = static_cast<SWGFeatureSettings*>(create(json, QString("SWGFeatureSettings")));
    worker->deleteLater();

    if (worker->error_type == QNetworkReply::NoError) {
        emit featuresetFeatureSettingsGetSignal(output);
    } else {
        emit featuresetFeatureSettingsGetSignalE(output, error_type, error_str);
        emit featuresetFeatureSettingsGetSignalEFull(worker, error_type, error_str);
    }
}

void
SWGFeatureSetApi::featuresetFeatureSettingsPatch(qint32 feature_set_index, qint32 feature_index, SWGFeatureSettings& body) {
    QString fullPath;
    fullPath.append(this->host).append(this->basePath).append("/sdrangel/featureset/{featureSetIndex}/feature/{featureIndex}/settings");

    QString feature_set_indexPathParam("{"); feature_set_indexPathParam.append("featureSetIndex").append("}");
    fullPath.replace(feature_set_indexPathParam, stringValue(feature_set_index));
    QString feature_indexPathParam("{"); feature_indexPathParam.append("featureIndex").append("}");
    fullPath.replace(feature_indexPathParam, stringValue(feature_index));


    SWGHttpRequestWorker *worker = new SWGHttpRequestWorker();
    SWGHttpRequestInput input(fullPath, "PATCH");


    
    QString output = body.asJson();
    input.request_body.append(output.toUtf8());
    


    foreach(QString key, this->defaultHeaders.keys()) {
        input.headers.insert(key, this->defaultHeaders.value(key));
    }

    connect(worker,
            &SWGHttpRequestWorker::on_execution_finished,
            this,
            &SWGFeatureSetApi::featuresetFeatureSettingsPatchCallback);

    worker->execute(&input);
}

void
SWGFeatureSetApi::featuresetFeatureSettingsPatchCallback(SWGHttpRequestWorker * worker) {
    QString msg;
    QString error_str = worker->error_str;
    QNetworkReply::NetworkError error_type = worker->error_type;

    if (worker->error_type == QNetworkReply::NoError) {
        msg = QString("Success! %1 bytes").arg(worker->response.length());
    }
    else {
        msg = "Error: " + worker->error_str;
    }


    QString json(worker->response);
    SWGFeatureSettings* output = static_cast<SWGFeatureSettings*>(create(json, QString("SWGFeatureSettings")));
    worker->deleteLater();

    if (worker->error_type == QNetworkReply::NoError) {
        emit featuresetFeatureSettingsPatchSignal(output);
    } else {
        emit featuresetFeatureSettingsPatchSignalE(output, error_type, error_str);
        emit featuresetFeatureSettingsPatchSignalEFull(worker, error_type, error_str);
    }
}

void
SWGFeatureSetApi::featuresetGet(qint32 feature_set_index) {
    QString fullPath;
    fullPath.append(this->host).append(this->basePath).append("/sdrangel/featureset/{featureSetIndex}");

    QString feature_set_indexPathParam("{"); feature_set_indexPathParam.append("featureSetIndex").append("}");
    fullPath.replace(feature_set_indexPathParam, stringValue(feature_set_index));


    SWGHttpRequestWorker *worker = new SWGHttpRequestWorker();
    SWGHttpRequestInput input(fullPath, "GET");





    foreach(QString key, this->defaultHeaders.keys()) {
        input.headers.insert(key, this->defaultHeaders.value(key));
    }

    connect(worker,
            &SWGHttpRequestWorker::on_execution_finished,
            this,
            &SWGFeatureSetApi::featuresetGetCallback);

    worker->execute(&input);
}

void
SWGFeatureSetApi::featuresetGetCallback(SWGHttpRequestWorker * worker) {
    QString msg;
    QString error_str = worker->error_str;
    QNetworkReply::NetworkError error_type = worker->error_type;

    if (worker->error_type == QNetworkReply::NoError) {
        msg = QString("Success! %1 bytes").arg(worker->response.length());
    }
    else {
        msg = "Error: " + worker->error_str;
    }


    QString json(worker->response);
    SWGFeatureSet* output = static_cast<SWGFeatureSet*>(create(json, QString("SWGFeatureSet")));
    worker->deleteLater();

    if (worker->error_type == QNetworkReply::NoError) {
        emit featuresetGetSignal(output);
    } else {
        emit featuresetGetSignalE(output, error_type, error_str);
        emit featuresetGetSignalEFull(worker, error_type, error_str);
    }
}

void
SWGFeatureSetApi::featuresetPresetPatch(qint32 feature_set_index, SWGFeaturePresetIdentifier& body) {
    QString fullPath;
    fullPath.append(this->host).append(this->basePath).append("/sdrangel/featureset/{featureSetIndex}/preset");

    QString feature_set_indexPathParam("{"); feature_set_indexPathParam.append("featureSetIndex").append("}");
    fullPath.replace(feature_set_indexPathParam, stringValue(feature_set_index));


    SWGHttpRequestWorker *worker = new SWGHttpRequestWorker();
    SWGHttpRequestInput input(fullPath, "PATCH");


    
    QString output = body.asJson();
    input.request_body.append(output.toUtf8());
    


    foreach(QString key, this->defaultHeaders.keys()) {
        input.headers.insert(key, this->defaultHeaders.value(key));
    }

    connect(worker,
            &SWGHttpRequestWorker::on_execution_finished,
            this,
            &SWGFeatureSetApi::featuresetPresetPatchCallback);

    worker->execute(&input);
}

void
SWGFeatureSetApi::featuresetPresetPatchCallback(SWGHttpRequestWorker * worker) {
    QString msg;
    QString error_str = worker->error_str;
    QNetworkReply::NetworkError error_type = worker->error_type;

    if (worker->error_type == QNetworkReply::NoError) {
        msg = QString("Success! %1 bytes").arg(worker->response.length());
    }
    else {
        msg = "Error: " + worker->error_str;
    }


    QString json(worker->response);
    SWGFeaturePresetIdentifier* output = static_cast<SWGFeaturePresetIdentifier*>(create(json, QString("SWGFeaturePresetIdentifier")));
    worker->deleteLater();

    if (worker->error_type == QNetworkReply::NoError) {
        emit featuresetPresetPatchSignal(output);
    } else {
        emit featuresetPresetPatchSignalE(output, error_type, error_str);
        emit featuresetPresetPatchSignalEFull(worker, error_type, error_str);
    }
}

void
SWGFeatureSetApi::featuresetPresetPost(qint32 feature_set_index, SWGFeaturePresetIdentifier& body) {
    QString fullPath;
    fullPath.append(this->host).append(this->basePath).append("/sdrangel/featureset/{featureSetIndex}/preset");

    QString feature_set_indexPathParam("{"); feature_set_indexPathParam.append("featureSetIndex").append("}");
    fullPath.replace(feature_set_indexPathParam, stringValue(feature_set_index));


    SWGHttpRequestWorker *worker = new SWGHttpRequestWorker();
    SWGHttpRequestInput input(fullPath, "POST");


    
    QString output = body.asJson();
    input.request_body.append(output.toUtf8());
    


    foreach(QString key, this->defaultHeaders.keys()) {
        input.headers.insert(key, this->defaultHeaders.value(key));
    }

    connect(worker,
            &SWGHttpRequestWorker::on_execution_finished,
            this,
            &SWGFeatureSetApi::featuresetPresetPostCallback);

    worker->execute(&input);
}

void
SWGFeatureSetApi::featuresetPresetPostCallback(SWGHttpRequestWorker * worker) {
    QString msg;
    QString error_str = worker->error_str;
    QNetworkReply::NetworkError error_type = worker->error_type;

    if (worker->error_type == QNetworkReply::NoError) {
        msg = QString("Success! %1 bytes").arg(worker->response.length());
    }
    else {
        msg = "Error: " + worker->error_str;
    }


    QString json(worker->response);
    SWGPresetIdentifier* output = static_cast<SWGPresetIdentifier*>(create(json, QString("SWGPresetIdentifier")));
    worker->deleteLater();

    if (worker->error_type == QNetworkReply::NoError) {
        emit featuresetPresetPostSignal(output);
    } else {
        emit featuresetPresetPostSignalE(output, error_type, error_str);
        emit featuresetPresetPostSignalEFull(worker, error_type, error_str);
    }
}

void
SWGFeatureSetApi::featuresetPresetPut(qint32 feature_set_index, SWGFeaturePresetIdentifier& body) {
    QString fullPath;
    fullPath.append(this->host).append(this->basePath).append("/sdrangel/featureset/{featureSetIndex}/preset");

    QString feature_set_indexPathParam("{"); feature_set_indexPathParam.append("featureSetIndex").append("}");
    fullPath.replace(feature_set_indexPathParam, stringValue(feature_set_index));


    SWGHttpRequestWorker *worker = new SWGHttpRequestWorker();
    SWGHttpRequestInput input(fullPath, "PUT");


    
    QString output = body.asJson();
    input.request_body.append(output.toUtf8());
    


    foreach(QString key, this->defaultHeaders.keys()) {
        input.headers.insert(key, this->defaultHeaders.value(key));
    }

    connect(worker,
            &SWGHttpRequestWorker::on_execution_finished,
            this,
            &SWGFeatureSetApi::featuresetPresetPutCallback);

    worker->execute(&input);
}

void
SWGFeatureSetApi::featuresetPresetPutCallback(SWGHttpRequestWorker * worker) {
    QString msg;
    QString error_str = worker->error_str;
    QNetworkReply::NetworkError error_type = worker->error_type;

    if (worker->error_type == QNetworkReply::NoError) {
        msg = QString("Success! %1 bytes").arg(worker->response.length());
    }
    else {
        msg = "Error: " + worker->error_str;
    }


    QString json(worker->response);
    SWGFeaturePresetIdentifier* output = static_cast<SWGFeaturePresetIdentifier*>(create(json, QString("SWGFeaturePresetIdentifier")));
    worker->deleteLater();

    if (worker->error_type == QNetworkReply::NoError) {
        emit featuresetPresetPutSignal(output);
    } else {
        emit featuresetPresetPutSignalE(output, error_type, error_str);
        emit featuresetPresetPutSignalEFull(worker, error_type, error_str);
    }
}

void
SWGFeatureSetApi::instanceFeatureSetDelete() {
    QString fullPath;
    fullPath.append(this->host).append(this->basePath).append("/sdrangel/featureset");



    SWGHttpRequestWorker *worker = new SWGHttpRequestWorker();
    SWGHttpRequestInput input(fullPath, "DELETE");





    foreach(QString key, this->defaultHeaders.keys()) {
        input.headers.insert(key, this->defaultHeaders.value(key));
    }

    connect(worker,
            &SWGHttpRequestWorker::on_execution_finished,
            this,
            &SWGFeatureSetApi::instanceFeatureSetDeleteCallback);

    worker->execute(&input);
}

void
SWGFeatureSetApi::instanceFeatureSetDeleteCallback(SWGHttpRequestWorker * worker) {
    QString msg;
    QString error_str = worker->error_str;
    QNetworkReply::NetworkError error_type = worker->error_type;

    if (worker->error_type == QNetworkReply::NoError) {
        msg = QString("Success! %1 bytes").arg(worker->response.length());
    }
    else {
        msg = "Error: " + worker->error_str;
    }


    QString json(worker->response);
    SWGSuccessResponse* output = static_cast<SWGSuccessResponse*>(create(json, QString("SWGSuccessResponse")));
    worker->deleteLater();

    if (worker->error_type == QNetworkReply::NoError) {
        emit instanceFeatureSetDeleteSignal(output);
    } else {
        emit instanceFeatureSetDeleteSignalE(output, error_type, error_str);
        emit instanceFeatureSetDeleteSignalEFull(worker, error_type, error_str);
    }
}

void
SWGFeatureSetApi::instanceFeatureSetPost() {
    QString fullPath;
    fullPath.append(this->host).append(this->basePath).append("/sdrangel/featureset");



    SWGHttpRequestWorker *worker = new SWGHttpRequestWorker();
    SWGHttpRequestInput input(fullPath, "POST");





    foreach(QString key, this->defaultHeaders.keys()) {
        input.headers.insert(key, this->defaultHeaders.value(key));
    }

    connect(worker,
            &SWGHttpRequestWorker::on_execution_finished,
            this,
            &SWGFeatureSetApi::instanceFeatureSetPostCallback);

    worker->execute(&input);
}

void
SWGFeatureSetApi::instanceFeatureSetPostCallback(SWGHttpRequestWorker * worker) {
    QString msg;
    QString error_str = worker->error_str;
    QNetworkReply::NetworkError error_type = worker->error_type;

    if (worker->error_type == QNetworkReply::NoError) {
        msg = QString("Success! %1 bytes").arg(worker->response.length());
    }
    else {
        msg = "Error: " + worker->error_str;
    }


    QString json(worker->response);
    SWGSuccessResponse* output = static_cast<SWGSuccessResponse*>(create(json, QString("SWGSuccessResponse")));
    worker->deleteLater();

    if (worker->error_type == QNetworkReply::NoError) {
        emit instanceFeatureSetPostSignal(output);
    } else {
        emit instanceFeatureSetPostSignalE(output, error_type, error_str);
        emit instanceFeatureSetPostSignalEFull(worker, error_type, error_str);
    }
}


}
