/**
 * SDRangel
 * This is the web REST/JSON API of SDRangel SDR software. SDRangel is an Open Source Qt5/OpenGL 3.0+ (4.3+ in Windows) GUI and server Software Defined Radio and signal analyzer in software. It supports Airspy, BladeRF, HackRF, LimeSDR, PlutoSDR, RTL-SDR, SDRplay RSP1 and FunCube    ---   Limitations and specifcities:    * In SDRangel GUI the first Rx device set cannot be deleted. Conversely the server starts with no device sets and its number of device sets can be reduced to zero by as many calls as necessary to /sdrangel/deviceset with DELETE method.   * Preset import and export from/to file is a server only feature.   * Device set focus is a GUI only feature.   * The following channels are not implemented (status 501 is returned): ATV and DATV demodulators, Channel Analyzer NG, LoRa demodulator   * The device settings and report structures contains only the sub-structure corresponding to the device type. The DeviceSettings and DeviceReport structures documented here shows all of them but only one will be or should be present at a time   * The channel settings and report structures contains only the sub-structure corresponding to the channel type. The ChannelSettings and ChannelReport structures documented here shows all of them but only one will be or should be present at a time    --- 
 *
 * OpenAPI spec version: 6.0.0
 * Contact: f4exb06@gmail.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


#include "SWGFeatureReport.h"

#include "SWGHelpers.h"

#include <QJsonDocument>
#include <QJsonArray>
#include <QObject>
#include <QDebug>

namespace SWGSDRangel {

SWGFeatureReport::SWGFeatureReport(QString* json) {
    init();
    this->fromJson(*json);
}

SWGFeatureReport::SWGFeatureReport() {
    feature_type = nullptr;
    m_feature_type_isSet = false;
    afc_report = nullptr;
    m_afc_report_isSet = false;
    gs232_controller_report = nullptr;
    m_gs232_controller_report_isSet = false;
    per_tester_report = nullptr;
    m_per_tester_report_isSet = false;
    rig_ctl_server_report = nullptr;
    m_rig_ctl_server_report_isSet = false;
    satellite_tracker_report = nullptr;
    m_satellite_tracker_report_isSet = false;
    simple_ptt_report = nullptr;
    m_simple_ptt_report_isSet = false;
    star_tracker_report = nullptr;
    m_star_tracker_report_isSet = false;
    vor_localizer_report = nullptr;
    m_vor_localizer_report_isSet = false;
}

SWGFeatureReport::~SWGFeatureReport() {
    this->cleanup();
}

void
SWGFeatureReport::init() {
    feature_type = new QString("");
    m_feature_type_isSet = false;
    afc_report = new SWGAFCReport();
    m_afc_report_isSet = false;
    gs232_controller_report = new SWGGS232ControllerReport();
    m_gs232_controller_report_isSet = false;
    per_tester_report = new SWGPERTesterReport();
    m_per_tester_report_isSet = false;
    rig_ctl_server_report = new SWGRigCtlServerReport();
    m_rig_ctl_server_report_isSet = false;
    satellite_tracker_report = new SWGSatelliteTrackerReport();
    m_satellite_tracker_report_isSet = false;
    simple_ptt_report = new SWGSimplePTTReport();
    m_simple_ptt_report_isSet = false;
    star_tracker_report = new SWGStarTrackerReport();
    m_star_tracker_report_isSet = false;
    vor_localizer_report = new SWGVORLocalizerReport();
    m_vor_localizer_report_isSet = false;
}

void
SWGFeatureReport::cleanup() {
    if(feature_type != nullptr) { 
        delete feature_type;
    }
    if(afc_report != nullptr) { 
        delete afc_report;
    }
    if(gs232_controller_report != nullptr) { 
        delete gs232_controller_report;
    }
    if(per_tester_report != nullptr) { 
        delete per_tester_report;
    }
    if(rig_ctl_server_report != nullptr) { 
        delete rig_ctl_server_report;
    }
    if(satellite_tracker_report != nullptr) { 
        delete satellite_tracker_report;
    }
    if(simple_ptt_report != nullptr) { 
        delete simple_ptt_report;
    }
    if(star_tracker_report != nullptr) { 
        delete star_tracker_report;
    }
    if(vor_localizer_report != nullptr) { 
        delete vor_localizer_report;
    }
}

SWGFeatureReport*
SWGFeatureReport::fromJson(QString &json) {
    QByteArray array (json.toStdString().c_str());
    QJsonDocument doc = QJsonDocument::fromJson(array);
    QJsonObject jsonObject = doc.object();
    this->fromJsonObject(jsonObject);
    return this;
}

void
SWGFeatureReport::fromJsonObject(QJsonObject &pJson) {
    ::SWGSDRangel::setValue(&feature_type, pJson["featureType"], "QString", "QString");
    
    ::SWGSDRangel::setValue(&afc_report, pJson["AFCReport"], "SWGAFCReport", "SWGAFCReport");
    
    ::SWGSDRangel::setValue(&gs232_controller_report, pJson["GS232ControllerReport"], "SWGGS232ControllerReport", "SWGGS232ControllerReport");
    
    ::SWGSDRangel::setValue(&per_tester_report, pJson["PERTesterReport"], "SWGPERTesterReport", "SWGPERTesterReport");
    
    ::SWGSDRangel::setValue(&rig_ctl_server_report, pJson["RigCtlServerReport"], "SWGRigCtlServerReport", "SWGRigCtlServerReport");
    
    ::SWGSDRangel::setValue(&satellite_tracker_report, pJson["SatelliteTrackerReport"], "SWGSatelliteTrackerReport", "SWGSatelliteTrackerReport");
    
    ::SWGSDRangel::setValue(&simple_ptt_report, pJson["SimplePTTReport"], "SWGSimplePTTReport", "SWGSimplePTTReport");
    
    ::SWGSDRangel::setValue(&star_tracker_report, pJson["StarTrackerReport"], "SWGStarTrackerReport", "SWGStarTrackerReport");
    
    ::SWGSDRangel::setValue(&vor_localizer_report, pJson["VORLocalizerReport"], "SWGVORLocalizerReport", "SWGVORLocalizerReport");
    
}

QString
SWGFeatureReport::asJson ()
{
    QJsonObject* obj = this->asJsonObject();

    QJsonDocument doc(*obj);
    QByteArray bytes = doc.toJson();
    delete obj;
    return QString(bytes);
}

QJsonObject*
SWGFeatureReport::asJsonObject() {
    QJsonObject* obj = new QJsonObject();
    if(feature_type != nullptr && *feature_type != QString("")){
        toJsonValue(QString("featureType"), feature_type, obj, QString("QString"));
    }
    if((afc_report != nullptr) && (afc_report->isSet())){
        toJsonValue(QString("AFCReport"), afc_report, obj, QString("SWGAFCReport"));
    }
    if((gs232_controller_report != nullptr) && (gs232_controller_report->isSet())){
        toJsonValue(QString("GS232ControllerReport"), gs232_controller_report, obj, QString("SWGGS232ControllerReport"));
    }
    if((per_tester_report != nullptr) && (per_tester_report->isSet())){
        toJsonValue(QString("PERTesterReport"), per_tester_report, obj, QString("SWGPERTesterReport"));
    }
    if((rig_ctl_server_report != nullptr) && (rig_ctl_server_report->isSet())){
        toJsonValue(QString("RigCtlServerReport"), rig_ctl_server_report, obj, QString("SWGRigCtlServerReport"));
    }
    if((satellite_tracker_report != nullptr) && (satellite_tracker_report->isSet())){
        toJsonValue(QString("SatelliteTrackerReport"), satellite_tracker_report, obj, QString("SWGSatelliteTrackerReport"));
    }
    if((simple_ptt_report != nullptr) && (simple_ptt_report->isSet())){
        toJsonValue(QString("SimplePTTReport"), simple_ptt_report, obj, QString("SWGSimplePTTReport"));
    }
    if((star_tracker_report != nullptr) && (star_tracker_report->isSet())){
        toJsonValue(QString("StarTrackerReport"), star_tracker_report, obj, QString("SWGStarTrackerReport"));
    }
    if((vor_localizer_report != nullptr) && (vor_localizer_report->isSet())){
        toJsonValue(QString("VORLocalizerReport"), vor_localizer_report, obj, QString("SWGVORLocalizerReport"));
    }

    return obj;
}

QString*
SWGFeatureReport::getFeatureType() {
    return feature_type;
}
void
SWGFeatureReport::setFeatureType(QString* feature_type) {
    this->feature_type = feature_type;
    this->m_feature_type_isSet = true;
}

SWGAFCReport*
SWGFeatureReport::getAfcReport() {
    return afc_report;
}
void
SWGFeatureReport::setAfcReport(SWGAFCReport* afc_report) {
    this->afc_report = afc_report;
    this->m_afc_report_isSet = true;
}

SWGGS232ControllerReport*
SWGFeatureReport::getGs232ControllerReport() {
    return gs232_controller_report;
}
void
SWGFeatureReport::setGs232ControllerReport(SWGGS232ControllerReport* gs232_controller_report) {
    this->gs232_controller_report = gs232_controller_report;
    this->m_gs232_controller_report_isSet = true;
}

SWGPERTesterReport*
SWGFeatureReport::getPerTesterReport() {
    return per_tester_report;
}
void
SWGFeatureReport::setPerTesterReport(SWGPERTesterReport* per_tester_report) {
    this->per_tester_report = per_tester_report;
    this->m_per_tester_report_isSet = true;
}

SWGRigCtlServerReport*
SWGFeatureReport::getRigCtlServerReport() {
    return rig_ctl_server_report;
}
void
SWGFeatureReport::setRigCtlServerReport(SWGRigCtlServerReport* rig_ctl_server_report) {
    this->rig_ctl_server_report = rig_ctl_server_report;
    this->m_rig_ctl_server_report_isSet = true;
}

SWGSatelliteTrackerReport*
SWGFeatureReport::getSatelliteTrackerReport() {
    return satellite_tracker_report;
}
void
SWGFeatureReport::setSatelliteTrackerReport(SWGSatelliteTrackerReport* satellite_tracker_report) {
    this->satellite_tracker_report = satellite_tracker_report;
    this->m_satellite_tracker_report_isSet = true;
}

SWGSimplePTTReport*
SWGFeatureReport::getSimplePttReport() {
    return simple_ptt_report;
}
void
SWGFeatureReport::setSimplePttReport(SWGSimplePTTReport* simple_ptt_report) {
    this->simple_ptt_report = simple_ptt_report;
    this->m_simple_ptt_report_isSet = true;
}

SWGStarTrackerReport*
SWGFeatureReport::getStarTrackerReport() {
    return star_tracker_report;
}
void
SWGFeatureReport::setStarTrackerReport(SWGStarTrackerReport* star_tracker_report) {
    this->star_tracker_report = star_tracker_report;
    this->m_star_tracker_report_isSet = true;
}

SWGVORLocalizerReport*
SWGFeatureReport::getVorLocalizerReport() {
    return vor_localizer_report;
}
void
SWGFeatureReport::setVorLocalizerReport(SWGVORLocalizerReport* vor_localizer_report) {
    this->vor_localizer_report = vor_localizer_report;
    this->m_vor_localizer_report_isSet = true;
}


bool
SWGFeatureReport::isSet(){
    bool isObjectUpdated = false;
    do{
        if(feature_type && *feature_type != QString("")){
            isObjectUpdated = true; break;
        }
        if(afc_report && afc_report->isSet()){
            isObjectUpdated = true; break;
        }
        if(gs232_controller_report && gs232_controller_report->isSet()){
            isObjectUpdated = true; break;
        }
        if(per_tester_report && per_tester_report->isSet()){
            isObjectUpdated = true; break;
        }
        if(rig_ctl_server_report && rig_ctl_server_report->isSet()){
            isObjectUpdated = true; break;
        }
        if(satellite_tracker_report && satellite_tracker_report->isSet()){
            isObjectUpdated = true; break;
        }
        if(simple_ptt_report && simple_ptt_report->isSet()){
            isObjectUpdated = true; break;
        }
        if(star_tracker_report && star_tracker_report->isSet()){
            isObjectUpdated = true; break;
        }
        if(vor_localizer_report && vor_localizer_report->isSet()){
            isObjectUpdated = true; break;
        }
    }while(false);
    return isObjectUpdated;
}
}

