/**
 * SDRangel
 * This is the web REST/JSON API of SDRangel SDR software. SDRangel is an Open Source Qt5/OpenGL 3.0+ (4.3+ in Windows) GUI and server Software Defined Radio and signal analyzer in software. It supports Airspy, BladeRF, HackRF, LimeSDR, PlutoSDR, RTL-SDR, SDRplay RSP1 and FunCube    ---   Limitations and specifcities:    * In SDRangel GUI the first Rx device set cannot be deleted. Conversely the server starts with no device sets and its number of device sets can be reduced to zero by as many calls as necessary to /sdrangel/deviceset with DELETE method.   * Preset import and export from/to file is a server only feature.   * Device set focus is a GUI only feature.   * The following channels are not implemented (status 501 is returned): ATV and DATV demodulators, Channel Analyzer NG, LoRa demodulator   * The device settings and report structures contains only the sub-structure corresponding to the device type. The DeviceSettings and DeviceReport structures documented here shows all of them but only one will be or should be present at a time   * The channel settings and report structures contains only the sub-structure corresponding to the channel type. The ChannelSettings and ChannelReport structures documented here shows all of them but only one will be or should be present at a time    --- 
 *
 * OpenAPI spec version: 6.0.0
 * Contact: f4exb06@gmail.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


#include "SWGFeatureListItem.h"

#include "SWGHelpers.h"

#include <QJsonDocument>
#include <QJsonArray>
#include <QObject>
#include <QDebug>

namespace SWGSDRangel {

SWGFeatureListItem::SWGFeatureListItem(QString* json) {
    init();
    this->fromJson(*json);
}

SWGFeatureListItem::SWGFeatureListItem() {
    name = nullptr;
    m_name_isSet = false;
    id_uri = nullptr;
    m_id_uri_isSet = false;
    id = nullptr;
    m_id_isSet = false;
    version = nullptr;
    m_version_isSet = false;
    index = 0;
    m_index_isSet = false;
}

SWGFeatureListItem::~SWGFeatureListItem() {
    this->cleanup();
}

void
SWGFeatureListItem::init() {
    name = new QString("");
    m_name_isSet = false;
    id_uri = new QString("");
    m_id_uri_isSet = false;
    id = new QString("");
    m_id_isSet = false;
    version = new QString("");
    m_version_isSet = false;
    index = 0;
    m_index_isSet = false;
}

void
SWGFeatureListItem::cleanup() {
    if(name != nullptr) { 
        delete name;
    }
    if(id_uri != nullptr) { 
        delete id_uri;
    }
    if(id != nullptr) { 
        delete id;
    }
    if(version != nullptr) { 
        delete version;
    }

}

SWGFeatureListItem*
SWGFeatureListItem::fromJson(QString &json) {
    QByteArray array (json.toStdString().c_str());
    QJsonDocument doc = QJsonDocument::fromJson(array);
    QJsonObject jsonObject = doc.object();
    this->fromJsonObject(jsonObject);
    return this;
}

void
SWGFeatureListItem::fromJsonObject(QJsonObject &pJson) {
    ::SWGSDRangel::setValue(&name, pJson["name"], "QString", "QString");
    
    ::SWGSDRangel::setValue(&id_uri, pJson["idURI"], "QString", "QString");
    
    ::SWGSDRangel::setValue(&id, pJson["id"], "QString", "QString");
    
    ::SWGSDRangel::setValue(&version, pJson["version"], "QString", "QString");
    
    ::SWGSDRangel::setValue(&index, pJson["index"], "qint32", "");
    
}

QString
SWGFeatureListItem::asJson ()
{
    QJsonObject* obj = this->asJsonObject();

    QJsonDocument doc(*obj);
    QByteArray bytes = doc.toJson();
    delete obj;
    return QString(bytes);
}

QJsonObject*
SWGFeatureListItem::asJsonObject() {
    QJsonObject* obj = new QJsonObject();
    if(name != nullptr && *name != QString("")){
        toJsonValue(QString("name"), name, obj, QString("QString"));
    }
    if(id_uri != nullptr && *id_uri != QString("")){
        toJsonValue(QString("idURI"), id_uri, obj, QString("QString"));
    }
    if(id != nullptr && *id != QString("")){
        toJsonValue(QString("id"), id, obj, QString("QString"));
    }
    if(version != nullptr && *version != QString("")){
        toJsonValue(QString("version"), version, obj, QString("QString"));
    }
    if(m_index_isSet){
        obj->insert("index", QJsonValue(index));
    }

    return obj;
}

QString*
SWGFeatureListItem::getName() {
    return name;
}
void
SWGFeatureListItem::setName(QString* name) {
    this->name = name;
    this->m_name_isSet = true;
}

QString*
SWGFeatureListItem::getIdUri() {
    return id_uri;
}
void
SWGFeatureListItem::setIdUri(QString* id_uri) {
    this->id_uri = id_uri;
    this->m_id_uri_isSet = true;
}

QString*
SWGFeatureListItem::getId() {
    return id;
}
void
SWGFeatureListItem::setId(QString* id) {
    this->id = id;
    this->m_id_isSet = true;
}

QString*
SWGFeatureListItem::getVersion() {
    return version;
}
void
SWGFeatureListItem::setVersion(QString* version) {
    this->version = version;
    this->m_version_isSet = true;
}

qint32
SWGFeatureListItem::getIndex() {
    return index;
}
void
SWGFeatureListItem::setIndex(qint32 index) {
    this->index = index;
    this->m_index_isSet = true;
}


bool
SWGFeatureListItem::isSet(){
    bool isObjectUpdated = false;
    do{
        if(name && *name != QString("")){
            isObjectUpdated = true; break;
        }
        if(id_uri && *id_uri != QString("")){
            isObjectUpdated = true; break;
        }
        if(id && *id != QString("")){
            isObjectUpdated = true; break;
        }
        if(version && *version != QString("")){
            isObjectUpdated = true; break;
        }
        if(m_index_isSet){
            isObjectUpdated = true; break;
        }
    }while(false);
    return isObjectUpdated;
}
}

