/**
 * SDRangel
 * This is the web REST/JSON API of SDRangel SDR software. SDRangel is an Open Source Qt5/OpenGL 3.0+ (4.3+ in Windows) GUI and server Software Defined Radio and signal analyzer in software. It supports Airspy, BladeRF, HackRF, LimeSDR, PlutoSDR, RTL-SDR, SDRplay RSP1 and FunCube    ---   Limitations and specifcities:    * In SDRangel GUI the first Rx device set cannot be deleted. Conversely the server starts with no device sets and its number of device sets can be reduced to zero by as many calls as necessary to /sdrangel/deviceset with DELETE method.   * Preset import and export from/to file is a server only feature.   * Device set focus is a GUI only feature.   * The following channels are not implemented (status 501 is returned): ATV and DATV demodulators, Channel Analyzer NG, LoRa demodulator   * The device settings and report structures contains only the sub-structure corresponding to the device type. The DeviceSettings and DeviceReport structures documented here shows all of them but only one will be or should be present at a time   * The channel settings and report structures contains only the sub-structure corresponding to the channel type. The ChannelSettings and ChannelReport structures documented here shows all of them but only one will be or should be present at a time    --- 
 *
 * OpenAPI spec version: 6.0.0
 * Contact: f4exb06@gmail.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


#include "SWGAntennaToolsSettings.h"

#include "SWGHelpers.h"

#include <QJsonDocument>
#include <QJsonArray>
#include <QObject>
#include <QDebug>

namespace SWGSDRangel {

SWGAntennaToolsSettings::SWGAntennaToolsSettings(QString* json) {
    init();
    this->fromJson(*json);
}

SWGAntennaToolsSettings::SWGAntennaToolsSettings() {
    dipole_frequency_m_hz = 0.0f;
    m_dipole_frequency_m_hz_isSet = false;
    dipole_end_effect_factor = 0.0f;
    m_dipole_end_effect_factor_isSet = false;
    dish_frequency_m_hz = 0.0f;
    m_dish_frequency_m_hz_isSet = false;
    dish_diameter = 0.0f;
    m_dish_diameter_isSet = false;
    dish_depth = 0.0f;
    m_dish_depth_isSet = false;
    dish_efficiency = 0;
    m_dish_efficiency_isSet = false;
    title = nullptr;
    m_title_isSet = false;
    rgb_color = 0;
    m_rgb_color_isSet = false;
    use_reverse_api = 0;
    m_use_reverse_api_isSet = false;
    reverse_api_address = nullptr;
    m_reverse_api_address_isSet = false;
    reverse_api_port = 0;
    m_reverse_api_port_isSet = false;
    reverse_api_feature_set_index = 0;
    m_reverse_api_feature_set_index_isSet = false;
    reverse_api_feature_index = 0;
    m_reverse_api_feature_index_isSet = false;
}

SWGAntennaToolsSettings::~SWGAntennaToolsSettings() {
    this->cleanup();
}

void
SWGAntennaToolsSettings::init() {
    dipole_frequency_m_hz = 0.0f;
    m_dipole_frequency_m_hz_isSet = false;
    dipole_end_effect_factor = 0.0f;
    m_dipole_end_effect_factor_isSet = false;
    dish_frequency_m_hz = 0.0f;
    m_dish_frequency_m_hz_isSet = false;
    dish_diameter = 0.0f;
    m_dish_diameter_isSet = false;
    dish_depth = 0.0f;
    m_dish_depth_isSet = false;
    dish_efficiency = 0;
    m_dish_efficiency_isSet = false;
    title = new QString("");
    m_title_isSet = false;
    rgb_color = 0;
    m_rgb_color_isSet = false;
    use_reverse_api = 0;
    m_use_reverse_api_isSet = false;
    reverse_api_address = new QString("");
    m_reverse_api_address_isSet = false;
    reverse_api_port = 0;
    m_reverse_api_port_isSet = false;
    reverse_api_feature_set_index = 0;
    m_reverse_api_feature_set_index_isSet = false;
    reverse_api_feature_index = 0;
    m_reverse_api_feature_index_isSet = false;
}

void
SWGAntennaToolsSettings::cleanup() {






    if(title != nullptr) { 
        delete title;
    }


    if(reverse_api_address != nullptr) { 
        delete reverse_api_address;
    }



}

SWGAntennaToolsSettings*
SWGAntennaToolsSettings::fromJson(QString &json) {
    QByteArray array (json.toStdString().c_str());
    QJsonDocument doc = QJsonDocument::fromJson(array);
    QJsonObject jsonObject = doc.object();
    this->fromJsonObject(jsonObject);
    return this;
}

void
SWGAntennaToolsSettings::fromJsonObject(QJsonObject &pJson) {
    ::SWGSDRangel::setValue(&dipole_frequency_m_hz, pJson["dipoleFrequencyMHz"], "float", "");
    
    ::SWGSDRangel::setValue(&dipole_end_effect_factor, pJson["dipoleEndEffectFactor"], "float", "");
    
    ::SWGSDRangel::setValue(&dish_frequency_m_hz, pJson["dishFrequencyMHz"], "float", "");
    
    ::SWGSDRangel::setValue(&dish_diameter, pJson["dishDiameter"], "float", "");
    
    ::SWGSDRangel::setValue(&dish_depth, pJson["dishDepth"], "float", "");
    
    ::SWGSDRangel::setValue(&dish_efficiency, pJson["dishEfficiency"], "qint32", "");
    
    ::SWGSDRangel::setValue(&title, pJson["title"], "QString", "QString");
    
    ::SWGSDRangel::setValue(&rgb_color, pJson["rgbColor"], "qint32", "");
    
    ::SWGSDRangel::setValue(&use_reverse_api, pJson["useReverseAPI"], "qint32", "");
    
    ::SWGSDRangel::setValue(&reverse_api_address, pJson["reverseAPIAddress"], "QString", "QString");
    
    ::SWGSDRangel::setValue(&reverse_api_port, pJson["reverseAPIPort"], "qint32", "");
    
    ::SWGSDRangel::setValue(&reverse_api_feature_set_index, pJson["reverseAPIFeatureSetIndex"], "qint32", "");
    
    ::SWGSDRangel::setValue(&reverse_api_feature_index, pJson["reverseAPIFeatureIndex"], "qint32", "");
    
}

QString
SWGAntennaToolsSettings::asJson ()
{
    QJsonObject* obj = this->asJsonObject();

    QJsonDocument doc(*obj);
    QByteArray bytes = doc.toJson();
    delete obj;
    return QString(bytes);
}

QJsonObject*
SWGAntennaToolsSettings::asJsonObject() {
    QJsonObject* obj = new QJsonObject();
    if(m_dipole_frequency_m_hz_isSet){
        obj->insert("dipoleFrequencyMHz", QJsonValue(dipole_frequency_m_hz));
    }
    if(m_dipole_end_effect_factor_isSet){
        obj->insert("dipoleEndEffectFactor", QJsonValue(dipole_end_effect_factor));
    }
    if(m_dish_frequency_m_hz_isSet){
        obj->insert("dishFrequencyMHz", QJsonValue(dish_frequency_m_hz));
    }
    if(m_dish_diameter_isSet){
        obj->insert("dishDiameter", QJsonValue(dish_diameter));
    }
    if(m_dish_depth_isSet){
        obj->insert("dishDepth", QJsonValue(dish_depth));
    }
    if(m_dish_efficiency_isSet){
        obj->insert("dishEfficiency", QJsonValue(dish_efficiency));
    }
    if(title != nullptr && *title != QString("")){
        toJsonValue(QString("title"), title, obj, QString("QString"));
    }
    if(m_rgb_color_isSet){
        obj->insert("rgbColor", QJsonValue(rgb_color));
    }
    if(m_use_reverse_api_isSet){
        obj->insert("useReverseAPI", QJsonValue(use_reverse_api));
    }
    if(reverse_api_address != nullptr && *reverse_api_address != QString("")){
        toJsonValue(QString("reverseAPIAddress"), reverse_api_address, obj, QString("QString"));
    }
    if(m_reverse_api_port_isSet){
        obj->insert("reverseAPIPort", QJsonValue(reverse_api_port));
    }
    if(m_reverse_api_feature_set_index_isSet){
        obj->insert("reverseAPIFeatureSetIndex", QJsonValue(reverse_api_feature_set_index));
    }
    if(m_reverse_api_feature_index_isSet){
        obj->insert("reverseAPIFeatureIndex", QJsonValue(reverse_api_feature_index));
    }

    return obj;
}

float
SWGAntennaToolsSettings::getDipoleFrequencyMHz() {
    return dipole_frequency_m_hz;
}
void
SWGAntennaToolsSettings::setDipoleFrequencyMHz(float dipole_frequency_m_hz) {
    this->dipole_frequency_m_hz = dipole_frequency_m_hz;
    this->m_dipole_frequency_m_hz_isSet = true;
}

float
SWGAntennaToolsSettings::getDipoleEndEffectFactor() {
    return dipole_end_effect_factor;
}
void
SWGAntennaToolsSettings::setDipoleEndEffectFactor(float dipole_end_effect_factor) {
    this->dipole_end_effect_factor = dipole_end_effect_factor;
    this->m_dipole_end_effect_factor_isSet = true;
}

float
SWGAntennaToolsSettings::getDishFrequencyMHz() {
    return dish_frequency_m_hz;
}
void
SWGAntennaToolsSettings::setDishFrequencyMHz(float dish_frequency_m_hz) {
    this->dish_frequency_m_hz = dish_frequency_m_hz;
    this->m_dish_frequency_m_hz_isSet = true;
}

float
SWGAntennaToolsSettings::getDishDiameter() {
    return dish_diameter;
}
void
SWGAntennaToolsSettings::setDishDiameter(float dish_diameter) {
    this->dish_diameter = dish_diameter;
    this->m_dish_diameter_isSet = true;
}

float
SWGAntennaToolsSettings::getDishDepth() {
    return dish_depth;
}
void
SWGAntennaToolsSettings::setDishDepth(float dish_depth) {
    this->dish_depth = dish_depth;
    this->m_dish_depth_isSet = true;
}

qint32
SWGAntennaToolsSettings::getDishEfficiency() {
    return dish_efficiency;
}
void
SWGAntennaToolsSettings::setDishEfficiency(qint32 dish_efficiency) {
    this->dish_efficiency = dish_efficiency;
    this->m_dish_efficiency_isSet = true;
}

QString*
SWGAntennaToolsSettings::getTitle() {
    return title;
}
void
SWGAntennaToolsSettings::setTitle(QString* title) {
    this->title = title;
    this->m_title_isSet = true;
}

qint32
SWGAntennaToolsSettings::getRgbColor() {
    return rgb_color;
}
void
SWGAntennaToolsSettings::setRgbColor(qint32 rgb_color) {
    this->rgb_color = rgb_color;
    this->m_rgb_color_isSet = true;
}

qint32
SWGAntennaToolsSettings::getUseReverseApi() {
    return use_reverse_api;
}
void
SWGAntennaToolsSettings::setUseReverseApi(qint32 use_reverse_api) {
    this->use_reverse_api = use_reverse_api;
    this->m_use_reverse_api_isSet = true;
}

QString*
SWGAntennaToolsSettings::getReverseApiAddress() {
    return reverse_api_address;
}
void
SWGAntennaToolsSettings::setReverseApiAddress(QString* reverse_api_address) {
    this->reverse_api_address = reverse_api_address;
    this->m_reverse_api_address_isSet = true;
}

qint32
SWGAntennaToolsSettings::getReverseApiPort() {
    return reverse_api_port;
}
void
SWGAntennaToolsSettings::setReverseApiPort(qint32 reverse_api_port) {
    this->reverse_api_port = reverse_api_port;
    this->m_reverse_api_port_isSet = true;
}

qint32
SWGAntennaToolsSettings::getReverseApiFeatureSetIndex() {
    return reverse_api_feature_set_index;
}
void
SWGAntennaToolsSettings::setReverseApiFeatureSetIndex(qint32 reverse_api_feature_set_index) {
    this->reverse_api_feature_set_index = reverse_api_feature_set_index;
    this->m_reverse_api_feature_set_index_isSet = true;
}

qint32
SWGAntennaToolsSettings::getReverseApiFeatureIndex() {
    return reverse_api_feature_index;
}
void
SWGAntennaToolsSettings::setReverseApiFeatureIndex(qint32 reverse_api_feature_index) {
    this->reverse_api_feature_index = reverse_api_feature_index;
    this->m_reverse_api_feature_index_isSet = true;
}


bool
SWGAntennaToolsSettings::isSet(){
    bool isObjectUpdated = false;
    do{
        if(m_dipole_frequency_m_hz_isSet){
            isObjectUpdated = true; break;
        }
        if(m_dipole_end_effect_factor_isSet){
            isObjectUpdated = true; break;
        }
        if(m_dish_frequency_m_hz_isSet){
            isObjectUpdated = true; break;
        }
        if(m_dish_diameter_isSet){
            isObjectUpdated = true; break;
        }
        if(m_dish_depth_isSet){
            isObjectUpdated = true; break;
        }
        if(m_dish_efficiency_isSet){
            isObjectUpdated = true; break;
        }
        if(title && *title != QString("")){
            isObjectUpdated = true; break;
        }
        if(m_rgb_color_isSet){
            isObjectUpdated = true; break;
        }
        if(m_use_reverse_api_isSet){
            isObjectUpdated = true; break;
        }
        if(reverse_api_address && *reverse_api_address != QString("")){
            isObjectUpdated = true; break;
        }
        if(m_reverse_api_port_isSet){
            isObjectUpdated = true; break;
        }
        if(m_reverse_api_feature_set_index_isSet){
            isObjectUpdated = true; break;
        }
        if(m_reverse_api_feature_index_isSet){
            isObjectUpdated = true; break;
        }
    }while(false);
    return isObjectUpdated;
}
}

