/**
 * SDRangel
 * This is the web REST/JSON API of SDRangel SDR software. SDRangel is an Open Source Qt5/OpenGL 3.0+ (4.3+ in Windows) GUI and server Software Defined Radio and signal analyzer in software. It supports Airspy, BladeRF, HackRF, LimeSDR, PlutoSDR, RTL-SDR, SDRplay RSP1 and FunCube    ---   Limitations and specifcities:    * In SDRangel GUI the first Rx device set cannot be deleted. Conversely the server starts with no device sets and its number of device sets can be reduced to zero by as many calls as necessary to /sdrangel/deviceset with DELETE method.   * Preset import and export from/to file is a server only feature.   * Device set focus is a GUI only feature.   * The following channels are not implemented (status 501 is returned): ATV and DATV demodulators, Channel Analyzer NG, LoRa demodulator   * The device settings and report structures contains only the sub-structure corresponding to the device type. The DeviceSettings and DeviceReport structures documented here shows all of them but only one will be or should be present at a time   * The channel settings and report structures contains only the sub-structure corresponding to the channel type. The ChannelSettings and ChannelReport structures documented here shows all of them but only one will be or should be present at a time    --- 
 *
 * OpenAPI spec version: 6.0.0
 * Contact: f4exb06@gmail.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


#include "SWGMapItem_2.h"

#include "SWGHelpers.h"

#include <QJsonDocument>
#include <QJsonArray>
#include <QObject>
#include <QDebug>

namespace SWGSDRangel {

SWGMapItem_2::SWGMapItem_2(QString* json) {
    init();
    this->fromJson(*json);
}

SWGMapItem_2::SWGMapItem_2() {
    name = nullptr;
    m_name_isSet = false;
    image = nullptr;
    m_image_isSet = false;
    image_rotation = 0;
    m_image_rotation_isSet = false;
    image_min_zoom = 0;
    m_image_min_zoom_isSet = false;
    text = nullptr;
    m_text_isSet = false;
    latitude = 0.0f;
    m_latitude_isSet = false;
    longitude = 0.0f;
    m_longitude_isSet = false;
    altitude = 0.0f;
    m_altitude_isSet = false;
    track = nullptr;
    m_track_isSet = false;
    predicted_track = nullptr;
    m_predicted_track_isSet = false;
}

SWGMapItem_2::~SWGMapItem_2() {
    this->cleanup();
}

void
SWGMapItem_2::init() {
    name = new QString("");
    m_name_isSet = false;
    image = new QString("");
    m_image_isSet = false;
    image_rotation = 0;
    m_image_rotation_isSet = false;
    image_min_zoom = 0;
    m_image_min_zoom_isSet = false;
    text = new QString("");
    m_text_isSet = false;
    latitude = 0.0f;
    m_latitude_isSet = false;
    longitude = 0.0f;
    m_longitude_isSet = false;
    altitude = 0.0f;
    m_altitude_isSet = false;
    track = new QList<SWGMapCoordinate*>();
    m_track_isSet = false;
    predicted_track = new QList<SWGMapCoordinate*>();
    m_predicted_track_isSet = false;
}

void
SWGMapItem_2::cleanup() {
    if(name != nullptr) { 
        delete name;
    }
    if(image != nullptr) { 
        delete image;
    }


    if(text != nullptr) { 
        delete text;
    }



    if(track != nullptr) { 
        auto arr = track;
        for(auto o: *arr) { 
            delete o;
        }
        delete track;
    }
    if(predicted_track != nullptr) { 
        auto arr = predicted_track;
        for(auto o: *arr) { 
            delete o;
        }
        delete predicted_track;
    }
}

SWGMapItem_2*
SWGMapItem_2::fromJson(QString &json) {
    QByteArray array (json.toStdString().c_str());
    QJsonDocument doc = QJsonDocument::fromJson(array);
    QJsonObject jsonObject = doc.object();
    this->fromJsonObject(jsonObject);
    return this;
}

void
SWGMapItem_2::fromJsonObject(QJsonObject &pJson) {
    ::SWGSDRangel::setValue(&name, pJson["name"], "QString", "QString");
    
    ::SWGSDRangel::setValue(&image, pJson["image"], "QString", "QString");
    
    ::SWGSDRangel::setValue(&image_rotation, pJson["imageRotation"], "qint32", "");
    
    ::SWGSDRangel::setValue(&image_min_zoom, pJson["imageMinZoom"], "qint32", "");
    
    ::SWGSDRangel::setValue(&text, pJson["text"], "QString", "QString");
    
    ::SWGSDRangel::setValue(&latitude, pJson["latitude"], "float", "");
    
    ::SWGSDRangel::setValue(&longitude, pJson["longitude"], "float", "");
    
    ::SWGSDRangel::setValue(&altitude, pJson["altitude"], "float", "");
    
    
    ::SWGSDRangel::setValue(&track, pJson["track"], "QList", "SWGMapCoordinate");
    
    ::SWGSDRangel::setValue(&predicted_track, pJson["predictedTrack"], "QList", "SWGMapCoordinate");
}

QString
SWGMapItem_2::asJson ()
{
    QJsonObject* obj = this->asJsonObject();

    QJsonDocument doc(*obj);
    QByteArray bytes = doc.toJson();
    delete obj;
    return QString(bytes);
}

QJsonObject*
SWGMapItem_2::asJsonObject() {
    QJsonObject* obj = new QJsonObject();
    if(name != nullptr && *name != QString("")){
        toJsonValue(QString("name"), name, obj, QString("QString"));
    }
    if(image != nullptr && *image != QString("")){
        toJsonValue(QString("image"), image, obj, QString("QString"));
    }
    if(m_image_rotation_isSet){
        obj->insert("imageRotation", QJsonValue(image_rotation));
    }
    if(m_image_min_zoom_isSet){
        obj->insert("imageMinZoom", QJsonValue(image_min_zoom));
    }
    if(text != nullptr && *text != QString("")){
        toJsonValue(QString("text"), text, obj, QString("QString"));
    }
    if(m_latitude_isSet){
        obj->insert("latitude", QJsonValue(latitude));
    }
    if(m_longitude_isSet){
        obj->insert("longitude", QJsonValue(longitude));
    }
    if(m_altitude_isSet){
        obj->insert("altitude", QJsonValue(altitude));
    }
    if(track && track->size() > 0){
        toJsonArray((QList<void*>*)track, obj, "track", "SWGMapCoordinate");
    }
    if(predicted_track && predicted_track->size() > 0){
        toJsonArray((QList<void*>*)predicted_track, obj, "predictedTrack", "SWGMapCoordinate");
    }

    return obj;
}

QString*
SWGMapItem_2::getName() {
    return name;
}
void
SWGMapItem_2::setName(QString* name) {
    this->name = name;
    this->m_name_isSet = true;
}

QString*
SWGMapItem_2::getImage() {
    return image;
}
void
SWGMapItem_2::setImage(QString* image) {
    this->image = image;
    this->m_image_isSet = true;
}

qint32
SWGMapItem_2::getImageRotation() {
    return image_rotation;
}
void
SWGMapItem_2::setImageRotation(qint32 image_rotation) {
    this->image_rotation = image_rotation;
    this->m_image_rotation_isSet = true;
}

qint32
SWGMapItem_2::getImageMinZoom() {
    return image_min_zoom;
}
void
SWGMapItem_2::setImageMinZoom(qint32 image_min_zoom) {
    this->image_min_zoom = image_min_zoom;
    this->m_image_min_zoom_isSet = true;
}

QString*
SWGMapItem_2::getText() {
    return text;
}
void
SWGMapItem_2::setText(QString* text) {
    this->text = text;
    this->m_text_isSet = true;
}

float
SWGMapItem_2::getLatitude() {
    return latitude;
}
void
SWGMapItem_2::setLatitude(float latitude) {
    this->latitude = latitude;
    this->m_latitude_isSet = true;
}

float
SWGMapItem_2::getLongitude() {
    return longitude;
}
void
SWGMapItem_2::setLongitude(float longitude) {
    this->longitude = longitude;
    this->m_longitude_isSet = true;
}

float
SWGMapItem_2::getAltitude() {
    return altitude;
}
void
SWGMapItem_2::setAltitude(float altitude) {
    this->altitude = altitude;
    this->m_altitude_isSet = true;
}

QList<SWGMapCoordinate*>*
SWGMapItem_2::getTrack() {
    return track;
}
void
SWGMapItem_2::setTrack(QList<SWGMapCoordinate*>* track) {
    this->track = track;
    this->m_track_isSet = true;
}

QList<SWGMapCoordinate*>*
SWGMapItem_2::getPredictedTrack() {
    return predicted_track;
}
void
SWGMapItem_2::setPredictedTrack(QList<SWGMapCoordinate*>* predicted_track) {
    this->predicted_track = predicted_track;
    this->m_predicted_track_isSet = true;
}


bool
SWGMapItem_2::isSet(){
    bool isObjectUpdated = false;
    do{
        if(name && *name != QString("")){
            isObjectUpdated = true; break;
        }
        if(image && *image != QString("")){
            isObjectUpdated = true; break;
        }
        if(m_image_rotation_isSet){
            isObjectUpdated = true; break;
        }
        if(m_image_min_zoom_isSet){
            isObjectUpdated = true; break;
        }
        if(text && *text != QString("")){
            isObjectUpdated = true; break;
        }
        if(m_latitude_isSet){
            isObjectUpdated = true; break;
        }
        if(m_longitude_isSet){
            isObjectUpdated = true; break;
        }
        if(m_altitude_isSet){
            isObjectUpdated = true; break;
        }
        if(track && (track->size() > 0)){
            isObjectUpdated = true; break;
        }
        if(predicted_track && (predicted_track->size() > 0)){
            isObjectUpdated = true; break;
        }
    }while(false);
    return isObjectUpdated;
}
}

