% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sv_importance.R
\name{sv_importance}
\alias{sv_importance}
\alias{sv_importance.default}
\alias{sv_importance.shapviz}
\alias{sv_importance.mshapviz}
\title{SHAP Importance Plots}
\usage{
sv_importance(object, ...)

\method{sv_importance}{default}(object, ...)

\method{sv_importance}{shapviz}(
  object,
  kind = c("bar", "beeswarm", "both", "no"),
  max_display = 15L,
  fill = "#fca50a",
  bar_width = 2/3,
  bee_width = 0.4,
  bee_adjust = 0.5,
  viridis_args = getOption("shapviz.viridis_args"),
  color_bar_title = "Feature value",
  show_numbers = FALSE,
  format_fun = format_max,
  number_size = 3.2,
  ...
)

\method{sv_importance}{mshapviz}(
  object,
  kind = c("bar", "beeswarm", "both", "no"),
  max_display = 15L,
  fill = "#fca50a",
  bar_width = 2/3,
  bar_type = c("dodge", "stack", "facets", "separate"),
  bee_width = 0.4,
  bee_adjust = 0.5,
  viridis_args = getOption("shapviz.viridis_args"),
  color_bar_title = "Feature value",
  show_numbers = FALSE,
  format_fun = format_max,
  number_size = 3.2,
  ...
)
}
\arguments{
\item{object}{An object of class "(m)shapviz".}

\item{...}{Arguments passed to \code{\link[ggplot2:geom_bar]{ggplot2::geom_bar()}} (if \code{kind = "bar"}) or to
\code{\link[ggplot2:geom_point]{ggplot2::geom_point()}} otherwise. For instance, passing \code{alpha = 0.2} will produce
semi-transparent beeswarms, and setting \code{size = 3} will produce larger dots.}

\item{kind}{Should a "bar" plot (the default), a "beeswarm" plot, or "both" be shown?
Set to "no" in order to suppress plotting. In that case, the sorted
SHAP feature importances of all variables are returned.}

\item{max_display}{Maximum number of features (with highest importance) to plot.
Set to \code{Inf} to show all features. Has no effect if \code{kind = "no"}.}

\item{fill}{Color used to fill the bars (only used if bars are shown).}

\item{bar_width}{Relative width of the bars (only used if bars are shown).}

\item{bee_width}{Relative width of the beeswarms.}

\item{bee_adjust}{Relative bandwidth adjustment factor used in
estimating the density of the beeswarms.}

\item{viridis_args}{List of viridis color scale arguments. The default points to the
global option \code{shapviz.viridis_args}, which corresponds to
\code{list(begin = 0.25, end = 0.85, option = "inferno")}. These values are passed to
\code{\link[ggplot2:scale_viridis]{ggplot2::scale_color_viridis_c()}}. For example, to switch to standard viridis,
either change the default with \code{options(shapviz.viridis_args = list())} or set
\code{viridis_args = list()}.}

\item{color_bar_title}{Title of color bar of the beeswarm plot. Set to \code{NULL}
to hide the color bar altogether.}

\item{show_numbers}{Should SHAP feature importances be printed? Default is \code{FALSE}.}

\item{format_fun}{Function used to format SHAP feature importances
(only if \code{show_numbers = TRUE}). To change to scientific notation, use
\verb{function(x) = prettyNum(x, scientific = TRUE)}.}

\item{number_size}{Text size of the numbers (if \code{show_numbers = TRUE}).}

\item{bar_type}{For "mshapviz" objects with \code{kind = "bar"}: How should bars be
represented? The default is "dodge" for dodged bars. Other options are "stack",
"wrap", or "separate" (via "patchwork"). Note that "separate" is currently
the only option that supports \code{show_numbers = TRUE}.}
}
\value{
A "ggplot" (or "patchwork") object representing an importance plot, or - if
\code{kind = "no"} - a named numeric vector of sorted SHAP feature importances
(or a matrix in case of an object of class "mshapviz").
}
\description{
This function provides two types of SHAP importance plots: a bar plot
and a beeswarm plot (sometimes called "SHAP summary plot").
The two types of plots can also be combined.
}
\details{
The bar plot shows SHAP feature importances, calculated as the average absolute SHAP
value per feature. The beeswarm plot displays SHAP values per feature, using min-max
scaled feature values on the color axis. Non-numeric features are transformed
to numeric by calling \code{\link[=data.matrix]{data.matrix()}} first. For both types of plots, the features
are sorted in decreasing order of importance.
}
\section{Methods (by class)}{
\itemize{
\item \code{sv_importance(default)}: Default method.

\item \code{sv_importance(shapviz)}: SHAP importance plot for an object of class "shapviz".

\item \code{sv_importance(mshapviz)}: SHAP importance plot for an object of class "mshapviz".

}}
\examples{
X_train <- data.matrix(iris[, -1])
dtrain <- xgboost::xgb.DMatrix(X_train, label = iris[, 1], nthread = 1)
fit <- xgboost::xgb.train(data = dtrain, nrounds = 10, nthread = 1)
x <- shapviz(fit, X_pred = X_train)
sv_importance(x)
sv_importance(x, kind = "no")
sv_importance(x, kind = "beeswarm", show_numbers = TRUE)
}
\seealso{
\code{\link{sv_interaction}}
}
