---
name: Bottleneck
about: proffer is too slow or consumes too many resources.
title: ''
labels: 'topic: performance'
assignees: r-prof

---

## Prework


* [ ] Read and agree to the [code of conduct](https://github.com/r-prof/proffer/blob/main/CODE_OF_CONDUCT.md) and [contributing guidelines](https://github.com/r-prof/proffer/blob/main/CONTRIBUTING.md).
* [ ] If there is [already a relevant issue](https://github.com/r-prof/proffer/issues), whether open or closed, comment on the existing thread instead of posting a new issue.
* [ ] For any problem you identify, post a [minimal reproducible example](https://www.tidyverse.org/help/) so the maintainer can troubleshoot. A reproducible example is:
    * [ ] **Runnable**: post enough R code and data so any onlooker can create the error on their own computer.
    * [ ] **Minimal**: reduce runtime wherever possible and remove complicated details that are irrelevant to the issue at hand.
    * [ ] **Readable**: format your code according to the [tidyverse style guide](https://style.tidyverse.org/).

## Description

Describe the bottleneck clearly and concisely. 

## Reproducible example

* [ ] For any problem you identify, post a [minimal reproducible example](https://www.tidyverse.org/help/) so the maintainer can troubleshoot. A reproducible example is:
    * [ ] **Runnable**: post enough R code and data so any onlooker can create the error on their own computer.
    * [ ] **Minimal**: reduce runtime wherever possible and remove complicated details that are irrelevant to the issue at hand.
    * [ ] **Readable**: format your code according to the [tidyverse style guide](https://style.tidyverse.org/).

## Benchmarks

How poorly does `proffer` perform? Feel free to use `proffer` itself to show us.
