% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BUGS_model.R
\name{getConditionallyIndependentSets}
\alias{getConditionallyIndependentSets}
\title{Get a list of conditionally independent sets of nodes in a nimble model}
\usage{
getConditionallyIndependentSets(
  model,
  nodes,
  givenNodes,
  omit = integer(),
  inputType = c("latent", "param", "data"),
  stochOnly = TRUE,
  returnType = "names",
  returnScalarComponents = FALSE
)
}
\arguments{
\item{model}{A nimble model object (uncompiled or compiled).}

\item{nodes}{A vector of node names or their graph IDs that are the starting nodes from which conditionally independent sets of nodes should be found.  If omitted, the default will be all latent nodes, defined as stochastic nodes that are not data and have at least one stochastic parent node (possible with determinstic nodes in between).  Note that this will omit latent states that have no hyperparameters.  An example is the first latent state in some state-space (time-series) models, which is sometimes declared with known prior.  See \code{type} because it relates to the interpretation of \code{nodes}.}

\item{givenNodes}{A vector of node names or their graph IDs that should be considered as fixed and hence can be conditioned on.  If omitted, the default will be all data nodes and all parameter nodes, the latter defined as nodes with no stochastic parent nodes (skipping over deterministic parent nodes).}

\item{omit}{A vector of node names or their graph IDs that should be omitted and should block further graph exploration.}

\item{inputType}{The method of graph exploration depends on what the nodes argument represents.  For \code{latent}, the input \code{nodes} are interpreted as latent states, from which both parent and descendent graph exploration should be done to find nodes in the same set (nodes that are NOT conditionally independent from each other).  For \code{param}, the input \code{nodes} are interpreted as parameters, so graph exploration begins from the  top (input) and explores descendents.  For \code{data}, the input \code{nodes} are interpreted as data nodes, so graph exploration begins from the bottom (input) explores parent nodes.}

\item{stochOnly}{Logical for whether only stochastic nodes should be returned (default = TRUE).  If FALSE, both deterministic and stochastic nodes are returned.}

\item{returnType}{Either \code{names} for returned nodes to be node names or \code{ids} for returned nodes to be graph IDs.}

\item{returnScalarComponents}{If FALSE (default), multivariate nodes are returned as full names (e.g. \code{x[1:3]}).  If TRUE, they are returned as scalar elements (e.g. \code{x[1]},  \code{x[2]},  \code{x[3]}).}
}
\value{
List of nodes that are in conditionally independent sets.  With each set, nodes are returned in topologically sorted order.  The sets themselves are returned in topologically sorted order of their first nodes.
}
\description{
Conditionally independent sets of nodes are typically groups of latent states whose joint probability (density) will not change even if any other non-fixed node is changed.  Default fixed nodes are data nodes and parameter nodes (with no parent nodes), but this can be controlled.
}
\details{
This function returns sets of conditionally independent nodes.  Multiple input \code{nodes} might be in the same set or different sets, and other nodes (not in \code{nodes}) will be included.

By default, deterministic dependencies of givenNodes are also
counted as given nodes.  This is relevant only for parent nodes.
This allows the givenNodes to include only stochastic nodes.  Say
we have A -> B -> C -> D.  A and D are givenNodes.  C is a latent
node.  B is a deterministic node.  By default, B is considered
given.  Otherwise, other dependent networks of nodes that that depend on B would be grouped
in the same output set as C, but this is usually what is wanted.
Any use of the resulting output must ensure that B is calculated when
necessary, as usual with nimble's model-generic programming.  To
turn off this feature, set
\code{nimbleOptions(groupDetermWithGivenInCondIndSets = FALSE)}.
}
\seealso{
There is a non-exported function \code{nimble:::testConditionallyIndependentSets(model, sets, initialize = TRUE)} that tests whether the conditional independence of sets is valid.  It should be the case that \code{nimble:::testConditionallyIndependentSets(model, getConditionallyIndependentSets(model), initialize = TRUE)} returns \code{TRUE}.
}
\author{
Perry de Valpine
}
