% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/special-attributes.R
\name{set_lb_date}
\alias{set_lb_date}
\title{Set special libbib date attribute on object}
\usage{
set_lb_date(x, value)
}
\arguments{
\item{x}{An object to set the attribute on}

\item{value}{Either a value of class \code{Date} or a string in ISO 8601
date format (yyyy-mm-dd) which will be converted into a Date}
}
\value{
Nothing, since the object is modified by reference.
}
\description{
Takes an object and a date and sets a special attribute, "lb.date"
by reference
}
\examples{
set_lb_date(mtcars, "2021-05-08")
attributes(mtcars)$lb.date
# [1] "2021-05-08

set_lb_date(mtcars, Sys.Date())

}
