Contributing to jfa
=============================

`jfa` is an open-source project and we would love to receive contributions from the community! There are many ways to contribute, from improving the documentation, submitting bug reports and feature requests or writing code which can be incorporated into `jfa` itself.

Bug reports
-----------

If you think you have found a bug in `jfa`, first make sure that you are testing against the [latest version of jfa](https://cran.r-project.org/package=jfa) - your issue may already have been fixed. If not, search the [issues list](https://github.com/koenderks/jfa/issues) on GitHub in case a similar issue has already been opened.

It is very helpful if you can prepare a reproduction of the bug. In other words, provide a small test case which we can run to confirm your bug. It makes it easier to find the problem and to fix it.

Feature requests
----------------

If you find yourself wishing for a feature that doesn't exist in `jfa`, you are probably not alone. There are bound to be others out there with similar needs. Open an issue on our [issues list](https://github.com/koenderks/jfa/issues) on GitHub which describes the feature you would like to see, why you need it, and how it should work.

Contributing code to jfa
----------------

You can also contribute your own code (in the form of new methods or benchmarks) to `jfa`. See the pages below on how to contribute. 

[How to set up the jfa repository](https://github.com/koenderks/jfa/wiki/Setup)

[How to add a benchmark to jfa](https://github.com/koenderks/jfa/wiki/Benchmarks)

[How to add a new method to jfa](https://github.com/koenderks/jfa/wiki/Methods)