% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/citeproc_writer.R
\name{citeproc_writer}
\alias{citeproc_writer}
\title{citeproc writer}
\usage{
citeproc_writer(z, auto_unbox = TRUE, pretty = TRUE, ...)
}
\arguments{
\item{z}{an object of class \code{handl}; see \link{handl} for more}

\item{auto_unbox}{(logical) automatically "unbox" all atomic
vectors of length 1 (default: \code{TRUE}). passed to \code{\link[jsonlite:fromJSON]{jsonlite::toJSON()}}}

\item{pretty}{(logical) adds indentation whitespace to JSON output
(default: \code{TRUE}), passed to \code{\link[jsonlite:fromJSON]{jsonlite::toJSON()}}}

\item{...}{further params passed to \code{\link[jsonlite:fromJSON]{jsonlite::toJSON()}}}
}
\value{
citeproc as JSON
}
\description{
citeproc writer
}
\examples{
z <- system.file('extdata/citeproc.json', package = "handlr")
(tmp <- citeproc_reader(z))
citeproc_writer(z = tmp)
citeproc_writer(z = tmp, pretty = FALSE)
cat(ris_writer(z = tmp))

# many
z <- system.file('extdata/citeproc-many.json', package = "handlr")
w <- citeproc_reader(x = z)
citeproc_writer(w)
}
\seealso{
Other writers: 
\code{\link{bibtex_writer}()},
\code{\link{cff_writer}()},
\code{\link{codemeta_writer}()},
\code{\link{rdf_xml_writer}()},
\code{\link{ris_writer}()},
\code{\link{schema_org_writer}()}

Other citeproc: 
\code{\link{citeproc_reader}()}
}
\concept{citeproc}
\concept{writers}
