% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gofar.R
\name{gofar_control}
\alias{gofar_control}
\title{Control parameters for the estimation procedure of GOFAR(S) and GOFAR(P)}
\usage{
gofar_control(
  maxit = 5000,
  epsilon = 1e-06,
  elnetAlpha = 0.95,
  gamma0 = 1,
  se1 = 1,
  spU = 0.5,
  spV = 0.5,
  lamMaxFac = 1,
  lamMinFac = 1e-06,
  initmaxit = 2000,
  initepsilon = 1e-06,
  equalphi = 1,
  objI = 1,
  alp = 60
)
}
\arguments{
\item{maxit}{maximum iteration for each sequential steps}

\item{epsilon}{tolerence value set for convergene of gcure}

\item{elnetAlpha}{elastic net penalty parameter}

\item{gamma0}{power parameter in the adaptive weights}

\item{se1}{apply 1se sule for the model;}

\item{spU}{maximum proportion of nonzero elements in each column of U}

\item{spV}{maximum proportion of nonzero elements in each column of V}

\item{lamMaxFac}{a multiplier of calculated lambda_max}

\item{lamMinFac}{a multiplier of determing lambda_min as a fraction of lambda_max}

\item{initmaxit}{maximum iteration for initialization problem}

\item{initepsilon}{tolerence value for convergene in the initialization problem}

\item{equalphi}{dispersion parameter for all gaussian outcome equal or not 0/1}

\item{objI}{1 or 0 convergence on the basis of objective function or not}

\item{alp}{scaling factor corresponding to poisson outcomes}
}
\value{
a list of controling parameter.
}
\description{
Default control parameters for Generalized co-sparse factor regresion
}
\examples{

# control variable for GOFAR(S) and GOFAR(P)
control <- gofar_control()

}
\references{
\emph{ Mishra, Aditya, Dipak K. Dey, Yong Chen, and Kun Chen. Generalized co-sparse factor regression. Computational Statistics & Data Analysis 157 (2021): 107127}
}
