% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/signature.R
\name{default_signature}
\alias{default_signature}
\title{Get the signature}
\usage{
default_signature(repo = ".")
}
\arguments{
\item{repo}{a path to a repository or a \code{git_repository}
object. Default is '.'}
}
\value{
A \code{git_signature} object with entries:
}
\description{
Get the signature according to the repository's configuration
}
\examples{
\dontrun{
## Initialize a temporary repository
path <- tempfile(pattern="git2r-")
dir.create(path)
repo <- init(path)

## Create a user
config(repo, user.name = "Alice", user.email = "alice@example.org")

## Get the default signature
default_signature(repo)

## Change user
config(repo, user.name = "Bob", user.email = "bob@example.org")

## Get the default signature
default_signature(repo)
}
}
