% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/treedata-function.R
\name{td_filter}
\alias{td_filter}
\title{td-filter}
\usage{
td_filter(..., .f = NULL)
}
\arguments{
\item{...}{Expressions that return a logical value.}

\item{.f}{a function (if any, defaults to NULL) that pre-operate the data}
}
\value{
A function to filter ggtree plot data using conditions defined by '...'.
}
\description{
filter data for tree annotation layer
}
\details{
The 'td_filter()' function returns another function that can be
used to subset ggtree() plot data. The function can be passed to the 'data' parameter
of geom layer to perform subsetting. All rows that satisy your conditions will be retained.
}
\examples{
tree <- rtree(30)
## similar to 'ggtree(tree) + geom_tippoint()'
ggtree(tree) + geom_point(data = td_filter(isTip))
}
\references{
For more detailed demonstration of this function, please refer to chapter 12.5.1 of
\emph{Data Integration, Manipulation and Visualization of Phylogenetic Trees}
\url{http://yulab-smu.top/treedata-book/index.html} by Guangchuang Yu.
}
\seealso{
\link[dplyr:filter]{filter}
}
\author{
Guangchuang Yu
}
