<!-- Generated by galley: do not edit by hand -->

Once you have all your primary keys set and all foreign key relations
defined, a graphical representation of your data model offers a
condensed view of the tables and the relationships between the tables.
The following functions can be used to visualize the `dm` object:[1]

1.  `dm_draw()`
2.  `dm_set_colors()`
3.  `dm_get_colors()`
4.  `dm_get_available_colors()`

We use the prepared example `dm` object `dm_nycflights13(cycle = TRUE)`:

``` r
library(dm)
library(dplyr)
#> 
#> Attaching package: 'dplyr'
#> The following object is masked from 'package:testthat':
#> 
#>     matches
#> The following objects are masked from 'package:stats':
#> 
#>     filter, lag
#> The following objects are masked from 'package:base':
#> 
#>     intersect, setdiff, setequal, union
flights_dm_w_many_keys <- dm_nycflights13(color = FALSE)
flights_dm_w_many_keys
#> ── Metadata ───────────────────────────────────────────────────────────────
#> Tables: `airlines`, `airports`, `flights`, `planes`, `weather`
#> Columns: 53
#> Primary keys: 4
#> Foreign keys: 4
```

The schema is drawn with `dm_draw()`.

``` r
dm_draw(flights_dm_w_many_keys)
```

![](/home/kirill/git/R/dm/vignettes/out/tech-dm-draw_files/figure-gfm/unnamed-chunk-2-1.png)<!-- -->

You can use colors to visually group your tables into families to
reflect their logical grouping. The available colors are either hexcoded
colors or the standard R color names. The function
`dm_get_available_colors()` forwards to `grDevices::colors()`:

``` r
dm_get_available_colors()
#>   [1] "default"              "white"                "aliceblue"           
#>   [4] "antiquewhite"         "antiquewhite1"        "antiquewhite2"       
#>   [7] "antiquewhite3"        "antiquewhite4"        "aquamarine"          
#>  [10] "aquamarine1"          "aquamarine2"          "aquamarine3"         
#>  [13] "aquamarine4"          "azure"                "azure1"              
#>  [16] "azure2"               "azure3"               "azure4"              
#>  [19] "beige"                "bisque"               "bisque1"             
#>  [22] "bisque2"              "bisque3"              "bisque4"             
#>  [25] "black"                "blanchedalmond"       "blue"                
#>  [28] "blue1"                "blue2"                "blue3"               
#>  [31] "blue4"                "blueviolet"           "brown"               
#>  [34] "brown1"               "brown2"               "brown3"              
#>  [37] "brown4"               "burlywood"            "burlywood1"          
#>  [40] "burlywood2"           "burlywood3"           "burlywood4"          
#>  [43] "cadetblue"            "cadetblue1"           "cadetblue2"          
#>  [46] "cadetblue3"           "cadetblue4"           "chartreuse"          
#>  [49] "chartreuse1"          "chartreuse2"          "chartreuse3"         
#>  [52] "chartreuse4"          "chocolate"            "chocolate1"          
#>  [55] "chocolate2"           "chocolate3"           "chocolate4"          
#>  [58] "coral"                "coral1"               "coral2"              
#>  [61] "coral3"               "coral4"               "cornflowerblue"      
#>  [64] "cornsilk"             "cornsilk1"            "cornsilk2"           
#>  [67] "cornsilk3"            "cornsilk4"            "cyan"                
#>  [70] "cyan1"                "cyan2"                "cyan3"               
#>  [73] "cyan4"                "darkblue"             "darkcyan"            
#>  [76] "darkgoldenrod"        "darkgoldenrod1"       "darkgoldenrod2"      
#>  [79] "darkgoldenrod3"       "darkgoldenrod4"       "darkgray"            
#>  [82] "darkgreen"            "darkgrey"             "darkkhaki"           
#>  [85] "darkmagenta"          "darkolivegreen"       "darkolivegreen1"     
#>  [88] "darkolivegreen2"      "darkolivegreen3"      "darkolivegreen4"     
#>  [91] "darkorange"           "darkorange1"          "darkorange2"         
#>  [94] "darkorange3"          "darkorange4"          "darkorchid"          
#>  [97] "darkorchid1"          "darkorchid2"          "darkorchid3"         
#> [100] "darkorchid4"          "darkred"              "darksalmon"          
#> [103] "darkseagreen"         "darkseagreen1"        "darkseagreen2"       
#> [106] "darkseagreen3"        "darkseagreen4"        "darkslateblue"       
#> [109] "darkslategray"        "darkslategray1"       "darkslategray2"      
#> [112] "darkslategray3"       "darkslategray4"       "darkslategrey"       
#> [115] "darkturquoise"        "darkviolet"           "deeppink"            
#> [118] "deeppink1"            "deeppink2"            "deeppink3"           
#> [121] "deeppink4"            "deepskyblue"          "deepskyblue1"        
#> [124] "deepskyblue2"         "deepskyblue3"         "deepskyblue4"        
#> [127] "dimgray"              "dimgrey"              "dodgerblue"          
#> [130] "dodgerblue1"          "dodgerblue2"          "dodgerblue3"         
#> [133] "dodgerblue4"          "firebrick"            "firebrick1"          
#> [136] "firebrick2"           "firebrick3"           "firebrick4"          
#> [139] "floralwhite"          "forestgreen"          "gainsboro"           
#> [142] "ghostwhite"           "gold"                 "gold1"               
#> [145] "gold2"                "gold3"                "gold4"               
#> [148] "goldenrod"            "goldenrod1"           "goldenrod2"          
#> [151] "goldenrod3"           "goldenrod4"           "gray"                
#> [154] "gray0"                "gray1"                "gray2"               
#> [157] "gray3"                "gray4"                "gray5"               
#> [160] "gray6"                "gray7"                "gray8"               
#> [163] "gray9"                "gray10"               "gray11"              
#> [166] "gray12"               "gray13"               "gray14"              
#> [169] "gray15"               "gray16"               "gray17"              
#> [172] "gray18"               "gray19"               "gray20"              
#> [175] "gray21"               "gray22"               "gray23"              
#> [178] "gray24"               "gray25"               "gray26"              
#> [181] "gray27"               "gray28"               "gray29"              
#> [184] "gray30"               "gray31"               "gray32"              
#> [187] "gray33"               "gray34"               "gray35"              
#> [190] "gray36"               "gray37"               "gray38"              
#> [193] "gray39"               "gray40"               "gray41"              
#> [196] "gray42"               "gray43"               "gray44"              
#> [199] "gray45"               "gray46"               "gray47"              
#> [202] "gray48"               "gray49"               "gray50"              
#> [205] "gray51"               "gray52"               "gray53"              
#> [208] "gray54"               "gray55"               "gray56"              
#> [211] "gray57"               "gray58"               "gray59"              
#> [214] "gray60"               "gray61"               "gray62"              
#> [217] "gray63"               "gray64"               "gray65"              
#> [220] "gray66"               "gray67"               "gray68"              
#> [223] "gray69"               "gray70"               "gray71"              
#> [226] "gray72"               "gray73"               "gray74"              
#> [229] "gray75"               "gray76"               "gray77"              
#> [232] "gray78"               "gray79"               "gray80"              
#> [235] "gray81"               "gray82"               "gray83"              
#> [238] "gray84"               "gray85"               "gray86"              
#> [241] "gray87"               "gray88"               "gray89"              
#> [244] "gray90"               "gray91"               "gray92"              
#> [247] "gray93"               "gray94"               "gray95"              
#> [250] "gray96"               "gray97"               "gray98"              
#> [253] "gray99"               "gray100"              "green"               
#> [256] "green1"               "green2"               "green3"              
#> [259] "green4"               "greenyellow"          "grey"                
#> [262] "grey0"                "grey1"                "grey2"               
#> [265] "grey3"                "grey4"                "grey5"               
#> [268] "grey6"                "grey7"                "grey8"               
#> [271] "grey9"                "grey10"               "grey11"              
#> [274] "grey12"               "grey13"               "grey14"              
#> [277] "grey15"               "grey16"               "grey17"              
#> [280] "grey18"               "grey19"               "grey20"              
#> [283] "grey21"               "grey22"               "grey23"              
#> [286] "grey24"               "grey25"               "grey26"              
#> [289] "grey27"               "grey28"               "grey29"              
#> [292] "grey30"               "grey31"               "grey32"              
#> [295] "grey33"               "grey34"               "grey35"              
#> [298] "grey36"               "grey37"               "grey38"              
#> [301] "grey39"               "grey40"               "grey41"              
#> [304] "grey42"               "grey43"               "grey44"              
#> [307] "grey45"               "grey46"               "grey47"              
#> [310] "grey48"               "grey49"               "grey50"              
#> [313] "grey51"               "grey52"               "grey53"              
#> [316] "grey54"               "grey55"               "grey56"              
#> [319] "grey57"               "grey58"               "grey59"              
#> [322] "grey60"               "grey61"               "grey62"              
#> [325] "grey63"               "grey64"               "grey65"              
#> [328] "grey66"               "grey67"               "grey68"              
#> [331] "grey69"               "grey70"               "grey71"              
#> [334] "grey72"               "grey73"               "grey74"              
#> [337] "grey75"               "grey76"               "grey77"              
#> [340] "grey78"               "grey79"               "grey80"              
#> [343] "grey81"               "grey82"               "grey83"              
#> [346] "grey84"               "grey85"               "grey86"              
#> [349] "grey87"               "grey88"               "grey89"              
#> [352] "grey90"               "grey91"               "grey92"              
#> [355] "grey93"               "grey94"               "grey95"              
#> [358] "grey96"               "grey97"               "grey98"              
#> [361] "grey99"               "grey100"              "honeydew"            
#> [364] "honeydew1"            "honeydew2"            "honeydew3"           
#> [367] "honeydew4"            "hotpink"              "hotpink1"            
#> [370] "hotpink2"             "hotpink3"             "hotpink4"            
#> [373] "indianred"            "indianred1"           "indianred2"          
#> [376] "indianred3"           "indianred4"           "ivory"               
#> [379] "ivory1"               "ivory2"               "ivory3"              
#> [382] "ivory4"               "khaki"                "khaki1"              
#> [385] "khaki2"               "khaki3"               "khaki4"              
#> [388] "lavender"             "lavenderblush"        "lavenderblush1"      
#> [391] "lavenderblush2"       "lavenderblush3"       "lavenderblush4"      
#> [394] "lawngreen"            "lemonchiffon"         "lemonchiffon1"       
#> [397] "lemonchiffon2"        "lemonchiffon3"        "lemonchiffon4"       
#> [400] "lightblue"            "lightblue1"           "lightblue2"          
#> [403] "lightblue3"           "lightblue4"           "lightcoral"          
#> [406] "lightcyan"            "lightcyan1"           "lightcyan2"          
#> [409] "lightcyan3"           "lightcyan4"           "lightgoldenrod"      
#> [412] "lightgoldenrod1"      "lightgoldenrod2"      "lightgoldenrod3"     
#> [415] "lightgoldenrod4"      "lightgoldenrodyellow" "lightgray"           
#> [418] "lightgreen"           "lightgrey"            "lightpink"           
#> [421] "lightpink1"           "lightpink2"           "lightpink3"          
#> [424] "lightpink4"           "lightsalmon"          "lightsalmon1"        
#> [427] "lightsalmon2"         "lightsalmon3"         "lightsalmon4"        
#> [430] "lightseagreen"        "lightskyblue"         "lightskyblue1"       
#> [433] "lightskyblue2"        "lightskyblue3"        "lightskyblue4"       
#> [436] "lightslateblue"       "lightslategray"       "lightslategrey"      
#> [439] "lightsteelblue"       "lightsteelblue1"      "lightsteelblue2"     
#> [442] "lightsteelblue3"      "lightsteelblue4"      "lightyellow"         
#> [445] "lightyellow1"         "lightyellow2"         "lightyellow3"        
#> [448] "lightyellow4"         "limegreen"            "linen"               
#> [451] "magenta"              "magenta1"             "magenta2"            
#> [454] "magenta3"             "magenta4"             "maroon"              
#> [457] "maroon1"              "maroon2"              "maroon3"             
#> [460] "maroon4"              "mediumaquamarine"     "mediumblue"          
#> [463] "mediumorchid"         "mediumorchid1"        "mediumorchid2"       
#> [466] "mediumorchid3"        "mediumorchid4"        "mediumpurple"        
#> [469] "mediumpurple1"        "mediumpurple2"        "mediumpurple3"       
#> [472] "mediumpurple4"        "mediumseagreen"       "mediumslateblue"     
#> [475] "mediumspringgreen"    "mediumturquoise"      "mediumvioletred"     
#> [478] "midnightblue"         "mintcream"            "mistyrose"           
#> [481] "mistyrose1"           "mistyrose2"           "mistyrose3"          
#> [484] "mistyrose4"           "moccasin"             "navajowhite"         
#> [487] "navajowhite1"         "navajowhite2"         "navajowhite3"        
#> [490] "navajowhite4"         "navy"                 "navyblue"            
#> [493] "oldlace"              "olivedrab"            "olivedrab1"          
#> [496] "olivedrab2"           "olivedrab3"           "olivedrab4"          
#> [499] "orange"               "orange1"              "orange2"             
#> [502] "orange3"              "orange4"              "orangered"           
#> [505] "orangered1"           "orangered2"           "orangered3"          
#> [508] "orangered4"           "orchid"               "orchid1"             
#> [511] "orchid2"              "orchid3"              "orchid4"             
#> [514] "palegoldenrod"        "palegreen"            "palegreen1"          
#> [517] "palegreen2"           "palegreen3"           "palegreen4"          
#> [520] "paleturquoise"        "paleturquoise1"       "paleturquoise2"      
#> [523] "paleturquoise3"       "paleturquoise4"       "palevioletred"       
#> [526] "palevioletred1"       "palevioletred2"       "palevioletred3"      
#> [529] "palevioletred4"       "papayawhip"           "peachpuff"           
#> [532] "peachpuff1"           "peachpuff2"           "peachpuff3"          
#> [535] "peachpuff4"           "peru"                 "pink"                
#> [538] "pink1"                "pink2"                "pink3"               
#> [541] "pink4"                "plum"                 "plum1"               
#> [544] "plum2"                "plum3"                "plum4"               
#> [547] "powderblue"           "purple"               "purple1"             
#> [550] "purple2"              "purple3"              "purple4"             
#> [553] "red"                  "red1"                 "red2"                
#> [556] "red3"                 "red4"                 "rosybrown"           
#> [559] "rosybrown1"           "rosybrown2"           "rosybrown3"          
#> [562] "rosybrown4"           "royalblue"            "royalblue1"          
#> [565] "royalblue2"           "royalblue3"           "royalblue4"          
#> [568] "saddlebrown"          "salmon"               "salmon1"             
#> [571] "salmon2"              "salmon3"              "salmon4"             
#> [574] "sandybrown"           "seagreen"             "seagreen1"           
#> [577] "seagreen2"            "seagreen3"            "seagreen4"           
#> [580] "seashell"             "seashell1"            "seashell2"           
#> [583] "seashell3"            "seashell4"            "sienna"              
#> [586] "sienna1"              "sienna2"              "sienna3"             
#> [589] "sienna4"              "skyblue"              "skyblue1"            
#> [592] "skyblue2"             "skyblue3"             "skyblue4"            
#> [595] "slateblue"            "slateblue1"           "slateblue2"          
#> [598] "slateblue3"           "slateblue4"           "slategray"           
#> [601] "slategray1"           "slategray2"           "slategray3"          
#> [604] "slategray4"           "slategrey"            "snow"                
#> [607] "snow1"                "snow2"                "snow3"               
#> [610] "snow4"                "springgreen"          "springgreen1"        
#> [613] "springgreen2"         "springgreen3"         "springgreen4"        
#> [616] "steelblue"            "steelblue1"           "steelblue2"          
#> [619] "steelblue3"           "steelblue4"           "tan"                 
#> [622] "tan1"                 "tan2"                 "tan3"                
#> [625] "tan4"                 "thistle"              "thistle1"            
#> [628] "thistle2"             "thistle3"             "thistle4"            
#> [631] "tomato"               "tomato1"              "tomato2"             
#> [634] "tomato3"              "tomato4"              "turquoise"           
#> [637] "turquoise1"           "turquoise2"           "turquoise3"          
#> [640] "turquoise4"           "violet"               "violetred"           
#> [643] "violetred1"           "violetred2"           "violetred3"          
#> [646] "violetred4"           "wheat"                "wheat1"              
#> [649] "wheat2"               "wheat3"               "wheat4"              
#> [652] "whitesmoke"           "yellow"               "yellow1"             
#> [655] "yellow2"              "yellow3"              "yellow4"             
#> [658] "yellowgreen"
```

Colors are assigned with `dm_set_colors()` using syntax known in the
{tidyverse} as {tidyselect}-syntax, here in the form: `color = table`.
`select_helper` functions are supported. The result of `dm_set_colors()`
is a `dm` object. The information about the color is stored together
with the rest of the metadata.

``` r
flights_dm_w_many_keys_and_colors <-
  flights_dm_w_many_keys %>%
  dm_set_colors(
    maroon4 = flights,
    orange = starts_with("air"),
    "#5986C4" = planes
  )
```

Draw the schema with `dm_draw()`.

``` r
dm_draw(flights_dm_w_many_keys_and_colors)
```

![](/home/kirill/git/R/dm/vignettes/out/tech-dm-draw_files/figure-gfm/unnamed-chunk-5-1.png)<!-- -->

The colors can be queried with `dm_get_colors()`.

``` r
dm_get_colors(flights_dm_w_many_keys_and_colors)
#>  #FFA500FF  #FFA500FF  #8B1C62FF  #5986C4FF    default 
#> "airlines" "airports"  "flights"   "planes"  "weather"
```

See the documentation for `dm_draw()` for further options. One important
argument is `view_type`. Besides the default `"keys_only"`, it accepts
`"all"` to display all columns, and `"title_only"` to show only the
title of the table.

``` r
flights_dm_w_many_keys_and_colors %>%
  dm_draw(view_type = "title_only")
```

![](/home/kirill/git/R/dm/vignettes/out/tech-dm-draw_files/figure-gfm/unnamed-chunk-7-1.png)<!-- -->

If you would like to visualize only a some of the tables, use
`dm_select_tbl()` before drawing:

``` r
flights_dm_w_many_keys_and_colors %>%
  dm_select_tbl(flights, airports, planes) %>%
  dm_draw()
```

![](/home/kirill/git/R/dm/vignettes/out/tech-dm-draw_files/figure-gfm/unnamed-chunk-8-1.png)<!-- -->

Finally, for exporting a drawing to `svg` you could use
`DiagrammeRsvg::export_svg()`:

``` r
flights_dm_w_many_keys_and_colors %>% 
  dm_select_tbl(flights, airports, planes) %>% 
  dm_draw() %>% 
  DiagrammeRsvg::export_svg() %>% 
  write("flights_dm_w_many_keys_and_color.svg")
```

[1] The code for the functions in this section is borrowed from the
[{datamodelr}](https://github.com/bergant/datamodelr) package.
